<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			
		    <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
							    <button class="btn btn-primary datos-horario mx-1" data-bs-toggle="modal" data-bs-target="#informacionHorario" data-form='#formInformacionHorario' data-id="0" data-accion="crear" id="crear-horario">
								    <i class="mdi mdi-plus-circle"></i> Añadir
							    </button>
							</div>
                        </div>
                        <div class="card-body">
                        	<table id="tblListarHorarios" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
                                                        
                        	</table>
                        </div>
                    </div>
                                    		<!-- end col -->
                </div>
                                    	<!-- end col -->
                <div></div>
            </div>
        </div>
		
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>

<!-- Modal para editar horario -->
<!--<div class="modal fade" id="modalEditarHorario" tabindex="-1" aria-labelledby="modalEditarHorarioLabel" aria-hidden="true">-->
<!--    <div class="modal-dialog modal-dialog-centered">-->
<!--        <div class="modal-content">-->
<!--            <div class="modal-header">-->
<!--                <h5 class="modal-title" id="modalEditarHorarioLabel">Editar Horario</h5>-->
<!--                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>-->
<!--            </div>-->
<!--            <div class="modal-body">-->
<!--                <form>-->
<!--                    <span class="respuesta"></span>-->
<!--                    <div class="mb-3">-->
<!--                        <label for="editarCodigo" class="form-label">Código</label>-->
<!--                        <input type="text" class="form-control" id="editarCodigo">-->
<!--                    </div>-->
<!--                    <div class="mb-3">-->
<!--                        <label for="editarHorario" class="form-label">Horario</label>-->
<!--                        <input type="text" class="form-control" id="editarHorario">-->
<!--                    </div>-->
<!--                    <div class="mb-3">-->
<!--                        <label for="editarEstado" class="form-label">Estado</label>-->
<!--                        <select class="form-select" id="editarEstado">-->
<!--                            <option value="Activo">Activo</option>-->
<!--                            <option value="Inactivo">Inactivo</option>-->
<!--                        </select>-->
                        <!--<input type="text" class="form-control" id="editarEstado">-->
<!--                    </div>-->
<!--                    <div class="mb-3">-->
<!--                        <label for="editarHoraInicio" class="form-label">Hora Inicio</label>-->
<!--                        <input type="time" class="form-control flatpickr-input" id="editarHoraInicio">-->
<!--                    </div>-->
<!--                    <div class="mb-3">-->
<!--                        <label for="editarHoraFin" class="form-label">Hora Fin</label>-->
<!--                        <input type="time" class="form-control flatpickr-input" id="editarHoraFin">-->
<!--                    </div>-->
<!--                </form>-->
<!--            </div>-->
<!--            <div class="modal-footer">-->
<!--                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>-->
<!--                <button type="button" class="btn btn-primary" id="guardarCambiosHorario">Guardar Cambios</button>-->
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->
<!--</div>-->

<!-- Modal para ver detalles del horario -->
<!--<div class="modal fade" id="modalDetallesHorario" tabindex="-1" aria-labelledby="modalDetallesHorarioLabel" aria-hidden="true">-->
<!--    <div class="modal-dialog modal-dialog-centered">-->
<!--        <div class="modal-content">-->
<!--            <div class="modal-header p-3 bg-info-subtle">-->
<!--                <h5 class="modal-title" id="modalDetallesHorarioLabel">Detalles del Horario</h5>-->
<!--                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>-->
<!--            </div>-->
            
<!--            <div class="modal-body">-->
                <!-- Aquí se llenarán los detalles con JavaScript -->
<!--                <div class="d-flex align-items-center mb-2">-->
<!--                    <div class="flex-shrink-0 me-3">-->
<!--                       <i class="ri-time-line text-muted fs-16"></i>-->
<!--                    </div>-->
<!--                    <div class="flex-grow-1">-->
<!--                       <h6 class="d-block fw-semibold mb-0"><span id="verHoraInicio"></span> - <span id="verHoraFin"></span></h6>-->
<!--                    </div>-->
<!--                </div>-->
<!--                <div class="d-flex align-items-center mb-2">-->
<!--                    <div class="flex-shrink-0 me-3">-->
<!--                       <i class="ri-bookmark-line text-muted fs-16"></i>-->
<!--                    </div>-->
<!--                    <div class="flex-grow-1">-->
<!--                       <h6 class="d-block fw-semibold mb-0"> <span id="verCodigo"></span></h6>-->
<!--                    </div>-->
<!--                </div>-->
<!--                <div class="d-flex mb-3">-->
<!--                    <div class="flex-shrink-0 me-3">-->
<!--                       <i class="ri-shield-user-line text-muted fs-16"></i>-->
<!--                    </div>-->
<!--                    <div class="flex-grow-1">-->
<!--                       <p class="d-block text-muted mb-0" id="verHorario"></p>-->
<!--                    </div>-->
<!--                 </div>-->
<!--            </div>-->
<!--            <div class="modal-footer">-->
<!--                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>-->
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->
<!--</div>-->

<!-- Modal Información Requerimiento -->
<!--<div class="modal fade" id="crearHorario" tabindex="-1" role="dialog" aria-labelledby="examplecrearHorario" aria-hidden="true">-->
<!--	<div class="modal-dialog modal-dialog-centered" role="document">-->
<!--		<div class="modal-content">-->
<!--			<div class="modal-header">-->
<!--				<h5 class="modal-title" id="examplecrearHorario">Creación de Horario</h5>-->
<!--				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>-->
<!--			</div>-->
<!--			<form id="formcrearHorario" class="formulario" autocomplete="off" action="" method="POST">-->
<!--				<span class="respuesta"></span>-->
<!--				<div class="modal-body">-->
<!--					<input type="hidden" id="txtIDGrupoTrabajo_i" name="txtIDGrupoTrabajo_i">-->
<!--					<div class="row">-->
<!--						<div class="col-xxl-12 col-md-12 col-12 mb-3">-->
<!--							<label for="txtHorario_i" class="form-label">Horario</label>-->
<!--							<div class="input-group">-->
<!--								<input type="text" class="form-control" aria-label="horario" id="txtHorario_i" name="txtHorario_i">-->
<!--							</div>-->
<!--						</div>-->
<!--						<div class="col-xxl-12 col-md-12 col-12 mb-3">-->
<!--							<label for="txtCodigo_i" class="form-label">Codigo</label>-->
<!--							<div class="input-group">-->
<!--								<input type="text" class="form-control" aria-label="Codigo" id="txtCodigo_i" name="txtCodigo_i">-->
<!--							</div>-->
<!--						</div>-->
<!--                        <div class="col-xxl-12 col-md-12 col-12 mb-3">-->
<!--							<label for="txtHoraInicio_i" class="form-label">Hora Inicio</label>-->
<!--							<div class="input-group">-->
<!--								<input type="time" class="form-control flatpickr-input" aria-label="Hora Inicio" id="txtHoraInicio_i" name="txtHoraInicio_i">-->
<!--							</div>-->
<!--						</div>-->
<!--						<div class="col-xxl-12 col-md-12 col-12 mb-3">-->
<!--							<label for="txtHoraFin_i" class="form-label">Hora Fin</label>-->
<!--							<div class="input-group">-->
<!--								<input type="time" class="form-control flatpickr-input" aria-label="Hora Fin" id="txtHoraFin_i" name="txtHoraFin_i">-->
<!--							</div>-->
<!--						</div>-->
<!--					</div>-->
<!--				</div>-->
<!--				<div class="modal-footer">-->
<!--					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>-->
<!--					<button type="submit" id="btnEjecutarGrupoTrabajo" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>-->
<!--				</div>-->
<!--			</form>-->
<!--		</div>-->
<!--	</div>-->
<!--</div>-->

<!-- Modal Información Horario -->
<div class="modal fade zoomIn" id="informacionHorario" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionHorario" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionHorario">Información de Horario</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionHorario" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDHorario_i" name="txtIDHorario_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtCodigoHorario_i" class="form-label">Código</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Código" id="txtCodigoHorario_i" name="txtCodigoHorario_i">
							</div>
						</div>
					    <div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtHorario_i" class="form-label">Horario</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Horario" id="txtHorario_i" name="txtHorario_i">
							</div>
						</div>
					    <div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtInicioHorario_i" class="form-label">Hora de Inicio</label>
							<div class="input-group">
								<input type="time" class="form-control" aria-label="Hora de Inicio" id="txtInicioHorario_i" name="txtInicioHorario_i">
							</div>
						</div>
					    <div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtFinHorario_i" class="form-label">Hora de Fin</label>
							<div class="input-group">
								<input type="time" class="form-control" aria-label="Hora de Fin" id="txtFinHorario_i" name="txtFinHorario_i">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
					<button type="submit" id="btnEjecutarHorario" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-content-save me-2 color-white" style="font-size: 14px;"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?= $this->section('js'); ?>
<script>
    // let dt3 = null;
    
    // $("#editarEstado").select2({
    //     minimumResultsForSearch: -1
    // });
    // $(".flatpickr-input").flatpickr(    
    //     {
    //         enableTime: true,
    //         noCalendar: true,
    //         dateFormat: "H:i",
    //         time_24hr: true
    //     }
    // );
    
    $(function () {
        
        /*** SERVERSIDE HORARIOS ***/
        assetListVM2 = {
            init: function () {
                // Si ya existe un DataTable inicializado, destrúyelo primero
                if ($.fn.DataTable.isDataTable('#tblListarHorarios')) {
                    $('#tblListarHorarios').DataTable().destroy();
                }
    
                // Inicializa el DataTable nuevamente
                dt3 = $('#tblListarHorarios').DataTable({
                    "serverSide": true,
                    "processing": true,
                    "ajax": {
                        "url": baseUrl + "/listar-horario-datatable",
                        "type": 'GET'
                    },
                    "columns": [
                        {"title": "ID Horario", "data": "id_horario", "class": "text-center", "searchable": true },
                        {"title": "Horario", "data": "horario", "class": "text-center", "searchable": true },
                        {"title": "Código", "data": "codigo", "class": "text-center", "searchable": true },
                        {"title": "Usuario Registra", "data": "nombresCompletos", "class": "text-center", "searchable": true },
                        {"title": "Fecha Registra", "data": "FechaRegistra", "class": "text-center", "searchable": true },
                        {"title": "Estado", "data": "EstadoHorario", "class": "text-center", "searchable": true },
                        {"title": "Acciones", "data": "Acciones", "class": "text-center", "searchable": true}
                    ],
                    "lengthMenu": [[5, 10, 25, 50], [5, 10, 25, 50]],
                    responsive: true,
                    autoWidth: false,
                    'pageLength': 5,
                    "aaSorting": [[0, 'desc']],
                    "rowCallback": function (row, data) {
                        $(row).addClass('form-check-all');
                    }
                });
    
                // Manejar el evento del botón de eliminar
                $('#tblListarHorarios').on('click', '.eliminar-horario', function () {
                    var idHorario = $(this).data('id');
                    eliminarHorario(idHorario);
                });
    
                // Manejar el evento del botón de ver detalles
                $('#tblListarHorarios').on('click', '.ver-detalles', function () {
                    var idHorario = $(this).data('id');
                    mostrarDetallesHorario(idHorario);
                });
    
                // Manejar el evento del botón de editar
                $('#tblListarHorarios').on('click', '.editar-horario', function () {
                    var idHorario = $(this).data('id'); console.log(idHorario);
                    editarHorario(idHorario);
                });
            }
        };
    
        assetListVM2.init();
        
        $(document).on('click', '.datos-horario', function(e) {
            $('#btnEjecutarHorario').addClass("d-none");
            
            var idHorario = $(this).data('id');
            var accion = $(this).data('accion');
            var formulario = $(this).data('form');
            var modal = $(this).data('bs-target');
            
            $(formulario + ' input[type=text]').attr("disabled","disabled");
            $(formulario + ' input[type=time]').attr("disabled","disabled");
            
            $(formulario + ' input[type=text]').val("");
            $(formulario + ' input[type=time]').val("");
            
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
            
            if(accion == 'crear')
            {
                $('#exampleinformacionHorario').text("Crear Horario");
                $(formulario).attr('action', baseUrl + '/registrar-horario');
                $('#btnEjecutarHorario').removeClass("d-none");
                $('#btnEjecutarHorario').html('<i class="mdi mdi-content-save me-2 color-white" style="font-size: 14px;"></i>Guardar');
                
                $(formulario + ' input[type=text]').removeAttr("disabled");
                $(formulario + ' input[type=time]').removeAttr("disabled");
            
                Swal.close();
            }
            else
            {
                $.post(baseUrl + '/obtener-detalles-horario', 
                {         
                    id_horario : idHorario
                }, 
                function(response) 
                {
                    Swal.close();
                    
                    if (response.descripcion === 0) 
                    {
                        Swal.fire({
                            title: 'No se encontró la información solicitada',
                            icon: 'warning',
                            showCancelButton: false,
                            confirmButtonColor: '#282E38',
                            confirmButtonText: 'Confirmar'
                        });
                    } 
                    else 
                    {
                        if(accion == 'ver')
                        {
                            $('#exampleinformacionHorario').text("Información de Horario");
                            $('#btnEjecutarHorario').addClass("d-none");
                            $(formulario).attr('action', '');
        
                            $(formulario + ' input[type=text]').attr("disabled","disabled");
                            $(formulario + ' input[type=time]').attr("disabled","disabled");
                        }
                        else
                        {
                            $('#exampleinformacionHorario').text("Actualizar Horario");
                            $('#formInformacionHorario').attr('action', baseUrl + '/actualizar-horario/' + idHorario);
                            $('#btnEjecutarHorario').removeClass("d-none");
                            $('#btnEjecutarHorario').html('<i class="mdi mdi-content-save me-2 color-white" style="font-size: 14px;"></i>Actualizar');
                        
                            $(formulario + ' input[type=text]').removeAttr("disabled");
                            $(formulario + ' input[type=time]').removeAttr("disabled");
                        }
        
                        $('#txtCodigoHorario_i').val(response.codigo);
                        $('#txtHorario_i').val(response.horario);
                        $('#txtInicioHorario_i').val(response.HoraInicio);
                        $('#txtFinHorario_i').val(response.HoraFin);
                    }
                }, 'json'); 
            }
            
            $(modal).modal("show");
        });
    
        $(document).on('click', '.cambiar-estado-horario', function() {
            var idHorario = $(this).data("id");
            var estado = $(this).data("estado");
            
            if(estado == "A")
            {
                var msgEstado = 'DESACTIVAR';
                var estado = 'I';
            }
            else
            {
                var msgEstado = 'ACTIVAR';
                var estado = 'A';
            }
        
            Swal.fire({
                title: '¿Estas seguro que deseas '+msgEstado+' el horario?',
                //text: "Recuerda que esta acción es permanente.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#282e38',
                cancelButtonColor: '#f35d5d',
                confirmButtonText: 'Confirmar',
                input: 'textarea',
                inputAttributes: {
                    autocapitalize: 'on'
                },
                inputValidator: obs => {
                    // Si el valor es válido, debes regresar undefined. Si no, una cadena
                    if (!obs) {
                        return "Por favor escribe el motivo";
                    } else {
                        return undefined;
                    }
                }
            }).then((result) => {
                if (result.isConfirmed) {
        
                    var motivo = result.value;
                    var parametros = {
                        "idHorario" : idHorario,
                        "estado" : estado,
                        "motivo" : motivo
            		};
                    $.ajax({        
                        // url: baseUrl + '/cambiar-estado-horario',
                        url: baseUrl + '/eliminar-horario',
                        type: "POST",
                        data: parametros,
                        success: function(response) {
                            $('.respuesta_global').html(response);
                        }, 
                        error: function(jqXHR, textStatus, errorThrown){
                            Swal.fire({
                                title: 'Ha ocurrido un error interno',
                                text: errorThrown,
                                icon: 'error',
                                showCancelButton: false,
                                confirmButtonColor: '#E4002B',
                                confirmButtonText: 'Confirmar'
                            });
                        }
                    });
                }
            });
        
            return false;
        });
        
    });
    
    // function editarHorario(idHorario) {
    //     // Llamar al backend para obtener los detalles del horario
    //     $.ajax({
    //         url: baseUrl + '/obtener-detalles-horario',
    //         type: 'GET',
    //         data: { id_horario: idHorario },
    //         success: function(response) { 
            
    //             if (response.descripcion === 0) {
    //                 //alert("Ocurrió un error al obtener los datos.");
    //             } else {
    //                 var data = $.parseJSON(response); console.log(data);
    //                 // Llenar el formulario con los datos obtenidos
         
    //                 $('#editarCodigo').val(data.codigo);
    //                 $('#editarHorario').val(data.horario);
    //                 $('#editarEstado').val(data.Estado).trigger("change"); 
    //                 $('#editarHoraInicio').val(data.HoraInicio);
    //                 // $('#editarHoraInicio').attr("data-default-time",data.HoraInicio);
    //                 $('#editarHoraFin').val(data.HoraFin);
        
    //                 // Mostrar el modal de edición
    //                 $('#modalEditarHorario').modal('show');
        
    //                 // Configurar el botón de guardar cambios
    //                 $('#guardarCambiosHorario').off('click').on('click', function() {
    //                     guardarCambiosHorario(idHorario);
    //                 });
    //             }
    //         },
    //         error: function() {
    //             alert("Ocurrió un error al obtener los detalles del horario.");
    //         }
    //     });
    // }
    
    // function guardarCambiosHorario(idHorario) {
    //     // Obtener los datos del formulario
    //     const datosActualizados = {
    //         id_horario: idHorario,
    //         codigo: $('#editarCodigo').val(),
    //         horario: $('#editarHorario').val(),
    //         Estado: $('#editarEstado').val(),
    //         HoraInicio: $('#editarHoraInicio').val(),
    //         HoraFin: $('#editarHoraFin').val()
    //     };
    
    //     // Enviar la actualización al backend
    //     $.ajax({
    //         url: baseUrl + '/actualizar-horario',
    //         type: 'POST',
    //         data: datosActualizados,
    //         success: function(response) {
    //             $('.respuesta').html(response);
    //             // alert("Horario actualizado exitosamente.");
    //             // $('#modalEditarHorario').modal('hide');
    //             // dt2.ajax.reload(); // Recargar la tabla después de actualizar
    //         },
    //         error: function() {
    //             alert("Ocurrió un error al actualizar el horario.");
    //         }
    //     });
    // }

    
    // function eliminarHorario(idHorario) {
    //     if (confirm("¿Estás seguro de que deseas eliminar este horario?")) {
    //         $.ajax({
    //             url: baseUrl + '/eliminar-horario', // Asegúrate de que esta URL apunte al controlador correcto
    //             type: 'POST',
    //             data: { id_horario: idHorario },
    //             success: function(response) {
    //                 alert("Horario eliminado exitosamente.");
    //                 dt2.ajax.reload(); // Recargar la tabla después de eliminar
    //             },
    //             error: function(error) {
    //                 alert("Ocurrió un error al eliminar el horario.");
    //             }
    //         });
    //     }
    // }
    
    // function mostrarDetallesHorario(idHorario) {
    //     // Aquí puedes implementar el código para mostrar el modal con los detalles del horario
    //     // Ejemplo:
    //     $.ajax({
    //         url: baseUrl + '/obtener-detalles-horario', // Asegúrate de que esta URL apunte al controlador correcto
    //         type: 'GET',
    //         data: { id_horario: idHorario },
    //         success: function(response) {
    //             var data = $.parseJSON(response); console.log(data);
    //             $("#verHorario").text(data.horario);
    //             $("#verCodigo").text(data.codigo);
    //             $("#verHoraInicio").text(data.HoraInicio);
    //             $("#verHoraFin").text(data.HoraFin);
    //             // Suponiendo que el 'response' tiene los detalles del horario
    //             // $('#modalDetallesHorario .modal-body').html(`
    //             //     <p><strong>Código:</strong> ${data.codigo}</p>
    //             //     <p><strong>Horario:</strong> ${data.horario}</p>
    //             //     <p><strong>Estado:</strong> ${data.Estado}</p>
    //             //     <p><strong>Hora Inicio:</strong> ${data.HoraInicio}</p>
    //             //     <p><strong>Hora Fin:</strong> ${data.HoraFin}</p>
    //             // `);
    //             $('#modalDetallesHorario').modal('show');
    //         },
    //         error: function(error) {
    //             alert("Ocurrió un error al obtener los detalles del horario.");
    //         }
    //     });
    // }

    
</script>


<script>
//     // Ejecutar el script cuando el DOM esté completamente cargado
//     $(document).ready(function() {
//         let idGrupoTrabajoSeleccionado = null; // Almacena el ID del grupo de trabajo seleccionado
//         // Manejar el clic en los botones "Seleccionar Grupo de Trabajo"
//         $('.grupo-trabajo').on('click', function (e) {
//             e.preventDefault();
        
//             // Obtener el ID del grupo de trabajo seleccionado
//             const idGrupoTrabajo = $(this).data('grupotrabajo'); 
        
//             // Si ya está seleccionado el mismo grupo, no recargar la tabla
//             if (idGrupoTrabajoSeleccionado === idGrupoTrabajo) {
//                 return; // No hace nada si es el mismo grupo
//             }
        
//             // Asigna el nuevo grupo de trabajo
//             idGrupoTrabajoSeleccionado = idGrupoTrabajo;

//             // Recargar el DataTable con la nueva información del grupo de trabajo
//             // dt2.ajax.reload(null, false); // Recarga la tabla sin reiniciar la paginación
//             recargarDataTableHorarios(idGrupoTrabajoSeleccionado);
//         });
//     // recargarDataTableHorarios();
//     });
</script>
<?php $this->endSection(); ?>

<?php $this->endSection(); ?>