<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between mb-1">crea
						<h4 class="mb-sm-0"><?= $breadcrumb ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
        
			<div class="row">
				<div class="col-lg-12">

                    <div class="card mb-1">
                        <div class="card-header d-flex align-items-center">
                            <h4 class="card-title mb-0 flex-grow-1">Gráficas | Indicadores</h4>
                        </div>
                        <div class="card-body">
                            <!--<h4 class="card-title">Gráficas | Indicadores</h4>-->
                            <div class="row">
                                <!-- Gráfica de Porcentaje Over -->
                                <div class="col-lg-4 col-md-4 col-sm-12 mb-3">
                                    <h5 class="text-center">Porcentaje Over</h5>
                                    <div id="graficoPagoOver" class="apex-charts"></div>
                                </div>
                                <!-- Gráfica de Pago Above -->
                                <div class="col-lg-4 col-md-4 col-sm-12 mb-3">
                                    <h5 class="text-center">Pago Above</h5>
                                    <div id="graficoPagoOverBar" class="apex-charts"></div>
                                </div>
                                <!-- Gráfica de Kpi Noche -->
                                <div class="col-lg-4 col-md-4 col-sm-12 mb-3">
                                    <h5 class="text-center">Kpi Noche</h5>
                                    <div id="graficoPagoOverPie" class="apex-charts"></div>
                                </div>
                            </div>
                        </div>
                    </div>

					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div class="d-flex">
								<?php
								if(in_array("VERPLA", $permisos))
								{
								?>
                                <!--<button class="btn btn-info mx-1 d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#importarCSVUsuarioFlota">-->
								<!--	<i class='mdi mdi-routes-clock align-bottom me-2 text-muted' style='font-size: 18px;'></i> Ver Planificación-->
								<!--</button>-->
								<a href='#' class='btn btn-info mx-1 d-flex align-items-center ver-planificacion d-none' data-idplanificacion=''>
                                    <i class="mdi mdi-plus-circle mr-1" style="font-size: 18px;"></i> Ver Planificacion
                                </a>
								<?php
								}
								
								if(in_array("GRUPUS", $permisos))
								{
								?>
                                <button class="btn btn-danger mx-1 d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#importarCSVUsuarioDesempeno">
									<i class="mdi mdi-plus-circle mr-1" style="font-size: 18px;"></i> Importar Desempeño
								</button>
								<?php
								}
								
								if(in_array("HORAPL", $permisos))
								{
								?>
                                <button class="btn btn-success mx-1 d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#importarPlanificacion">
									<i class="mdi mdi-plus-circle mr-1" style="font-size: 18px;"></i> Importar Planificación
								</button>
								<?php
								}
								
								if (in_array("TESTEO", $permisos)) 
								{
								?>
                                <button class="btn btn-primary mx-1 d-flex align-items-center datos-planificacion" data-bs-toggle="modal" data-bs-target="#informacionPlanificacion" data-id="0" data-accion="crear" id="crear-usuario">
									<i class="mdi mdi-plus-circle mr-1" style="font-size: 18px;"></i> Crear Planificación 
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
                            <!-- Botones de filtro -->
                            <div class="btn-group mb-2">
                                <!--<button class="btn d-none" data-filter="todos">Todos</button>-->
                                <button class="btn btn-outline-danger btn-sm active" data-filter="cumplimiento_procesos">Cumplimiento de Procesos</button>
                                <button class="btn btn-outline-danger btn-sm" data-filter="atencion_cliente">Atención al Cliente</button>
                                <button class="btn btn-outline-danger btn-sm" data-filter="tmo">TMO</button>
                                <button class="btn btn-outline-danger btn-sm" data-filter="productividad">Productividad</button>
                                <button class="btn btn-outline-danger btn-sm" data-filter="wp">WP</button>
                            </div>
                        
                            <!-- Tabla de indicadores -->
                            <table id="controlIndicadoresDataTable" class="table table-striped table-hover table-sm" data-responsive="true" style="width: 100%;"></table>
                        
						</div>
					</div>
					
				</div>
			</div>
			
		</div>
		
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<?= $this->section('js'); ?>
<script>

$(function () {
    let categoriaSeleccionada = "cumplimiento_procesos";

    const dt = $('#controlIndicadoresDataTable').DataTable({
        serverSide: true,
        processing: true,
        ajax: {
            url: baseUrl + "/indicadores-data-table",
            type: "GET",
            data: function (d) {
                d.categoria = categoriaSeleccionada; // Pasar la categoría seleccionada al servidor
            }
        },
        columns: [
            { title: "Categoría", data: "nombre_categoria", class: "text-center" },
            {   title: "Bono 90", 
                data: null, 
                class: "text-center",
                render: function (data, type, row) {
                    if (categoriaSeleccionada === "cumplimiento_procesos") { id = row.id_kpi_cumplimiento_procesos;}
                    if (categoriaSeleccionada === "atencion_cliente") { id = row.id_kpi_atencion_cliente;}
                    if (categoriaSeleccionada === "tmo") { id = row.id_kpi_tmo;}
                    if (categoriaSeleccionada === "productividad") { id = row.id_kpi_productividad;}
                    if (categoriaSeleccionada === "wp") { id = row.id_kpi_wp;}
                    return `<input type="number" class="form-control bono-90 text-center" data-id="${id}" value="${row.bono_90}">`;
                }
            },
            {   title: "Bono 100", 
                data: null, 
                class: "text-center", 
                render: function (data, type, row) {
                    if (categoriaSeleccionada === "cumplimiento_procesos") { id = row.id_kpi_cumplimiento_procesos;}
                    if (categoriaSeleccionada === "atencion_cliente") { id = row.id_kpi_atencion_cliente;}
                    if (categoriaSeleccionada === "tmo") { id = row.id_kpi_tmo;}
                    if (categoriaSeleccionada === "productividad") { id = row.id_kpi_productividad;}
                    if (categoriaSeleccionada === "wp") { id = row.id_kpi_wp;}
                    return `<input type="number" class="form-control bono-100 text-center" data-id="${id}" value="${row.bono_100}">`;
                }
            },
            {
                title: "KPI Día",
                data: null,
                class: "text-center",
                render: function (data, type, row) {
                    if (categoriaSeleccionada === "cumplimiento_procesos") {valor = row.kpi_dia_cumplimiento_procesos; id = row.id_kpi_cumplimiento_procesos;}
                    if (categoriaSeleccionada === "atencion_cliente") {valor = row.kpi_dia_atencion_cliente; id = row.id_kpi_atencion_cliente;}
                    if (categoriaSeleccionada === "tmo") {valor = row.kpi_dia_tmo; id = row.id_kpi_tmo;}
                    if (categoriaSeleccionada === "productividad") {valor = row.kpi_dia_productividad; id = row.id_kpi_productividad;}
                    if (categoriaSeleccionada === "wp") {valor = row.kpi_dia_wp; id = row.id_kpi_wp;}
                    return `<input type="number" class="form-control kpi-dia text-center" data-id="${id}" value="${valor}">`;
                }
            },
            {
                title: "KPI Noche",
                data: null,
                class: "text-center",
                render: function (data, type, row) {
                    if (categoriaSeleccionada === "cumplimiento_procesos") {valor = row.kpi_noche_cumplimiento_procesos; id = row.id_kpi_cumplimiento_procesos;}
                    if (categoriaSeleccionada === "atencion_cliente") {valor = row.kpi_noche_atencion_cliente; id = row.id_kpi_atencion_cliente;}
                    if (categoriaSeleccionada === "tmo") {valor = row.kpi_noche_tmo; id = row.id_kpi_tmo;} 
                    if (categoriaSeleccionada === "productividad") {valor = row.kpi_noche_productividad; id = row.id_kpi_productividad;}
                    if (categoriaSeleccionada === "wp") {valor = row.kpi_noche_wp; id = row.id_kpi_wp;}
                    return `<input type="number" class="form-control kpi-noche text-center" data-id="${id}" value="${valor}">`;
                }
            },
            {
                title: "Porcentaje above",
                data: null,
                class: "text-center",
                render: function (data, type, row) {
                    if (categoriaSeleccionada === "cumplimiento_procesos") {valor = row.kpi_porcentaje_above_cumplimiento_procesos; id = row.id_kpi_cumplimiento_procesos;}
                    if (categoriaSeleccionada === "atencion_cliente") {valor = row.kpi_porcentaje_above_atencion_cliente; id = row.id_kpi_atencion_cliente;}
                    if (categoriaSeleccionada === "tmo") {valor = row.kpi_porcentaje_above_tmo; id = row.id_kpi_tmo;} 
                    if (categoriaSeleccionada === "productividad") {valor = row.kpi_porcentaje_above_productividad; id = row.id_kpi_productividad;}
                    if (categoriaSeleccionada === "wp") {valor = row.kpi_porcentaje_above_wp; id = row.id_kpi_wp;}
                    return `<input type="number" class="form-control porcentaje-above text-center" data-id="${id}" value="${valor}">`;
                }
            },
            {
                title: "Porcentaje over",
                data: null,
                class: "text-center",
                render: function (data, type, row) {
                    if (categoriaSeleccionada === "cumplimiento_procesos") {valor = row.kpi_porcentaje_over_cumplimiento_procesos; id = row.id_kpi_cumplimiento_procesos;}
                    if (categoriaSeleccionada === "atencion_cliente") {valor = row.kpi_porcentaje_over_atencion_cliente; id = row.id_kpi_atencion_cliente;}
                    if (categoriaSeleccionada === "tmo") {valor = row.kpi_porcentaje_over_tmo; id = row.id_kpi_tmo;} 
                    if (categoriaSeleccionada === "productividad") {valor = row.kpi_porcentaje_over_productividad; id = row.id_kpi_productividad;}
                    if (categoriaSeleccionada === "wp") {valor = row.kpi_porcentaje_over_wp; id = row.id_kpi_wp;}
                    return `<input type="number" class="form-control porcentaje-over text-center" data-id="${id}" value="${valor}">`;
                }
            },
            {
                title: "Peso",
                data: null,
                class: "text-center",
                render: function (data, type, row) {
                    if (categoriaSeleccionada === "cumplimiento_procesos") {valor = row.kpi_peso_cumplimiento_procesos; id = row.id_kpi_cumplimiento_procesos;}
                    if (categoriaSeleccionada === "atencion_cliente") {valor = row.kpi_peso_atencion_cliente; id = row.id_kpi_atencion_cliente;}
                    if (categoriaSeleccionada === "tmo") {valor = row.kpi_peso_tmo; id = row.id_kpi_tmo;} 
                    if (categoriaSeleccionada === "productividad") {valor = row.kpi_peso_productividad; id = row.id_kpi_productividad;}
                    if (categoriaSeleccionada === "wp") {valor = row.kpi_peso_wp; id = row.id_kpi_wp;}
                    return `<input type="number" class="form-control peso text-center" data-id="${id}" value="${valor}">`;
                }
            },
            {
                title: "Pago Above",
                data: null,
                class: "text-center",
                render: function (data, type, row) {
                    if (categoriaSeleccionada === "cumplimiento_procesos") {valor = row.pago_above_cumplimiento_procesos; id = row.id_kpi_cumplimiento_procesos;}
                    if (categoriaSeleccionada === "atencion_cliente") {valor = row.pago_above_atencion_cliente; id = row.id_kpi_atencion_cliente;}
                    if (categoriaSeleccionada === "tmo") {valor = row.pago_above_tmo; id = row.id_kpi_tmo;}
                    if (categoriaSeleccionada === "productividad") {valor = row.pago_above_productividad; id = row.id_kpi_productividad;}
                    if (categoriaSeleccionada === "wp") {valor = row.pago_above_wp; id = row.id_kpi_wp;}
                    return `<input type="number" class="form-control pago-above text-center" data-id="${id}" value="${valor}">`;
                }
            },
            {
                title: "Pago Target",
                data: null,
                class: "text-center",
                render: function (data, type, row) {
                    if (categoriaSeleccionada === "cumplimiento_procesos") {valor = row.pago_target_cumplimiento_procesos; id = row.id_kpi_cumplimiento_procesos;}
                    if (categoriaSeleccionada === "atencion_cliente") {valor = row.pago_target_atencion_cliente; id = row.id_kpi_atencion_cliente;}
                    if (categoriaSeleccionada === "tmo") {valor = row.pago_target_tmo; id = row.id_kpi_tmo;}
                    if (categoriaSeleccionada === "productividad") {valor = row.pago_target_productividad; id = row.id_kpi_productividad;}
                    if (categoriaSeleccionada === "wp") {valor = row.pago_target_wp; id = row.id_kpi_wp;}
                    return `<input type="number" class="form-control pago-target text-center" data-id="${id}" value="${valor}">`;
                }
            },
            {
                title: "Pago Over",
                data: null,
                class: "text-center",
                render: function (data, type, row) {
                    if (categoriaSeleccionada === "cumplimiento_procesos") {valor = row.pago_over_cumplimiento_procesos; id = row.id_kpi_cumplimiento_procesos;}
                    if (categoriaSeleccionada === "atencion_cliente") {valor = row.pago_over_atencion_cliente; id = row.id_kpi_atencion_cliente;}
                    if (categoriaSeleccionada === "tmo") {valor = row.pago_over_tmo; id = row.id_kpi_tmo;}
                    if (categoriaSeleccionada === "productividad") {valor = row.pago_over_productividad; id = row.id_kpi_productividad;}
                    if (categoriaSeleccionada === "wp") {valor = row.pago_over_wp; id = row.id_kpi_wp;}
                    return `<input type="number" class="form-control pago-over text-center" data-id="${id}" value="${valor}">`;
                }
            },
            {
                title: "Acciones",
                data: null,
                class: "text-center",
                render: function (data, type, row) {
                    if (categoriaSeleccionada === "cumplimiento_procesos") { id = row.id_kpi_cumplimiento_procesos;}
                    if (categoriaSeleccionada === "atencion_cliente") { id = row.id_kpi_atencion_cliente;}
                    if (categoriaSeleccionada === "tmo") { id = row.id_kpi_tmo;}
                    if (categoriaSeleccionada === "productividad") { id = row.id_kpi_productividad;}
                    if (categoriaSeleccionada === "wp") { id = row.id_kpi_wp;}
                    
                    return `<button class="btn btn-success guardar-cambios" data-id="${id}">Update</button>`;
                }
            }
        ],
        language: {
            url: "//cdn.datatables.net/plug-ins/1.13.4/i18n/es-ES.json"
        },
        drawCallback: function () {
            // Extraer datos y actualizar gráfica después de cargar la tabla
            actualizarGrafico();
        }
    });

    $('.btn-group .btn').on('click', function () {
        $('.btn-group .btn').removeClass('active');
        $(this).addClass('active');
        categoriaSeleccionada = $(this).data('filter');
        dt.ajax.reload();
    });
    
/**********************/

    // Función para generar/actualizar la gráfica
    function actualizarGrafico() {
        // Obtener los datos directamente desde el DataTable
        const data = dt.rows().data().toArray();

        // Filtrar los nombres de las categorías y los valores de "Porcentaje Over"
        const categoriasGrafico = data.map(row => row.nombre_categoria);
        const valoresGrafico = data.map(row => {
            if (categoriaSeleccionada === "cumplimiento_procesos") return parseFloat(row.kpi_porcentaje_over_cumplimiento_procesos || 0);
            if (categoriaSeleccionada === "atencion_cliente") return parseFloat(row.kpi_porcentaje_over_atencion_cliente || 0);
            if (categoriaSeleccionada === "tmo") return parseFloat(row.kpi_porcentaje_over_tmo || 0);
            if (categoriaSeleccionada === "productividad") return parseFloat(row.kpi_porcentaje_over_productividad || 0);
            if (categoriaSeleccionada === "wp") return parseFloat(row.kpi_porcentaje_over_wp || 0);
            return 0;
        });

        // Configurar gráfica ApexCharts
        const opcionesGrafico = {
            chart: {
                type: "bar",
                height: 300
            },
            series: [{
                name: "Pago Over",
                data: valoresGrafico
            }],
            xaxis: {
                categories: categoriasGrafico
            },
            colors: ["#556ee6"], // Color personalizado
            legend: {
                position: "top"
            },
            dataLabels: {
                enabled: true
            }
        };
        
        // Renderizar la gráfica
        $("#graficoPagoOver").empty(); // Eliminar gráfica anterior
        const grafico = new ApexCharts(document.querySelector("#graficoPagoOver"), opcionesGrafico);
        grafico.render();
        
        /***********************************/
        
        // Filtrar los nombres de las categorías y los valores de "Pago Above"
        const categoriasBar = data.map(row => row.nombre_categoria);
        const valoresBar = data.map(row => {
            if (categoriaSeleccionada === "cumplimiento_procesos") return parseFloat(row.pago_above_cumplimiento_procesos || 0);
            if (categoriaSeleccionada === "atencion_cliente") return parseFloat(row.pago_above_atencion_cliente || 0);
            if (categoriaSeleccionada === "tmo") return parseFloat(row.pago_above_tmo || 0);
            if (categoriaSeleccionada === "productividad") return parseFloat(row.pago_above_productividad || 0);
            if (categoriaSeleccionada === "wp") return parseFloat(row.pago_above_wp || 0);
            return 0;
        });
        
        // Configuración para la gráfica de Barras
        const opcionesBar = {
            chart: {
                type: "bar",
                height: 300
            },
            series: [{
                name: "Pago Over",
                data: valoresBar
            }],
            xaxis: {
                categories: categoriasBar
            },
            colors: ["#556ee6"], // Color personalizado
            legend: {
                position: "top"
            },
            dataLabels: {
                enabled: true
            }
        };
        
        // Renderizar gráfica de Barras
        $("#graficoPagoOverBar").empty();
        const graficoBar = new ApexCharts(document.querySelector("#graficoPagoOverBar"), opcionesBar);
        graficoBar.render();
        
        /***************************************/

        // Filtrar los nombres de las categorías y los valores de "Kpi Dia"
        const categoriasPie = data.map(row => row.nombre_categoria);
        const valoresPie = data.map(row => {
            if (categoriaSeleccionada === "cumplimiento_procesos") return parseFloat(row.kpi_noche_cumplimiento_procesos || 0);
            if (categoriaSeleccionada === "atencion_cliente") return parseFloat(row.kpi_noche_atencion_cliente || 0);
            if (categoriaSeleccionada === "tmo") return parseFloat(row.kpi_noche_tmo || 0);
            if (categoriaSeleccionada === "productividad") return parseFloat(row.kpi_noche_productividad || 0);
            if (categoriaSeleccionada === "wp") return parseFloat(row.kpi_noche_wp || 0);
            return 0;
        });
        
        // Configuración para la gráfica de Pastel
        const opcionesPie = {
            chart: {
                type: "pie",
                height: 300
            },
            series: valoresPie,
            labels: categoriasPie,
            colors: ["#556ee6", "#34c38f", "#f46a6a", "#f1b44c", "#50a5f1"], // Colores personalizados
            legend: {
                position: "bottom"
            },
            dataLabels: {
                enabled: true
            }
        };

        // Renderizar gráfica de Pastel
        $("#graficoPagoOverPie").empty();
        const graficoPie = new ApexCharts(document.querySelector("#graficoPagoOverPie"), opcionesPie);
        graficoPie.render();
    }

/*********************/

    $('#controlIndicadoresDataTable').on('click', '.guardar-cambios', function () {
        const id = $(this).data('id');
        const bono90 = $(`.bono-90[data-id="${id}"]`).val();
        const bono100 = $(`.bono-100[data-id="${id}"]`).val();
        const kpiDia = $(`.kpi-dia[data-id="${id}"]`).val();
        const kpiNoche = $(`.kpi-noche[data-id="${id}"]`).val();
        const porcentajeAbove = $(`.porcentaje-above[data-id="${id}"]`).val();
        const porcentajeOver = $(`.porcentaje-over[data-id="${id}"]`).val();
        const peso = $(`.peso[data-id="${id}"]`).val();
        const pagoAbove = $(`.pago-above[data-id="${id}"]`).val();
        const pagoTarget = $(`.pago-target[data-id="${id}"]`).val();
        const pagoOver = $(`.pago-over[data-id="${id}"]`).val();
        
        const boton = $(this); // Guardar referencia del botón
        boton.text("Guardando...").prop("disabled", true); // Cambiar estado del botón

        $.ajax({
            url: baseUrl + "/guardar-indicador",
            type: "POST",
            data: { id, bono90, bono100, kpi_dia: kpiDia, kpi_noche: kpiNoche, porcentajeAbove, porcentajeOver, peso, pagoAbove, pagoTarget, pagoOver },
            success: function (response) {
                $('.respuesta_global').html(response);
               
                if (response.success) dt.ajax.reload(null, false);
            },
            complete: function () {
                boton.text("Update").prop("disabled", false); // Restaurar botón
            }
        });
    });
});

</script>
<?php $this->endSection(); ?>


<?php $this->endSection(); ?>

<?= $this->section('js'); ?>
<script>
$(function () {
    
});


		</script>
<?php $this->endSection(); ?>