<?php
namespace App\Models;
use CodeIgniter\Model;

class ReporteNovedadesModel extends Model
{
    protected $table      = 'reporte_novedades';
    protected $primaryKey = 'id';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = [ 'id', 'idUsuario', 'IDGrupoTrabajo', 'UsuarioRegistra', 'categoria', 'horas_trabajadas', 'tardanza', 'horas_extras', 'total_faltas', 'bono_desempeno', 'comision_total', 'matricula', 'dias_trabajo_efectivo', 'fechas_trabajo_efectivo', 'dias_teletrabajo', 'fechas_teletrabajo', 'HHEE25', 'HHEE35', 'HHEE_dominical_100', 'HHEE_feriado', 'HHEE_1ro_de_mayo', 'HHEE_nocturnas', 'bono_productividad', 'otros_bonos', 'bono_de_carrera', 'bonificacion_por_desempeno', 'bono_responsabilidad', 'bono_inicio', 'bono_veritombola', 'comisiones_upselling', 'reintegro_afecto', 'gift_card', 'gift_card_upselling', 'obsequios_upselling', 'obsequios_al_personal', 'descuento_por_equipo_celular', 'descuento_uniforme_materiales', 'descuento_por_demos', 'descuento_eps', 'descuento_alarma_verisure', 'descuento_seguro_rimac', 'observaciones', 'fecha_creacion', 'mesReporte', 'anioReporte'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listaReporteNovedadesServerSide($get, $adicionales)
    {
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        // $this->globales = new Globales();
        $fields = array(
            0 => 'UsuarioRegistra',                     // Usuario que registra
            1 => 'categoria',                           // Categoría
            2 => 'horas_trabajadas',                    // Horas Trabajadas
            3 => 'tardanza',                            // Tardanza
            4 => 'horas_extras',                        // Horas Extras
            5 => 'total_faltas',                        // Total Faltas
            6 => 'bono_desempeno',                      // Bono Desempeño
            7 => 'comision_total',                      // Comisión Total
            8 => 'matricula',                           // Matrícula
            9 => 'dias_trabajo_efectivo',               // Días Trabajo Efectivo
            10 => 'fechas_trabajo_efectivo',            // Fechas Trabajo Efectivo
            11 => 'dias_teletrabajo',                   // Días Teletrabajo
            12 => 'fechas_teletrabajo',                 // Fechas Teletrabajo
            13 => 'HHEE25',                             // Horas Extra 25%
            14 => 'HHEE35',                             // Horas Extra 35%
            15 => 'HHEE_dominical_100',                 // Horas Extra Dominical 100%
            16 => 'HHEE_feriado',                       // Horas Extra Feriado
            // 17 => 'HHEE_1ro_de_mayo',                   // Horas Extra 1ro de Mayo
            17 => 'HHEE_nocturnas',                     // Horas Extra Nocturnas
            18 => 'bono_productividad',                 // Bono Productividad
            19 => 'otros_bonos',                        // Otros Bonos
            20 => 'bono_de_carrera',                    // Bono de Carrera
            21 => 'bonificacion_por_desempeno',         // Bonificación por Desempeño
            22 => 'bono_responsabilidad',               // Bono Responsabilidad
            23 => 'bono_inicio',                        // Bono Inicio
            24 => 'bono_veritombola',                   // Bono Veritombola
            25 => 'comisiones_upselling',               // Comisiones Upselling
            26 => 'reintegro_afecto',                   // Reintegro Afecto
            27 => 'gift_card',                          // Gift Card
            28 => 'gift_card_upselling',                // Gift Card Upselling
            29 => 'obsequios_upselling',                // Obsequios Upselling
            30 => 'obsequios_al_personal',              // Obsequios al Personal
            31 => 'descuento_por_equipo_celular',       // Descuento por Equipo Celular
            32 => 'descuento_uniforme_materiales',      // Descuento Uniforme Materiales
            33 => 'descuento_por_demos',                // Descuento por Demos
            // 34 => 'descuento_eps',                      // Descuento EPS
            // 35 => 'descuento_alarma_verisure',          // Descuento Alarma Verisure
            // // 37 => 'descuento_seguro_rimac',             // Descuento Seguro Rimac
            // 36 => 'observaciones',                      // Observaciones
            // 37 => 'fecha_creacion',                     // Fecha de Creación
            // 48 => 'mesReporte',                         // Mes del Reporte
            // 39 => 'anioReporte'                         // Año del Reporte
        );


        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('
            gt.GrupoTrabajo,
            UsuarioRegistra,
            categoria,
            horas_trabajadas,
            tardanza,
            horas_extras,
            total_faltas,
            bono_desempeno,
            comision_total,
            matricula,
            dias_trabajo_efectivo,
            fechas_trabajo_efectivo,
            dias_teletrabajo,
            fechas_teletrabajo,
            HHEE25,
            HHEE35,
            HHEE_dominical_100,
            HHEE_feriado,
            HHEE_1ro_de_mayo,
            HHEE_nocturnas,
            bono_productividad,
            otros_bonos,
            bono_de_carrera,
            bonificacion_por_desempeno,
            bono_responsabilidad,
            bono_inicio,
            bono_veritombola,
            comisiones_upselling,
            reintegro_afecto,
            gift_card,
            gift_card_upselling,
            obsequios_upselling,
            obsequios_al_personal,
            descuento_por_equipo_celular,
            descuento_uniforme_materiales,
            descuento_por_demos
        ');
        $this->join('grupostrabajo gt', 'reporte_novedades.IDGrupoTrabajo = gt.IDGrupoTrabajo', 'left');

        // $this->where($adicionales);
        
        // Aplica las condiciones basadas en $adicionales
        if (!empty($adicionales['values']) && isset($adicionales['column'])) {
            $this->whereIn($adicionales['column'], $adicionales['values']);
        }
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */

            if (isset($get['search']) &&  $get['search']['value'] != "") 
            {
                $this->groupStart(); // Inicia un grupo de condiciones
                foreach ($get['columns'] as $k => $column) 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $this->orLike($fields[$k], $get['search']['value']);
                    }
                }
                $this->groupEnd(); // Finaliza el grupo de condiciones
            }
            
            /*
            * ----------------------------
            * ORDENAMIENTO DE QUERY
            * ----------------------------
            */
            if (isset($get['order'])) {
                foreach ($get['order'] as $order) {
                    if(array_key_exists($order['column'], $fields))
                    {
                        $this->orderBy($fields[$order['column']], $order['dir']);
                    }
                }
            }
            /*
            * ----------------------------
            * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
            * ----------------------------
            */
            if (isset($get['length']) && isset($get['start'])) {
                $this->limit($get['length'], $get['start']);
            }
  
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        $result = $this->get()->getResultArray(); 
        
        // Retornar datos y totales
        return   $result;  
    }

}