<?php
namespace App\Models;
use CodeIgniter\Model;

class HorariosModel extends Model
{
    protected $table      = 'horarios';
    protected $primaryKey = 'id_horario';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = [ 'id_horario', 'UsuarioRegistra', 'horario', 'codigo', 'FechaRegistra', 'Estado', 'EliminacionLogica','HoraInicio','HoraFin', 'UsuarioModifica', 'FechaModifica', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listaHorariosServerSide($get, $adicionales)
    {
        $idUsuario = $adicionales['Idusuario'];
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        // $this->globales = new Globales();
        $fields = array(
            0 => 'horarios.id_horario',
            1 => 'horarios.horario',
            2 => 'horarios.codigo',
            3 => 'horarios.UsuarioRegistra',
            4 => 'horarios.FechaRegistra',
            5 => 'horarios.Estado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        $this->select('horarios.id_horario, 
            horarios.horario, 
            horarios.codigo, 
            horarios.UsuarioRegistra, 
            horarios.FechaRegistra, 
            horarios.Estado AS estadoHorario, 
            horarios.EliminacionLogica, 
            CONCAT(tblusuario.Nombres," ",tblusuario.Apellidos) AS nombresCompletos');
        // $this->join('horario_grupotrabajo', 'horario_grupotrabajo.id_horario = horarios.id_horario');
        
        $this->join('tblusuario', 'tblusuario.IdUsuario = horarios.UsuarioRegistra', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
    //     $whereHorarios = array(
				//     'horarios.EliminacionLogica' => 1,
				//     'horario_grupotrabajo.IDGrupoTrabajo' => $idGrupoTrabajo
			 //   );
	    
	   // $this->where($whereHorarios);
	
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('horarios.id_horario, 
            horarios.horario, 
            horarios.codigo, 
            horarios.UsuarioRegistra, 
            horarios.FechaRegistra, 
            horarios.Estado AS estadoHorario, 
            horarios.EliminacionLogica, 
            CONCAT(tblusuario.Nombres," ",tblusuario.Apellidos) AS nombresCompletos');
            
        $this->join('tblusuario', 'tblusuario.IdUsuario = horarios.UsuarioRegistra', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        $this->limit($get['length'], $get['start']);
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        // $this->get();
        // return $this->getLastQuery();
        $result = $this->get()->getResultArray(); 
        
        // Retornar datos y totales
        return [
            'draw' => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal' => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered' => $filteredRecords, // Total de registros después de aplicar filtros
            'data' => $result // Los datos actuales para mostrar
        ];
    }
    
    public function listaGeneralHorariosServerSide($get, $adicionales)
    {
        $idGrupoTrabajo = $adicionales['idGrupoTrabajo'];
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        // $this->globales = new Globales();
        $fields = array(
            0 => 'horarios.id_horario',
            1 => 'horarios.horario',
            2 => 'horarios.codigo',
            3 => 'horarios.UsuarioRegistra',
            4 => 'horarios.FechaRegistra',
            5 => 'horarios.Estado');
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        $this->select('horarios.id_horario, horarios.horario, horarios.codigo, horarios.UsuarioRegistra, horarios.FechaRegistra, horarios.Estado, horarios.EliminacionLogica, CONCAT(tblusuario.Nombres," ",tblusuario.Apellidos) AS nombresCompletos');
        $this->join('horario_grupotrabajo', 'horario_grupotrabajo.id_horario = horarios.id_horario');
        $this->join('tblusuario', 'tblusuario.IdUsuario = horarios.UsuarioRegistra', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        $whereHorarios = array(
				    'horarios.EliminacionLogica' => 1,
				    'horario_grupotrabajo.IDGrupoTrabajo' => $idGrupoTrabajo
			    );
	    
	    $this->where($whereHorarios);
			    
        // $this->where('horarios.EliminacionLogica', 1);
        // $this->where('horario_grupotrabajo.IDGrupoTrabajo',$idGrupoTrabajo);
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        $this->limit($get['length'], $get['start']);
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        // $this->get();
        // return $this->getLastQuery();
        $result = $this->get()->getResultArray(); 
        
        // Retornar datos y totales
        return   $result;  

    }
    
    public function listarHorariosXPlanificacion($idUsuarioPlanificacion)
    { 
        $this->distinct(); // Asegura que los resultados no se repitan
        $this->select('horarios.id_horario, horarios.horario, horarios.codigo,horarios.HoraInicio,horarios.HoraFin,horario_grupotrabajo.IDGrupoTrabajo');
        $this->join('horario_grupotrabajo', 'horario_grupotrabajo.id_horario = horarios.id_horario');
        $this->join('planificacion', 'planificacion.IDGrupoTrabajo = horario_grupotrabajo.IDGrupoTrabajo');
        $this->where('planificacion.IdUsuario', $idUsuarioPlanificacion);
        
        $datos = $this->findAll(); // Ejecuta la consulta y obtiene los resultados
        return $datos; // Retorna los datos únicos
    }
    
    public function horariosGrupoTrabajoAsociado($idGrupoTrabajo, $idUsuario)
    { 
        $where = array(
			'grupostrabajo.JefeGrupoTrabajo' => $idUsuario,
			'horario_grupotrabajo.IDGrupoTrabajo' => $idGrupoTrabajo
		);
			    
        $this->select('horarios.id_horario, horarios.horario, horarios.codigo, horarios.UsuarioRegistra, horarios.FechaRegistra, horarios.Estado AS estadoHorario, horarios.EliminacionLogica,grupostrabajo.IDGrupoTrabajo');
        $this->join('horario_grupotrabajo', 'horario_grupotrabajo.id_horario = horarios.id_horario');
        $this->join('grupostrabajo', 'grupostrabajo.IDGrupoTrabajo = horario_grupotrabajo.IDGrupoTrabajo');
        $this->where($where);
        
        $datos = $this->findAll(); // Ejecuta la consulta y obtiene los resultados
        return $datos; // Retorna los datos únicos
    }
    
    // public function listarHorariosXSeleccion($idHorarioSeleccionado)
    // { 
    //     $whereDatos = array(
    //         'planificacion.id_horario' => $idHorarioSeleccionado,
    //         'horarios.EliminacionLogica' => 1
    //     );
        
    //     // Construimos la consulta directamente sobre el modelo actual
    //     $datos = $this->select('planificacion.FechaTrabajo, planificacion.IdUsuario,planificacion.Motivo, planificacion.IdPlanificacion, grupostrabajo.GrupoTrabajo, horarios.horario, horarios.id_horario, horarios.HoraInicio, horarios.HoraFin, horarios.codigo, tblusuario.Nombres, tblusuario.Apellidos')
    //         ->join('horarios', 'planificacion.id_horario = horarios.id_horario', 'left')
    //         ->join('grupostrabajo', 'grupostrabajo.IDGrupoTrabajo = planificacion.IDGrupoTrabajo', 'left')
    //         ->join('tblusuario', 'tblusuario.IdUsuario = grupostrabajo.JefeGrupoTrabajo', 'left')
    //         ->where($whereDatos)
    //         ->findAll(); // Ejecuta la consulta y obtiene los resultados
        
    //     return $datos; // Retorna los datos obtenidos
    // }

}