<?php

namespace App\Libraries;
use \App\Libraries\Error;
use \App\Libraries\Alertas;

class Globales {
    
    function estadosLinea() {
        return array(
            'ACT' => "ACTIVO",
            'SUS' => "SUSPENDIDA",
            'BAJ' => "BAJA"
        );
    }    

    function motivoEstadoLinea($estadoLinea) {

        switch ($estadoLinea) {
            case 'ACT':
                return array(
                    "NUE" => "NUEVO",
                    "REP" => "REPOSICIÓN",
                    "ASI" => "ASIGNADO",
                    "TRA" => "TRASPASO",
                    "DEV" => "DEVOLUCIÓN OK"
                );
                break;
            case 'SUS':
                return array(
                    "ROB" => "ROBO",
                    "PER" => "PÉRDIDA",
                    "BAC" => "BACKUP"
                );
                break;
            case 'BAJ':
                return array(
                    "DEP" => "DEPURACIÓN",
                    "TRA" => "TRASPASO"
                );
                break;
            default:
                return array();
                break;
        }
    }    

    function estadosMovil() {
        return array(
            'ACT' => "ACTIVO",
            'AVE' => "AVERIADO",
            'REP' => "REPARACIÓN",
            'BAJ' => "BAJA"
        );
    }    

    function motivoEstadoMovil($estadoMovil) {

        switch ($estadoMovil) {
            case 'ACT':
                return array(
                    "NUE" => "NUEVO",
                    "OPE" => "OPERATIVO",
                    "ASI" => "ASIGNADO",
                    "STO" => "STOCK",
                    "DEV" => "DEVOLUCIÓN OK"
                );
                break;
            case 'AVE':
                return array(
                    "FF" => "FALLA DE FÁBRICA",
                    "FT" => "FALLA TÉCNICA"
                );
                break;
            case 'REP':
                return array(
                    "GAR" => "GARANTÍA (OPERADOR)",
                    "EXT" => "CENTRO EXTERNO"
                );
                break;
            case 'BAJ':
                return array(
                    "INO" => "INOPERATIVO",
                    "ROB" => "ROBO",
                    "PER" => "PÉRDIDA",
                    "NOD" => "NO DEVOLUCIÓN",
                    "FAL" => "FALLA"
                );
                break;
            default:
                return array(
                    "NUE" => "NUEVO",
                    "OPE" => "OPERATIVO",
                    "ASI" => "ASIGNADO",
                    "STO" => "STOCK",
                    "DEV" => "DEVOLUCIÓN OK",
                    "FF" => "FALLA DE FÁBRICA",
                    "FT" => "FALLA TÉCNICA",
                    "GAR" => "GARANTÍA (OPERADOR)",
                    "EXT" => "CENTRO EXTERNO",
                    "INO" => "INOPERATIVO",
                    "ROB" => "ROBO",
                    "PER" => "PÉRDIDA",
                    "NOD" => "NO DEVOLUCIÓN",
                    "FAL" => "FALLA"
                );
                break;
        }
    }    

    function permanenciaContrato() {
        return array(
            'SP' => "SIN PERMANENCIA",
            '12' => "12 MESES",
            '15' => "15 MESES",
            '18' => "18 MESES"
        );
    }    

    function estadosPaqueteria() {
        return array(
            'REG' => array(
                "NOMBRE"    => "REGISTRADO",
                "FONDO"     => "bg-secondary"
            ),
            'ENV' => array(
                "NOMBRE"    => "ENVIADO",
                "FONDO"     => "bg-primary"
            ),
            'REC' => array(
                "NOMBRE"    => "RECIBIDO",
                "FONDO"     => "bg-success"
            )
        );
    }    

    function diaCortePlanilla()
    {
        return 13;
    }
    
    function listadoCentroCostoCoordinador()
    {
        return array(
            1476 => array(40, 41, 80, 100, 230),
            4093 => array(60, 120, 121, 140, 200),
            1093 => array(152, 154, 155, 158),
            167 => array(130, 150, 151, 156, 157, 159, 252),
            2320 => array(80, 100, 230),
            3998 => array(120, 121),
            4103 => array(120, 140),
            3131 => array(152, 155),
            3298 => array(154),
            1527 => array(156, 157),
            3282 => array(159, 252),
            2319 => array(140, 141),
            112 => array(40, 41, 60, 80, 100, 120, 121, 130, 140, 141, 150, 151, 152, 154, 155, 156, 157, 159, 158, 200, 230, 252)
        );
    }
}
