<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- Main content -->

<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
		<!-- start page title -->
    		<div class="row">
    			<div class="col-12">
    				<div class="page-title-box d-sm-flex align-items-center justify-content-between">
    					<h4 class="mb-sm-0"><?= $breadcrumb ?></h4>
    
    					<div class="page-title-right">
    						<ol class="breadcrumb m-0">
    							<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
    							<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
    						</ol>
    					</div>
    
    				</div>
    			</div>
    		</div>
    		<!-- end page title -->
    		<div class="row">
    			<div class="col-12">
    				<div class="card">
    					<div class="card-header align-items-center d-flex">
    						<h4 class="card-title mb-0 flex-grow-1"><?= $breadcrumb ?></h4>
    						<div class="d-flex">
    						    <?php
								if (in_array("EXPPRO", $permisos)) 
								{
								?>
    							<button type="button" class="btn bg-warning d-flex align-items-center mx-1 color-white" id="btnExportarProveedor">
    								<i class="mdi mdi-file-download" style="font-size: 14px;"></i> Exportar
    							</button>
    							<?php
    							}
    							
								if (in_array("ADDPRO", $permisos)) 
								{
								?>
    							<button type="button" class="btn bg-info d-flex align-items-center mx-1 color-white" data-bs-target="#nuevoProveedor" id="btnNuevoProveedor">
    								<i class="mdi mdi-plus-circle" style="font-size: 14px;"></i> Nuevo
    							</button>
    							<?php
								}
								?>
    						</div>
    					</div>
    					<!-- /.card-header -->
    					<div class="card-body">
    						<div class="">
    							<table id="tblProveedores" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
    								
    							</table>
    						</div>
    					</div>
    					<!-- /.card-body -->
    				</div>
    				<!-- /.card -->
    			</div>
    			<!-- /.col -->
    		</div>
    		<!-- end row-->
    	</div>
		<span class="respuesta_global"></span>
    	<!-- container-fluid -->
    </div>
    <!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- /.content -->
<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE PROVEEDORES***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblProveedores').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/proveedoresServerside",
						type: 'GET'
					},
					"columns": [
						{"title": "RUC", "data": "RUC", "class": "text-center", "searchable": true },
						{"title": "Proveedor", "data": "Nombre", "class": "text-center", "searchable": true },
						{"title": "Contacto", "data": "Contacto", "class": "text-center", "searchable": true },
						{"title": "Departamento", "data": "Departamento", "class": "text-center", "searchable": true },
						{"title": "Provincia", "data": "Provincia", "class": "text-center", "searchable": true },
						{"title": "Distrito", "data": "Distrito", "class": "text-center", "searchable": true },
						{"title": "Teléfono 01", "data": "Telefono01", "class": "text-center", "searchable": true },
						{"title": "Teléfono 02", "data": "Telefono02", "class": "text-center", "searchable": true },
						{"title": "Email", "data": "Email", "class": "text-center", "searchable": true },
						{"title": "Estado",
							"data": "Estado",
							class: 'text-center',
								render: function(data, type, row){  // con row obtienes la información por fila
								<?php
								if (in_array("ESTPRO", $permisos)) 
								{
								?>
								return "<button class='badge "+(row.Estado == 'A' ? 'bg-success' : 'bg-danger')+" border-0 cambiar-estado-proveedor' data-estado='"+row.Estado+"' data-id='"+row.IDProveedor+"'>"+(row.Estado == 'A' ? 'ACTIVO' : 'INACTIVO')+"</button>";
								<?php
								}
								else
								{
								?>
								return "<span class='badge "+(row.Estado == 'A' ? 'bg-success' : 'bg-danger')+"'>"+(row.Estado == 'A' ? 'ACTIVO' : 'INACTIVO')+"</span>";
								<?php
								}
								?>
								
							}
						},
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],

					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"aaSorting": [[1, 'asc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE PROVEEDORES****/
	});
</script>
<?php $this->endSection(); ?>
<!-- AGREGAR NUEVO PROVEEDOR -->
<div class="modal fade zoomIn" id="nuevoProveedor" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog modal-xl modal-dialog-centered">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h4 class="modal-title color-white">Registrar Proveedor</h4>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close">
				</button>
			</div>
			<form id="formNuevoProveedor" class="formulario form-steps" autocomplete="off" action="<?= $baseUrl ?>/registrar-proveedor" method="POST">
				<span class="respuesta"></span>
    			<div class="modal-body">
    				<div class="mb-4">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="tabInformacionProveedor" data-bs-toggle="tab" data-bs-target="#tabcontentInformacionProveedor" type="button" role="tab" aria-controls="tabcontentInformacionProveedor" aria-selected="true" data-position="0">Proveedor</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tabModalidadPagoProveedor" data-bs-toggle="tab" data-bs-target="#tabcontentModalidadPagoProveedor" type="button" role="tab" aria-controls="tabcontentModalidadPagoProveedor" aria-selected="false" data-position="1">Modalidad de Pago</button>
                            </li>
                        </ul>
                    </div>
                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="tabcontentInformacionProveedor" role="tabpanel" aria-labelledby="tabInformacionProveedor">
                            <div class="row g-4">
								<div class="col-12 col-lg-4">
									<div class="form-group">
										<label for="ruc">Ruc</label>
										<input type="text" class="form-control" id="ruc" name="ruc" placeholder="Ruc">
									</div>
								</div>
								<div class="col-12 col-lg-4">
									<div class="form-group">
										<label for="proveedor">Nombre Proveedor</label>
										<input type="text" class="form-control" id="proveedor" name="proveedor" placeholder="Proveedor">
									</div>
								</div>
								<div class="col-12 col-lg-4">
									<div class="form-group">
										<label for="contacto">Contacto</label>
										<input type="text" class="form-control" id="contacto" name="contacto" placeholder="Contacto">
									</div>
								</div>
								<div class="col-12 col-lg-4">
									<div class="form-group">
										<label for="cboGrupoContableNegocio">Grupo Contable Negocio</label>
										<select class="form-select" id="cboGrupoContableNegocio" name="cboGrupoContableNegocio">
										    <option value="" selected>Seleccione una opción...</option>
										    <option value="NACIONAL">NACIONAL</option>
										    <option value="EXPORT">EXPORT</option>
										</select>
									</div>
								</div>
								<div class="col-12 col-lg-4">
									<div class="form-group">
										<label for="cboGrupoRegistroIVA">Grupo Registro IVA</label>
										<select class="form-select" id="cboGrupoRegistroIVA" name="cboGrupoRegistroIVA">
										    <option value="" selected>Seleccione una opción...</option>
										    <option value="NACIONAL">NACIONAL</option>
										    <option value="EXPORT">EXPORT</option>
										</select>
									</div>
								</div>
								<div class="col-12 col-lg-4">
									<div class="form-group">
										<label for="cboGrupoContableProveedor">Grupo Contable Proveedor</label>
										<select class="form-select" id="cboGrupoContableProveedor" name="cboGrupoContableProveedor">
										    <option value="" selected>Seleccione una opción...</option>
										    <option value="ACREED">ACREED</option>
										    <option value="ALQ">ALQ</option>
										    <option value="BOLETAS">BOLETAS</option>
										    <option value="CIAL">CIAL</option>
										    <option value="DETRACC">DETRACC</option>
										    <option value="EMP.GRUPO">EMP.GRUPO</option>
										    <option value="INST">INST</option>
										    <option value="INTL">INTL</option>
										    <option value="PROVEED">PROVEED</option>
										    <option value="RETENCION">RETENCION</option>
										    <option value="UE">UE</option>
										    <option value="UESERV">UESERV</option>
										</select>
									</div>
								</div>
								<div class="col-12 col-lg-4">
									<div class="form-group">
										<label for="pais">Pais</label>
										<select class="form-select select2-dinamico" id="pais" name="pais" data-modal="nuevoProveedor">
										</select>
									</div>
								</div>
								<div class="col-12 col-lg-4">
									<div class="form-group">
										<label for="departamento">Departamento</label>
										<select class="form-select select2-dinamico" id="departamento" name="departamento" data-modal="nuevoProveedor">
										</select>
									</div>
								</div>
								<div class="col-12 col-lg-4">
									<div class="form-group">
										<label for="provincia">Provincia</label>
										<select class="form-select select2-dinamico" id="provincia" name="provincia" data-modal="nuevoProveedor">
										</select>
									</div>
								</div>
								<div class="col-12 col-lg-4">
									<div class="form-group">
										<label for="distrito">Distrito</label>
										<select class="form-select select2-dinamico" id="distrito" name="distrito" data-modal="nuevoProveedor">
										</select>
									</div>
								</div>
								<div class="col-12 col-lg-4">
									<div class="form-group">
										<label for="direccion">Dirección</label>
										<input type="text" class="form-control" id="direccion" name="direccion" placeholder="Dirección">
									</div>
								</div>
								<div class="col-12 col-lg-4">
									<div class="form-group">
										<label for="correo">Email</label>
										<input type="text" class="form-control" id="correo" name="correo" placeholder="Correo">
									</div>
								</div>
								<div class="col-12 col-lg-4">
									<div class="form-group">
										<label for="telefono01">Telefono</label>
										<input type="text" class="form-control" id="telefono01" name="telefono01" placeholder="Telefono 01">
									</div>
								</div>
								<div class="col-12 col-lg-4">
									<div class="form-group">
										<label for="telefono02">Telefono 2</label>
										<input type="text" class="form-control" id="telefono02" name="telefono02" placeholder="Telefono 02">
									</div>
								</div>
								<div class="col-12 col-lg-4">
									<div class="form-group">
										<label for="formapago">Forma de Pago</label>
										<select class="form-select select2-dinamico" id="formapago" name="formapago">
										</select>
									</div>
								</div>
								<div class="col-12 col-lg-12">
									<div class="form-group">
										<label for="tipologia">Tipologia</label>
										<select class="form-select select2-dinamico" id="tipologia" name="tipologia[]" multiple="multiple">
										</select>
									</div>
								</div>
								<div class="col-12 col-lg-6">
									<div class="form-group">
										<label for="cuenta_detraccion">Nro Cuenta Detracción</label>
										<input type="text" class="form-control " id="cuenta_detraccion" name="cuenta_detraccion" placeholder="Cuenta Detracción">
									</div>
								</div>
								<div class="col-12 col-lg-6">
									<div class="form-group">
										<label for="codigo_detraccion">Código Detracción</label>
										<select class="form-select select2-dinamico" id="codigo_detraccion" name="codigo_detraccion">
										</select>
									</div>
								</div>
        					    <div class="col-12 col-lg-12">
        					        <div class="form-group">
        								<label for="observaciones">Observaciones Generales</label>
        								<textarea class="form-control" id="observaciones" name="observaciones" rows="4" placeholder="Observaciones"></textarea>
            						</div>
        					    </div>
								<!--<div class="col-12 col-lg-6">-->
								<!--	<div class="form-group">-->
								<!--		<label for="codigo_detraccion">Código Detracción</label>-->
								<!--		<input type="text" class="form-control" id="codigo_detraccion" name="codigo_detraccion" placeholder="Código Detracción">-->
								<!--	</div>-->
								<!--</div>-->
								<!--<div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-2 mb-1 d-flex justify-content-between align-items-center" style="border-radius: 10px;">-->
        <!--						    <h5 class="color-white m-0">¿Tiene una cuenta de detracción?</h5>-->
        <!--						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center">-->
        <!--								<input class="form-check-input form-check-input-green" type="checkbox" role="switch" name="cuenta_detraccion" id="cuenta_detraccion" >-->
        <!--								<label class="form-check-label" for="cuenta_detraccion"></label>-->
        <!--							</div>-->
        <!--						</div>-->
								<!--<div class="col-12 col-lg-12 d-none" id="ctnCuentaDetraccion">-->
								<!--	<div class="form-group">-->
								<!--		<label for="codigo_detraccion">Código Detracción</label>-->
								<!--		<input type="text" class="form-control" id="codigo_detraccion" name="codigo_detraccion" placeholder="Código Detracción">-->
								<!--	</div>-->
								<!--</div>-->
							</div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabModalidadPagoProveedor"><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Ingresar Modalidad de Pago</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                        <div class="tab-pane fade" id="tabcontentModalidadPagoProveedor" role="tabpanel" aria-labelledby="tabModalidadPagoProveedor">
                            <div>
                                <h3 class="mb-3">Agregar Modalidad de Pago</h3>
                                <div class="card-text mb-3">
									<div class="form-group row">
										<div class="col-4">
											<label for="modalidadPago">Modalidad de Pago</label>
											<select class="form-select select2-dinamico" id="modalidadPago" data-modal="nuevoProveedor">
											</select>
										</div>
										<div class="col-4">
											<label for="banco">Banco</label>
											<select class="form-select select2-dinamico" id="banco" data-modal="nuevoProveedor">
											</select>
										</div>
										<div class="col-4">
											<label for="nrocuenta">Número de Cuenta</label>
											<input type="text" class="form-control" id="nrocuenta" placeholder="Número de Cuenta">
										</div>
									</div>
								</div>
								<div class="card-text mb-3">
									<div class="form-group row">
										<div class="col-3">
											<label for="cci">CCI</label>
											<input type="text" class="form-control" id="cci" placeholder="CCI">
										</div>
										<div class="col-3">
											<label for="moneda">Moneda</label>
											<select class="form-select select2-dinamico" id="moneda">
											</select>
										</div>
										<div class="col-3">
											<label for="prioridad">Prioridad</label>
											<input type="number" min="1" step="1" class="form-control" id="prioridad" placeholder="Prioridad">
										</div>
										<div class="col-3 d-flex justify-content-end align-items-center">
										    <button type="button" class="btn bg-info px-2 py-1 ms-3 color-white d-flex justify-content-end align-items-center" onclick="return agregarModalidadPago('ctnModalidadesPago');" data-tooltip="tooltip" aria-label="Agregar Modalidad de Pago">
                                                <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i> Agregar Modalidad de Pago
                                            </button>
										</div>
									</div>
								</div>
								<div class="card-text mb-3">
									<div class="form-group row">
										
									</div>
								</div>
								<hr>
								<h3 class="mb-3">Modalidades de Pago</h3>
								<div class="row col-12 m-0 p-0 d-flex" id="ctnModalidadesPago">
								    
        				        </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionProveedor"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a Proveedor</button>
                                <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                    </div>
                    <!-- end tab content -->
    			</div>
    		</form>
		</div>
	</div>
</div>

<!--  EDITAR PROVEEDOR -->
<div class="modal fade zoomIn" id="editarProveedor" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleeditarProveedor" aria-hidden="true">
	<div class="modal-dialog modal-xl modal-dialog-centered">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h4 class="modal-title color-white" id="exampleeditarProveedor">Editar Proveedor</h4>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formEditarProveedor" class="formulario" autocomplete="off" action="<?= $baseUrl ?>/actualizar-proveedor" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="row g-4">
						<div class="col-12 col-lg-4">

							<label for="ruc_e">Ruc</label>
							<input type="text" class="form-control" id="ruc_e" name="ruc_e" placeholder="Ruc">

						</div>
						<div class="col-12 col-lg-4">

							<label for="proveedor_e">Nombre Proveedor</label>
							<input type="text" class="form-control" id="proveedor_e" name="proveedor_e" placeholder="Proveedor">

						</div>
						<div class="col-12 col-lg-4">

							<label for="contacto_e">Contacto</label>
							<input type="text" class="form-control" id="contacto_e" name="contacto_e" placeholder="Contacto">

						</div>
						
						<div class="col-12 col-lg-4">
							<div class="form-group">
								<label for="cboGrupoContableNegocio_e">Grupo Contable Negocio</label>
								<select class="form-select" id="cboGrupoContableNegocio_e" name="cboGrupoContableNegocio_e">
								    <option value="" selected>Seleccione una opción...</option>
								    <option value="NACIONAL">NACIONAL</option>
								    <option value="EXPORT">EXPORT</option>
								</select>
							</div>
						</div>
						<div class="col-12 col-lg-4">
							<div class="form-group">
								<label for="cboGrupoRegistroIVA_e">Grupo Registro IVA</label>
								<select class="form-select" id="cboGrupoRegistroIVA_e" name="cboGrupoRegistroIVA_e">
								    <option value="" selected>Seleccione una opción...</option>
								    <option value="NACIONAL">NACIONAL</option>
								    <option value="EXPORT">EXPORT</option>
								</select>
							</div>
						</div>
						<div class="col-12 col-lg-4">
							<div class="form-group">
								<label for="cboGrupoContableProveedor_e">Grupo Contable Proveedor</label>
								<select class="form-select" id="cboGrupoContableProveedor_e" name="cboGrupoContableProveedor_e">
								    <option value="" selected>Seleccione una opción...</option>
								    <option value="ACREED">ACREED</option>
								    <option value="ALQ">ALQ</option>
								    <option value="BOLETAS">BOLETAS</option>
								    <option value="CIAL">CIAL</option>
								    <option value="DETRACC">DETRACC</option>
								    <option value="EMP.GRUPO">EMP.GRUPO</option>
								    <option value="INST">INST</option>
								    <option value="INTL">INTL</option>
								    <option value="PROVEED">PROVEED</option>
								    <option value="RETENCION">RETENCION</option>
								    <option value="UE">UE</option>
								    <option value="UESERV">UESERV</option>
								</select>
							</div>
						</div>
						<div class="col-12 col-lg-4">

							<label for="pais_e">Pais</label>
							<select class="form-select select2-dinamico" id="pais_e" name="pais_e" data-modal="editarProveedor">
							</select>

						</div>
						<div class="col-12 col-lg-4">

							<label for="departamento_e">Departamento</label>
							<select class="form-select select2-dinamico" id="departamento_e" name="departamento_e" data-modal="editarProveedor">
							</select>

						</div>
						<div class="col-12 col-lg-4">

							<label for="provincia_e">Provincia</label>
							<select class="form-select select2-dinamico" id="provincia_e" name="provincia_e" data-modal="editarProveedor">
							</select>

						</div>
						<div class="col-12 col-lg-4">

							<label for="distrito_e">Distrito</label>
							<select class="form-select select2-dinamico" id="distrito_e" name="distrito_e" data-modal="editarProveedor">
							</select>

						</div>
						<div class="col-12 col-lg-4">

							<label for="direccion_e">Dirección</label>
							<input type="text" class="form-control" id="direccion_e" name="direccion_e" placeholder="Dirección">

						</div>
						<div class="col-12 col-lg-4">

							<label for="correo_e">Email</label>
							<input type="text" class="form-control" id="correo_e" name="correo_e" placeholder="Correo">

						</div>
						<div class="col-12 col-lg-4">

							<label for="telefono01_e">Telefono 01</label>
							<input type="text" class="form-control" id="telefono01_e" name="telefono01_e" placeholder="Telefono">

						</div>
						<div class="col-12 col-lg-4">

							<label for="telefono02_e">Telefono 02</label>
							<input type="text" class="form-control" id="telefono02_e" name="telefono02_e" placeholder="Telefono 2">

						</div>
						<div class="col-12 col-lg-4">

							<label for="formapago_e">Forma de Pago</label>
							<select class="form-select select2-dinamico" id="formapago_e" name="formapago_e" data-modal="editarProveedor">
							</select>

						</div>
						<div class="col-12 col-lg-12">

							<label for="tipologia_e">Tipologia</label>
							<select class="form-select select2-dinamico" id="tipologia_e" name="tipologia_e[]" multiple="multiple" data-modal="editarProveedor">
							</select>

						</div>
						
						<div class="col-12 col-lg-6">

							<label for="cuenta_detraccion_e">Cuenta Detracción</label>
							<input type="text" class="form-control " id="cuenta_detraccion_e" name="cuenta_detraccion_e" placeholder="Cuenta Detracción">

						</div>
						<div class="col-12 col-lg-6">
							<div class="form-group">
								<label for="codigo_detraccion_e">Código Detracción</label>
								<select class="form-select select2-dinamico" id="codigo_detraccion_e" name="codigo_detraccion_e">
								</select>
							</div>
						</div>
					    <div class="col-12 col-lg-12">
					        <div class="form-group">
								<label for="observaciones_e">Observaciones Generales</label>
								<textarea class="form-control" id="observaciones_e" name="observaciones_e" rows="4" placeholder="Observaciones"></textarea>
    						</div>
					    </div>
						<!--<div class="col-12 col-lg-6">-->

						<!--	<label for="codigo_detraccion_e">Código Detracción</label>-->
						<!--	<input type="text" class="form-control" id="codigo_detraccion_e" name="codigo_detraccion_e" placeholder="Código Detracción">-->

						<!--</div>-->
					</div>

				</div>
				<div class="modal-footer justify-content-end">
					<button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarProveedor" class="btn btn-dark">Grabar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- EXPORTAR EXCEL PROVEEDORES -->
<div class="modal fade zoomIn" id="modal-exportar-proveedor" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog modal-md modal-dialog-centered">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h4 class="modal-title">Descargar Proveedor</h4>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close">
				</button>
			</div>
			<form class="formulario" action="<?= $baseUrl ?>/exportar-proveedores" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="row g-4">

						<div class="form-group ml-2" style="width:fit-content; margin:0 auto !important;">
							<a href="<?= $baseUrl ?>/descargar-proveedor/1" role="button" class="btn btn-success btn-xs p-2">
								<i class="fas fa-file-excel mr-1"></i>Exportar
							</a>
							<a href="<?= $baseUrl ?>/descargar-proveedor/0" role="button" class="btn btn-danger btn-xs p-2">
								<i class="fas fa-file-excel mr-1"></i>Exportar
							</a>
							<a href="<?= $baseUrl ?>/descargar-proveedor/2" role="button" class="btn btn-dark btn-xs p-2">
								<i class="fas fa-file-excel mr-1"></i>Exportar
							</a>
						</div>

					</div>
				</div>
				<div class="modal-footer justify-content-center">
					<span class="badge" style="color:#fff; background-color:#00a37d ;">Activos</span>
					<span class="badge" style="color:#fff; background-color:#ed002f;">Inactivos</span>
					<span class="badge" style="color:#fff; background-color:#636466 ;">Todos</span>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- MODAL EDITAR MODALIDAD PAGO checked-->
<div class="modal fade zoomIn" id="editarModalidadPagoProveedor" data-bs-backdrop="static" data-bs-focus="false" tabindex="-1" role="dialog" aria-labelledby="exampleeditarModalidadPagoProveedor" aria-hidden="true">
	<div class="modal-dialog modal-xl modal-dialog-centered">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h4 class="modal-title color-white" id="exampleeditarModalidadPagoProveedor">Modalidad de Pago del Proveedor</h4>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close">
				</button>
			</div>
			<span class="respuesta"></span>
			<div class="modal-body">
			    <h3 class="mb-3">Proveedor</h3>
			    <div class="row m-0 mb-3">
					<div class="col-12 col-lg-5">
						<div class="form-group">
							<label for="ruc_pp">RUC</label>
							<input type="text" class="form-control" id="ruc_pp" placeholder="Ruc" disabled>
						</div>
					</div>
					<div class="col-12 col-lg-5">
						<div class="form-group">
							<label for="proveedor_pp">Nombre Proveedor</label>
							<input type="text" class="form-control" id="proveedor_pp" placeholder="Proveedor" disabled>
						</div>
					</div>
					<div class="col-12 col-lg-2 d-flex justify-content-end align-items-center">
					    <button type="button" class="btn bg-info px-2 py-1 d-flex justify-content-center align-items-center color-white informacionModalidadPagoProveedor" data-tooltip="tooltip" aria-label="Nueva Modalidad de Pago" data-collapse="#ctnModalidadPagoProveedorModal" data-form="#formModalidadPagoProveedor" data-modal="#editarModalidadPagoProveedor" data-id="0" data-accion="crear">
                            <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i> Modalidad Pago
                        </button>
					</div>
				</div>
				<hr>
				<h3 class="mb-3">Modalidades de Pago</h3>
			    <div class="row m-0 mb-3">
			        <table id="tblModalidadPagoProveedor" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
			            <thead>
							<tr>
								<th class="text-center align-middle">Correlativo</th>
								<th class="text-center align-middle">Modalidad de Pago</th>
								<th class="text-center align-middle">Banco</th>
								<th class="text-center align-middle">Cuenta Bancaria</th>
								<th class="text-center align-middle">Cuenta Interbancaria</th>
								<th class="text-center align-middle">Moneda</th>
								<th class="text-center align-middle">Prioridad</th>
								<th class="text-center align-middle">Estado</th>
								<th class="text-center align-middle">Acciones</th>
							</tr>
						</thead>
						<tbody>
						</tbody>
			        </table>
			    </div>
				<hr>
			    <div class="row m-0 collapse mb-2 py-3 border-sistema-2px" id="ctnModalidadPagoProveedorModal" style="border-radius: 10px;">
    			    <form id="formModalidadPagoProveedor" class="formularioModalidadPagoProveedor" autocomplete="off" action="" method="POST" data-collapse="#ctnModalidadPagoProveedorModal">
    			        <span class="respuesta"></span>
    					<h3 class="mb-3" id="lblTituloMPPR" >Información Modalidad de Pago</h3>
                        <div class="card-text mb-3">
                            <input type="hidden" id="idproveedor_pp" name="idproveedor_pp">
                            <input type="hidden" id="idproveedorpago_pp" name="idproveedorpago_pp">
							<div class="form-group row">
								<div class="col-4">
									<label for="modalidadPago_pp">Modalidad de Pago</label>
									<select class="form-select" id="modalidadPago_pp" name="modalidadPago_pp" data-modal="editarModalidadPagoProveedor">
									</select>
								</div>
								<div class="col-4">
									<label for="banco_pp">Banco</label>
									<select class="form-select" id="banco_pp" name="banco_pp" data-modal="editarModalidadPagoProveedor">
									</select>
								</div>
								<div class="col-4">
									<label for="nrocuenta_pp">Número de Cuenta</label>
									<input type="text" class="form-control" id="nrocuenta_pp" name="nrocuenta_pp" placeholder="Número de Cuenta">
								</div>
							</div>
						</div>
						<div class="card-text mb-3">
							<div class="form-group row">
								<div class="col-3">
									<label for="cci_pp">CCI</label>
									<input type="text" class="form-control" id="cci_pp" name="cci_pp" placeholder="CCI">
								</div>
								<div class="col-3">
									<label for="moneda_pp">Moneda</label>
									<select class="form-select" id="moneda_pp" name="moneda_pp" data-modal="editarModalidadPagoProveedor">
									</select>
								</div>
								<div class="col-3">
									<label for="prioridad_pp">Prioridad</label>
									<input type="number" min="1" step="1" class="form-control" id="prioridad_pp" name="prioridad_pp" placeholder="Prioridad">
								</div>
								<div class="col-3 d-flex justify-content-between align-items-center">
                                    <button type="button" data-bs-toggle="collapse" href="#ctnModalidadPagoProveedorModal" class="btn bg-warning px-2 py-1 d-flex justify-content-center align-items-center color-white" >
                                        <i class="mdi mdi-minus-thick" style="font-size: 24px; color: #FFF"></i> Ocultar
                                    </button>
            					    <button type="submit" id="btnEjecutarModalidadPagoProveedor" class="btn bg-success px-2 py-1 ms-2 d-flex justify-content-center align-items-center color-white" >
                                        <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i> Agregar
                                    </button>
            					</div>
								<!--<div class="col-3 d-flex justify-content-end align-items-center">-->
								<!--    <button type="submit" class="btn bg-info px-2 py-1 ms-3 color-white d-flex justify-content-end align-items-center">-->
        <!--                                <i class="mdi mdi-save" style="font-size: 24px; color: #FFF"></i> Agregar -->
        <!--                            </button>-->
								<!--</div>-->
							</div>
						</div>
    			    </form>
    		    </div>
			</div>
			<div class="modal-footer justify-content-end">
				<button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cerrar</button>
			</div>
		</div>
	</div>
</div>

<?php $this->endSection(); ?>