<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
								<?php
								if (in_array("ADDMOD", $permisos)) 
								{
								?>
                                <button class="btn btn-primary datos-modulo" data-bs-toggle="modal" data-bs-target="#informacionModulo" data-id="0" data-accion="crear" id="crear-modulo">
									<i class="mdi mdi-plus-circle"></i> Agregar módulo
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="example" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Cabecera</th>
										<th class="text-center align-middle">Orden</th>
										<th class="text-center align-middle">Módulo</th>
										<th class="text-center align-middle">Ícono</th>
										<th class="text-center align-middle">Raíz</th>
										<th class="text-center align-middle">Observación</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaModulos as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDModulo'] ?></td>
										<td class="text-center align-middle"><?= $items['Cabecera'] ?></td>
										<td class="text-center align-middle"><?= $items['Orden'] ?></td>
										<td class="text-center align-middle"><?= $items['Modulo'] ?></td>
										<td class="text-center align-middle">
											<span class="<?= $items['Icono'] != '' ? $items['Icono'] : 'mdi mdi-home' ?>"></span>
										</td>
										<td class="text-center align-middle"><?= $items['Ruta'] ?></td>
										<td class="text-center align-middle"><?= $items['Observacion'] ?></td>
										<td class="text-center align-middle">
											<?php
											if (in_array("ESTMOD", $permisos)) 
											{
											?>
											<button class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0 cambiar-estado-modulo" data-estado="<?= $items['Estado'] ?>" data-id="<?= $items['IDModulo'] ?>">
												<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
											</button>
											<?php
											}
											else 
											{
											?>
											<span class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0">
												<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
											</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
													<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-modulo" data-bs-toggle="modal" data-bs-target="#informacionModulo" data-id="<?= $items['IDModulo'] ?>" data-accion="ver" id="ver-modulo">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPDMOD", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-modulo" data-bs-toggle="modal" data-bs-target="#informacionModulo" data-id="<?= $items['IDModulo'] ?>" data-accion="editar" id="editar-modulo">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													?>	
													<li>
														<a href="<?= $baseUrl ?>/listar-rutas-modulo/<?= $items['IDModulo'] ?>" class="dropdown-item">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Rutas
														</a>
													</li>
													<li>
														<a href="<?= $baseUrl ?>/listar-acciones-modulo/<?= $items['IDModulo'] ?>" class="dropdown-item">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Acciones
														</a>
													</li>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Información Marca -->
<div class="modal fade" id="informacionModulo" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionModulo" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionModulo">Información de módulo</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionModulo" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtCabecera_i" class="form-label">Cabecera</label>
								<select class="form-select" aria-label="Cabecera" id="txtCabecera_i" name="txtCabecera_i">
									<option selected="" value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtModulo_i" class="form-label">Módulo</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Módulo" id="txtModulo_i" name="txtModulo_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtOrden_i" class="form-label">Orden</label>
							<div class="input-group">
								<input type="number" class="form-control" min="1" aria-label="Orden" id="txtOrden_i" name="txtOrden_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtIcono_i" class="form-label">Clase ícono</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Ícono" id="txtIcono_i" name="txtIcono_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtObservacionModulo_i" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacionModulo_i" name="txtObservacionModulo_i" rows="3"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarModulo" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>