<?php
namespace App\Models;
use CodeIgniter\Model;

class RequerimientosMotivoModel extends Model
{
    protected $table        = 'requerimientos_motivos';
    protected $primaryKey   = 'IDMotivo';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDRequerimiento', 'Motivo', 'UsuarioResponsable', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerArea($idArea)
    {
        $this->select('estructura_area.IDArea,
            estructura_area.Area,
            estructura_area.IDDireccion,
            estructura_direccion.Direccion');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->where('estructura_area.IDArea', $idArea);

        $datos = $this->first();
        return $datos;
    }
    
    // public function listadoCargosSelect($variable)
    // {
    //     $this->select('IDCargo,
    //         Cargo,
    //         Categoria');
    //     $this->like("Cargo", $variable);
    //     $this->orLike("Categoria", $variable);
        
    //     $datos = $this->findAll();
    //     return $datos;
    // }
}