<?php namespace App\Models;

use CodeIgniter\Model;

class PerfilPermisosModel extends Model {
  protected $table = 'perfil_permisos';
  protected $primaryKey = 'IDPerfil';
  protected $allowedFields = ['IDPerfil', 'IDAccionModulo', 'UsuarioRegistra', 'FechaRegistra'];
  protected $useAutoIncrement = false;
  protected $useSoftDeletes = false;
  
  public function listarPermisosPerfil($idPerfil)
  {
      $this->select('modulos_acciones.IDAccionModulo,
        modulos_acciones.IDModulo, 
        modulos_acciones.Codigo, 
        modulos_acciones.Accion, 
        IF(perfil_permisos.IDPerfil IS NULL, 0, 1) AS "ACTIVO"');
      $this->join('modulos_acciones', 'perfil_permisos.IDAccionModulo = modulos_acciones.IDAccionModulo AND perfil_permisos.IDPerfil = "'.$idPerfil.'"', 'right');
      
      $datos = $this->findAll();
      return $datos;
  }
}
