<?php namespace App\Models;

use CodeIgniter\Model;

class ExternosProveedorModel extends Model {
    protected $table              = 'externos_proveedor';
    protected $primaryKey         = 'IDExterno';
    protected $allowedFields      = ['IDExterno', 'IDProveedor', 'UsuarioRegistra', 'FechaRegistra'];
    protected $useAutoIncrement   = false;
    protected $useSoftDeletes     = false;
    
    public function listadoExternosProveedor($idProveedor)
    {
        $this->select('externos_proveedor.IDExterno,
            externos_acceso.Nombres,
            externos_acceso.Apellidos,
            externos_acceso.NroDocumento,
            externos_acceso.NroContacto,
            externos_acceso.CorreoElectronico,
            externos_acceso.Cargo,
            externos_acceso.IDPerfil,
            externos_acceso.Estado,
            externos_proveedor.IDProveedor');
        $this->join('externos_acceso', 'externos_proveedor.IDExterno = externos_acceso.IDExterno', 'left');
        
        $this->where("externos_proveedor.IDProveedor", $idProveedor);
        
        $datos = $this->findAll();
        return $datos;
    }

}
