<?php
namespace App\Models;
use CodeIgniter\Model;

class EstructuraSubareaModel extends Model
{
    protected $DBGroup      = 'baseT';
    protected $table        = 'estructura_subarea';
    protected $primaryKey   = 'IDSubarea';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDArea', 'Subarea', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerSubareaXNombres($subarea, $area, $direccion)
    {
        $this->select('estructura_subarea.IDSubarea,
            estructura_subarea.Subarea,
            estructura_subarea_responsable.IDResponsable AS "Responsable_Subarea",
            estructura_subarea.IDArea,
            estructura_area.Area,
            estructura_area_responsable.IDResponsable AS "Responsable_Area",
            estructura_area.IDDireccion,
            estructura_direccion.Direccion,
            estructura_direccion_responsable.IDResponsable AS "Responsable_Direccion"');
        $this->join('estructura_subarea_responsable', 'estructura_subarea.IDSubarea = estructura_subarea_responsable.IDSubarea AND estructura_subarea_responsable.Principal="Y"', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_area_responsable', 'estructura_area.IDArea = estructura_area_responsable.IDArea AND estructura_area_responsable.Principal="Y"', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('estructura_direccion_responsable', 'estructura_direccion.IDDireccion = estructura_direccion_responsable.IDDireccion AND estructura_direccion_responsable.Principal="Y"', 'left');
        $this->where('estructura_subarea.Subarea', $subarea);
        $this->where('estructura_area.Area', $area);
        $this->where('estructura_direccion.Direccion', $direccion);

        $datos = $this->first();
        return $datos;
    }
    
    public function listadoSubarea($array)
    {
        $this->select('estructura_subarea.IDSubarea,
            estructura_subarea.Subarea,
            estructura_subarea_responsable.IDResponsable AS "Responsable_Subarea",
            estructura_subarea.IDArea,
            estructura_area.Area,
            estructura_area_responsable.IDResponsable AS "Responsable_Area",
            estructura_area.IDDireccion,
            estructura_direccion.Direccion,
            estructura_direccion_responsable.IDResponsable AS "Responsable_Direccion"');
        $this->join('estructura_subarea_responsable', 'estructura_subarea.IDSubarea = estructura_subarea_responsable.IDSubarea AND estructura_subarea_responsable.Principal="Y"', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_area_responsable', 'estructura_area.IDArea = estructura_area_responsable.IDArea AND estructura_area_responsable.Principal="Y"', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('estructura_direccion_responsable', 'estructura_direccion.IDDireccion = estructura_direccion_responsable.IDDireccion AND estructura_direccion_responsable.Principal="Y"', 'left');
        
        if(!empty($array))
        {
            if(isset($array['listadoID']) && !empty($array['listadoID']))
            {
                $this->whereIn('estructura_subarea.IDSubarea', $array['listadoID']);
            }
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function obtenerSubarea($idSubarea)
    {
        $this->select('estructura_subarea.IDSubarea,
            estructura_subarea.Subarea,
            estructura_subarea_responsable.IDResponsable AS "Responsable_Subarea",
            estructura_subarea.IDArea,
            estructura_area.Area,
            estructura_area_responsable.IDResponsable AS "Responsable_Area",
            estructura_area.IDDireccion,
            estructura_direccion.Direccion,
            estructura_direccion_responsable.IDResponsable AS "Responsable_Direccion"');
        $this->join('estructura_subarea_responsable', 'estructura_subarea.IDSubarea = estructura_subarea_responsable.IDSubarea AND estructura_subarea_responsable.Principal="Y"', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_area_responsable', 'estructura_area.IDArea = estructura_area_responsable.IDArea AND estructura_area_responsable.Principal="Y"', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('estructura_direccion_responsable', 'estructura_direccion.IDDireccion = estructura_direccion_responsable.IDDireccion AND estructura_direccion_responsable.Principal="Y"', 'left');
        $this->where('estructura_subarea.IDSubarea', $idSubarea);

        $datos = $this->first();
        return $datos;
    }
    
    public function listadoEstructuraDepartamentalTotal()
    {
        $this->select('estructura_subarea.IDSubarea,
            estructura_subarea.Subarea,
            estructura_subarea.IDArea,
            estructura_area.Area,
            estructura_area.IDDireccion,
            estructura_direccion.Direccion,
            GROUP_CONCAT(DISTINCT (CONCAT("[",CC,"-",LN,"]")) SEPARATOR "<br>") AS "Delegaciones"');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('estructura_subarea_delegacion', 'estructura_subarea.IDSubarea = estructura_subarea_delegacion.IDSubarea', 'left');
        $this->join('estructura_delegacion', 'estructura_subarea_delegacion.IDDelegacion = estructura_delegacion.IDDelegacion AND estructura_delegacion.Estado = "A"', 'left');
        
        $this->where('estructura_subarea.Estado', "A");
        $this->where('estructura_area.Estado', "A");
        $this->where('estructura_direccion.Estado', "A");
        
        $this->groupBy('estructura_subarea.IDSubarea');
        
        $datos = $this->findAll();
        return $datos;
    }
    
    // public function listadoCargosSelect($variable)
    // {
    //     $this->select('IDCargo,
    //         Cargo,
    //         Categoria');
    //     $this->like("Cargo", $variable);
    //     $this->orLike("Categoria", $variable);
        
    //     $datos = $this->findAll();
    //     return $datos;
    // }
}