<?php
    session_name();
    session_start();

    date_default_timezone_set('America/Lima');
    include 'config/db.php';
    include 'config/conexion.php';

    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
    	exit;
    }

?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
        <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
        <!-- daterange picker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-daterangepicker/daterangepicker.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap Color Picker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-colorpicker/dist/css/bootstrap-colorpicker.min.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <link href="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.css" rel="stylesheet" type="text/css"/>
        <!-- bootstrap wysihtml5 - text editor -->
        <link rel="stylesheet" href="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
        <link href="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.css" rel="stylesheet" type="text/css"/>
        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
        
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">

        <style>

            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;
            }

            .espacio{
                height:10px;
            }

            .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h3{
                margin-top: -10px;
                font-size:24px;
                /*font-weight:  bold;*/
            }

            .caption p{
                color:#777;
                font-size:13px;
                padding:0px 25px 0px 25px
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #myWizard2 .form-control{
                border-radius: 4px
            }

            #myWizard3 .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 400%;

            }

            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo {
                color: #FFFFFF;
                background-color: #444444;
                border-color: #444444;
            }

            .btn-nuevo:hover,
            .btn-nuevo:focus,
            .btn-nuevo:active,
            .btn-nuevo.active,
            .open .dropdown-toggle.btn-nuevo {
                color: #FFFFFF;
                background-color: #616161;
                border-color: #444444;
            }

            .btn-nuevo:active,
            .btn-nuevo.active,
            .open .dropdown-toggle.btn-nuevo {
                background-image: none;
            }

            .btn-nuevo.disabled,
            .btn-nuevo[disabled],
            fieldset[disabled] .btn-nuevo,
            .btn-nuevo.disabled:hover,
            .btn-nuevo[disabled]:hover,
            fieldset[disabled] .btn-nuevo:hover,
            .btn-nuevo.disabled:focus,
            .btn-nuevo[disabled]:focus,
            fieldset[disabled] .btn-nuevo:focus,
            .btn-nuevo.disabled:active,
            .btn-nuevo[disabled]:active,
            fieldset[disabled] .btn-nuevo:active,
            .btn-nuevo.disabled.active,
            .btn-nuevo[disabled].active,
            fieldset[disabled] .btn-nuevo.active {
                background-color: #444444;
                border-color: #444444;
            }

        </style>
        <style>
            .main-header,.main-sidebar,.left-side{position:fixed}

            .main-header {
                  top: 0;
                  right: 0;
                  left: 0
            }

           .content-wrapper,
           .right-side {
              padding-top: 50px
          }

          @media (max-width:767px) {
               .content-wrapper,
               .right-side {
                  padding-top: 100px
              }
          }

          .layout-boxed .wrapper {
              max-width: 100%
          }

          .wrapper {
              overflow: hidden

           .control-sidebar {
              position: fixed;
              height: 100%;
              overflow-y: auto;
              padding-bottom: 50px
          }
        </style>
        <style>
          html, body { margin: 0; padding: 0; height: 100%; }
        </style>
        <style>
            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                -moz-border-radius: 5px;
                border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);

                z-index: 1051 !important;

            }

            input[type="search"]::-webkit-search-cancel-button {
              -webkit-appearance: searchfield-cancel-button;
            }

        </style>
        
    </head>
    <body class="sidebar-collapse skin-red sidebar-mini">

        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php
            $marketing="active";
            $televenta= "active";
            include 'admin/main-sidebar.php';
            ?>
            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div style="font-size:180%;"> 
                    Zonificacion
                </div>
                <ol class="breadcrumb">
                    <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                    <li><a href="#">Ventas</a></li>
                    <li class="active">Zonificacion</li>
                </ol>
            </section>

            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-md-12">
                        <div class="box box-danger">
                            <div class="box-header">
                               <table  style="width:90%;">
                                    <tr>
                                        <td style="width: 7%;"><h3 class="box-title">BUSCAR:</h3></td>
                                        <td style="width: 83%;">
                                            <div class="input-group input-group-sm" style="width: 200px;">
                                                <input type="search" name="table_buscar" oninput="onFilterChanged(this.value)" class="form-control" placeholder="Buscar..">
                                                <!--<input type="text" name="table_buscar" id="BuscarProspecto" oninput="onFilterChanged(this.value)" class="form-control" placeholder="Buscar..">-->
                                            </div>
                                        </td>
                                    </tr>
                                </table>

                                <div class="box-tools pull-right">
                                    <button class="btn btn-danger btn-sm" data-toggle="modal" data-target="#modal-default" id="btnNuevaMicroZona"><i class="fa fa-plus"></i> Nueva Zonificacion</button>
                                    <!--<button type="button" id="btnBuscarProspecto"  class="btn btn-default btn-sm">Ver Todo</button>-->
                                    <!--
                                    <button type="submit" class="btn btn-danger btn-sm" style="border-radius: 0px;" data-toggle="modal" data-target="#modal-default" id="d"><i class="fa fa-plus"></i> Nueva TV</button>
                                    -->
                                </div>
                            </div>
                            <!-- /.box-header -->
                            <!--box-body -->
                            <div class="box-body" id="vistaboy">
                                <div id="myGrid"  style="height: 100%" class="ag-theme-fresh"></div>
                                <div  id="ningunresultado"></div>
                            </div>
                            <!-- /.box-body -->

                        </div>
                        <!-- /.box -->
                    </div>
                </div>
            </section>
            <!-- /.content -->
            
            <!-- Modal -->
            <div class="modal fade" id="modal-default">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h3 id="Titulo">REGISTRAR ZONIFICACION</h3>
                        </div>
                        <div class="modal-body">
                            <div class="form-horizontal">
                                <div class="form-group">
                                    <label for="microzona" class="col-sm-4 control-label">Microzona</label>
                
                                    <div class="col-sm-6">
                                        <input type="text" class="form-control" id="microzona" placeholder="Microzona" >
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="distrito" class="col-sm-4 control-label">Distrito</label>
                
                                    <div class="col-sm-6">
                                        <input type="text" class="form-control" id="distrito" placeholder="Distrito">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="zona" class="col-sm-4 control-label">Zona</label>
                
                                    <div class="col-sm-6">
                                        <input type="text" class="form-control" id="zona" placeholder="Zona">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="codDelegacion" class="col-sm-4 control-label">Codigo Delegación</label>
                
                                    <div class="col-sm-6">
                                        <select class="form-control select2" id="codDelegacion" placeholder="Codigo Delegacion">
                                            <option val="" disabled selected>Seleccione</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="nombreDelegacion" class="col-sm-4 control-label">Nombre Delegacion</label>
                
                                    <div class="col-sm-6">
                                        <input type="text" class="form-control" id="nombreDelegacion" placeholder="Nombre Delegacion" disabled>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="delegado" class="col-sm-4 control-label">Delegado</label>
                
                                    <div class="col-sm-6">
                                        <input type="text" class="form-control" id="delegado" placeholder="Delegado" disabled>
                                        <input type="hidden" id="matriculaDelegado">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <input type="hidden" id="idZonificacion">
                            <button type="submit" id="btnGuardar"  class="btn btn-danger btn-sm"><i class="fa fa-cart-plus"></i> Guardar</button>
                            <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                        </div>
                        </div>
                    
                </div>
            </div>
            <!-- /.modal -->
        </div>
            <!-- /.content-wrapper -->
            <div class="control-sidebar-bg"></div>
        </div>
        <!-- ./wrapper -->
        <!-- jQuery v1.11 -->
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>$.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
        <!-- jQuery Knob Chart -->
        <script src="admin/bower_components/jquery-knob/dist/jquery.knob.min.js"></script>
        <!-- Bootstrap WYSIHTML5 -->
        <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
        <!-- date-range-picker -->
        <script src="admin/bower_components/moment/min/moment.min.js"></script>
        <script src="admin/bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap color picker -->
        <script src="admin/bower_components/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js"></script>
        <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- SweetAlert -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <!-- VARIABLES -->
        <script>
            var arregloDatos;
            
            const arregloDelegaciones = [
                    {codDelegacion: '150', Delegacion: 'Surco', Matricula: 'BK8947', Delegado: 'BORIS MURGA RAMOS'},
                    {codDelegacion: '151', Delegacion: 'Lima Sur', Matricula: 'HA6658', Delegado: 'HECTOR VIGO QUIROZ'},
                    {codDelegacion: '152', Delegacion: 'Lima Este', Matricula: 'CD4231', Delegado: 'CRISTHIAN CUNEO COLINA'},
                    {codDelegacion: '153', Delegacion: 'Lima Centro', Matricula: 'C37264', Delegado: 'CESAR AUGUSTO ALMEIDA'},
                    {codDelegacion: '154', Delegacion: 'Miraflores', Matricula: 'DF3030', Delegado: 'DAVID  ADELL MORILLA'},
                    {codDelegacion: '155', Delegacion: 'Lima Norte', Matricula: 'F45995', Delegado: 'FERNANDO JAVIER VERA'},
                    {codDelegacion: '156', Delegacion: 'Lima Oeste', Matricula: 'J20612', Delegado: 'JUAN TORREGROSA ARIZA'},
                    {codDelegacion: '152-JVD', Delegacion: 'La Molina', Matricula: 'JD9721', Delegado: 'JUAN UGAZ CAMPUSAN'},
                    {codDelegacion: '153-JVD', Delegacion: 'Lince', Matricula: 'J36506', Delegado: 'JAHIR GOICOCHEA GOICOCHEA'},
                    {codDelegacion: '155-JVD', Delegacion: 'Callao', Matricula: 'MJ4599', Delegado: 'MICHAEL CASTILLO REQUIS'},
                    {codDelegacion: 'Zona No Coberturada', Delegacion: 'Zona No Coberturada', Matricula: 'Zona No Coberturada', Delegado: 'Zona No Coberturada'}
                ];
                
            let editando;
                
        </script>
        <!-- SCRIPT AG-GRID PRINCIPAL-->
        <script>
            var columnDefs = [
                {
                    headerName: '',
                    field: 'IdZonificacion',
                    width: 40,
                    pinned: 'left',
                    cellRenderer: function (params) {
                        
                        return `
                            <a class="fa fa-edit editar-zona" href="#" data-Id="${params.value}" title="Editar" style="text-decoration:none;color:#4c4c4c"></a>
                        `
                    }
                },
                {headerName: 'Microzona', field: 'Microzona', width: 110, pinned: 'left'},
                {headerName: 'Distrito', field: 'Distrito', width: 110, pinned: 'left'},
                {headerName: 'Zona', field: 'Zona', width: 110, pinned: 'left'},
                {headerName: 'CodigoDelegacion', field: 'CodigoDelegacion', width: 180, pinned: 'left'},
                {headerName: 'NombreDelegacion', field: 'NombreDelegacion', width: 180, pinned: 'left'},
                {headerName: 'Delegado', field: 'Delegado', width: 250, pinned: 'left'}
            ];

            var gridOptions = {
                    columnDefs: columnDefs,
                    onPaginationChanged: onPaginationChanged,
                    rowData: null,
                    enableFilter: true,
                    enableColResize: true,
                    localeText: {
                        // for filter panel
                        page: 'página',
                        more: 'Más',
                        to: 'a',
                        of: 'de',
                        next: 'Siguiente',
                        last: 'Último',
                        first: 'Primero',
                        previous: 'Anterior',
                        loadingOoo: 'Cargando...',
                        // for set filter
                        selectAll: 'Seleccionar todo',
                        searchOoo: 'Buscando...',
                        blanks: 'Espacios en blanco',
                        // for number filter and text filter
                        filterOoo: 'Filtrar...',
                        applyFilter: 'Aplicar Filtro',
                        // for number filter
                        equals: 'Igual',
                        notEqual: 'No es igual',
                        lessThanOrEqual: 'Menor o igual',
                        greaterThanOrEqual: 'Mayor que o igual',
                        inRange: 'En el rango',
                        lessThan: 'Menos que',
                        greaterThan: 'Mas grande que',
                        // for text filter
                        contains: 'Contiene',
                        startsWith: 'Comienza con',
                        endsWith: 'Termina con',
                        notContains:'No contiene',
                        // the header of the default group column
                        group: 'Grupo',
                        // tool panel
                        columns: 'columnas',
                        rowGroupColumns: 'Grupo columnas',
                        rowGroupColumnsEmptyMessage: 'No hay resultado',
                        valueColumns: 'Columna de valor',
                        pivotMode: 'Modo pivote',
                        groups: 'grupos',
                        values: 'valor',
                        pivots: 'pivote',
                        valueColumnsEmptyMessage: 'No hay resultado',
                        pivotColumnsEmptyMessage: 'No hay resultado',
                        // other
                        noRowsToShow: '<div class="callout callout-danger">\n\
                        <span class="pull-left">\n\
                        <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
                        </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
                        <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
                        <br></div>',
                        // enterprise menu
                        pinColumn: 'Aclar columna',
                        valueAggregation: 'Agregar valor',
                        autosizeThiscolumn: 'Auto tamaño esta columna ',
                        autosizeAllColumns: 'Auto tamaño todas columnas',
                        groupBy: 'Agrupar',
                        ungroupBy: 'Agrupar uno',
                        resetColumns: 'Restaurar Columnas',
                        expandAll: 'expandir todo',
                        collapseAll: 'desplegar todo',
                        toolPanel: 'Panel de Heramientas',
                        export: 'Exportar',
                        csvExport: 'Exportar CSV',
                        excelExport: 'Exportar Excel',
                        // enterprise menu pinning
                        pinLeft: 'Anclar a derecha',
                        pinRight: 'Anclar a izquierda',
                        noPin: 'Desanclar',
                        // enterprise menu aggregation and status panel
                        sum: 'Sumar',
                        min: 'Minimo',
                        max: 'Maximo',
                        first: 'Primero',
                                last: 'Ultimo',
                                none: 'Nada',
                        count: 'Contador',
                        average: 'Promedio',
                        // standard menu
                        copy: 'Copiar',
                        copyWithHeaders: 'Copiar Cabecera',
                        ctrlC: 'Ctrl+C',
                        paste: 'Pegar',
                        ctrlV: 'Ctrl+V'
                    },
                    enableSorting: true,
                    accentedSort: true
                    //rowData: [{ accented: 'Alta' }, { accented: 'Media' }, { accented: 'Baja' }],
                };

            function onPaginationChanged(params) {
                this.gridRowCount = params.api.paginationGetRowCount();
                $("#count").html(this.gridRowCount);
            }

            function onFilterChanged(value) {
                gridOptions.api.setQuickFilter(value);
            }

            function listar() {
                
                var gridDiv = document.querySelector('#myGrid');
                new agGrid.Grid(gridDiv, gridOptions);
                
                agGrid.simpleHttpRequest({
                    url:'ajax/selectListarZonificacion.php'
                }).then(function (data) {
                    arregloDatos = data.datos;
                    gridOptions.api.setRowData(data.datos);
                });
                
                $('#vistaboy').height(function (index, height) {
                  return $(window).height() * 65 / 100;
                });
            }
            
            function refresh(){
                
                var gridDiv = document.querySelector('#myGrid');
                agGrid.simpleHttpRequest(
                {
                  url:'ajax/selectListarZonificacion.php'
                }).then(function (data) {
                    arregloDatos = data.datos;
                    gridOptions.api.setRowData(data.datos);
                });
                
                $('#vistaboy').height(function (index, height) {
                    return $(window).height() * 65 / 100;
                });
                $("#ningunresultado").hide("fast");
                $('#myGrid').show(200);
            }  

            var cambio=function(){
                $('#vistaboy').height(function (index, height) {
                    return $(window).height() * 65 / 100;
                });
            }

        </script>
        <!-- DOCUMENT READY -->
        <script>
            $(document).ready(function () {
                listar();
                
                generarCodDelegacion();
          }); 
        </script>
        <!-- EVENT LISTENERS -->
        <script>
            $('#vistaboy').on('click', (e) => {
                
                e.preventDefault();
                
                if (e.target.classList.contains('editar-zona')) {
                    const idZonificacion = e.target.getAttribute('data-id');
                    
                    for(let objZona of arregloDatos){
                        
                        if(objZona.IdZonificacion === idZonificacion){
                            $('#microzona').val(objZona.Microzona);
                            $('#distrito').val(objZona.Distrito);
                            $('#zona').val(objZona.Zona);
                            $('#codDelegacion').val(objZona.CodigoDelegacion);
                            $('#nombreDelegacion').val(objZona.NombreDelegacion);
                            $('#delegado').val(objZona.Delegado);
                            $('#matriculaDelegado').val(objZona.MatriculaDelegado);
                            $('#idZonificacion').val(idZonificacion);
                            
                            let texto = `ACTUALIZAR ZONIFICACION - ${objZona.Microzona}`;
                            $('#Titulo').text(texto);
                            
                            $('#microzona').prop('disabled', true);
                            $('#distrito').prop('disabled', true);
                            $('#nombreDelegacion').prop('disabled', true);
                            $('#delegado').prop('disabled', true);
                            
                            editando = true;
                    
                            break;
                        }
                    }
                    
                    $("#modal-default").modal("show");
                }
                
            })
            
            $('#modal-default').on('hide.bs.modal', function (e) {
                  limpiarFormulario();
            })
            
            $('#btnGuardar').on('click', () => {
                
                if(validarFormulario()){
                    if(editando){
                        let datos = {
                            tipo: 'update',
                            idZonificacion: $('#idZonificacion').val(),
                            zona: $('#zona').val(),
                            codDelegacion: $('#codDelegacion').val(),
                            nombreDelegacion: $('#nombreDelegacion').val(),
                            matriculaDelegado: $('#matriculaDelegado').val()
                        }
                        
                        $.ajax({
                            type: 'POST',
                            url: 'ajax/insertUpdateZonificacion.php',
                            data: datos,
                            dataType: 'Json',
                            success: function (data) {
                                console.log(data);
                                if(data.respuesta == 'Exito'){
                                    imprimirAlerta('exito', 'Zona Actualizada', 'Se actualizo la zona correctamente');
                                    limpiarFormulario();
                                    refresh();
                                } else if (data.respuesta == 'SinCambios') {
                                    imprimirAlerta('alerta', 'Alerta!', 'No se realizarón cambios.');
                                } else {
                                    imprimirAlerta('error');
                                }
                            }
                        })
                        
                        $("#modal-default").modal("hide");
                        
                        editando=false;
                    } else {
                        
                    }
                } 
            })
            
            $('#codDelegacion').on('change', () => {
                let codDelegacion = $('#codDelegacion').val();
                
                for(let objDelegacion of arregloDelegaciones){
                    if (codDelegacion === objDelegacion.codDelegacion){
                        $('#nombreDelegacion').val(objDelegacion.Delegacion);
                        $('#matriculaDelegado').val(objDelegacion.Matricula);
                        $('#delegado').val(objDelegacion.Delegado);
                    }
                }
            })
            
        </script>
        <!-- FUNCIONES -->
        <script>
            function generarCodDelegacion(){
                for(let objDeleegaciones of arregloDelegaciones){
                    $("#codDelegacion").append(new Option(objDeleegaciones.codDelegacion, objDeleegaciones.codDelegacion));
                }
            }
        
            function limpiarFormulario(){
                $('#Titulo').text("REGISTRAR ZONIFICACION");
                
                $('#microzona').val('');
                $('#distrito').val('');
                $('#zona').val('');
                $('#codDelegacion').val('');
                $('#nombreDelegacion').val('');
                $('#delegado').val('');
                $('#matriculaDelegado').val('');
                $('#idZonificacion').val('');
                
                $('#microzona').prop('disabled', false);
                $('#distrito').prop('disabled', false);
            }
            
            function validarFormulario(){
                if($('#microzona').val() === ''){
                    imprimirAlerta('error');
                    return false;
                }
                if($('#distrito').val() === ''){
                    imprimirAlerta('error');
                    return false;
                }
                if($('#zona').val() === '' ){
                    imprimirAlerta('error');
                    return false;
                }
                if($('#codDelegacion').val()===''){
                    imprimirAlerta('error');
                    return false;
                }
                if($('#nombreDelegacion').val()===''){
                    imprimirAlerta('error');
                    return false;
                }
                if($('#delegado').val()===''){
                    imprimirAlerta('error');
                    return false;
                }
                return true;
            }
            
            function imprimirAlerta(tipo, cabezera, mensaje){
                if(tipo === 'error'){
                    Swal.fire(
                      `error!`,
                      `Ocurrió un error, por favor vuelva a intentar o comuniquese con soporte`,
                      `error`
                    )
                } else if(tipo === 'exito'){
                    Swal.fire(
                      `${cabezera}`,
                      `${mensaje}`,
                      `success`
                    )
                } else {
                    Swal.fire(
                      `${cabezera}`,
                      `${mensaje}`,
                      `warning`
                    )
                }
            }
        </script>

    </body>
</html>
