<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
    	exit;
    }
    
if ($_SESSION['pzvtatc']==0) {
    header("location: ./denegado.php");
    exit;
}

date_default_timezone_set('America/Lima');
include 'config/db.php';
include 'config/conexion.php';

?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">

        <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">

        <!-- daterange picker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-daterangepicker/daterangepicker.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap Color Picker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-colorpicker/dist/css/bootstrap-colorpicker.min.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <!-- Bootsrap Toogle -->
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>

        <link href="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.css" rel="stylesheet" type="text/css"/>
        <!-- bootstrap wysihtml5 - text editor -->
        <link rel="stylesheet" href="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">

        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

        <link href="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.css" rel="stylesheet" type="text/css"/>

        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">

        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
        
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">

        <style>

            .callout {
                border-radius: 3px;
                margin: 0 0 20px 0;
                padding: 15px;
                border-left: 0px solid #eee;
            }


            @font-face {
                font-family: 'fontello';
                src: url('./font/fontello.eot?11113651');
                src: url('./font/fontello.eot?11113651#iefix') format('embedded-opentype'),
                url('./font/fontello.woff?11113651') format('woff'),
                url('./font/fontello.ttf?11113651') format('truetype'),
                url('./font/fontello.svg?11113651#fontello') format('svg');
                font-weight: normal;
                font-style: normal;
            }

            .demo-icon {
                font-family: "fontello";
                font-style: normal;
                font-weight: normal;
                /* speak: none; */
                display: inline-block;
                text-decoration: inherit;
                width: 1em;
                margin-right: .1em;
                text-align: center;
                /* opacity: .8; */
                font-variant: normal;
                text-transform: none;
                line-height: 1.7em;
                margin-left: .1em;
                /* font-size: 120%; */
                -webkit-font-smoothing: antialiased;
                -moz-osx-font-smoothing: grayscale;
                /* text-shadow: 1px 1px 1px rgba(127, 127, 127, 0.3); */
            }

        
            .thumbnail .caption {
                padding: 0px;
                color: #333;
                margin-bottom: 0px; 
            }

            .modal-header-success {
                color:#fff;
                background-color: #008d4c;              
            }
            .modal-header-danger {
                color:#fff;
                background-color: #fb1e1e;              
            }

            @media (min-height: 500px) {
              /*  .modal-body { height: 550px; }*/
            }

            @media (min-height: 800px) {
               /*  .modal-body { height: 550px; }*/
            }
            

            .espacio{
                height:10px;
            }

            .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }
            .bg-gray {
                color: #666;
                background-color: #eeeeee !important;
            }

            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #myWizard2 .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: 0;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }


            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo { 
                color: #FFFFFF; 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                color: #FFFFFF; 
                background-color: #616161;  
                border-color: #444444; 
            } 

            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                background-image: none; 
            } 

            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
                background-color: #444444; 
                border-color: #444444; 
            } 
            
            .btn-nuevo2 { 
                color: #444444;
                background-color: #eeeeee;
                border-color: #d2d6de;
            } 


            .btn-nuevo2:hover, 
            .btn-nuevo2:focus, 
            .btn-nuevo2:active, 
            .btn-nuevo2.active, 
            .open .dropdown-toggle.btn-nuevo2 { 
              color: #FFFFFF; 
              background-color: #616161; 
              border-color: #444444; 
            } 
 
            .btn-nuevo2:active, 
            .btn-nuevo2.active, 
            .open .dropdown-toggle.btn-nuevo2 { 
              background-image: none; 
            } 
             
            .btn-nuevo2.disabled, 
            .btn-nuevo2[disabled], 
            fieldset[disabled] .btn-nuevo2, 
            .btn-nuevo2.disabled:hover, 
            .btn-nuevo2[disabled]:hover, 
            fieldset[disabled] .btn-nuevo2:hover, 
            .btn-nuevo2.disabled:focus, 
            .btn-nuevo2[disabled]:focus, 
            fieldset[disabled] .btn-nuevo2:focus, 
            .btn-nuevo2.disabled:active, 
            .btn-nuevo2[disabled]:active, 
            fieldset[disabled] .btn-nuevo2:active, 
            .btn-nuevo2.disabled.active, 
            .btn-nuevo2[disabled].active, 
            fieldset[disabled] .btn-nuevo2.active { 
              background-color: #444444; 
              border-color: #444444; 
            } 
 
            .btn-nuevo2 .badge { 
              color: #444444; 
              background-color: #FFFFFF; 
            }
            
             .btn-nuevo3 {
                color: #fb1e1e;
                background-color: #ffffff;
                border-color: #d2d6de;
            }
            
            .btn-nuevo3:hover, 
            .btn-nuevo3:focus, 
            .btn-nuevo3:active, 
            .btn-nuevo3.active, 
            .open .dropdown-toggle.btn-nuevo3 { 
              color: #FFFFFF; 
              background-color: #dddddd; 
              border-color: #dddddd; 
              
            } 
             
            .btn-nuevo3:active, 
            .btn-nuevo3.active, 
            .open .dropdown-toggle.btn-nuevo3 { 
              background-image: none; 
            } 
             
            .btn-nuevo3.disabled, 
            .btn-nuevo3[disabled], 
            fieldset[disabled] .btn-nuevo3, 
            .btn-nuevo3.disabled:hover, 
            .btn-nuevo3[disabled]:hover, 
            fieldset[disabled] .btn-nuevo3:hover, 
            .btn-nuevo3.disabled:focus, 
            .btn-nuevo3[disabled]:focus, 
            fieldset[disabled] .btn-nuevo3:focus, 
            .btn-nuevo3.disabled:active, 
            .btn-nuevo3[disabled]:active, 
            fieldset[disabled] .btn-nuevo3:active, 
            .btn-nuevo3.disabled.active, 
            .btn-nuevo3[disabled].active, 
            fieldset[disabled] .btn-nuevo3.active { 
              background-color: #444444; 
              border-color: #444444; 
            } 
 


        </style>
        <style>
            .main-header,.main-sidebar,.left-side{position:fixed}
       
            .main-header {
            top: 0;
            right: 0;
            left: 0
            }
            .content-wrapper,
            .right-side {
            padding-top: 50px
            }
            
            @media (max-width:767px) {
            .content-wrapper,
            .right-side {
            padding-top: 100px
            }
            }
            
            .layout-boxed .wrapper {
            max-width: 100%
            }
            
            .wrapper {
            overflow: hidden
            
            .control-sidebar {
            position: fixed;
            height: 100%;
            overflow-y: auto;
            padding-bottom: 50px
            }       
        </style>
        <style> html, body { margin: 0; padding: 0; height: 100%; } </style>
        <style>

            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                -moz-border-radius: 5px;
                border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);

                z-index: 1051 !important;    

            }

            input[type="search"]::-webkit-search-cancel-button {
                -webkit-appearance: searchfield-cancel-button;
            }

        </style>
    <style>
        .modal-header-danger{color:#fff;background-color:#e4002b}.modal-header-success{color:#fff;background-color:#008d4c}@media (min-height:500px){.modal-body .regtv{height:500px}}@media (min-height:800px){.modal-body .regtv{height:500px}}.modal-body .regtv{width:100%;height:500px}.espacio{height:10px}.espacio2{height:15px}.thumbnail_style{text-align:center;border:none}.caption h3{margin-top:-10px;font-size:24px}.caption p{color:#777;font-size:13px;padding:0px 25px 0px 25px}.caption a{color:#777;font-size:10px}#myWizard2 .form-control{border-radius:4px}#c-slider{margin:auto;width:100%;max-width:900px;position:relative;overflow:hidden}#slider{display:flex;width:300%}#slider section{width:100%}.btn-nuevo{color:#fff;background-color:#444;border-color:#444}.btn-nuevo.active,.btn-nuevo:active,.btn-nuevo:focus,.btn-nuevo:hover,.open .dropdown-toggle.btn-nuevo{color:#fff;background-color:#616161;border-color:#444}.btn-nuevo.active,.btn-nuevo:active,.open .dropdown-toggle.btn-nuevo{background-image:none}.btn-nuevo.disabled,.btn-nuevo.disabled.active,.btn-nuevo.disabled:active,.btn-nuevo.disabled:focus,.btn-nuevo.disabled:hover,.btn-nuevo[disabled],.btn-nuevo[disabled].active,.btn-nuevo[disabled]:active,.btn-nuevo[disabled]:focus,.btn-nuevo[disabled]:hover,fieldset[disabled] .btn-nuevo,fieldset[disabled] .btn-nuevo.active,fieldset[disabled] .btn-nuevo:active,fieldset[disabled] .btn-nuevo:focus,fieldset[disabled] .btn-nuevo:hover{background-color:#444;border-color:#444}
        .left-side,.main-header,.main-sidebar{position:fixed}.main-header{top:0;right:0;left:0;z-index:1000}.content-wrapper,.right-side{padding-top:50px;}@media (max-width:767px){.content-wrapper,.right-side{padding-top:100px;}}.layout-boxed .wrapper{max-width:100%}.wrapper{overflow:hidden;height:100%;overflow-y:auto;}
        html,body{margin:0;padding:0;height:100%}
        .ui-autocomplete{position:absolute;z-index:1000;cursor:default;padding:0;margin-top:2px;list-style:none;font-size:11px;font-family:"Helvetica Neue",Helvetica,Arial,sans-serif;background-color:#fff;border:1px solid #ccc;-webkit-border-radius:5px;-moz-border-radius:5px;border-radius:5px;-webkit-box-shadow:0 5px 10px rgba(0,0,0,.2);-moz-box-shadow:0 5px 10px rgba(0,0,0,.2);box-shadow:0 5px 10px rgba(0,0,0,.2);z-index:1051!important}input[type=search]::-webkit-search-cancel-button{-webkit-appearance:searchfield-cancel-button}.pagination>.active>a,.pagination>.active>a:focus,.pagination>.active>a:hover,.pagination>.active>span,.pagination>.active>span:focus,.pagination>.active>span:hover{z-index:3;color:#222d32;cursor:default;background-color:#c1c1c1;border-color:#ddd}.backpack-filter label{color:#868686;font-weight:600;text-transform:uppercase}.navbar-filters{min-height:25px;border-radius:0;margin-bottom:6px;margin-top:0;background:0 0;border-color:#f4f4f4;border:none}.navbar-filters .navbar-collapse{padding:0;border:0}.navbar-filters .navbar-toggle{padding:10px 15px;border-radius:0}.navbar-filters .navbar-brand{height:25px;padding:5px 15px;font-size:14px;text-transform:uppercase}@media (min-width:768px){.navbar-filters .navbar-nav>li>a{padding-top:5px;padding-bottom:5px}}@media (max-width:768px){.navbar-filters .navbar-nav{margin:0}}.navbar-filters .navbar-nav>.active>a,.navbar-filters .navbar-nav>.active>a:focus,.navbar-filters .navbar-nav>.active>a:hover,.navbar-filters .navbar-nav>.open>a,.navbar-filters .navbar-nav>.open>a:focus,.navbar-filters .navbar-nav>.open>a:hover,.navbar-filters li>a:active{background-color:#e4e7ea;border-radius:3px}.navbar-filters li{margin:0 2px}.navbar-filters li>a{border-radius:2px}.navbar-filters .nav.navbar-nav{float:none}.pb-0,.py-0{padding-bottom:0!important}.pt-0,.py-0{padding-top:0!important}.mb-0,.my-0{margin-bottom:0!important}.p-0{padding:0!important}.m-b-0{margin-bottom:0!important}.select2-container--default .select2-selection--single{border:1px solid #d2d6de;font-size:12px;padding:4px 6px}.select2-container--default .select2-selection--multiple .select2-selection__choice{color:#333}.input-group.date{width:320px;max-width:100%}.daterangepicker .dropdown-menu{z-index:3001!important}.select2-container--default .select2-search--dropdown .select2-search__field,.select2-container--default.select2-container--focus .select2-selection--multiple{border-color:#aaa!important}.form-inline .select2-container{display:inline-block}.select2-drop-active{border:none}.select2-container .select2-choice,.select2-container .select2-choices,.select2-container .select2-choices .select2-search-field input{border:none}.select2-container-active .select2-choice{border:none;box-shadow:none}.select2-container--default .select2-dropdown{margin-top:-2px;margin-left:-1px}.navbar-collapse.in{overflow-y:visible}.d-none{display:none!important}@media (min-width:992px){.d-lg-block{display:block!important}}@media (min-width:992px){.navbar-expand-lg .navbar-toggler{display:none}}.navbar-toggler{padding:.25rem .75rem;font-size:1.25rem;background-color:transparent;border:1px solid transparent;}.whiteinput{background-color:#fff!important;}
        .callout{border-radius:3px;margin:0 0 20px 0;padding:15px;border-left:0px solid #eee}.swal2-popup{font-size:1.5rem!important}.swal2-styled.swal2-confirm{background-color:#e4002b!important}
        .ocultar {display: none;}
    </style>
    
    <style>
        .swal2-html-container{
            text-align: justify!important;
        }
    </style>

    </head>


    <body class="sidebar-collapse skin-red sidebar-mini">

        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php

            //$configamp="active";
            //$amp="active";
    
                include 'admin/main-sidebar.php';
            ?>


            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                        <div style="font-size:180%;"> TELECIERRE &nbsp <span style="font-size:80%;color:#DAD8D4"> | &nbsp <span style="font-size:80%;color:#8D8A80"> GENERAL </span></span> </div> 
                        <ol class="breadcrumb">
                            <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                            <li><a href="ventadc511.php">Ventas</a></li>
                            <li class="active">Registro de Venta</li>
                        </ol>
                </section>
    
                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="box box-danger">
                                <div class="box-header">
                                    <table  style="width:90%;">
                                        <tr>
                                            <td style="width: 7%;"><h3 class="box-title">TELEFONO o PROSPECTO:</h3></td>
                                            <td style="width: 83%;">
                                                <div filter-name="BUSCAR" filter-type="text" class="input-group input-group-sm" style="width: 200px;">
                                                    <input type="text" name="lblmatriculausuario" value="<?php echo $matriculausuario;?>" hidden="" id="lblmatriculausuario" >
                                                    <input type="text" name="lblperfilusuario" value="<?php echo $nombacceso;?>" hidden="" id="lblperfilusuario" >
                                                    <input type="text" name="lblnombreusuario" value="<?php echo $nombreusuario;?>" hidden="" id="lblnombreusuario" >
                                                    
                                                    <input type="search" name="text-filter-BUSCAR" id="text-filter-BUSCAR" type="text"  value="" class="form-control" placeholder="">
    
                                                    <div class="input-group-btn">
                                                         <button type="button" id="btn-buscar" class="btn btn-default"><i class="fa fa-search"></i></button>
                                                    </div>
                                                </div>
                                            </td>
                                            
                                        </tr>
                                        <tr><td colspan="2">Total Registros: <span id="counttotal"></span></td></tr> 
                                        <tr><td colspan="2">Registros por página: <span id="count"></span></td></tr>
                                        <tr class="selectrow"><td colspan="2">N° Seleccionados: <span id="countselectedRows">0</span></td></tr>
                                    </table>
                                    <div class="box-tools pull-right">
                                         <a class="btn btn-nuevo btn-sm"  href="#" style="border-radius: 0px;" onclick="javascript:window.location.reload();"><i class="fa fa-refresh"></i></a>
                                    </div>
                                </div>
                                <!-- /.box-header -->
    
                                <div class="box-body" id="vistaboy">
                                 <nav class="navbar navbar-default navbar-filters">
                                    <div class="container-fluid">
                                      <!-- Brand and toggle get grouped for better mobile display -->
                                
                                      
                                      <div class="navbar-header navbar-expand-lg">
                                          
                                            <a class="nav-item d-none d-lg-block navbar-brand"><span class="fa fa-filter"></span></a>
                                          <button class="navbar-toggler navbar-brand" type="button" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-controls="bs-example-navbar-collapse-1" aria-expanded="false" aria-label="Toggle filters">
                                            <span class="fa fa-filter"></span> Filtros
                                          </button>
                                
                                    </div>
                                
                                      <!-- Collect the nav links, forms, and other content for toggling -->
                                      <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                                        <ul class="nav navbar-nav">
                                          <!-- THE ACTUAL FILTERS -->
                                        <li filter-name="TELEFONO" filter-type="text" class="dropdown">
                                        	<a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">TELEFONO <span class="caret"></span></a>
                                        	<div class="dropdown-menu p-0">
                                        		<div class="form-group backpack-filter m-b-0">
                                        			<div class="input-group">
                                        		        <input class="form-control pull-right" id="text-filter-TELEFONO" type="text" value="">
                                        		        <div class="input-group-addon text-filter-TELEFONO-clear-button">
                                        		          <a class="" href="#"><i class="fa fa-times"></i></a>
                                        		        </div>
                                        		    </div>
                                        		</div>
                                        	</div>
                                        </li>                                          
                                        <li filter-name="ESTADOVENTA" filter-type="select2_multiple" class="nav-item dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">ESTADOVENTA <span class="caret"></span></a>
                                            <div class="dropdown-menu p-0">
                                              <div class="form-group backpack-filter m-b-0">
                                        			<select id="filter_ESTADOVENTA" name="filter_ESTADOVENTA" class="form-control input-sm select2" placeholder="" multiple>
                                                      <option value="AgendadaTEC">AgendadaTEC</option>
                                                      <option value="Cancelada">Cancelada</option>
                                                      <option value="Desmontada">Desmontada</option>
                                                      <option value="Facturada">Facturada</option>
                                                      <option value="Ilocalizable">Ilocalizable</option>
                                                      <option value="Incidencia">Incidencia</option>
                                                      <option value="Instalada">Instalada</option>
                                                      <option value="NoDoc">NoDoc</option>
                                                      <option value="NoVendida">NoVendida</option>
                                                      <option value="PorFacturar">PorFacturar</option>
                                                      <option value="Postergada">Postergada</option>
                                                      <option value="VAsignada">VAsignada</option>
                                        			</select>
                                        		</div>
                                            </div>
                                          </li>
                                        <li filter-name="ESTADOTC" filter-type="select2_multiple" class="nav-item dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">ESTADOTC <span class="caret"></span></a>
                                            <div class="dropdown-menu p-0">
                                              <div class="form-group backpack-filter m-b-0">
                                        			<select id="filter_ESTADOTC" name="filter_ESTADOTC" class="form-control input-sm select2" placeholder="" multiple>
                                                        <option value="Contactado">Contactado</option>
                                                        <option value="ContactadoSinGestion">ContactadoSinGestion</option>
                                                        <option value="DevolverLlamada">DevolverLlamada</option>
                                                        <option value="Ficha">Ficha</option>
                                                        <option value="NoContactado">NoContactado</option>
                                                        <option value="NoVendida">NoVendida</option>
                                                        <option value="NoVisitado">NoVisitado</option>
                                                        <option value="Online">Online</option>
                                                        <option value="PendienteRespuesta">PendienteRespuesta</option>
                                        			</select>
                                        		</div>
                                            </div>
                                          </li>
                                        <li filter-name="FECHAHORATRANSFERENCIATC" filter-type="date_range" class="dropdown">
                                        	<a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">FECHAHORATRANSFERENCIATC <span class="caret"></span></a>
                                        	<div class="dropdown-menu p-0">
                                        		<div class="form-group backpack-filter m-b-0">
                                        			<div class="input-group date">
                                        		        <div class="input-group-addon">
                                        		          <i class="fa fa-calendar"></i>
                                        		        </div>
                                        		        <input class="form-control pull-left whiteinput" id="daterangepicker-FECHAHORATRANSFERENCIATC" type="text" readonly>
                                        		        <div class="input-group-addon daterangepicker-FECHAHORATRANSFERENCIATC-clear-button">
                                        		          <a class="" href=""><i class="fa fa-times"></i></a>
                                        		        </div>
                                        		    </div>
                                        		</div>
                                        	</div>
                                        </li>                                          
                                        <li filter-name="TCGESTOR" filter-type="select2_multiple" class="nav-item dropdown">
                                            <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">TCGESTOR<span class="caret"></span></a>
                                            <div class="dropdown-menu p-0">
                                              <div class="form-group backpack-filter m-b-0">
                                        			<select id="filter_TCGESTOR" name="filter_TCGESTOR" class="form-control input-sm select2" placeholder="" multiple>
                                        			</select>
                                        		</div>
                                            </div>
                                          </li>

                                        <li filter-name="PRUEBA" filter-type="text" class="dropdown"></li>                                          
                                        <li><a href="#" id="remove_filters_button" class="hidden"><i class="fa fa-eraser"></i> Remover Filtros</a></li>
                                        </ul>
                                      </div><!-- /.navbar-collapse -->
                                    </div><!-- /.container-fluid -->
                                  </nav>                                    
                                    <div id="myGrid" style="height: 480px" class="ag-theme-fresh"></div>
                                    <div  id="ningunresultado"></div>
                                </div>
                                <!-- /.box-body -->
                                <div class="box-footer clearfix">
                                    <ul class="pagination pagination-sm no-margin pull-right" id="paginador"></ul>
                                </div>                                
                            </div>
                            <!-- /.box -->
                        </div>
                    </div>
                    <div class="test-header" style="display:none"><span id="selectedRows"></span></div>
                </section>
                <!-- /.content -->
                <!-- /.modal -->
            </div>
            <!-- /.content-wrapper -->
            <div class="control-sidebar-bg"></div>
            
        </div>
        <!-- ./wrapper -->


        <!-- jQuery v1.11 -->

        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>$.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>

        <!-- jQuery Knob Chart -->
        <script src="admin/bower_components/jquery-knob/dist/jquery.knob.min.js"></script> 
        <!-- Bootstrap WYSIHTML5 -->
        <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>


        <script src="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.js" type="text/javascript"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>

        <!-- date-range-picker -->
        <script src="admin/bower_components/moment/min/moment.min.js"></script>
        <script src="admin/bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap color picker -->
        <script src="admin/bower_components/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js"></script>
        <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- SweetAlert -->
        <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <!-- GLOBALES -->
        <script>
            const perfilUsuario = $('#headerPerfilUsuario').val();
        </script>
        <script>
        
            $('#cboGestorCALLMultiple').select2({
                placeholder: "Seleccionar Gestor",
                multiple: true,
                ajax: {
                    url: "ajax/selectGestor.php",
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data, params) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });
            
            $('#cbotipoAsignacion').on('change', function(){
                if($(this).val() == 'manual'){
                    $('.selectManual').removeClass('ocultar');
                    $('.selectAuto').addClass('ocultar');
                } else {
                    $('.selectManual').addClass('ocultar');
                    $('.selectAuto').removeClass('ocultar');
                }
            })
            /*
            $('#cboGestorCALLMultiple').select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder'),
	        	                    language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {

                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectGestor.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });
            */
        </script>
        <!--GRID GESTOR Y SUPERVISOR-->
        <script>
        var paginador;
		var totalPaginas;
		var itemsPorPagina = 50;
		var numerosPorPagina = 8;
		var filterscount=0;
	    var cadena='';
	    
            var columnDefs = [
                {
                    headerName: '',
                    field: 'IdVenta',
                    width: 40,
                    pinned: 'left',
                    cellRenderer: function (params) {
                        return '<a class="fa fa-edit" href="editartelecierre.php?idventa=' + params.value + '&rc=All" title="Editar" style="text-decoration:none;color:#4c4c4c"></a>';
                    }
                },
                {headerName: 'FECHAHORATRANSFERENCIATC', field: 'FechaHoraTransferenciaTC', width: 210},         
                {headerName: 'ESTADOTC', field: 'EstadoTelecierre', width: 110, pinned: 'left'},
                {headerName: 'ESTADOVENTA', field: 'EstadoVenta', width: 130, pinned: 'left'},
                {
                    headerName: 'RECURSO', 
                    field: 'TipoVenta', 
                    width: 100, 
                    pinned: 'left',
                    cellRenderer: function (params) {
                        if (params.value == 'RE') {
                            return "<div style='text-align: center;'><span class='label label-primary'>" + params.value + "</span></div>";
                        } else {
                            return "<div style='text-align: center;'><span class='label label-danger'>" + params.value + "</span></div>";
                        }
                    }
                },
                {headerName: 'DC', field: 'DC', width: 60},
                {headerName: 'FECHAVISITA', field: 'FechaVisita', width: 120},
                {headerName: 'HORAVISITA', field: 'HoraVisita', width: 120},
                {headerName: 'VENCIMIENTOVISITA', field: 'FVencimientoVisita', width: 130},
                {
                    headerName: 'CHECKIN', 
                    field: 'Checkin', 
                    width: 110,
                    cellRenderer: function (params) {
                        if (params.value == 'SI') {
                            return "<div style='text-align: center;'><i class='fa fa-map-marker' style='color:#f12208 !important;'></div>";
                        } else {
                            return "<div style='text-align: center;'><i class='fa fa-map-marker' style='color:#989898 !important;'></div>";
                        }
                    }
                },
                {
                    headerName: 'VnoV', 
                    field: 'VisitaNoVisitable', 
                    width: 110,
                    cellRenderer: function (params) {
                        if (params.value == 'SI') {
                            return "<div style='text-align: center;'><i class='fa fa-check' style='color:#f12208 !important;'></div>";
                        } else {
                            return "<div style='text-align: center;'><i class='fa fa-check' style='color:#989898 !important;'></div>";
                        }
                    }
                },
                {headerName: 'TCGESTOR', field: 'TCGestor', width: 110},
                {headerName: 'MATRICULA', field: 'Matricula', width: 110},
                {headerName: 'COMERCIAL', field: 'Comercial', width: 250},
                {headerName: 'SEGMENTO', field: 'Segmento', width: 130},
                {headerName: 'PROSPECTO', field: 'NProspecto', width: 120},
                {headerName: 'TELEFONO UNO', field: 'Telefonouno', width: 120},
                {headerName: 'TELEFONO DOS', field: 'Telefonodos', width: 120},
                {headerName: 'CONTRATO', field: 'NContrato', width: 110},
                {headerName: 'CLIENTE', field: 'Cliente', width: 250},
                {headerName: 'INSTX', field: 'InstaladoX', width: 80},
                {headerName: 'FECHAINST', field: 'FechaInst', width: 110},
                {headerName: 'HORAINST', field: 'HoraInst', width: 110}
            ];
            
            var gridOptions = {
                columnDefs: columnDefs,
                onPaginationChanged: onPaginationChanged,
                rowData: null,
                enableFilter: true,
                enableColResize: true,
                localeText: {
                    // for filter panel
                    page: 'página',
                    more: 'Más',
                    to: 'a',
                    of: 'de',
                    next: 'Siguiente',
                    last: 'Último',
                    first: 'Primero',
                    previous: 'Anterior',
                    loadingOoo: 'Cargando...',
                    // for set filter
                    selectAll: 'Seleccionar todo',
                    searchOoo: 'Buscando...',
                    blanks: 'Espacios en blanco',
                    // for number filter and text filter
                    filterOoo: 'Filtrar...',
                    applyFilter: 'Aplicar Filtro',
                    // for number filter
                    equals: 'Igual',
                    notEqual: 'No es igual',
                    lessThanOrEqual: 'Menor o igual',
                    greaterThanOrEqual: 'Mayor que o igual',
                    inRange: 'En el rango',
                    lessThan: 'Menos que',
                    greaterThan: 'Mas grande que',
                    // for text filter
                    contains: 'Contiene',
                    startsWith: 'Comienza con',
                    endsWith: 'Termina con',
                    notContains:'No contiene',
                    // the header of the default group column
                    group: 'Grupo',
                    // tool panel
                    columns: 'columnas',
                    rowGroupColumns: 'Grupo columnas',
                    rowGroupColumnsEmptyMessage: 'No hay resultado',
                    valueColumns: 'Columna de valor',
                    pivotMode: 'Modo pivote',
                    groups: 'grupos',
                    values: 'valor',
                    pivots: 'pivote',
                    valueColumnsEmptyMessage: 'No hay resultado',
                    pivotColumnsEmptyMessage: 'No hay resultado',
                    // other
                    noRowsToShow: '<div class="callout callout-danger">\n\
                                    <span class="pull-left">\n\
                                    <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
                                    </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
                                    <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
                                    <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
                                    <br></div>',
                    // enterprise menu
                    pinColumn: 'Aclar columna',
                    valueAggregation: 'Agregar valor',
                    autosizeThiscolumn: 'Auto tamaño esta columna ',
                    autosizeAllColumns: 'Auto tamaño todas columnas',
                    groupBy: 'Agrupar',
                    ungroupBy: 'Agrupar uno',
                    resetColumns: 'Restaurar Columnas',
                    expandAll: 'expandir todo',
                    collapseAll: 'desplegar todo',
                    toolPanel: 'Panel de Heramientas',
                    export: 'Exportar',
                    csvExport: 'Exportar CSV',
                    excelExport: 'Exportar Excel',
                    // enterprise menu pinning
                    pinLeft: 'Anclar a derecha',
                    pinRight: 'Anclar a izquierda',
                    noPin: 'Desanclar',
                    // enterprise menu aggregation and status panel
                    sum: 'Sumar',
                    min: 'Minimo',
                    max: 'Maximo',
                    first: 'Primero',
                            last: 'Ultimo',
                            none: 'Nada',
                    count: 'Contador',
                    average: 'Promedio',
                    // standard menu
                    copy: 'Copiar',
                    copyWithHeaders: 'Copiar Cabecera',
                    ctrlC: 'Ctrl+C',
                    paste: 'Pegar',
                    ctrlV: 'Ctrl+V'
                },
                enableSorting: true
            };
            

            function onPaginationChanged(params) {
                this.gridRowCount = params.api.paginationGetRowCount();
                $("#count").html(this.gridRowCount);
            }
            
            function onFilterChanged(value) {
                
                    gridOptions.api.setQuickFilter(value);
                
                
            }

           
            function listar(pagenum) {
                var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                
                new agGrid.Grid(gridDiv, gridOptions);
                
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            }
            
            function refresh(){
                var pagenum= $(".pagination").find("li.active .page_link").html().valueOf()-1;
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,false);
            }          
            
            function creaPaginador(totalItems){
            	$(".pagination li").remove();
    			paginador = $(".pagination");
    			totalPaginas = Math.ceil(totalItems/itemsPorPagina);
    			$('<li><a href="#" class="first_link"><i class="fa fa-angle-double-left"></i></a></li>').appendTo(paginador);
    			if(totalPaginas>1){
    			$('<li><a href="#" class="prev_link"><i class="fa fa-angle-left"></i></a></li>').appendTo(paginador);
    			}
    			var pag = 0;
    			while(totalPaginas > pag){
    				$('<li><a href="#" class="page_link">'+(pag+1)+'</a></li>').appendTo(paginador);
    				pag++;
    			}
    
    			if(numerosPorPagina > 1){
    				$(".page_link").hide();
    				$(".page_link").slice(0,numerosPorPagina).show();
    			}
    			if(totalPaginas>1){
    				$('<li><a href="#" class="next_link"><i class="fa fa-angle-right"></i></a></li>').appendTo(paginador);
    			}
    			$('<li><a href="#" class="last_link"><i class="fa fa-angle-double-right"></i></a></li>').appendTo(paginador);
    
    			paginador.find(".page_link:first").addClass("active");
    			paginador.find(".page_link:first").parents("li").addClass("active");
    
    			paginador.find(".prev_link").hide();
    
    			paginador.find("li .page_link").click(function()
    			{
    				var irpagina =$(this).html().valueOf()-1;
    				cargaPagina(irpagina);
    				return false;
    			});
    
    			paginador.find("li .first_link").click(function()
    			{
    				var irpagina=0;
    				cargaPagina(irpagina);
    				return false;
    			});
    
    			paginador.find("li .prev_link").click(function()
    			{
    				var irpagina =parseInt(paginador.data("pag")) -1;
    				cargaPagina(irpagina);
    				return false;
    			});
    
    			paginador.find("li .next_link").click(function()
    			{
    				var irpagina =parseInt(paginador.data("pag")) +1;
    				cargaPagina(irpagina);
    				return false;
    			});
    
    			paginador.find("li .last_link").click(function()
    			{
    				var irpagina =totalPaginas -1;
    				cargaPagina(irpagina);
    				return false;
    			});
    
    			//cargaPagina(0);

		    }
		    
	        function cargaPagina(pagina){
	    
	            var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagina,cadena,false);
               
    			if(pagina>= 1){
    				paginador.find(".prev_link").show();
    			}else{
    				paginador.find(".prev_link").hide();
    			}
    			if(pagina <(totalPaginas- numerosPorPagina)){
    				paginador.find(".next_link").show();
    			}else{
    				paginador.find(".next_link").hide();
    			}
    			paginador.data("pag",pagina);
    
    			if(numerosPorPagina>1){
    				$(".page_link").hide();
    				if(pagina < (totalPaginas- numerosPorPagina)){
    					$(".page_link").slice(pagina,numerosPorPagina + pagina).show();
    				}else{
    					if(totalPaginas > numerosPorPagina){
    						$(".page_link").slice(totalPaginas- numerosPorPagina).show();
    					}else{
    						$(".page_link").slice(0).show();
    					}
    
    				}
    			}
    			paginador.children().removeClass("active");
    			paginador.children().eq(pagina+2).addClass("active");


		    }
		
            function cambio(){
                $('#vistaboy').height(function (index, height) {
                return $(window).height() * 65 / 100;
                });
            
            }
        </script>
        <!--FILTROS Y CONFIGURACION GRID-->
        <script>

              function normalizeAmpersand(string) {
                return string.replace(/&amp;/g, "&").replace(/amp%3B/g, "");
              }
      
      function Urlcadena(){
                var cadena=new Object();
			    var filterscount=0;
                var registro=[];

                var valueTELEFONO=$("#text-filter-TELEFONO").val();
                var valueESTADOVENTA=$("#filter_ESTADOVENTA").val();
                var valueESTADOTC=$("#filter_ESTADOTC").val();
                var valueFECHAHORATRANSFERENCIATC=$("#daterangepicker-FECHAHORATRANSFERENCIATC").val();
                var valueTCGESTOR=$("#filter_TCGESTOR").val();

                var valueBUSCAR=$("#text-filter-BUSCAR").val();
                cadena['sortdatafield']='FechaVisita';
                cadena['sortorder']='desc'; 



                if(valueTELEFONO!==''){
                    registro.push({nombrecampo:'Telefonouno',valor:valueTELEFONO,condicion:'EQUAL',operador:0});
                }

            
                if(valueESTADOVENTA!==null){
                     for(var i=0;i<valueESTADOVENTA.length;i++){
                          registro.push({nombrecampo:'EstadoVenta',valor:valueESTADOVENTA[i],condicion:'EQUAL',operador:1});   
                     }
                }
                if(valueESTADOTC!==null){
                     for(var i=0;i<valueESTADOTC.length;i++){
                          registro.push({nombrecampo:'EstadoTelecierre',valor:valueESTADOTC[i],condicion:'EQUAL',operador:1});   
                     }
                }                 
                if(valueFECHAHORATRANSFERENCIATC!==''){
                    var separador = " - ",
                    arrFECHAHORATRANSFERENCIATC = valueFECHAHORATRANSFERENCIATC.split(separador);
                    registro.push({nombrecampo:'FechaHoraTransferenciaTC',valor:arrFECHAHORATRANSFERENCIATC[0].replace(new RegExp("/","g"),"-"),condicion:'GREATER_THAN_OR_EQUAL_TIME',operador:0});
                    registro.push({nombrecampo:'FechaHoraTransferenciaTC',valor:arrFECHAHORATRANSFERENCIATC[1].replace(new RegExp("/","g"),"-"),condicion:'LESS_THAN_OR_EQUAL_TIME',operador:0});
                }
                if(valueTCGESTOR!==null){
                     for(var i=0;i<valueTCGESTOR.length;i++){
                          registro.push({nombrecampo:'TCGestor',valor:valueTCGESTOR[i],condicion:'EQUAL',operador:1});   
                     }
                }
               
                
                if(valueBUSCAR!==''){

                    registro.push({nombrecampo:'Telefonouno',valor:valueBUSCAR,condicion:'CONTAINS',operador:2});
                    registro.push({nombrecampo:'Telefonodos',valor:valueBUSCAR,condicion:'CONTAINS',operador:2});
                    registro.push({nombrecampo:'NProspecto',valor:valueBUSCAR,condicion:'CONTAINS',operador:2});
                    registro.push({nombrecampo:'NContrato',valor:valueBUSCAR,condicion:'CONTAINS',operador:2});
                   
                }
                
                

                if(registro.length>0){
                    for(i=0;i<registro.length;i++){
                    cadena['filtervalue'+i]=registro[i].valor;
                    cadena['filtercondition'+i]=registro[i].condicion;
                    cadena['filterdatafield'+i]=registro[i].nombrecampo;
                    cadena['filteroperator'+i]=registro[i].operador;  
                    }    
                
                    $('#remove_filters_button').removeClass('hidden');
                }
                cadena['filterscount']=registro.length;
                 return cadena;
      }
      
      function ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,activoPaginador){
                gridOptions.api.showLoadingOverlay();

                var objpagina={
                    array:'array7',
                    pagesize:itemsPorPagina,
                    pagenum:pagenum
                }
                var datos = {...objpagina, ...cadena};
                
                 $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    url: 'Controller/ControllerTelecierre.php',
                    data:{function: JSON.stringify(datos)},
                    success: function (r) {
                    if (r[0].tipo == 0){
                          $("#ningunresultado").html(r[0].mensaje);
                          $("#ningunresultado").show("200");
                          $('#myGrid').hide("fast");
                          $("#counttotal").html(r[0].TotalRows);
                          $('#paginador').hide("fast");
                            gridOptions.api.setRowData(r[0].Rows);                        
                    } else {
                        $('#myGrid').show(200);
                        $('#paginador').show(200);
                        $("#ningunresultado").hide("fast");
                        gridOptions.api.setRowData(r[0].Rows);                         
                          if(activoPaginador==true){
                          creaPaginador(r[0].TotalRows);
                          paginador.data("pag",pagenum);
                          }
                          $("#counttotal").html(r[0].TotalRows);
                    }
                       
                   }
                   
               });
            }
      
      // botón para eliminar todos los filtros
      jQuery(document).ready(function($) {
      	$("#remove_filters_button").click(function(e) {
      		e.preventDefault();
		    	// comportamiento por ajax
            	var pagenum=0;

                var cadena=new Object();
                cadena['sortdatafield']='FechaVisita';
                cadena['sortorder']='desc';
                cadena['filterscount']=0;				    
			    
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
  				// borrar todos los filtros
  				$(".navbar-filters li[filter-name]").trigger('filter:clear');
      	    });

        // hide the Remove filters button when no filter is active
        $(".navbar-filters li[filter-name]").on('filter:clear', function() {
          var anyActiveFilters = false;
          $(".navbar-filters li[filter-name]").each(function () {
              
            if ($(this).hasClass('active')) {
              anyActiveFilters = true;

            }
          });

          if (anyActiveFilters == false) {
            $('#remove_filters_button').addClass('hidden');
          }
        });
      
        $('select[name=filter_ESTADOLEAD]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder')
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });

	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=ESTADOLEAD]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=ESTADOLEAD]").removeClass("active");
						//$("li[filter-name=ESTADOLEAD]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=ESTADOLEAD]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=ESTADOLEAD]").on('shown.bs.dropdown', function () {
					$('#filter_ESTADOLEAD').select2('open');
				});

				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=ESTADOLEAD]").on('filter:clear', function(e) {
					$("li[filter-name=ESTADOLEAD]").removeClass('active');
	                $('#filter_ESTADOLEAD').val(null).trigger('change.select2');
	                //$("li[filter-name=ESTADOLEAD] .select2").select2("val", "");
				});

 //Filtro IDLEAD
			$('#text-filter-IDLEAD').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				if (value!='') {
					$('li[filter-name=IDLEAD]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=IDLEAD]').trigger('filter:clear');
				}
		
			});
			$('li[filter-name=IDLEAD]').on('filter:clear', function(e) {
				$('li[filter-name=IDLEAD]').removeClass('active');
				$('#text-filter-IDLEAD').val('');
			});
			// Limpiar button IDLEAD
			$(".text-filter-IDLEAD-clear-button").click(function(e) {
				e.preventDefault();
				$('li[filter-name=IDLEAD]').trigger('filter:clear');
				$('#text-filter-IDLEAD').val('');
				$('#text-filter-IDLEAD').trigger('change');
			});	
				
				
//GESTION
        $('select[name=filter_GESTION]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder')
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });
	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=GESTION]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=GESTION]").removeClass("active");
						//$("li[filter-name=GESTION]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=GESTION]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=GESTION]").on('shown.bs.dropdown', function () {
					$('#filter_GESTION').select2('open');
				});

				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=GESTION]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
					$("li[filter-name=GESTION]").removeClass('active');
	                $('#filter_GESTION').val(null).trigger('change.select2');
	                //$("li[filter-name=GESTION] .select2").select2("val", "");
				});


//Filtro CAMPAÑA
    $('select[name=filter_CAMPAÑA]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder')
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });
	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=CAMPAÑA]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=CAMPAÑA]").removeClass("active");
						//$("li[filter-name=CAMPAÑA]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=CAMPAÑA]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=CAMPAÑA]").on('shown.bs.dropdown', function () {
					$('#filter_CAMPAÑA').select2('open');
				});
				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=CAMPAÑA]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
					$("li[filter-name=CAMPAÑA]").removeClass('active');
	                $('#filter_CAMPAÑA').val(null).trigger('change.select2');
	                //$("li[filter-name=CAMPAÑA] .select2").select2("val", "");
				});



			    //Filtro NOMBRES
			$('#text-filter-NOMBRES').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				if (value!='') {
					$('li[filter-name=NOMBRES]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=NOMBRES]').trigger('filter:clear');
				}
		
			});
			$('li[filter-name=NOMBRES]').on('filter:clear', function(e) {
				$('li[filter-name=NOMBRES]').removeClass('active');
				$('#text-filter-NOMBRES').val('');
			});
			// Limpiar button NOMBRES
			$(".text-filter-NOMBRES-clear-button").click(function(e) {
				e.preventDefault();
				$('li[filter-name=NOMBRES]').trigger('filter:clear');
				$('#text-filter-NOMBRES').val('');
				$('#text-filter-NOMBRES').trigger('change');
			});				


			    //Filtro APELLIDOS
			$('#text-filter-APELLIDOS').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				if (value!='') {
					$('li[filter-name=APELLIDOS]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=APELLIDOS]').trigger('filter:clear');
				}
		
			});
			$('li[filter-name=APELLIDOS]').on('filter:clear', function(e) {
				$('li[filter-name=APELLIDOS]').removeClass('active');
				$('#text-filter-APELLIDOS').val('');
			});
			// Limpiar button APELLIDOS
			$(".text-filter-APELLIDOS-clear-button").click(function(e) {
				e.preventDefault();
				$('li[filter-name=APELLIDOS]').trigger('filter:clear');
				$('#text-filter-APELLIDOS').val('');
				$('#text-filter-APELLIDOS').trigger('change');
			});

			    //Filtro TELEFONO
			$('#text-filter-TELEFONO').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				if (value!='') {
					$('li[filter-name=TELEFONO]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=TELEFONO]').trigger('filter:clear');
				}
		
			});
			$('li[filter-name=TELEFONO]').on('filter:clear', function(e) {
				$('li[filter-name=TELEFONO]').removeClass('active');
				$('#text-filter-TELEFONO').val('');
			});
			// Limpiar button TELEFONO
			$(".text-filter-TELEFONO-clear-button").click(function(e) {
				e.preventDefault();
				$('li[filter-name=TELEFONO]').trigger('filter:clear');
				$('#text-filter-TELEFONO').val('');
				$('#text-filter-TELEFONO').trigger('change');
			});

			    //Filtro TELEFONO_2
			$('#text-filter-TELEFONO_2').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				if (value!='') {
					$('li[filter-name=TELEFONO_2]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=TELEFONO_2]').trigger('filter:clear');
				}
		
			});
			$('li[filter-name=TELEFONO_2]').on('filter:clear', function(e) {
				$('li[filter-name=TELEFONO_2]').removeClass('active');
				$('#text-filter-TELEFONO_2').val('');
			});
			// Limpiar button TELEFONO_2
			$(".text-filter-TELEFONO_2-clear-button").click(function(e) {
				e.preventDefault();
				$('li[filter-name=TELEFONO_2]').trigger('filter:clear');
				$('#text-filter-TELEFONO_2').val('');
				$('#text-filter-TELEFONO_2').trigger('change');
			});

	    //Filtro ORIGEN
			$('#text-filter-ORIGEN').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				if (value!='') {
					$('li[filter-name=ORIGEN]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=ORIGEN]').trigger('filter:clear');
				}
		
			});
			$('li[filter-name=ORIGEN]').on('filter:clear', function(e) {
				$('li[filter-name=ORIGEN]').removeClass('active');
				$('#text-filter-ORIGEN').val('');
			});
			// Limpiar button ORIGEN
			$(".text-filter-ORIGEN-clear-button").click(function(e) {
				e.preventDefault();
				$('li[filter-name=ORIGEN]').trigger('filter:clear');
				$('#text-filter-ORIGEN').val('');
				$('#text-filter-ORIGEN').trigger('change');
			});

			    //Filtro LEADID
			$('#text-filter-LEADID').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				if (value!='') {
					$('li[filter-name=LEADID]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=LEADID]').trigger('filter:clear');
				}
		
			});
			$('li[filter-name=LEADID]').on('filter:clear', function(e) {
				$('li[filter-name=LEADID]').removeClass('active');
				$('#text-filter-LEADID').val('');
			});
			// Limpiar button LEADID
			$(".text-filter-LEADID-clear-button").click(function(e) {
				e.preventDefault();
				$('li[filter-name=LEADID]').trigger('filter:clear');
				$('#text-filter-LEADID').val('');
				$('#text-filter-LEADID').trigger('change');
			});			

	    //Filtro DEPARTAMENTO
			$('#text-filter-DEPARTAMENTO').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				if (value!='') {
					$('li[filter-name=DEPARTAMENTO]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=DEPARTAMENTO]').trigger('filter:clear');
				}
		
			});
			$('li[filter-name=DEPARTAMENTO]').on('filter:clear', function(e) {
				$('li[filter-name=DEPARTAMENTO]').removeClass('active');
				$('#text-filter-DEPARTAMENTO').val('');
			});
			// Limpiar button DEPARTAMENTO
			$(".text-filter-DEPARTAMENTO-clear-button").click(function(e) {
				e.preventDefault();
				$('li[filter-name=DEPARTAMENTO]').trigger('filter:clear');
				$('#text-filter-DEPARTAMENTO').val('');
				$('#text-filter-DEPARTAMENTO').trigger('change');
			});

	    //Filtro PROVINCIA
			$('#text-filter-PROVINCIA').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				if (value!='') {
					$('li[filter-name=PROVINCIA]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=PROVINCIA]').trigger('filter:clear');
				}
		
			});
			$('li[filter-name=PROVINCIA]').on('filter:clear', function(e) {
				$('li[filter-name=PROVINCIA]').removeClass('active');
				$('#text-filter-PROVINCIA').val('');
			});
			// Limpiar button PROVINCIA
			$(".text-filter-PROVINCIA-clear-button").click(function(e) {
				e.preventDefault();
				$('li[filter-name=PROVINCIA]').trigger('filter:clear');
				$('#text-filter-PROVINCIA').val('');
				$('#text-filter-PROVINCIA').trigger('change');
			});

		    //Filtro DISTRITO
			$('#text-filter-DISTRITO').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				if (value!='') {
					$('li[filter-name=DISTRITO]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=DISTRITO]').trigger('filter:clear');
				}
		
			});
			$('li[filter-name=DISTRITO]').on('filter:clear', function(e) {
				$('li[filter-name=DISTRITO]').removeClass('active');
				$('#text-filter-DISTRITO').val('');
			});
			// Limpiar button DISTRITO
			$(".text-filter-DISTRITO-clear-button").click(function(e) {
				e.preventDefault();
				$('li[filter-name=DISTRITO]').trigger('filter:clear');
				$('#text-filter-DISTRITO').val('');
				$('#text-filter-DISTRITO').trigger('change');
			});


			    //Filtro OBSERVACIONES
			$('#text-filter-OBSERVACIONES').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				if (value!='') {
					$('li[filter-name=OBSERVACIONES]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=OBSERVACIONES]').trigger('filter:clear');
				}
		
			});
			$('li[filter-name=OBSERVACIONES]').on('filter:clear', function(e) {
				$('li[filter-name=OBSERVACIONES]').removeClass('active');
				$('#text-filter-OBSERVACIONES').val('');
			});
			// Limpiar button OBSERVACIONES
			$(".text-filter-OBSERVACIONES-clear-button").click(function(e) {
				e.preventDefault();
				$('li[filter-name=OBSERVACIONES]').trigger('filter:clear');
				$('#text-filter-OBSERVACIONES').val('');
				$('#text-filter-OBSERVACIONES').trigger('change');
			});


//Filtro SEGMENTO
    $('select[name=filter_SEGMENTO]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder')
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });
	                    
	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=SEGMENTO]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=SEGMENTO]").removeClass("active");
						//$("li[filter-name=SEGMENTO]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=SEGMENTO]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=SEGMENTO]").on('shown.bs.dropdown', function () {
					$('#filter_SEGMENTO').select2('open');
				});
				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=SEGMENTO]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
					$("li[filter-name=SEGMENTO]").removeClass('active');
	                $('#filter_SEGMENTO').val(null).trigger('change.select2');
	                //$("li[filter-name=SEGMENTO] .select2").select2("val", "");
				});


          //Filtro FECHAHORATRANSFERENCIATC
        	function applyDateRangeFilterFECHAHORATRANSFERENCIATC(start, end) {
          			if (start && end) {
          				var dates = {
        					'from': start.format('YYYY-MM-DD'),
        					'to': end.format('YYYY-MM-DD')
        				};
        				var value = JSON.stringify(dates);
          			} else {
          				//this change to empty string,because addOrUpdateUriParameter method just judgment string
          				var value = '';
          			}
        
        			// mark this filter as active in the navbar-filters
        			if (value!=='') {
        				$('li[filter-name=FECHAHORATRANSFERENCIATC]').removeClass('active').addClass('active');
        			}
        			else
        			{
        				$('li[filter-name=FECHAHORATRANSFERENCIATC]').trigger('filter:clear');
        			}
        			
        			
          		}

			var dateRangeInput = $('#daterangepicker-FECHAHORATRANSFERENCIATC').daterangepicker({
				timePicker: false,
		        ranges: {
		            'Today': [moment().startOf('day'), moment().endOf('day')],
		            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
		            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
		            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
		            'This Month': [moment().startOf('month'), moment().endOf('month')],
		            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
		        },
				alwaysShowCalendars: true,
				autoUpdateInput: false
			});

			dateRangeInput.on('apply.daterangepicker', function(ev, picker) {
			applyDateRangeFilterFECHAHORATRANSFERENCIATC(picker.startDate, picker.endDate);
			$(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
				var pagenum=0;
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
			});
			/*
            dateRangeInput.on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });
            */
			
			$('li[filter-name=FECHAHORATRANSFERENCIATC]').on('hide.bs.dropdown', function () {
				if($('.daterangepicker').is(':visible'))
			    return false;
			});

			$('li[filter-name=FECHAHORATRANSFERENCIATC]').on('filter:clear', function(e) {
				// console.log('daterangepicker filter cleared');
				//if triggered by remove filters click just remove active class,no need to send ajax
				$('li[filter-name=FECHAHORATRANSFERENCIATC]').removeClass('active');
				$(this).val('');
				$('#daterangepicker-FECHAHORATRANSFERENCIATC').val('');
			});

			// datepicker clear button
			$(".daterangepicker-FECHAHORATRANSFERENCIATC-clear-button").click(function(e) {
				e.preventDefault();
				applyDateRangeFilterFECHAHORATRANSFERENCIATC(null, null);
				$('li[filter-name=FECHAHORATRANSFERENCIATC]').trigger('filter:clear');
				var pagenum=0;
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
			})


          //Filtro FECHAREGISTRO
        	function applyDateRangeFilterFECHAREGISTRO(start, end) {
          			if (start && end) {
          				var dates = {
        					'from': start.format('YYYY-MM-DD'),
        					'to': end.format('YYYY-MM-DD')
        				};
        				var value = JSON.stringify(dates);
          			} else {
          				//this change to empty string,because addOrUpdateUriParameter method just judgment string
          				var value = '';
          			}
        
        			// mark this filter as active in the navbar-filters
        			if (value!=='') {
        				$('li[filter-name=FECHAREGISTRO]').removeClass('active').addClass('active');
        			}
        			else
        			{
        				$('li[filter-name=FECHAREGISTRO]').trigger('filter:clear');
        			}
        			
        			
          		}

			var dateRangeInput = $('#daterangepicker-FECHAREGISTRO').daterangepicker({
				timePicker: false,
		        ranges: {
		            'Today': [moment().startOf('day'), moment().endOf('day')],
		            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
		            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
		            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
		            'This Month': [moment().startOf('month'), moment().endOf('month')],
		            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
		        },
				alwaysShowCalendars: true,
				autoUpdateInput: false
			});

			dateRangeInput.on('apply.daterangepicker', function(ev, picker) {
			applyDateRangeFilterFECHAREGISTRO(picker.startDate, picker.endDate);
			$(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
				var pagenum=0;
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
			});
			/*
            dateRangeInput.on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });
            */
			
			$('li[filter-name=FECHAREGISTRO]').on('hide.bs.dropdown', function () {
				if($('.daterangepicker').is(':visible'))
			    return false;
			});

			$('li[filter-name=FECHAREGISTRO]').on('filter:clear', function(e) {
				// console.log('daterangepicker filter cleared');
				//if triggered by remove filters click just remove active class,no need to send ajax
				$('li[filter-name=FECHAREGISTRO]').removeClass('active');
				$(this).val('');
				$('#daterangepicker-FECHAREGISTRO').val('');
			});

			// datepicker clear button
			$(".daterangepicker-FECHAREGISTRO-clear-button").click(function(e) {
				e.preventDefault();
				applyDateRangeFilterFECHAREGISTRO(null, null);
				$('li[filter-name=FECHAREGISTRO]').trigger('filter:clear');
				var pagenum=0;
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
			})


//Filtro FECHAULTIMAGESTION
        	function applyDateRangeFilterFECHAULTIMAGESTION(start, end) {
          			if (start && end) {
          				var dates = {
        					'from': start.format('YYYY-MM-DD'),
        					'to': end.format('YYYY-MM-DD')
        				};
        				var value = JSON.stringify(dates);
          			} else {
          				//this change to empty string,because addOrUpdateUriParameter method just judgment string
          				var value = '';
          			}
        
        			// mark this filter as active in the navbar-filters
        			if (value!=='') {
        				$('li[filter-name=FECHAULTIMAGESTION]').removeClass('active').addClass('active');
        			}
        			else
        			{
        				$('li[filter-name=FECHAULTIMAGESTION]').trigger('filter:clear');
        			}
        			
        			
          		}

			var dateRangeInput = $('#daterangepicker-FECHAULTIMAGESTION').daterangepicker({
				timePicker: false,
		        ranges: {
		            'Today': [moment().startOf('day'), moment().endOf('day')],
		            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
		            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
		            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
		            'This Month': [moment().startOf('month'), moment().endOf('month')],
		            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
		        },
				alwaysShowCalendars: true,
				autoUpdateInput: false
			});

			dateRangeInput.on('apply.daterangepicker', function(ev, picker) {
			applyDateRangeFilterFECHAULTIMAGESTION(picker.startDate, picker.endDate);
			$(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
				var pagenum=0;
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
			});
			/*
            dateRangeInput.on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });
            */
			
			$('li[filter-name=FECHAULTIMAGESTION]').on('hide.bs.dropdown', function () {
				if($('.daterangepicker').is(':visible'))
			    return false;
			});

			$('li[filter-name=FECHAULTIMAGESTION]').on('filter:clear', function(e) {
				// console.log('daterangepicker filter cleared');
				//if triggered by remove filters click just remove active class,no need to send ajax
				$('li[filter-name=FECHAULTIMAGESTION]').removeClass('active');
				$(this).val('');
				$('#daterangepicker-FECHAULTIMAGESTION').val('');
			});

			// datepicker clear button
			$(".daterangepicker-FECHAULTIMAGESTION-clear-button").click(function(e) {
				e.preventDefault();
				applyDateRangeFilterFECHAULTIMAGESTION(null, null);
				$('li[filter-name=FECHAULTIMAGESTION]').trigger('filter:clear');
				var pagenum=0;
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
			})



          //Filtro FECHARELLAMADA
        	function applyDateRangeFilterFECHARELLAMADA(start, end) {
          			if (start && end) {
          				var dates = {
        					'from': start.format('YYYY-MM-DD'),
        					'to': end.format('YYYY-MM-DD')
        				};
        				var value = JSON.stringify(dates);
          			} else {
          				//this change to empty string,because addOrUpdateUriParameter method just judgment string
          				var value = '';
          			}
        
        			// mark this filter as active in the navbar-filters
        			if (value!=='') {
        				$('li[filter-name=FECHARELLAMADA]').removeClass('active').addClass('active');
        			}
        			else
        			{
        				$('li[filter-name=FECHARELLAMADA]').trigger('filter:clear');
        			}
        			
        			
          		}

			var dateRangeInput = $('#daterangepicker-FECHARELLAMADA').daterangepicker({
				timePicker: false,
		        ranges: {
		            'Today': [moment().startOf('day'), moment().endOf('day')],
		            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
		            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
		            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
		            'This Month': [moment().startOf('month'), moment().endOf('month')],
		            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
		        },
				alwaysShowCalendars: true,
				autoUpdateInput: false
			});

			dateRangeInput.on('apply.daterangepicker', function(ev, picker) {
			applyDateRangeFilterFECHARELLAMADA(picker.startDate, picker.endDate);
			$(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
				var pagenum=0;
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
			});
			/*
            dateRangeInput.on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });
            */
			
			$('li[filter-name=FECHARELLAMADA]').on('hide.bs.dropdown', function () {
				if($('.daterangepicker').is(':visible'))
			    return false;
			});

			$('li[filter-name=FECHARELLAMADA]').on('filter:clear', function(e) {
				// console.log('daterangepicker filter cleared');
				//if triggered by remove filters click just remove active class,no need to send ajax
				$('li[filter-name=FECHARELLAMADA]').removeClass('active');
				$(this).val('');
				$('#daterangepicker-FECHARELLAMADA').val('');
			});

			// datepicker clear button
			$(".daterangepicker-FECHARELLAMADA-clear-button").click(function(e) {
				e.preventDefault();
				applyDateRangeFilterFECHARELLAMADA(null, null);
				$('li[filter-name=FECHARELLAMADA]').trigger('filter:clear');
				var pagenum=0;
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
			})			
			

//Filtro VUELTAS
    $('select[name=filter_VUELTAS]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder')
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });
	                    console.log(values);
	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                console.log(value);
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=VUELTAS]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=VUELTAS]").removeClass("active");
						//$("li[filter-name=VUELTAS]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=VUELTAS]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=VUELTAS]").on('shown.bs.dropdown', function () {
					$('#filter_VUELTAS').select2('open');
				});
				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=VUELTAS]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
					$("li[filter-name=VUELTAS]").removeClass('active');
	                $('#filter_VUELTAS').val(null).trigger('change.select2');
	                //$("li[filter-name=VUELTAS] .select2").select2("val", "");
				});


//Filtro TIPO_CONTACTO
    $('select[name=filter_TIPO_CONTACTO]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder')
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });
	                    console.log(values);
	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                console.log(value);
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=TIPO_CONTACTO]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=TIPO_CONTACTO]").removeClass("active");
						//$("li[filter-name=TIPO_CONTACTO]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=TIPO_CONTACTO]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=TIPO_CONTACTO]").on('shown.bs.dropdown', function () {
					$('#filter_TIPO_CONTACTO').select2('open');
				});
				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=TIPO_CONTACTO]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
					$("li[filter-name=TIPO_CONTACTO]").removeClass('active');
	                $('#filter_TIPO_CONTACTO').val(null).trigger('change.select2');
	                //$("li[filter-name=TIPO_CONTACTO] .select2").select2("val", "");
				});

//Filtro REMARKETING
    $('select[name=filter_REMARKETING]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder')
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });
	                    console.log(values);
	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                console.log(value);
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=REMARKETING]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=REMARKETING]").removeClass("active");
						//$("li[filter-name=REMARKETING]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=REMARKETING]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=REMARKETING]").on('shown.bs.dropdown', function () {
					$('#filter_REMARKETING').select2('open');
				});
				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=REMARKETING]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
					$("li[filter-name=REMARKETING]").removeClass('active');
	                $('#filter_REMARKETING').val(null).trigger('change.select2');
	                //$("li[filter-name=REMARKETING] .select2").select2("val", "");
				});

//Filtro ESTADOVENTA
    $('select[name=filter_ESTADOVENTA]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder')
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });
	                    console.log(values);
	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                console.log(value);
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=ESTADOVENTA]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=ESTADOVENTA]").removeClass("active");
						//$("li[filter-name=ESTADOVENTA]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=ESTADOVENTA]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=ESTADOVENTA]").on('shown.bs.dropdown', function () {
					$('#filter_ESTADOVENTA').select2('open');
				});
				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=ESTADOVENTA]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
					$("li[filter-name=ESTADOVENTA]").removeClass('active');
	                $('#filter_ESTADOVENTA').val(null).trigger('change.select2');
	                //$("li[filter-name=ESTADOVENTA] .select2").select2("val", "");
				});

//Filtro ESTADOTC
    $('select[name=filter_ESTADOTC]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder')
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });
	                    console.log(values);
	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                console.log(value);
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=ESTADOTC]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=ESTADOTC]").removeClass("active");
						//$("li[filter-name=ESTADOTC]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=ESTADOTC]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=ESTADOTC]").on('shown.bs.dropdown', function () {
					$('#filter_ESTADOTC').select2('open');
				});
				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=ESTADOTC]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
					$("li[filter-name=ESTADOTC]").removeClass('active');
	                $('#filter_ESTADOTC').val(null).trigger('change.select2');
	                //$("li[filter-name=ESTADOTC] .select2").select2("val", "");
				});



//Filtro TCGESTOR	
	
		        $('select[name=filter_TCGESTOR]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder'),
	        	                    language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {

                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectGestorTC_pre.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });
	                    console.log(values);
	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                console.log(value);
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=TCGESTOR]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=TCGESTOR]").removeClass("active");
						//$("li[filter-name=TCGESTOR]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=TCGESTOR]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=TCGESTOR]").on('shown.bs.dropdown', function () {
					$('#filter_TCGESTOR').select2('open');
				});
				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=TCGESTOR]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
					$("li[filter-name=TCGESTOR]").removeClass('active');
	                $('#filter_TCGESTOR').val(null).trigger('change.select2');
	                //$("li[filter-name=TCGESTOR] .select2").select2("val", "");
				});

//Filtro MATRICULA_AGENTE	

		        $('select[name=filter_MATRICULA_AGENTE]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder'),
	        	                    language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {

                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectGestor.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });
	                    console.log(values);
	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                console.log(value);
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=MATRICULA_AGENTE]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=MATRICULA_AGENTE]").removeClass("active");
						//$("li[filter-name=MATRICULA_AGENTE]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=MATRICULA_AGENTE]").removeClass("active");
						$("li[filter-name=MATRICULA_AGENTE]").removeClass("open");
						//$("li[filter-name=MATRICULA_AGENTE]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=MATRICULA_AGENTE]").on('shown.bs.dropdown', function () {
					$('#filter_MATRICULA_AGENTE').select2('open');
				});
				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=MATRICULA_AGENTE]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
					$("li[filter-name=MATRICULA_AGENTE]").removeClass('active');
	                $('#filter_MATRICULA_AGENTE').val(null).trigger('change.select2');
	                //$("li[filter-name=MATRICULA_AGENTE] .select2").select2("val", "");
				});

//Filtro MATRICULA_REMARKETING	

		        $('select[name=filter_MATRICULA_REMARKETING]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder'),
	        	                    language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {

                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectGestor.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });
	                    console.log(values);
	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                console.log(value);
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=MATRICULA_REMARKETING]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=MATRICULA_REMARKETING]").removeClass("active");
						//$("li[filter-name=MATRICULA_REMARKETING]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=MATRICULA_REMARKETING]").removeClass("active");
						$("li[filter-name=MATRICULA_REMARKETING]").removeClass("open");
						//$("li[filter-name=MATRICULA_REMARKETING]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=MATRICULA_REMARKETING]").on('shown.bs.dropdown', function () {
					$('#filter_MATRICULA_REMARKETING').select2('open');
				});
				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=MATRICULA_REMARKETING]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
					$("li[filter-name=MATRICULA_REMARKETING]").removeClass('active');
	                $('#filter_MATRICULA_REMARKETING').val(null).trigger('change.select2');
	                //$("li[filter-name=MATRICULA_REMARKETING] .select2").select2("val", "");
				});				

//Filtro PROVINCIA_DISTRITO	

		        $('select[name=filter_PROVINCIA_DISTRITO]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder'),
	        	                    language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {

                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectUbigeo.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });
	                    console.log(values);
	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                console.log(value);
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=PROVINCIA_DISTRITO]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=PROVINCIA_DISTRITO]").removeClass("active");
						//$("li[filter-name=PROVINCIA_DISTRITO]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=PROVINCIA_DISTRITO]").removeClass("active");
						$("li[filter-name=PROVINCIA_DISTRITO]").removeClass("open");
						//$("li[filter-name=PROVINCIA_DISTRITO]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=PROVINCIA_DISTRITO]").on('shown.bs.dropdown', function () {
					$('#filter_PROVINCIA_DISTRITO').select2('open');
				});
				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=PROVINCIA_DISTRITO]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
					$("li[filter-name=PROVINCIA_DISTRITO]").removeClass('active');
	                $('#filter_PROVINCIA_DISTRITO').val(null).trigger('change.select2');
	                //$("li[filter-name=PROVINCIA_DISTRITO] .select2").select2("val", "");
				});				

				
			//Filtro BUSCAR
			$('#text-filter-BUSCAR').on('change', function(e) {
			    var pagenum=0;
			    var value = $(this).val();
			    var cadena=Urlcadena();
			    var gridDiv = document.querySelector('#myGrid');
                ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
            
				// marque este filtro como activo en los filtros en navbar-filters
				/*
				if (value!='') {
					$('li[filter-name=CLIENTE]').removeClass('active').addClass('active');
				} else {
					$('li[filter-name=CLIENTE]').trigger('filter:clear');
				}
				*/
		
			});
			$('div[filter-name=BUSCAR]').on('filter:clear', function(e) {
				//$('li[filter-name=CLIENTE]').removeClass('active');
				$('#text-filter-BUSCAR').val('');
			});
			// Limpiar button BUSCAR				

//Filtro FILTROS_RECOVERY
    $('select[name=filter_FILTROS_RECOVERY]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');
            	var filter_key = $(this).attr('data-filter-key');
            	var element = $(this);
            	
            	$(this).attr('data-filter-enabled', 'true');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder')
                });

                $(this).change(function() {
	                var value = $(this).val();
	                var parameter = $(this).attr('data-filter-name');
	                console.log(value);
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=FILTROS_RECOVERY]").addClass('active');
					}
					else
					{
						$("li[filter-name=FILTROS_RECOVERY]").removeClass("active");
						$("li[filter-name=FILTROS_RECOVERY]").removeClass("open");
						//$("li[filter-name=FILTROS_RECOVERY]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=FILTROS_RECOVERY]").on('shown.bs.dropdown', function () {
					$('#filter_FILTROS_RECOVERY').select2('open');
				});
				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=FILTROS_RECOVERY]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
			//$("li[filter-name=FILTROS_RECOVERY]").removeClass('active');
	        // $('li[filter-name=FILTROS_RECOVERY]').val('').trigger('change.select2');
	                //$("li[filter-name=FILTROS_RECOVERY] .select2").select2("val", "");
					$("li[filter-name=FILTROS_RECOVERY]").removeClass('active');
	                //$('li[filter-name=FILTROS_RECOVERY] .select2').val(null).trigger('change.select2');	
	                $('#filter_FILTROS_RECOVERY').val(null).trigger('change');
	                
	                
	                
				});									

//Filtro FILTROS_ZONAS
    $('select[name=filter_FILTROS_ZONAS]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder')
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });
	                    console.log(values);
	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                console.log(value);
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=FILTROS_ZONAS]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=FILTROS_ZONAS]").removeClass("active");
						//$("li[filter-name=FILTROS_ZONAS]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=FILTROS_ZONAS]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=FILTROS_ZONAS]").on('shown.bs.dropdown', function () {
					$('#filter_FILTROS_ZONAS').select2('open');
				});
				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=FILTROS_ZONAS]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
					$("li[filter-name=FILTROS_ZONAS]").removeClass('active');
	                $('#filter_FILTROS_ZONAS').val(null).trigger('change.select2');
	                //$("li[filter-name=FILTROS_ZONAS] .select2").select2("val", "");
				});

//Filtro FILTROS_CANAL
    $('select[name=filter_FILTROS_CANAL]').not('[data-filter-enabled]').each(function () {
            	var filterName = $(this).attr('data-filter-name');

                $(this).select2({
                	allowClear: true,
					closeOnSelect: false,
					width: "100%",
					dropdownParent: $(this).parent('.form-group'),
	        	    placeholder: $(this).attr('placeholder')
                });

                $(this).change(function() {
	                var value = '';
	                if ($(this).val() !== null) {
	                    // clean array from undefined, null, "".
	                    var values = $(this).val().filter(function(e){ return e === 0 || e });
	                    console.log(values);
	                    // stringify only if values is not empty. otherwise it will be '[]'.
	                    value = values.length !== 0 ? JSON.stringify(values) : '';
	                    
	                }
	                console.log(value);
	                
	                var pagenum=0;
    			    var cadena=Urlcadena();
    			    var gridDiv = document.querySelector('#myGrid');
                    ajaxUpdateUriParameter(gridDiv,itemsPorPagina,pagenum,cadena,true);
	                
					// mark this filter as active in the navbar-filters
					if (value.length!==0) {
						$("li[filter-name=FILTROS_CANAL]").removeClass('active').addClass('active');
					}
					else
					{
						//$("li[filter-name=FILTROS_CANAL]").removeClass("active");
						//$("li[filter-name=FILTROS_CANAL]").find('.dropdown-menu').removeClass("show");
						$("li[filter-name=FILTROS_CANAL]").trigger("filter:clear");
					}
					
				});

			
            });
            	// when the dropdown is opened, autofocus on the select2
				$("li[filter-name=FILTROS_CANAL]").on('shown.bs.dropdown', function () {
					$('#filter_FILTROS_CANAL').select2('open');
				});
				// clear filter event (used here and by the Remove all filters button)
				$("li[filter-name=FILTROS_CANAL]").on('filter:clear', function(e) {
					// console.log('select2 filter cleared');
					$("li[filter-name=FILTROS_CANAL]").removeClass('active');
	                $('#filter_FILTROS_CANAL').val(null).trigger('change.select2');
	                //$("li[filter-name=FILTROS_CANAL] .select2").select2("val", "");
				});




          
      });
    </script>        
        
        <!-- DOCUMENT READY -->
        <script>
            $(document).ready(function () {
                
                listar(0);

                $(window).resize(() => { alterClass(); });
                
                //Fire it when the page first loads:
                alterClass();
                //USUARIO OPERADOR DE CALL CENTER
                if(perfilUsuario == 55){
                    $('#btnCargarArchivo').addClass('ocultar');
                    $('#btnCargarRemarketing').addClass('ocultar');
                    $('#btnAsignarGestorRemarketing').addClass('ocultar');
                    $('#btnExportarLeads').addClass('ocultar');
                    $('.selectrow').addClass('ocultar');
                    
                    $('.navocultar').css({"display": "none"});
                    
                } //USARIO MARKETING BO 
                else if (perfilUsuario == 41) {
                    $('#btnCargarArchivo').removeClass('ocultar');
                    $('#btnCargarRemarketing').removeClass('ocultar');
                    $('#btnAsignarGestorRemarketing').removeClass('ocultar');
                    $('#btnExportarLeads').removeClass('ocultar');
                    $('.navocultar').css({"display": "block"});
                } //USUARIOS DIRECCION MARKETING
                else if (perfilUsuario == 18) {
                    $('#btnCargarArchivo').removeClass('ocultar');
                    $('#btnAsignarGestorRemarketing').removeClass('ocultar');
                    $('#btnExportarLeads').removeClass('ocultar');
                    $('.selectrow').removeClass('ocultar');
                    $('.navocultar').css({"display": "block"});
                } //USUARIO ADMINISTRADOR
                else if (perfilUsuario == 1){
                    $('#btnCargarArchivo').removeClass('ocultar');
                    $('#btnCargarRemarketing').removeClass('ocultar');
                    $('#btnAsignarGestorRemarketing').removeClass('ocultar');
                    $('#btnExportarLeads').removeClass('ocultar');
                    $('.selectrow').removeClass('ocultar');
                    $('.navocultar').css({"display": "block"});
                }
                else {
                    $('#btnCargarArchivo').removeClass('ocultar');
                    $('#btnAsignarGestorRemarketing').removeClass('ocultar');
                    $('#btnExportarLeads').removeClass('ocultar');
                    $('.selectrow').removeClass('ocultar');
                    $('.navocultar').css({"display": "block"});
                    
                }
            });
    
        </script>
        <!-- EVENTOS -->
        <script>
            $('#nuevoLead').on('click', () => {
                window.location.href = "";
            })
            
            $('#btnCargarArchivo').on('click', function(){
                $('#modalPlantillas').modal('show');
            })
            
            $('#btnCargarRemarketing').on('click', function(){
                $('#modalRemarketing').modal('show');
            })
            $('#btnAsignarGestorRemarketing').on('click', function(){
                 var selectrows= $('#selectedRows').text();
                 var countselectedRows=$('#countselectedRows').text();
                 var mensaje='';

                 if(selectrows=="" || selectrows.length==0){
                    swal.fire('Alerta','Debes seleccionar un registro a asignar','warning');
                 }else{
                     
                     $('#cboGestorCALL').val('').trigger('change');
                     $('#modal-asignar').modal('show');
                     $('#selectedRowsModal').text(selectrows);
                     $('#countselectedRowsModal').text(countselectedRows);
                 }                
            })            
            $('.selectMatriculaCALL').select2({
                placeholder: 'Seleccione Gestor CALL CENTER',
                allowClear: true,
                language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {

                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectGestor.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });
        </script>
        
        <script>
            function alterClass() {
                var ww = document.body.clientWidth;
                if (ww < 767) {
                    $('body').removeClass('sidebar-collapse');

                } else if (ww >= 768) {
                    $('body').addClass('sidebar-collapse');

                }
            };
        </script>
        
        <script>
        // FUNCION PARA REFRESCAR LA PAGINA CADA 3 MINUTOS Y ESTAR ACTIVA
            document.addEventListener("DOMContentLoaded", function(){
            // Invocamos cada 3 minutos ;)
            const milisegundos = 3 *60000;
            setInterval(function(){
                // No esperamos la respuesta de la peticion porque no nos importa
                fetch("./ajax/refrescar.php");
            },milisegundos);
        });
        </script>
        <!-- IMPORTANCION DE DATOS (REMARKETING) -->
        <script>
            $('#btnDescargarLeadsRemarketing').on('click', function(){
                
                Swal.fire({
                  title: '¿Deseas descargar la base de Leads para REMARKETING?',
                  icon: 'info',
                  showCancelButton: true,
                  focusConfirm: false,
                  confirmButtonText: 'Descargar',
                  cancelButtonText: 'Cancelar'
                }).then((result) => {
                  /* Read more about isConfirmed, isDenied below */
                    if (result.isConfirmed) {
                        window.open("./ajax/exportLeadRemarketing.php", '_blank');
                        //Swal.fire('Saved!', '', 'success')
                    } 
                })
            })
            
            $('#actualizarLeadRemarketing').on('submit', function(e){
                
                e.preventDefault();
                
                var Form = new FormData($('#actualizarLeadRemarketing')[0]);
                console.log($('#actualizarLeadRemarketing')[0]);
                console.log(Form);
                
                $.ajax({
                    url: 'ajax/importarRemarketing.php',
                    type: 'post',
                    data: Form,
                    processData: false,
                    contentType: false,
                    cache: false,
                    success: function(data){
                        console.log(data);
                        const arrayResultado = JSON.parse(data);
                        
                        console.log(arrayResultado);
                        
                        let textohtml = `<table class="table table-striped">
                                            <tbody>
                                                <tr>
                                                    <th style="text-align: center!important;">FILA</th>
                                                    <th style="text-align: center!important;">ID LEAD</th>
                                                    <th style="text-align: center!important;">RESULTADO</th>
                                                </tr>`;
                        
                        let i = 0;
                        
                        for (let fila of arrayResultado){
                            i++;
                            
                            let {respuesta, id} = fila;
                            
                            let icono;
                            if(respuesta == 'error'){
                                icono = '<i class="fa fa-close text-red"><i>';
                            } else if(respuesta == 'sincambios'){
                                icono = '<i class="fa fa-exclamation text-yellow">SIN CAMBIOS<i>';
                            } else {
                                icono = '<i class="fa fa-check text-green"><i>';
                            }
                            
                            textohtml += `<tr><td>${i}</td><td>${id}</td><td>${icono}</td><tr>`;
                            
                        }
                        
                        textohtml += '</tbody></table>';
                        
                        console.log(textohtml);
                        
                        Swal.fire({
                          title: '<strong><u>Resultado</u></strong>',
                          icon: 'info',
                          html: textohtml
                        })
                        
                        refresh();
                        
                    }
                    
                });
                
            })
            
            $('#btnDescargarLeads').on('click', function(){
                
                Swal.fire({
                  title: '¿Deseas descargar la base de Leads para CAMBIO MASIVO DE TIPIFICACION?',
                  icon: 'info',
                  showCancelButton: true,
                  focusConfirm: false,
                  confirmButtonText: 'Descargar',
                  cancelButtonText: 'Cancelar'
                }).then((result) => {
                  /* Read more about isConfirmed, isDenied below */
                    if (result.isConfirmed) {
                        window.open("./ajax/exportLeadTipificacion.php", '_blank');
                        //Swal.fire('Saved!', '', 'success')
                    } 
                })
            })
            
            $('#actualizarLeadTipificacion').on('submit', function(e){
                
                e.preventDefault();
                
                var Form = new FormData($('#actualizarLeadTipificacion')[0]);
                console.log($('#actualizarLeadTipificacion')[0]);
                console.log(Form);
                
                $.ajax({
                    url: 'ajax/importarLeadTipificacion.php',
                    type: 'post',
                    data: Form,
                    processData: false,
                    contentType: false,
                    cache: false,
                    success: function(data){
                        console.log(data);
                        const arrayResultado = JSON.parse(data);
                        
                        console.log(arrayResultado);
                        
                        let textohtml = `<table class="table table-striped">
                                            <tbody>
                                                <tr>
                                                    <th style="text-align: center!important;">FILA</th>
                                                    <th style="text-align: center!important;">ID LEAD</th>
                                                    <th style="text-align: center!important;">RESULTADO</th>
                                                </tr>`;
                        
                        let i = 0;
                        
                        for (let fila of arrayResultado){
                            i++;
                            
                            let {respuesta, id} = fila;
                            
                            let icono;
                            if(respuesta == 'error'){
                                icono = '<i class="fa fa-close text-red"><i>';
                            } else if(respuesta == 'sincambios'){
                                icono = '<i class="fa fa-exclamation text-yellow">SIN CAMBIOS<i>';
                            } else {
                                icono = '<i class="fa fa-check text-green"><i>';
                            }
                            
                            textohtml += `<tr><td>${i}</td><td>${id}</td><td>${icono}</td><tr>`;
                            
                        }
                        
                        textohtml += '</tbody></table>';
                        
                        console.log(textohtml);
                        
                        Swal.fire({
                          title: '<strong><u>Resultado</u></strong>',
                          icon: 'info',
                          html: textohtml
                        })
                        
                        refresh();
                        
                    }
                    
                });
                
            })

            $('#btnAsignar').on('click', function(){
                const selectrows= $('#selectedRowsModal').text();
                const countselectedRows= $('#countselectedRowsModal').text();
                const cboGestorCALL=$('#cboGestorCALL').val();
                const cbotipoAsignacion = $('#cbotipoAsignacion').val();
                
                let mensaje='';
                
                if(cbotipoAsignacion == 'automatico'){
                    let gestores = $('#cboGestorCALLMultiple').val();
                    console.log(gestores);
                    
                    const cantGestores = gestores.length;
                    
                    if(cantGestores > 0){
                        
                        const cociente = Math.floor(countselectedRows/cantGestores);
                        console.log(cociente);
                        const arregloRows = selectrows.split(', ');
                        console.log(arregloRows);
                        let arregloObjetos = [];
                        
                        const filasRepartir = cantGestores*cociente;
                        console.log(filasRepartir);
                        let contador = 1;
                        let auxiliar = 0;
                        
                        arregloRows.forEach(elemento => {
                            
                            console.log(contador);
                            console.log(auxiliar);
                            
                            if(filasRepartir >= contador){
                                
                                if(auxiliar <= (cantGestores-1)){
                                    const gestorMatricula = gestores[auxiliar];
                                    console.log(gestorMatricula);
                                    
                                    const objetoAsignado = {
                                        elemento,
                                        gestorMatricula
                                    }
                                    
                                    if(auxiliar < (cantGestores-1)){
                                        auxiliar++;
                                    } else {
                                        auxiliar = 0;
                                    }
                                    arregloObjetos.push(objetoAsignado);
                                } else {
                                    auxiliar = 0;
                                }
                                
                                
                            } else {
                            
                                const aleatorio = Math.floor(Math.random() * (gestores.length));
                                console.log(aleatorio);
                                const gestorMatricula = gestores[aleatorio];
                                
                                const objetoAsignado = {
                                    elemento,
                                    gestorMatricula
                                }
                                
                                arregloObjetos.push(objetoAsignado);
                            }
                            
                            contador++;
                            
                        })
                        
                        console.log(arregloObjetos);
                        
                        let mensajeFinal = '';
                        
                        arregloObjetos.forEach(objeto => {
                            
                            const {elemento, gestorMatricula} = objeto;
                            
                            mensajeFinal += `El Lead ${elemento} se asigno al gestor ${gestorMatricula} <br>`;
                        })
                        
                        swal.fire('Asignación', mensajeFinal, 'success'); 
                        
                    } else {
                        swal.fire('Alerta','Debes seleccionar Gestor','warning'); 
                    }
                    
                } else {
                    if(cboGestorCALL==""){
                        swal.fire('Alerta','Debes seleccionar Gestor','warning'); 
                    }else{
                        if(countselectedRows==1){
                         mensaje='¿Deseas  asignar de '+countselectedRows+' registro seleccionado?';
                        }else{
                         mensaje='¿Deseas asignar de los '+countselectedRows+' registros seleccionados?'
                        }                    
                        Swal.fire({
                          title: mensaje,
                          icon: 'info',
                          showCancelButton: true,
                          focusConfirm: false,
                          confirmButtonText: 'Aceptar',
                          cancelButtonText: 'Cancelar'
                        }).then((result) => {
                          /* Read more about isConfirmed, isDenied below */
                            if (result.isConfirmed) {
                            var datos = {cboGestorCALL:cboGestorCALL,selectrows};
                            console.log(datos);
                            
                            $.ajax({
                               type: 'POST',
                               url: 'ajax/updateCALLAsignar.php',
                               data: datos,
                               dataType: "Json",
                               success: function (r) {
                                   console.log(r);
                                    if (r.respuesta == "exito") {
                                         swal.fire({
                                                title: 'Modificado!',
                                                text: 'Modificación exitosa',
                                                type: 'success'
                                            }).then((result) => {
                                                    if (result.value) {
                                                       $('#selectedRows').text('');
                                                       $('#countselectedRows').text('0');
                                                       $('#selectedRowsModal').text('');
                                                       $('#countselectedRowsModal').text('0');
                                                       $('#modal-asignar').modal('hide');
                                                       refresh();
                                                    }
                                            })
      
                                    }
                                    else {
                                        Swal.fire('Error al asignar lead', '', 'error')
                                       
                                    }
                               }
                            });
                            } else if (result.isDenied) {
                                Swal.fire('No se genero la Asignación', '', 'info')
                            } 
                        })
    
                    }
                }
            }); 
            
            
        </script>

    </body>
</html>