<?php
session_start();
    date_default_timezone_set('America/Lima');
    include 'config/db.php';
    include 'config/conexion.php';

    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
    	exit;
    }
    if ($_SESSION['pzmktteleventa']==0) {
        header("location: ./denegado.php");
    	exit;
    }
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">

        <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">

        <!-- daterange picker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-daterangepicker/daterangepicker.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap Color Picker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-colorpicker/dist/css/bootstrap-colorpicker.min.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
                <!-- Bootsrap Toogle -->
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.css" rel="stylesheet" type="text/css"/>
        <!-- bootstrap wysihtml5 - text editor -->
        <link rel="stylesheet" href="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">

        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">

        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
        
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">

        <style>

            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;
            }

            @media (min-height: 500px) {
                /*.modal-body {width: 100%;height:550px;*/
            }

            @media (min-height: 800px) {
                /*.modal-body {width: 100%;height:550px;*/
            }
            /*.modal-body {width: 100%;height:550px;*/
            }

            .espacio{
                height:10px;
            }

            .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h3{
                margin-top: -10px;
                font-size:24px;
                /*font-weight:  bold;*/
            }

            .caption p{
                color:#777;
                font-size:13px;
                padding:0px 25px 0px 25px
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #myWizard2 .form-control{
                border-radius: 4px
            }

            #myWizard3 .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }

            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo {
                color: #FFFFFF;
                background-color: #444444;
                border-color: #444444;
            }

            .btn-nuevo:hover,
            .btn-nuevo:focus,
            .btn-nuevo:active,
            .btn-nuevo.active,
            .open .dropdown-toggle.btn-nuevo {
                color: #FFFFFF;
                background-color: #616161;
                border-color: #444444;
            }

            .btn-nuevo:active,
            .btn-nuevo.active,
            .open .dropdown-toggle.btn-nuevo {
                background-image: none;
            }

            .btn-nuevo.disabled,
            .btn-nuevo[disabled],
            fieldset[disabled] .btn-nuevo,
            .btn-nuevo.disabled:hover,
            .btn-nuevo[disabled]:hover,
            fieldset[disabled] .btn-nuevo:hover,
            .btn-nuevo.disabled:focus,
            .btn-nuevo[disabled]:focus,
            fieldset[disabled] .btn-nuevo:focus,
            .btn-nuevo.disabled:active,
            .btn-nuevo[disabled]:active,
            fieldset[disabled] .btn-nuevo:active,
            .btn-nuevo.disabled.active,
            .btn-nuevo[disabled].active,
            fieldset[disabled] .btn-nuevo.active {
                background-color: #444444;
                border-color: #444444;
            }

        </style>
        <style>
            .main-header,.main-sidebar,.left-side{position:fixed}

            .main-header {
                  top: 0;
                  right: 0;
                  left: 0
            }

           .content-wrapper,
           .right-side {
              padding-top: 50px
          }

          @media (max-width:767px) {
               .content-wrapper,
               .right-side {
                  padding-top: 100px
              }
          }

          .layout-boxed .wrapper {
              max-width: 100%
          }

          .wrapper {
              overflow: hidden

           .control-sidebar {
              position: fixed;
              height: 100%;
              overflow-y: auto;
              padding-bottom: 50px
          }
        </style>
        <style>
          html, body { margin: 0; padding: 0; height: 100%; }
        </style>
        <style>
            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                -moz-border-radius: 5px;
                border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);

                z-index: 1051 !important;

            }

            input[type="search"]::-webkit-search-cancel-button {
              -webkit-appearance: searchfield-cancel-button;
            }
.bootstrap-timepicker .input-group-addon i {
    width: 11px;
    height: 0px;
}
.ocultar{
  display: none;
}    

.ocultar_gestortv{
  display: none;
}    

.nav-tabs-custom>.nav-tabs>li.active {
    border-top-color: #e4002b;
}
        </style>
        
    </head>
    <body class="sidebar-collapse skin-red sidebar-mini">

        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php
            $marketing="active";
            $televentalead= "active";
            include 'admin/main-sidebar.php';
            ?>
            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div style="font-size:180%;"> 
                    TELEVENTA &nbsp <span style="font-size:80%;color:#DAD8D4"> | &nbsp </span><span style="font-size:80%;color:#8D8A80"> TRANSFERENCIAS SIN ASIGNAR </span> 
                </div>
                <ol class="breadcrumb">
                    <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                    <li><a href="#.php">Televenta</a></li>
                    <li class="active">Transferencias</li>
                </ol>
            </section>

            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-md-12">

                            <div class="box box-danger">
                            <div class="box-header">
                            <table  style="width:90%;">
                                    <tr>
                                        <td style="width: 7%;"><h3 class="box-title">BUSCAR:</h3></td>
                                        <td style="width: 83%;">
                                          <div class="input-group input-group-sm" style="width: 200px;">
                                            <input type="text" name="table_buscar" id="BuscarProspecto" oninput="onFilterChanged(this.value)" class="form-control" placeholder="Buscar..">
                                            <!--
                                            <input type="search" name="table_buscar" oninput="onFilterChanged(this.value)" class="form-control" placeholder="Buscar..">
                                            -->
                                            
                                          </div>
                                        </td>
                                    </tr>
                                    <tr>
                                      <td>Total Registros: <span id="count"></span></td>
                                    </tr>
                                     <tr class="selectrow"><td colspan="2">N° Seleccionados: <span id="countselectedRows">0</span></td></tr>
                            </table>

                                <div class="box-tools pull-right">
                                    <div class="btn-group">
                                          <button type="button" class="btn btn-danger btn-sm dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                            <i class="fa fa-wrench"></i></button>
                                          <ul class="dropdown-menu" role="menu">
                                            <!--<li><a href="#" id="d"><i class="fa fa-plus"></i> Nueva TV</a></li>-->
                                            <li><a href="#" data-toggle="modal" data-target="#modal-asig"><i class="fa fa-users"></i> Transferir por Busq.Telefono/DNI</a></li>
                                            <li><a href="#" id="asig"><i class="fa fa-users"></i> Transferir Gestor-Masivo</a></li>
                                          </ul>
                                    </div>
                                    <button class="btn btn-success btn-sm ocultar" name="btnExportarTVLeads" id="btnExportarTVLeads">Exportar Transferencia sin Asignar</button>                                    
                                    <a class="btn btn-nuevo btn-sm" href="#" style="border-radius: 0px;" onclick="javascript:window.location.reload();" title="Actualizar"><i class="fa fa-refresh"></i></a>                                    
                                </div>
                               
                            </div>
                            <!-- /.box-header -->

                            <div class="box-body" id="vistaboy">
                                <div id="myGrid"  style="height: 100%" class="ag-theme-fresh"></div>
                                <div  id="ningunresultado"></div>

                            </div>
                            <!-- /.box-body -->

                        </div>
                        <!-- /.box -->
                        
                        
                    </div>
                </div>
<div class="test-header" style="display:none"><span id="selectedRows"></span></div>                
            </section>
            <!-- /.content -->
            
            <!-- Modal Opciones -->
            <div class="modal fade" id="modal-default">
    
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h3 id="myModalLabel">REGISTRO DE TRANSFERENCIA</h3>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <!-- left column -->
                                <div class="col-xs-12">
                                                    <!-- general form elements -->
                                                    <div class="box box-danger">
                                                        <div class="box-header with-border">
                                                            <h1 class="box-title" name="titulocategoria" id="titulocategoria">CONTACTADO</h1>
    
                                                        </div>
                                                        <!-- /.box-header -->
                                                        <!-- form start -->
        
                                                        <div class="box-body" id="bodyventaoline3">
                                                            <form id="frmVentaZ" method="POST">
                                                                <div class="espacio"></div>
                                                                <table  cellspacing="0"  style="width:100%;border-collapse: separate;border: #dfdfdf 1px solid;padding: 10px;" >
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px">GETION:<span style="color:red"> * </span></td>
                                                                        <td style="width:25%;">
                                                                            <select class="form-control input-sm" name="lblgestion" id="lblgestion" style="width: 100%;">
                                                                                <option value="">Seleccione</option>
                                                                                <option value="Outbound">Outbound</option>
                                                                                <option value="Inbound">Inbound</option>
                                                                            </select>
                                                                        </td>
                                                                        <td style="width:10%"></td>
                                                                        <td style="width:15%;font-size: 12px"><span class="lblleadhidden ocultar">LEAD ID:</span><span style="color:red" class="lblleadhidden ocultar"> * </span></td>
                                                                        <td style="width:2%"></td>
                                                                        <td style="width:25%"><input type="text" maxlength="15" class="form-control input-sm lblleadhidden ocultar" name="lblleadid" id="lblleadid" onkeypress="return filterFloat(event, this);">
                                                                        </td>
                                                                    </tr>                                                                
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px">TELEFONO:<span style="color:red"> * </span></td>
        
                                                                        <td style="width:25%"><input type="text" class="form-control input-sm" name="lbltelefono" id="lbltelefono" maxlength="9" onkeypress="return filterFloat(event, this);">
                                                                        </td>
                                                                        <td style="width:10%"></td>
                                                                        <td style="width:15%;font-size: 12px">FECHA Y HORA COTIZACON:<span style="color:red"> * </span></td>
                                                                        <td style="width:2%"></td>
                                                                        <td style="width:25%">                                    <div class="input-group">
                                                          <div class="input-group-addon input-sm">
                                                              <i class="fa fa-calendar"></i>
                                                          </div>
                                                          <input type="text" class="form-control pull-right input-sm" id="lblfvisita"  name="lblfvisita" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                        </div>
                                                                                                    <div class="bootstrap-timepicker timepicker">
                                                           <div class="input-group">
                                                                                                                         <div class="input-group-addon input-sm">
                                                                  <i class="fa fa-clock-o"></i>
                                                              </div>
                                                              <input type="text" class="form-control pull-right input-sm" placeholder="12:00 AM" name="lblhvisita" id="lblhvisita" >
    
                                                            </div>
                                                        </div>
                                                                        </td>
                                                                    </tr>
                                                                  
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px">PROVINCIA:<span style="color:red"> * </span></td>
        
                                                                        <td style="width:25%;"><select class="form-control input-sm" name="lblprovinciaz" id="lblprovinciaz" style="width: 100%;">
                                                                                <option value="">Seleccione</option>
                                                                                <option value="Lima">Lima</option>
                                                                                <option value="Arequipa">Arequipa</option>
                                                                                <option value="Trujillo">Trujillo</option>
                                                                                <option value="Ica">Ica</option>
                                                                                <option value="Piura">Piura</option>
                                                                                <option value="Chiclayo">Chiclayo</option>
                                                                            </select></td>
                                                                        <td style="width:10%"></td>
                                                                        <td style="width:15%;font-size: 12px">DISTRITO:<span style="color:red"> * </span></td>
                                                                        <td style="width:2%"></td>
                                                                        <td style="width:25%"><select class="form-control input-sm" name="lbldistritoz" id="lbldistritoz" style="width: 100%;">
                                                                                <option value="">Seleccione</option>
                                                                            </select></td>
                                                                    </tr>
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px">APELLIDOS:<span style="color:red"> * </span></td>
                                                                        <td style="width:25%;"><input name="lblapellidos" class="form-control input-sm" id="lblapellidos" style="width: 100%;"/></td>
                                                                        <td style="width:10%"></td>
                                                                        <td style="width:15%;font-size: 12px">NOMBRES:<span style="color:red"> * </span></td>
                                                                        <td style="width:2%"></td>
                                                                        <td style="width:25%"><input name="lblnombres" class="form-control input-sm" id="lblnombres" style="width: 100%;"/>
                                                                           </td>
                                                                    </tr>
                                                    <tr class="espacio"></tr>
                                                    <tr>
                                                        <td style="width:15%;font-size: 12px">TIPO DOCUMENTO:</td>
                                                        <td style="width:25%;">
                                             <select class="form-control input-sm" name="lbltipodoc" id="lbltipodoc">
                                            <option value="">Seleccione</option>
                                            <option value="DNI">DNI</option>
                                            <option value="RUC">RUC</option>
                                            <option value="CE">CE</option>
                                        </select>
                                                        </td>
                                                        <td style="width:10%"></td>
                                                        <td style="width:15%;font-size: 12px">DOCUMENTO:</td>
                                                        <td style="width:2%"></td>
                                                        <td style="width:25%">
                                                          <input type="text" class="form-control input-sm" name="lbldocumento" id="lbldocumento" maxlength="12" onkeypress="return filterFloat(event, this);">
                                                        </td>
                                                    </tr>                                                                
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px">COMENTARIO:</td>
                                                                        <td colspan="5" style="width:77%">
                                                                          <textarea class="form-control input-sm" name="lblcomentariolead" id="lblcomentariolead" rows="2" style="resize:none" placeholder="Ingresar..."></textarea>
                                                                        </td>
                                                                    </tr>
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px">SEGMENTO:</td>
                                                                        <td style="width:25%;"><select class="form-control input-sm" name="lblsegmentoz" id="lblsegmentoz">
                                                                                <option value="">Seleccione</option>
                                                                                <option value="RES">RES</option>
                                                                                <option value="NEG">NEG</option>
                                                                            </select>
                                                                            </td>
                                                                        <td style="width:10%"></td>
                                                                        <td style="width:15%;font-size: 12px">RESULTADO SCORING:<span style="color:red"> * </span></td>
                                                                        <td style="width:2%"></td>
                                                                        <td style="width:25%">
                                                                            <select class="form-control input-sm" name="lblresultadoscoring" id="lblresultadoscoring" style="width: 100%;" disabled>
                                                                                <option value=""></option>
                                                                                <option value="Televenta">Televenta</option>
                                                                                <option value="Scoring">Scoring</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>                                                                
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px">ORIGEN:</td>
                                                                        <td style="width:25%"><input class="form-control input-sm" name="lblorigen" id="lblorigen" required="required"></td>
                                                                        <td style="width:10%"></td>
                                                                        <td style="width:15%;font-size: 12px">ASIGNADO POR:<span style="color:red"> * </span></td>
                                                                        <td style="width:2%"></td>
                                                                        <td style="width:25%"><input type="text" name="lblasignadopor" id="lblasignadopor" class="form-control input-sm" style="width: 100%;" readonly="readonly" required="required"></td>
                                                                    </tr>
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px">TIPO TRANSF:<span style="color:red"> * </span></td>
        
                                                                        <td style="width:25%">
                                                                            <select class="form-control input-sm" name="lbltipotransf" id="lbltipotransf" style="width: 100%;">
                                                                                <option value="">Seleccione</option>
                                                                                <option value="EnLinea">En Linea</option>
                                                                                <option value="BD">BD</option>
                                                                                <option value="BD48horas">BD - 48 horas</option>
                                                                            </select>
                                                                            </td>
                                                                        <td style="width:10%"></td>
                                                                        <td style="width:15%;font-size: 12px">ASOCIAL</td>
                                                                        <td style="width:2%"></td>
                                                                        <td style="width:25%">
                                                                            <input type="checkbox" name="Asocial" id="Asocial" data-size="small">
                                                                            <input type="hidden" name="ValAsocial" id="ValAsocial" value="NO">
                                                                        </td>
                                                                    </tr>
                                                                    <tr class="espacio gestortv ocultar_gestortv"></tr>
                                                                    <tr class="gestortv ocultar_gestortv">
                                                                        <td style="width:15%;font-size: 12px">GESTOR TV</span></td>
                                                                        <td style="width:25%">
                                                                            <select class="form-control input-sm cbxtelecierre" name="lblgestortv" id="lblgestortv" style="width: 100%;">
                                                                                <option value="">Ninguno</option>
                                                                            </select>
                                                                            </td>
                                                                        <td style="width:10%"></td>
                                                                        <td style="width:15%;font-size: 12px"></td>
                                                                        <td style="width:2%"></td>
                                                                        <td style="width:25%">
                                                                        </td>
                                                                    </tr>                                                                 
                                                                </table>
                                                            </form>
                                                        </div>
                                                        <!-- /.box-body -->
                                                    </div>
                                                    <!-- /.box -->
                                                </div>
                            </div>
        
                            <div class="modal-footer">
                                <a class="btn btn-link mensajematricula pull-left"  href="#"></a>
                                <button type="button" class="btn btn-nuevo" id="Cerrarmodal" data-dismiss="modal">Cerrar</button>
                                <?php if($nombacceso=='test'){ } else{?>
                                <button type="button" class="btn btn-danger" id="btnGuardarVentaZ">Guardar</button>
                                <!--<a class="btn btn-danger" id="btnGuardarVentaZ" href="#" >Guardar</a> -->
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>
            <!-- /.modal -->
            <div class="modal fade" id="modal-asig">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h3 id="myModalLabel">TRANSFERIR POR TELEFONO/DNI</h3>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-xs-1"></div>
                                <div class="col-xs-10">
                                    <div class="form-group">
                                        <label class="col-sm-4 control-label" style="font-size: 18px;color: #444">TELEFONO/DNI:</label>
                                        <div class="col-sm-8">
                                            <div class="input-group input-group-sm">
                                                <input type="text" class="form-control input-sm" name="lblnclientebuscar" id="lblnclientebuscar" placeholder="Buscar transferencia.." onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="9" >
                                                <div class="input-group-btn">
                                                    <button type="submit" id="buscarnum"  class="btn btn-nuevo2 btn-sm" style="border-radius: 0px;"><i class="fa fa-search"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xs-1"></div>
                            </div>
                            <div class="espacio" style="height:10px;"></div>
                            <div class="row">
                                <div class="col-xs-1"></div>
                                <div class="col-xs-10">
                                    <table class="table table-border" id="tblVentas" border="1">
                                        <thead>
                                            <tr style="height:1vw">
                                                <td style="width:5%;" class="text-center">OPCIONES</td>
                                                <td style="width:5%;" class="text-center">TELEFONO</td>
                                                <td style="width:5%;" class="text-center">DOCUMENTO</td>
                                                <td style="width:5%;" class="text-center">TIPO TRANSF.</td>
                                                <td style="width:5%;" class="text-center">CONTACTO</td>
                                                <!-- <td style="width:5%;" class="text-center">ESTADO</td> -->
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="col-xs-1"></div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-nuevo" data-dismiss="modal">Cerrar</button>
                        </div>
                    </div>  
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>
            <!-- /.modal -->
 <div class="modal fade" id="modal-asignar">
                <div class="modal-dialog">
                    <div class="modal-content">
                      <div class="modal-header modal-header-danger">
                          <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                          <h3 id="myModalLabel">ASIGNAR TELEVENTA</h3>
                      </div>

                      <div class="modal-body">
                          <div class="row">
                              <div class="col-xs-1"></div>
                              <div class="col-xs-10">
                                  <div class="form-group">
                                      
                                      
                                      <label class="col-sm-4 control-label" style="font-size: 14px;color: #444"> GESTOR:</label>

                                      <div class="col-sm-8">
                                                    
                                                    <select class="form-control cbxtelecierre input-sm" id="cboGestorTV" name="cboGestorTV" style="width: 100%;">
                                                        <option value="">Seleccione</option>
                                                    </select>
                                      </div>
                                  </div>
                              </div>
                              <div class="col-xs-1"></div>
                          </div>
                          <div class="espacio"></div>
                          <span style="display:none" id="selectedRowsModal"></span>
                          <span style="display:none" id="countselectedRowsModal">0</span>
                      </div>
                      <div class="modal-footer">
                  <?php if($nombacceso=='test'){ } else{ ?>
                        <input type="button" class="btn btn-danger" id="btnAsignar" name="btnAsignar" value="Asignar">
                <?php } ?>
                          
                          <button type="button" class="btn btn-nuevo" data-dismiss="modal">Cerrar</button>
                      </div>
                    </div>
                </div>
            </div>            
            
        </div>
            <!-- /.content-wrapper -->
            <div class="control-sidebar-bg"></div>
        </div>
        <!-- ./wrapper -->
        <!-- jQuery v1.11 -->
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>$.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
        <!-- jQuery Knob Chart -->
        <script src="admin/bower_components/jquery-knob/dist/jquery.knob.min.js"></script>
        <!-- Bootstrap WYSIHTML5 -->
        <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
        <!-- date-range-picker -->
        <script src="admin/bower_components/moment/min/moment.min.js"></script>
        <script src="admin/bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap color picker -->
        <script src="admin/bower_components/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js"></script>
        <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- Notificaciones -->
        <script src="js/notificaciones.js" type="text/javascript"></script>
        <!-- GRILLA DE BUSCAR NUMERO -->
        <!-- sweetalert --> 
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>        
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- SCRIPT AG-GRID PRINCIPAL-->
        <!-- TOOGLE -->
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>   
        <script>
            //GLOBALES
            const perfilUsuario = $('#headerPerfilUsuario').val();
        </script>
        <!-- GRID PRINCIPAL -->
        <script>

           var columnDefs = [
                {
                    headerName: 'IDLEAD_CC',
                    field: 'IdLeadCC',
                    width: 130,
                    pinned: 'left',
                    headerCheckboxSelection: true,
                    headerCheckboxSelectionFilteredOnly: true,
                    checkboxSelection: true                       
                },
                {headerName: 'FECHAREGISTRO', field: 'FechaHoraReg', width: 163,
                    filter:'date', filterParams: {
                    filterOptions: ['equals', 'notEqual', 'lessThan', 'lessThanOrEqual', 'greaterThan', 'greaterThanOrEqual', 'inRange'],
                    // use inRangeInclusive: true for the range filter to include the selected 
                    // from and to dates. Setting it false would fetch only the inbetween dates
                    inRangeInclusive: true,  
                    comparator: function(filterLocalDateAtMidnight, cellValue) {
                      //using moment js
                      var dateAsString = moment(cellValue).format('DD/MM/YYYY');
                      var dateParts = dateAsString.split("/");
                      var cellDate = new Date(Number(dateParts[2]), Number(dateParts[1]) - 1, Number(dateParts[0]));
                
                      if (filterLocalDateAtMidnight.getTime() == cellDate.getTime()) {
                        return 0
                      }
                
                      if (cellDate < filterLocalDateAtMidnight) {
                        return -1;
                      }
                
                      if (cellDate > filterLocalDateAtMidnight) {
                        return 1;
                      }
                    }
                  }
                },
                {headerName: 'APELLIDOS Y NOMBRES', field: 'NombreCompleto', width: 150},
                {headerName: 'TELEFONO', field: 'Telefono', width: 100},
                {headerName: 'TELEFONO2', field: 'Telefono2', width: 100},
                {headerName: 'GESTION', field: 'Gestion', width: 150},
                {headerName: 'CAMPAÑA', field: 'Campaña', width: 150},
                {headerName: 'REMARKETING', field: '', width: 60},
                {headerName: 'LEADID', field: 'LeadID', width: 100},
                {headerName: 'OBSERVACIONES', field: 'Observaciones', width: 100},
                {headerName: 'AGENTE CALL', field: 'Matricula', width: 100},
                {headerName: 'VUELTAS', field: 'Vueltas', width: 100},
        		{headerName: 'TIPOTRANSFERENCIA', field: 'TipoTransferencia', width: 130},
        		{headerName: 'FECHA HORA COTIZACION', field: 'FechaHoraCotizacion', width: 100},
        		{headerName: 'ORIGEN', field: 'Origen', width: 250},
                {headerName: 'ORIGEN', field: 'Origen', width: 100},
                {headerName: 'DEPARTAMENTO', field: 'Departamento', width: 100},
                {headerName: 'PROVINCIA', field: 'Provincia', width: 100},
                {headerName: 'DISTRITO', field: 'Distrito', width: 100},
                {headerName: 'SEGMENTO', field: 'Segmento', width: 100},
                {headerName: 'GESTOR ASIGNADO', field: 'Matricula', width: 100},
                {headerName: 'TIPO CONTACTO', field: 'Contacto', width: 100},
                {headerName: 'TIPIFICACION', field: 'ResultadoGestion', width: 120},
                {headerName: 'SUBTIPIFICACION', field: 'SubTipificacion', width: 100}
                ];

            var gridOptions = {
                columnDefs: columnDefs,
                onPaginationChanged: onPaginationChanged,
                rowData: null,
                enableFilter: true,
                enableColResize: true,
                enableSorting: true,
                rowSelection: 'multiple',
                onSelectionChanged: onSelectionChanged,                
                localeText: {
                  // for filter panel
                  page: 'página',
                  more: 'Más',
                  to: 'a',
                  of: 'de',
                  next: 'Siguiente',
                  last: 'Último',
                  first: 'Primero',
                  previous: 'Anterior',
                  loadingOoo: 'Cargando...',
                  // for set filter
                  selectAll: 'Seleccionar todo',
                  searchOoo: 'Buscando...',
                  blanks: 'Espacios en blanco',
                  // for number filter and text filter
                  filterOoo: 'Filtrar...',
                  applyFilter: 'Aplicar Filtro',
                  // for number filter
                  equals: 'Igual',
                  notEqual: 'No es igual',
                  lessThanOrEqual: 'Menor o igual',
                  greaterThanOrEqual: 'Mayor que o igual',
                  inRange: 'En el rango',
                  lessThan: 'Menos que',
                  greaterThan: 'Mas grande que',
                  // for text filter
                  contains: 'Contiene',
                  startsWith: 'Comienza con',
                  endsWith: 'Termina con',
                  notContains:'No contiene',
                  // the header of the default group column
                  group: 'Grupo',
                  // tool panel
                  columns: 'columnas',
                  rowGroupColumns: 'Grupo columnas',
                  rowGroupColumnsEmptyMessage: 'No hay resultado',
                  valueColumns: 'Columna de valor',
                  pivotMode: 'Modo pivote',
                  groups: 'grupos',
                  values: 'valor',
                  pivots: 'pivote',
                  valueColumnsEmptyMessage: 'No hay resultado',
                  pivotColumnsEmptyMessage: 'No hay resultado',
                  // other
                  noRowsToShow: '<div class="callout callout-danger">\n\
                                <span class="pull-left">\n\
                                <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
                                </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
                                <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
                                <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
                                <br></div>'
                  ,
                  // enterprise menu
                  pinColumn: 'Aclar columna',
                  valueAggregation: 'Agregar valor',
                  autosizeThiscolumn: 'Auto tamaño esta columna ',
                  autosizeAllColumns: 'Auto tamaño todas columnas',
                  groupBy: 'Agrupar',
                  ungroupBy: 'Agrupar uno',
                  resetColumns: 'Restaurar Columnas',
                  expandAll: 'expandir todo',
                  collapseAll: 'desplegar todo',
                  toolPanel: 'Panel de Heramientas',
                  export: 'Exportar',
                  csvExport: 'Exportar CSV',
                  excelExport: 'Exportar Excel',
                  // enterprise menu pinning
                  pinLeft: 'Anclar a derecha',
                  pinRight: 'Anclar a izquierda',
                  noPin: 'Desanclar',
                  // enterprise menu aggregation and status panel
                  sum: 'Sumar',
                  min: 'Minimo',
                  max: 'Maximo',
                  first: 'Primero',
                          last: 'Ultimo',
                          none: 'Nada',
                  count: 'Contador',
                  average: 'Promedio',
                  // standard menu
                  copy: 'Copiar',
                  copyWithHeaders: 'Copiar Cabecera',
                  ctrlC: 'Ctrl+C',
                  paste: 'Pegar',
                  ctrlV: 'Ctrl+V'
                },
                enableSorting: true
              };


            function onPaginationChanged(params) {
              this.gridRowCount = params.api.paginationGetRowCount();
              $("#count").html(this.gridRowCount);
            }

            function onFilterChanged(value) {
                gridOptions.api.setQuickFilter(value);
            }

            function onSelectionChanged() {
            var selectedRows = gridOptions.api.getSelectedRows();
            var selectedRowsString = '';
            var countselectedRows=0;
            selectedRows.forEach(function(selectedRow, index) {
                if (index!==0) {
                    selectedRowsString += ', ';
                    countselectedRows +=0;
                }
                    selectedRowsString += selectedRow.IdLeadCC;
                    countselectedRows +=1;
            });
            
            document.querySelector('#selectedRows').innerHTML = selectedRowsString;
            document.querySelector('#countselectedRows').innerHTML = countselectedRows;
        }            
            function onPaginationChangedT(params) {
              this.gridRowCount = params.api.paginationGetRowCount();
              $("#count2").html(this.gridRowCount);
            }

            function onFilterChangedT(value) {
                gridOptionsT.api.setQuickFilter(value);
            }            
        </script>
        <!-- FUNCIONES DE LA GRID PRINCIPAL -->
        <script type="text/javascript">
            function listar(){
              var tipo = 'Load';

              var gridDiv = document.querySelector('#myGrid');
              new agGrid.Grid(gridDiv, gridOptions);
              agGrid.simpleHttpRequest(
                {
                  url:'ajax/selectListarLeadTV.php?tipo='+ tipo
                }).then(function (data) {
                  gridOptions.api.setRowData(data);
                });

                $('#vistaboy').height(function (index, height) {
                    return $(window).height() * 65 / 100;
                });
            }

            function refresh(){
                var tipo = 'Load';
                
                var gridDiv = document.querySelector('#myGrid');
                agGrid.simpleHttpRequest(
                {
                  url:'ajax/selectListarLeadTV.php?tipo='+ tipo
                }).then(function (data) {
                  gridOptions.api.setRowData(data);
                });
                
                $('#vistaboy').height(function (index, height) {
                    return $(window).height() * 65 / 100;
                });
                $("#ningunresultado").hide("fast");
                $('#myGrid').show(200);
                
            }

        </script>
        <!-- ACCIONES DEL DOM -->
        <script>
            
            $("#lblprovinciaz").change(function () {
                $("#lblprovinciaz option:selected").each(function () {
                    var lblprovinciaz = $(this).val();
                    $.post("./ajax/selectDistrito_Call.php", {lblprovinciaz: lblprovinciaz}, function (data) {
                        $("#lbldistritoz").html(data);
                    });
                });
            });
            $("#lblgestion").change(function () {
                $("#lblgestion option:selected").each(function () {
                    var lblgestion = $(this).val();
                    if(lblgestion=="Outbound"){
                        $(".lblleadhidden").removeClass("ocultar");
                    }else{
                        $(".lblleadhidden").addClass("ocultar");
                    }
                });
            });
            $("#lbldistritoz").change(function () {
                $("#lbldistritoz option:selected").each(function () {
                    var lbldistritoz = $(this).val();
                    $.post("./ajax/selectDistrito_Scoring.php", {lbldistritoz: lbldistritoz}, function (data) {
                        $("#lblresultadoscoring").html(data);
                    });
                });
            });            

            $("#lbltipotransf").change(function () {
                $("#lbltipotransf option:selected").each(function () {
                    var lbltipotransf = $(this).val();
                    if(lbltipotransf=="EnLinea"){
                        $(".gestortv").removeClass("ocultar_gestortv");
                    }else{
                        $(".gestortv").addClass("ocultar_gestortv");
                    }
                });
            });

            //Funcion para seleccionar al jefe de venta de acuerdo a la delegacion
            $("#lbldcz").change(function () {
                $("#lbldcz option:selected").each(function () {
                    var lbldc = $(this).val();
                    $.post("./ajax/selectJefeVenta.php", {lbldc: lbldc}, function (data) {
                        $("#lbljefeventaz").html(data);
                    });
                });
            });            

                $('#Asocial').bootstrapToggle({
                      on:'SI',
                      off:'NO',
                      onstyle:'success',
                      offstyle:'danger'
                });
                $('#Asocial').change(function(){
                    if($(this).prop('checked')){
                       $('#ValAsocial').val('SI');
                    }else{
                      $('#ValAsocial').val('NO');
                     }
                });
                $("#lbltipodoc").change(function () {
                    var tipodoc = $("#lbltipodoc").val();
                   if(tipodoc=="DNI"){
                       $('#lbldocumento').attr('maxlength', 8);
                   }else if(tipodoc=="RUC"){
                       $('#lbldocumento').attr('maxlength', 11);
                   }else{
                       $('#lbldocumento').attr('maxlength', 12);
                   }
                });             



            $("#lblmatriculaz").on("keydown", function (event) {
                if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE){
                    $('#lblidusuarioz').val("");
                    $('#lblmatriculaz').val("");
                    $('#lblnombcomercialz').val("");
                }
                if (event.keyCode == $.ui.keyCode.DELETE) {
                    $('#lblmatriculaz').val("");
                    $('#lblidusuarioz').val("");
                    $('#lblnombcomercialz').val("");
                }
            });
            
            $('#buscarnum').click(function () {
                var numero=$("#lblnclientebuscar").val();
                const contenedor = document.querySelector('#tblVentas tbody');
                while (contenedor.firstChild) {
                    contenedor.removeChild(contenedor.firstChild);
                }
                if(numero==""){
                    alertify.warning("Número Vacio");
                    $("#lblnclientebuscar").focus();
                } else {
                    $.ajax({
                        url: 'ajax/findTranferencia.php',
                        method:"POST",  
                        data:{numero:numero},  
                        dataType:"json",
                        success: function (datos) {
                            console.log(datos);
                            if(datos!==null){
                                for (let [llave, valor] of Object.entries(datos)){
                                    const row = document.createElement('tr');
                                    if(valor.EstadoLead=="Transferido"){
                                        row.innerHTML = `   <td class="tblBody text-center">Transferido</td> 
                                                            <td class="tblBody text-center">${valor.Telefono}</td>
                                                            <td class="tblBody text-center">${valor.NDocumento}</td>
                                                            <td class="tblBody text-center">${valor.TipoTransferencia}</td>
                                                            
                                                            <td class="tblBody text-center">${valor.Nombres} ${valor.Apellidos}</td>
                                                        `                        
                                            
                                    }else{
                                        row.innerHTML = `   <td class="tblBody text-center">
                                                                <a class="fa fa-user asignarGestor" data-id="${valor.IdLeadCC}" data-estado="${valor.EstadoLead}" href="#" title="Asignar Gestor" style="text-decoration:none;color:#4c4c4c"></a>
                                                            </td> 
                                                            <td class="tblBody text-center">${valor.Telefono}</td>
                                                            <td class="tblBody text-center">${valor.NDocumento}</td>
                                                            <td class="tblBody text-center">${valor.TipoTransferencia}</td>
                                                            <td class="tblBody text-center">${valor.Nombres} ${valor.Apellidos}</td>
                                                        `
                                    }
                
                                    //Agrega el HTML del carrito en el tbody 
                                    contenedor.appendChild(row);
                                } 
                            }else{
                                const row = document.createElement('tr');
                                row.innerHTML = ` <td colspan="4" class="tblBody text-center">No se encontro con ningun dato</td>`
                                //Agrega el HTML del carrito en el tbody 
                                contenedor.appendChild(row);
                            }
                        }
                });
                }
            });
            
            
            $('#tblVentas').on("click", function(e){
                
                if (e.target.classList.contains('asignarGestor')) {
                    const leadId = e.target.getAttribute('data-id');
                    const EstadoLead = e.target.getAttribute('data-estado');
                    <?php
                    $html_tc=[];
                    $sql_tc = "SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) GestorTC FROM yifi58ge_dbUSUARIO.tblusuario u  
                        INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea
                        WHERE a.IdArea='40' and u.Estado='Activo'"; 
                        $result_tc = mysqli_query($con, $sql_tc);
                        if (mysqli_num_rows($result_tc)> 0) {
                            while ($row_t = mysqli_fetch_array($result_tc)) {
                                $html_tc[] = array_map("utf8_encode",['id'=>$row_t['Matricula'], 'text'=>$row_t['Matricula'].' - '.utf8_encode($row_t['GestorTC'])]);
                            }
                        }
                    ?>
                    var array = <?php echo json_encode($html_tc);?>;
                    var options = {};
                    $.map(array,
                    function(o){
                        options[o.id] = o.text;
                    });
                    console.log(EstadoLead);
                    
                    if(EstadoLead === null || EstadoLead==='' || EstadoLead==='null'){
                        //SWAL
                        Swal.fire({
                            title: 'ASIGNACIÓN DEL GESTOR',
                            input: 'select',
                            inputOptions: options,
                            inputPlaceholder: 'Seleccionar Gestor',
                            showCancelButton: true,
                            confirmButtonColor: '#e4002b',
                            confirmButtonText: 'Asignar',
                            showLoaderOnConfirm: true,
                            preConfirm: (gestor) => {
                                let data = {gestor: gestor, leadId:leadId};
                                console.log(data);
                                fetch('./ajax/insertTeleventaTransferencia.php', {method: 'POST', body: JSON.stringify(data)})
                                    .then(function(res) {
                                        console.log(res);
                                        return res.json();
                                    })
                                    .then(function(datos) {
                                        console.log(datos);
                                    })
                                    .catch(function(error) {
                                        Swal.showValidationMessage(
                                          `Solicitud ERROR: ${error}`
                                        )
                                    })
                          },
                          allowOutsideClick: () => !Swal.isLoading()
                        }).then((result) => {
                            if (result.isConfirmed) {
                                Swal.fire(
                                    'Transferido!',
                                    'El lead ha sido transferido satisfactoriamente!',
                                    'success'
                                )
                                $('#modal-asig').modal('hide');
                                var contenedor = document.querySelector('#tblVentas tbody');
                                    while (contenedor.firstChild) {
                                        contenedor.removeChild(contenedor.firstChild);
                                    }
                                refresh();
                                refreshT();
                                
                            }
                        })
                        //END SWAL    
                    } else {
                        Swal.fire(
                                'Error!',
                                'El lead ya fue transferido a televenta',
                                'error'
                            )
                    }
                } //END IF
            })
            
            
        </script>
        <!-- DOCUMENT READY -->
        <script>
            $(document).ready(function () {
                listar();
                //listarBUSCAR();
                var alterClass = function () {
                    var ww = document.body.clientWidth;
                    if (ww < 767) {
                        $('body').removeClass('sidebar-collapse');
    
                    } else if (ww >= 768) {
                        $('body').addClass('sidebar-collapse');
                    }
                };
                $(window).resize(function () {
                    alterClass();
                    //cambio();
                });
                //Fire it when the page first loads:
                alterClass();

              //USUARIO OPERADOR DE CALL CENTER
                if($('#lblmatriculausuario').val()=='NT9897'){
                    
                }
                else if(perfilUsuario == 35){
                    $('#btnExportarTVLeads').addClass('ocultar');
                } 
                else {
                    $('#btnExportarTVLeads').removeClass('ocultar');
                }                

                $('.selectdistrito').select2({
                    placeholder: 'Seleccione Distrito - Provincia',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {
    
                            return "Buscando..";
                        }
                    },
                    ajax: {
                        url: 'ajax/selectDistrito.php',
                        dataType: 'json',
                        delay: 250,
                        processResults: function (data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    }
                });
    
                $('.selectgestor').select2({
                    placeholder: 'Seleccione Gestor',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {
    
                            return "Buscando..";
                        }
                    },
                    ajax: {
                        url: 'ajax/selectGestor.php',
                        dataType: 'json',
                        delay: 250,
                        processResults: function (data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    }
                });

            $('.cbxtelecierre').select2({
                placeholder: 'Seleccione Gestor TV',
                allowClear: true,
                language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {

                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectMatriculaTV_v2.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });
             $('#asig').click(function(){
                 var selectrows= $('#selectedRows').text();
                 var countselectedRows=$('#countselectedRows').text();
                 var mensaje='';

                 if(selectrows=="" || selectrows.length==0){
                    swal.fire(
                                'Alerta',
                                'Debes seleccionar un registro a asignar',
                                'warning');
                 }else{
                     
                     $('#cboGestorTV').val('').trigger('change');
                     $('#modal-asignar').modal('show');
                     $('#selectedRowsModal').text(selectrows);
                     $('#countselectedRowsModal').text(countselectedRows);
                 }
          });
           $('#btnAsignar').on('click', function(){
                var selectrows= $('#selectedRowsModal').text();
                var countselectedRows= $('#countselectedRowsModal').text();
                var cboGestorTV=$('#cboGestorTV').val();
                if(cboGestorTV==""){
                            swal.fire(
                                'Alerta',
                                'Debes seleccionar Gestor',
                                'warning'); 
                }else{
                                     //Algunas variables por default de alertify
                alertify.defaults.theme.ok = "btn btn-nuevo";
                alertify.defaults.theme.cancel = "btn btn-danger";

                var lastX,lastY;
                if(countselectedRows==1){
                 mensaje='¿Deseas  asignar de '+countselectedRows+' registro seleccionado?';
                }else{
                 mensaje='¿Deseas asignar de los '+countselectedRows+' registros seleccionados?'
                }
                
                alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', mensaje, function(){ 
                    var datos = {cboGestorTV:cboGestorTV,selectrows};
                        console.log(datos);
                        
                        $.ajax({
                           type: 'POST',
                           url: 'ajax/updateTVAsignarLead.php',
                           data: datos,
                           dataType: "Json",
                           success: function (r) {
                               console.log(r);
                                if (r.respuesta == "exito") {
                                    
                                     swal.fire({
                                            title: 'Transferido!',
                                            text: 'Transferencia del Lead exitosa',
                                            type: 'success'
                                        }).then((result) => {
                                                if (result.value) {
                                                    $('#modal-asignar').modal('hide');
                                                }
                                        });
                                                   $('#selectedRows').text('');
                                                   $('#countselectedRows').text('0');
                                                   $('#selectedRowsModal').text('');
                                                   $('#countselectedRowsModal').text('0');
                                                   refresh();                                        
                                }
                                else {
                                    alertify.error("Fallo el server");
                                   
                                }
                           }
                        });
                        
                        
                }, function(){ alertify.error('Se ha cancelado las modificaciones')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
        
                    lastX = window.scrollX;
                    lastY = window.scrollY;
                },
                'onfocus':function(){
                    window.scrollTo(lastX, lastY);
                }  }).show(); 
                }

          });
    
                $('#datemask').inputmask('dd/mm/yyyy', {'placeholder': 'dd/mm/yyyy'});
    
                $('#bodyprincipal').slimScroll({
                    height: '400px'
                });
    
                $('#bodyventaoline').slimScroll({
                    height: '400px'
                });
    
                $('#bodyeditarventa').slimScroll({
                    height: '500px'
                });
    
                $('#bodyventaoline3').slimScroll({
                    height: '400px'
                });
    
                $('#slider').css('margin-left', '-' + 100 + '%');
    
                $('#mesanoz').datepicker({
                    autoclose: true,
                    language: 'en',
                    firstDay: 1, format: 'M-yyyy',
                    viewMode: "years",
                    minViewMode: "months"
                }).datepicker("setDate", new Date());
                //Money Euro
                $('[data-mask]').inputmask();
                //Date picker
                 $('#lblfvisita').datepicker({
                  autoclose: true,
                  language: 'es',
                  firstDay: 1
              });

              $('#lblhvisita').timepicker({
                  showInputs: true,
                  minuteStep: 1
              });
          }); 
        </script>
        <!-- SCRIPT BOTON GUARDAR VENTA -->
        <script>
            $('#btnGuardarVentaZ').click(function () {
                
                $('#btnGuardarVentaZ').prop('disabled', true);
                
                var gestorbackoffice='<?php echo $matriculausuario; ?>';
                // Primero validará el formulario.
                if (validaFormZ()) {

                var lblgestion = $('#lblgestion').val();
                var lblleadid = $('#lblleadid').val();
                var lbltelefono = $('#lbltelefono').val();
                var lblfvisita = $('#lblfvisita').val();
                var lblhvisita = $('#lblhvisita').val();
                var lbldistritoz = $('#lbldistritoz').val();
                var lblapellidos = $('#lblapellidos').val();
                var lblnombres = $('#lblnombres').val();
                var lblcomentariolead = $('#lblcomentariolead').val();
                var lbltipotransf = $('#lbltipotransf').val();
                var lblresultadoscoring = $('#lblresultadoscoring').val();
                var lblsegmentoz = $('#lblsegmentoz').val();
                var lblasignadopor=$('#lblasignadopor').val();
                var lblorigen=$('#lblorigen').val();
                var lbltipodoc=$('#lbltipodoc').val();
                var lbldocumento=$('#lbldocumento').val();
                var ValAsocial=$('#ValAsocial').val();
                var lblgestortv=$('#lblgestortv').val();

                var datos = {
                    lblgestion: lblgestion,
                    lblleadid: lblleadid,
                    lbltelefono: lbltelefono,
                    lblfvisita: lblfvisita,
                    lblhvisita :lblhvisita,
                    lbldistritoz: lbldistritoz,
                    lblapellidos: lblapellidos,
                    lblnombres: lblnombres,
                    lblcomentariolead:lblcomentariolead,
                    lbltipotransf: lbltipotransf,
                    lblresultadoscoring: lblresultadoscoring,
                    lblsegmentoz: lblsegmentoz,
                    lblasignadopor: lblasignadopor,
                    lblorigen:lblorigen,
                    lbltipodoc:lbltipodoc,
                    lbldocumento:lbldocumento,
                    ValAsocial:ValAsocial,
                    lblgestortv:lblgestortv
                };
                    console.log(datos);

                    $.ajax({
                        type: 'POST',
                        url: 'ajax/insertLead.php',
                        data: datos,
                        dataType: "Json",
                        success: function (r) {
                            console.log(r);
                            if (r.respuesta == "exito") {
                                $("#modal-default").modal("hide");
                                refresh();
                                Swal.fire(
                                  'Agregado con exito!',
                                  'Se ha registrado LEAD-ID: '+r.id_lead,
                                  'success'
                                );
                                
                            }else {
                                    Swal.fire({
                                        title: "Error",
                                        text: "Comuniquese con soporte en soporteit@verisure.pe",
                                        type: 'error'
                                    });
                            }
                        }
                    });

                } // END IF VALIDAR FORM
                
                $('#btnGuardarVentaZ').prop('disabled', false);
            });
        </script>
        <!-- SCRIPT FILTROS -->
        <script>
            //FILTRO POR ESTADO TELECIERRE Y ESTADO VENTA
            $('#FiltroEstadoTc, #FiltroEstadoVenta').on('change', function(){
                //var FiltroGestorTc = $('#FiltroGestorTc').val();
                var filtroEstadoTc = $('#FiltroEstadoTc').val();
                var FiltroEstadoVenta = $('#FiltroEstadoVenta').val();
                var FiltroCelular = $('#FiltroCelular').val();
            
                if (filtroEstadoTc == '' && FiltroEstadoVenta == '' && FiltroCelular == ''){
                    var tipo = 'Load';
                } else {
                    var tipo = 'Filtro';    
                }
            
                //$('#FiltroGestorTc').prop('disabled', true);
                $('#FiltroEstadoTc').prop('disabled', true);
                $('#FiltroEstadoVenta').prop('disabled', true);
                $('#FiltroCelular').prop('disabled', true);

                datos = {
                  filtroEstadoTc: filtroEstadoTc,
                  FiltroEstadoVenta: FiltroEstadoVenta,
                  FiltroCelular: FiltroCelular
                }

                $.ajax({
                  type: 'Post',
                  url: 'ajax/selectListarTeleventa_test2.php?tipo='+tipo,
                  data: datos,
                  dataType: 'json',
                  success: function(data){
                      gridOptions.api.setRowData(data);
    
                      //$('#FiltroGestorTc').prop('disabled', false);
                      $('#FiltroEstadoTc').prop('disabled', false);
                      $('#FiltroEstadoVenta').prop('disabled', false);
                      $('#FiltroCelular').prop('disabled', false);
                  }
                })
            })
            //FIN FILTRO

            $('#FiltroCelular').on('blur', function(){
                //var FiltroGestorTc = $('#FiltroGestorTc').val();
                var filtroEstadoTc = $('#FiltroEstadoTc').val();
                var FiltroEstadoVenta = $('#FiltroEstadoVenta').val();
                var FiltroCelular = $('#FiltroCelular').val();

                if (filtroEstadoTc == '' && FiltroEstadoVenta == '' && FiltroCelular == ''){
                    var tipo = 'Load';
                } else {
                    var tipo = 'Filtro';    
                }

                datos = {
                  //FiltroGestorTc: FiltroGestorTc,
                  filtroEstadoTc: filtroEstadoTc,
                  FiltroEstadoVenta: FiltroEstadoVenta,
                  FiltroCelular: FiltroCelular
                }

                $.ajax({
                  type: 'Post',
                  url: 'ajax/selectListarTeleventa_test2.php?tipo='+tipo,
                  data: datos,
                  dataType: 'json',
                  success: function(data){
                      console.log(data);
                      gridOptions.api.setRowData(data);
                  }
                })
            })
            
            $('#btnBuscarProspecto').on('click', function(){
                var tipo = 'All';
                $('#btnBuscarProspecto').prop('disabled', true);
                
                $.ajax({
                  type: 'Post',
                  url: 'ajax/selectListarTeleventa_test2.php?tipo='+tipo,
                  dataType: 'json',
                  success: function(data){
                      gridOptions.api.setRowData(data);
                      
                      $('#btnBuscarProspecto').prop('disabled', false);
                  }
                })
                
            })
            
            //Elimina los cursos del tbody
            function limpiarHTML() {
                //forma lenta
                //contenedorCarrito.innerHTML = '';
            
                //forma recomendada
                while (contenedor.firstChild) {
                    contenedor.removeChild(contenedor.firstChild);
                }
            }
            
            function filterFloat(evt, input) {
                // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
                var key = window.Event ? evt.which : evt.keyCode;
                var chark = String.fromCharCode(key);
                 var tempValue = input.value + chark;
                if (key >= 48 && key <= 57) {
                    if (filter(tempValue) === false) {
                    return false;
                    } else {
                    return true;
                    }
                } else {
                    if (key == 8 || key == 13 || key == 0) {
                        return true;
                    } else if (key == 46) {
                        if (filter(tempValue) === false) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                      return false;
                    }
                }
            }

            function filter(__val__) {
                var preg = /^([0-9]+\.?[0-9]{0,2})$/;
                if (preg.test(__val__) === true) {
                return true;
                } else {
                return false;
                }
            }

        </script>
        <!-- SCRIPT VALIDACIONES -->
        <script>
            function validaForm() {
                // Campos de texto
                if ($("#frmVenta #lblmatricula").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula correspondiente");
                    $("#frmVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmVenta #lblnombcomercial").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula valida");
                    $("#frmVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmVenta #lbldc").val() == "" || $("#frmVenta #lbldc").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar CC correcto");
                    $("#frmVenta #lbldc").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
    
                if ($("#frmVenta #lbljefeventa").val() == "" || $("#frmVenta #lbljefeventa").val() == "No se encontraron resultado") {
                    alertify.warning("Por favor revisar Jefe de Estructura Comercial");
                    $("#frmVenta #lbljefeventa").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
    
    
                if ($("#frmVenta #lblestadoventa").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Estado de Venta correcto");
                    $("#frmVenta #lblestadoventa").focus();
                    return false;
                }
                if ($("#frmVenta #lbltipoventa").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Recurso correcto");
                    $("#frmVenta #lbltipoventa").focus();
                    return false;
                }
                if ($("#frmVenta #lblsegmento").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Segmento correcto");
                    $("#frmVenta #lblsegmento").focus();
                    return false;
                }
                if ($("#frmVenta #lblmesesautorizados").val() == "") {
                    alertify.warning("Por favor ingresar MesAutorizado.Si no tuviese coloque: 0");
                    $("#frmVenta #lblmesesautorizados").focus();
                    return false;
                }
    
                if ($("#frmVenta #lblnombcliente").val() == "") {
                    alertify.warning("Por favor ingresar Nombre del Cliente");
                    $("#frmVenta #lblnombcliente").focus();
                    return false;
                }
                if ($("#frmVenta #lblcorreo").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#frmVenta #lblcorreo").val())) {
                    alertify.warning("Por favor ingresar correo válido");
                    $("#frmVenta #lblcorreo").focus();
                    return false;
                }
                if ($("#frmVenta #lbldireccion").val() == "") {
                    alertify.warning("Por favor ingresar la Direccion del Cliente");
                    $("#frmVenta #lbldireccion").focus();
                    return false;
                }
    
                if ($("#frmVenta #lbldistrito").val() == "") {
                    alertify.warning("Por favor ingresar Distrito correcto");
    
                    $("#frmVenta #lbldistrito").select2('open');
                    return false;
                }
    
    
                if ($("#frmVenta #lblmovil").val() == "") {
                    alertify.warning("Por favor ingresar Telefono, de caso contrario digite: 0");
                    $("#frmVenta #lblmovil").focus();
                    return false;
                }
                if ($("#frmVenta #lblpreciokit").val() == "") {
                    alertify.warning("Por favor ingresar Precio del KIT");
                    $("#frmVenta #lblpreciokit").focus();
                    return false;
                }
                if ($("#frmVenta #lbltotalextra").val() == "") {
                    alertify.warning("Por favor ingresar Total de Extra, de caso contrario digite: 0");
                    $("#frmVenta #lbltotalextra").focus();
                    return false;
                }
    
                if ($("#frmVenta #lblresumenventa").val() == "") {
                    alertify.warning("Por favor ingresar Resumen de Venta");
                    $("#frmVenta #lblresumenventa").focus();
                    return false;
                }
                if ($("#frmVenta #lblformadepago").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Forma de Pago");
                    $("#frmVenta #lblformadepago").focus();
                    return false;
                }
                /*
                if ($("#frmVenta #mesano").val() == "") {
                    alertify.warning("Por favor ingresar 590");
                    $("#frmVenta #mesano").focus();
                    return false;
                }*/
                if ($("#frmVenta #lblPAI").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar PAI ");
                    $("#frmVenta #lblPAI").focus();
                    return false;
                }
    
                return true;
          }

            function validaFormZ() {
                // Campos de texto
                if ($("#frmVentaZ #lblgestion").val() == "") {
                    console.log($("#frmVentaZ #lblgestion").val());
                    alertify.warning("Por favor ingresar Seleccionar Gestion correspondiente");
                    $("#frmVentaZ #lblgestion").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }

                if ($("#frmVentaZ #lblgestion").val() == "Outbound") {
                     if ($("#frmVentaZ #lblleadid").val() == "") {
                        alertify.warning("Por favor ingresar Lead ID");
                        $("#frmVentaZ #lblleadid").focus();
                        return false;
                    }
                }
                
                /*
                if ($("#frmVentaZ #lblnombcomercialz").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula valida");
                    $("#frmVentaZ #lblmatriculaz").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmVentaZ #lbldcz").val() == "" || $("#frmVentaZ #lbldcz").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar CC correcto");
                    $("#frmVentaZ #lbldcz").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
    
                if ($("#frmVentaZ #lbljefeventaz").val() == "" || $("#frmVentaZ #lbljefeventaz").val() == "No se encontraron resultado") {
                    alertify.warning("Por favor revisar Jefe de Estructura Comercial");
                    $("#frmVentaZ #lbljefeventaz").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
    
                if ($("#frmVentaZ #lbltipoventaz").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Recurso correcto");
                    $("#frmVentaZ #lbltipoventaz").focus();
                    return false;
                }
    
                 if ($("#frmVentaZ #lblasignadoz").val() == "") {
                    alertify.warning("Por favor ingresar Gestor Contact Center correcto");
    
                    $("#frmVentaZ #lblasignadoz").select2('open');
                    return false;
                }
                if ($("#frmVentaZ #lblsegmentoz").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Segmento correcto");
                    $("#frmVentaZ #lblsegmentoz").focus();
                    return false;
                }
                
                if ($("#frmVentaZ #lblnombclientez").val() == "") {
                    alertify.warning("Por favor ingresar Nombre del Cliente");
                    $("#frmVentaZ #lblnombclientez").focus();
                    return false;
                }
                */
    
                if ($("#frmVentaZ #lbldistritoz").val() == "") {
                    alertify.warning("Por favor ingresar Distrito correcto");
    
                    $("#frmVentaZ #lbldistritoz").select2('open');
                    return false;
                }
    /*
                 if ($("#frmVentaZ #mesanoz").val() == "") {
                    alertify.warning("Por favor ingresar Mes de Televenta");
                    $("#frmVentaZ #mesanoz").focus();
                    return false;
                }
       */   
                if ($("#frmVentaZ #lbltelefono").val() == "") {
                    alertify.warning("Por favor ingresar Telefono");
                    $("#frmVentaZ #lbltelefono").focus();
                    return false;
                }
          
    
                /*
                if ($("#frmVentaZ #lblleadidz").val() == "") {
                    alertify.warning("Por favor ingresar Lead ID");
                    $("#frmVentaZ #lblleadidz").focus();
                    return false;
                }
                */

                    if ($("#frmVentaZ #lbltipodoc").val() == "") {
                           alertify.warning("Por favor Seleccionar Tipo Documento");
                           $("#frmVentaZ #lbltipodoc").focus();
                           return false;
                        }
                        
                        if ($("#frmVentaZ #lbldocumento").val() == "") {
                           alertify.warning("Por favor ingresar Documento");
                           $("#frmVentaZ #lbldocumento").focus();
                           return false;
                        }
                        
                        if ($("#frmVentaZ #lbltipodoc").val() == "RUC") {
                            if ($("#frmVenta #lbldocumento").val().length!=11) {
                               alertify.warning("Por favor ingresar los 11 digitos del RUC");
                               $("#frmVenta #lbldocumento").focus();
                               return false;
                            }
                            
                        if ($("#frmVentaZ #lbldocumento").val().substr(0,2)==10 || $("#frmVenta #lbldocumento").val().substr(0,2)==20) {
                              
                            }else{
                                 alertify.warning("Por favor ingresar correctamente el RUC debe comenzar 10 o 20");
                               $("#frmVentaZ #lbldocumento").focus();
                               return false;
                            }
                            
                            
                        }
                        
                        if ($("#frmVentaZ #lbltipodoc").val() == "DNI") {
                            if ($("#frmVentaZ #lbldocumento").val().length!=8) {
                               alertify.warning("Por favor ingresar los 8 digitos del DNI");
                               $("#frmVentaZ #lbldocumento").focus();
                               return false;
                            }
                        }                  

                if ($("#frmVentaZ #lbltipotransf").val() == "") {
                    alertify.warning("Por favor Seleccionar Tipo de Transferencia");
                    $("#frmVentaZ #lbltipotransf").focus();
                    return false;
                }

                return true;
            }
        
        </script>
        <script>
            function limpiarFormulario(){
                
                console.log('Limpiar Formulario');
                
                $('#lblmatriculaz').val('');
                $('#lblidusuarioz').val('');
                $('#lblnombclientez').val('');
                $('#lbltipotvz').val('');
            }
             $('#btnExportarTVLeads').on('click', function(e){
                            Swal.fire({
                                title: '¿Desea Exportar a CSV?',
                                text: "Está accediendo a un información de propiedad de VERISURE PERU SAC; para ejercer esta acción asegúrese de contar con la autorización de la empresa o su Jefe Directo por escrito. Le recordamos que el uso de esta información se encuentra estrictamente limitado al uso indicado en dicha autorización. El acceso no autorizado a la información o su uso indebido del mismo está prohibido y es contrario a la Política Corporativa de Seguridad y a la legislación vigente. Si usted revela información de VERISURE PERU SAC o de sus clientes sin previa autorización podrá estar incurriendo en una violación de la Normativa Corporativa y del Reglamento Interno, que podría incluso suponer la posible comisión de un delito o falta, con la consecuencia de despido.”",
                                icon: 'info',
                                showCancelButton: true,
                                confirmButtonColor: '#333',
                                confirmButtonText: 'Si, descargar'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.open('./ajax/spout/exportTeleventaLead.php');
                                }
                            })
            })            
        </script>

    </body>
</html>
