<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
    }


    if (($_SESSION['pzvtatc']+$_SESSION['pzmktcgestionados'])==0) {
        header("location: ./denegado.php");
		exit;
    }

    date_default_timezone_set('America/Lima');
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date)
    {
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date)
    {
        return date('Y-m-d', strtotime($date));
    }

    include 'config/db.php';
    include 'config/conexion.php';
    include 'helper/helper_validacion.php';

    $rc=NULL;

    if (isset($_GET['idventa'])) {
        $idventa = sanitizaCampo($_GET['idventa'], 'sanitizeint|scapestring|htmlspecialchars', $con);
        $idventa = htmlspecialchars($idventa);        
    } else {
    	header("location: ./denegado.php");
    	exit;
    }
    
    if (isset($_GET['rc'])) {
        $rc = sanitizaCampo($_GET['rc'], 'sanitizestring|htmlspecialchars', $con);
        $rc=htmlspecialchars($rc);
    } else {
        $rc = NULL;
    }
    
    $fechames=date("M-Y");
    
    $IdPerfil = $_SESSION['id_perfil'];
    
    //AGREGAR Funciones
    include 'ajax/funciones/Telecierre.php';
  
    $totalGestiones = totalGestiones($idventa);
    

try{       
$stmt = $con->prepare("SELECT
        u.IdUsuario,
        v.Matricula,
        v.Comercial,
        v.CC,
        v.JefeVenta,
        CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
        v.EstadoVenta,
        v.CategoriaVenta,
        v.TipoVenta,
        v.Segmento,
        v.MesesAutorizado,
        v.NProspecto,
        v.NContrato,
        v.IdCliente,
        c.NombApellido Cliente,
        c.Correo,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.IdGeografico,
        g.Distrito,
        g.Provincia,
        v.PrecioKit,
        v.TotalExtra,
        v.ResumenVenta,
        v.ExtraAutorizado,
        v.FormaPago,
        v.N590,
        v.PAI,
        v.CCOriginal,
    	v.EstadoVisita,
        v.EstadoTelecierre,
        v.TCGestor,
        v.TCComentario,
        v.PrecioKITOriginal,
        v.TotalExtraOriginal,
        v.ResumenVentaOriginal,
        v.ExtraAutorizadoOriginal,
        v.FormaPagoOriginal,
        v.MesesAutorizadoOriginal,
        v.PAIOriginal,
        v.TCMotivoNoVenta,
        v.TCTipoVenta,
    	DATE_FORMAT(v.FechaVisita,'%d/%m/%Y') FechaVisita,
    	TIME_FORMAT(v.HoraVisita,'%r') HoraVisita,
    	DATE_FORMAT(v.FVencimientoVisita,'%d/%m/%Y') FVencimientoVisita,
    	v.GestorMKT,
    	CONCAT(mk.Nombres,' ',mk.Apellidos) Operador,
    	v.OrigenVisita,
    	v.ComentarioVisita,
        v.TCVisitado,
        v.TCScoring,
        v.TCCompetencia,
        v.FechaGestionTC,
        agen.IdAgenda,
        agen.InstaladoX,
        agen.MatriculaTec,
        CONCAT(t.Nombres,' ',t.Apellidos) Instalador,
        t.LN LNInstalador,
        DATE_FORMAT(agen.FechaInst, '%d/%m/%Y') FechaInst, 
        TIME_FORMAT(agen.HoraInst,'%r') HoraInst,
        agen.Comentario,
        agen.MotivoInviable,
        agen.MotivoCancelada,
        agen.Repercusion,
        f.MotivoIncidencia,
        DATE_FORMAT(f.FechaRecepcionDOC, '%d/%m/%Y') FechaRecepcionDOC,
        DATE_FORMAT(f.FechaFacturacion, '%d/%m/%Y') FechaFacturacion,
        f.DOCOriginal,
        f.Segmentacion,
        f.Pago,
        f.Autoriza,
        f.DNI,
        f.ElementosCTOPS,
        f.DOCPAI,
        f.FaltaDOC,
        f.RehacerCTO,
        f.Afiliacion,
        f.Prospecto_NroGuia,
        f.FueraHora,
        c.IdDocTC,
        doc.TipoDocumento,
        doc.Documento,
        docv.TipoDocumento as TipoDocVisita,
        docv.Documento as DocumentoVisita,
        v.TipoKIT,
        v.CantidadExtras,
        v.CantidadRegalo,
        v.DescMeses,
        v.pagoAdelantado,
        v.TotalCuotaMonitoreo,
        v.FormaPagoCuota,
        DATE_FORMAT(v.FechaHoraREG, '%Y-%m-%d') FechaHoraREG,
        v.TCFechaRellamada,
        v.TCHoraRellamada,
        vi.TipoCamaraKit, 
        vi.VendidaCamaraInternaExtra,
        vi.CantidadCamaraInternaExtra,
        vi.PrecioCamaraInternaExtra,
        vi.VendidaCamaraExternaExtra,
        vi.CantidadCamaraExternaExtra,
        vi.PrecioCamaraExternaExtra,
        v.FechaTCFI,
        v.IteraccionAgenda,
        v.IdConsultaScoringTCTV,
        sc.NumeroDocumento as DocumentoScoring,
        CASE WHEN sc.TipoDocumento=6 THEN sc.RazonSocial ELSE CONCAT(sc.Nombres,' ',sc.ApellidoPaterno,' ',sc.ApellidoMaterno) END as NombreScoring,
        sc.NumeroOperacion,
        v.Vueltas,
        v.FechaUltimaGestion,
        v.referidoHabilitadoTVTC,
        v.ComentarioCancelacion,
        pp.IdDepartamental,
        DATE_FORMAT(vtacert.FechaCierre,'%d/%m/%Y') FechaCierre,
        vtacert.TipoCierre,
        vtacert.MotivoIncidencia as MotivoIncidenciaCert,
        vtacert.SolucionIncidencia,
        vtacert.IncidenciaTecnica,
        vtacert.FormaPago as FormaPagoCert,
        vtacert.Comentario as ComentarioCert,
        v.GestorCertVenta,
        CONCAT(cer.Nombres,' ',cer.Apellidos) NombGestorCertVenta,
        v.FechaApertura,
        sc.Nombres as NombresScoring,
        sc.ApellidoPaterno as ApellidoPaternoScoring,
        sc.ApellidoMaterno as ApellidoMaternoScoring,
        sc.TipoDocumento as TipoDocumentoScoring,
        v.TCAcuerdoComercial,
        agen.Desplazamiento,
        v.ProspectoAbierto,
        v.FechaProspectoAbierto,
        refc.NombreColaborador,
        v.MotivoTransferencia,
        v.conSistema,
        v.empresaSistema        
        FROM yifi58ge_dbVENTAS.tblventa v 
        INNER JOIN yifi58ge_dbUSUARIO.tblusuario u on v.IdUsuario=u.IdUsuario 
        INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
        INNER JOIN yifi58ge_dbUSUARIO.tblusuario m on m.Matricula=u.Manager
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
        INNER JOIN yifi58ge_dbVENTAS.tblagenda agen on agen.IdVenta=v.IdVenta
        INNER JOIN yifi58ge_dbVENTAS.tblfacturacion f on f.IdVenta=v.IdVenta
        LEFT JOIN yifi58ge_dbUSUARIO.tblusuario t on t.Matricula=agen.MatriculaTec
        LEFT JOIN yifi58ge_dbUSUARIO.tblusuario mk on mk.Matricula=v.GestorMKT
        LEFT JOIN yifi58ge_dbVENTAS.tbldocumento doc on doc.IdDoc=c.IdDocTC
        LEFT JOIN yifi58ge_dbVENTAS.tbldocumento docv on docv.IdDoc=c.IdDocVisita
        LEFT JOIN yifi58ge_dbVENTAS.tblventainformacionarlo vi on vi.IdVenta=v.IdVenta
        LEFT JOIN yifi58ge_dbVENTAS.tbltmpscoring sc on sc.IdConsultaScoring=v.IdConsultaScoringTCTV
        LEFT JOIN yifi58ge_dbVENTAS.tbldistrital dd on dd.CodUbigeoReniec=g.CodUbigeoReniec
        LEFT JOIN yifi58ge_dbVENTAS.tblprovincial pp on pp.IdProvincial=dd.IdProvincial
        LEFT JOIN yifi58ge_dbVENTAS.tblcertificacionventa vtacert on vtacert.IdCertVenta=v.IdCertVenta
        LEFT JOIN yifi58ge_dbUSUARIO.tblusuario cer on cer.Matricula=v.GestorCertVenta
        LEFT JOIN yifi58ge_dbREFERIDO.tblreferidocolaborador refc on refc.IdVenta=v.IdVenta

        WHERE v.IdVenta=?");
$stmt->bind_param('i', $idventa);
$stmt->execute();
$stmt->store_result();
$stmt->bind_result($idu,
$matricula,
$comercial,
$dc,
$matjefe,
$jefeventa,
$estadoventa,
$categoriaventa,
$tipoventa,
$segmento,
$mesesautorizados,
$nprospecto,
$ncontrato,
$idcliente,
$cliente,
$correo,
$movil,
$fijo,
$direccion,
$idgeografico,
$distrito,
$provincia,
$preciokit,
$totalextra,
$resumenventa,
$regaloutorizado,
$formadepago,
$n590,
$PAI,
$CCOriginal,
$estadovisita,
$estadotelecierre,
$TCGestor,
$TCComentario,
$PrecioKITOriginal,
$TotalExtraOriginal,
$ResumenVentaOriginal,
$ExtraAutorizadoOriginal,
$FormaPagoOriginal,
$MesesAutorizadoOriginal,
$PAIOriginal,
$TCMotivoNoVenta,
$TCTipoVenta,
$fechavisita,
$horavisita,
$fvencimientovisita,
$matriculagestormkt,
$operadormkt,
$origenvisita,
$comentariovisita,
$TCVisitado,
$TCScoring,
$TCCompetencia,
$TCFechaGestion,
$idagenda,
$instaladox,
$matriculatec,
$nomreinstalador,
$lninstalador,
$fechainstalacionver,
$horainstalacionver,
$comentarioagenda,
$motivoinviable,
$motivocancelado,
$repercucion,
$factmotivoincidencia,
$factfecharecepciondoc,
$factfechafacturacion,
$factdocoriginal,
$factsegmentacion,
$factpago,
$factautoriza,
$factdni,
$factelementosctops,
$factdocpai,
$factfaltadoc,
$factrehacercto,
$factafiliacion,
$factprospecto_nroguia,
$factfuerahora,
$IdDocTC,
$TipoDocumento,
$Documento,
$TipoDocVisita,
$DocumentoVisita,
$TipoKIT,
$CantidadExtras,
$CantidadRegalo,
$DescMeses,
$pagoAdelantado,
$TotalCuotaMonitoreo,
$FormaPagoCuota,
$FechaHoraREG,
$TCFechaRellamada,
$TCHoraRellamada,
$TipoCamaraKit,
$VendidaCamaraInternaExtra,
$CantidadCamaraInternaExtra,
$PrecioCamaraInternaExtra,
$VendidaCamaraExternaExtra,
$CantidadCamaraExternaExtra,
$PrecioCamaraExternaExtra,
$FechaTCFI,
$IteraccionAgenda,
$IdConsultaScoringTCTV,
$DocumentoScoring,
$NombreScoring,
$CodigoOperacionScoring,
$Vueltas,
$FechaUltimaGestion,
$referidoHabilitado,
$ComentarioCancelacion,
$IdDepartamental,
$FechaCierre,
$TipoCierre,
$MotivoIncidencia,
$SolucionIncidencia,
$inci_tecnica,
$FormaPagoCert,
$ComentarioCert,
$GestorCertVenta,
$NombGestorCertVenta,
$FechaApertura,
$NombresScoring,
$ApellidoPaternoScoring,
$ApellidoMaternoScoring,
$TipoDocumentoScoring,
$TCAcuerdoComercial,
$Desplazamiento,
$prospectoAbierto,
$FechaProspectoAbierto,
$NombreColaborador,
$MotivoTransferencia,
$conSistema,
$empresaSistema
);
$stmt->fetch();
$stmt->close();

if (empty($Vueltas)) {
    $Vueltas = 0;
}
if (empty($IteraccionAgenda)) {
    $IteraccionAgenda = 0;
}  

} catch(PDOException $e) {
    echo "Error: " . $e->getMessage();
}   
    $html=NULL;
    try {
        
    $stmtJE = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) JefeVenta FROM yifi58ge_dbUSUARIO.tblusuario u  where u.CC=? AND u.LN='11' AND (u.Categoria ='JE' OR u.Categoria ='COACH' OR u.Categoria ='DEL') LIMIT 50");
    $stmtJE->bind_param('i', $CCOriginal);
    $stmtJE->execute();
    $stmtJE->store_result();
    $stmtJE->bind_result($MatriculaJE,$JefeVentaJE);

    if($stmtJE->num_rows>0){
        while( $row = $stmtJE->fetch()){
            if($MatriculaJE==$matjefe){
               $html .= '<option value="'.$MatriculaJE.'" selected>'.$MatriculaJE.' - '.utf8_encode($JefeVentaJE).' </option>';
            }else{
               $html .= '<option value="'.$MatriculaJE.'">'.$MatriculaJE.' - '.utf8_encode($JefeVentaJE).' </option>';            
            }       
        }
    }else{
        $html .= '<option>No se encontraron resultado</option>';
    }
    
    $stmtJE->close();
 
    } catch(PDOException $e) {
    echo "Error: " . $e->getMessage();
    } 
    


$html_tecnico=NULL;
if($lninstalador=="" || empty($lninstalador)){
$html_tecnico.= '<option></option>';
}else{

    try {
        
    $stmtTecnico = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador FROM yifi58ge_dbUSUARIO.tblusuario u INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea WHERE u.LN=?");
    $stmtTecnico->bind_param('i', $lninstalador);
    $stmtTecnico->execute();
    $stmtTecnico->store_result();
    $stmtTecnico->bind_result($MatriculaTEC,$InstaladorTEC);

    if($stmtTecnico->num_rows>0){
        while( $row = $stmtTecnico->fetch()){
            if($MatriculaTEC==$matriculatec){
               $html_tecnico .= '<option value="'.$MatriculaTEC.'" selected>'.$MatriculaTEC.' - '.utf8_encode($InstaladorTEC).' </option>';
            }else{
               $html_tecnico .= '<option value="'.$MatriculaTEC.'">'.$MatriculaTEC.' - '.utf8_encode($InstaladorTEC).' </option>';            
            }       
        }
    }else{
        $html_tecnico .= '<option>No se encontraron resultado</option>';
    }
    
    $stmtTecnico->close();
 
    } catch(PDOException $e) {
    echo "Error: " . $e->getMessage();
    } 



}
    $html_tc=NULL;


    if($TCGestor=="" || empty($TCGestor)){
        $html_tc.= '<option value="" selected></option>';
    }else{

    try {
        
    $stmtTC = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Telecierre FROM yifi58ge_dbUSUARIO.tblusuario u  INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea WHERE a.IdArea='17' and u.Estado='Activo'");
    $stmtTC->execute();
    $stmtTC->store_result();
    $stmtTC->bind_result($MatriculaTC,$Telecierre);

    if($stmtTC->num_rows>0){
        while( $row = $stmtTC->fetch()){
            if($MatriculaTC==$TCGestor){
               $html_tc .= '<option value="'.$MatriculaTC.'" selected>'.$MatriculaTC.' - '.utf8_encode($Telecierre).' </option>';
            }else{
               $html_tc .= '<option value="'.$MatriculaTC.'">'.$MatriculaTC.' - '.utf8_encode($Telecierre).' </option>';            
            }       
        }
    }else{
        $html_tc .= '<option>No se encontraron resultado</option>';
    }
    
    $stmtTC->close();
 
    } catch (\Exception $e) {
      echo "Error: " . $e->getMessage();
    }

    }


	/* INFORMACIÓN DE AFILIACIÓN */
	if(!empty($ncontrato)){
        /* CONSULTA PREPARADA N°05 */
	    $queryAfiliacion = "SELECT status,ACTION_DESCRIPTION,dataMap FROM yifi58ge_dbREFERIDO.tblafiliacion where beneficiaryId=?";
	    
    	try{       
            $stmtAfiliacion = $con->prepare($queryAfiliacion);
            $stmtAfiliacion->bind_param('i', $ncontrato);
            $stmtAfiliacion->execute();
            $stmtAfiliacion->store_result();
            $stmtAfiliacion->bind_result($statusAfiliacion, $actionDescriptionAfiliacion, $dataMapAfiliacion);
            
            if($stmtAfiliacion->num_rows > 0){
                while($rowafi = $stmtAfiliacion->fetch()){
	                $estadoafiliacion = $statusAfiliacion;
	                $ACTION_DESCRIPTION = $actionDescriptionAfiliacion;
	                $dataMap = $dataMapAfiliacion;
	                
	                if(isset($dataMap) && !empty($dataMap)){
	                    $objAfiliacion = json_decode($dataMap, true);
	                    if(isset($objAfiliacion['mensaje_autorizacion']['dataMap']['CARD'])){
	                        $card=$objAfiliacion['mensaje_autorizacion']['dataMap']['CARD'];
	                        $tipocuenta='Tarjeta';
	                    } else {
	                        $card='';
	                        $tipocuenta='';
	                    }
	                }     
                }
            } else {
	            $estadoafiliacion = 'Pendiente';
	            $ACTION_DESCRIPTION = '';
	            $dataMap = '';
	            $card = '';
	            $tipocuenta = '';
            }        
            
            $stmtAfiliacion->close();
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }
        
        /* CONSULTA PREPARADA N°06 */
        $variablecuenta = array('Diners Club','visa','mastercard','American Express');
        $queryVariableCuenta = "SELECT id,status,motivo,numero,tipo,correo FROM yifi58ge_dbREFERIDO.tblmdpafiliacion where ncontrato=?"; 
        
    	try{       
            $stmtVariableC = $con->prepare($queryVariableCuenta);
            $stmtVariableC->bind_param('i', $ncontrato);
            $stmtVariableC->execute();
            $stmtVariableC->store_result();
            $stmtVariableC->bind_result($idAfiliacionMDP, $statusAfiliacionMDP, $motivoAfiliacionMDP, $numeroAfiliacionMDP, $tipoAfiliacionMDP, $correoAfiliacionMDP);
            
            if($stmtVariableC->num_rows > 0){
                while($rowvariablec = $stmtVariableC->fetch()){
    	            $idnmdp = $idAfiliacionMDP;
    	            $estadoafiliacionmdp = $statusAfiliacionMDP;
    	            $motivomdp = $motivoAfiliacionMDP;
    	            $card = $numeroAfiliacionMDP;
    	            $tipo = $tipoAfiliacionMDP;
    	            $correoenviomdp = $correoAfiliacionMDP;
    	            
    	            if(in_array($tipo, $variablecuenta)){
    	               $tipocuenta = 'Tarjeta'; 
    	            } else {
    	               $tipocuenta = 'Cuenta'; 
    	            }  
                }
            } else {
                $idnmdp='';
    	        $estadoafiliacionmdp='';
    	        $motivomdp='';
    	        $tipo='';
    	        $correoenviomdp='';
    	        $tipocuenta='';
    	    }      
            
            $stmtVariableC->close();
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }        
        
	    
	} else {
        $estadoafiliacion = 'Pendiente';
	    $ACTION_DESCRIPTION = '';
	    $dataMap = '';
	    $card = '';
	    $tipocuenta = '';	    
	}
    
    

?>

<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
       <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <link rel="stylesheet" href="admin/bower_components/sweetalert2/dist/sweetalert2.min.css">
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
        <!-- JQUERY -->
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
        <!-- DATETIME PICKER -->
        <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css"/>
        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
        <!-- Toogle -->
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
        <!-- CSS EDITAR FACTURACION -->
        <link rel="stylesheet" href="css/editarfacturacion.css">
        <!-- STYLES -->
        <style>
            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;              
            }

            .preloader{
                background-color:#FFF;
                width: 100%;
                height: 100%;
                position: absolute;
                z-index: 1;
            }

            .dataTables_wrapper .myfilter .dataTables_filter{
                float:left
            }
            
            .dataTables_wrapper .mylength .dataTables_length{
                float:right
            }
            
            div.dataTables_scrollBody thead th {
                vertical-align: top;
            }
            
            td {
                max-width: 250px;
                overflow: hidden;
                white-space: nowrap;
                text-overflow: ellipsis;

            }
            
            .espacio{
                height:10px;
            }
            
           .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #frmEditarVenta .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 300%;

            }
            #slider section{
                width: 100%;
            }

            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo { 
                color: #FFFFFF; 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                color: #FFFFFF; 
                background-color: #616161;  
                border-color: #444444; 
            } 

            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                background-image: none; 
            } 

            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .ocultar{
                display:none;
            }

        </style>
        <style>
            .main-header,.main-sidebar,.left-side{position:fixed}
       
            .main-header {
                top: 0;
                right: 0;
                left: 0
            }
            
            .content-wrapper,.right-side {
                padding-top: 50px
            }

            @media (max-width:767px) {
                 .content-wrapper,
                 .right-side {
                    padding-top: 100px
                }
            }

            .layout-boxed .wrapper {
                max-width: 100%
            }

            .wrapper {
                overflow: hidden
            
             .control-sidebar {
                position: fixed;
                height: 100%;
                overflow-y: auto;
                padding-bottom: 50px
            }       
        </style>
        <style>
            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                   -moz-border-radius: 5px;
                        border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                   -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        
                    z-index: 1051 !important;    
            }

            hr {
            height: 4px;
            width: 100%;
            background-color: #ecf0f5;
            
            }
            
            hr {
                /* margin-top: 20px; */
                margin-bottom: 20px;
                border: 0;
                /* border-top: 1px solid #eee; */
            }
            
            hr {
                display: block;
                unicode-bidi: isolate;
                -webkit-margin-before: 0.5em;
                -webkit-margin-after: 0.5em;
                -webkit-margin-start: auto;
                -webkit-margin-end: auto;
                overflow: hidden;
                border-style: inset;
            }

            .box.box-custom {
                border-top-color: #ffffff;
            }

            .box {
                position: relative;
                border-radius: 3px;
                background: #ffffff;
                border-top: 3px solid #d2d6de;
                margin-bottom: 5px;
                width: 100%;
                box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            }


            .no-search .select2-search {
                display:none
            }

            .swal2-popup {
                font-size: 1.5rem!important;
            }
            .swal2-styled.swal2-confirm {
                background-color: #e4002b !important;
            }            

        </style>
        <style>
            .subtitulo {
                text-decoration: underline;
                font-weight: bold;
            }
            label {
                font-weight: 400;
            }            
        </style>
    <!-- ESTILOS DE SCORING-->
    <style>
                .bg-deuda{
                    color: #000;
                    background-color: #ffffff !important;
                }
                
                .bg-visita{
                    color: #fff;
                    background-color: #008000 !important;
                }
                .bg-gestion{
                 color: #fff;
                background-color: #6a6659 !important;   
                }
                .bg-televenta{
                    color: #fff;
                    background-color: #f39c12 !important;
                }
        .btn-verisure {
            font-family: "Avenir Next LT W01 Demi", sans-serif;
            font-weight: normal !important;
            font-style: normal !important;
            box-sizing: border-box;
            -moz-box-sizing: border-box;
            font-size: 15px;
            color: #EE0008;
            border: 1px solid #eb3e3e;
            border-radius: 40px;
            display: inline-block;
            /*padding: 15px 24px 15px 44px;*/
            text-decoration: none;
            text-align: center;
            line-height: 28px;
            text-transform: uppercase;
        }


        .btn-verisure {
            color: #ffffff;
            background-color: #FF0033;
            border-color: #FF0033;
        }

        .btn-verisure:hover,
        .btn-verisure:focus,
        .btn-verisure:active,
        .btn-verisure.active,
        .open .dropdown-toggle.btn-verisure {
            color: #ffffff;
            background-color: #a62828;
            border-color: #a62828;
        }

        .btn-verisure:active,
        .btn-verisure.active,
        .open .dropdown-toggle.btn-verisure {
            background-image: none;
        }

        .btn-verisure.disabled,
        .btn-verisure[disabled],
        fieldset[disabled] .btn-verisure,
        .btn-verisure.disabled:hover,
        .btn-verisure[disabled]:hover,
        fieldset[disabled] .btn-verisure:hover,
        .btn-verisure.disabled:focus,
        .btn-verisure[disabled]:focus,
        fieldset[disabled] .btn-verisure:focus,
        .btn-verisure.disabled:active,
        .btn-verisure[disabled]:active,
        fieldset[disabled] .btn-verisure:active,
        .btn-verisure.disabled.active,
        .btn-verisure[disabled].active,
        fieldset[disabled] .btn-verisure.active {
            background-color: #555758;
            border-color: #555758;
        }

        .btn-verisure .badge {
            color: #FF0033;
            background-color: #ffffff;
        }



        .btn-verisurecerrar {
            font-family: "Avenir Next LT W01 Demi", sans-serif;
            font-weight: normal !important;
            font-style: normal !important;
            box-sizing: border-box;
            -moz-box-sizing: border-box;
            font-size: 15px;
            color: #444;
            border: 1px solid #ddd;
            border-radius: 40px;
            display: inline-block;
            /*padding: 15px 24px 15px 44px;*/
            text-decoration: none;
            text-align: center;
            line-height: 28px;
            text-transform: uppercase;
        }


        .btn-verisurecerrar {
            background-color: #f4f4f4;
            color: #444;
            border-color: #ddd;
        }

        .btn-verisurecerrar:hover,
        .btn-verisurecerrar:focus,
        .btn-verisurecerrar:active,
        .btn-verisurecerrar.active,
        .open .dropdown-toggle.btn-verisurecerrar {
            color: #333;
            background-color: #e6e6e6;
            border-color: #adadad;
        }

        .btn-verisurecerrar:active,
        .btn-verisurecerrar.active,
        .open .dropdown-toggle.btn-verisurecerrar {
            background-image: none;
        }

        .btn-verisurecerrar.disabled,
        .btn-verisurecerrar[disabled],
        fieldset[disabled] .btn-verisurecerrar,
        .btn-verisurecerrar.disabled:hover,
        .btn-verisurecerrar[disabled]:hover,
        fieldset[disabled] .btn-verisurecerrar:hover,
        .btn-verisurecerrar.disabled:focus,
        .btn-verisurecerrar[disabled]:focus,
        fieldset[disabled] .btn-verisurecerrar:focus,
        .btn-verisurecerrar.disabled:active,
        .btn-verisurecerrar[disabled]:active,
        fieldset[disabled] .btn-verisurecerrar:active,
        .btn-verisurecerrar.disabled.active,
        .btn-verisurecerrar[disabled].active,
        fieldset[disabled] .btn-verisurecerrar.active {
            background-color: #e7e7e7;
        }

        .btn-verisurecerrar .badge {
            background-color: #f4f4f4;
            color: #444;
        }

    </style>
<style>
                #divLoading {
                      background: rgba(66,118,164,0.4);
                      width: 100%;
                      height: 100%;
                      min-height: 100%;
                      position: absolute;
                      top: 0;
                      left: 0;
                      z-index: 999999999;
                      display:none;
                    }
                #divLoadingBoton {
                      background: rgba(66,118,164,0.4);
                      width: 100%;
                      height: 100%;
                      min-height: 100%;
                      position: absolute;
                      top: 0;
                      left: 0;
                      z-index: 999999999;
                      display:none;
                    }
                .spinner {
                  margin: 300px auto 0;
                  width: 70px;
                  text-align: center;
                }
                
                .spinner > div {
                  background-color: #e4002b;
                  width: 18px;
                  height: 18px;
                  border-radius: 100%;
                  display: inline-block;
                  -webkit-animation: sk-bouncedelay 1.4s infinite ease-in-out both;
                  animation: sk-bouncedelay 1.4s infinite ease-in-out both;
                }
                
                .spinner .bounce1 {
                  -webkit-animation-delay: -0.32s;
                  animation-delay: -0.32s;
                }
                
                .spinner .bounce2 {
                  -webkit-animation-delay: -0.16s;
                  animation-delay: -0.16s;
                }

                .spinnerBoton {
                  margin: 300px auto 0;
                  width: 70px;
                  text-align: center;
                }
                
                .spinnerBoton > div {
                  background-color: #e4002b;
                  width: 18px;
                  height: 18px;
                  border-radius: 100%;
                  display: inline-block;
                  -webkit-animation: sk-bouncedelay 1.4s infinite ease-in-out both;
                  animation: sk-bouncedelay 1.4s infinite ease-in-out both;
                }
                
                .spinnerBoton .bounce1Boton {
                  -webkit-animation-delay: -0.32s;
                  animation-delay: -0.32s;
                }
                
                .spinnerBoton .bounce2Boton {
                  -webkit-animation-delay: -0.16s;
                  animation-delay: -0.16s;
                }
                
                @-webkit-keyframes sk-bouncedelay {
                  0%, 80%, 100% { -webkit-transform: scale(0) }
                  40% { -webkit-transform: scale(1.0) }
                }
                
                @keyframes sk-bouncedelay {
                  0%, 80%, 100% {
                    -webkit-transform: scale(0);
                    transform: scale(0);
                  } 40% {
                    -webkit-transform: scale(1.0);
                    transform: scale(1.0);
                  }
                }        
    </style>    
    </head>
    <body class="sidebar-collapse skin-red sidebar-mini">
        <div id="divLoading" style="display: none;height: auto; min-height: 100%;">
            <div class="spinner">
              <div class="bounce1"></div>
              <div class="bounce2"></div>
              <div class="bounce3"></div>
            </div>
        </div>        
        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php
            $marketing = "active";
            include 'admin/main-sidebar.php';
            ?>
            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        EDITAR TELECIERRE
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li><a href="ventadc511.php">Telecierre</a></li>
                        <li class="active">Editar</li>
                    </ol>
                </section>
                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-md-2"></div>
                        <div class="col-md-8">
                            <!-- /.box-header -->
                            <div class="box box-danger">
                                <div class="box-header">
                                    <h3 class="box-title">EDITAR    <?php 
                                                                        if ($categoriaventa == "Online"){
                                                                            $nombc="VENTA ONLINE";
                                                                        }else if($categoriaventa == "Ficha"){
                                                                            $nombc="VENTA FICHA";
                                                                        }else if($categoriaventa == "VAsignada"){
                                                                            $nombc="VISITA ASIGNADA";
                                                                        }else if($categoriaventa == "Cancelada"){
                                                                            $nombc="CANCELADA";
                                                                        }else if($categoriaventa == "NoVendida"){
                                                                            $nombc="NO VENDIDA";
                                                                        }else if($categoriaventa == "Delegacion"){
                                                                            $nombc="VENTA DELEGACIÓN";
                                                                        }
                                                                        echo $nombc." - ".$nprospecto." | ".$ncontrato 
                                                                    ?>
                                    </h3>
                                    <input id="IdPerfil" name="IdPerfil" value="<?php echo $IdPerfil;?>" hidden="">
                                    <input id="lblcat" name="lblcat" value="<?php echo $categoriaventa;?>" hidden="">
                                    <input type="hidden" id="idVenta" name="idVenta" value="<?php echo $idventa; ?>">
                                    <div class="box-tools pull-right">
                                        <?php 
                                            if($estadoventa=='Facturada' || $estadoventa=='PorFacturar' || $nombacceso=='test'){
                                            }else{ 
                                        ?>
                                                <a class="btn btn-nuevo btn-sm" id="btnGuardarEditarVenta" href="#"><i class="fa fa-save"></i> Guardar</a>
                                        <?php
                                            } 
                                        ?>
                                        <a href="<?php if($rc=='gestionados'){echo 'tcgestionados.php';}else {echo 'ventadc511.php';} ?>" class="btn btn-danger btn-sm" ><i class="fa fa-reply"></i> Regresar</a>
                                    </div>
                                </div>
                                <div class="espacio"></div>
                            </div>
                            <!-- FORMULARIO -->
                            <form id="frmEditarVenta" class="form-horizontal" method="post">
                                <input type="hidden" id="FechaTCFI" name="FechaTCFI" value="<?php echo $FechaTCFI;?>">
                                <!-- INFORMACION DEL CLIENTE -->
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                        <h5>INFORMACION DE VENTA</h5>
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                        </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                        <div style="width:100%;border-collapse: separate;padding: 20px;">
                                            
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="width:15%;font-size: 12px">MATRICULA:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input name="lblmatricula" id="lblmatricula" class="form-control input-sm" value="<?php echo $matricula;?>" style="width: 100%;" disabled/>
                                                    <input id="lblidusuario" name="lblidusuario" value="<?php echo $idu;?>" hidden="">
                                                </div>
                                                <div class="col-md-2">
                                                    <label style="width:15%;font-size: 12px">COMERCIAL:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input name="lblnombcomercial" id="lblnombcomercial" class="form-control input-sm" style="width: 100%;" value="<?php echo $comercial;?>" disabled>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">DC:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input name="lbldc" id="lbldc" class="form-control input-sm" style="width: 100%;" value="<?php echo $CCOriginal;?>" disabled>
                                                </div>
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">	JEFE VENTA:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control input-sm" name="lbljefeventa" id="lbljefeventa" style="width: 100%;" disabled="disabled">
                                                        <?php echo $html;?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">ESTADO VISITA:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text" name="lblestadovisita" id="lblestadovisita" value="<?php echo $estadovisita; ?>" class="form-control input-sm" style="width: 100%;" readonly="readonly"/>
                                                </div>
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">ESTADO VENTA:</label>
                                                </div>
                                                <div class="col-md-4 selecteleventa">
                                                    <?php 
                                                        if ($estadoventa == "Instalada" || $estadoventa == "Incidencia" || $estadoventa == "IncidenciaGestCorreo" || $estadoventa == "IncidenciaGestValija" || $estadoventa == "NoDoc" || $estadoventa == "DocEnvi") {
                                                    ?>
                                                        <select name="lblestadoventa" id="lblestadoventa" class="form-control input-sm">
                                                            <option>Seleccione</option>
                                                            <?php 
                                                                if ($estadoventa == "Instalada"){
                                                            ?>
                                                            <option value="Instalada"<?php if ($estadoventa == "Instalada") {echo "selected";}?> hidden="">Instalada</option>
                                                            <option value="DocEnvi"<?php if ($estadoventa == "DocEnvi") {echo "selected";}?>>DocEnvi</option>
                                                            <?php 
                                                                }
                                                                if ($estadoventa == "Incidencia" || $estadoventa == "IncidenciaGestCorreo" || $estadoventa == "IncidenciaGestValija") {
                                                            ?>
                                                            <option value="Incidencia" <?php if ($estadoventa == "Incidencia") { echo "selected";} ?> hidden="">Incidencia</option>
                                                            <option value="IncidenciaGestCorreo" <?php if ($estadoventa == "IncidenciaGestCorreo") { echo "selected";} ?>>IncidenciaGestCorreo</option>
                                                            <option value="IncidenciaGestValija" <?php if ($estadoventa == "IncidenciaGestValija") { echo "selected";} ?>>IncidenciaGestValija</option>
                                                            <?php
                                                                }
                                                                if ($estadoventa == "NoDoc" || $estadoventa == "DocEnvi") {
                                                            ?>
                                                            <option value="NoDoc" <?php if ($estadoventa == "NoDoc") { echo "selected"; } ?> hidden="">NoDoc</option>
                                                            <option value="DocEnvi" <?php if ($estadoventa == "DocEnvi") { echo "selected"; } ?>>DocEnvi</option>
                                                            <?php
                                                                }
                                                            ?>
                                                        </select>
                                                    <?php 
                                                        } 
                                                        else { 
                                                    ?>
                                                        <input type="text" name="lblestadoventa" id="lblestadoventa" value="<?php echo $estadoventa; ?>" class="form-control input-sm" style="width: 100%;" readonly="readonly" />
                                                    <?php 
                                                        } 
                                                    ?>                                            
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">SEGMENTO:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control input-sm" name="lblsegmento" id="lblsegmento" disabled="disabled">
                                                        <option>Seleccione</option>
                                                        <option value="RES"<?php if ($segmento == "RES") {echo "selected";}?>>RES</option>
                                                        <option value="NEG"<?php if ($segmento == "NEG") {echo "selected";}?>>NEG</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-2">
                                                    <label style="width:15%;font-size: 12px">RECURSO:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text" name="lbltipoventa" id="lbltipoventa" value="<?php echo $tipoventa;?>" class="form-control input-sm" style="width: 100%;" readonly="readonly"/>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">N° PROSPECTO:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text" class="form-control input-sm" name="lblnprospecto" id="lblnprospecto" data-inputmask='"mask": "999999"' value="<?php echo $nprospecto;?>" data-mask disabled="disabled">
                                                </div>
                                                <div class="col-md-2">
                                                    <label style="width:15%;font-size: 12px">N° CONTRATO:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text" class="form-control input-sm" name="lblncontrato" id="lblncontrato" data-inputmask='"mask": "9999999"' value="<?php echo $ncontrato;?>" data-mask readonly="readonly">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">ASIGNADO POR:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control selectgestor input-sm" name="lblasignado" id="lblasignado" style="width: 100%;" disabled="disabled">
                                                        <option value="<?php echo $matriculagestormkt; ?>"><?php echo $matriculagestormkt.' - '.$operadormkt; ?></option>
                                                    </select>                                            </div>
                                                <div class="col-md-2">
                                                    <label style="width:15%;font-size: 12px">ORIGEN:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input class="form-control input-sm" name="lblorigen" id="lblorigen" value="<?php echo $origenvisita;?>" disabled="disabled">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">FECHA VISITA:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control pull-right input-sm" id="lblfvisita"  name="lblfvisita" value="<?php echo $fechavisita;?>"  data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled="disabled">
                                                    </div>                                               
                                                </div>
                                                <div class="col-md-2">
                                                    <label style="width:15%;font-size: 12px">HORA VISITA:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="bootstrap-timepicker timepicker">
                                                        <div class="input-group">
                                                            <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhvisita" id="lblhvisita" value="<?php echo $horavisita;?>" disabled="disabled" >
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-clock-o"></i>
                                                            </div>
                                                        </div>
                                                    </div> 
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">FECHA VENCIMIENTO:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control pull-right input-sm" id="lblfvencimiento"  value="<?php echo $fvencimientovisita;?>" name="lblfvencimiento" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled="disabled">
                                                    </div>                                            
                                                </div>
                                                <div class="col-md-2">
                                                    <label style="width:15%;font-size: 12px">MESES AUTORIZADOS:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text" maxlength="3" class="form-control input-sm" id="lblmesesautorizados" name="lblmesesautorizados"  value="<?php echo $mesesautorizados;?>" onkeypress="return filterFloat(event, this);" readonly="readonly">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">COMENTARIO VISITA:</label>
                                                </div>
                                                <div class="col-md-10">
                                                    <textarea class="form-control input-sm" name="lblcomentariovisita" id="lblcomentariovisita" rows="3" style="resize:none"  placeholder="Ingresar..." disabled="disabled"><?php echo $comentariovisita;?></textarea>                                          
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">590:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control pull-right input-sm" style="cursor:pointer;background-color: #fff;" id="mesano" data-role="date" value="<?php if(isset($n590)){ echo $n590;}else{echo $fechames;}?>" name="lbl590" readonly="readonly" >
                                                    </div>                                            
                                                </div>
                                            </div>

                                            <div>
                                                <h5 class="subtitulo">DATOS GENERALES DEL CLIENTE <button type="button" id="btneditarCliente" class="btn btn-danger btn-xs <?php echo ($CCOriginal==511?'':'hidden'); ?>"><i class="fa fa-edit"></i> </button></h5>
                                            </div> 
                                            <?php if($MotivoTransferencia=='ReferidoColaborador'){ ?>
                                            <div class="form-group">
                                             
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">REFERIDO COLABORADOR:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input name="lblnombrereferidocolaborador" class="form-control input-sm" id="lblnombrereferidocolaborador" value="<?php echo $NombreColaborador;?>" style="width: 100%;" disabled="disabled"/>
                                                </div>
                                                
                                            </div> 
                                            <?php }?>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">CLIENTE:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input name="lblnombcliente" class="form-control input-sm" id="lblnombcliente" value="<?php echo $cliente;?>" style="width: 100%;" disabled="disabled"/>
                                                    <input id="lblidcliente" name="lblidcliente" value="<?php echo $idcliente;?>" hidden="">                                          
                                                </div>
                                                <div class="col-md-2">
                                                    <label style="width:15%;font-size: 12px">CORREO:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text"  class="form-control input-sm" id="lblcorreo" value="<?php echo $correo;?>" name="lblcorreo" disabled="disabled">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">TIPO DOCUMENTO VISITA:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input name="lbltipodocumentovisita" class="form-control input-sm" id="lbltipodocumentovisita" value="<?php echo $TipoDocVisita;?>" style="width: 100%;" disabled="disabled"/>                                          
                                                </div>
                                                <div class="col-md-2">
                                                    <label style="width:15%;font-size: 12px">DOCUMENTO VISITA:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text"  class="form-control input-sm" id="lbldocumentovisita" value="<?php echo $DocumentoVisita;?>" name="lbldocumentovisita" disabled="disabled">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">DIRECCIÓN:</label>
                                                </div>
                                                <div class="col-md-6">
                                                    <textarea class="form-control input-sm" name="lbldireccion" id="lbldireccion" rows="1" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php echo $direccion;?></textarea>                                            
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control selectdistrito input-sm" name="lbldistrito" id="lbldistrito" style="width: 100%;" disabled="disabled">
                                                        <option value="<?php echo $idgeografico; ?>"><?php echo $distrito.' - '.$provincia; ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">TELEFONO UNO:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text" class="form-control input-sm" name="lblmovil" id="lblmovil" value="<?php echo $movil;?>"  data-inputmask='"mask": "999999999"'  data-mask disabled="disabled">                                          
                                                </div>
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">TELEFONO DOS:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text" class="form-control input-sm" name="lblfijo" id="lblfijo" value="<?php echo $fijo;?>" data-inputmask='"mask": "999999999"'  data-mask disabled="disabled">
                                                </div>
                                            </div>
                                    <div class="referidotvtc">
                                        <h5 class="subtitulo">INFORMACION REFERIDO</h5>
                                    </div>
                                    <div class="form-group referidotvtc" style="margin-bottom: 0px;">
                                        <div class="col-sm-6 col-md-6">
                                            <div class="form-group">
                                                <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="referidoHabilitado">¿CLIENTE BRINDÓ REFERIDO?:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                         <select class="form-control input-sm" name="referidoHabilitado" id="referidoHabilitado">
                                                            <option value="" disabled selected>Seleccione</option>
                                                            <option value="SI" <?php if ($referidoHabilitado == "SI") {echo "selected";}?>>SI</option>
                                                            <option value="NO" <?php if ($referidoHabilitado == "NO") {echo "selected";}?>>NO</option>
                                                        </select>
                                                        <input type="hidden" name="hidreferidoHabilitado" id="hidreferidoHabilitado" value="<?php echo $referidoHabilitado; ?>"/>
                                                    </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-6 col-md-6 hidden">
                                            <div class="form-group">
                                                <label class="col-sm-4 col-xs-4 control-label " for="cantidadreferidoHabilitado" style="text-align:left;">CANTIDAD REFERIDO: </label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <input type="text" class="form-control" id="cantidadreferidoHabilitado" name="cantidadreferidoHabilitado" value="0"  readonly>
                                                            <div class="input-group-addon">
                                                                <i class="fa fa-repeat actualizarcantidadref" style="cursor: pointer;"></i> <span class="actualizarcantidadref" style="cursor: pointer;"> Actualizar # Referidos</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group referidotvtc datosreferidoHabilitado <?php if($referidoHabilitado=="SI"){echo '';} else{echo 'hidden';}?>" style="margin-bottom: 0px;">
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label class="col-sm-2 col-xs-4 control-label " style="text-align:left;" for="urlreferidoHabilitado">URL:</label>
                                                    <div class="col-sm-10 col-xs-8">
                                                        <div class="input-group">
                                                            <input type="text" class="form-control" id="urlreferidoHabilitado" name="urlreferidoHabilitado" value="<?php echo 'https://clientesverisure.com/apps/referidostctv/create/'.$idventa.'/'.htmlspecialchars($TCGestor).'/'.htmlspecialchars($tipoventa).'/'.rawurlencode(explode( '/', htmlspecialchars($cliente))[0]).'/511/'.htmlspecialchars($correo);?>" readonly>
                                                                <div class="input-group-addon">
                                                                  <i class="fa fa-copy copiarurl" style="cursor: pointer;"></i>
                                                                </div>
                                                                <div class="input-group-addon">
                                                                  <i class="fa fa-external-link irurl" style="cursor: pointer;"></i>
                                                                </div>
                                                        </div>
                                                              
                                                    </div>
                                            </div>
                                        </div>
                                    </div>
                                            
                                            
                                    </div>
                                    <!-- /.box-body -->
                                    </div>
                                </div>
                                <!-- INFORMACION DE TELECIERRE -->
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                        <h5>INFORMACIÓN DE TELECIERRE</h5>
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                         </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                        <div style="width:100%;border-collapse: separate;padding: 20px;">
                                    <div>
                                        <h5 class="subtitulo">INFORMACION SCORING</h5>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-md-2">
                                            <label style="font-size: 12px">RESULTADO SCORING: <span style="color:red"> * </span></label>
                                        </div>
                                        <div class="col-md-4">
                                                <select class="form-control input-sm" name="lblresultadoScoring" id="lblresultadoScoring" disabled>
                                                    <option value="" disabled selected>Seleccione</option>
                                                    <option value="OfertaEspecial">Oferta especial</option>
                                                    <option value="Oferta" hidden>Oferta</option>
                                                    <option value="SuperOferta" hidden>Super oferta</option>
                                                    <option value="OfertaExtraordinaria" hidden>Oferta extraordinaria</option>
                                                </select>
                                                <input type="hidden" id="valresultadoScoring" value="<?php echo $TCScoring;?>">
                                                <input type="hidden" id="valcodigoOperacionScoring" value="<?php echo $CodigoOperacionScoring; ?>">
												<input type="hidden" id="NombresScoring" name="NombresScoring" value="<?php echo $NombresScoring;?>"/>
												<input type="hidden" id="ApellidoPaternoScoring" name="ApellidoPaternoScoring" value="<?php echo $ApellidoPaternoScoring;?>"/>
												<input type="hidden" id="ApellidoMaternoScoring" name="ApellidoMaternoScoring" value="<?php echo $ApellidoMaternoScoring;?>"/>
												<input type="hidden" id="TipoDocumentoScoring" name="TipoDocumentoScoring" value="<?php echo $TipoDocumentoScoring;?>"/>
												<input type="hidden" name="lbldocumentoscoring" id="lbldocumentoscoring" value="<?php echo $DocumentoScoring;?>">                   
												
                                            <input type="hidden" name="lblprospectoabierto" id="lblprospectoabierto" value="<?php echo $prospectoAbierto; ?>" >
                                            <input type="hidden" name="lblfechaprospectoabierto" id="lblfechaprospectoabierto" value="<?php echo $FechaProspectoAbierto; ?>" >
                                                
                                        </div>
                                        <div class="col-md-6">
                                                
                                                    <div class="col-sm-6 col-xs-6">
                                                        <button type="button" class="btn btn-danger btn-block btn-sm" id="btnModalconsultascoring" data-toggle="modal" data-target="#modal-consultascoring"><i class="fa fa-cog"></i> SCORING</button>
                                                    </div>
                                                    <div class="col-sm-6 col-xs-6">
                                                        <button type="button" class="btn btn-default btn-block btn-sm" id="logconsultadoc" data-toggle="modal" data-target="#modal-logdni"><i class="fa fa-pencil-square-o"></i> CONSULTAS DOC.</button>
                                                    </div>
                                                
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-md-2">
                                            <label style="font-size: 12px">DOCUMENTO SCORING:</label>
                                        </div>
                                        <div class="col-md-4">
                                            <input type="text" class="form-control input-sm" name="lbldocumentoscoring" id="lbldocumentoscoring" maxlength="11" onkeypress="return event.charCode >= 48 && event.charCode <= 57" value="<?php echo $DocumentoScoring; ?>" readonly="readonly">
                                        </div>
                                        <div class="col-md-2">
                                            <label style="font-size: 12px">TITULAR SCORING:</label>
                                        </div>
                                        <div class="col-md-4">
                                            <input name="lbltitularscoring" id="lbltitularscoring" class="form-control input-sm" style="width: 100%;" value="<?php echo $NombreScoring; ?>" readonly="readonly">
                                        </div>
                                    </div>
                                    <div>
                                        <h5 class="subtitulo">DETALLE DE LA GESTIÓN</h5>
                                    </div>
                                    <?php if ($estadoventa=='InstaladaDEL' || $estadoventa=='IncidenciaAuditoria' || $estadoventa=='Instalada' || $estadoventa=='InstaladaTEC' || $estadoventa=='IncidenciaGestCorreo' || $estadoventa=='IncidenciaGestValija' || $estadoventa=='Facturada' || $estadoventa=='PorFacturar' || $estadoventa=='DocEnvi'  || $estadoventa=='Incidencia' || $estadoventa=='NoDoc' || $estadoventa=='AgendadaTEC') { ?>
                                    <?php $botonhiden = "hidden";?>
                                    <?php }else{$botonhiden ="";} ?>                                    
                                    <div class="form-group">
                                        <div class="col-md-2">
                                            <label style="font-size: 12px">TIPO CONTACTO: <span style="color:red"> * </span></label>
                                        </div>
                                        <div class="col-md-4">
                                            <select class="form-control input-sm select2full" name="lblnivel1" id="lblnivel1" style="width: 100%;">
                                                <option value="">Seleccione</option>
                                            </select>
                                            <input type="hidden" name="hiddenlblnivel1" value="" id="hiddenlblnivel1" />
                                            <input type="hidden" name="lblnivel2" value="" id="lblnivel2" />
                                        </div>
                                        <div class="col-md-2">
                                            <label style="font-size: 12px">VUELTAS:</label>
                                        </div>
                                        <div class="col-md-4">
                                            <input type="text" class="form-control input-sm" name="lblvueltas" value="<?php echo $Vueltas; ?>" id="lblvueltas" readonly />
                                        </div>
                                    </div>
                                    <div class="form-group nivel3">
                                        <div class="col-md-2">
                                            <label style="font-size: 12px">TIPIFICACIÓN: <span style="color:red"> * </span></label>
                                        </div>
                                        <div class="col-md-4">
                                            <select class="form-control input-sm select2full" name="lblestadoteleventa" id="lblestadoteleventa" style="width: 100%;">
                                                <option value="">Seleccione</option>
                                            </select>
                                            <input type="hidden" name="hiddenlblestadoteleventa" value="" id="hiddenlblestadoteleventa" />
                                        </div>
                                        <div class="col-md-2 nivel4">
                                            <label style="font-size: 12px">SUBTIPIFICACIÓN:</label>
                                        </div>
                                        <div class="col-md-4 nivel4">
                                            <select class="form-control input-sm select2full" name="lblsubestado" id="lblsubestado" style="width: 100%;">
                                                <option value="">Seleccione</option>
                                            </select>
                                            <input type="hidden" name="hiddenlblsubestado" value="" id="hiddenlblsubestado" />
                                        </div>
                                    </div>
                                    <div class="form-group ocultar" id="rowDevolverLlmada">
                                        <div class="col-md-2">
                                            <label style="font-size: 12px">FECHA RELLAMADA:</label>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="input-group">
                                                <div class="input-group-addon input-sm">
                                                    <i class="fa fa-calendar"></i>
                                                </div>
                                                <input type="text" class="form-control pull-right input-sm" id="lblfrellamadaTC" name="lblfrellamadaTC"  data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <label style="font-size: 12px">HORA RELLAMADA:</label>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="bootstrap-timepicker timepicker">
                                                <div class="input-group">
                                                    <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhrellamadaTC" id="lblhrellamadaTC">
                                                    <div class="input-group-addon input-sm">
                                                        <i class="fa fa-clock-o"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group ocultar" id="rowCompetencia">
                                        <div class="col-md-2">
                                            <label style="font-size: 12px">COMPETENCIA:</label>
                                        </div>
                                        <div class="col-md-4">
                                            <select class="form-control input-sm select2full" name="lblcompetencia" id="lblcompetencia">
                                                <option value="">Seleccione</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group <?php echo $botonhiden; ?>">
                                        <div class="col-md-2">
                                            <h5 class="subtitulo">AGENDAMIENTO:</h5>
                                        </div>
                                        <div class="col-md-4">
                                            <button type="button" id="disponibilidad" class="btn btn-primary btn-sm">Disponibilidad</button>
                                        </div>
                                    </div>                                      
                                    <div class="form-group">
                                        <div class="col-md-2">
                                            <h5 class="subtitulo">ULTIMA GESTIÓN</h5>
                                        </div>
                                        <div class="col-md-4">
                                            <a class="btn btn-sm btn-primary" href="#" data-toggle="modal" id="logcontactados" data-target="#modal-contactados"><i class="fa fa-pencil-square-o"></i> Historico Gestión</a>
                                        </div>
                                    </div>                                    
                                    <div class="form-group">
                                        <div class="col-md-2">
                                            <label style="font-size: 12px">TIPIFICACIÓN: <span style="color:red"></span></label>
                                        </div>
                                        <div class="col-md-4">
                                            <input type="text" class="form-control input-sm" name="ultimagestion" value="<?php echo $estadotelecierre; ?>" id="ultimagestion" readonly />
                                        </div>
                                        <div class="col-md-2" id="lbllabelnivel">
                                            <label style="font-size: 12px">FECHA ULTIMA GESTIÓN:</label>
                                        </div> 
                                        <div class="col-md-4">
                                            <input type="text" class="form-control input-sm" name="lblfechaultimagestion" value="<?php echo $FechaUltimaGestion; ?>" id="lblfechaultimagestion" readonly />
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-md-2">
                                            <label style="font-size: 12px">FECHA PRIMERA GESTIÓN: <span style="color:red"></span></label>
                                        </div>
                                        <div class="col-md-4">
                                            <input type="text" class="form-control input-sm" id="lblfechagestion" name="lblfechagestion" value="<?php echo $TCFechaGestion;?>" readonly />
                                        </div>
                                        
                                        <div class="rellamada col-md-2 ocultar">
                                            <label style="font-size: 12px">FECHA RELLAMADA: </label>
                                        </div>
                                        <div class="rellamada col-md-4 ocultar">
                                            <input type="text" class="form-control input-sm" id="lblfechahorarellamada" name="lblfechahorarellamada" value="<?php echo $TCFechaRellamada.' '.$TCHoraRellamada;?>" readonly />
                                        </div>                                        
                                    </div>                                    

                                    
                                    <div>
                                        <h5 class="subtitulo">DETALLE DE LA OFERTA</h5>
                                    </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">TIPO DOCUMENTO TC:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control input-sm" name="lbltipodoc" id="lbltipodoc">
                                                        <option value="">Seleccione</option>
                                                        <option value="DNI" <?php if ($TipoDocumento== "DNI") {echo "selected";}?>>DNI</option>
                                                        <option value="RUC" <?php if ($TipoDocumento== "RUC") {echo "selected";}?>>RUC</option>
                                                        <option value="CE" <?php if ($TipoDocumento== "CE") {echo "selected";}?>>CE</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">DOCUMENTO TC:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input id="lblIdDocTC" name="lblIdDocTC" value="<?php echo $IdDocTC;?>" hidden>
                                                    <input type="text" class="form-control input-sm" name="lbldocumento" id="lbldocumento" value="<?php echo $Documento ;?>" maxlength="12" onkeypress="return filterFloat(event, this);">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">VISITADO:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control input-sm" name="hidden_visitadox" id="hidden_visitadox">
                                                        <option value="">Seleccione</option>
                                                        <option value="SI" <?php if ($TCVisitado== "SI") {echo "selected";}?>>SI</option>
                                                        <option value="NO" <?php if ($TCVisitado== "NO") {echo "selected";}?>>NO</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-2 ocultar checkacuerdocomercial">
                                                    <label style="font-size: 12px">ACUERDO COMERCIAL DE INST.</label>
                                                </div>
                                                <div class="col-md-4 ocultar checkacuerdocomercial">
                                                    <select class="form-control input-sm" name="hidden_acuerdocomercialinst" id="hidden_acuerdocomercialinst">
                                                        <option value="">Seleccione</option>
                                                        <option value="SI" <?php if ($TCAcuerdoComercial== "SI") {echo "selected";}?>>SI</option>
                                                        <option value="NO" <?php if ($TCAcuerdoComercial== "NO") {echo "selected";}?>>NO</option>
                                                    </select>                                                    
                                                 
                                                    <select class="form-control input-sm ocultar" name="lblsco_old" id="lblsco_old">
                                                        <option value="">Seleccione</option>
                                                        <option value="OfertaExtraordinaria" <?php if ($TCScoring== "OfertaExtraordinaria") {echo "selected";}?>>Oferta Extraordinaria</option>
                                                        <option value="SuperOferta" <?php if ($TCScoring== "SuperOferta") {echo "selected";}?>>Super Oferta</option>
                                                        <option value="Oferta" <?php if ($TCScoring== "Oferta") {echo "selected";}?>>Oferta</option>
                                                        <option value="OfertaEspecial" <?php if ($TCScoring== "OfertaEspecial") {echo "selected";}?>>Oferta Especial</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group ocultar">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">ESTADO TELECIERRE:<span style="color:red"> * </span></label>
                                                </div>
                                                <div class="col-md-4">
                                                    <!-- VERSION ANTIGUA
                                                    <select class="form-control input-sm" name="lblestadotelecierre" id="lblestadotelecierre">
                                                        <option value="">Seleccione</option>
                                                        <option value="NoContactado" <?php if ($estadotelecierre== "NoContactado") {echo "selected";}?>>No Contactado</option>
                                                        <option value="PendienteRespuesta" <?php if ($estadotelecierre== "PendienteRespuesta") {echo "selected";}?>>Pendiente Respuesta</option>
                                                        <option value="ContactadoSinGestion" <?php if ($estadotelecierre== "ContactadoSinGestion") {echo "selected";}?>>Contactado sin Gestion</option>
                                                        <option value="Online" <?php if ($estadotelecierre== "Online") {echo "selected";}?>>Vendida Online</option>
                                                        <option value="Ficha" <?php if ($estadotelecierre== "Ficha") {echo "selected";}?>>Vendida Ficha</option>
                                                        <option value="NoVendida" <?php if ($estadotelecierre== "NoVendida") {echo "selected";}?>>No Vendida</option>
                                                    </select>
                                                    -->
                                                    <select class="form-control input-sm" name="lblestadotelecierre" id="lblestadotelecierre">
                                                        <option value="">Seleccione</option>
                                                        <option value="NoContactado" <?php if ($estadotelecierre== "NoContactado") {echo "selected";}?>>No Contactado</option>
                                                        <option value="TelefonoClienteErrado" <?php if ($estadotelecierre== "TelefonoClienteErrado") {echo "selected";}?> hidden disabled>Telefono/Cliente Errado</option>
                                                        <option value="DevolverLlamada" <?php if ($estadotelecierre== "DevolverLlamada"){echo "selected";}?>>DevolverLlamada</option>
                                                        <option value="PendienteRespuesta" <?php if ($estadotelecierre== "PendienteRespuesta") {echo "selected";}?> hidden disabled>Pendiente Respuesta</option>
                                                        <option value="Ficha" <?php if ($estadotelecierre== "Ficha") {echo "selected";}?> hidden disabled>Vendida Ficha</option>
                                                        <option value="ContactadoSinGestion" <?php if ($estadotelecierre== "ContactadoSinGestion") {echo "selected";}?> hidden disabled>Contactado sin Gestion</option>
                                                        <!-- NUEVOS PROSPECTOS PARA TENER LOS MISMOS ESTADOS QUE GENESIS. SOLICITADO POR RAUL RUBIO 27/04/2021 -->
                                                        <option value="ProspectoAbierto" <?php if ($estadotelecierre== "ProspectoAbierto") {echo "selected";}?>>Prospecto Abierto</option>
                                                        <option value="NoInteresa" <?php if ($estadotelecierre== "NoInteresa") {echo "selected";}?>>No Interesa</option>
                                                        <option value="Precio" <?php if ($estadotelecierre== "Precio") {echo "selected";}?>>Precio</option>
                                                        <option value="Competencia" <?php if ($estadotelecierre== "Competencia") {echo "selected";}?>>Competencia</option>
                                                        <option value="Cliente" <?php if ($estadotelecierre== "Cliente") {echo "selected";}?>>Cliente</option>
                                                        <option value="InviableTecnicamente" <?php if ($estadotelecierre== "InviableTecnicamente") {echo "InviableTecnicamente";}?>>Inviable Tecnicamente</option>
                                                        <option value="YaTieneProspecto" <?php if ($estadotelecierre== "YaTieneProspecto") {echo "selected";}?>>Ya Tiene Prospecto</option>
                                                        <!-- ESTADOS VENTA Y NO VENTA-->
                                                        <option value="PendienteValidacion" <?php if ($estadotelecierre== "PendienteValidacion") {echo "selected";}?>>Pendiente Validacion</option>
                                                        <option value="Online" <?php if ($estadotelecierre== "Online") {echo "selected";}?>>Vendida Online</option>
                                                        <option value="NoVendida" <?php if ($estadotelecierre== "NoVendida") {echo "selected";}?>>No Vendida</option>
                                                    </select>
                                                    
                                                </div>
                                                <div class="col-md-2 ocultar" id="lbllabelmotivo">
                                                      <label style="font-size: 12px">SUB ESTADO:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <!--
                                                    <select <?php //if ($estadotelecierre!== "NoVendida") {echo 'style="display:none;"';}?>  class="form-control input-sm"  name="lblmovivonoventatc" id="lblmovivonoventatc">
                                                        <option value="">Seleccione</option>
                                                        <option value="NoInteresado" <?php if ($TCMotivoNoVenta=== "NoInteresado") {echo "selected";}?>>No Interesado</option>
                                                        <option value="Permanencia" <?php if ($TCMotivoNoVenta=== "Permanencia") {echo "selected";}?>>Permanencia</option>
                                                        <option value="EcoCuota" <?php if ($TCMotivoNoVenta=== "EcoCuota") {echo "selected";}?>>ECO-CUOTA</option>
                                                        <option value="EcoUpfront" <?php if ($TCMotivoNoVenta=== "EcoUpfront") {echo "selected";}?>>ECO-UPFRONT</option>
                                                        <option value="Camaras" <?php if ($TCMotivoNoVenta=== "Camaras") {echo "selected";}?>>Cámaras</option>
                                                        <option value="Competencia" <?php if ($TCMotivoNoVenta=== "Competencia") {echo "selected";}?>>Competencia</option>
                                                    </select>
                                                    -->
                                                    <select  class="form-control input-sm ocultar"  name="lblmovivonoventatc" id="lblmovivonoventatc">
                                                        <option value="">Seleccione</option>
                                                        <option value="NoInteresado" <?php if ($TCMotivoNoVenta=== "NoInteresado") {echo "selected";}?> <?php if ($estadotelecierre=== "NoContactado" || $estadotelecierre=== "PendienteRespuesta" || $estadotelecierre=== "DevolverLlamada") {echo "hidden";}?>>No Interesado</option>
                                                        <option value="Inviable" <?php if ($TCMotivoNoVenta=== "Inviable") {echo "selected";}?> <?php if ($estadotelecierre=== "NoContactado" || $estadotelecierre=== "PendienteRespuesta" || $estadotelecierre=== "DevolverLlamada") {echo "hidden";}?>>Inviable</option>
                                                        <option value="Permanencia" <?php if ($TCMotivoNoVenta=== "Permanencia") {echo "selected";}?> <?php if ($estadotelecierre=== "NoContactado" || $estadotelecierre=== "PendienteRespuesta" || $estadotelecierre=== "DevolverLlamada") {echo "hidden";}?>>Permanencia</option>
                                                        <option value="EcoCuota" <?php if ($TCMotivoNoVenta=== "EcoCuota") {echo "selected";}?> hidden disabled>ECO-CUOTA</option>
                                                        <option value="EcoUpfront" <?php if ($TCMotivoNoVenta=== "EcoUpfront") {echo "selected";}?> hidden disabled>ECO-UPFRONT</option>
                                                        <option value="Camaras" <?php if ($TCMotivoNoVenta=== "Camaras") {echo "selected";}?> <?php if ($estadotelecierre=== "NoContactado" || $estadotelecierre=== "PendienteRespuesta" || $estadotelecierre=== "DevolverLlamada") {echo "hidden";}?>>Cámaras</option>
                                                        <option value="Competencia" <?php if ($TCMotivoNoVenta=== "Competencia") {echo "selected";}?> <?php if ($estadotelecierre=== "NoContactado" || $estadotelecierre=== "PendienteRespuesta" || $estadotelecierre=== "DevolverLlamada") {echo "hidden";}?>>Competencia</option>
                                                        <option value="ZonadeCobertura" <?php if ($TCMotivoNoVenta=== "ZonadeCobertura") {echo "selected";}?> <?php if ($estadotelecierre=== "NoContactado" || $estadotelecierre=== "PendienteRespuesta" || $estadotelecierre=== "DevolverLlamada") {echo "hidden";}?>>Zona de Cobertura</option>
                                                        <option value="Duplicado" <?php if ($TCMotivoNoVenta=== "Duplicado") {echo "selected";}?> <?php if ($estadotelecierre=== "NoContactado" || $estadotelecierre=== "PendienteRespuesta" || $estadotelecierre=== "DevolverLlamada") {echo "hidden";}?>>Duplicado</option>
                                                        <!-- NO CONTACTADO -->
                                                        <!-- ANTIGUOS -->
                                                        <option value="Telefononovalido" <?php if ($TCMotivoNoVenta=== "Telefononovalido") {echo "selected";}?> <?php if ($estadotelecierre=== "NoVendida" || $estadotelecierre=== "PendienteRespuesta" || $estadotelecierre=== "DevolverLlamada") {echo "hidden";}?> hidden>Teléfono No valido</option>
                                                        <option value="Apagado" <?php if ($TCMotivoNoVenta=== "Apagado") {echo "selected";}?> <?php if ($estadotelecierre=== "NoVendida" || $estadotelecierre=== "PendienteRespuesta" || $estadotelecierre=== "DevolverLlamada") {echo "hidden";}?> hidden>Apagado</option>
                                                        <option value="Timbranocontesta" <?php if ($TCMotivoNoVenta=== "Timbranocontesta") {echo "selected";}?> <?php if ($estadotelecierre=== "NoVendida" || $estadotelecierre=== "PendienteRespuesta" || $estadotelecierre=== "DevolverLlamada") {echo "hidden";}?> hidden>Timbra no contesta</option>
                                                        <!-- NUEVOS GENESYS -->
                                                        <option value="SinRespuesta" <?php if ($TCMotivoNoVenta=== "SinRespuesta") {echo "selected";}?> <?php if ($estadotelecierre=== "NoVendida" || $estadotelecierre=== "PendienteRespuesta" || $estadotelecierre=== "DevolverLlamada") {echo "hidden";}?>>Sin Respuesta</option>
                                                        <option value="ContestadoraAutomatica" <?php if ($TCMotivoNoVenta=== "ContestadoraAutomatica") {echo "selected";}?> <?php if ($estadotelecierre=== "NoVendida" || $estadotelecierre=== "PendienteRespuesta" || $estadotelecierre=== "DevolverLlamada") {echo "hidden";}?>>Contestadora Automatica</option>
                                                        <option value="NumeroEquivocado" <?php if ($TCMotivoNoVenta=== "NumeroEquivocado") {echo "selected";}?> <?php if ($estadotelecierre=== "NoVendida" || $estadotelecierre=== "PendienteRespuesta" || $estadotelecierre=== "DevolverLlamada") {echo "hidden";}?>>Numero Equivocado</option>
                                                        <!-- DEVOLVER LLAMADA -->
                                                        <option value="LlamarManana" <?php if ($TCMotivoNoVenta=== "LlamarManana") {echo "selected";}?> <?php if ($estadotelecierre=== "NoContactado" || $estadotelecierre=== "NoVendida") {echo "hidden";}?>>Llamar Mañana</option>
                                                        <option value="LLamarTarde" <?php if ($TCMotivoNoVenta=== "LLamarTarde") {echo "selected";}?> <?php if ($estadotelecierre=== "NoContactado" ||  $estadotelecierre=== "NoVendida") {echo "hidden";}?>>LLamar Tarde</option>
                                                        <option value="LlamarNoche" <?php if ($TCMotivoNoVenta=== "LlamarNoche") {echo "selected";}?> <?php if ($estadotelecierre=== "NoContactado" ||  $estadotelecierre=== "NoVendida") {echo "hidden";}?>>Llamar Noche</option>
                                                    </select>
                                                    <input hidden value="<?php echo $estadotelecierre; ?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">TIPO VENTA TC:<span style="color:red"> * </span></label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text" name="lbltipoventatc" id="lbltipoventatc" value="Telecierre" class="form-control input-sm" style="width: 100%;" readonly="readonly"/>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">CC TC:<span style="color:red"> * </span></label>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control input-sm" name="lblcctc" id="lblcctc">
                                                        <option value="150" <?php if ($dc == "150") {echo "selected";}?> hidden="">150</option>
                                                        <option value="151" <?php if ($dc == "151") {echo "selected";}?> hidden="">151</option>
                                                        <option value="152" <?php if ($dc == "152") {echo "selected";}?> hidden="">152</option>
                                                        <option value="153" <?php if ($dc == "153") {echo "selected";}?> hidden="">153</option>
                                                        <option value="154" <?php if ($dc == "154") {echo "selected";}?> hidden="">154</option>
                                                        <option value="155" <?php if ($dc == "155") {echo "selected";}?> hidden="">155</option>
                                                        <option value="156" <?php if ($dc == "156") {echo "selected";}?> hidden="">156</option>
                                                        <option value="157" <?php if ($dc == "157") {echo "selected";}?> hidden="">157</option>
                                                        <option value="158" <?php if ($dc == "158") {echo "selected";}?> hidden="">158</option>
                                                        <option value="159" <?php if ($dc == "159") {echo "selected";}?> hidden="">159</option>
                                                        <option value="200" <?php if ($dc == "200") {echo "selected";}?> hidden="">200</option>
                                                        <option value="140" <?php if ($dc == "140") {echo "selected";}?> hidden="">140</option>
                                                        <option value="141" <?php if ($dc == "141") {echo "selected";}?> hidden="">141</option>
                                                        <option value="120" <?php if ($dc == "120") {echo "selected";}?> hidden="">120</option>
                                                        <option value="100" <?php if ($dc == "100") {echo "selected";}?> hidden="">100</option>
                                                        <option value="40" <?php if ($dc == "40") {echo "selected";}?> hidden="">40</option>
                                                        <option value="41" <?php if ($dc == "41") {echo "selected";}?> hidden="">41</option>
                                                        <option value="42" <?php if ($dc == "42") {echo "selected";}?> hidden="">42</option>
                                                        <option value="121" <?php if ($dc == "121") {echo "selected";}?> hidden="">121</option>
                                                        <option value="80" <?php if ($dc == "80") {echo "selected";}?> hidden="">80</option>
                                                        <option value="250" <?php if ($dc == "250") {echo "selected";}?> hidden="">250</option>
                                                        <option value="251" <?php if ($dc == "251") {echo "selected";}?> hidden="">251</option>
                                                        <option value="252" <?php if ($dc == "252") {echo "selected";}?> hidden="">252</option>
                                                        <option value="20" <?php if ($dc == "20") {echo "selected";}?> hidden="">20</option>
                                                        <option value="511" <?php if ($dc == "511") {echo "selected";}?>>511</option>
                                                        <option value="512" <?php if ($dc == "512") {echo "selected";}?> hidden="">512</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">GESTOR TC:<span style="color:red"> * </span></label>
                                                </div>
                                                <div class="col-md-4">
                                                    <select name="lblgestortc" id="lblgestortc" class="form-control cbxtelecierre input-sm" style="width: 100%;">
                                                        <?php echo $html_tc;?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">TIPO KIT:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control input-sm" name="lbltipokittc" id="lbltipokittc">
                                                        <option value="">Seleccione</option>
                                                        <option value="Basico" <?php if ($TipoKIT == 'Basico') {echo "selected";}?>>Básico</option>
                                                        <option value="Premium" <?php if ($TipoKIT == 'Premium') {echo "selected";}?>>Premium</option>
                                                        <option value="ZeroVision" <?php if ($TipoKIT == 'ZeroVision') {echo "selected";}?>>ZeroVision</option>
                                                        <option value="Camara" <?php if ($TipoKIT == 'Camara') {echo "selected";}?>>Camara</option>
                                                        <option value="Basico PRO" <?php if ($TipoKIT == 'Basico PRO') {echo "selected";}?>>Basico PRO</option>
                                                        <option value="ZeroVision PRO" <?php if ($TipoKIT == 'ZeroVision PRO') {echo "selected";}?>>ZeroVision PRO</option>                                                        
                                                    </select>
                                                </div>
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">PRECIOKIT TC:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="">S/.</i>
                                                        </div>
                                                        <?php
                                                            if($IdPerfil == 12){
                                                        ?>
                                                                <select class="form-control input-sm" name="lblpreciokittc" id="lblpreciokittc">
                                                                    <!--
                                                                    <option value="">Seleccione</option>
                                                                    <option value="0.00" <?php if ($preciokit == 0.00) {echo "selected";}?>>0.00</option>
                                                                    <option value="199.00" <?php if ($preciokit == 199.00) {echo "selected";}?>>199.00</option>
                                                                    <option value="399.00" <?php if ($preciokit == 399.00) {echo "selected";}?>>399.00</option>
                                                                    <option value="599.00" <?php if ($preciokit == 599.00) {echo "selected";}?>>599.00</option>
                                                                    <option value="799.00" <?php if ($preciokit == 799.00) {echo "selected";}?>>799.00</option>
                                                                    <option value="999.00" <?php if ($preciokit == 999.00) {echo "selected";}?>>999.00</option>
                                                                    <option value="1199.00" <?php if ($preciokit == 1199.00) {echo "selected";}?>>1199.00</option>
                                                                    <option value="1599.00" <?php if ($preciokit == 1599.00) {echo "selected";}?>>1599.00</option>
                                                                    -->
                                                                </select>
                                                                <input type="hidden" id="hiddenpreciokittc" name="hiddenpreciokittc" value="<?php echo $preciokit; ?>">
                                                        <?php
                                                            } else {
                                                        ?>
                                                                <input class="form-control input-sm" type="text" name="lblpreciokittc" id="lblpreciokittc" value="<?php echo $preciokit; ?>">
                                                                <input type="hidden" id="hiddenpreciokittc" name="hiddenpreciokittc" value="<?php echo $preciokit; ?>">
                                                        <?php
                                                            }
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group ocultar camaraarlo">
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px">TIPO CÁMARA KIT:</label>
                                                </div>
                                                <div class="col-md-4">
                                                            <select class="form-control input-sm" id="lbltipocamarakit" name="lbltipocamarakit">
                                                                <option value="" disabled selected>Seleccione</option>
                                                            </select>
                                                            <input type="hidden" id="valtipocamarakit" value="<?php echo $TipoCamaraKit; ?>">
                                                </div>
                                            </div>                                            
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px">TOTAL EXTRA TC:</label>
                                                </div>
                                                <div class="col-md-4">
                                                  <div class="input-group">
                                                      <div class="input-group-addon input-sm">
                                                          <i class="">S/.</i>
                                                      </div>
                                                    <input type="text" class="form-control input-sm" name="lbltotalextratc" id="lbltotalextratc" value="<?php echo $totalextra;?>" onkeypress="return filterFloat(event, this);" disabled/>
                                                  </div>
                                                </div>
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px">CANTIDAD EXTRA TC:</label>
                                                </div>
                                                <div class="col-md-4">
                                                  <input type="text" class="form-control input-sm" name="lblcantidadextratc" id="lblcantidadextratc" value="<?php echo $CantidadExtras;?>" onkeypress="return event.charCode >= 48 && event.charCode <= 57" maxlength="2" disabled />
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px">TOTAL CUOTA MONITOREO:</label>
                                                </div>
                                                <div class="col-md-4">
                                                  <div class="input-group">
                                                      <div class="input-group-addon input-sm">
                                                          <i class="">S/.</i>
                                                      </div>
                                                    <input type="text" class="form-control input-sm" name="lblTotalCuotaMonitoreo" id="lblTotalCuotaMonitoreo" value="<?php echo $TotalCuotaMonitoreo; ?>" onkeypress="return filterFloat(event, this);" disabled/>
                                                  </div>
                                                </div>
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px">CANTIDAD REGALO:</label>
                                                </div>
                                                <div class="col-md-4">
                                                  <input type="text" class="form-control input-sm" name="lblcantidadregalotc" id="lblcantidadregalotc" value="<?php echo $CantidadRegalo; ?>" disabled />
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px">RESUMEN INST. TC:</label>
                                                </div>
                                                <div class="col-md-10">
                                                    <div class="input-group">
                                                        <input type="text" class="form-control input-sm" id="lblresumenventatc" name="lblresumenventatc" value="<?php echo $resumenventa; ?>" disabled>
                                    
                                                        <div class="input-group-addon btn" id="btnModalProductos">
                                                            <i class="fa fa-cart-plus"></i>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px">REGALO AUTORIZADO TC:</label>
                                                </div>
                                                <div class="col-md-4">
                                                  <select class="form-control input-sm select2" name="lblextraautorizadotc" id="lblextraautorizadotc" style="width: 100%">
                                                    <option value="">Seleccione</option>1
                                                    <option value="Ninguno"<?php if ($regaloutorizado == "Ninguno") {echo "selected";}?>>Ninguno</option>
                                                    <option value="Mando a distancia"<?php if ($regaloutorizado == "Mando a distancia") {echo "selected";}?>>Mando a distancia</option>
                                                    <option value="Magnetico"<?php if ($regaloutorizado == "Magnetico") {echo "selected";}?>>Magnetico</option>
                                                    <option value="Pulsador"<?php if ($regaloutorizado == "Pulsador") {echo "selected";}?>>Pulsador</option>
                                                    <option value="Upgrade" <?php if ($regaloutorizado == "Upgrade") {echo "selected";}?>>Upgrade magnetico pesado</option>
                                                  </select>
                                                </div>
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px">FORMA DE PAGO TC:</label>
                                                </div>
                                                <div class="col-md-4">
                                                  <select class="form-control input-sm select2" name="lblformadepagotc" id="lblformadepagotc" style="width: 100%">
                                                    <option value="">Seleccione</option>
                                                    <option value="Cheque" <?php if ($formadepago == "Cheque") {echo "selected";}?>>Cheque</option>
                                                    <option value="Deposito" <?php if ($formadepago == "Deposito") {echo "selected";}?>>Depósito</option>
                                                    <option value="Transferencia" <?php if ($formadepago == "Transferencia") {echo "selected";}?>>Transferencia</option>
                                                    <option value="TransferenciaInterbancaria" <?php if ($formadepago == "TransferenciaInterbancaria") {echo "selected";}?>>Transferencia Interbancaria</option>
                                                    <option value="PagoPOSVisa" <?php if ($formadepago == "PagoPOSVisa") {echo "selected";}?>>Pago POSVisa</option>
                                                    <option value="PagoPOSMC" <?php if ($formadepago == "PagoPOSMC") {echo "selected";}?>>Pago POSMC</option>
                                                    <option value="TarjetadeCredito" <?php if ($formadepago == "TarjetadeCredito") {echo "selected";}?>>Tarjeta de Crédito</option>
                                                    <option value="PagoPasarella" <?php if ($formadepago == "PagoPasarella") {echo "selected";}?>>Pago Pasarella</option>
                                                   </select>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px">MESES AUTORIZADOS TC:</label>
                                                </div>
                                                <div class="col-md-4">
                                                  <input type="text" maxlength="3" class="form-control input-sm" id="lblmesesautorizadostc" name="lblmesesautorizadostc"  value="<?php echo $mesesautorizados;?>" onkeypress="return filterFloat(event, this);">
                                                </div>
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px">PAI TC:</label>
                                                </div>
                                                <div class="col-md-4">
                                                  <select class="form-control input-sm select2" name="lblPAItc" id="lblPAItc" style="width: 100%">
                                                    <option value="">Seleccione</option>
                                                    <option value="BBVA-DIN"<?php if ($PAI == "BBVA-DIN") {echo "selected";}?>>BBVA-DIN</option>
                                                    <option value="PAI 30x36"<?php if ($PAI == "PAI 30x36") {echo "selected";}?>>PAI 30x36</option>
                                                    <option value="NO"<?php if ($PAI == "NO") {echo "selected";}?>>NO</option>
                                                  </select>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px">DESC 50% - 3 MESES:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="checkbox" name="desc3meses" id="desc3meses" <?php if($DescMeses=="SI"){echo 'checked';}else{echo '';}?> data-size="small"/>
                                                    <input type="hidden" id="HidDesc3meses" value="<?=$DescMeses;?>">                                    
                                                </div>
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px">FORMA DE PAGO MONITOREO</label>
                                                </div>
                                                <div class="col-md-4">
                                                  <select class="form-control input-sm select2" name="lblformapagocuota" id="lblformapagocuota" style="width: 100%">
                                                    <option value="">Seleccione</option>
                                                    <option value="Contrafactura" <?php if ($FormaPagoCuota == "Contrafactura") {echo "selected";}?>>Contrafactura</option>
                                                    <option value="Tarjetacredito" <?php if ($FormaPagoCuota == "Tarjetacredito") {echo "selected";}?>>Tarjeta crédito</option>
                                                    <option value="Tarjetadebito" <?php if ($FormaPagoCuota == "Tarjetadebito") {echo "selected";}?>> Tarjeta débito</option>
                                                    <option value="Cuentadebito" <?php if ($FormaPagoCuota == "Cuentadebito") {echo "selected";}?>>Cuenta débito</option>
                                                  </select>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px">COMENTARIO TC:</label>
                                                </div>
                                                <div class="col-md-10">
                                                  <textarea class="form-control input-sm" name="lblcomentariotc" id="lblcomentariotc" rows="3" style="resize:none"  placeholder="Ingresar..."><?php echo $TCComentario;?></textarea>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                    <label style="font-size: 12px">COMENTARIO CANCELACION:</label>
                                                </div>
                                                <div class="col-md-10">
                                                    <textarea class="form-control input-sm" name="lblcomentariocancelacion" id="lblcomentariocancelacion" rows="2" style="resize:none" placeholder="Ingresar..." maxlength="220"><?php echo $ComentarioCancelacion; ?></textarea>
                                                </div>
                                            </div>   
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px">PAGO ADELANTADO:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="checkbox" name="pagoAdelantado" id="pagoAdelantado" <?php if($pagoAdelantado=="SI"){echo 'checked';}else{echo '';}?> data-size="small"/>
                                                    <input type="hidden" id="HidpagoAdelantado" value="<?=$pagoAdelantado;?>">                                    
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px">CON SISTEMA DE ALARMAS:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <select class="form-control input-sm" name="conSistema" id="conSistema" style="width: 100%" disabled>
                                                        <option value="">Seleccione</option>
                                                        <option value="Si" <?php if ($conSistema== "Si") {echo "selected";}?>>Si</option>
                                                        <option value="No" <?php if ($conSistema== "No") {echo "selected";}?>>No</option>
                                                    </select>                                     
                                                </div>
                                                <div class="col-md-2">
                                                  <label style="font-size: 12px"><span class="Lead__empresaAlarmas <?php if ($conSistema == "No" || $conSistema == "") {echo "ocultar";}?>">EMPRESA ALARMAS:</span></label>
                                                </div>
                                                <div class="col-md-4">
                                                 <input type="text" class="form-control input-sm Lead__empresaAlarmas <?php if ($conSistema == "No" || $conSistema == "") {echo "ocultar";}?>" id="empresaSistema"  name="empresaSistema" value="<?php echo $empresaSistema;?>" maxlength="50" disabled>
                                                </div>
                                            </div>                                            

                                            <div class="divinformacioncamaraarlo ocultar">
                                                    <h5 class="subtitulo eti_1">INFORMACIÓN EXTRAS CÁMARA ARLO</h5>
                                            </div>
                                            <div class="form-group divinformacioncamaraarlo ocultar">
                                                <div class="col-md-2">
                                                  <label class="eti_2" style="font-size: 12px">CÁMARA ARLO INTERNA EXTRA:</label>
                                                </div>
                                                <div class="col-md-4">
                                                            <select class="form-control input-sm" id="VendidaCamaraExtraInterna" name="VendidaCamaraExtraInterna">
                                                                <option value="" disabled selected>Seleccione</option>
                                                                <option value="SI">SI</option>
                                                                <option value="NO" >NO</option>
                                                            </select>
                                                            <input type="hidden" id="valVendidaCamaraExtraInterna" value="<?php echo $VendidaCamaraInternaExtra; ?>">
                                                </div>
                                            </div>
                                            <div class="form-group ocultar camaraarlointerna">
                                                <div class="col-md-2">
                                                  <label class="eti_3" style="font-size: 12px">CANTIDAD CÁMARA ARLO INTERNA EXTRA:</label>
                                                </div>
                                                <div class="col-md-4">
                                                        <input type="text" class="form-control input-sm" name="CantidadCamaraExtraInterna" id="CantidadCamaraExtraInterna" maxlength="12" value="<?php echo $CantidadCamaraInternaExtra; ?>" onkeypress="return event.charCode >= 48 && event.charCode <= 57">                                 
                                                </div>
                                                <div class="col-md-2">
                                                  <label class="eti_4" style="font-size: 12px">PRECIO CÁMARA ARLO INTERNA EXTRA:</label>
                                                </div>
                                                <div class="col-md-4">
                                                  <input type="text" class="form-control input-sm" name="PrecioCamaraExtraInterna" id="PrecioCamaraExtraInterna" value="<?php echo $PrecioCamaraInternaExtra; ?>" onkeypress="return filterFloat(event, this);">
                                                </div>
                                            </div>
                                            
                                            <div class="form-group divinformacioncamaraarlo ocultar">
                                                <div class="col-md-2">
                                                  <label class="eti_5" style="font-size: 12px">CÁMARA ARLO EXTERNA EXTRA:</label>
                                                </div>
                                                <div class="col-md-4">
                                                            <select class="form-control input-sm" id="VendidaCamaraExtraExterna" name="VendidaCamaraExtraExterna">
                                                                <option value="" disabled selected>Seleccione</option>
                                                                <option value="SI">SI</option>
                                                                <option value="NO" >NO</option>
                                                            </select>
                                                            <input type="hidden" id="valVendidaCamaraExternaExtra" value="<?php echo $VendidaCamaraExternaExtra; ?>">
                                                </div>
                                            </div>
                                            <div class="form-group ocultar camaraarloexterna">
                                                <div class="col-md-2">
                                                  <label class="eti_6" style="font-size: 12px">CANTIDAD CÁMARA ARLO EXTERNA EXTRA:</label>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text" class="form-control input-sm" name="CantidadCamaraExtraExterna" id="CantidadCamaraExtraExterna" maxlength="12" value="<?php echo $CantidadCamaraExternaExtra; ?>" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                                                </div>
                                                <div class="col-md-2">
                                                  <label class="eti_7" style="font-size: 12px">PRECIO CÁMARA ARLO EXTERNA EXTRA:</label>
                                                </div>
                                                <div class="col-md-4">
                                                  <input type="text" class="form-control input-sm" name="PrecioCamaraExtraExterna" id="PrecioCamaraExtraExterna" value="<?php echo $PrecioCamaraExternaExtra; ?>" onkeypress="return filterFloat(event, this);">
                                                </div>
                                            </div>                                                 
                                            
                                        </div>
                                    </div>
                                    <!-- /.box-body -->
                                </div>
                                <!-- INFORMACION DE AGENDA -->
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACION DE AGENDA</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                        <table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
                                            <tr>
                                                <td style="width:15%;font-size: 12px">INSTALADOX:</td>
                                                <td style="width:25%">
                                                    <select class="form-control input-sm" name="lblinstaladox" id="lblinstaladox" disabled="disabled">
                                                        <option>Seleccione</option>
                                                        <option value="TEC"<?php if ($instaladox == "TEC") {echo "selected";}?>>TEC</option>
                                                        <option value="DEL"<?php if ($instaladox == "DEL") {echo "selected";}?>>DEL</option>
                                                    </select>
                                                    <input id="lblidagenda" name="lblidagenda" value="<?php echo $idagenda;?>" hidden="">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">TÉCNICO:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"> 
                                                    <select name="lbltecnico" id="lbltecnico" class="form-control cbxtecnico input-sm" style="width: 100%;" disabled="disabled">
                                                        <?php echo $html_tecnico;?>
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">F.INSTALACIÓN:</td>
                                                <td style="width:25%">
                                                    <div class="input-group" id="fi">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control pull-right input-sm" id="fechainst" value="<?php echo $fechainstalacionver;?>"  name="lblfinstalacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled="disabled">
                                                    </div>
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">H.INSTALACIÓN:</td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <div class="bootstrap-timepicker timepicker">
                                                        <div class="input-group">
                                                            <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhinstalacion" id="horainst" value="<?php echo $horainstalacionver;?>" disabled="disabled" >
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-clock-o"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">REPERCUCIÓN:</td>
                                                <td colspan="3" style="width:50%">
                                                    <textarea class="form-control input-sm" name="lblrepercucion" id="lblrepercucion" rows="1" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php echo $repercucion;?></textarea></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    <a class="btn btn-danger btn-sm"  href="#" data-toggle="modal" id="logcambios" data-target="#modal-default"><i class="fa fa-pencil-square-o"></i> Log de Cambios</a>
                                                    <input type="hidden" name="lblIteraccionAgenda" value="<?php echo $IteraccionAgenda; ?>" id="lblIteraccionAgenda" />
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">DESPLAZAMIENTO</td>
                                                <td style="width:25%">
                                                    <input type="text" class="form-control pull-right input-sm" id="lbldesplazamientotecnico" value="<?php echo $Desplazamiento;?>"  name="lbldesplazamientotecnico" disabled="disabled">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px"></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                </td>
                                            </tr>                                       
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">COMENTARIO:</td>
                                                <td colspan="3" style="width:50%">
                                                    <textarea class="form-control input-sm" name="lblcomentarioagenda" id="lblcomentarioagenda" rows="1" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php echo utf8_encode($comentarioagenda);?></textarea>
                                                </td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"></td>
                                            </tr>
                                            <tr class="espacio" id="tinviableespacio"></tr>
                                            <tr id="tinviable">
                                                <td style="width:15%;font-size: 12px">MOTIVO INVIABLE:</td>
                                                <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblinviable" id="lblinviable" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $motivoinviable;?></textarea></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"></td>
                                            </tr>
                                            <tr class="espacio" id="tcanceladoespacio"></tr>
                                            <tr id="tcancelado">
                                                <td style="width:15%;font-size: 12px">MOTIVO CANCELADO:</td>
                                                <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lblcancelado" id="lblcancelado" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $motivocancelado;?></textarea></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"></td>
                                            </tr>
                                        </table>
                                    </div>
                                    <!-- /.box-body -->
                                </div>
                            <!-- INFORMACION DE CERTIFICACION -->
                            <div class="box box-custom div-certificacionventa">
                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                    <h5>INFORMACIÓN DE CERTIFICACIÓN VENTA</h5>
    
                                    <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
    
                                    </div>
                                </div>
                                <div class="box-body">
                                    <div style="width:100%;border-collapse: separate;padding: 20px 20px 10px;">
                                        <div class="form-group">
                                            <div class="col-md-2">
                                                <label style="font-size: 12px">GESTOR:</label>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control pull-right input-sm" id="lblasignado_cert" value="<?php echo $GestorCertVenta.' - '.$NombGestorCertVenta;?>"  name="lblasignado_cert" disabled="disabled">
                                            </div>
                                            <div class="col-md-2">
                                                <label style="font-size: 12px">FECHA DE APERTURA:</label>
                                            </div>
                                            <div class="col-md-4">
                                                 <div class="input-group" id="fi">
                                                    <div class="input-group-addon input-sm">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right input-sm" id="lblfechaapertura_cert" value="<?php echo $FechaApertura;?>"  name="lblfechaapertura_cert" disabled="disabled">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="col-md-2">
                                                <label style="font-size: 12px">FECHA CIERRE:</label>
                                            </div>
                                            <div class="col-md-4">
                                               
                                                   <div class="input-group" id="fi">
                                                           <div class="input-group-addon input-sm">
                                                               <i class="fa fa-calendar"></i>
                                                           </div>
                                                           <input type="text" class="form-control pull-right input-sm" id="lblfechacierre_cert" value="<?php echo $FechaCierre;?>"  name="lblfechacierre_cert" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled="disabled">
                                                    </div>
                                            </div>
                                            <div class="col-md-2">
                                                <label style="font-size: 12px">TIPO CIERRE:</label>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control pull-right input-sm" id="lbltipocierre_cert" value="<?php echo $TipoCierre;?>"  name="lbltipocierre_cert" disabled="disabled">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="col-md-2">
                                                <label style="font-size: 12px">MOTIVO INCIDENCIA:</label>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control pull-right input-sm" id="hidlblmotivoincidencia_cert" value="<?php echo $MotivoIncidencia;?>"  name="hidlblmotivoincidencia_cert" disabled="disabled">
                                            </div>
                                            <div class="col-md-2">
                                                <label style="font-size: 12px">SOLUCION INCIDENCIA:</label>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control pull-right input-sm" id="lblsolucionincidencia_cert" value="<?php echo $SolucionIncidencia;?>"  name="lblsolucionincidencia_cert" disabled="disabled">
                                            </div>
                                        </div>
                                        
                                        <div class="form-group">
                                            <div class="col-md-2">
                                                <label style="font-size: 12px">INC. TECNICA:</label>
                                            </div>
                                            <div class="col-md-4">
                                                        <input type="checkbox" name="inci_tecnica" id="inci_tecnica" <?php if($inci_tecnica=="SI"){echo 'checked';}else{echo '';}?> data-size="small" disabled="disabled"/>
                                                        <input type="hidden" name="hidden_inci_tecnica" id="hidden_inci_tecnica" value="<?php echo $inci_tecnica;?>">
                                            </div>
                                            <div class="col-md-2">
                                                <label style="font-size: 12px">FORMA PAGO:</label>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="text" class="form-control pull-right input-sm" id="hidlblformapago_cert" value="<?php echo $FormaPagoCert;?>"  name="hidlblformapago_cert" disabled="disabled">
                                                
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="col-md-2">
                                                <label style="font-size: 12px">COMENTARIO:</label>
                                            </div>
                                            <div class="col-md-4">
                                                   <textarea class="form-control input-sm" name="lblcomentario_cert" id="lblcomentario_cert" rows="2" style="resize:none"  placeholder="Ingresar..." disabled="disabled"><?php echo $ComentarioCert;?></textarea>
                                            </div>
                                            
                                        </div>                                    
                                    </div>
                                </div>
                            </div>                        
                            
                                    
                                    
                                <!-- INFORMACION DE FACTURACION -->
                                <div class="box box-custom">
                                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                                  <h5>INFORMACION DE FACTURACIÓN</h5>
                                    
                                                  <div class="box-tools pull-right">
                                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                                    </button>
                                                    
                                                  </div>
                                                </div>
                                                <!-- /.box-header -->
                                                <div class="box-body">
                                              <table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
                                                  <?php if($estadoventa=="InstaladaTEC" || $estadoventa=="Instalada" || $estadoventa=="IncidenciaGestCorreo" || $estadoventa=="IncidenciaGestValija" || $estadoventa=="Facturada" || $estadoventa=="PorFacturar" || $estadoventa=="DocEnvi"  || $estadoventa=="Incidencia" || $estadoventa=="NoDoc"){
                                                  ?>
                                                                <tr>
                                                                        <td style="width:15%;font-size: 12px">PAGO:</td>
                                                                        <td style="width:25%"><a class="btn btn-danger btn-social btn-sm"  data-toggle="modal" id="btnrealizarpago" data-target="#modal-mediodepago"> <i class="fa fa-credit-card"></i> Realizar Pago </a>
                                                                        <a class="btn btn-nuevo btn-social btn-sm"  data-toggle="modal" id="btnenviarcorreoafiliar" data-target="#modal-enviarcorreoafiliar"> <i class="fa fa-envelope-o"></i> Enviar Afiliacion </a>
                                                                        </td>
                                                                        <td style="width:10%"></td>
                        												<td colspan="3" style="width:42%">
                        													<label class="label label-danger" style="font-size:12px">ESTADO DE AFILIACION</label>
                        													<label class="label label-default" style="font-size:12px"><?php if($estadoafiliacion=="NOREGISTRADO"){ echo "RECHAZADO:".$ACTION_DESCRIPTION;}else if($estadoafiliacion=='REGISTRADO'){echo 'AFILIADO';}else if($estadoafiliacionmdp=='ENPROCESO'){echo 'ENPROCESO';}else if($estadoafiliacionmdp=='AFILIADO'){echo 'AFILIADO';}else if($estadoafiliacionmdp=='RECHAZADO'){echo "RECHAZADO:".$motivomdp;}else{echo 'PENDIENTE';}?></label>
                        													<?php if(isset($card) && !empty($card)){?>
                        													<label class="label label-default" style="font-size:12px"><?php echo $tipocuenta.' '.$card;?></label>
                        													<?php }
                        														?>
                        												</td>
                                                                    </tr>
                                                                     <tr class="espacio"></tr>
                                                                       <?  } ?>
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px">MOTIVO INCIDENCIA:</td>
                                                                        <td colspan="7" style="width:77%"><textarea class="form-control input-sm" name="lblmotivoincidencia" id="lblmotivoincidencia" rows="1" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php echo $factmotivoincidencia;?></textarea></td>
                                                                    </tr>
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px">FECHA RECEPCION DOC.:</td>
                                                                        <td style="width:25%"><div class="input-group">
                                                                                <div class="input-group-addon input-sm">
                                                                                    <i class="fa fa-calendar"></i>
                                                                                </div>
                                                                                <input type="text" class="form-control pull-right input-sm" id="lblfecharecpciondoc"  name="lblfecharecpciondoc" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfecharecepciondoc;?>" disabled="disabled" >
                                                                            </div>
                                                                        </td>
                                                                        <td style="width:10%"></td>
                                                                        <td style="width:15%;font-size: 12px">FECHA DE FACTURACIÓN: <span style="font-size: 12px; color:red ">(*)</span></td>
                                                                        <td style="width:2%"></td>
                                                                        <td style="width:25%"><div class="input-group">
                                                                                <div class="input-group-addon input-sm">
                                                                                    <i class="fa fa-calendar"></i>
                                                                                </div>
                                                                                <input type="text" class="form-control pull-right input-sm" id="lblfechafacturacion"  name="lblfechafacturacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfechafacturacion;?>" disabled="disabled" />
                                                                            </div></td>
                                                                    </tr>
                </table>
                
                <table cellspacing="0"  style="width:100%;border-collapse: separate;padding: 20px">                                                  
                                                                    <tr>
                                                                        <td style="font-size: 12px; color:red ">MOTIVOS DE INCIDENCIA (*):</td>
                                                                    </tr>
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:8%;font-size: 12px">DOC. ORIGINAL:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdocoriginal" id="lblfactdocoriginal" value="<?php echo $factdocoriginal;?>" disabled="disabled" /></td>
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">FALTA DNI:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdni" id="lblfactdni" value="<?php echo $factdni;?>" disabled="disabled" /></td>
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">REHACER CTO:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactrehacercto" id="lblfactrehacercto" value="<?php echo $factrehacercto;?>" disabled="disabled" /></td>
                                                                    </tr>
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:8%;font-size: 12px">SEGMENTACIÓN:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactsegmentacion" id="lblfactsegmentacion" value="<?php echo $factsegmentacion;?>" disabled="disabled" /></td>
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">ELEMENTOS CTO PS:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactelementosctops" id="lblfactelementosctops" value="<?php echo $factelementosctops;?>" disabled="disabled" /></td>
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">AFILIACION:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactafiliacion" id="lblfactafiliacion" value="<?php echo $factafiliacion;?>" disabled="disabled" /></td>
                                                                    </tr>
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:8%;font-size: 12px">PAGO:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactpago" id="lblfactpago" value="<?php echo $factpago;?>" disabled="disabled" /></td>   
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">DOC PAI:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdocpai" id="lblfactdocpai" value="<?php echo $factdocpai;?>" disabled="disabled" /></td>
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">PROSPECTO/NRO GUIA:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactprospecto_nroguia" id="lblfactprospecto_nroguia" value="<?php echo $factprospecto_nroguia;?>" disabled="disabled" /></td>
                                                                    </tr>
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:8%;font-size: 12px">AUTORIZA:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactautoriza" id="lblfactautoriza" value="<?php echo $factautoriza;?>" disabled="disabled" /></td>
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">FALTA DOC (P.A./CTO):</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactfaltadoc" id="lblfactfaltadoc" value="<?php echo $factfaltadoc;?>" disabled="disabled" /></td>
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">FUERA DE HORA:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactfuerahora" id="lblfactfuerahora" value="<?php echo $factfuerahora;?>" disabled="disabled" /></td>
                                                                    </tr>
                    </table> 
            </div>
            <!-- /.box-body -->
       
          </div>
                            </form>
                        </div>
                        <div class="col-md-2"></div>
                    </div>

            
<!-- DISPONIBILIDAD -->
                    <div class="modal fade" id="modalDisponibilidad" tabindex="-1" role = "doalog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4>DISPONIBILIDAD DE AGENDAMIENTO</h4>
                                </div>
                                <div class="modal-body" id="vistaboy4" height="500"> 
                                
                                    <iframe id="iframeCalendario" src="" style="border:0px" width="100%" height="500" allowfullscreen >
                                    </iframe>   
        
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                                </div>
                            </div>
                        </div>
                    </div>
<!-- ////// -->
<!-- Modal  to Add Event -->


                    <div class="modal fade" id="modal-default">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4>GESTIONES DE AGENDAMIENTO</h4>
                                </div>
                                <div class="modal-body" id="vistaboy">
                                    <div id="myGrid"  style="height: 100%" class="ag-theme-fresh"></div>
                                    <div  id="ningunresultado"></div>
                                </div> 
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                                </div>                  
                            </div>  
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->

                    <div class="modal fade" id="modal-contactados">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4>GESTIONES DE CONTACTIVILIDAD</h4>
                                </div>
                                <div class="modal-body" id="vistaboy2">
                                    <div  class="">
                                        <h4 id="TotalGestiones">Total Gestiones: <span><?php echo $totalGestiones; ?></span> </h4>
                                        </div>
                                    <div id="myGridactividad"  style="height: 100%" class="ag-theme-fresh"></div>
                                    <div  id="ningunresultadoactividad"></div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                                </div>
                            </div>  
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                    
                    <div class="modal fade" id="modal-mediodepago">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h3 id="myModalLabel">MEDIO DE PAGOS</h3>
                                </div>
                                <div class="modal-body">
                                    <div id="c-slider">
                                        <div id="slider">
                                            <section id="myWizard0">
                                                <div class="row">
                                                    <!-- left column -->
                                                    <div class="col-xs-12">
                                                            <!-- general form elements -->
                                                            <div class="box box-danger">
                                                                <div class="box-header">
                                                                    <h1 class="box-title">SELECCIONE TIPO DE TARJETA</h1>
                                                                </div>
                                                                <!-- /.box-header -->
                                                                <!-- form start -->
                                                        <div class="box-body" id="bodyprincipal" >
                                                            <div class="row fila-tarjeta">
                                                              <div class="col-md-2"></div>
                                                              <div class="col-md-3">
                                                                <img src="img/credit/Visa2.png" alt="VISA" class="btnvisa">
                                                              </div>
                                                              <div class="col-md-2"></div>
                                                              <div class="col-md-3">
                                                                <img src="img/credit/MasterCard.png" alt="MASTERCARD" class="btnmastercard">
                                                              </div>
                                                              <div class="col-md-2"></div>
                                                            </div>
                                                            <div class="row fila-tarjeta">
                                                                <div class="col-md-2"></div>
                                                                <div class="col-md-3">
                                                                    <img src="img/credit/dinerslogo.png" alt="DINNERS" class="btndinners">
                                                                </div>
                                                                <div class="col-md-2"></div>
                                                                <div class="col-md-3">
                                                                    <img src="img/credit/american.png" alt="AMERICAN EXPRESS" class="btnamex">
                                                                </div>
                                                                <div class="col-md-2"></div>
                                                            </div>
                                                            </div>
                                                                </div>
                                                                <!-- /.box-body -->
                                                            </div>
                                                        <!-- /.box -->
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-nuevo" data-dismiss="modal">Cerrar</button>
                                                </div>
                                            </section>
                                            <section id="myWizard">
                                                    <div class="row">
                                                        <!-- left column -->
                                                        <div class="col-xs-12">
                                                            <!-- general form elements -->
                                                            <div class="box box-danger">
                                                                <div class="box-header">
                                                                         <h1 class="box-title" id="titulo"></h1>
                                                                         <h1 class="box-title" id="titulo2"></h1>
                                                                </div>
                                                                <!-- /.box-header -->
                                                                <!-- form start -->
                                                                <div class="box-body" id="bodyprincipal">
                                                                    <div class="row">
                                                                         <div class="col-md-1 col-sm-1 col-xs-1">  </div>                                              
                                                                        <div class="col-md-10 col-sm-10 col-xs-10">
                                                                          <a class="btn btn-default btn-social btn-block btn-lg step3"> <i class="fa fa-credit-card"></i>PAGAR AHORA </a>
                                                                          <div class="espacio"> </div>
                                                                          <!-- /.info-box -->
                                                                        </div>
                                                                        <div class="col-md-1 col-sm-1 col-xs-1">  </div>   
                                                                        </div>
                                                                    <div class="row">
                                                                         <div class="col-xs-1">  </div>                                              
                                                                        <div class="col-xs-10">
                                                                          <a class="btn btn-default btn-social btn-block btn-lg  step2"> <i class="fa fa-envelope-o"></i>ENVIAR CORREO </a>
                                                                          <div class="espacio"> </div>
                                                                          <!-- /.info-box -->
                                                                        </div>
                                                                        <div class="col-xs-1">  </div>   
                                                                        </div> 
                                                                    </div>
                                                                </div>
                                                                <!-- /.box-body -->
                                                            </div>
                                                            <!-- /.box -->
                                                    </div>
                                                    <div class="modal-footer">
                                                       <a class="btn btn-default  regresarvtaonline" href="#"><i class="fa fa-reply"> Regresar</i></a> 
                                                        <button type="button" class="btn btn-nuevo pull-right" data-dismiss="modal">Cerrar</button>
                                                    </div>
                                                    </section>
                                            <section id="myWizard2">
                                                        <div class="row">
                                                            <!-- left column -->
                                                            <div class="col-xs-12">
                                                                <!-- general form elements -->
                                                                <div class="box box-danger">
                                                                    <div class="box-header">
                                                                    </div>
                                                                    <!-- /.box-header -->
                                                                    <!-- form start -->
                                                                       <div class="box-body" id="bodyventaoline">
                                                                        <div id="divLoadingBoton" style="display: none;">
                                                                        <div class="spinnerBoton">
                                                                          <div class="bounce1Boton"></div>
                                                                          <div class="bounce2Boton"></div>
                                                                          <div class="bounce3Boton"></div>
                                                                        </div>
                                                                    </div>
                                                                    <input id="lblmediopago" name="lblmediopago" value="" hidden="">
                                                                    <div  id="ningunresultado3"></div>
                                                                        </div>
                                                                                    <!-- /.box-body -->
                                                                </div>
                                                                <!-- /.box -->
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <a class="btn btn-link mensajematricula pull-left"  href="#"></a>
                                                            <button type="button" class="btn btn-nuevo" id="Cerrarmodal" data-dismiss="modal">Cerrar</button>
                                                        </div>
                                                    </section>
                                        </div>
                                    </div>
                                </div>
                            </div>  
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                    
                    <!-- MODAL PRODUCTOS -->
                    <div class="modal fade" id="modal_productos">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4>DETALLE PRODUCTOS</h4>
                                </div>
                                <div class="modal-body">
                        <div class="box box-solid" style="box-shadow: none;">
                            <form>
                                <div class="box-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="cboProducto" class="col-sm-3 control-label">Extra:</label>
                                                <div class="col-sm-9">
                                                    <select class="form-control select2" id="cboProducto" name="cboProducto" style="width: 100%">
                                                        <option value="" disabled selected>--Seleccione--</option>
                                                        <?php
                                                            $query="SELECT IdItem, CodItem, Item, Precio, CuotaMes
                                                                    FROM tblitem
                                                                    where CategoriaItem = 'televenta' and Estado = 'Activo'";
                                                            $resultado=$con->query($query);
                                                                    
                                                            while ($data = $resultado->fetch_assoc()){                                                          
                                                        ?>
                                                                <option value="<?php echo $data['IdItem']; ?>"><?php echo $data ['Item']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="cboTipoPrecio" class="col-sm-3 control-label">Tipo Precio:</label>
                                            <div class="col-sm-9">
                                                <select class="form-control select2" id="cboTipoPrecio" name="cboTipoPrecio" style="width: 100%">
                                                    <option value="" disabled selected>--Seleccione--</option>
                                                    <option value="catalogo">CATALOGO</option>
                                                    <option value="medio">MEDIO</option>
                                                    <option value="autorizado">AUTORIZADO</option>
                                                    <option value="regalo">REGALO</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="lblPrecioAdicional" class="col-sm-3 control-label">Precio Especial:</label>
                                                <div class="col-sm-9">
                                                    <input type="number" class="form-control input-sm" id="lblPrecioAdicional" name="lblPrecioAdicional" style="width: 100%">
                                                </div>
                                            </div>
                                        </div>
                                        <!--
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="lblRegalo" class="col-sm-3 control-label">Regalo:</label>
                                                <div class="col-sm-9">
                                                    <input type="checkbox" name="cboxRegalo" id="cboxRegalo" data-size="small"/>
                                                    <input type="hidden" id="HidcboxRegalo" value="NO">
                                                </div>
                                            </div>
                                        </div>
                                        -->
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <button class="btn btn-danger pull-right" id="btnAgregar" name="btnAgregar"><i class="fa fa-plus"></i>&nbsp Agregar </button>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-2"></div>
                                        <div class="col-md-8">
                                            <table class="table table-hover" id="tbdatos">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Producto</th>
                                                        <th>Tipo Precio</th>
                                                        <th>Precio</th>
                                                        <th>Cuota Mensual</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                </tbody>
                                            </table>
                                        </div>
                                        
                                    </div>
                                    <br>
                                    <!--
                                    <div class="row">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-8">
                                            <label for="txtResumen" class="col-md-4 control-label">Licencia Guardian:</label>
                                            <div class="col-md-8">
                                                <div class="input-group">
                                                    <input type="text" class="form-control input-sm" name="lblAdicionalesOtros" id="lblAdicionalesOtros">
                                                    <div class="input-group-addon btn" id="btnAgregarOtros">
                                                        <i class="fa fa-plus"></i>
                                                    </div>
                                                </div>      
                                            </div>
                                        </div>
                                        
                                    </div>
                                    <br>
                                    -->
                                    <div class="row">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-8">
                                            <label for="txtResumen" class="col-sm-4 control-label">Resumen:</label>
                                            <div class="col-sm-8">
                                                <textarea rows="2" id="txtResumen" name="txtResumen" style="width: 100%" disabled></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-8">
                                            <label for="txtCantidadExtra" class="col-sm-4 control-label">Cantidad Extras:</label>
                                            <div class="col-sm-8">
                                                <input type="number" id="txtCantidadExtra" name="txtCantidadExtra" style="width: 100%" min="0" value="0" disabled>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-8">
                                            <label for="txtCantidadRegalo" class="col-sm-4 control-label">Cantidad Regalo:</label>
                                            <div class="col-sm-8">
                                                <input type="number" id="txtCantidadRegalo" name="txtCantidadRegalo" style="width: 100%" min="0" value="0" disabled>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-8">
                                            <label for="txtTotal" class="col-sm-4 control-label">Total:</label>
                                            <div class="col-sm-8">
                                                <input type="number" id="txtTotal" name="txtTotal" style="width: 100%" min="0" value="0.00" disabled>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-8">
                                            <label for="txtTotalCuota" class="col-sm-4 control-label">Total Cuota:</label>
                                            <div class="col-sm-8">
                                                <input type="number" id="txtTotalCuota" name="txtTotalCuota" style="width: 100%" min="0" value="0.00" disabled>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" id="Cerrarmodal" data-dismiss="modal">Cerrar</button>
                                    <input type="submit" name="btnGenerar" id="btnGenerar" value="Generar" class="btn btn-danger">
                                </div>   
                            </div>
                        </div>
                    </div>

            <!-- MODAL DE SCORING -->
                <div class="modal fade" id="modal-consultascoring">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <div class="modal-header modal-header-danger">
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                <h4>CONSULTAR SCORING</h4>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div id="frmEditarVentaScoring" method="post">
                                            <div class="box box-danger">
                                                <div class="box-header with-border">
                                                    <h5>SCORING</h5>
                                                    <div class="box-tools pull-right">
                                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="box-body">
                                                    <div class="form-horizontal" style="padding: 10px 20px 0">
                                                        <div class="form-group">
                                                            <label style="text-align: left;">TIPO DOCUMENTO:</label>
                                                            <input type="hidden" id="matriculausuario" value="<?php echo $matriculausuario; ?>">
                                                            <input type="hidden" id="nombreusuario" value="<?php echo $nombreusuario; ?>">
                                                            <select class="form-control input-sm" name="TipoDocumento" id="TipoDocumento">
                                                                <option value="">Seleccione</option>
                                                                <option value="1">DNI</option>
                                                                <option value="3">Carnet Extranjeria</option>
                                                                <option value="6">RUC</option>
                                                            </select>
                                                            <a href="#" title="Modal de Busqueda de Documento" id="btnEquifax">(No tengo el Número de Documento)</a>

                                                        </div>
                                                        <div class="form-group">
                                                            <label id="labeltelefono">DOCUMENTO: </label>
                                                            <input type="text" class="form-control input-sm" name="Documento" id="Documento" maxlength="12" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                                                        </div>
                                                        <div class="form-group">
                                                            <label>DEPARTAMENTO: </label>
                                                            <select class="form-control input-sm select2full" name="Departamental" id="Departamental" style="width: 100%">
                                                                <option value="" selected>Seleccione</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group">
                                                            <label>PROVINCIA: </label>
                                                            <select class="form-control input-sm select2full" name="Provincial" id="Provincial" style="width: 100%">
                                                                <option value="">Seleccione</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group">
                                                            <label>DISTRITO: </label>
                                                            <select class="form-control input-sm select2full" name="Distrital" id="Distrital" style="width: 100%">
                                                                <option value="">Seleccione</option>
                                                            </select>
                                                        </div>
                                                    <div class="form-group ocultar">
                                                    <label>SEGMENTO: </label>
                                                             <select class="form-control input-sm" name="Segmento" id="Segmento" style="width: 100%">
                                                                        <option value="">Seleccione</option>
                                                                        <option value="RES">RES</option>
                                                                        <option value="NEG">NEG</option>
                                                            </select>
                                                     </div>                                             
                                                        <div class="form-group" style="margin-top:40px;">
                                                            <button class="btn  btn-block btn-verisure" id="btnScoring">Consultar Scoring</button>
                                                            <button class="btn  btn-block btn-verisure" style="display:none" id="btnNuevaScoring">Nueva Consulta</button>
                                                            <button type="button" class="btn btn-block btn-verisurecerrar" data-dismiss="modal">Cerrar</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <main class="contenedor ocultar box box-danger" id="ResultadoEquifax">
                                            <div id="resultado">
                                                <div class="callout bg-deuda">
                                                    <h4><i class="fa fa-bullhorn"></i> Resultado de la Consulta:</h4>
                                                    <h2 style="text-align: center;"><small class="label bg-visita"><span class="TextoAccion"></span></small><small class="label bg-televenta"><span class="TextoAccion"></span></small><small class="label bg-gestion"><span class="TextoAccion"></span></small></h2><br>
                                                    <!--<strong>N°Operación: </strong><span id="NOperacion">S32012280000162</span><br>-->
                                                    <strong>Fecha Consulta: </strong><span id="FechaConsulta">13/11/2019 12:24:34</span><br><br>

                                                    <div class="row">
                                                        <div class="col-xs-12">
                                                            <strong><i class="fa fa-user text-danger"></i> Nombre del Solicitante:</strong><br><span id="NombreCompleto">DUBOIS DORIBAL DUBOIS DORIBAL GLADYS ELVIRA</span><br>
                                                            <strong><i class="fa fa-folder-open text-danger"></i> <span id="TDocumento">DNI:</span></strong><br><span id="NumeroDocumento">00007039332</span><br>
                                                        </div>

                                                        <div class="col-xs-12" style="display:none">
                                                            <div class="contenido-score">
                                                                <div class="score-info">
                                                                    <div>
                                                                        <strong>SCORE - RIESGO</strong>
                                                                        <br>

                                                                        <span id="Riesgo">Bajo</span>
                                                                    </div>
                                                                    <div>
                                                                        <strong>SCORE - VALOR</strong>
                                                                        <br>
                                                                        <div id="Valor">952</div>
                                                                    </div>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>


                                                </div>
                                            </div>
                                        </main>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            <!-- MODAL DE DNISCORING -->    
                <div class="modal fade" id="modal-logdni">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <div class="modal-header modal-header-danger">
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                <h3>DOCUMENTOS</h3>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-xs-12 col-sm-12 table-responsive no-padding">
                                        <table class="table table-bordered" id="tblVentas" style="display:none;">
                                            <thead>
                                                <tr style="height:0.8vw">
                                                    <td class="text-center">OPCIONES</td>
                                                    <td class="text-center">FECHA CONSULTA</td>
                                                    <td class="text-center">TIPO DOC.</td>
                                                    <td class="text-center">DOCUMENTO</td>
                                                    <td class="text-center">NOMBRES, APELLIDO PATERNO, APELLIDO MATERNO</td>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                            </div>

                        </div>
                    </div>
                </div>                        

            <!-- MODAL DE CLIENTE-PROSPECTO -->
                <div class="modal fade" id="modal-editarclienteprospecto">
                    <div class="modal-dialog modal-sm">
                        <div class="modal-content">
                            <div class="modal-header modal-header-danger">
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                <h4>EDITAR CLIENTE-PROSPECTO</h4>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                        
                                        <div class="box-body">
                                                    <div class="form-horizontal" style="padding: 10px 20px 0">

                                                        <div class="form-group">
                                                            <label style="font-size: 12px">N° PROSPECTO:</label>
                                                            <input type="text" class="form-control input-sm" name="lblnprospectoz" id="lblnprospectoz" data-inputmask='"mask": "999999"' value="" data-mask>
                                                        </div>
                                                        <div class="form-group">
                                                            <label style="font-size: 12px">CLIENTE:</label>
                                                            <input name="lblnombclientez" class="form-control input-sm" id="lblnombclientez" value="" style="width: 100%;"/>
                                                        </div>
                                                        <div class="form-group">    
                                                                <label style="width:15%;font-size: 12px">CORREO:</label>
                                                                <input type="text"  class="form-control input-sm" id="lblcorreoz" value="" name="lblcorreoz">
                                                        </div>
                                                        <div class="form-group">
                                                            <label style="font-size: 12px">DIRECCIÓN:</label>
                                                                <textarea class="form-control input-sm" name="lbldireccionz" id="lbldireccionz" rows="1" style="resize:none" placeholder="Ingresar..."></textarea>
                                                        </div>
                                                        <div class="form-group">                                                    
                                                            <label style="font-size: 12px">DISTRITO-PROVINCIA:</label>
                                                                <select class="form-control selectdistrito input-sm" name="lbldistritoz" id="lbldistritoz" style="width: 100%;">
                                                                    <option value="<?php echo $idgeografico; ?>"><?php echo $distrito.' - '.$provincia; ?></option>
                                                                </select>
                                                                <input id="lblIdDepartamental" name="lblIdDepartamental" value="<?php echo $IdDepartamental; ?>" hidden="" />
                                                                <input id="lblProvinciaCalendario" name="lblProvinciaCalendario" value="<?php echo $provincia; ?>" type="hidden" />
                                                        </div>
                                                        <div class="form-group">
                                                                <label style="font-size: 12px">TELEFONO DOS:</label>
                                                                <input type="text" class="form-control input-sm" name="lblfijoz" id="lblfijoz" value="" data-inputmask='"mask": "999999999"'  data-mask>
                                                        </div>
                                                        
                                                        <div class="form-group" style="margin-top:40px;">
                                                            <button class="btn  btn-block btn-verisure" id="btnActualizarCliente">ACTUALIZAR</button>
                                                            <button type="button" class="btn btn-block btn-verisurecerrar" data-dismiss="modal">Cerrar</button>
                                                        </div>
                                                    </div>
                                                </div>
                                        
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            <!-- MODAL ENVIO DE AFILIACION -->
            <div class="modal fade" id="modal-enviarcorreoafiliar" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-enviocorreo-title">ENVIAR A AFILIAR</h4>
                        </div>
                        <div class="modal-body">
                            <form id="form_enviocorreo" methodo="POST">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">CORREO:</label>
                                    <input type="email" class="form-control" id="InputCorreo" placeholder="Escribir correo">
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" id="ModEnviarCerrar" data-dismiss="modal">Cerrar</button>
                            <button type="button" class="btn btn-danger" id="ModEnviar">Enviar</button>
                        </div>
                    </div>
                </div>
            </div>

                </section>
                <!-- /.content -->
            </div>
            <!-- /.content-wrapper -->
            <div class="control-sidebar-bg"></div>
        </div>
        <!-- ./wrapper -->
       <!-- jQuery v1.11 -->
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
        $.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
        <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- SweetAlert -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10" type="text/javascript"></script>
        <!-- TOOGLE -->
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>
        <!-- AGGRID-->
        <script>
            var columnDefs = [
                {headerName: 'FechaHoraREG', field: 'FechaHoraREG', width: 140},
                {headerName: 'FechaInst', field: 'FechaInst', width: 130},
                {headerName: 'HoraInst', field: 'HoraInst', width: 105},
                {headerName: 'InstaladoX', field: 'InstaladoX', width: 100},
                {headerName: 'MatriculaTec', field: 'MatriculaTec', width: 110},
                {headerName: 'Repercusion', field: 'Repercusion', width: 130},
                {headerName: 'R.Costo', field: 'RepercusionCosto', width: 90},
                {headerName: 'MotivoInviable', field: 'MotivoInviable', width: 150},
                {headerName: 'Comentario', field: 'Comentario', width: 200},
                {headerName: 'EstadoVenta', field: 'EstadoVenta', width: 120},
                {headerName: 'Gestor', field: 'GestorAgenda', width: 120}
            ];

            var columnDefscontactado = [
                                        {headerName: 'FechaHoraREG', field: 'FechaHoraREG', width: 140},
                                        {headerName: 'EstadoVisita', field: 'EstadoVisita', width: 100},    
                                        {headerName: 'EstadoVenta', field: 'EstadoVenta', width: 111},
                                        {headerName: 'EstadoTelecierre', field: 'EstadoTelecierre', width: 130},
                                        {headerName: 'TipoVenta', field: 'TCTipoVenta', width: 90},
                                        {headerName: 'MotivoNoVenta', field: 'TCMotivoNoVenta', width: 90},
                                        {headerName: 'CC', field: 'TCCC', width: 53},
                                        {headerName: 'CCOriginal', field: 'CCOriginal', width: 53},
                                        {headerName: 'TCGestor', field: 'TCGestor', width: 91},
                                        {headerName: 'PrecioKIT', field: 'TCPrecioKIT', width: 93},
                                        {headerName: 'TotalExtra', field: 'TCTotalExtra', width: 93},
                                        {headerName: 'ResumenVenta', field: 'TCResumenVenta', width: 230},
                                        {headerName: 'ExtraAutorizado', field: 'TCExtraAutorizado', width: 130},
                                        {headerName: 'FormaPago', field: 'TCFormaPago', width: 120},
                                        {headerName: 'MesesAutorizado', field: 'TCMesesAutorizado', width: 80},
                                        {headerName: 'PAI', field: 'TCPAI', width: 70},
                                        {headerName: 'Comentario', field: 'TCComentario', width: 240},
                                        {headerName: '590', field: 'TC590', width: 89},
                                        {headerName: 'FormaPago', field: 'TCFormaPago', width: 120},
                                        {headerName: 'TCVisitado', field: 'TCVisitado', width: 120},
                                        {headerName: 'TCScoring', field: 'TCScoring', width: 120},
                                        {headerName: 'TCCompetencia', field: 'TCCompetencia', width: 120},
                                        {headerName: 'GestorOrigen', field: 'GestorOrigen', width: 115},
                                        {headerName: 'FechaUltimaGestion', field: 'FechaModEstado', width: 115},
                                    ];

            var gridOptions = {
        columnDefs: columnDefs,
        rowData: null,
        enableFilter: true,
        enableColResize: true,
        localeText: {
            // for filter panel
            page: 'página',
            more: 'Más',
            to: 'a',
            of: 'de',
            next: 'Siguiente',
            last: 'Último',
            first: 'Primero',
            previous: 'Anterior',
            loadingOoo: 'Cargando...',
            // for set filter
            selectAll: 'Seleccionar todo',
            searchOoo: 'Buscando...',
            blanks: 'Espacios en blanco',
            // for number filter and text filter
            filterOoo: 'Filtrar...',
            applyFilter: 'Aplicar Filtro',
            // for number filter
            equals: 'Igual',
            notEqual: 'No es igual',
            lessThanOrEqual: 'Menor o igual',
            greaterThanOrEqual: 'Mayor que o igual',
            inRange: 'En el rango',
            lessThan: 'Menos que',
            greaterThan: 'Mas grande que',
            // for text filter
            contains: 'Contiene',
            startsWith: 'Comienza con',
            endsWith: 'Termina con',
            notContains:'No contiene',
            // the header of the default group column
            group: 'Grupo',
            // tool panel
            columns: 'columnas',
            rowGroupColumns: 'Grupo columnas',
            rowGroupColumnsEmptyMessage: 'No hay resultado',
            valueColumns: 'Columna de valor',
            pivotMode: 'Modo pivote',
            groups: 'grupos',
            values: 'valor',
            pivots: 'pivote',
            valueColumnsEmptyMessage: 'No hay resultado',
            pivotColumnsEmptyMessage: 'No hay resultado',
            // other
            noRowsToShow: '<div class="callout callout-danger">\n\
<span class="pull-left">\n\
<img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
</span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
<strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
<p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
<br></div>'


            ,
            // enterprise menu
            pinColumn: 'Aclar columna',
            valueAggregation: 'Agregar valor',
            autosizeThiscolumn: 'Auto tamaño esta columna ',
            autosizeAllColumns: 'Auto tamaño todas columnas',
            groupBy: 'Agrupar',
            ungroupBy: 'Agrupar uno',
            resetColumns: 'Restaurar Columnas',
            expandAll: 'expandir todo',
            collapseAll: 'desplegar todo',
            toolPanel: 'Panel de Heramientas',
            export: 'Exportar',
            csvExport: 'Exportar CSV',
            excelExport: 'Exportar Excel',
            // enterprise menu pinning
            pinLeft: 'Anclar a derecha',
            pinRight: 'Anclar a izquierda',
            noPin: 'Desanclar',
            // enterprise menu aggregation and status panel
            sum: 'Sumar',
            min: 'Minimo',
            max: 'Maximo',
            first: 'Primero',
                    last: 'Ultimo',
                    none: 'Nada',
            count: 'Contador',
            average: 'Promedio',
            // standard menu
            copy: 'Copiar',
            copyWithHeaders: 'Copiar Cabecera',
            ctrlC: 'Ctrl+C',
            paste: 'Pegar',
            ctrlV: 'Ctrl+V'
        },
        enableSorting: true
    };
    
            var gridOptionsconctactado = {
                columnDefs: columnDefscontactado,
                rowData: null,
                enableFilter: true,
                enableColResize: true,
                localeText: {
                    // for filter panel
                    page: 'página',
                    more: 'Más',
                    to: 'a',
                    of: 'de',
                    next: 'Siguiente',
                    last: 'Último',
                    first: 'Primero',
                    previous: 'Anterior',
                    loadingOoo: 'Cargando...',
                    // for set filter
                    selectAll: 'Seleccionar todo',
                    searchOoo: 'Buscando...',
                    blanks: 'Espacios en blanco',
                    // for number filter and text filter
                    filterOoo: 'Filtrar...',
                    applyFilter: 'Aplicar Filtro',
                    // for number filter
                    equals: 'Igual',
                    notEqual: 'No es igual',
                    lessThanOrEqual: 'Menor o igual',
                    greaterThanOrEqual: 'Mayor que o igual',
                    inRange: 'En el rango',
                    lessThan: 'Menos que',
                    greaterThan: 'Mas grande que',
                    // for text filter
                    contains: 'Contiene',
                    startsWith: 'Comienza con',
                    endsWith: 'Termina con',
                    notContains:'No contiene',
                    // the header of the default group column
                    group: 'Grupo',
                    // tool panel
                    columns: 'columnas',
                    rowGroupColumns: 'Grupo columnas',
                    rowGroupColumnsEmptyMessage: 'No hay resultado',
                    valueColumns: 'Columna de valor',
                    pivotMode: 'Modo pivote',
                    groups: 'grupos',
                    values: 'valor',
                    pivots: 'pivote',
                    valueColumnsEmptyMessage: 'No hay resultado',
                    pivotColumnsEmptyMessage: 'No hay resultado',
                    // other
                    noRowsToShow: '<div class="callout callout-danger">\n\
                        <span class="pull-left">\n\
                        <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
                        </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
                        <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
                        <br></div>',
                    // enterprise menu
                    pinColumn: 'Aclar columna',
                    valueAggregation: 'Agregar valor',
                    autosizeThiscolumn: 'Auto tamaño esta columna ',
                    autosizeAllColumns: 'Auto tamaño todas columnas',
                    groupBy: 'Agrupar',
                    ungroupBy: 'Agrupar uno',
                    resetColumns: 'Restaurar Columnas',
                    expandAll: 'expandir todo',
                    collapseAll: 'desplegar todo',
                    toolPanel: 'Panel de Heramientas',
                    export: 'Exportar',
                    csvExport: 'Exportar CSV',
                    excelExport: 'Exportar Excel',
                    // enterprise menu pinning
                    pinLeft: 'Anclar a derecha',
                    pinRight: 'Anclar a izquierda',
                    noPin: 'Desanclar',
                    // enterprise menu aggregation and status panel
                    sum: 'Sumar',
                    min: 'Minimo',
                    max: 'Maximo',
                    first: 'Primero',
                            last: 'Ultimo',
                            none: 'Nada',
                    count: 'Contador',
                    average: 'Promedio',
                    // standard menu
                    copy: 'Copiar',
                    copyWithHeaders: 'Copiar Cabecera',
                    ctrlC: 'Ctrl+C',
                    paste: 'Pegar',
                    ctrlV: 'Ctrl+V'
                },
                enableSorting: true
            };

            function listar() {
     var idventa=$('#idVenta').val();
        $.ajax({
            url: 'ajax/findDataHisAgenda.php?idventa='+idventa,
            success: function (r) {

                if (r == 1) {
                    var gridDiv = document.querySelector('#myGrid');
                    new agGrid.Grid(gridDiv, gridOptions);

                    agGrid.simpleHttpRequest({url: 'ajax/selectListarHistAgenda.php?idventa='+idventa}).then(function (data) {

                        gridOptions.api.setRowData(data);
                    });
                    $('#vistaboy').height(function (index, height) {

                        return $(window).height() * 35 / 100;
                    });
                   
                } else {

                    $("#ningunresultado").html(r);

                    var gridDiv = document.querySelector('#myGrid');
                    new agGrid.Grid(gridDiv, gridOptions);

                    agGrid.simpleHttpRequest({url: 'ajax/selectListarHistAgenda.php?idventa='+idventa}).then(function (data) {

                        gridOptions.api.setRowData(data);
                    });



                    $('#myGrid').hide("fast");

                }





            }
        });
    }

            function listarTC() {
                var idventa=$('#idVenta').val();
                $.ajax({
                    url: 'ajax/findDataHisTelecierre.php?idventa='+idventa,
                    success: function (data) {
        
                        if (data == 1) {
                            var gridDiv = document.querySelector('#myGridactividad');
                            new agGrid.Grid(gridDiv, gridOptionsconctactado);
        
                            agGrid.simpleHttpRequest({url: 'ajax/selectListarHistTelecierre_pre.php?idventa='+idventa}).then(function (data) {
        
                                gridOptionsconctactado.api.setRowData(data);
                            });
                            $('#vistaboy2').height(function (index, height) {
        
                                return $(window).height() * 35 / 100;
                            });
                           
                        } else {
        
                            $("#ningunresultadoactividad").html(data);
        
                            var gridDiv = document.querySelector('#myGridactividad');
                            new agGrid.Grid(gridDiv, gridOptionsconctactado);
        
                            agGrid.simpleHttpRequest({url: 'ajax/selectListarHistTelecierre_pre.php?idventa='+idventa}).then(function (data) {
        
                                gridOptionsconctactado.api.setRowData(data);
                            });
        
        
        
                            $('#myGridactividad').hide("fast");
        
                        }
        
        
        
        
        
                    }
                });
            }

            var refresh = function () {
                var idventa=$('#idVenta').val();
                $.ajax({
                    url: 'ajax/findDataHisAgenda.php?idventa='+idventa,
                    success: function (r) {
        
                        if (r == 1) {
        
                            var gridDiv = document.querySelector('#myGrid');
                            agGrid.simpleHttpRequest({url: 'ajax/selectListarHistAgenda.php?idventa='+idventa}).then(function (data) {
                                gridOptions.api.setRowData(data);
                            });
                            $('#vistaboy').height(function (index, height) {
        
                                return $(window).height() * 35 / 100;
                            });
                            $("#ningunresultado").hide("fast");
                            $('#myGrid').show(200);
                        } else {
        
                            $("#ningunresultado").html(r);
                            $('#myGrid').hide("fast");
        
                        }
        
        
        
        
        
                    }
                });

            }

            var refreshTC = function () {
                var idventa=$('#idVenta').val();
                    $.ajax({
                        url: 'ajax/findDataHisTelecierre.php?idventa='+idventa,
                        success: function (data) {
            
                            if (data == 1) {
            
                                var gridDiv = document.querySelector('#myGridactividad');
                                agGrid.simpleHttpRequest({url: 'ajax/selectListarHistTelecierre_pre.php?idventa='+idventa}).then(function (data) {
                                    gridOptionsconctactado.api.setRowData(data);
                                });
                                $('#vistaboy2').height(function (index, height) {
            
                                    return $(window).height() * 35 / 100;
                                });
                                $("#ningunresultadoactividad").hide("fast");
                                $('#myGridactividad').show(200);
                            } else {
            
                                $("#ningunresultadoactividad").html(data);
                                $('#myGridactividad').hide("fast");
            
                            }
            
            
            
            
            
                        }
                    });
            
            }

            // setup the grid after the page has finished loading
            document.addEventListener('DOMContentLoaded', function () {
               listarTC();
               listar();
            });
        </script>

        <script>
            $("#lblcctc").change(function () {
                $("#lblcctc option:selected").each(function () {
                    var lblcctc= $(this).val();
                    $.post("./ajax/selectGestorTC.php", { lblcctc: lblcctc}, function(data){
                        $("#lblgestortc").html(data);
                    });            
                });
            });

            $("#lblinstaladox").change(function () {
                $("#lblinstaladox option:selected").each(function () {
                    var lblinstaladox= $(this).val();
                    $.post("./ajax/selectTecnico.php", { lblinstaladox: lblinstaladox }, function(data){
                        $("#lbltecnico").html(data);
                    });            
                });
            });


            $('#hidden_visitadox').change(function(){
                
                if($(this).val()=="SI"){
                    $('.checkacuerdocomercial').removeClass('ocultar');
                }else{
                    $('.checkacuerdocomercial').addClass('ocultar');
                    $('#hidden_acuerdocomercialinst').val('NO');
                }
            });

            
            $('#desc3meses').change(function(){
                if($(this).prop('checked')){
                    $('#HidDesc3meses').val('SI');
                }else{
                    $('#HidDesc3meses').val('NO');
                }
            })
            
            $('#pagoAdelantado').change(function(){
                if($(this).prop('checked')){
                    $('#HidpagoAdelantado').val('SI');
                }else{
                    $('#HidpagoAdelantado').val('NO');
                }
            })

            $('#inci_tecnica').bootstrapToggle({
            on:'SI',
            off:'NO',
            onstyle:'success',
            offstyle:'danger'
            });

            $("#lblestadoventa").change(function () {
                var condiciones = $("#lblestadoventa").val();
                bloquear(condiciones);
            });

            $("#lblcategoria").change(function () {
                var categoria = $("#lblcategoria").val();
                $("#lblcat").val(categoria);
                bloquearxCategoria(categoria);
            });

            $("#lbltipodoc").change(function () {
                var tipodoc = $("#lbltipodoc").val();
                if(tipodoc=="DNI"){
                    $('#lbldocumento').attr('maxlength', 8);
                }else if(tipodoc=="RUC"){
                    $('#lbldocumento').attr('maxlength', 11);
                }else{
                    $('#lbldocumento').attr('maxlength', 12);
                }
            });
        </script>
        
        <script>
            $('#desc3meses,#pagoAdelantado').bootstrapToggle({
                on:'SI',
                off:'NO',
                onstyle:'success',
                offstyle:'danger'
            }); 
            
            $('.selectdistrito').select2({
                placeholder: 'Seleccione Distrito - Provincia',
                allowClear: true,
                language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {

                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectDistrito.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });
            
            $('.cbxtecnico').select2({
                placeholder: 'Seleccione',
                allowClear: true,
                language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {

                        return "Buscando..";
                    }
                }
            });
            
            $('.cbxtelecierre').select2({
                placeholder: 'Seleccione',
                allowClear: true,
                language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {

                        return "Buscando..";
                    }
                }
            });
            
            $('.selectgestor').select2({
                placeholder: 'Seleccione Gestor',
                allowClear: true,
                language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {

                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectGestor.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });
            
            $('#datemask').inputmask('dd/mm/yyyy', {'placeholder': 'dd/mm/yyyy'});
                                                               
                                                               
            $('#lblfecharecpciondoc').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1
            });
              $('#lblfechafacturacion').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1
            });
            //Money Euro
            $('[data-mask]').inputmask();
            //Date picker
            $('#fechainst').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1
            });
            //Date picker
            $('#horainst').timepicker({
                defaultTime:false,                                                                                    
                showInputs: true,
                 minuteStep: 1
            });
          
            $('#mesano').datepicker({
                autoclose: true,
                language: 'en',
                firstDay: 1, format: 'M-yyyy',
                viewMode: "years",
                minViewMode: "months",
                clearBtn:true,
                todayBtn: 'linked',
                todayHighlight:true
            });

            $('#lblfvencimiento').datepicker({
            autoclose: true,
            language: 'es',
            firstDay: 1
            });
        
            $('#lblfvisita').datepicker({
            autoclose: true,
            language: 'es',
            firstDay: 1
            });
            
            $('#lblhvisita').timepicker({
            defaultTime:false,                                                                                    
            showInputs: true,
            minuteStep: 1
            });
            
            $('#lblfrellamadaTC').datepicker({
                    language: 'es',
                    autoclose: true,
                    firstDay: 1,
                    startDate: new Date()
                });

            $('#lblhrellamadaTC').timepicker({
                    defaultTime:false,
                    showInputs: true,
                    minuteStep: 1
                })
            
            $('#logcambios').click(function () {
                refresh();
            }); 

            $('#logcontactados').click(function () {
                refreshTC();
            });
            
            function formatStateMuestra (state) {
              if (!state.id) {
                return state.text;
              }
              var $state;
              if(state.element.value==="Bajo"){
                $state = $('<span style="color:#fff">&nbsp;&nbsp;' + state.text + '</span>'); 
              }else if(state.element.value==="Minimo"){
                $state = $('<span style="color:#fff">&nbsp;&nbsp;' + state.text + '</span>'); 
              }else if(state.element.value==="Mediano"){
                $state = $('<span style="color:#555">&nbsp;&nbsp;' + state.text + '</span>'); 
              }else if(state.element.value==="Alto"){
                $state = $('<span style="color:#fff">&nbsp;&nbsp;' + state.text + '</span>'); 
              }else{
                $state = $('<span>&nbsp;&nbsp;' + state.text + '</span>');
             }
                
              return $state;
            };
            
            function formatState (state) {
                if (!state.id) {
                return state.text;
                }
                var $state;
                if(state.element.value==="Bajo"){
                    $state = $('<span><i class="fa fa-circle" style="color:#979797"></i>&nbsp;&nbsp;' + state.text + '</span>'); 
                }else if(state.element.value==="Minimo"){
                    $state = $('<span><i class="fa fa-circle" style="color:#42a941"></i>&nbsp;&nbsp;' + state.text + '</span>'); 
                }else if(state.element.value==="Mediano"){
                    $state = $('<span><i class="fa fa-circle" style="color:#f2ca0b"></i>&nbsp;&nbsp;' + state.text + '</span>'); 
                }else if(state.element.value==="Alto"){
                    $state = $('<span><i class="fa fa-circle" style="color:#ef273e"></i>&nbsp;&nbsp;' + state.text + '</span>'); 
                }else{
                    $state = $('<span>&nbsp;&nbsp;' + state.text + '</span>');
                }
                
                return $state;
            };
  
            $('.scoringselect').select2({
                  templateSelection: formatStateMuestra,
                  templateResult: formatState,
                  dropdownCssClass : 'no-search',
            }).on('change', function(){
                    if(this.value==="Bajo"){
                       $(this).next().find('.select2-selection').css({backgroundColor: '#979797'});
                       $(this).next().find('.select2-selection__arrow b').css({'border-color': '#fff transparent #fff transparent'});
                    }else if(this.value==="Minimo"){
                       $(this).next().find('.select2-selection').css({backgroundColor: '#42a941'});   
                       $(this).next().find('.select2-selection__arrow b').css({'border-color': '#fff transparent #fff transparent'});
                    }else if(this.value==="Mediano"){
                       $(this).next().find('.select2-selection').css({backgroundColor: '#f2ca0b'});
                       $(this).next().find('.select2-selection__arrow b').css({'border-color': '#555 transparent #555 transparent'}); 
                    }else if(this.value==="Alto"){
                       $(this).next().find('.select2-selection').css({backgroundColor: '#ef273e'});
                       $(this).next().find('.select2-selection__arrow b').css({'border-color': '#fff transparent #fff transparent'});
                    }else{
                        $(this).next().find('.select2-selection').css({backgroundColor: '#fff'});
                        $(this).next().find('.select2-selection__arrow b').css({'border-color': '#555 transparent #555 transparent'}); 
                    }
            }).trigger('change'); 
        </script>
        <!-- MOD PAGO -->
        <script>
            $('.step3').click(function (event) {
                    var idventa=$('#idVenta').val();
                    var tipopago='WEB';
                    var mediopago = $("#lblmediopago").val();
                    var correo=$("#lblcorreo").val();
                    var gestororigen='<?php echo $matriculausuario;?>';
                    var divLoading = $('#divLoadingBoton');
                    divLoading.show();
                    //Algunas variables por default de alertify
                    alertify.defaults.theme.ok = "btn btn-nuevo";
                    alertify.defaults.theme.cancel = "btn btn-danger";

                    if ($(this).is("[disabled]")) {
                        event.preventDefault();
                    } else {
                        var lastX,lastY;
                        alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', 'Por su seguridad, no guardaremos ningún registro después de esta operación', function(){ 
                            $('#slider').animate({
                                marginLeft: '-' + 100 + '%'}, 300, function () {
                                $('#slider').css('margin-left', '-' + 200 + '%');
                            });

                        $.ajax({
                            type: 'POST',
                            url: 'ajax/insertTransaccion.php',
                            data: "idventa=" + idventa + "&tipopago="+tipopago+"&mediopago="+mediopago+"&gestororigen="+gestororigen+"&correo="+correo,
                            dataType: "JSON",
                            success: function (r) {
                                if (r.resultado==1) {
                                     $("#ningunresultado3").html(r.mostrar);
                                     window.open(r.URL,'_blank');
                                     divLoading.hide();
                                } else if(r.resultado==2 || r.resultado==3){
                                     $("#ningunresultado3").html(r.mostrar);
                                     divLoading.hide();
                                } else if(r.resultado==4){
                                     $("#ningunresultado3").html(r.mostrar);
                                     divLoading.hide();
                                } else if(r.resultado==6){
                                     $("#ningunresultado3").html(r.mostrar);
                                     divLoading.hide();
                                }
                                
                                else {
                                    alertify.error("Fallo el server");
                                   
                                }
                                
                            }
                        });
                     }
                        , function(){ alertify.error('Cancel')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
                            lastX = window.scrollX;
                            lastY = window.scrollY;
                        },
                            'onfocus':function(){
                                window.scrollTo(lastX, lastY);
                            }  
                        }).show(); 
                    } // END ELSE
                
            });
            
            $('.step2').click(function () {
                
                var idventa=$('#idVenta').val();
                var tipopago='CORREO';
                var mediopago = $("#lblmediopago").val();
                var gestororigen='<?php echo $matriculausuario;?>';
                var divLoading = $('#divLoadingBoton');
                var correomostrar=$("#frmEditarVenta #lblcorreo").val();
                divLoading.show();
                
                //Algunas variables por default de alertify
                alertify.defaults.theme.ok = "btn btn-nuevo";
                alertify.defaults.theme.cancel = "btn btn-danger";

                var lastX,lastY;
                    alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', 'Por su seguridad, no guardaremos ningún registro después de esta operación. Desea enviar correo  a: <br><input name="lblcorreoenvio" class="form-control input-sm" id="lblcorreoenvio" value="'+ correomostrar+'" style="width: 100%;"/>', function(){ 
                        if (validaCorreo()) {
                            var lblcorreoenvio=$("#lblcorreoenvio").val();         
                            $('#slider').animate({
                                marginLeft: '-' + 100 + '%'}, 300, function () {
                                $('#slider').css('margin-left', '-' + 200 + '%');
                            });
                          
                                $.ajax({
                            type: 'POST',
                            url: 'ajax/insertTransaccion.php',
                            data: "idventa=" + idventa + "&tipopago="+tipopago+"&mediopago="+mediopago+"&gestororigen="+gestororigen+"&correo="+lblcorreoenvio,
                            dataType: "JSON",
                            success: function (r) {
                                if (r.resultado==1) {
                                     $("#ningunresultado3").html(r.mostrar);
                                     window.open(r.URL,'_blank');
                                     divLoading.hide();
                                } else if(r.resultado==2 || r.resultado==3){
                                     $("#ningunresultado3").html(r.mostrar);
                                     divLoading.hide();
                                }else if(r.resultado==4){
                                     $("#ningunresultado3").html(r.mostrar);
                                     divLoading.hide();
                                }else if(r.resultado==6){
                                     $("#ningunresultado3").html(r.mostrar);
                                     divLoading.hide();
                                }else {
                                    alertify.error("Fallo el server");
                                   
                                }
                                
                            }
                        });
    
                        } //END IF VALIDAR CORREO
                    }
                    , function(){ alertify.error('Cancel')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
                        lastX = window.scrollX;
                        lastY = window.scrollY;
                    },
                      'onfocus':function(){
                        window.scrollTo(lastX, lastY);
                      }  }).show(); 
            }); //END STEP2
            
            $('.regresarvtaonline').click(function () {
                $('#slider').animate({
                    marginLeft: 0}, 300);
            });
            
            $('.btnvisa').click(function () {
                $('#lblmediopago').val("VISA");
                
                $('#titulo').text("VISA ");
                $('#titulo2').text("| MODO DE PAGO");
                
                                $('#slider').animate({
                    marginLeft: '-' + 100 + '%'}, 300, function () {
                    $('#slider').css('margin-left', '-' + 100 + '%');
                });
                
            });
            
            $('.btnmastercard').click(function () {
                $('#lblmediopago').val("MASTERCARD");
                 $('#titulo').text("MASTERCARD ");
                 $('#titulo2').text("| MODO DE PAGO");
        
                                $('#slider').animate({
                    marginLeft: '-' + 100 + '%'}, 300, function () {
                    $('#slider').css('margin-left', '-' + 100 + '%');
                });
                
            });
            
            $('.btndinners').click(function () {
                $('#lblmediopago').val("DINNERS");
                
                $('#titulo').text("DINNERS ");
                $('#titulo2').text("| MODO DE PAGO");
                                $('#slider').animate({
                    marginLeft: '-' + 100 + '%'}, 300, function () {
                    $('#slider').css('margin-left', '-' + 100 + '%');
                });
                
            });
            
            $('.btnamex').click(function () {
                $('#lblmediopago').val("AMEX");
                
                $('#titulo').text("AMERICAN EXPRESS ");
                $('#titulo2').text("| MODO DE PAGO");
                                $('#slider').animate({
                    marginLeft: '-' + 100 + '%'}, 300, function () {
                    $('#slider').css('margin-left', '-' + 100 + '%');
                });
                
            });
            
            $('#btnrealizarpago').click(function(e){
                
                var gestororigen='<?php echo $matriculausuario;?>';
                
                $.ajax({
                   url: "ajax/selectListarMdpTransaccionxUser.php",
                   method: "POST",
                   data: {gestororigen:gestororigen},
                   success:function(data){
                       console.log(data);
                       data = JSON.parse(data);
                       if (data >= 5) {
                           Swal.fire({
                              type: 'warning',
                              title: '¡Advertencia!',
                              text: 'No puede realizar más de 5 transacciones por día',
                            })
                            $('.step3').attr("disabled", "disabled");
                       } 
                   }
                });
                
                $('#slider').css('margin-left', 0);
         
            });
        </script>
        <script>
            const contenedorNuevosDatos = document.querySelector('#tbdatos tbody');
            let arregloDatos = [];
        </script>

        <script>
            $(document).ready(function () {
                
                bloquear('<?php echo $estadoventa; ?>');
                //FUNCION PARA HABILITAR CAMPOS SEGUN ESTADO
                var estadoTelecierre = $('#lblestadotelecierre').val();
                var ultimagestion = $('#ultimagestion').val();
                
                if(ultimagestion=='DevolverLlamada' || ultimagestion=='ContactoConTerceros' || ultimagestion=='ProspectoAbierto'){
                    $('.rellamada').removeClass('ocultar');
                }
                
                //habilitar(estadoTelecierre);
                cargarnivel1();
                
                //SCORING
                $('#lblresultadoScoring').val($('#valresultadoScoring').val());
                cargardepartamento();                
            
                var lblcctc=$('#lblcctc').val();
                if(lblcctc==511 && $("#lblgestortc").val()==""){
                    $("#lblcctc option:selected").each(function () {
           
                        $.post("./ajax/selectGestorTC.php", { lblcctc: lblcctc}, function(data){
                            $("#lblgestortc").html(data);
                        });            
                    });
                }
                
                var EstadoVenta = $('#lblestadoventa').val();
                 console.log(EstadoVenta);
                 if(EstadoVenta=='AgendadaTEC'||EstadoVenta=='Instalada'||EstadoVenta=='NoDoc'||EstadoVenta=='DocEnvi'||EstadoVenta=='Incidencia'||EstadoVenta=='IncidenciaGestCorreo'||EstadoVenta=='IncidenciaGestValija'||EstadoVenta=='PorFacturar'||EstadoVenta=='Facturada'){
                    $('#lblestadotelecierre').prop('disabled', true);
                    
                 }
                    
                var alterClass = function () {
                    var ww = document.body.clientWidth;
                    if (ww < 767) {
                        $('body').removeClass('sidebar-collapse');
                    } else if (ww >= 768) {
                        $('body').addClass('sidebar-collapse');
                    }
                    ;
                };

                $(window).resize(function () {
                    alterClass();
                });
                //Fire it when the page first loads:
                alterClass();

                $('#slider').css('margin-left', '-' + 100 + '%');
                
                //CAMARA ARLO DOM
                const segmento = $('#lblsegmento').val();

                $('.divinformacioncamaraarlo').removeClass('ocultar');

                const eti_1=$('.eti_1').text();
                const eti_2=$('.eti_2').text();
                const eti_3=$('.eti_3').text();
                const eti_4=$('.eti_4').text();
                const eti_5=$('.eti_5').text();
                const eti_6=$('.eti_6').text();
                const eti_7=$('.eti_7').text();
                
                if(segmento=='RES'){
                    $('.eti_1').text(eti_1.replace('N1','ARLO'));
                    $('.eti_2').text(eti_2.replace('N1','ARLO'));
                    $('.eti_3').text(eti_3.replace('N1','ARLO'));
                    $('.eti_4').text(eti_4.replace('N1','ARLO'));
                    $('.eti_5').text(eti_5.replace('N1','ARLO'));
                    $('.eti_6').text(eti_6.replace('N1','ARLO'));
                    $('.eti_7').text(eti_7.replace('N1','ARLO'));
                }else{
                    $('.eti_1').text(eti_1.replace('ARLO','N1'));
                    $('.eti_2').text(eti_2.replace('ARLO','N1'));
                    $('.eti_3').text(eti_3.replace('ARLO','N1'));
                    $('.eti_4').text(eti_4.replace('ARLO','N1'));
                    $('.eti_5').text(eti_5.replace('ARLO','N1'));
                    $('.eti_6').text(eti_6.replace('ARLO','N1'));
                    $('.eti_7').text(eti_7.replace('ARLO','N1'));                   
                }
                
                $('#lbltipokittc').trigger("change");
                $('#lbltipocamarakit').val($('#valtipocamarakit').val());
                $('#VendidaCamaraExtraInterna').val($('#valVendidaCamaraExtraInterna').val());
                $('#VendidaCamaraExtraInterna').trigger("change");
                $('#VendidaCamaraExtraExterna').val($('#valVendidaCamaraExternaExtra').val());
                $('#VendidaCamaraExtraExterna').trigger("change");                
                
                                                                                   
            });
        </script>
        <!-- BTN GUARDAR EDITAR VENTA -->
        <script>

            $('#btnGuardarEditarVenta').click(function () {
                let idventa=window.location.search.substring(1).split('&')[0].split('=')[1];
                let lblidcliente = $('#lblidcliente').val();
                let catgventa=$('#lblcat').val();
                var lblestadoventa=$('#lblestadoventa').val();
                let lbl590=$('#mesano').val();
                let lblestadotelecierre=$('#lblestadoteleventa').val();
                let lbltipoventatc=$('#lbltipoventatc').val();
                let lblmovivonoventatc=$('#lblsubestado').val();
                let lblcctc=$('#lblcctc').val();
                let lblgestortc=$('#lblgestortc').val();
                let lbltipokittc=$('#lbltipokittc').val();
                let lblpreciokittc=$('#lblpreciokittc').val();
                let hiddenpreciokittc=$('#hiddenpreciokittc').val();
                let lbltotalextratc=$('#lbltotalextratc').val();
                let lblcantidadextratc=$('#lblcantidadextratc').val();
                let lblTotalCuotaMonitoreo=$('#lblTotalCuotaMonitoreo').val();
                let lblcantidadregalotc=$('#lblcantidadregalotc').val();
                let lblresumenventatc=$('#lblresumenventatc').val();
                let lblextraautorizadotc=$('#lblextraautorizadotc').val();
                let lblformadepagotc=$('#lblformadepagotc').val();
                let lblmesesautorizadostc=$('#lblmesesautorizadostc').val();
                let lblPAItc=$('#lblPAItc').val();
                let HidDesc3meses=$('#HidDesc3meses').val();
                let HidpagoAdelantado=$('#HidpagoAdelantado').val();
                let lblformapagocuota=$('#lblformapagocuota').val();
                let lblcomentariotc=$('#lblcomentariotc').val();
                let lblcomentariocancelacion=$('#lblcomentariocancelacion').val();
                let lblcompetencia=$('#lblcompetencia').val();
                let lblestadovisita=$('#lblestadovisita').val();
                let lblsco=$('#valresultadoScoring').val();
                var valcodigoOperacionScoring = $('#valcodigoOperacionScoring').val();
                let lblfrellamadaTC = $('#lblfrellamadaTC').val();
                let lblhrellamadaTC = $('#lblhrellamadaTC').val();
                let hidden_visitadox = $('#hidden_visitadox').val();
                let hidden_acuerdocomercialinst = $('#hidden_acuerdocomercialinst').val();
                let lblfechagestion = $('#lblfechagestion').val();
                let lblIdDocTC = $('#lblIdDocTC').val();
                let lbltipodoc = $('#lbltipodoc').val();
                let lbldocumento = $('#lbldocumento').val();
                //NUEVOS CAMPOS GENERADOS PARA ARLO
                var lbltipocamarakit=$('#lbltipocamarakit').val();
                var VendidaCamaraExtraInterna=$('#VendidaCamaraExtraInterna').val();
                var CantidadCamaraExtraInterna=$('#CantidadCamaraExtraInterna').val();
                var PrecioCamaraExtraInterna=$('#PrecioCamaraExtraInterna').val();
                var VendidaCamaraExtraExterna=$('#VendidaCamaraExtraExterna').val();
                var CantidadCamaraExtraExterna=$('#CantidadCamaraExtraExterna').val();
                var PrecioCamaraExtraExterna=$('#PrecioCamaraExtraExterna').val();
                var FechaTCFI=$('#FechaTCFI').val();
                //NUEVO DE ITERACCIONES
                var lblIteraccionAgenda = $('#lblIteraccionAgenda').val();                                
                var lbldistrito = $('#lbldistrito').val();
                let gestor='<?php echo $matriculausuario; ?>'; //Usuario que realiza el registro porque puede realizarlo por otro usuario
                let lbldc =$('#lbldc').val();
                //NUEVO DATOS DE GESTION
                var lblnivel1 = $('#lblnivel1 option:selected').val();
                var lblnivel2 = $('#lblnivel2').val();
                var lblvueltas = $('#lblvueltas').val();
                var lblfechaultimagestion = $('#lblfechaultimagestion').val();
                
                // AGENDA
                var instaladoXAgenda = $("#lblinstaladox").val();
                var tecnicoAgenda = $("#lbltecnico").val();
                var fechaAgenda = $("#fechainst").val();
                var horaAgenda = $("#horainst").val();
                var comentarioAgenda = $("#lblcomentarioagenda").val();
                var repercucionAgenda = $("#lblrepercucion").val();
                var lblidagenda = $('#lblidagenda').val();
                var lblinviable = $('#lblinviable').val();
                var lblcancelado = $('#lblcancelado').val();       
                var lblprospectoabierto = $('#lblprospectoabierto').val(); 
                var lblfechaprospectoabierto = $('#lblfechaprospectoabierto').val();        
                
                
                datos = {
                    array:'array2',
                    idventa,
                    lblidcliente,
                    catgventa,
                    lblestadoventa,
                    lbl590,
                    lblestadotelecierre,
                    lbltipoventatc,
                    lblmovivonoventatc,
                    lblcctc,
                    lblgestortc,
                    lbltipokittc,
                    lblpreciokittc,
                    hiddenpreciokittc,
                    lbltotalextratc,
                    lblcantidadextratc,
                    lblTotalCuotaMonitoreo,
                    lblcantidadregalotc,
                    lblresumenventatc,
                    lblextraautorizadotc,
                    lblformadepagotc,
                    lblmesesautorizadostc,
                    lblPAItc,
                    HidDesc3meses,
                    HidpagoAdelantado,
                    lblformapagocuota,
                    lblcomentariotc,
                    lblcomentariocancelacion,
                    lblcompetencia,
                    lblestadovisita,
                    lblsco,
                    lblfrellamadaTC,
                    lblhrellamadaTC,
                    hidden_visitadox,
                    hidden_acuerdocomercialinst,
                    gestor,
                    lbldc,
                    lblfechagestion,
                    lbltipodoc,
                    lbldocumento,
                    lblIdDocTC,
                    lbltipocamarakit,
                    VendidaCamaraExtraInterna,
                    CantidadCamaraExtraInterna,
                    PrecioCamaraExtraInterna,
                    VendidaCamaraExtraExterna,
                    CantidadCamaraExtraExterna,
                    PrecioCamaraExtraExterna,
                    FechaTCFI,
                    lblIteraccionAgenda,
                    lbldistrito,
                    valcodigoOperacionScoring,
                    lblnivel1,
                    lblnivel2,
                    lblvueltas,
                    lblfechaultimagestion,
                    instaladoXAgenda: instaladoXAgenda,
                    tecnicoAgenda: tecnicoAgenda,
                    fechaAgenda: fechaAgenda,
                    horaAgenda: horaAgenda,
                    comentarioAgenda: comentarioAgenda,
                    repercucionAgenda: repercucionAgenda,
                    lblidagenda,
                    lblinviable,
                    lblcancelado,
                    lblprospectoabierto : lblprospectoabierto,
                    lblfechaprospectoabierto: lblfechaprospectoabierto
                }
                
                console.log(datos);

            Swal.fire({
                title: '¿Deseas guardar los cambios generados?',
                html: '',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: `Gestión`,
                denyButtonText: `Información`,
                icon: 'info',
            }).then((result) => {
                //GESTION
                if (result.isConfirmed) {
                    datos.lbltipoaccion = 'gestion';
                    console.log(datos);
                    if (fechadiferencia()) {
                        console.log('Entra Gestion');
                        if (validarGestion(datos)) {
                            
                            $.ajax({
                                type: 'POST',
                                url: './Controller/ControllerTelecierre.php',
	                            data: {function: JSON.stringify(datos)},                                
                                dataType: "Json",
                                success: function(data) {
                                    console.log(data);
                                    if (data.respuesta == 'exito') {
                                        Swal.fire({
                                           title:'Modificado con exito!',
                                           text:'Podrás volver a realizar una modificación luego de 1 minuto',
                                           icon:'success',
                                           showCancelButton:false,
                                           confirmButtonColor:'',
                                           confirmButtonText:'OK',
                                           closeOnConfirm: false,
                                           allowOutsideClick: false                          
                                        }).then((result)=>{
                                            if(result.isConfirmed){
                                                window.location.reload();
                                            }
                                        });
                                        
                                        if (lblestadoventa == "PendienteData" || lblestadoventa == "PendienteAgenda") {
                                            enviarEncuesta();
                                        }
                                        
                                    } else if (data.respuesta == 'sincambios') {
                                        alertify.warning("No se ha realizado ninguna modificación");

                                    } else {
                                        alertify.error("Fallo el server");

                                    }
                                }
                            });
                            
                        }

                    } else {
                        Swal.fire('Debes esperar 1 minuto para realizar una nueva gestión', '', 'info')
                    }


                }
                //INFORMACION
                else if (result.isDenied) {
                    datos.lbltipoaccion = 'informacion';
                    console.log(datos);
                    if(datos.lblcctc==""){
                        Swal.fire('Por favor ingresar CC valida', '', 'warning');
                        return;
                    }
                    
                    if(datos.lblgestortc==""){
                        Swal.fire('Por favor ingresar Gestor Telecierre correcto', '', 'warning');
                        return;
                    }

                    if (datos.hidden_visitadox == '' || datos.hidden_visitadox == null) {
                        Swal.fire('¿Visitado?, seleccionar SI/NO', '', 'warning')
                        return;
                    }
                    if (datos.hidden_visitadox == 'SI') {
                        if (datos.hidden_acuerdocomercialinst == '' || datos.hidden_acuerdocomercialinst == null) {
                            Swal.fire('¿Acuerdo comercial?, seleccionar SI/NO', '', 'warning')
                            return;
                        }
                    }
                    
                    
                    $.ajax({
                        type: 'POST',
                        url: './Controller/ControllerTelecierre.php',
	                    data: {function: JSON.stringify(datos)},           
                        dataType: "Json",
                        success: function(data) {
                            console.log(data);
                            if (data.respuesta == 'exito') {

                                Swal.fire({
                                           title:'Información actualizada!',
                                           text:'',
                                           icon:'success',
                                           showCancelButton:false,
                                           confirmButtonColor:'',
                                           confirmButtonText:'OK',
                                           closeOnConfirm: false,
                                           allowOutsideClick: false                                      
                                    })
                                
                            } else if (data.respuesta == 'sincambios') {
                                alertify.warning("No se ha realizado ninguna modificación");
                            } else {
                                alertify.error("Fallo el server");

                            }
                        }
                    });

                } else {
                    return;
                }
            })

                

            })
        </script>
        <!-- FUNCIONES -->
        <script>
            function habilitar(condiciones){
                if (condiciones == ''){
                    $('#rowDevolverLlmada').hide();
                }
                if (condiciones == 'NoContactado' || condiciones == 'NoVendida'){
                    $('#rowDevolverLlmada').hide();
                    $('#lbllabelmotivo').removeClass('ocultar');
                    $('#lblmovivonoventatc').removeClass('ocultar');
                } 
                if(condiciones == 'PendienteRespuesta' || condiciones == 'DevolverLlamada'){
                    $('#lbllabelmotivo').removeClass('ocultar');
                    $('#lblmovivonoventatc').removeClass('ocultar');                
                    $('rowDevolverLlmada').show();
                }
            }
        
            function bloquear(condiciones){
                var idperfil = $("#IdPerfil").val();
                
                $('#tinviable').hide();
                $('#lblinviable').hide();
                $('#lblinviable').disabled=true;
                $('#tinviableespacio').hide();
                
                $('#tcancelado').hide();
                $('#lblcancelado').hide();
                $('#lblcancelado').disabled=true;
                $('#tcanceladoespacio').hide();
                        
                if (condiciones == "Inviable") {
                    $('#tinviable').show();
                    $('#lblinviable').show();
                    $('#lblinviable').show();
                    $('#lblinviable').disabled=false;
                    $('#tinviableespacio').show();
                
                }else if(condiciones=="Cancelado"){
                    $('#tcancelado').show();
                    $('#lblcancelado').show();
                    $('#lblcancelado').disabled=false;
                    $('#tcanceladoespacio').show();
                
                } 
                else {
                    $('#tinviable').hide();
                    $('#lblinviable').hide();
                    $('#lblinviable').disabled=true;
                    $('#tinviableespacio').hide();
                    
                    $('#tcancelado').hide();
                    $('#lblcancelado').hide();
                    $('#lblcancelado').disabled=true;
                    $('#tcanceladoespacio').hide();
                
                }
                
                if (idperfil == 12) {
                    //Scoring
                    //$('#lblresultadoScoring').prop('disabled', true);
                } else {
                    //Scoring
                    $('#lblresultadoScoring').prop('disabled', false);
                }                
                
    
            }

            function validaCorreo() {
                // Campos de texto
                
                if ($("#lblcorreoenvio").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#lblcorreoenvio").val())) {
                    alertify.warning("Por favor ingresar correo válido");
                    $("#lblcorreoenvio").val($("#frmEditarVenta #lblcorreo").val());
                    return false;
                }
                return true;
            }   
                                                                         
            function validaForm() {
                if ($("#frmEditarVenta #lblestadoteleventa").val() == "") {
                    alertify.warning("Por favor ingresar Estado Telecierre correspondiente");
                    $("#frmEditarVenta #lblestadoteleventa").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lblcctc").val() == "" || $("#frmEditarVenta #lblcctc").val() != '511') {
                    alertify.warning("Por favor ingresar CC valida");
                    $("#frmEditarVenta #lblcctc").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lblgestortc").val() == "" || $("#frmEditarVenta #lblgestortc").val() == "Seleccione" || $("#frmEditarVenta #lblgestortc").val() == "No se encontraron resultado") {
                    alertify.warning("Por favor ingresar Gestor Telecierre correcto");
                    $("#frmEditarVenta #lblgestortc").select2('open');
                    return false;
                }
                //NUEVA FUNCION SI SELECCIONA DNI/RUC
                if ($("#frmEditarVenta #lbltipodoc").val() == "RUC") {
                    if ($("#frmEditarVenta #lbldocumento").val().length!=11) {
                        alertify.warning("Por favor ingresar los 11 digitos del RUC");
                        $("#frmEditarVenta #lbldocumento").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lbldocumento").val().substr(0,2)==10 || $("#frmEditarVenta #lbldocumento").val().substr(0,2)==20) {
                        //SIN ACCIONES
                    }else{
                        alertify.warning("Por favor ingresar correctamente el RUC debe comenzar 10 o 20");
                        $("#frmEditarVenta #lbldocumento").focus();
                        return false;
                    }
                }
                if ($("#frmEditarVenta #lbltipodoc").val() == "DNI") {
                    if ($("#frmEditarVenta #lbldocumento").val().length!=8) {
                        alertify.warning("Por favor ingresar los 8 digitos del DNI");
                        $("#frmEditarVenta #lbldocumento").focus();
                        return false;
                    }
                }                        
                if ($("#frmEditarVenta #lbltipodoc").val() == "CE") {
                    if ($("#frmEditarVenta #lbldocumento").val().length==0) {
                        alertify.warning("Por favor ingresar CE");
                        $("#frmEditarVenta #lbldocumento").focus();
                        return false;
                    }
                }                                     
                if ($("#frmEditarVenta #lblestadoteleventa").val() == "Online" || $("#frmEditarVenta #lblestadoteleventa").val() == "Ficha" || $("#frmEditarVenta #lblestadoteleventa").val() == "NoVendida" ) {
                    if ($("#frmEditarVenta #lblcctc").val() == "" || $("#frmEditarVenta #lblcctc").val() != '511') {
                        alertify.warning("Por favor ingresar CC valida");
                        $("#frmEditarVenta #lblcctc").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                        return false;
                    }
                    if ($("#frmEditarVenta #lbltipoventatc").val() == "Seleccione" || $("#frmEditarVenta #lbltipoventatc").val() == "") {
                        alertify.warning("Por favor ingresar Tipo Venta TC");
                        $("#frmEditarVenta #lbltipoventatc").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblgestortc").val() == "" || $("#frmEditarVenta #lblgestortc").val() == "Seleccione" || $("#frmEditarVenta #lblgestortc").val() == "No se encontraron resultado") {
                        alertify.warning("Por favor ingresar Gestor Telecierre correcto");
                        $("#frmEditarVenta #lblgestortc").select2('open');
                        return false;
                    }
                    if ($("#frmEditarVenta #lbltipodoc").val() == "") {
                        alertify.warning("Por favor Seleccionar Tipo Documento");
                        $("#frmEditarVenta #lbltipodoc").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lbldocumento").val() == "") {
                        alertify.warning("Por favor ingresar Documento");
                        $("#frmEditarVenta #lbldocumento").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lbltipodoc").val() == "RUC") {
                        if ($("#frmEditarVenta #lbldocumento").val().length!=11) {
                            alertify.warning("Por favor ingresar los 11 digitos del RUC");
                            $("#frmEditarVenta #lbldocumento").focus();
                            return false;
                        }
                        if ($("#frmEditarVenta #lbldocumento").val().substr(0,2)==10 || $("#frmEditarVenta #lbldocumento").val().substr(0,2)==20) {
                            //SIN ACCIONES
                        }else{
                            alertify.warning("Por favor ingresar correctamente el RUC debe comenzar 10 o 20");
                            $("#frmEditarVenta #lbldocumento").focus();
                            return false;
                        }
                    }
                    if ($("#frmEditarVenta #lbltipodoc").val() == "DNI") {
                        if ($("#frmEditarVenta #lbldocumento").val().length!=8) {
                            alertify.warning("Por favor ingresar los 8 digitos del DNI");
                            $("#frmEditarVenta #lbldocumento").focus();
                            return false;
                        }
                    }                        
                    if ($("#frmEditarVenta #lblresultadoScoring").val() == "" || $("#frmEditarVenta #lblresultadoScoring").val() == null) {
                        alertify.warning("Por favor ingresar RESULTADO SCORING");
                        $("#frmEditarVenta #lblresultadoScoring").focus();
                        return false;
                    }                      
                    if ($("#frmEditarVenta #lblpreciokittc").val() == "") {
                        alertify.warning("Por favor ingresar Precio correcto");
                        $("#frmEditarVenta #lblpreciokittc").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lbltotalextratc").val() == "") {
                        alertify.warning("Por favor ingresar Total de extras. Si no tuviese colocar valor: 0");
                        $("#frmEditarVenta #lbltotalextratc").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblresumenventatc").val() == "") {
                        alertify.warning("Por favor ingresar Resumen correcto");
                        $("#frmEditarVenta #lblresumenventatc").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblextraautorizadotc").val() == "" || $("#frmEditarVenta #lblextraautorizadotc").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Extra Autorizado. Si no tuviene colocar valor");
                        $("#frmEditarVenta #lblextraautorizadotc").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblformadepagotc").val() == "") {
                        alertify.warning("Por favor ingresar Forma de Pago correspondiente");
                        $("#frmEditarVenta #lblformadepagotc").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #mesano").val() == "") {
                        alertify.warning("Por favor ingresar 590 correspondiente");
                        $("#frmEditarVenta #mesano").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblPAItc").val() == "" || $("#frmEditarVenta #lblPAItc").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar PAI correspondiente");
                        $("#frmEditarVenta #lblPAItc").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblestadoteleventa").val() == "NoVendida") {
                        if ($("#frmEditarVenta #lblmovivonoventatc").val() == "") {
                            alertify.warning("Por favor ingresar Motivo de no venta");
                            $("#frmEditarVenta #lblmovivonoventatc").focus();
                            return false;
                        }
                        if ($("#frmEditarVenta #lblmovivonoventatc").val() == "Competencia") {
                            if ($("#frmEditarVenta #lblcompetencia").val() == "") {
                                alertify.warning("Por favor ingresar Competencia correspondiente. Si selecciona : Otros, colocar en comentario el nombre de la empresa");
                                $("#frmEditarVenta #lblcompetencia").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                                return false;
                            }
                        }
                    }
                    
                    
                    //NUEVAS VALIDACIONES PARA CAMARA ALO
                    if($("#frmEditarVenta #lblestadoteleventa").val() == "Online"){
                        if ($("#frmEditarVenta #lbltipokittc").val() == 'Camara') {
                            if ($("#frmEditarVenta #lbltipocamarakit").val() == '' || $("#frmEditarVenta #lbltipocamarakit").val() == null) {
                                Swal.fire('¡Advertencia!','Seleccionar TIPO CAMARA KIT','warning');
                                $("#frmEditarVenta #lbltipocamarakit").focus();
                                return false;
                            }
                        }
                        var eti=$("#frmEditarVenta #lblsegmento").val()=='RES' ? 'ARLO' : 'N1';
                        if ($("#frmEditarVenta #VendidaCamaraExtraInterna").val() == '' || $("#frmEditarVenta #VendidaCamaraExtraInterna").val() == null) {
                            Swal.fire('¡Advertencia!','Seleccionar CÁMARA '+eti+' EXTRA INTERNA','warning');
                            $("#frmEditarVenta #VendidaCamaraExtraInterna").focus();
                            return false;
                        }
                        if ($("#frmEditarVenta #VendidaCamaraExtraInterna").val() == 'SI') {
                            if ($("#frmEditarVenta #CantidadCamaraExtraInterna").val() == '' ) {
                                Swal.fire('¡Advertencia!','Ingresar CANTIDAD '+eti+' EXTRA INTERNA','warning');
                                $("#frmEditarVenta #CantidadCamaraExtraInterna").focus();
                                return false;
                            }
                            if ($("#frmEditarVenta #PrecioCamaraExtraInterna").val() == '' ) {
                                Swal.fire('¡Advertencia!','Ingresar PRECIO '+eti+' EXTRA INTERNA','warning');
                                $("#frmEditarVenta #PrecioCamaraExtraInterna").focus();
                                return false;
                            }                        
                        }                 
                        if ($("#frmEditarVenta #VendidaCamaraExtraExterna").val() == '' || $("#frmEditarVenta #VendidaCamaraExtraExterna").val() == null) {
                            Swal.fire('¡Advertencia!','Seleccionar CÁMARA '+eti+' EXTRA EXTERNA','warning');
                            $("#frmEditarVenta #VendidaCamaraExtraExterna").focus();
                            return false;
                        }
                        if ($("#frmEditarVenta #VendidaCamaraExtraExterna").val() == 'SI') {
                            if ($("#frmEditarVenta #CantidadCamaraExtraExterna").val() == '' ) {
                                Swal.fire('¡Advertencia!','Ingresar CANTIDAD '+eti+' EXTRA EXTERNA','warning');
                                $("#frmEditarVenta #CantidadCamaraExtraExterna").focus();
                                return false;
                            }
                            if ($("#frmEditarVenta #PrecioCamaraExtraExterna").val() == '' ) {
                                Swal.fire('¡Advertencia!','Ingresar PRECIO '+eti+' EXTRA EXTERNA','warning');
                                $("#frmEditarVenta #PrecioCamaraExtraExterna").focus();
                                return false;
                            }                        
                        }                     
                
                    }                
               
                    if ($("#frmEditarVenta #lblestadoventa").val() == "AgendadaTEC") {
                    
                        if($("#frmEditarVenta #lblinstaladox").val() == "" || $("#frmEditarVenta #lbltecnico").val() == "" || $("#frmEditarVenta #fechainst").val() == "" || $("#frmEditarVenta #horainst").val() == "" || $("#frmEditarVenta #lblcomentarioagenda").val() == ""){ 
                            Swal.fire(
                                        'Elija una visita Técnica!',
                                          'Ingrese al boton Disponibilidad',
                                          'warning'
                                    )
                            return false;
                        }
                
                    }                    
                    
                    
                }
                if ($("#frmEditarVenta #lblestadoteleventa").val() == "NoContactado" || $("#frmEditarVenta #lblestadoteleventa").val() == "PendienteRespuesta" || $("#frmEditarVenta #lblestadoteleventa").val() == "ContactadoSinGestion") {
                    if ($("#frmEditarVenta #lblcomentariotc").val() == "") {
                        alertify.warning("Por favor ingresar Comentario");
                        $("#frmEditarVenta #lblcomentariotc").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblcctc").val() == ""||$("#frmEditarVenta #lblcctc").val() != '511') {
                        alertify.warning("Por favor ingresar CC valida");
                        $("#frmEditarVenta #lblcctc").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                        return false;
                    }
                }
                
                return true; 
            }
            
            function filter(__val__) {
                var preg = /^([0-9]+\.?[0-9]{0,2})$/;
                if (preg.test(__val__) === true) {
                    return true;
                } else {
                    return false;
                }

            }
            
            var calcDataTableHeight = function () {
                return $(window).height() * 65 / 100;
            };

            function filterFloat(evt, input) {
                // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
                var key = window.Event ? evt.which : evt.keyCode;
                var chark = String.fromCharCode(key);
                var tempValue = input.value + chark;
                if (key >= 48 && key <= 57) {
                    if (filter(tempValue) === false) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    if (key == 8 || key == 13 || key == 0) {
                        return true;
                    } else if (key == 46) {
                        if (filter(tempValue) === false) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
            }
        </script>
        <!-- FUNCIONES PARA TIPO KIT Y PRECIO KIT -->
        <script>
            function cargarPrecios(){
                
                const tipoKit = document.querySelector('#lbltipokittc');
                const selectPrecioKit = document.querySelector('#lblpreciokittc');
                const hiddenpreciokittc = document.querySelector('#hiddenpreciokittc');
                
                selectPrecioKit.options.length = 0
                
                $('#lblpreciokittc').append($('<option>').text('Seleccione').attr('value', ''));
                $('#lblpreciokittc').append($('<option>').text('0.00').attr('value', '0.00'));
                console.log(selectPrecioKit);
            if(tipoKit.value == 'Basico'){
                $('#lblpreciokittc').append($('<option>').text('199.00').attr('value', '199.00'));
                $('#lblpreciokittc').append($('<option>').text('299.00').attr('value', '299.00'));
                $('#lblpreciokittc').append($('<option>').text('399.00').attr('value', '399.00'));
                $('#lblpreciokittc').append($('<option>').text('499.00').attr('value', '499.00'));                
                $('#lblpreciokittc').append($('<option>').text('599.00').attr('value', '599.00'));
                $('#lblpreciokittc').append($('<option>').text('699.00').attr('value', '699.00'));
                $('#lblpreciokittc').append($('<option>').text('799.00').attr('value', '799.00'));
            }
            if(tipoKit.value == 'Premium'){
                $('#lblpreciokittc').append($('<option>').text('599.00').attr('value', '599.00'));
                $('#lblpreciokittc').append($('<option>').text('699.00').attr('value', '699.00'));
                $('#lblpreciokittc').append($('<option>').text('799.00').attr('value', '799.00'));
                $('#lblpreciokittc').append($('<option>').text('899.00').attr('value', '899.00')); 
                $('#lblpreciokittc').append($('<option>').text('999.00').attr('value', '999.00'));
                $('#lblpreciokittc').append($('<option>').text('1099.00').attr('value', '1099.00'));
                $('#lblpreciokittc').append($('<option>').text('1199.00').attr('value', '1199.00'));
            }
            if(tipoKit.value == 'ZeroVision'){
                $('#lblpreciokittc').append($('<option>').text('599.00').attr('value', '599.00'));
                $('#lblpreciokittc').append($('<option>').text('699.00').attr('value', '699.00'));
                $('#lblpreciokittc').append($('<option>').text('799.00').attr('value', '799.00'));
                $('#lblpreciokittc').append($('<option>').text('899.00').attr('value', '899.00')); 
                $('#lblpreciokittc').append($('<option>').text('999.00').attr('value', '999.00'));
                $('#lblpreciokittc').append($('<option>').text('1099.00').attr('value', '1099.00'));
                $('#lblpreciokittc').append($('<option>').text('1199.00').attr('value', '1199.00'));                
            }
            if(tipoKit.value == 'Camara'){
                $('#lblpreciokittc').append($('<option>').text('599.00').attr('value', '599.00'));
                $('#lblpreciokittc').append($('<option>').text('699.00').attr('value', '699.00'));
                $('#lblpreciokittc').append($('<option>').text('799.00').attr('value', '799.00'));
                $('#lblpreciokittc').append($('<option>').text('899.00').attr('value', '899.00')); 
                $('#lblpreciokittc').append($('<option>').text('999.00').attr('value', '999.00'));
                $('#lblpreciokittc').append($('<option>').text('1099.00').attr('value', '1099.00'));
                $('#lblpreciokittc').append($('<option>').text('1199.00').attr('value', '1199.00'));                
            }
            if(tipoKit.value == 'Basico PRO'){
                $('#lblpreciokittc').append($('<option>').text('199.00').attr('value', '199.00'));
                $('#lblpreciokittc').append($('<option>').text('299.00').attr('value', '299.00'));
                $('#lblpreciokittc').append($('<option>').text('399.00').attr('value', '399.00'));
                $('#lblpreciokittc').append($('<option>').text('499.00').attr('value', '499.00'));                
                $('#lblpreciokittc').append($('<option>').text('599.00').attr('value', '599.00'));
                $('#lblpreciokittc').append($('<option>').text('699.00').attr('value', '699.00'));
                $('#lblpreciokittc').append($('<option>').text('799.00').attr('value', '799.00'));
            }
            if(tipoKit.value == 'ZeroVision PRO'){
                $('#lblpreciokittc').append($('<option>').text('599.00').attr('value', '599.00'));
                $('#lblpreciokittc').append($('<option>').text('699.00').attr('value', '699.00'));
                $('#lblpreciokittc').append($('<option>').text('799.00').attr('value', '799.00'));
                $('#lblpreciokittc').append($('<option>').text('899.00').attr('value', '899.00')); 
                $('#lblpreciokittc').append($('<option>').text('999.00').attr('value', '999.00'));
                $('#lblpreciokittc').append($('<option>').text('1099.00').attr('value', '1099.00'));
                $('#lblpreciokittc').append($('<option>').text('1199.00').attr('value', '1199.00'));                
            }          
                
                
                selectPrecioKit.value = hiddenpreciokittc.value;
                /*
                console.log(selectPrecioKit.value);
                if(selectPrecioKit.value == null || selectPrecioKit.value == ''){
                    $('#lblpreciokittc').append($('<option>').text(hiddenpreciokittc.value).attr('value', hiddenpreciokittc.value));
                    selectPrecioKit.value = hiddenpreciokittc.value;
                }
                */
            }
        </script>
        <!-- MAQUETA CARRITA DE COMPRAS -->
    <script>
        function calcularPrecio(Producto, TipoPrecio, callback){
            
            fetch('ajax/selectListarExtras.php')
                .then(function(res) {
                    return res.json();
                })
                .then(function(datos) {
                    console.log(datos);
                    var catalogoPrecios = datos;
                    
                    let precioProducto;
                    let cuotaMensual;
                    
                    for (let [llave, valor] of Object.entries(datos)){
                        if(valor.IdItem == Producto.val()){
                            precioProducto = valor.Precio;
                            cuotaMensual = valor.CuotaMes;
                            break;
                        }
                    }
                    
                    //let precioProducto = catalogoPrecios[]['Precio'];
                    let precioProductoNeto;
                    
                    if(TipoPrecio.text() == 'CATALOGO'){
                        let descuento = 1.00;
                        precioProductoNeto = precioProducto*descuento;
                    } 
                    else if(TipoPrecio.text() == 'MEDIO') {
                        let descuento = 0.75;
                        precioProductoNeto = precioProducto*descuento;
                    } else {
                        let descuento = 0.50;
                        precioProductoNeto = precioProducto*descuento;
                    }
                    
                    callback(precioProductoNeto);
                    
                })
                .catch(function(error) {
                    console.log(error);
                })
            
        }
    </script>
    <!-- SCRIPT NUEVAS FUNCIONES -->
    <script>
        function datosHTML(){
            limpiarHTML(contenedorNuevosDatos);
            
            let resumen = '';
            let total = 0;
            let totalCuota = 0;
            let fila = 1;
            let cantidadExtras= 0;
            let cantidadRegalos=0;
            
            arregloDatos.forEach(datos => {
                console.log(datos);
                const {Producto, txtProducto, TipoPrecio, PrecioAdicional, CuotaMensual} =  datos;
                const row = document.createElement('tr');
                row.innerHTML = `
                                    <td></td>
                                    <td>${txtProducto}</td>
                                    <td>${TipoPrecio}</td>
                                    <td>${PrecioAdicional}</td>
                                    <td>${CuotaMensual}</td>
                                    <td><a href="#" class="borrar-producto" data-id="${Producto}" text-id="${txtProducto}">X</a></td>
                                `   
                contenedorNuevosDatos.appendChild(row);
                
                if (fila == arregloDatos.length){
                    resumen += txtProducto + '';
                }
                else {
                    resumen += txtProducto + ' + ';    
                }
                
                if (TipoPrecio === 'REGALO'){
                    cantidadRegalos++;
                } else {
                    cantidadExtras++;
                }
                
                console.log(PrecioAdicional);
                console.log(CuotaMensual);
                
                total += PrecioAdicional;
                totalCuota += CuotaMensual;
                fila++;
                
            })
                    
            $('#txtResumen').val(resumen);
            //
            $('#txtCantidadExtra').val(cantidadExtras);
            $('#txtCantidadRegalo').val(cantidadRegalos);
            //
            
            $('#txtTotal').val(total);
            $('#txtTotalCuota').val(totalCuota);
            
        }
        
        //Elimina los cursos del tbody
        function limpiarHTML(cont) {
            //forma recomendada
            while (cont.firstChild) {
                cont.removeChild(cont.firstChild);
            }
            
            $('#txtResumen').val('');
            $('#txtCantidad').val('');
            $('#txtTotal').val('');
        }
    </script>
    <!-- OTRAS -->
    <script>
        $('#btnModalProductos').on('click', function(){
            $('#modal_productos').modal('show');
        })
        
        $('#btnAgregar').on('click', function(e){
            e.preventDefault();
            
            const Producto = $('#cboProducto option:selected');
            const TipoPrecio = $('#cboTipoPrecio option:selected');
            const PrecioAdicional = $('#lblPrecioAdicional');
            
            if (Producto.val() != '' && TipoPrecio.val() != ''){
                //CONSULTA LA LISTA DE EXTRAS PARA TELEVENTA DE LA BASE DE DATOS. MEJORAR LA EFICIENCIA.
                fetch('ajax/selectListarExtras.php')
                    .then(function(res) {
                        return res.json();
                    })
                    .then(function(datos) {
                        console.log(datos);
                        //DECLARACION DE LAS VARIABLES NECESITADAS
                        let precioProducto;
                        let CuotaMensual;
                            
                        //BUSCA EN LOS DATOS TRAIDOS EL ITEM QUE SE AGREGO
                        for (let [llave, valor] of Object.entries(datos)){
                            if(valor.IdItem == Producto.val()){
                                textoProducto = valor.Item;
                                precioProducto = valor.Precio;
                                CuotaMensual = parseInt(valor.CuotaMes);
                                break;
                            }
                        }
                            
                        let precioProductoNeto;
                        
                        if(TipoPrecio.text() == 'CATALOGO'){
                            let descuento = 1.00;
                            precioProductoNeto = precioProducto*descuento;
                        } 
                        else if(TipoPrecio.text() == 'MEDIO') {
                            let descuento = 0.75;
                            precioProductoNeto = precioProducto*descuento;
                        } else if(TipoPrecio.text() == 'AUTORIZADO') {
                            let descuento = 0.50;
                            precioProductoNeto = precioProducto*descuento;
                        } else if(TipoPrecio.text() == 'REGALO'){
                            
                            if(Producto.text() === 'LLAVE INTELIGENTE INDIVIDUAL' || Producto.text() === 'PACK 3 LLAVES' || Producto.text() === 'MANDO' || Producto.text() === 'MAGNÉTICO SHOCK SENSOR' || Producto.text() ==='UPGRADE MAGNETICO PESADO'){
                                textoProducto = Producto.text() + ' (REGALO)';
                                txtTipoPrecio = 'REGALO'; 
                            } else {
                                Swal.fire(
                                    'Error',
                                    'El producto seleccionado no puede ser un regalo',
                                    'error'
                                )
                                return;
                            }
                            
                            let descuento = 0;
                            precioProductoNeto = precioProducto*descuento;
                        }
                            
                        //callback(precioProductoNeto);
                        //VERIFICA SI EL PRECIO ADICIONAL HA SIDO AGREGADO
                        if (PrecioAdicional.val() != ''){
                            precioProductoNeto = parseFloat(PrecioAdicional.val());
                            PrecioAdicional.val('');
                        } 
                            
                        //GENERAR CODIGO DE ITEM PARA LA TABLA
                        let totalFilas = arregloDatos.length +1;
                        let codigoProducto = Producto.val()+'-'+totalFilas;
                        
                        let data = {
                            Producto: codigoProducto,
                            txtProducto: textoProducto,
                            TipoPrecio: TipoPrecio.text(),
                            PrecioAdicional: precioProductoNeto,
                            CuotaMensual: CuotaMensual
                        }
                        
                        arregloDatos = [...arregloDatos, data];
                        console.log(arregloDatos);
                        datosHTML();
                        
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                
            } else {
                Swal.fire(
                    'Error',
                    'Debe seleccionar Extra y Tipo Precio',
                    'error'
                )
            }
            
            $('#cboProducto').val('').trigger('change');
            $('#cboTipoPrecio').val('').trigger('change');
        
        })
        
        $('#btnAgregarOtros').on('click', function(e){
            e.preventDefault();
            
            datosHTML();
        })
        
        $('#btnGenerar').on('click', function(e){
            e.preventDefault();
            
            let lbltipokittc = $('#lbltipokittc').val();
            
            if(lbltipokittc == ''){
                swal.fire(
                    'Debe seleccionar el tipo kit',
                    '',
                    'error'
                )
            } else {
                let resumen = lbltipokittc + ' + ' + $('#txtResumen').val();
                let txtCantidadExtra = $('#txtCantidadExtra').val();
                let txtTotal = $('#txtTotal').val();
                let txtTotalCuota = $('#txtTotalCuota').val();
                let txtCantidadRegalo = $('#txtCantidadRegalo').val();
                
                $('#lbltotalextratc').val(txtTotal);
                $('#lblcantidadextratc').val(txtCantidadExtra);
                $('#lblcantidadregalotc').val(txtCantidadRegalo);
                $('#lblresumenventatc').val(resumen);
                $('#lblTotalCuotaMonitoreo').val(txtTotalCuota);
                
                $('#modal_productos').modal('hide');
            }
            
            
        })
        
        $('#tbdatos').on("click", function(e){
            e.preventDefault();
            
            if (e.target.classList.contains('borrar-producto')) {
                const Producto = e.target.getAttribute('data-id');
                const txtProducto = e.target.getAttribute('text-id');
        
                //Elimina del arreglo de articulosCarrito por el data-id
                arregloDatos = arregloDatos.filter(datos => datos.Producto != Producto);
                
                datosHTML();
                
                /*
                $('#cboCC').append(`<option value="${cc}">${cctext}</option>`);
                
                $('#cboCC').prop('disabled', false);
                $('#objetivo').prop('disabled',false);
                $('#btnAgregar').removeClass('ocultar');
                $('#btnAgregar').prop('disabled', false);
                $('#insert').prop('disabled', true);
                
                */
            }
        })
        
        $('#lbltipokittc').on("change", function(){
            console.log($('#IdPerfil').val());
            if($('#IdPerfil').val() == 12){
                cargarPrecios();
            }
            //NUEVOS CAMPOS PARA CAMARA ARLO
                const tipokit=this.value;
                const tipocamarakit = document.getElementById("lbltipocamarakit");
                limpiarDatos(tipocamarakit)
                if(tipokit=='Camara'){
                    let arraglotipocamarakit = ['Camara Interna N1','Camara Interna Arlo', 'Camara Externa Arlo'];
                    cargarDatosKit(tipocamarakit, arraglotipocamarakit);                    
                    $('.camaraarlo').removeClass('ocultar');
                }else{
                    $('.camaraarlo').addClass('ocultar');
                }            
        })
        
            function limpiarDatos(select){
                while(select.children.length > 1){
                    select.lastChild.remove();
                }
            }
            function cargarDatosKit(tipokit, arragloKit){
                for (value in arragloKit) {
                    var option = document.createElement("option");
                    option.value = arragloKit[value];
                    option.text = arragloKit[value];
                    tipokit.add(option);
                }
            }            
        
    </script>
        <!-- SCRIPT DE QSERVUS -->
    <script>
            function enviarEncuesta(){
                var lblcorreo=$('#lblcorreo').val();
                var lblnombcliente=$('#lblnombcliente').val();
                var lblncliente=$('#lblncliente').val();
                var lblmovil=$('#lblmovil').val();
                var lblfijo=$('#lblfijo').val();
                                
                var lblgestortc = $('#lblgestortc').val();
                
                var lblasignado=$('#lblasignado').val();
                var lblcctc = $('#lblcctc').val();
                var lblsegmento=$('#lblsegmento').val();
                var lblnprospecto=$('#lblnprospecto').val();
                var lblestadoventa=$('#lblestadoventa').val();
                var fecha_visita=$('#lblfvisita').val();
                var origen=$('#lblorigen').val();

                data =  {
                      "campaign_id":309815,
                      "survey_id":337000,
                      "respondent_email": lblcorreo,
                      "respondent_name": lblnombcliente,
                      "respondent_phone": lblmovil,
                      "respondent_expiration_days": 10,
                      "telefono_2": lblfijo, 
                      "matricula": lblgestortc,
                      "asignado por": lblasignado,
                      "dc": lblcctc,
                      "estado": lblestadoventa,
                      "segmento": lblsegmento,
                      "n_prospecto": lblnprospecto,
                      "fecha_visita": fecha_visita,
                      "origen": origen,
                      "tipo_canal": "Telecierre"
                }


                console.log(data);

                fetch('https://qservus.redcalidad.com/api/addrespondent/', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Authorization': 'Token 69091bedd687e3b2da71f0d804df3853242a493c'
                        },
                        body: JSON.stringify(data),
                    })
                    .then(response => response.json())
                    .then(data => {
                      console.log('Success:', data);
                    })
                    .catch((error) => {
                      console.error('Error:', error);
                    });
        
            }
        </script>
    <script>
            $('#lblsegmento').on('change', function(){
                //console.log($('#lblsegmento').val());
                //CAMBIO DE SEGMENTO
               $('#lblresultadoScoring').val("");
               $('#valcodigoOperacionScoring').val("");
               $('#lbltitularscoring').val("");
               $('#lbldocumentoscoring').val("");
                
                const segmento=this.value;
                const eti_1=$('.eti_1').text();
                const eti_2=$('.eti_2').text();
                const eti_3=$('.eti_3').text();
                const eti_4=$('.eti_4').text();
                const eti_5=$('.eti_5').text();
                const eti_6=$('.eti_6').text();
                const eti_7=$('.eti_7').text();                

                $('.divinformacioncamaraarlo').removeClass('ocultar');
                if(segmento=='RES'){
                    $('.eti_1').text(eti_1.replace('N1','ARLO'));
                    $('.eti_2').text(eti_2.replace('N1','ARLO'));
                    $('.eti_3').text(eti_3.replace('N1','ARLO'));
                    $('.eti_4').text(eti_4.replace('N1','ARLO'));
                    $('.eti_5').text(eti_5.replace('N1','ARLO'));
                    $('.eti_6').text(eti_6.replace('N1','ARLO'));
                    $('.eti_7').text(eti_7.replace('N1','ARLO'));
                    
                }else{
                    
                    $('.eti_1').text(eti_1.replace('ARLO','N1'));
                    $('.eti_2').text(eti_2.replace('ARLO','N1'));
                    $('.eti_3').text(eti_3.replace('ARLO','N1'));
                    $('.eti_4').text(eti_4.replace('ARLO','N1'));
                    $('.eti_5').text(eti_5.replace('ARLO','N1'));
                    $('.eti_6').text(eti_6.replace('ARLO','N1'));
                    $('.eti_7').text(eti_7.replace('ARLO','N1'));                   
                }
            })
            $('#VendidaCamaraExtraInterna').on('change', function(){
                const VendidaCamaraExtraInterna=this.value;
                if(VendidaCamaraExtraInterna=='SI'){
                    $('.camaraarlointerna').removeClass('ocultar');
                }else{
                    $('#CantidadCamaraExtraInterna').val('');
                    $('#PrecioCamaraExtraInterna').val('');
                    $('.camaraarlointerna').addClass('ocultar');
                }
                
            });
            $('#VendidaCamaraExtraExterna').on('change', function(){
                //console.log($('#lblsegmento').val());
                const VendidaCamaraExtraExterna=this.value;
                if(VendidaCamaraExtraExterna=='SI'){
                    $('.camaraarloexterna').removeClass('ocultar');
                }else{
                    $('#CantidadCamaraExtraExterna').val('');
                    $('#PrecioCamaraExtraExterna').val('');
                    $('.camaraarloexterna').addClass('ocultar');
                }
            });             
        </script>
     <!-- SCORING -->
    <script>
        function cargardepartamento() {
            $('#TipoDocumento').val("1");
            var provincia = $("#Departamental");
            $.ajax({
                url: './ajax/selectDepartamental.php',
                type: 'POST',
                dataType: 'json',
                beforeSend: function() {
                    provincia.prop('disabled', true);

                },
                success: function(r) {
                    provincia.prop('disabled', false);

                    // Limpiamos el select de Provincia
                    provincia.find('option').remove();
                    provincia.append('<option value="">Seleccione</option>');

                    $(r).each(function(i, v) { // indice, valor
                        provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                    })
                    $("#Departamental option[value='15']").attr("selected", true);
                    $("#Departamental option:selected").each(function() {
                        var Provincial = $(this).val();
                        var datos = {
                            Provincial: Provincial
                        };
                        var provincia = $("#Provincial");
                        var distrito = $("#Distrital");
                        $.ajax({
                            data: datos,
                            url: './ajax/selectProvincial.php',
                            type: 'POST',
                            dataType: 'json',
                            beforeSend: function() {
                                //provincia.prop('disabled', true);
                                //distrito.prop('disabled', true);
                            },
                            success: function(r) {
                                provincia.prop('disabled', false);
                                distrito.prop('disabled', false);

                                // Limpiamos el select de Provincia
                                provincia.find('option').remove();
                                provincia.append('<option value="">Seleccione</option>');
                                // Limpiamos el select de Distrito
                                distrito.find('option').remove();
                                distrito.append('<option value="">Seleccione</option>');

                                $(r).each(function(i, v) { // indice, valor
                                    provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                                })
                                $("#Provincial option[value='128']").attr("selected", true);
                                $("#Provincial option:selected").each(function() {
                                    var Provincial = $(this).val();
                                    var datos = {
                                        Provincial: Provincial
                                    };
                                    var provincia = $("#Distrital");
                                    $.ajax({
                                        data: datos,
                                        url: './ajax/selectDistrital.php',
                                        type: 'POST',
                                        dataType: 'json',
                                        beforeSend: function() {
                                            //provincia.prop('disabled', true);
                                        },
                                        success: function(r) {
                                            provincia.prop('disabled', false);

                                            // Limpiamos el select
                                            provincia.find('option').remove();
                                            provincia.append('<option value="">Seleccione</option>');

                                            $(r).each(function(i, v) { // indice, valor
                                                provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                                            })
                                            provincia.trigger('change');

                                            provincia.prop('disabled', false);
                                        },
                                        error: function() {
                                            //alert('Ocurrio un error en el servidor ..');
                                            provincia.find('option').remove();
                                            provincia.append('<option value="">Seleccione</option>');
                                            provincia.prop('disabled', false);
                                        }
                                    });

                                });
                                provincia.prop('disabled', false);
                                distrito.prop('disabled', false);
                            },
                            error: function() {
                                //alert('Ocurrio un error en el servidor ..');
                                provincia.prop('disabled', false);
                                distrito.prop('disabled', false);
                            }
                        });

                    });
                    //provincia.trigger('change');


                    provincia.prop('disabled', false);

                },
                error: function() {
                    //alert('Ocurrio un error en el servidor ..');
                    provincia.prop('disabled', false);
                }
            });

        }
                    function validaFormScoring(){
                              if ($("#frmEditarVentaScoring #TipoDocumento").val() == "") {
                           alertify.warning("Por favor ingresar Tipo de Documento");
                           $("#frmEditarVentaScoring #lbldireccion").focus();
                           return false;
                        }
                                              if ($("#frmEditarVentaScoring #Documento").val() == "") {
                           alertify.warning("Por favor ingresar Número de Documento");
                           $("#frmEditarVentaScoring #Documento").focus();
                           return false;
                        }
                        //NUEVA FUNCION SI SELECCIONA DNI/RUC
                    if ($("#frmEditarVentaScoring #TipoDocumento").val() == "6") {
                            if ($("#frmEditarVentaScoring #Documento").val().length!=11) {
                                
                               alertify.warning("Por favor ingresar los 11 digitos del RUC");
                               $("#frmEditarVentaScoring #Documento").focus();
                               return false;
                            }
                            
                            if ($("#frmEditarVentaScoring #Documento").val().substr(0,2)==10 || $("#frmEditarVentaScoring #Documento").val().substr(0,2)==20 || $("#frmEditarVentaScoring #Documento").val().substr(0,2)==15 || $("#frmEditarVentaScoring #Documento").val().substr(0,2)==17) {
                              
                            }else{
                                 alertify.warning("Por favor ingresar correctamente el RUC debe comenzar 10 o 20");
                               $("#frmEditarVentaScoring #Documento").focus();
                               return false;
                            }
                            
                            
                        }
                    if ($("#frmEditarVentaScoring #TipoDocumento").val() == "1") {
                            if ($("#frmEditarVentaScoring #Documento").val().length!=8) {
                               alertify.warning("Por favor ingresar los 8 digitos del DNI");
                               $("#frmEditarVentaScoring #Documento").focus();
                               return false;
                            }
                        }                        
                    if ($("#frmEditarVentaScoring #TipoDocumento").val() == "3") {
                            if ($("#frmEditarVentaScoring #Documento").val().length==0) {
                               alertify.warning("Por favor ingresar CE");
                               $("#frmEditarVentaScoring #Documento").focus();
                               return false;
                            }
                        }
                                      if ($("#frmEditarVentaScoring #Departamental").val() == "") {
                      alertify.warning("Por favor ingresar Departamento correspondiente");
                      $("#frmEditarVentaScoring #Departamental").focus();
                      return false;
                  }
                                    if ($("#frmEditarVentaScoring #Provincial").val() == "") {
                      alertify.warning("Por favor ingresar Pronvincia correspondiente");
                      $("#frmEditarVentaScoring #Provincial").focus();
                      return false;
                  }
                                    if ($("#frmEditarVentaScoring #Distrital").val() == "") {
                      alertify.warning("Por favor ingresar Distrito correspondiente");
                      $("#frmEditarVentaScoring #Distrital").focus();
                      return false;
                  }
                                    if ($("#frmEditarVentaScoring #Segmento").val() == "") {
                      alertify.warning("Por favor seleccionar Segmento correspondiente");
                      $("#frmEditarVentaScoring #Segmento").focus();
                      return false;
                  }                       
                      
                  return true;
    }         
        $("#Departamental").change(function() {
            $("#Departamental option:selected").each(function() {
                var Provincial = $(this).val();
                var datos = {
                    Provincial: Provincial
                };
                var provincia = $("#Provincial");
                var distrito = $("#Distrital");
                $.ajax({
                    data: datos,
                    url: './ajax/selectProvincial.php',
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function() {
                        //provincia.prop('disabled', true);
                        //distrito.prop('disabled', true);
                    },
                    success: function(r) {
                        provincia.prop('disabled', false);
                        distrito.prop('disabled', false);

                        // Limpiamos el select de Provincia
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');
                        // Limpiamos el select de Distrito
                        distrito.find('option').remove();
                        distrito.append('<option value="">Seleccione</option>');

                        $(r).each(function(i, v) { // indice, valor
                            provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                        })

                        provincia.prop('disabled', false);
                        distrito.prop('disabled', false);
                    },
                    error: function() {
                        //alert('Ocurrio un error en el servidor ..');
                        provincia.prop('disabled', false);
                        distrito.prop('disabled', false);
                    }
                });

            });
        });

        $("#Provincial").change(function() {
            $("#Provincial option:selected").each(function() {
                var Provincial = $(this).val();
                var datos = {
                    Provincial: Provincial
                };
                var provincia = $("#Distrital");
                $.ajax({
                    data: datos,
                    url: './ajax/selectDistrital.php',
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function() {
                        //provincia.prop('disabled', true);
                    },
                    success: function(r) {
                        provincia.prop('disabled', false);

                        // Limpiamos el select
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');

                        $(r).each(function(i, v) { // indice, valor
                            provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                        })

                        provincia.prop('disabled', false);
                    },
                    error: function() {
                        //alert('Ocurrio un error en el servidor ..');
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');
                        provincia.prop('disabled', false);
                    }
                });

            });
        });

        //Validaciones
        //nombres apellido_p apellido_m
        $("#nombres").bind('keypress', function(event) {
            var regex = new RegExp("^[a-zA-Z ]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
        });

        $("#apellido_p").bind('keypress', function(event) {
            var regex = new RegExp("^[a-zA-Z ]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
        });
        $("#apellido_m").bind('keypress', function(event) {
            var regex = new RegExp("^[a-zA-Z ]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }

        });    
            $("#btnModalconsultascoring").click(function(event) {
                  const modalsegmento=$("#Segmento");
               $("#lblsegmento option:selected").each(function () {
                    var segmento = $(this).val();
                      modalsegmento.val(segmento);
                      modalsegmento.trigger('change');
                    });
        });
        $('#btnScoring').on('click', function() {
            var divLoading = $('#divLoading');
            $('#btnScoring').prop('disabled', true);

            divLoading.show();
            var idventa = $('#idVenta').val();
            var matriculausuario = $('#matriculausuario').val();
            var nombreusuario = $('#nombreusuario').val();
            var TipoDocumento = $('#TipoDocumento').val();
            var Documento = $('#Documento').val();
            var Departamental = $("#Departamental option:selected").text();
            var Provincial = $("#Provincial option:selected").text();
            var Distrital = $("#Distrital option:selected").text();
            var Ubigeo = $("#Distrital").val();
            var Segmento=$("#Segmento option:selected").val();
            var Area = 'TELECIERRE';
            var valPrecioBomba="";

            var datos = {
                matriculausuario: matriculausuario,
                nombreusuario: nombreusuario,
                TipoDocumento: TipoDocumento,
                Documento: Documento,
                Departamental: Departamental,
                Provincial: Provincial,
                Distrital: Distrital,
                Ubigeo: Ubigeo,
                idventa: idventa,
                Segmento:Segmento,
                Area: Area
            }
            console.log(datos);

            if (validaFormScoring()) {
                $.ajax({
                    type: "Post",
                    data: datos,
                    url: "ajax/funciones/soap2_tctv.php",
                    dataType: "Json",
                    success: function(data) {
                        console.log(data);

                        if (data.tipo == 'exito') {
                            $('#FechaConsulta').html(data.fecha);
                            var resultado = data.datos;
                            //var resultadooperacion=data.NodoAccion;
                            var resultadooperacion = resultado.respuestaSVC11Type.GrupoCampos.Campo[1].Valor;

                            //$('.TextoAccion').html(resultadooperacion);
                            if (resultadooperacion == "Generar Visita") {
                                $('.bg-visita').show();
                                $('.bg-televenta').hide();
                                $('.bg-gestion').hide();
                            } else if (resultadooperacion == "Pasar a base de datos-48 horas" || resultadooperacion == "Pasar a Televenta") {
                                $('.bg-visita').hide();
                                $('.bg-televenta').show();
                                $('.bg-gestion').hide();
                            } else {
                                $('.bg-visita').hide();
                                $('.bg-televenta').hide();
                                $('.bg-gestion').show();
                            }
                            $('#Riesgo').html(resultado.respuestaSVC11Type.Scores.Score.Riesgo + ' Riesgo');
                            if (resultado.respuestaSVC11Type.Integrante.TipoDocumento == 1) {
                                $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno + ' ' + resultado.respuestaSVC11Type.Integrante.ApellidoMaterno + ' ' + resultado.respuestaSVC11Type.Integrante.Nombres);
                                $('#lbltitularscoring').val(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno + ' ' + resultado.respuestaSVC11Type.Integrante.ApellidoMaterno + ' ' + resultado.respuestaSVC11Type.Integrante.Nombres);
                                $('#TDocumento').html("DNI:");
                            } else if (resultado.respuestaSVC11Type.Integrante.TipoDocumento == 6) {

                                if (resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0, 2) == 10 || resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0, 2) == 15 || resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0, 2) == 17) {
                                    $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno + ' ' + resultado.respuestaSVC11Type.Integrante.ApellidoMaterno + ' ' + resultado.respuestaSVC11Type.Integrante.Nombres);
                                
                                    $('#lbltitularscoring').val(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno + ' ' + resultado.respuestaSVC11Type.Integrante.ApellidoMaterno + ' ' + resultado.respuestaSVC11Type.Integrante.Nombres);
                                } else {
                                    $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.RazonSocial);
                                    $('#lbltitularscoring').val(resultado.respuestaSVC11Type.Integrante.RazonSocial);
                                }
                                $('#TDocumento').html("RUC:");
                            } else {
                                $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno + ' ' + resultado.respuestaSVC11Type.Integrante.ApellidoMaterno + ' ' + resultado.respuestaSVC11Type.Integrante.Nombres);
                                $('#TDocumento').html("CE:");
                                
                                //NUEVO TV 2022.04.22
                                $('#lbltitularscoring').val(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno + ' ' + resultado.respuestaSVC11Type.Integrante.ApellidoMaterno + ' ' + resultado.respuestaSVC11Type.Integrante.Nombres);
                            }
                                
                                
                            $('#NumeroDocumento').html(resultado.respuestaSVC11Type.Integrante.NumeroDocumento);
                            
                            //MOSTRAR EN LA VISTA
                            $('#lbldocumentoscoring').val(resultado.respuestaSVC11Type.Integrante.NumeroDocumento);
                            
                            //resultadooperacion=data.NodoAccion;
                            $('.TextoAccion').html(resultadooperacion); 
                            /*
                            if(tipoventa=="RE" && valPrecioBomba=="NO"){
                                $('.TextoAccion').html('Oferta RE');
                            }else{
                                $('.TextoAccion').html(resultadooperacion);   
                            } 
                            */
                            $('#Valor').html(resultado.respuestaSVC11Type.Scores.Score.Valor);
                            
                            console.log(resultadooperacion);
                            if(resultadooperacion=="TC Oferta Extraordinaria"){
                                $('#lblresultadoScoring').val("OfertaExtraordinaria");
                                $('#valresultadoScoring').val("OfertaExtraordinaria");
                            }else if(resultadooperacion=="TC Super Oferta"){
                                $('#lblresultadoScoring').val("SuperOferta");
                                $('#valresultadoScoring').val("SuperOferta");
                            }else if(resultadooperacion=="TC Oferta"){
                                $('#lblresultadoScoring').val("Oferta");
                                $('#valresultadoScoring').val("Oferta");
                            }else if(resultadooperacion=="TC Oferta Especial"){
                               $('#lblresultadoScoring').val("OfertaEspecial");
                               $('#valresultadoScoring').val("OfertaEspecial");
                            }else{
                                $('#lblresultadoScoring').val("");
                                $('#valresultadoScoring').val("");
                                $('#lbldocumentoscoring').val("");
                                $('#lbltitularscoring').val("");
                            }
                            $('#lblresultadoScoring').trigger('change');
                            $('#valcodigoOperacionScoring').val(resultado.respuestaSVC11Type.Header.NumeroOperacion);
                            
                            divLoading.hide();

                            //$('#ResultadoEquifax').show();
                            //$('#ResultadoEquifax').hide();
                            //$('#ResultadoEquifax').addClass('ocultar');
                            $('#ResultadoEquifax').removeClass('ocultar');                            
                            $('#TipoDocumento').prop('disabled', true);
                            $('#Documento').prop('disabled', true);
                            $("#Departamental").prop('disabled', true);
                            $("#Provincial").prop('disabled', true);
                            $("#Distrital").prop('disabled', true);
                            $("#Segmento").prop('disabled', true);
                            $('#btnScoring').hide();
                            $('#btnScoring').prop('disabled', false);
                            $('#btnNuevaScoring').show();
                        } else {
                            divLoading.hide();
                            alert(data.mensaje);
                            $('#btnScoring').show();
                            $('#btnScoring').prop('disabled', false);
                            $('#btnNuevaScoring').hide();
                        }



                    }
                })

            } else {
                divLoading.hide();
                $('#btnScoring').prop('disabled', false);
            }

        });

        $('#btnNuevaScoring').on('click', function() {
            //$('#ResultadoEquifax').hide();
            $('#ResultadoEquifax').addClass('ocultar');
            //$('#ResultadoEquifax').removeClass('ocultar');

            
            $('#TipoDocumento').prop('disabled', false);
            $('#Documento').prop('disabled', false);
            $("#Departamental").prop('disabled', false);
            $("#Provincial").prop('disabled', false);
            $("#Distrital").prop('disabled', false);
            $('#btnNuevaScoring').hide();
            $('#btnScoring').show();
            $('#btnScoring').prop('disabled', false);

            $('#TipoDocumento').val("1");
            $('#Documento').val("");
            $("#Departamental").val("");
            $("#Provincial").find('option').remove();
            $("#Provincial").append('<option value="">Seleccione</option>');
            $("#Distrital").find('option').remove();
            $("#Distrital").append('<option value="">Seleccione</option>');
            cargardepartamento();

        });

        $('#modal-logdni').on('shown.bs.modal', function() {
            var divLoading = $('#divLoading');
            $('#logconsultadoc').prop('disabled', true);
            divLoading.show();
            const contenedor = document.querySelector('#tblVentas tbody');
            while (contenedor.firstChild) {
                contenedor.removeChild(contenedor.firstChild);
            }

            var idventa = $('#idVenta').val();
            const lblsegmento=$('#lblsegmento option:selected').val();
            var datos = {
                idventa: idventa,
                lblsegmento:lblsegmento
            }
            console.log(datos);
            $.ajax({
                type: "Post",
                data: datos,
                url: "ajax/findDataConsultaScoringTC.php",
                dataType: "Json",
                success: function(data) {
                    console.log(data);
                    divLoading.hide();
                    $('#tblVentas').show();
                    if (data.length > 0) {

                        for (let [llave, valor] of Object.entries(data)) {
                            var TipoDoc;
                            var Nombre = "";
                            if (valor.TipoDocumento == 1) {
                                TipoDoc = "DNI";
                                Nombre = valor.Nombres + " " + valor.ApellidoPaterno + " " + valor.ApellidoMaterno;
                            } else if (valor.TipoDocumento == 6) {
                                TipoDoc = "RUC";
                                Nombre = valor.RazonSocial;
                            } else {
                                TipoDoc = "CE";
                                Nombre = valor.Nombres + " " + valor.ApellidoPaterno + " " + valor.ApellidoMaterno;
                            }
                            const row = document.createElement('tr');
                            row.innerHTML = `   <td class="tblBody text-center"><button type="button" class="btn btn-nuevo btnSeleccionar" id="${valor.Accion+"-"+valor.NumeroOperacion+"-"+valor.Dentromes+"-"+valor.NumeroDocumento+"-"+Nombre}">Seleccionar</button></td>
                                                            <td class="tblBody text-center">${valor.FechaHoraReg}</td> 
                                                            <td class="tblBody text-center">${TipoDoc}</td> 
                                                            <td class="tblBody text-center">${valor.NumeroDocumento}</td>
                                                            <td class="tblBody text-center">${Nombre}</td>
                                                            
                                                        `
                            //Agrega el HTML del carrito en el tbody 
                            contenedor.appendChild(row);
                        }
                        //Desbloqueo del Boton
                        $('#logconsultadoc').prop('disabled', false);
                        $('.btnSeleccionar').on('click', function() {
                            var cadena = $(this).attr("id");
                            var separador = "-", // hay un "-"
                                arregloDeSubCadenas = cadena.split(separador);
                            var Accion = arregloDeSubCadenas[0];
                            var NumeroOperacion = arregloDeSubCadenas[1];
                            var Dentromes = arregloDeSubCadenas[2];
                            var NumeroDocumento = arregloDeSubCadenas[3];
                            var Titular = arregloDeSubCadenas[4];
                            if (Dentromes == "NO") {
                                Swal.fire(
                                    '¡Scoring Desactualizado!',
                                    'Por favor volver a scorear',
                                    'warning'
                                );
                            } else {

                            if(Accion=="TC Oferta Extraordinaria"){
                                $('#lblresultadoScoring').val("OfertaExtraordinaria");
                                $('#valresultadoScoring').val("OfertaExtraordinaria");
                            }else if(Accion=="TC Super Oferta"){
                                $('#lblresultadoScoring').val("SuperOferta");
                                $('#valresultadoScoring').val("SuperOferta");
                            }else if(Accion=="TC Oferta"){
                                $('#lblresultadoScoring').val("Oferta");
                                $('#valresultadoScoring').val("Oferta");
                            }else if(Accion=="TC Oferta Especial"){
                               $('#lblresultadoScoring').val("OfertaEspecial");
                               $('#valresultadoScoring').val("OfertaEspecial");
                            }else{
                                    $('#lblresultadoScoring').val("");
                                    $('#valresultadoScoring').val("");
                            }
                            
                                $('#valcodigoOperacionScoring').val(NumeroOperacion);
                                $('#lbldocumentoscoring').val(NumeroDocumento);
                                $('#lbltitularscoring').val(Titular);
                                $('#lblresultadoScoring').trigger('change');

                                $('#modal-logdni').modal('hide');
                            }
                        });
                    } else {
                        const row = document.createElement('tr');
                        row.innerHTML = `<td colspan="5" class="tblBody text-center"> No se encontró resultado</td>`
                        //Agrega el HTML del carrito en el tbody 
                        contenedor.appendChild(row);
                        $('#logconsultadoc').prop('disabled', false);
                    }
                }
            });
        })
        
    </script>        
    <!-- GESTION -->
    <script>
        function validarGestion(datos) {
            const ultimaGestion = $('#ultimagestion').val();
            console.log(datos);
            const {
                lblnivel1,
                lblnivel2,
                lblestadotelecierre,
                lblmovivonoventatc,
                lblfrellamadaTC,
                lblhrellamadaTC,
                lblcompetencia,
                lblcctc,
                lblgestortc,
                hidden_visitadox,
                hidden_acuerdocomercialinst                
            } = datos;
            console.log(datos);
            if(lblcctc=='' || lblcctc!=511){
                Swal.fire('Por favor ingresar CC valida', '', 'warning')
                return false;
            }else{

                if (lblgestortc == "" || lblgestortc == "Seleccione" || lblgestortc== "No se encontraron resultado") {
                    Swal.fire('Por favor ingresar Gestor Telecierre correcto', '', 'warning')
                    return false;                        
                }
                
                if (lblnivel1 == '' || lblnivel1 == null) {
                    Swal.fire('Seleccionar Tipo Contacto', '', 'warning')
                    return false;
                } else {
                    if (lblnivel2 == '' || lblnivel2 == null) {
                        Swal.fire('Seleccionar Tipo Gestionable', '', 'warning')
                        return false;
                    } else {
                        if (lblestadotelecierre == '' || lblestadotelecierre == null) {
                            Swal.fire('Seleccionar Tipificacion', '', 'warning')
                            return false;
                        } else {
                            if (lblestadotelecierre == 'Online') {
                                if (lblmovivonoventatc == '' || lblmovivonoventatc == null) {
                                    Swal.fire('Debes elegir la subtipificacion', '', 'warning')
                                    return false;
                                }
                                
                                if (hidden_visitadox == '' || hidden_visitadox == null) {
                                    Swal.fire('¿Visitado?, seleccionar SI/NO', '', 'warning')
                                    return false;
                                }
                                if (hidden_visitadox == 'SI') {
                                    if (hidden_acuerdocomercialinst == '' || hidden_acuerdocomercialinst == null) {
                                        Swal.fire('¿Acuerdo comercial?, seleccionar SI/NO', '', 'warning')
                                        return false;
                                    }
                                }                                
                                
                                
                                return validaForm();
                            } else if (lblestadotelecierre == 'DevolverLlamada' || lblestadotelecierre == 'PendienteRespuesta' || lblestadotelecierre == 'NoInteresa' || lblestadotelecierre == 'ProspectoAbierto' || lblestadotelecierre == 'NoVendida' || lblestadotelecierre == 'BlackList') {
                                if (lblmovivonoventatc == '' || lblmovivonoventatc == null) {
                                    Swal.fire('Debes elegir la subtipificacion', '', 'warning')
                                    return false;
                                }

                                if (hidden_visitadox == '' || hidden_visitadox == null) {
                                    Swal.fire('¿Visitado?, seleccionar SI/NO', '', 'warning')
                                    return false;
                                }
                                if (hidden_visitadox == 'SI') {
                                    if (hidden_acuerdocomercialinst == '' || hidden_acuerdocomercialinst == null) {
                                        Swal.fire('¿Acuerdo comercial?, seleccionar SI/NO', '', 'warning')
                                        return false;
                                    }
                                }                                
                                if (lblestadotelecierre == 'DevolverLlamada' || lblestadotelecierre == 'PendienteRespuesta' || lblestadotelecierre == 'ProspectoAbierto') {
                                    if (lblfrellamadaTC == '' || lblfrellamadaTC == null) {
                                        Swal.fire('Ingresar Fecha de Rellamada', '', 'warning')
                                        return false;
                                    }
                                    if (lblhrellamadaTC == '' || lblhrellamadaTC == null) {
                                        Swal.fire('Ingresar Hora de Rellamada', '', 'warning')
                                        return false;
                                    }
                                }
                                if (lblmovivonoventatc == 'Competencia') {
                                    if (lblcompetencia == '' || lblcompetencia == null) {
                                        Swal.fire('Ingresar Competencia correspondiente.', 'Si selecciona : Otros, colocar en comentario el nombre de la empresa', 'warning')
                                        return false;
                                    }
                                }
                                
                                 return true;
                            }else{
                                return true;
                            }
                        }
                    }
                }                
            }
            
           
        }

        //FUNCION PARA LOS CAMBIOS EN LOS ESTADOS DE TC Y TV
        $("#lblnivel1").change(function() {
            $("#lblnivel1 option:selected").each(function() {
                var lblnivel1 = $(this).val();
                $('#hiddenlblnivel1').val(lblnivel1);
                cargarResultados();
                var lblestadoteleventa = $('#lblestadoteleventa').val();
                cargarsubestado(lblestadoteleventa);

            });
        });

        $("#lblestadoteleventa").change(function() {
            var estadove = '<?php echo $estadoventa; ?>';
            var estvisita = '<?php echo $estadovisita; ?>';
            var catee = '<?php echo $categoriaventa; ?>';
            $("#lblestadoteleventa option:selected").each(function() {
                var lblestadoteleventa = $(this).val();
                $('#hiddenlblestadoteleventa').val(lblestadoteleventa);
                cargarsubestado(lblestadoteleventa);
                if (lblestadoteleventa == "Online") {
                    $(".selecteleventa").html('<select name="lblestadoventa" id="lblestadoventa" class="form-control input-sm"><option value="AgendadaTEC">AgendadaTEC</option><option value="PendienteData">PendienteData</option></select>');
                    $("#lblestadoventa").val("AgendadaTEC"); // linea modificada antes PendienteData
                    $("#lblcat").val("Online");

                    //LIMPIAR PARTE DE AGENDA

                    $("#lblinstaladox").val('');
                    $("#lbltecnico").val('');
                    $("#fechainst").val('');
                    $("#horainst").val('');
                    $("#lblcomentarioagenda").val('');
                    $("#lblrepercucion").val('');
                    
                } else if (lblestadoteleventa == "Ficha") {
                    $("#lblestadoventa").val("PendienteAgenda");
                    $("#lblcat").val("Ficha");
                } else if (lblestadoteleventa == "NoVendida") {
                     $(".selecteleventa").html('<input type="text" name="lblestadoventa" id="lblestadoventa" value="" class="form-control input-sm" style="width: 100%;" disabled />');  
                    $("#lblestadoventa").val("NoVendida");
                    $("#lblcat").val("NoVendida");
                } else {
                     $(".selecteleventa").html('<input type="text" name="lblestadoventa" id="lblestadoventa" value="" class="form-control input-sm" style="width: 100%;" disabled />');  
                    $("#lblestadovisita").val(estvisita);
                    $("#lblestadoventa").val(estadove);
                    $("#lblcat").val(catee);
                }


            });
        });

        $("#lblsubestado").change(function() {
            $("#lblsubestado option:selected").each(function() {
                var lblsubestado = $(this).val();
                cargarcompetencia(lblsubestado);

            });
        });

        function cargarnivel1() {
            var lblnivel1 = $('#lblnivel1');
            lblnivel1.find('option').remove();
            lblnivel1.append('<option value="">Seleccione</option>');
            let tipocontacto = {
                SI: 'SI',
                NO: 'NO',
            }
            for (let [llave, valor] of Object.entries(tipocontacto)) {
                lblnivel1.append(`<option value="${llave}">${valor}</option>`);
            }
        }

        function cargarResultados() {
            const resultado = $('#lblestadoteleventa');

            resultado.find('option').remove();
            resultado.append('<option value="" disabled selected>SELECCIONE</option>');

            let Resultados;

            const contacto = $('#lblnivel1').val();

            if (contacto == 'SI') {
                Resultados = {
                    DevolverLlamada: 'Devolver llamada',
                    NoVendida: 'No Vendida',
                    ContactoConTerceros: 'Contacto con Terceros',
                    // PendienteValidacion: 'Pendiente Validacion',
                    ProspectoAbierto: 'Prospecto Abierto - Presupuesto',
                    Online: 'Venta Online',
                    Inviable: 'Inviable',
                    BlackList: 'Blacklist',
                    ProspectoField: 'Prospecto Field'
                }
            } else if (contacto == 'NO') {
                Resultados = {
                    Apagado: 'Apagado',
                    ContestaCorta: 'Contesta y corta',
                    NoContacto: 'No Contacto'
                }
            }
            if (Resultados != undefined) {
                for (let [llave, valor] of Object.entries(Resultados)) {
                    resultado.append(`<option value="${llave}">${valor}</option>`);
                }
            }
        }


        function cargarsubestado(lblestadoteleventa) {
            var lblsubestado = $('#lblsubestado');

            lblsubestado.find('option').remove();
            lblsubestado.append('<option value="">Seleccione</option>');

            if (lblestadoteleventa === 'DevolverLlamada') {
                subestado = {
                    LlamarManana: 'Llamar Mañana',
                    LlamarTarde: 'Llamar Tarde',
                    LlamarNoche: 'Llamar Noche',
                    LugarenObras: 'Lugar en Obras'
                }

                for (let [llave, valor] of Object.entries(subestado)) {
                    lblsubestado.append(`<option value="${llave}">${valor}</option>`);
                }

            }

            if (lblestadoteleventa === 'ContactoConTerceros' || lblestadoteleventa === 'ProspectoAbierto') {
                subestado = {
                    LlamarManana: 'Llamar Mañana',
                    LlamarTarde: 'Llamar Tarde',
                    LlamarNoche: 'Llamar Noche'
                }

                for (let [llave, valor] of Object.entries(subestado)) {
                    lblsubestado.append(`<option value="${llave}">${valor}</option>`);
                }

            }

            if (lblestadoteleventa === 'NoVendida') {
                subestado = {
                    Economico: 'Económico',
                    PorContrato: 'Por Contrato',
                    Camaras: 'Cámaras',
                    NoInteresa: 'NoInteresa',
                    DesconoceCotizacion: 'Desconoce cotizacion / Número Equivocado',
                    Competencia: 'Competencia',
                    Otros: 'Otros'
                }

                for (let [llave, valor] of Object.entries(subestado)) {
                    lblsubestado.append(`<option value="${llave}">${valor}</option>`);
                }
            }
            
            if (lblestadoteleventa === 'Online') {
                subestado = {
                    AgedamientoporPlataforma: 'Agendamiento por plataforma',
                    TransferenciaenLinea: 'Transferencia en línea',
                    LineaOcupada: 'Línea ocupada'
                }

                for (let [llave, valor] of Object.entries(subestado)) {
                    lblsubestado.append(`<option value="${llave}">${valor}</option>`);
                }
            }

            if (lblestadoteleventa === 'Inviable') {
                subestado = {
                    InviableTecnicamente: 'Inviable Tecnicamente'
                }

                for (let [llave, valor] of Object.entries(subestado)) {
                    lblsubestado.append(`<option value="${llave}">${valor}</option>`);
                }

            }
            if (lblestadoteleventa === 'BlackList') {
                subestado = {
                    Clientenodeseaquelocontactenmas: 'Cliente no desea que lo contacten más'
                }

                for (let [llave, valor] of Object.entries(subestado)) {
                    lblsubestado.append(`<option value="${llave}">${valor}</option>`);
                }

            }            
            if (lblestadoteleventa === 'ProspectoField') {
                subestado = {
                    YatieneServicio: 'Ya tiene el servicio',
                    YatieneProspecto: 'Ya tiene prospecto'
                }

                for (let [llave, valor] of Object.entries(subestado)) {
                    lblsubestado.append(`<option value="${llave}">${valor}</option>`);
                }

            }            
            

            if (lblestadoteleventa == "DevolverLlamada" || lblestadoteleventa == "ContactoConTerceros" || lblestadoteleventa == "Inviable" || lblestadoteleventa == "BlackList" || lblestadoteleventa == "ProspectoField" || lblestadoteleventa == "ProspectoAbierto" || lblestadoteleventa == "NoVendida" || lblestadoteleventa == "Online") {
                $('.nivel4').show();
                if (lblestadoteleventa == "DevolverLlamada" || lblestadoteleventa == "ContactoConTerceros" || lblestadoteleventa == "ProspectoAbierto") {
                    $('#rowDevolverLlmada').removeClass('ocultar');
                } else {
                    $('#rowDevolverLlmada').addClass('ocultar');
                    $('#lblfrellamadaTC').val('');
                    $('#lblhrellamadaTC').val('');
                }
                $('#rowCompetencia').addClass('ocultar');
            } else {
                $('.nivel4').hide();
                $('#rowDevolverLlmada').addClass('ocultar');
                $('#rowCompetencia').addClass('ocultar');
            }

            //ARREGLO GESTIONABLE
            const arregloInternetGestionable = ['DevolverLlamada','NoVendida', 'ContactoConTerceros', 'PendienteValidacion', 'ProspectoAbierto', 'Online'];
            const arregloInternetNoContacto = ['Apagado', 'ContestaCorta', 'NoContacto'];
            const gestionable = arregloInternetGestionable.includes(lblestadoteleventa);
            const noContacto = arregloInternetNoContacto.includes(lblestadoteleventa);

            if (gestionable) {
                $('#lblnivel2').val('GESTIONABLE');
            } else if (noContacto) {
                $('#lblnivel2').val('NO CONTACTO');
            } else {
                $('#lblnivel2').val('NO GESTIONABLE');
            }

        }

        function cargarcompetencia(lblsubestado) {

            const lblcompetencia = $('#lblcompetencia');
            lblcompetencia.find('option').remove();
            lblcompetencia.append('<option value="" disabled selected>SELECCIONE</option>');
            if (lblsubestado === 'Competencia') {
                let competencias = {
                    Prosegur: 'Prosegur',
                    Mapfre: 'Mapfre',
                    Clave3: 'Clave3',
                    Boxer: 'Boxer',
                    Otros: 'Otros'
                }
                for (let [llave, valor] of Object.entries(competencias)) {
                    lblcompetencia.append(`<option value="${llave}">${valor}</option>`);
                }
                 $('#rowCompetencia').removeClass('ocultar');
            }
            else if (lblsubestado === 'Economico') {
                let competencias = {
                    PorPagoporMonitoreo: 'Por pago por Monitoreo',
                    PorPagoDispositovos: 'Por pago de dispositivos'
                }
                for (let [llave, valor] of Object.entries(competencias)) {
                    lblcompetencia.append(`<option value="${llave}">${valor}</option>`);
                }
                 $('#rowCompetencia').removeClass('ocultar');

            }else{
                $('#rowCompetencia').addClass('ocultar');
            }
          
        }

        function fechadiferencia() {

            var fechaUltGestion = $('#lblfechaultimagestion').val();

            var fechaInicio = new Date(fechaUltGestion).getTime();
            var fechaFin = new Date().getTime();
            var diff = (fechaFin - fechaInicio) / (1000 * 60);
            //MODIFICADO A 1 MINUTO
            if (diff < 1) {
                return false;
            } else {
                return true;
            }

        }
        
        $('#disponibilidad').on('click',function(){
           var zona = $('#lblIdDepartamental').val();
           var provincia = $("#lblProvinciaCalendario").val();
           var mesano590 = $("#mesano").val();
        //   $('#iframeCalendario').attr('src','Calendario_Visitas.php?zona='+zona);
           $('#iframeCalendario').attr('src','Calendario_VisitasDavid.php?provincia='+provincia+'&mesano590='+mesano590+'&zona='+zona);
           $('#modalDisponibilidad').modal('show');
      });       
        
    </script>

   <!-- FUNCIONES REFERIDO-->
        <script>
            $('#referidoHabilitado').change(function(){
                $("#referidoHabilitado option:selected").each(function () {
                var referidoHabilitado = $(this).val();
                 refhabilitada(referidoHabilitado);

                });
            });
            
            function validadatosReferidos(){
                if ($("#frmEditarVenta #lblcorreo").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#frmEditarVenta #lblcorreo").val())) {
                    Swal.fire('Por favor ingresar correo válido', '', 'warning');
                    $("#frmEditarVenta #lblcorreo").focus();
                    return false;
                }

                if ($("#frmEditarVenta #lblnombcliente").val() == "") {
                    Swal.fire('Por favor ingresar Nombre del Cliente', '', 'warning');
                    $("#frmEditarVenta #lblnombcliente").focus();
                    return false;
                }

                if ($("#frmEditarVenta #lblgestortc").val() == "" || $("#frmEditarVenta #lblgestortc").val() == "Seleccione" || $("#frmEditarVenta #lblgestortc").val() == "No se encontraron resultado") {
                    Swal.fire('Por favor ingresar Gestor Telecierre correcto', '', 'warning');
                    $("#frmEditarVenta #lblgestortc").select2('close');
                    return false;
                }   
                
                return true;
            }

            $('.copiarurl').on('click', function(){
             var content = document.getElementById('urlreferidoHabilitado');
                content.select();
                document.execCommand('copy');
                alertify.success("Copiado!");
            });
            
            $('.irurl').on('click', function(){
             var content = document.getElementById('urlreferidoHabilitado');
                window.open(content.value, '_blank').focus();
            });
            
            $('.actualizarcantidadref').on('click', function(){
            var idprospectorp=$('idVenta').val();
            var tipoventa=$('lbltipoventa').val();
            data = {idprospectorp:idprospectorp,tipoventa:tipoventa};
            fetch("./ajax/findCantidadReferidos.php",{method:'POST',body: JSON.stringify(data)})
                .then(function(res) {return res.json();})
                .then(function(data) {     
                    if(data.resultado=='Actualizado'){
                    Swal.fire(
                      'Actualizado!',
                      data.mensaje,
                      'success'
                        );
                    $('#cantidadreferidoHabilitado').val(data.cantidad);                        
                    }else{
                    Swal.fire(
                      'Error!',
                      data.mensaje,
                      'error'
                        );                        
                    }
                    $('#cantidadreferidoHabilitado').val(data.cantidad);
                })
                .catch(function(error) {
                    Swal.fire(
                      'Error!',
                      'Actualizar la página',
                      'error'
                        );  
                    
                });            
             
            });         
        function refhabilitada(value) {
            var idven=$('#idVenta').val();
            var tipoventa=$('#lbltipoventa').val();
            var refhabilitada = value;
            var lblcorreo=$('#lblcorreo').val();
            var lblnombcliente=$('#lblnombcliente').val();
            var lblgestortc=$('#lblgestortc').val();
            
            if(refhabilitada=="SI"){
                $('.datosreferidoHabilitado').removeClass('hidden');
                        //.classList().remove('ocultar');
            }else{
                $('.datosreferidoHabilitado').addClass('hidden');
            } 
            


            if(validadatosReferidos()){
                Swal.fire({
                    icon: 'question',
                    title: '¿Quieres guardar el cambio?',
                    showDenyButton: true,
                    showCancelButton: false,
                    confirmButtonText: `Modificar`,
                    denyButtonText: `Cancelar`,
                    allowOutsideClick: false
                }).then((result) => {
                    /* Read more about isConfirmed, isDenied below */
                    if (result.isConfirmed) {
                        if(refhabilitada=="SI"){
                            
                            
                            $('#hidreferidoHabilitado').val("SI");
                                    //.classList().remove('ocultar');
                            $('#urlreferidoHabilitado').val('https://clientesverisure.com/apps/referidostctv/create/'+idven+'/'+lblgestortc+'/'+tipoventa+'/'+encodeURI(lblnombcliente.split('/')[0])+'/511/'+lblcorreo);        
                        }else if(refhabilitada=="NO"){
                            $('#hidreferidoHabilitado').val("NO");
                            //.classList().add('ocultar');
                        }else{
                            $('#hidreferidoHabilitado').val("");
                                } 
                        
                        $.ajax({
                            type: 'post',
                            url: 'ajax/changeReferidoHabilitadoTVTC.php',
                            data: {
                                refhabilitada: refhabilitada,
                                idven: idven,
                                tipoventa:tipoventa
                            },
                            success: function(data) {
                                console.log(data);
                                if (data == 1) {
                                    Swal.fire('Modificado!', '', 'success');
    
                                } else if (data == 0) {
                                    swal.fire(
                                        'Alerta',
                                        'Sin cambios',
                                        'warning');
                                } else {
                                    swal.fire(
                                        'Error',
                                        'Error en la actualizacion',
                                        'error');
                                }
                            }
                        });
    
                    } else if (result.isDenied) {
                        var refhabilitadaN=$('#hidreferidoHabilitado').val();
                        if (refhabilitadaN == 'SI') {
                            //$('#cotenviada').prop('checked',false);
                            //$('#referidoHabilitado option:selected').val($('#hidreferidoHabilitado').val());
                            $('.datosreferidoHabilitado').removeClass('hidden');
                        } else if (refhabilitadaN == 'NO')  {
                            //$('#hidreferidoHabilitado').val('SI');
                            //$('#cotenviada').prop('checked',true);
                            //$('#referidoHabilitado option:selected').val('NO');
                            $('.datosreferidoHabilitado').addClass('hidden');
                        }else{
                            $('#hidreferidoHabilitado').val('');
                            //$('#cotenviada').prop('checked',true);
                            //$('#referidoHabilitado option:selected').val('');
                            $('.datosreferidoHabilitado').addClass('hidden');
                        }
                        $('#referidoHabilitado').val(refhabilitadaN);
                        Swal.fire('Los cambios no se guardan', '', 'info');
                    }
                })                       
            }else{
                        var refhabilitadaN=$('#hidreferidoHabilitado').val();
                        if (refhabilitadaN == 'SI') {
                            //$('#cotenviada').prop('checked',false);
                            $('#referidoHabilitado').val('NO');
                            $('.datosreferidoHabilitado').removeClass('hidden');
                        } else if (refhabilitadaN == 'NO')  {
                            //$('#hidreferidoHabilitado').val('SI');
                            //$('#cotenviada').prop('checked',true);
                            $('#referidoHabilitado').val('NO');
                            $('.datosreferidoHabilitado').addClass('hidden');
                        }else{
                            $('#hidreferidoHabilitado').val('');
                            //$('#cotenviada').prop('checked',true);
                            $('#referidoHabilitado').val('');
                            $('.datosreferidoHabilitado').addClass('hidden');
                        }            
            }

            



        }              
            
          $('#btneditarCliente').on('click', function() {
              
              $('#lblnprospectoz').val($('#lblnprospecto').val());
              $('#lblnombclientez').val($('#lblnombcliente').val());
              $('#lblcorreoz').val($('#lblcorreo').val());
              $('#lbldireccionz').val($('#lbldireccion').val());
              $('#lbldistritoz').val($('#lbldistrito').val());
              $('#lblfijoz').val($('#lblfijo').val());
    		  $('#modal-editarclienteprospecto').modal('show');
          });
          
          $('#btnActualizarCliente').on('click', function() {
              
             var lblnprospectoz=$('#lblnprospectoz').val();
             var lblnprospecto=$('#lblnprospecto').val();
             var lblnombclientez=$('#lblnombclientez').val();
             var lblcorreoz=$('#lblcorreoz').val();
             var lbldireccionz=$('#lbldireccionz').val();
             var lbldistritoz=$('#lbldistritoz').val();
             var lbldistritoNombre=$('#lbldistritoz option:selected').text();
             var lblfijoz=$('#lblfijoz').val();
             var lblidcliente=$('#lblidcliente').val();
             var lblidventa=$('#idVenta').val();
             
             var datos={
                array:'array6',
                lblnprospectoz,
                lblnprospecto,
                lblnombclientez,
                lblcorreoz,
                lbldireccionz,
                lbldistritoz,
                lblfijoz,
                lblidcliente,
                lblidventa
             }
             
             console.log(datos);
             
            if(validaClienteProspecto(datos)){
                $.ajax({
                        type: 'POST',
                        url: 'Controller/ControllerTVReferidos.php',
                        data:{function: JSON.stringify(datos)},  
                        dataType: "Json",
                        success: function (r) {
                            console.log(r);
                            if(r.respuesta=="exito"){
                                
                              $('#lblnprospecto').val(lblnprospectoz);
                              $('#lblnombcliente').val(lblnombclientez);
                              $('#lblcorreo').val(lblcorreoz);
                              $('#lbldireccion').val(lbldireccionz);

                              $("#lbldistrito").select2("trigger", "select", {data: { id: lbldistritoz ,text: lbldistritoNombre}});

                              $('#lblfijo').val(lblfijoz);
                              Swal.fire('Actualizado!', '', 'success');
                              $('#modal-editarclienteprospecto').modal('hidden');
                                
                            }else if(r.respuesta=="sincambios"){
                               Swal.fire('Prospecto duplicado!', '', 'warning'); 
                            }else{
                               Swal.fire('Algo ha salido mal al guardar!', '', 'error'); 
                            }

                        }
                    });                
            }
    		  
          });

        function validaClienteProspecto(datos) {
            const {lblnprospectoz,
                lblnombclientez,
                lblcorreoz,
                lbldireccionz,
                lbldistritoz,
                lblfijoz} = datos;
                        
                // Campos de texto
                if (lblnombclientez == "") {
                    Swal.fire('Por favor ingresar la Nombre del Cliente', '', 'warning');
                    return false;
                }
                if (lblcorreoz == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(lblcorreoz)) {
                    Swal.fire('Por favor ingresar correo válido', '', 'warning');
                    return false;
                }
                if (lbldireccionz == "") {
                    Swal.fire('Por favor ingresar la Direccion del Cliente', '', 'warning');
                    return false;
                } 
                if (lbldistritoz == "" || lbldistritoz == 0) {
                    Swal.fire('Por favor ingresar Distrito correcto', '', 'warning');
                    return false;
                }
                if (!/^([0-9])*$/.test(lblfijoz)) {
                    Swal.fire('El valor de Teléfono Dos no es un número', '', 'warning');
                    return false;
                }

                return true;
            }          
          
          
            
        </script> 
        <!--AFILIACION -->
        <script>
            $('#btnenviarcorreoafiliar').click(function(e){
                const correo=$('#lblcorreo').val();
                $('#InputCorreo').val(correo);    
            });
            
            $('#ModEnviar').click(function(e){
                var arrayNombre;
                const correo=$('#InputCorreo').val();
                var contrato=$('#lblncontrato').val();
                var nombcliente=getCleanedString($('#lblnombcliente').val().trim());
                arrayNombre=nombcliente.split(' ');
                var NombresScoring=getCleanedString($('#NombresScoring').val());
                var ApellidoPaternoScoring=getCleanedString($('#ApellidoPaternoScoring').val());
                var ApellidoMaternoScoring=getCleanedString($('#ApellidoMaternoScoring').val());
                var TipoDocumentoScoring=$('#TipoDocumentoScoring').val();
                var DocumentoScoring=$('#lbldocumentoscoring').val();
                if(TipoDocumentoScoring==6 || TipoDocumentoScoring==""){
                    TipoDocumentoScoring="0";
                    DocumentoScoring="00000000";
                    if(arrayNombre.length==1){
                        NombresScoring=arrayNombre[0];
                        ApellidoPaternoScoring=" ";
                        ApellidoMaternoScoring=" ";                    
                    }else if(arrayNombre.length==2){
                        NombresScoring=arrayNombre[0];
                        ApellidoPaternoScoring=arrayNombre[1];
                        ApellidoMaternoScoring=" ";   
                    }else{
                        NombresScoring=arrayNombre[0];
                        ApellidoPaternoScoring=arrayNombre[1];
                        ApellidoMaternoScoring=arrayNombre[2];
                    }                    
                }else if(TipoDocumentoScoring==3){
                    TipoDocumentoScoring=1;
                    DocumentoScoring=DocumentoScoring.substring(3);
                }else{
                    TipoDocumentoScoring=0;
                    DocumentoScoring=DocumentoScoring.substring(3);
                }
                console.log(DocumentoScoring);
            
                var url;
                var nombrecompleto;
                if (correo == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(correo)) {
                    Swal.fire({
                    type: 'warning',
                    title: '¡Advertencia!',
                    text: 'Verificar el correo a enviar la afiliacion',
                    })
                }else if(correo.split('@')[1].toLowerCase()=="verisure.pe"){
                    Swal.fire({
                    type: 'warning',
                    title: '¡Advertencia!',
                    text: 'Ingresar diferente al dominio de correo: @verisure.pe',
                    })
                 
                }else{
            
                    nombrecompleto=NombresScoring+" "+ApellidoPaternoScoring+" "+ApellidoMaternoScoring;
                    url="https://clientesverisure.com/apps/afiliacion/"+contrato+"/"+NombresScoring+"/"+ApellidoPaternoScoring+" "+ApellidoMaternoScoring+"/"+DocumentoScoring+"/"+TipoDocumentoScoring+"/"+correo;
                    var datos = {
                         correo:correo,
                         contrato:contrato,
                         nombrecompleto:encodeURIComponent(nombrecompleto),
                         url:encodeURIComponent(url)
                     }
                    $.ajax({
                        type: 'POST',
                        url: 'ajax/correoenvioAfiliacion.php',
                        data: datos,
                        dataType: "Json",
                        success: function(r) {
            
                            console.log(r);
            
                            if (r.respuesta == "exito") {
                                    swal.fire({
                                        title: 'Enviado!',
                                        text: 'El mensaje ha sido enviado exitosamente',
                                        type: 'success'
                                    });
            
                            } else {
                                    swal.fire({
                                        title: 'Error!',
                                        text: 'Ha ocurrido un erro en el envio,intentalo más tarde',
                                        type: 'error'
                                    });
                            }
                            $('#modal-enviarcorreoafiliar').modal('hide');                            
                        }
                    });
                }             
            
            });
            
            function getCleanedString(cadena){
            // Definimos los caracteres que queremos eliminar
            var specialChars = "!@#$^&%*()+=-[]\/{}|:<>?,.";
            
            // Los eliminamos todos
            for (var i = 0; i < specialChars.length; i++) {
               cadena= cadena.replace(new RegExp("\\" + specialChars[i], 'gi'), '');
            }   
            
            // Lo queremos devolver limpio en minusculas
            cadena = cadena.toLowerCase();
            
            // Quitamos acentos y "ñ". Fijate en que va sin comillas el primer parametro
            cadena = cadena.replace(/á/gi,"a");
            cadena = cadena.replace(/é/gi,"e");
            cadena = cadena.replace(/í/gi,"i");
            cadena = cadena.replace(/ó/gi,"o");
            cadena = cadena.replace(/ú/gi,"u");
            cadena = cadena.replace(/ñ/gi,"n");
            
            cadena = cadena.toUpperCase();
            
            return cadena;
            }            
            
        </script>
        

    
    </body>
</html>