<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
            header("location: ./login/index.php");
    		exit;
            }
    
    
    if ($_SESSION['pzvtaconsulta']==0) {
         header("location: ./denegado.php");
    		exit;
            }
    
    date_default_timezone_set('America/Lima');
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date)
    {
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date)
    {
        return date('Y-m-d', strtotime($date));
    }
    
    include 'config/db.php';
    include 'config/conexion.php';
    include 'helper/helper_validacion.php';
    /*
    include 'config/dbsec.php';
    include 'config/conexionsec.php';
    */
    
    if (isset($_GET['idventa'])) {
        $idventa = sanitizaCampo($_GET['idventa'], 'sanitizeint|scapestring|htmlspecialchars',$con);
        $idventa = htmlspecialchars($idventa);
    }
    
    $fechames=date("M-Y");
    
    $sql_venta = $con->prepare("SELECT
        u.IdUsuario,
        v.Matricula,
        v.Comercial,
        v.CC,
        v.JefeVenta,
        CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
        v.EstadoVenta,
        v.CategoriaVenta,
        v.TipoVenta,
        v.Segmento,
        v.MesesAutorizado,
        v.NProspecto,
        v.NContrato,
        v.IdCliente,
        v.FechaVisita,
        c.NombApellido Cliente,
        c.Correo,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        c.Interior,
        c.Referencia,
        g.IdGeografico,
        g.Distrito,
        g.Provincia,
        g.prioridadChip,
        v.PrecioKit,
        v.TotalExtra,
        v.ResumenVenta,
        v.ExtraAutorizado,
        v.FormaPago,
        v.N590,
        v.PAI,
        v.EstadoVisita,
        v.CCOriginal,
        v.HojaCertificacion,
        agen.IdAgenda,
        agen.InstaladoX,
        agen.MatriculaTec,
        CONCAT(t.Nombres,' ',t.Apellidos) Instalador,
        t.LN LNInstalador,
        DATE_FORMAT(agen.FechaInst, '%d/%m/%Y') FechaInst, 
        TIME_FORMAT(agen.HoraInst,'%r') HoraInst,
        agen.Comentario,
        agen.MotivoInviable,
        agen.MotivoCancelada,
        agen.Repercusion,
        f.MotivoIncidencia,
        DATE_FORMAT(f.FechaRecepcionDOC, '%d/%m/%Y') FechaRecepcionDOC,
        DATE_FORMAT(f.FechaFacturacion, '%d/%m/%Y') FechaFacturacion,
        f.DOCOriginal,
        f.Segmentacion,
        f.Pago,
        f.Autoriza,
        f.DNI,
        f.ElementosCTOPS,
        f.DOCPAI,
        f.FaltaDOC,
        f.RehacerCTO,
        f.Afiliacion,
        f.Prospecto_NroGuia,
        f.FueraHora,
        v.TipoKIT,
        v.CantidadExtras,
        v.ClosingPack,
        v.PrecioEspecial,
        v.ScoringRP,
        v.Checkin,
        v.InfoCheckIn,
        v.InfoCheckOut,
        v.totalHistorial,
        v.CheckOut,
        c.objGeofinder,
        c.DireccionAprox,
        c.TipoDireccion,
        v.FVisitaObras,
        v.IdConsultaScoringRP,
        v.GGCC,
        v.FormaPagoCuota,
        c.IdDocRP,
        v.referidoHabilitado,
        v.IdprospectoRP,
        v.CategoriaPrecio, 
        v.CantidadRegalo,
        v.TotalCuotaMonitoreo,
        vc.DetalleGeneral,
        vc.DetalleExtras,
        vc.DetalleRegalos,
        v.dsctCuota,
        v.TipoCamaraKit,
        sc.Nombres as NombresScoring,
        sc.ApellidoPaterno as ApellidoPaternoScoring,
        sc.ApellidoMaterno as ApellidoMaternoScoring,
        sc.TipoDocumento as TipoDocumentoScoring,
        sc.NumeroDocumento as DocumentoScoring,
        v.IteraccionAttec,
        v.OrigenVisita,
        att.IdAttec,
        DATE_FORMAT(att.FechaAuditoria, '%d/%m/%Y') FechaAuditoria,
        att.EstadoAttec,
        att.DatosSbn,
        att.DatosSbn_NoCoincide,
        DATE_FORMAT(att.F_CorreccionDatosSbn, '%d/%m/%Y') F_CorreccionDatosSbn,
        att.SegIncorrecto,
        DATE_FORMAT(att.F_CorreccionSegIncorrecto, '%d/%m/%Y') F_CorreccionSegIncorrecto,
        att.Seg_DebeDecir,
        att.Imagen,
        DATE_FORMAT(att.F_Imagen, '%d/%m/%Y') F_Imagen,
        att.Imagen_Motivo,
        att.IngresoProgramacion,
        DATE_FORMAT(att.F_CorreccionIngresoProgramacion, '%d/%m/%Y') F_CorreccionIngresoProgramacion,
        att.FallosCobertura,
        DATE_FORMAT(att.F_CorreccionFallosCobertura, '%d/%m/%Y') F_CorreccionFallosCobertura,
        att.MissingTest,
        DATE_FORMAT(att.F_CorreccionMissingTest, '%d/%m/%Y') F_CorreccionMissingTest,
        att.ZeroVision,
        DATE_FORMAT(att.F_CorreccionZeroVision, '%d/%m/%Y') F_CorreccionZeroVision,
        att.FalloSupervision,
        DATE_FORMAT(att.F_CorreccionFalloSupervision, '%d/%m/%Y') F_CorreccionFalloSupervision,
        att.FalloSupervision_Dispotivos,
        att.Tamper,
        DATE_FORMAT(att.F_CorreccionTamper, '%d/%m/%Y') F_CorreccionTamper,
        att.Tamper_Dispotivos,
        att.Comentario as ComentarioAttec,
        att.Zerovision_motivo,
        pp.IdProvincial,
        pp.IdDepartamental,
        g.CodUbigeoReniec,
        v.IdCertVenta,
        v.FechaApertura,
        DATE_FORMAT(vtacert.FechaCierre,'%d/%m/%Y') FechaCierre,
        vtacert.TipoCierre,
        vtacert.MotivoIncidencia as MotivoIncidenciaCert,
        vtacert.SolucionIncidencia,
        vtacert.IncidenciaTecnica,
        vtacert.FormaPago as FormaPagoCert,
        vtacert.Comentario as ComentarioCert,
        v.GestorCertVenta,
        CONCAT(cer.Nombres,' ',cer.Apellidos) NombGestorCertVenta,
        v.Renove,
        v.RCompetencia,
        v.RVencimiento,
        c.TipoSegmento,
vtacert.kitnoinstalado,
    DATE_FORMAT(vtacert.fechacorrecion_kitnoinstalado,'%d/%m/%Y') fechacorrecion_kitnoinstalado,
    vtacert.errorcomprobantepago,
    DATE_FORMAT(vtacert.fechacorrecion_errorcomprobantepago,'%d/%m/%Y') fechacorrecion_errorcomprobantepago,
    vtacert.errorsegmento,
    DATE_FORMAT(vtacert.fechacorrecion_errorsegmento,'%d/%m/%Y') fechacorrecion_errorsegmento,
    vtacert.fueranomalcomercial,
    DATE_FORMAT(vtacert.fechacorrecion_fueranomalcomercial,'%d/%m/%Y') fechacorrecion_fueranomalcomercial,
    vtacert.fueranormativatecnica,
    DATE_FORMAT(vtacert.fechacorrecion_fueranormativatecnica,'%d/%m/%Y') fechacorrecion_fueranormativatecnica,
    vtacert.incidenciadatos,
    DATE_FORMAT(vtacert.fechacorrecion_incidenciadatos,'%d/%m/%Y') fechacorrecion_incidenciadatos,
    vtacert.inconformidadfuncionamiento,
    DATE_FORMAT(vtacert.fechacorrecion_inconformidadfuncionamiento,'%d/%m/%Y') fechacorrecion_inconformidadfuncionamiento,
    vtacert.inconformidadpagoinicial,
    DATE_FORMAT(vtacert.fechacorrecion_inconformidadpagoinicial,'%d/%m/%Y') fechacorrecion_inconformidadpagoinicial,
    vtacert.inconformidadpagomensual,
    DATE_FORMAT(vtacert.fechacorrecion_inconformidadpagomensual,'%d/%m/%Y') fechacorrecion_inconformidadpagomensual,
    vtacert.inconformidadtiempopermanencia,
    DATE_FORMAT(vtacert.fechacorrecion_inconformidadtiempopermanencia,'%d/%m/%Y') fechacorrecion_inconformidadtiempopermanencia,
    vtacert.inconformidadubicaciondispositivos,
    DATE_FORMAT(vtacert.fechacorrecion_inconformidadubicaciondispositivos,'%d/%m/%Y') fechacorrecion_inconformidadubicaciondispositivos,
    vtacert.noconcefuncionamiento,
    DATE_FORMAT(vtacert.fechacorrecion_noconcefuncionamiento,'%d/%m/%Y') fechacorrecion_noconcefuncionamiento,
    vtacert.notienecontrato,
    DATE_FORMAT(vtacert.fechacorrecion_notienecontrato,'%d/%m/%Y') fechacorrecion_notienecontrato,
    vtacert.promesaspendientes,
    DATE_FORMAT(vtacert.fechacorrecion_promesaspendientes,'%d/%m/%Y') fechacorrecion_promesaspendientes,
    vtacert.reclamocomercial,
    DATE_FORMAT(vtacert.fechacorrecion_reclamocomercial,'%d/%m/%Y') fechacorrecion_reclamocomercial,
    vtacert.solicitabaja,
    DATE_FORMAT(vtacert.fechacorrecion_solicitabaja,'%d/%m/%Y') fechacorrecion_solicitabaja,
    vtacert.tarjetaafiliadanopertenecetitular,
    DATE_FORMAT(vtacert.fechacorrecion_tarjetaafiliadanopertenecetitular,'%d/%m/%Y') fechacorrecion_tarjetaafiliadanopertenecetitular,
    vtacert.recepmanual,
    DATE_FORMAT(vtacert.fechacorrecion_recepmanual,'%d/%m/%Y') fechacorrecion_recepmanual,
    vtacert.descargaapp,
    DATE_FORMAT(vtacert.fechacorrecion_descargaapp,'%d/%m/%Y') fechacorrecion_descargaapp,
    vtacert.capacitado,
    DATE_FORMAT(vtacert.fechacorrecion_capacitado,'%d/%m/%Y') fechacorrecion_capacitado,
    vtacert.numerollamadas,
    vtacert.FechaPendiente,
    vtacert.FechaPrimeraGestion,
    vtacert.FechaFinalizadoconIncidencia,
    vtacert.FechaResuelto,
    vtacert.ComentarioComercial,
    vtacert.RespComercial,
    vtacert.nuevohorarioSugerido,
    vtacert.FechaUltimaGestion,
    gt.EstadoLlamada,
    gt.Comentario as ComentarioGestion,
    gt.FechaHoraProgramacion,
    vtacert.jsonIncidencias      
        FROM yifi58ge_dbVENTAS.tblventa v 
        INNER JOIN yifi58ge_dbUSUARIO.tblusuario u on v.IdUsuario=u.IdUsuario 
        INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
        INNER JOIN yifi58ge_dbUSUARIO.tblusuario m on m.Matricula=u.Manager
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
        INNER JOIN yifi58ge_dbVENTAS.tblagenda agen on agen.IdVenta=v.IdVenta
        INNER JOIN yifi58ge_dbVENTAS.tblfacturacion f on f.IdVenta=v.IdVenta
        LEFT JOIN yifi58ge_dbVENTAS.tbltmpscoring sc on sc.IdConsultaScoring=v.IdConsultaScoringRP
        LEFT JOIN yifi58ge_dbUSUARIO.tblusuario t on t.Matricula=agen.MatriculaTec
        LEFT JOIN yifi58ge_dbVENTAS.tblventacotizacion vc ON v.IdVenta = vc.IdVenta
        LEFT JOIN yifi58ge_dbVENTAS.tblattec att on att.IdVenta=v.IdVenta
        LEFT JOIN yifi58ge_dbVENTAS.tbldistrital dd on dd.CodUbigeoReniec=g.CodUbigeoReniec
        LEFT JOIN yifi58ge_dbVENTAS.tblprovincial pp on pp.IdProvincial=dd.IdProvincial
        LEFT JOIN yifi58ge_dbVENTAS.tblcertificacionventa vtacert on vtacert.IdCertVenta=v.IdCertVenta
        LEFT JOIN yifi58ge_dbUSUARIO.tblusuario cer on cer.Matricula=v.GestorCertVenta
        LEFT JOIN yifi58ge_dbVENTAS.tblgestioncertificacionventa gt on gt.IdGestionCert=vtacert.IdGestionCert        
        WHERE v.IdVenta=? ");
        
        $sql_venta->bind_param('i',$idventa);
        $sql_venta->execute();
        $sql_venta->store_result();
        $sql_venta->bind_result(
            $IdUsuarioRow,
            $MatriculaRow,
            $ComercialRow,
            $CCRow,
            $JefeVentaRow,
            $NombJefeVentaRow,
            $EstadoVentaRow,
            $CategoriaVentaRow,
            $TipoVentaRow,
            $SegmentoRow,
            $MesesAutorizadoRow,
            $NProspectoRow,
            $NContratoRow,
            $IdClienteRow,
            $FechaVisitaRow,
            $ClienteRow,
            $CorreoRow,
            $TelefonounoRow,
            $TelefonodosRow,
            $DireccionRow,
            $InteriorRow,
            $ReferenciaRow,
            $IdGeograficoRow,
            $DistritoRow,
            $ProvinciaRow,
            $prioridadChipRow,
            $PrecioKitRow,
            $TotalExtraRow,
            $ResumenVentaRow,
            $ExtraAutorizadoRow,
            $FormaPagoRow,
            $N590Row,
            $PAIRow,
            $EstadoVisitaRow,
            $CCOriginalRow,
            $HojaCertificacionRow,
            $IdAgendaRow,
            $InstaladoXRow,
            $MatriculaTecRow,
            $InstaladorRow,
            $LNInstaladorRow,
            $FechaInstRow, 
            $HoraInstRow,
            $ComentarioRow,
            $MotivoInviableRow,
            $MotivoCanceladaRow,
            $RepercusionRow,
            $MotivoIncidenciaRow,
            $FechaRecepcionDOCRow,
            $FechaFacturacionRow,
            $DOCOriginalRow,
            $SegmentacionRow,
            $PagoRow,
            $AutorizaRow,
            $DNIRow,
            $ElementosCTOPSRow,
            $DOCPAIRow,
            $FaltaDOCRow,
            $RehacerCTORow,
            $AfiliacionRow,
            $Prospecto_NroGuiaRow,
            $FueraHoraRow,
            $TipoKITRow,
            $CantidadExtrasRow,
            $ClosingPackRow,
            $PrecioEspecialRow,
            $ScoringRPRow,
            $CheckinRow,
            $InfoCheckInRow,
            $InfoCheckOutRow,
            $totalHistorialRow,
            $CheckOutRow,
            $objGeofinderRow,
            $DireccionAproxRow,
            $TipoDireccionRow,
            $FVisitaObrasRow,
            $IdConsultaScoringRPRow,
            $GGCCRow,
            $FormaPagoCuotaRow,
            $IdDocRPRow,
            $referidoHabilitadoRow,
            $IdprospectoRPRow,
            $CategoriaPrecioRow, 
            $CantidadRegaloRow,
            $TotalCuotaMonitoreoRow,
            $DetalleGeneralRow,
            $DetalleExtrasRow,
            $DetalleRegalosRow,
            $dsctCuotaRow,
            $TipoCamaraKitRow,
            $NombresScoring,
            $ApellidoPaternoScoringRow,
            $ApellidoMaternoScoringRow,
            $TipoDocumentoScoringRow,
            $DocumentoScoringRow,
            $IteraccionAttecRow,
            $OrigenVisitaRow,
            $IdAttecRow,
            $FechaAuditoriaRow,
            $EstadoAttecRow,
            $DatosSbnRow,
            $DatosSbn_NoCoincideRow,
            $F_CorreccionDatosSbnRow,
            $SegIncorrectoRow,
            $F_CorreccionSegIncorrectoRow,
            $Seg_DebeDecirRow,
            $ImagenRow,
            $F_ImagenRow,
            $Imagen_MotivoRow,
            $IngresoProgramacionRow,
            $F_CorreccionIngresoProgramacionRow,
            $FallosCoberturaRow,
            $F_CorreccionFallosCoberturaRow,
            $MissingTestRow,
            $F_CorreccionMissingTestRow,
            $ZeroVisionRow,
            $F_CorreccionZeroVisionRow,
            $FalloSupervisionRow,
            $F_CorreccionFalloSupervisionRow,
            $FalloSupervision_DispotivosRow,
            $TamperRow,
            $F_CorreccionTamperRow,
            $Tamper_DispotivosRow,
            $ComentarioAttecRow,
            $Zerovision_motivoRow,
            $IdProvincialRow,
            $IdDepartamentalRow,
            $CodUbigeoReniecRow,
            $IdCertVentaRow,
            $FechaAperturaRow,
            $FechaCierreRow,
            $TipoCierreRow,
            $MotivoIncidenciaCertRow,
            $SolucionIncidenciaRow,
            $IncidenciaTecnicaRow,
            $FormaPagoCertRow,
            $ComentarioCertRow,
            $GestorCertVentaRow,
            $NombGestorCertVentaRow,
            $lblRenoveRow,
            $lblRcompetenciaRow,
            $lblRvencimientoRow,
            $TipoSegmentoRow,
    $kitnoinstaladoRow,
    $fechacorrecion_kitnoinstaladoRow,
    $errorcomprobantepagoRow,
    $fechacorrecion_errorcomprobantepagoRow,
    $errorsegmentoRow,
    $fechacorrecion_errorsegmentoRow,
    $fueranomalcomercialRow,
    $fechacorrecion_fueranomalcomercialRow,
    $fueranormativatecnicaRow,
    $fechacorrecion_fueranormativatecnicaRow,
    $incidenciadatosRow,
    $fechacorrecion_incidenciadatosRow,
    $inconformidadfuncionamientoRow,
    $fechacorrecion_inconformidadfuncionamientoRow,
    $inconformidadpagoinicialRow,
    $fechacorrecion_inconformidadpagoinicialRow,
    $inconformidadpagomensualRow,
    $fechacorrecion_inconformidadpagomensualRow,
    $inconformidadtiempopermanenciaRow,
    $fechacorrecion_inconformidadtiempopermanenciaRow,
    $inconformidadubicaciondispositivosRow,
    $fechacorrecion_inconformidadubicaciondispositivosRow,
    $noconcefuncionamientoRow,
    $fechacorrecion_noconcefuncionamientoRow,
    $notienecontratoRow,
    $fechacorrecion_notienecontratoRow,
    $promesaspendientesRow,
    $fechacorrecion_promesaspendientesRow,
    $reclamocomercialRow,
    $fechacorrecion_reclamocomercialRow,
    $solicitabajaRow,
    $fechacorrecion_solicitabajaRow,
    $tarjetaafiliadanopertenecetitularRow,
    $fechacorrecion_tarjetaafiliadanopertenecetitularRow,
    $recepmanualRow,
    $fechacorrecion_recepmanualRow,
    $descargaappRow,
    $fechacorrecion_descargaappRow,
    $capacitadoRow,
    $fechacorrecion_capacitadoRow,
    $numerollamadasRow,
    $FechaPendiente,
    $FechaPrimeraGestion,
    $FechaFinalizadoconIncidencia,
    $FechaResuelto,
    $ComentarioComercial,
    $RespComercial,
    $nuevohorarioSugerido,
    $FechaUltimaGestion,
    $EstadoLlamada,
    $ComentarioGestion,
    $FechaHoraProgramacion,
    $jsonIncidencias    
            );
    
    $numrows_venta = $sql_venta->num_rows;
    
    if ($numrows_venta > 0) {
        while ($sql_venta->fetch()) {
            $objGeofinder=desanitizaCampo($objGeofinderRow,'htmlspecialchars|htmlspecialchars|scapestring');
            $DireccionAprox=$DireccionAproxRow;
            $Checkin=$CheckinRow;
            $InfoCheckIn=$InfoCheckInRow;
            $CheckOut=$CheckOutRow;
            $InfoCheckOut=$InfoCheckOutRow;
            $totalHistorial=$totalHistorialRow;
            $TipoDireccion=$TipoDireccionRow;
            $idu=$IdUsuarioRow;
            $matricula=$MatriculaRow;
            $comercial=$ComercialRow;
            $matjefe= $JefeVentaRow;
            $jefeventa= $NombJefeVentaRow;
            $dc= $CCRow;
            $estadoventa= $EstadoVentaRow;
            $categoriaventa= $CategoriaVentaRow;
            $tipoventa= $TipoVentaRow;
            $segmento= $SegmentoRow;
            $mesesautorizados= $MesesAutorizadoRow;
            $nprospecto= $NProspectoRow;
            $ncontrato= $NContratoRow;
            $idcliente= $IdClienteRow;
            $cliente= $ClienteRow;
            $correo= $CorreoRow;
            $movil= $TelefonounoRow;
            $fijo= $TelefonodosRow;
            $direccion= $DireccionRow;
            $preciokit= $PrecioKitRow;
            $totalextra= $TotalExtraRow;
            $resumenventa= $ResumenVentaRow;
            $regaloutorizado= $ExtraAutorizadoRow;
            $formadepago= $FormaPagoRow;
            $n590= $N590Row;
            $PAI= $PAIRow;
            $idgeografico= $IdGeograficoRow;
            $distrito= $DistritoRow;
            $provincia= $ProvinciaRow;
            $sims = $prioridadChipRow;
            $HojaCertificacion= $HojaCertificacionRow;
            $lninstalador= $LNInstaladorRow;
            $idagenda= $IdAgendaRow;
            $instaladox= $InstaladoXRow;
            $matriculatec= $MatriculaTecRow;
            $nomreinstalador= $InstaladorRow;
            $fechainstalacionver= $FechaInstRow;
            $horainstalacionver= $HoraInstRow;
            $comentarioagenda= $ComentarioRow;
            $motivoinviable= $MotivoInviableRow;
            $motivocancelado= $MotivoCanceladaRow;
            $repercucion= $RepercusionRow;
            $CCOriginal= $CCOriginalRow;
            $factmotivoincidencia= $MotivoIncidenciaRow;
            $factfecharecepciondoc= $FechaRecepcionDOCRow;
            $factfechafacturacion= $FechaFacturacionRow;
            $factdocoriginal= $DOCOriginalRow;
            $factsegmentacion= $SegmentacionRow;
            $factpago= $PagoRow;
            $factautoriza= $AutorizaRow;
            $factdni= $DNIRow;
            $factelementosctops= $ElementosCTOPSRow;
            $factdocpai= $DOCPAIRow;
            $factfaltadoc= $FaltaDOCRow;
            $factrehacercto= $RehacerCTORow;
            $factafiliacion= $AfiliacionRow;
            $factprospecto_nroguia= $Prospecto_NroGuiaRow;
            $factfuerahora= $FueraHoraRow;
            $estadovisita= $EstadoVisitaRow;
            //NUEVOS CAMPOS DIRECCION
            $Interior=$InteriorRow;
            $Referencia=$ReferenciaRow;
            //NUEVOS CAMPOS ZEROVISION
            $TipoKIT=$TipoKITRow;
            $CantidadExtras=$CantidadExtrasRow;
            $ClosingPack=$ClosingPackRow;
            $PrecioEspecial=$PrecioEspecialRow;
            $ScoringRP=$ScoringRPRow;
            //Nuevos
            $FechaVisita=$FechaVisitaRow;
            $FVisitaObras=$FVisitaObrasRow;
            $GGCC=$GGCCRow;
            $IdConsultaScoringRP=$IdConsultaScoringRPRow;
            $FormaPagoCuota=$FormaPagoCuotaRow;
            $IdDocRP=$IdDocRPRow;
            //INFORMACION REFERIDO
            $idprospectorp=$IdprospectoRPRow;
            if($tipoventa=='RE' || $tipoventa=='RPMKT' || $tipoventa=='REGGCC'){
             $idprospectorp=$idventa; 
            }
            $referidoHabilitado=$referidoHabilitadoRow;
            //CARRITO DE COMPRAS
            $CategoriaPrecio= $CategoriaPrecioRow; 
            $CantidadRegalo= $CantidadRegaloRow; 
            $TotalCuotaMonitoreo= $TotalCuotaMonitoreoRow; 
            $DetalleGeneral= $DetalleGeneralRow; 
            $DetalleExtras= $DetalleExtrasRow; 
            $DetalleRegalos= $DetalleRegalosRow; 
            $dsctCuota= $dsctCuotaRow; 
            $TipoCamaraKit= $TipoCamaraKitRow; 
            $NombresScoring = $NombresScoring;
            $ApellidoPaternoScoring = $ApellidoPaternoScoringRow;
            $ApellidoMaternoScoring = $ApellidoMaternoScoringRow;
            $TipoDocumentoScoring = $TipoDocumentoScoringRow;
            $DocumentoScoring= $DocumentoScoringRow; 
            
            $IteraccionAttec = $IteraccionAttecRow;
            if (empty($IteraccionAttec)) {
                $IteraccionAttec = 0;
            }
            $OrigenVisita = $OrigenVisitaRow;          
            $idattec = $IdAttecRow;
            $FechaAuditoria = $FechaAuditoriaRow;
            $EstadoAttec = $EstadoAttecRow;
            $DatosSbn = $DatosSbnRow;
            $DatosSbn_NoCoincide = $DatosSbn_NoCoincideRow;
            $F_CorreccionDatosSbn = $F_CorreccionDatosSbnRow;
            $SegIncorrecto = $SegIncorrectoRow;
            $F_CorreccionSegIncorrecto = $F_CorreccionSegIncorrectoRow;
            $Seg_DebeDecir = $Seg_DebeDecirRow;
            $Imagen = $ImagenRow;
            $F_Imagen = $F_ImagenRow;
            $Imagen_Motivo = $Imagen_MotivoRow;
            $IngresoProgramacion = $IngresoProgramacionRow;
            $F_CorreccionIngresoProgramacion = $F_CorreccionIngresoProgramacionRow;
            $FallosCobertura = $FallosCoberturaRow;
            $F_CorreccionFallosCobertura = $F_CorreccionFallosCoberturaRow;
            $MissingTest = $MissingTestRow;
            $F_CorreccionMissingTest = $F_CorreccionMissingTestRow;
            $ZeroVision = $ZeroVisionRow;
            $F_CorreccionZeroVision = $F_CorreccionZeroVisionRow;
            $FalloSupervision = $FalloSupervisionRow;
            $F_CorreccionFalloSupervision = $F_CorreccionFalloSupervisionRow;
            $FalloSupervision_Dispotivos = $FalloSupervision_DispotivosRow;
            $Tamper = $TamperRow;
            $F_CorreccionTamper = $F_CorreccionTamperRow;
            $Tamper_Dispotivos = $Tamper_DispotivosRow;
            $ComentarioAttec = $ComentarioAttecRow;
            $Zerovision_motivo = $Zerovision_motivoRow;     
            $IdProvincial = $IdProvincialRow;
            $IdDepartamental = $IdDepartamentalRow;
            $CodUbigeoReniec = $CodUbigeoReniecRow;
            $idcertventa= $IdCertVentaRow;
            $FechaApertura= $FechaAperturaRow;
            $FechaCierre= $FechaCierreRow;
            $TipoCierre= $TipoCierreRow;
            $MotivoIncidenciaCert= $MotivoIncidenciaCertRow;
            $SolucionIncidencia= $SolucionIncidenciaRow;
            $IncidenciaTecnica= $IncidenciaTecnicaRow;
            $FormaPagoCert= $FormaPagoCertRow;
            $ComentarioCert= $ComentarioCertRow;
            $GestorCertVenta= $GestorCertVentaRow;
            $NombGestorCertVenta= $NombGestorCertVentaRow;
            
            $lblRenove=$lblRenoveRow;
            $lblRcompetencia=$lblRcompetenciaRow;
            $lblRvencimiento=$lblRvencimientoRow;
            
            $TipoSegmento=$TipoSegmentoRow;

            if(!empty($GestorCertVenta)){
    	        $htmlGestor='<option value="'.$GestorCertVenta.'" selected>'.$GestorCertVenta.' - '.$NombGestorCertVenta.'</option>';
    	    }else{
    	        $htmlGestor='<option value="" selected>Seleccione</option>';
    	    }

            if($tipoventa == "RE"){
			    $mostrarEtiqueta="";
			}else{
			    if($CategoriaPrecio == 'RENOVE' || $CategoriaPrecio == 'EXCEPCION RENOVE' || $CategoriaPrecio == 'SUPER OFERTA RENOVE'){
			        $mostrarEtiqueta="";
			    }else{
			        $mostrarEtiqueta="hidden";
			    }
			    
			}
			
$kitnoinstalado = $kitnoinstaladoRow;
        $fechacorrecion_kitnoinstalado = $fechacorrecion_kitnoinstaladoRow;
        $errorcomprobantepago = $errorcomprobantepagoRow;
        $fechacorrecion_errorcomprobantepago = $fechacorrecion_errorcomprobantepagoRow;
        $errorsegmento = $errorsegmentoRow;
        $fechacorrecion_errorsegmento = $fechacorrecion_errorsegmentoRow;
        $fueranomalcomercial = $fueranomalcomercialRow;
        $fechacorrecion_fueranomalcomercial = $fechacorrecion_fueranomalcomercialRow;
        $fueranormativatecnica = $fueranormativatecnicaRow;
        $fechacorrecion_fueranormativatecnica = $fechacorrecion_fueranormativatecnicaRow;
        $incidenciadatos = $incidenciadatosRow;
        $fechacorrecion_incidenciadatos = $fechacorrecion_incidenciadatosRow;
        $inconformidadfuncionamiento = $inconformidadfuncionamientoRow;
        $fechacorrecion_inconformidadfuncionamiento = $fechacorrecion_inconformidadfuncionamientoRow;
        $inconformidadpagoinicial = $inconformidadpagoinicialRow;
        $fechacorrecion_inconformidadpagoinicial = $fechacorrecion_inconformidadpagoinicialRow;
        $inconformidadpagomensual = $inconformidadpagomensualRow;
        $fechacorrecion_inconformidadpagomensual = $fechacorrecion_inconformidadpagomensualRow;
        $inconformidadtiempopermanencia = $inconformidadtiempopermanenciaRow;
        $fechacorrecion_inconformidadtiempopermanencia = $fechacorrecion_inconformidadtiempopermanenciaRow;
        $inconformidadubicaciondispositivos = $inconformidadubicaciondispositivosRow;
        $fechacorrecion_inconformidadubicaciondispositivos = $fechacorrecion_inconformidadubicaciondispositivosRow;
        $noconcefuncionamiento = $noconcefuncionamientoRow;
        $fechacorrecion_noconcefuncionamiento = $fechacorrecion_noconcefuncionamientoRow;
        $notienecontrato = $notienecontratoRow;
        $fechacorrecion_notienecontrato = $fechacorrecion_notienecontratoRow;
        $promesaspendientes = $promesaspendientesRow;
        $fechacorrecion_promesaspendientes = $fechacorrecion_promesaspendientesRow;
        $reclamocomercial = $reclamocomercialRow;
        $fechacorrecion_reclamocomercial = $fechacorrecion_reclamocomercialRow;
        $solicitabaja = $solicitabajaRow;
        $fechacorrecion_solicitabaja = $fechacorrecion_solicitabajaRow;
        $tarjetaafiliadanopertenecetitular = $tarjetaafiliadanopertenecetitularRow;
        $fechacorrecion_tarjetaafiliadanopertenecetitular = $fechacorrecion_tarjetaafiliadanopertenecetitularRow;
        $recepmanual = $recepmanualRow;
        $fechacorrecion_recepmanual = $fechacorrecion_recepmanualRow;
        $descargaapp = $descargaappRow;
        $fechacorrecion_descargaapp = $fechacorrecion_descargaappRow;
        $capacitado = $capacitadoRow;
        $fechacorrecion_capacitado = $fechacorrecion_capacitadoRow;
        $numerollamadas = $numerollamadasRow;

        
        if ($numerollamadas == "") {
            $numerollamadas=0;
        }			
    	    
        }
        $sql_venta->close();
        
        $infoCheckInD = json_decode($InfoCheckIn);
        $infoCheckOutD = json_decode($InfoCheckOut);
        $fechaEnvio = date("Y-m-d",strtotime($infoCheckInD->FechaEnvio)); 
    }

    if ($dc==511) {
         header("location: ./denegado.php");
    	 exit;
    }

    $sqlcodigo = $con->prepare("SELECT ts.NumeroOperacion FROM tbltmpscoring ts WHERE ts.IdConsultaScoring=? "); 
    $sqlcodigo->bind_param('i',$IdConsultaScoringRP);
    $sqlcodigo->execute();
    $sqlcodigo->store_result();
    $sqlcodigo->bind_result(
        $NumeroOperacionRow
        );
        
     if ($sqlcodigo->num_rows > 0) {
        while ($sqlcodigo->fetch()) {                
           $CodigoOperacionScoring=$NumeroOperacionRow;
        }
    }else{
         $CodigoOperacionScoring='';
    }
    
    $html=NULL;
    
    $sql = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) JefeVenta FROM yifi58ge_dbUSUARIO.tblusuario u  where u.CC=? AND u.LN='11' AND (u.Categoria ='JE' OR u.Categoria ='COACH' OR u.Categoria ='DEL' or u.Categoria='JE/DEL' or u.Categoria='GERENTE TERRITORIAL') LIMIT 50"); 
    $sql->bind_param('i',$CCOriginal);
    $sql->execute();
    $sql->store_result();
    $sql->bind_result(
        $MatriculaRow,
        $JefeVentaRow
        );
    
    if ($sql->num_rows > 0) {
        while ($sql->fetch()) {    
            $Matricula = $MatriculaRow;
            $JefeVenta = $JefeVentaRow;
           if($Matricula==$matjefe){
                   $html .= '<option value="'.$Matricula.'" selected>'.$Matricula.' - '.utf8_encode($JefeVenta).' </option>';
                    }else{
    $html .= '<option value="'.$Matricula.'">'.$Matricula.' - '.utf8_encode($JefeVenta).' </option>';
        }
    }

    }else{
         $html .= '<option>No se encontraron resultado</option>';
    }
    
    
    $html_tecnico=NULL;
    if($lninstalador=="" || empty($lninstalador)){
    $html_tecnico.= '<option></option>';
    }else{
    
    $sql_tecnico = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador FROM yifi58ge_dbUSUARIO.tblusuario u  
    INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea
    WHERE u.LN=? "); 
    $sql_tecnico->bind_param('i',$lninstalador);
    $sql_tecnico->execute();
    $sql_tecnico->store_result();
    $sql_tecnico->bind_result(
        $MatriculaRow,
        $InstaladorRow
        );

    
    if ($sql_tecnico->num_rows > 0) {
        while ($sql_tecnico->fetch()) {    
            $Matricula = $MatriculaRow;
            $Instalador = $InstaladorRow;
            
    if($Matricula==$matriculatec){
                   $html_tecnico.= '<option value="'.$Matricula.'" selected>'.$Matricula.' - '.utf8_encode($Instalador).' </option>';
                    }else{
    $html_tecnico.= '<option value="'.$Matricula.'">'.$Matricula.' - '.utf8_encode($Instalador).' </option>';
    }
        }
     
    }else{
         $html_tecnico.= '<option>No se encontraron resultado</option>';
    }
    
    }
    //INFORMACION REFERIDO
    $cantidadreferido=0;
    if($referidoHabilitado=="SI"){
    $sqlreferido = $con->prepare("SELECT COUNT(ref.IdProspectoRP) CantidadReferido FROM yifi58ge_dbREFERIDO.tblreferido ref INNER JOIN yifi58ge_dbREFERIDO.tblreferido_detalle detref on ref.Id= detref.Referido_ID WHERE ref.IdProspectoRP=? and ref.TipoVenta=?"); 
    $sqlreferido->bind_param('is',$idprospectorp,$tipoventa);
    $sqlreferido->execute();
    $sqlreferido->store_result();
    $sqlreferido->bind_result(
            $CantidadReferidoRow
        );
    
    if ($sqlreferido->num_rows > 0) {
        while ($sqlreferido->fetch()) {     
            $cantidadreferido=$CantidadReferidoRow;
        }
    }else{
         $cantidadreferido=0;
    }
    }    
    
    //INFORMACION EXISTE PRECIO BOMBA
    $resultadoPrecioBomba ='NO';
    if($tipoventa=='RE'){
        if($dc == "154" || $dc == "157" || $dc == "158" || $matriculausuario=='MGR200' || $dc == "120" || $dc == "150" || $dc == "41"){
            $sql = $con->prepare("SELECT 1 FROM yifi58ge_dbVENTAS.tblcategoria WHERE Categoria = 'PRECIO BOMBA' AND TipoVenta = 'RE' AND Estado = 'Activo' LIMIT 1");
            $sql->execute();
            $sql->store_result();
            $row_cnt = $sql->num_rows;
            if($row_cnt > 0){
                $resultadoPrecioBomba ='NO';
            }
    }else{
        $sql = $con->prepare("SELECT 1 FROM yifi58ge_dbVENTAS.tblcategoriatmp WHERE Categoria = 'PRECIO BOMBA' AND TipoVenta = 'RE' AND Estado = 'Activo' LIMIT 1");
        $sql->execute();
        $sql->store_result();
        $row_cnt = $sql->num_rows;
        if($row_cnt > 0){
            $resultadoPrecioBomba ='NO';
        }
    }
    //$respuesta = $con->query($sql);
    // $row_cnt = $respuesta->num_rows;
    // if($row_cnt > 0){
    //     $resultadoPrecioBomba ='NO';
    // }
    }
    
    //INFORMACION AFILIACION
    // if($dc == 100 || $dc == 140 || $dc == 152 || $dc == 159 || $dc == 155 || $dc == 154 || $dc == 200 || $dc == 141 || $dc == 500 || $dc == 120 || $dc == 121 || $dc == 40 || $dc == 41 || $dc == 42 || $dc == 80){
    if(!empty($ncontrato)){
        $sqlafiliacion = $con->prepare("SELECT status,ACTION_DESCRIPTION,dataMap FROM yifi58ge_dbREFERIDO.tblafiliacion where beneficiaryId=? "); 
        $sqlafiliacion->bind_param('s',$ncontrato);
        $sqlafiliacion->execute();
        $sqlafiliacion->store_result();
        $sqlafiliacion->bind_result(
            $statusRow,
            $ACTION_DESCRIPTIONRow,
            $dataMapRow
            );
      
        if ($sqlafiliacion->num_rows > 0) {
            while ($sqlafiliacion->fetch()) {     
                $estadoafiliacion=$statusRow;
                $ACTION_DESCRIPTION=$ACTION_DESCRIPTIONRow;
                $dataMap=$dataMapRow;
                if(isset($dataMap) && !empty($dataMap)){
                    $objAfiliacion=json_decode($dataMap, true);
                    if(isset($objAfiliacion['mensaje_autorizacion']['dataMap']['CARD'])){
                        $card=$objAfiliacion['mensaje_autorizacion']['dataMap']['CARD'];
                        $tipocuenta='Tarjeta';
                    }else{
                        $card='';
                        $tipocuenta='';
                    }
                }
            }
        }else{
             $estadoafiliacion='Pendiente';
             $ACTION_DESCRIPTION='';
             $dataMap='';
             $card='';
             $tipocuenta='';
        }
    
    $variablecuenta=array('Diners Club','visa','mastercard','American Express');
    //INFORMACION AFILIACION
    $sqlafiliacionmdp = $con->prepare("SELECT id,status,motivo,numero,tipo,correo FROM yifi58ge_dbREFERIDO.tblmdpafiliacion where ncontrato=? "); 
    $sqlafiliacionmdp->bind_param('s',$ncontrato);
    $sqlafiliacionmdp->execute();
    $sqlafiliacionmdp->store_result();
    $sqlafiliacionmdp->bind_result(
        $idRow,
        $statusRow,
        $motivoRow,
        $numeroRow,
        $tipoRow,
        $correoRow
    );

    if ($sqlafiliacionmdp->num_rows > 0) {
        while ($sqlafiliacionmdp->fetch()) {     
            $idnmdp=$idRow;
            $estadoafiliacionmdp=$statusRow;
            $motivomdp=$motivoRow;
            $card=$idRow;
            $tipo=$tipoRow;
            $correoenviomdp=$correoRow;
            if(in_array($tipo,$variablecuenta)){
               $tipocuenta='Tarjeta'; 
            }else{
               $tipocuenta='Cuenta'; 
            }
        }
    }else{
            $idnmdp='';
            $estadoafiliacionmdp='';
            $motivomdp='';
            $tipo='';
            $correoenviomdp='';
            $tipocuenta='';
    }
        
        
        
    }else{
             $estadoafiliacion='Pendiente';
             $ACTION_DESCRIPTION='';
             $dataMap='';
             $card='';
             $tipocuenta='';
        }
    
    
    
    
    // }else{
    //          $estadoafiliacion='Pendiente';
    //          $ACTION_DESCRIPTION='';
    //          $dataMap='';
    //          $card='';
    //          $tipocuenta='';
    // }
    
// INFORMACION PARA GUIA $ncontrato
$contrato_presente = 1;
if($ncontrato == ''){
    $numeroContrato = 999999999;
}else{
    $numeroContrato = $ncontrato;
}

// $ncontrato = $ncontrato =''?12345567789:$ncontrato;
   $stmtsqlguia = $con->prepare("SELECT contrato FROM yifi58ge_dbGUIAREMISION.guia where contrato=? AND contrato_presente  = ?"); 
    $stmtsqlguia->bind_param('si',$numeroContrato,$contrato_presente);
    $stmtsqlguia->execute();
    $stmtsqlguia->store_result();
    $stmtsqlguia->bind_result(
        $contratoRow
        );
    // var_dump($ncontrato);
    if ($stmtsqlguia->num_rows > 0) {
        $icono = 'fa-check';
        $colorGuia = 'btn-success';
        $estadoGuia = 'Guia Emitida';
        $estadoGuiaRemision = 'guiaEmitida';
    }else{
        $icono = 'fa-exclamation-circle';
        $colorGuia = 'btn-danger';
        $estadoGuia = 'Guia Pendiente';
        $estadoGuiaRemision = 'guiaPendiente';
    }
    
    ?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
        <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
            folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <link rel="stylesheet" href="admin/bower_components/sweetalert2/dist/sweetalert2.min.css">
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
        <!-- Bootstrap toogle-->
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
        <!-- Bootstrap datepicker -->
        <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css"/>
        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
        <!-- EDITAR FACTURACION -->
        <link rel="stylesheet" href="css/editarfacturacion.css">
        <!-- LEAFLET -->
        <link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css"
            integrity="sha512-xodZBNTC5n17Xt2atTPuE1HxjVMSvLVW9ocqUKLsCC5CXdbqCmblAshOMAS6/keqq/sMZMZ19scR4PsZChSR7A=="
            crossorigin=""/>
        <link rel="stylesheet" href="lib/leaflet_AwesomeMarkers/dist/leaflet.awesome-markers.css">
        <!-- LOCALES -->
        <style>
            #map { height: 400px; }
            .ocultar {
            display: none;
            }
            .swal2-popup {
            font-size: 1.5rem!important;
            }
            .modal-header-danger {
            color:#fff;
            background-color: #e4002b;              
            }
            .preloader{
            background-color:#FFF;
            width: 100%;
            height: 100%;
            position: absolute;
            z-index: 1;
            }
            .dataTables_wrapper .myfilter .dataTables_filter{float:left}
            .dataTables_wrapper .mylength .dataTables_length{float:right}
            div.dataTables_scrollBody thead th {
            vertical-align: top;
            } 
            td {
            max-width: 250px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
            }
            .espacio{
            height:10px;
            }
            .espacio2{
            height:15px;
            }
            .thumbnail_style{
            text-align:center;
            border:none;
            }
            .caption h4{
            margin-top: -10px;
            font-size:13px;
            font-weight:  bold;
            }
            .caption p{
            color:#777;
            font-size:13px;
            }
            .caption a{
            color:#777;
            font-size:10px;
            }
            #frmEditarVenta .form-control{
            border-radius: 4px
            }
            #c-slider{
            margin: auto;
            width: 100%;
            max-width: 900px;
            position: relative;
            overflow: hidden;
            }
            #slider{
            display: flex;
            width: 300%;
            }
            #slider section{
            width: 100%;
            }
            .select2-container--default .select2-selection--single {
            border: 1px solid #d2d6de;
            border-radius: 4px;font-size: 12px;
            padding:4px 6px;
            }
            .btn-nuevo { 
            color: #FFFFFF; 
            background-color: #444444; 
            border-color: #444444; 
            } 
            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
            color: #FFFFFF; 
            background-color: #616161;  
            border-color: #444444; 
            } 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
            background-image: none; 
            } 
            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
            background-color: #444444; 
            border-color: #444444; 
            } 
            input[type=number]::-webkit-outer-spin-button,
            input[type=number]::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
            }
            input[type=number] {
            -moz-appearance:textfield;
            }
        </style>
        <style>
            .main-header,.main-sidebar,.left-side{position:fixed}
            .main-header {
            top: 0;
            right: 0;
            left: 0
            }
            .content-wrapper,
            .right-side {
            padding-top: 50px
            }
            @media (max-width:767px) {
            .content-wrapper,
            .right-side {
            padding-top: 100px
            }
            }
            .layout-boxed .wrapper {
            max-width: 100%
            }
            .wrapper {
            overflow: hidden
            .control-sidebar {
            position: fixed;
            height: 100%;
            overflow-y: auto;
            padding-bottom: 50px
            }       
        </style>
        <style>
            .ui-autocomplete {
            position: absolute;
            z-index: 1000;
            cursor: default;
            padding: 0;
            margin-top: 2px;
            list-style: none;
            font-size: 11px;
            font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
            background-color: #ffffff;
            border: 1px solid #ccc;
            -webkit-border-radius: 5px;
            -moz-border-radius: 5px;
            border-radius: 5px;
            -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            z-index: 1051 !important;    
            }
            hr {
            height: 4px;
            width: 100%;
            background-color: #ecf0f5;
            }
            hr {
            /* margin-top: 20px; */
            margin-bottom: 20px;
            border: 0;
            /* border-top: 1px solid #eee; */
            }
            hr {
            display: block;
            unicode-bidi: isolate;
            -webkit-margin-before: 0.5em;
            -webkit-margin-after: 0.5em;
            -webkit-margin-start: auto;
            -webkit-margin-end: auto;
            overflow: hidden;
            border-style: inset;
            }
            .box.box-custom {
            border-top-color: #ffffff;
            }
            .box {
            position: relative;
            border-radius: 3px;
            background: #ffffff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 5px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            }
        </style>
        <style>
            .readonly_blanco {
            background-color: #fff!important;
            }
        </style>
        <style>
            #header-decision{
            height: auto;
            width: 100%;
            padding-top: 25px;
            padding-bottom: 25px;
            }
            #header-decision span{
            line-height: 40px;
            font-size: 18px;
            }
            .barra-informacion{
            background: rgb(82, 87, 88);
            color: white;
            padding: 0 2rem;
            }
            .barra-informacion ul{
            display: flex;
            justify-content: space-between;
            list-style: none;
            padding: 22px 55px;
            margin-bottom: 10px;
            }
            .barra-informacion a{
            text-decoration: none;
            color: white;
            font-weight: 600;
            }
            .main-contenido{
            display: flex;
            justify-content: space-between;
            flex-wrap: wrap;
            padding: 8rem 2rem;
            }
            .contenido-solicitante {
            padding: 0 5rem 0 5rem;
            }
            @media (min-width: 768px){
            .contenido-solicitante{
            flex-basis: calc(40% - 2rem);
            }
            .contenido-score{
            flex-basis: 60%;
            }
            }
            .contenido-solicitante-info{
            display: flex;
            align-items: center;
            }
            .icono{
            padding-right: 10px;
            }
            .icono i{
            font-size: 4.2rem;
            line-height: 3.8rem;
            }
            .info{
            line-height: 1.5rem;
            display: table-cell;
            vertical-align: top;
            }
            .score-conclusion strong{
            font-weight: 700;
            }
            #divLoading {
            background: rgba(66,118,164,0.4);
            width: 100%;
            height: 100%;
            min-height: 100%;
            position: absolute;
            top: 0;
            left: 0;
            z-index: 999999999;
            display:none;
            }
            #divLoading2 {
            background: rgba(66,118,164,0.4);
            width: 100%;
            height: 100%;
            min-height: 100%;
            position: absolute;
            top: 0;
            left: 0;
            z-index: 999999999;
            display:none;
            }
            .spinner {
            margin: 300px auto 0;
            width: 70px;
            text-align: center;
            }
            .spinner > div {
            background-color: #e4002b;
            width: 18px;
            height: 18px;
            border-radius: 100%;
            display: inline-block;
            -webkit-animation: sk-bouncedelay 1.4s infinite ease-in-out both;
            animation: sk-bouncedelay 1.4s infinite ease-in-out both;
            }
            .spinner .bounce1 {
            -webkit-animation-delay: -0.32s;
            animation-delay: -0.32s;
            }
            .spinner .bounce2 {
            -webkit-animation-delay: -0.16s;
            animation-delay: -0.16s;
            }
            @-webkit-keyframes sk-bouncedelay {
            0%, 80%, 100% { -webkit-transform: scale(0) }
            40% { -webkit-transform: scale(1.0) }
            }
            @keyframes sk-bouncedelay {
            0%, 80%, 100% {
            -webkit-transform: scale(0);
            transform: scale(0);
            } 40% {
            -webkit-transform: scale(1.0);
            transform: scale(1.0);
            }
            }
            .centrar-texto {
            text-align: center;
            }
            .m_get_started.fix {
            height: 100%;
            padding: 0;
            text-align: center;
            opacity: 1;
            }
            .callout {
            border-radius: 3px;
            margin: 0 0 20px 0;
            padding: 15px 30px 15px 15px;
            border-left: 5px solid #f03;
            -webkit-box-shadow: 10px 10px 5px -9px rgba(0,0,0,0.75);
            -moz-box-shadow: 10px 10px 5px -9px rgba(0,0,0,0.75);
            box-shadow: 10px 10px 5px -9px rgba(0,0,0,0.75);
            }
            .bg-deuda{
            color: #000;
            background-color: #ffffff !important;
            }
            .bg-visita{
            color: #fff;
            background-color: #008000 !important;
            }
            .bg-gestion{
            color: #fff;
            background-color: #6a6659 !important;   
            }
            .bg-televenta{
            color: #fff;
            background-color: #f39c12 !important;
            }
            input#nombres { text-transform: uppercase; }
            input#apellido_p { text-transform: uppercase; }
            input#apellido_m { text-transform: uppercase; }
            .select2-container--default .select2-selection--single {
            border: 1px solid #d2d6de;
            border-radius: 4px;font-size: 12px;
            padding:4px 6px;
            }
            select + span.select2:focus, select + span.select2 *:focus { 	outline-color: #7d3c8c; 	outline-width: 1px; }
            .select2-container--default.select2-container--focus, .select2-selection.select2-container--focus, .select2-container--default:focus, .select2-selection:focus, .select2-container--default:active, .select2-selection:active {
            outline: none;
            border: 1px solid #3c8dbc;
            border-radius: 4px;
            } 
            .btn-verisure{
            font-family: "Avenir Next LT W01 Demi", sans-serif;
            font-weight: normal !important;
            font-style: normal !important;
            box-sizing: border-box;
            -moz-box-sizing: border-box;
            font-size: 15px;
            color: #EE0008;
            border: 1px solid #eb3e3e;
            border-radius: 40px;
            display: inline-block;
            /*padding: 15px 24px 15px 44px;*/
            text-decoration: none;
            text-align: center;
            line-height: 28px;
            text-transform: uppercase;
            }
            .btn-verisure { 
            color: #ffffff; 
            background-color: #FF0033; 
            border-color: #FF0033; 
            } 
            .btn-verisure:hover, 
            .btn-verisure:focus, 
            .btn-verisure:active, 
            .btn-verisure.active, 
            .open .dropdown-toggle.btn-verisure { 
            color: #ffffff; 
            background-color: #a62828; 
            border-color: #a62828; 
            } 
            .btn-verisure:active, 
            .btn-verisure.active, 
            .open .dropdown-toggle.btn-verisure { 
            background-image: none; 
            } 
            .btn-verisure.disabled, 
            .btn-verisure[disabled], 
            fieldset[disabled] .btn-verisure, 
            .btn-verisure.disabled:hover, 
            .btn-verisure[disabled]:hover, 
            fieldset[disabled] .btn-verisure:hover, 
            .btn-verisure.disabled:focus, 
            .btn-verisure[disabled]:focus, 
            fieldset[disabled] .btn-verisure:focus, 
            .btn-verisure.disabled:active, 
            .btn-verisure[disabled]:active, 
            fieldset[disabled] .btn-verisure:active, 
            .btn-verisure.disabled.active, 
            .btn-verisure[disabled].active, 
            fieldset[disabled] .btn-verisure.active { 
            background-color: #555758; 
            border-color: #555758; 
            } 
            .btn-verisure .badge { 
            color: #FF0033; 
            background-color: #ffffff; 
            }
            .btn-verisurecerrar{
            font-family: "Avenir Next LT W01 Demi", sans-serif;
            font-weight: normal !important;
            font-style: normal !important;
            box-sizing: border-box;
            -moz-box-sizing: border-box;
            font-size: 15px;
            color: #444;
            border: 1px solid #ddd;
            border-radius: 40px;
            display: inline-block;
            /*padding: 15px 24px 15px 44px;*/
            text-decoration: none;
            text-align: center;
            line-height: 28px;
            text-transform: uppercase;
            }
            .btn-verisurecerrar { 
            background-color: #f4f4f4;
            color: #444;
            border-color: #ddd;
            } 
            .btn-verisurecerrar:hover, 
            .btn-verisurecerrar:focus, 
            .btn-verisurecerrar:active, 
            .btn-verisurecerrar.active, 
            .open .dropdown-toggle.btn-verisurecerrar { 
            color: #333;
            background-color: #e6e6e6;
            border-color: #adadad;
            } 
            .btn-verisurecerrar:active, 
            .btn-verisurecerrar.active, 
            .open .dropdown-toggle.btn-verisurecerrar { 
            background-image: none; 
            } 
            .btn-verisurecerrar.disabled, 
            .btn-verisurecerrar[disabled], 
            fieldset[disabled] .btn-verisurecerrar, 
            .btn-verisurecerrar.disabled:hover, 
            .btn-verisurecerrar[disabled]:hover, 
            fieldset[disabled] .btn-verisurecerrar:hover, 
            .btn-verisurecerrar.disabled:focus, 
            .btn-verisurecerrar[disabled]:focus, 
            fieldset[disabled] .btn-verisurecerrar:focus, 
            .btn-verisurecerrar.disabled:active, 
            .btn-verisurecerrar[disabled]:active, 
            fieldset[disabled] .btn-verisurecerrar:active, 
            .btn-verisurecerrar.disabled.active, 
            .btn-verisurecerrar[disabled].active, 
            fieldset[disabled] .btn-verisurecerrar.active { 
            background-color: #e7e7e7; 
            } 
            .btn-verisurecerrar .badge { 
            background-color: #f4f4f4;
            color: #444;
            }
            .swal2-popup {
            font-size: 1.5rem!important;
            }      
            label {
            font-weight: 400;
            font-size: 12px;
            }   
            .subtitulo{
            text-decoration: underline;
            font-weight: bold;
            }
        </style>
        <style>
            .toggle.ios,
            .toggle-on.ios,
            .toggle-off.ios {
            border-radius: 20px;
            }
            .toggle.ios .toggle-handle {
            border-radius: 20px;
            }
            .labelBBVA{
            background-color: #3c8dbc;
            border-color: #367fa9;
            border-radius: 3px;
            -webkit-box-shadow: none;
            box-shadow: none;
            border: 1px solid transparent;
            display: block;
            width: 100%;
            padding: 5px 10px;
            font-size: 12px;
            line-height: 1.5;
            color: #fff;text-align: center;               
            }
            .labelInterbank{
            background-color: #00a65a;
            border-color: #00a65a;
            border-radius: 3px;
            -webkit-box-shadow: none;
            box-shadow: none;
            border: 1px solid transparent;
            display: block;
            width: 100%;
            padding: 5px 10px;
            font-size: 12px;
            line-height: 1.5;
            color: #fff;text-align: center;                  
            }  
            .labelBCP{
            background-color: #f39c12;
            border-color: #f39c12;
            border-radius: 3px;
            -webkit-box-shadow: none;
            box-shadow: none;
            border: 1px solid transparent;
            display: block;
            width: 100%;
            padding: 5px 10px;
            font-size: 12px;
            line-height: 1.5;
            color: #fff;text-align: center;                  
            } 
            .labelOH{
            background-color: #dd4b39;
            border-color: #dd4b39;
            border-radius: 3px;
            -webkit-box-shadow: none;
            box-shadow: none;
            border: 1px solid transparent;
            display: block;
            width: 100%;
            padding: 5px 10px;
            font-size: 12px;
            line-height: 1.5;
            color: #fff;text-align: center;                  
            } 
        </style>
    </head>
    <body class="sidebar-collapse skin-red sidebar-mini">
        <div id="divLoading" style="display: none;height: auto; min-height: 100%;">
            <div class="spinner">
                <div class="bounce1"></div>
                <div class="bounce2"></div>
                <div class="bounce3"></div>
            </div>
        </div>
        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php
                $consultaventa="active";
                
                include 'admin/main-sidebar.php';
                ?>
            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        VENTAS
                    </h1>
                    <ol class="breadcrumb">
                        <li><i class="fa fa-dashboard"></i> Home</li>
                        <li><a href="consultaventa.php">Ventas</a></li>
                        <li class="active">Editar de Venta</li>
                    </ol>
                </section>
                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-md-2"></div>
                        <div class="col-md-8">
                            <!-- /.box-header -->
                            <div class="box box-danger">
                                <div class="box-header">
                                    <div class="form-horizontal">
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <h3 class="col-sm-12 col-xs-12 box-title" style="text-align:left;">EDITAR</h3>
                                                    <div class="col-sm-12 col-xs-12">
                                                        <?php if($tipoventa=='RE'){ ?>
                                                        <h3 class="box-title">
                                                            <select name="lblcategoria" id="lblcategoria" style="border:none;-moz-appearance:none;-webkit-appearance:none;-ms-appearance:none;-o-appearance:none;">
                                                                <?php
                                                                    //Condicion para los delegados
                                                                    if($matriculausuario=='C32805' || $matriculausuario=='CD4231' || $matriculausuario=='HA6658'|| $matriculausuario=='MF6331'|| $matriculausuario=='RF6290' || $matriculausuario=='C97801' || $matriculausuario=='DF3030' || $matriculausuario=='JG9306' || $matriculausuario=='CI8027'){
                                                                        
                                                                        if($estadoventa=="AgendadaTEC"){
                                                                            ?>
                                                                <option value="Online"<?php if ($categoriaventa == "Online") {echo "selected";}?> hidden="">VENTA ONLINE - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Ficha"<?php if ($categoriaventa == "Ficha") {echo "selected";}?>>VENTA FICHA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Delegacion"<?php if ($categoriaventa == "Delegacion") {echo "selected";}?>>VENTA DELEGACIÓN - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="VAsignada"<?php if ($categoriaventa == "VAsignada") {echo "selected";}?> hidden="">VISITA ASIGNADA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Cancelada"<?php if ($categoriaventa == "Cancelada") {echo "selected";}?> hidden="">CANCELADA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="NoVendida"<?php if ($categoriaventa == "NoVendida") {echo "selected";}?> >NO VENDIDA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <?php
                                                                    }else if($estadoventa=="NoInstalada" || $estadoventa=="NoVendida" || $estadoventa=="Cancelada" || $estadoventa=="Instalada" || $estadoventa=="Incidencia" || $estadoventa=="IncidenciaGestCorreo" || $estadoventa=="IncidenciaGestValija" || $estadoventa=="NoDoc" || $estadoventa=="DocEnvi" || $estadoventa=="Porfacturar"  || $estadoventa=="Facturada"){
                                                                    ?>
                                                                <option value="<?php echo $categoriaventa;?>"<?php if ($categoriaventa == "Online" || $categoriaventa == "Ficha" || $categoriaventa == "Delegacion" ) {echo "selected";}?>>
                                                                    <?php 
                                                                        if ($categoriaventa == "Online"){
                                                                            $nombc="VENTA ONLINE";
                                                                        }else if($categoriaventa == "Ficha"){
                                                                            $nombc="VENTA FICHA";
                                                                        }else if($categoriaventa == "Delegacion"){
                                                                            $nombc="VENTA DELEGACIÓN ";
                                                                        }
                                                                         echo $nombc;
                                                                        ?> - <?php echo $nprospecto." | ".$ncontrato ?>
                                                                </option>
                                                                <?php
                                                                    } else{
                                                                    ?>
                                                                <option value="Online"<?php if ($categoriaventa == "Online") {echo "selected";}?> hidden="">VENTA ONLINE - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Ficha"<?php if ($categoriaventa == "Ficha") {echo "selected";}?>>VENTA FICHA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Delegacion"<?php if ($categoriaventa == "Delegacion") {echo "selected";}?>>VENTA DELEGACIÓN - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="VAsignada"<?php if ($categoriaventa == "VAsignada") {echo "selected";}?> hidden="">VISITA ASIGNADA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Cancelada"<?php if ($categoriaventa == "Cancelada") {echo "selected";}?> hidden="">CANCELADA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="NoVendida"<?php if ($categoriaventa == "NoVendida") {echo "selected";}?> >NO VENDIDA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <?php
                                                                    } 
                                                                    //Fin de Condicion para delegados
                                                                    }else{
                                                                    if($estadoventa=="AgendadaTEC" || $estadoventa=="Instalada" || $estadoventa=="Incidencia" || $estadoventa=="IncidenciaGestCorreo" || $estadoventa=="IncidenciaGestValija" || $estadoventa=="NoDoc" || $estadoventa=="DocEnvi" || $estadoventa=="Porfacturar"  || $estadoventa=="Facturada" ){
                                                                    ?>                                                                
                                                                <option value="<?php echo $categoriaventa;?>"<?php if ($categoriaventa == "Online" || $categoriaventa == "Ficha" || $categoriaventa == "Delegacion" ) {echo "selected";}?>><?php 
                                                                    if ($categoriaventa == "Online"){
                                                                        $nombc="VENTA ONLINE";
                                                                    }else if($categoriaventa == "Ficha"){
                                                                        $nombc="VENTA FICHA";
                                                                    }else if($categoriaventa == "Delegacion"){
                                                                        $nombc="VENTA DELEGACIÓN ";
                                                                    }
                                                                    echo $nombc;
                                                                    ?> - <?php echo $nprospecto." | ".$ncontrato ?>
                                                                </option>
                                                                <?php
                                                                    }else{
                                                                    ?>
                                                                <option value="Online"<?php if ($categoriaventa == "Online") {echo "selected";}?> hidden="">VENTA ONLINE - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Ficha"<?php if ($categoriaventa == "Ficha") {echo "selected";}?>>VENTA FICHA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Delegacion"<?php if ($categoriaventa == "Delegacion") {echo "selected";}?>>VENTA DELEGACIÓN - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="VAsignada"<?php if ($categoriaventa == "VAsignada") {echo "selected";}?> hidden="">VISITA ASIGNADA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Cancelada"<?php if ($categoriaventa == "Cancelada") {echo "selected";}?> hidden="">CANCELADA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="NoVendida"<?php if ($categoriaventa == "NoVendida") {echo "selected";}?> >NO VENDIDA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <?php
                                                                    }
                                                                    }
                                                                    ?>
                                                            </select>
                                                        </h3>
                                                        <?php }
                                                            else{
                                                            ?>
                                                        <h3 class="box-title">
                                                            <select name="lblcategoria" id="lblcategoria" style="border:none;-moz-appearance:none;-webkit-appearance:none;-ms-appearance:none;-o-appearance:none;">
                                                                <?php
                                                                    if($matriculausuario=='C32805' || $matriculausuario=='CD4231' || $matriculausuario=='HA6658'|| $matriculausuario=='MF6331'|| $matriculausuario=='RF6290' || $matriculausuario=='C97801' || $matriculausuario=='DF3030' || $matriculausuario=='JG9306' || $matriculausuario=='CI8027'){
                                                                    
                                                                     if($estadoventa=="AgendadaTEC"){
                                                                            ?>
                                                                <option value="ProspectoRP"<?php if ($categoriaventa == "ProspectoRP") {echo "selected";}?> hidden="">NUEVO PROSPECTO RP - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Online"<?php if ($categoriaventa == "Online") {echo "selected";}?> hidden="">VENTA ONLINE - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Ficha"<?php if ($categoriaventa == "Ficha") {echo "selected";}?>>VENTA FICHA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Delegacion"<?php if ($categoriaventa == "Delegacion") {echo "selected";}?>>VENTA DELEGACIÓN - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="NoVendida"<?php if ($categoriaventa == "NoVendida") {echo "selected";}?> >NO VENDIDA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Cancelada"<?php if ($categoriaventa == "Cancelada") {echo "selected";}?> hidden="">CANCELADA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <?php
                                                                    }
                                                                    else if($estadoventa=="NoInstalada" || $estadoventa=="NoVendida" || $estadoventa=="Cancelada" || $estadoventa=="Instalada" || $estadoventa=="Incidencia" || $estadoventa=="IncidenciaGestCorreo" || $estadoventa=="IncidenciaGestValija" || $estadoventa=="NoDoc" || $estadoventa=="DocEnvi" || $estadoventa=="Porfacturar"  || $estadoventa=="Facturada"){
                                                                        ?>
                                                                <option value="<?php echo $categoriaventa;?>"<?php if ($categoriaventa == "Online" || $categoriaventa == "Ficha" || $categoriaventa == "Delegacion" ) {echo "selected";}?>><?php 
                                                                    if ($categoriaventa == "Online"){
                                                                        $nombc="VENTA ONLINE";
                                                                    }else if($categoriaventa == "Ficha"){
                                                                        $nombc="VENTA FICHA";
                                                                    }else if($categoriaventa == "Delegacion"){
                                                                        $nombc="VENTA DELEGACIÓN ";
                                                                    }
                                                                    echo $nombc;
                                                                    ?> - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <?php
                                                                    } else{
                                                                    ?>
                                                                <option value="ProspectoRP"<?php if ($categoriaventa == "ProspectoRP") {echo "selected";}?> hidden="">NUEVO PROSPECTO RP - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Online"<?php if ($categoriaventa == "Online") {echo "selected";}?> hidden="">VENTA ONLINE - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Ficha"<?php if ($categoriaventa == "Ficha") {echo "selected";}?>>VENTA FICHA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Delegacion"<?php if ($categoriaventa == "Delegacion") {echo "selected";}?>>VENTA DELEGACIÓN - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="NoVendida"<?php if ($categoriaventa == "NoVendida") {echo "selected";}?> >NO VENDIDA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Cancelada"<?php if ($categoriaventa == "Cancelada") {echo "selected";}?> hidden="">CANCELADA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <?php
                                                                    }
                                                                    }
                                                                    else{
                                                                       if($estadoventa=="NoInstalada" || $estadoventa=="NoVendida" || $estadoventa=="Cancelada" || $estadoventa=="AgendadaTEC" || $estadoventa=="Instalada" || $estadoventa=="Incidencia" || $estadoventa=="IncidenciaGestCorreo" || $estadoventa=="IncidenciaGestValija" || $estadoventa=="NoDoc" || $estadoventa=="DocEnvi" || $estadoventa=="Porfacturar"  || $estadoventa=="Facturada" ){
                                                                        
                                                                    ?>
                                                                <option value="<?php echo $categoriaventa;?>"<?php if ($categoriaventa == "Online" || $categoriaventa == "Ficha" || $categoriaventa == "Delegacion" ) {echo "selected";}?>><?php 
                                                                    if ($categoriaventa == "Online"){
                                                                        $nombc="VENTA ONLINE";
                                                                    }else if($categoriaventa == "Ficha"){
                                                                        $nombc="VENTA FICHA";
                                                                    }else if($categoriaventa == "Delegacion"){
                                                                        $nombc="VENTA DELEGACIÓN ";
                                                                    }
                                                                    echo $nombc;
                                                                    ?> - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <?php
                                                                    }else{
                                                                    ?>
                                                                <option value="ProspectoRP"<?php if ($categoriaventa == "ProspectoRP") {echo "selected";}?> hidden="">NUEVO PROSPECTO RP - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Online"<?php if ($categoriaventa == "Online") {echo "selected";}?> hidden="">VENTA ONLINE - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Ficha"<?php if ($categoriaventa == "Ficha") {echo "selected";}?>>VENTA FICHA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Delegacion"<?php if ($categoriaventa == "Delegacion") {echo "selected";}?>>VENTA DELEGACIÓN - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="NoVendida"<?php if ($categoriaventa == "NoVendida") {echo "selected";}?> >NO VENDIDA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <option value="Cancelada"<?php if ($categoriaventa == "Cancelada") {echo "selected";}?> hidden="">CANCELADA - <?php echo $nprospecto." | ".$ncontrato ?></option>
                                                                <?php
                                                                    } 
                                                                    }
                                                                    ?>
                                                            </select>
                                                        </h3>
                                                        <?php
                                                            }
                                                            ?>
                                                        <input id="lblcat" name="lblcat" value="<?php echo $categoriaventa;?>" hidden="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="box-tools pull-right">
                                        <a class="btn <?php echo $colorGuia; ?> btn-md" id="estadoGuia" href="#"><i class="fa <?php echo $icono; ?>"></i> <?php echo $estadoGuia; ?></a>
                                        <input type="hidden" class="form-control" id="estadoGuiaRemision" name="estadoGuiaRemision" value="<?php echo htmlspecialchars($estadoGuiaRemision);?>">
                                        <button class="btn btn-warning btn-sm" id="btnCheckIn" data-toggle="modal" data-target="#modal-checkin"><i class="fa fa-map-marker"></i></button>
                                        <button class="btn btn-primary btn-sm" id="btnCheckOut" data-toggle="modal" data-target="#modal-checkout"><i class="fa fa-sign-out"></i></button>
                                        <button class="btn btn-primary btn-sm hidden" id="btnHistorialCheckOut" data-toggle="modal" data-target="#modal-historial-checkout"><i class="fa fa-list"></i></button>
                                        <?php
                                            if($estadoventa=="NoInstalada" || $estadoventa=="NoVendida" || $estadoventa=="Cancelada" || $estadoventa=='PorFacturar' || $estadoventa=='Facturada' || $nombacceso=='test' || $dc == '511' || $estadoventa=="Instalada" || $estadoventa=="Incidencia" || $estadoventa=="IncidenciaGestCorreo" || $estadoventa=="IncidenciaGestValija" || $estadoventa=="NoDoc" || $estadoventa=="DocEnvi"){
                                                if($matriculausuario=="MGR200" || $matriculausuario=="MGR41"){
                                            ?>
                                        <a class="btn btn-nuevo btn-sm" id="btnGuardarEditarVenta" href="#"><i class="fa fa-save"></i></a>
                                        <?php    
                                            }                                           
                                            }else{ ?>
                                        <a class="btn btn-nuevo btn-sm" id="btnGuardarEditarVenta" href="#"><i class="fa fa-save"></i></a>
                                        <?php   
                                            } 
                                            ?>
                                        <a href="<?php if($matriculausuario=="JG9306" || $matriculausuario=="JB4716" || $matriculausuario=="RP1100" || $matriculausuario=="MR1229" || $matriculausuario=="CR2160" || $matriculausuario=="MR1229" || $matriculausuario=="GR5444" || $matriculausuario=="ER6494" || $matriculausuario=="ER9720"){ echo "consultaventa.php";} else {echo "consultaventa.php";} ?>" class="btn btn-danger btn-sm" ><i class="fa fa-reply"></i> </a>
                                    </div>
                                </div>
                            </div>
                            <form id="frmEditarVenta" method="POST">
                                <!-- INFORMACION DE LA VENTA -->
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                        <h5>INFORMACION DE VENTA</h5>
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                        <div class="form-horizontal">
                                            <div>
                                                <h5 class="subtitulo">DATOS DEL COMERCIAL</h5>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblmatricula">MATRICULA: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input name="lblmatricula" id="lblmatricula" class="form-control input-sm" value="<?php echo $matricula;?>" style="width: 100%;" readonly="readonly">
                                                            <input id="lblidusuario" name="lblidusuario" value="<?php echo $idu;?>" hidden="">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcomercial">COMERCIAL: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input name="lblnombcomercial" id="lblnombcomercial" class="form-control input-sm" style="width: 100%;" value="<?php echo $comercial;?>" readonly="readonly" >
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lbldc">DC: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" name="lbldc" id="lbldc" style="width: 100%;">
                                                                <option>Seleccione</option>
                                                                <?php if ($dc == "150") { ?>
                                                                <option value="150" <?php if ($dc == "150") {echo "selected";}?>>150</option>
                                                                <?php }else if($dc == "151") { ?>
                                                                <option value="151" <?php if ($dc == "151") {echo "selected";}?>>151</option>
                                                                <?php }else if ($dc == "152") { ?>
                                                                <option value="152" <?php if ($dc == "152") {echo "selected";}?>>152</option>
                                                                <?php }else if($dc == "153") { ?>
                                                                <option value="153" <?php if ($dc == "153") {echo "selected";}?>>153</option>
                                                                <?php }else if ($dc == "154") { ?>
                                                                <option value="154" <?php if ($dc == "154") {echo "selected";}?>>154</option>
                                                                <?php }else if($dc == "155") { ?>
                                                                <option value="155" <?php if ($dc == "155") {echo "selected";}?>>155</option>
                                                                <?php }else if($dc == "156") { ?>
                                                                <option value="156" <?php if ($dc == "156") {echo "selected";}?>>156</option>
                                                                <?php }else if($dc == "157") { ?>
                                                                <option value="157" <?php if ($dc == "157") {echo "selected";}?>>157</option>
                                                                <?php }else if($dc == "158") { ?>
                                                                <option value="158" <?php if ($dc == "158") {echo "selected";}?>>158</option>
                                                                <?php }else if($dc == "159") { ?>
                                                                <option value="159" <?php if ($dc == "159") {echo "selected";}?>>159</option>
                                                                <?php }else if ($dc == "200") { ?>
                                                                <option value="200" <?php if ($dc == "200") {echo "selected";}?>>200</option>
                                                                <?php }else if ($dc == "140") { ?>
                                                                <option value="140" <?php if ($dc == "140") {echo "selected";}?>>140</option>
                                                                <?php }else if ($dc == "120") { ?>
                                                                <option value="120" <?php if ($dc == "120") {echo "selected";}?>>120</option>
                                                                <?php }else if ($dc == "100") { ?>
                                                                <option value="100" <?php if ($dc == "100") {echo "selected";}?>>100</option>
                                                                <?php }else if ($dc == "40") { ?>
                                                                <option value="40" <?php if ($dc == "40") {echo "selected";}?>>40</option>
                                                                <?php }else if ($dc == "41") { ?>
                                                                <option value="41" <?php if ($dc == "41") {echo "selected";}?>>41</option>
                                                                <?php }else if ($dc == "42") { ?>
                                                                <option value="42" <?php if ($dc == "42") {echo "selected";}?>>42</option>
                                                                <?php }else if ($dc == "511") { ?>
                                                                <option value="511" <?php if ($dc == "511") {echo "selected";}?>>511</option>
                                                                <?php }else if ($dc == "512") { ?>
                                                                <option value="512" <?php if ($dc == "512") {echo "selected";}?>>512</option>
                                                                <?php }else if ($dc == "513") { ?>
                                                                <option value="513" <?php if ($dc == "513") {echo "selected";}?>>513</option>
                                                                <?php }else if ($dc == "500") { ?>
                                                                <option value="500" <?php if ($dc == "500") {echo "selected";}?>>500</option>
                                                                <?php }else if ($dc == "599") { ?>
                                                                <option value="599" <?php if ($dc == "599") {echo "selected";}?>>599</option>
                                                                <?php }else if ($dc == "121") { ?>
                                                                <option value="121" <?php if ($dc == "121") {echo "selected";}?>>121</option>
                                                                <?php }else if ($dc == "250") { ?>
                                                                <option value="250" <?php if ($dc == "250") {echo "selected";}?>>250</option>
                                                                <?php }else if ($dc == "251") { ?>
                                                                <option value="251" <?php if ($dc == "251") {echo "selected";}?>>251</option>
                                                                <?php }else if ($dc == "252") { ?>
                                                                <option value="252" <?php if ($dc == "252") {echo "selected";}?>>252</option>
                                                                <?php } else if ($dc == "80") { ?>
                                                                <option value="80" <?php if ($dc == "80") {echo "selected";}?>>80</option>
                                                                <?php } else if ($dc == "20") { ?>
                                                                <option value="20" <?php if ($dc == "20") {echo "selected";}?>>20</option>
                                                                <?php } else if ($dc == "141") { ?>
                                                                <option value="141" <?php if ($dc == "141") {echo "selected";}?>>141</option>

        														<?php } else if ($dc == "601") { ?>
        														<option value="601" <?php if ($dc == "601") {echo "selected";}?>>601</option>
        														<?php } else if ($dc == "602") { ?>
        														<option value="602" <?php if ($dc == "602") {echo "selected";}?>>602</option>        														
        														<?php } else if ($dc == "701") { ?>
        														<option value="701" <?php if ($dc == "701") {echo "selected";}?>>701</option>
        														<?php } else if ($dc == "702") { ?>
        														<option value="702" <?php if ($dc == "702") {echo "selected";}?>>702</option>
        														<?php } else if ($dc == "901") { ?>
        														<option value="901" <?php if ($dc == "901") {echo "selected";}?>>901</option>
        														<?php } else if ($dc == "711") { ?>
        														<option value="711" <?php if ($dc == "711") {echo "selected";}?>>711</option> 
        														<?php } else if ($dc == "713") { ?>
        														<option value="713" <?php if ($dc == "713") {echo "selected";}?>>713</option>          														
        														
        														<?php } else if ($dc == "130") { ?>
        														<option value="130" <?php if ($dc == "130") {echo "selected";}?>>130</option>    
        														<?php } else if ($dc == "230") { ?>
        														<option value="230" <?php if ($dc == "230") {echo "selected";}?>>230</option>
        														<?php } else if ($dc == "60") { ?>
        														<option value="60" <?php if ($dc == "60") {echo "selected";}?>>60</option>        														
                                                                
                                                                <?php } else { ?>
                                                                <option value="" selected></option>
                                                                <?php }?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lbljefeventa" style="text-align:left;">JEFE VENTA: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" name="lbljefeventa" id="lbljefeventa" style="width: 100%;">
                                                            <?php echo $html;?>
                                                            </select>   
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div>
                                                <h5 class="subtitulo">DATOS GENERALES DEL CLIENTE</h5>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcliente">CLIENTE: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input name="lblnombcliente" class="form-control input-sm" id="lblnombcliente" value="<?php echo $cliente;?>" style="width: 100%;"/>
                                                            <input id="lblidcliente" name="lblidcliente" value="<?php echo $idcliente;?>" hidden="">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">CORREO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="text"  class="form-control input-sm" id="lblcorreo" value="<?php echo $correo;?>" name="lblcorreo">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblsegmento">SEGMENTO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" name="lblsegmento" id="lblsegmento">
                                                                <option>Seleccione</option>
                                                                <option value="RES"<?php if ($segmento == "RES") {echo "selected";}?>>RES</option>
                                                                <option value="NEG"<?php if ($segmento == "NEG") {echo "selected";}?>>NEG</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6 <?php if ($segmento == "NEG") {echo "ocultar";}?>">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblsegmento">TIPO RESIDENCIAL: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
  
                                                        <select class="form-control input-sm Lead__tiposegmento <?php if ($segmento == "NEG") {echo "ocultar";}?>" name="lbltiposegmento" id="lbltiposegmento">
                                                            <option value="">Seleccione</option>
                                                            <option value="Casa"<?php if ($TipoSegmento == "Casa") {echo "selected";}?>>Casa</option>
                                                            <option value="Departamento"<?php if ($TipoSegmento == "Departamento") {echo "selected";}?>>Departamento</option>
                                                        </select>
                                                        </div>
                                                    </div>
                                                </div>                                                
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lbldireccion">DIRECCIÓN: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <textarea class="form-control input-sm" name="lbldireccion" id="lbldireccion" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $direccion;?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lbldistrito" style="text-align:left;">DISTRITO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control selectdistrito input-sm" name="lbldistrito" id="lbldistrito" style="width: 100%;" disabled>
                                                                <option value="<?php echo $idgeografico; ?>"><?php echo $distrito.' - '.$provincia; ?></option>
                                                            </select>
                                                            <input id="lblIdProvincial" name="lblIdProvincial" value="<?php echo $IdProvincial; ?>" hidden="" />
                                                            <input id="lblIdDepartamental" name="lblIdDepartamental" value="<?php echo $IdDepartamental; ?>" hidden="" />
                                                            <input id="lblCodUbigeoReniec" name="lblCodUbigeoReniec" value="<?php echo $CodUbigeoReniec; ?>" hidden="" />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblsims">PRIORIDAD SIMS: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input name="lblsims" class="form-control input-sm" id="lblsims" value="<?php echo $sims; ?>" style="width: 100%;" disabled />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lbldireccion">INTERIOR:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <textarea class="form-control input-sm" name="lblinterior" id="lblinterior" rows="1" style="resize:none" disabled><?php echo $Interior; ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lbldistrito" style="text-align:left;">REFERENCIA:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <textarea class="form-control input-sm" name="lblreferencia" id="lblreferencia" rows="1" style="resize:none" disabled><?php echo $Referencia;?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblmovil">TELEFONO UNO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="tel" class="form-control input-sm" name="lblmovil" id="lblmovil" value="<?php echo $movil;?>"  data-inputmask='"mask": "999999999"'  data-mask>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblfijo" style="text-align:left;">TELEFONO DOS:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="tel" class="form-control input-sm" name="lblfijo" id="lblfijo" value="<?php echo $fijo;?>" data-inputmask='"mask": "999999999"'  data-mask> 
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group <?php if($OrigenVisita=="FB_CAMERA_PROMO_TEST_INTERBANK_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_INTERBANK_m_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BCP_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BCP_m_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_OH_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_OH_m_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BBVA_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BBVA_m_cotizaciones"){ echo '';}else{echo 'ocultar';}?>" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblmovil">ORIGEN:></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <?php if($OrigenVisita=="FB_CAMERA_PROMO_TEST_BBVA_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BBVA_m_cotizaciones"){?>                                                            
                                                            <span class="labelBBVA" id="btnPromoBanco"><i class="fa fa-check"></i> PROMO BANCO BBVA</span>
                                                            <span style="color:red;white-space:normal"> Recordar que el pago de la instalación es con tarjeta BBVA </span>
                                                            <?php }if($OrigenVisita=="FB_CAMERA_PROMO_TEST_INTERBANK_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_INTERBANK_m_cotizaciones"){?>
                                                            <span class="labelInterbank" id="btnPromoBanco"><i class="fa fa-check"></i> PROMO BANCO INTERBANK</span>
                                                            <span style="color:red;white-space:normal"> Recordar que el pago de la instalación es con tarjeta INTERBANK </span>    
                                                            <?php }if($OrigenVisita=="FB_CAMERA_PROMO_TEST_BCP_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_BCP_m_cotizaciones"){?>
                                                            <span class="labelBCP" id="btnPromoBanco"><i class="fa fa-check"></i> PROMO BANCO BCP</span>
                                                            <span style="color:red;white-space:normal"> Recordar que el pago de la instalación es con tarjeta BCP </span>
                                                            <?php }if($OrigenVisita=="FB_CAMERA_PROMO_TEST_OH_cotizaciones" || $OrigenVisita=="FB_CAMERA_PROMO_TEST_OH_m_cotizaciones"){?>
                                                            <span class="labelOH" id="btnPromoBanco"><i class="fa fa-check"></i> PROMO FINANCIERA OH</span>
                                                            <span style="color:red;white-space:normal"> Recordar que el pago de la instalación es con tarjeta OH </span>
                                                            <?php }?>
                                                            <input type="hidden" id="OrigenVisita" value="<?php echo $OrigenVisita;?>">  
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div>
                                                <h5 class="subtitulo">INFORMACION SCORING</h5>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblresultadoScoring">RESULTADO SCORING:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" name="lblresultadoScoring" id="lblresultadoScoring" disabled>
                                                                <option value="" disabled selected>Seleccione</option>
                                                                <option value="Especial"><?php echo ($tipoventa=='RE' && $resultadoPrecioBomba=='NO')?'Oferta RE':'Oferta especial'; ?></option>
                                                                <option value="Oferta"><?php echo ($tipoventa=='RE' && $resultadoPrecioBomba=='NO')?'Oferta RE':'Oferta'; ?></option>
                                                                <option value="Limitada">Oferta limitada</option>
                                                                <option value="Extraordinaria"><?php echo ($tipoventa=='RE' && $resultadoPrecioBomba=='NO')?'Oferta RE':'Oferta extraordinaria'; ?></option>
                                                                <option value="Unica">Oferta unica</option>
                                                            </select>
                                                            <input type="hidden" id="valresultadoScoring" value="<?php echo $ScoringRP; ?>">
                                                            <input type="hidden" id="valcodigoOperacionScoring" value="<?php echo $CodigoOperacionScoring; ?>">
                                                            <input type="hidden" id="IdDocRP" value="<?php echo $IdDocRP; ?>">
                                                            <input type="hidden" id="valPrecioBomba" value="<?php echo $resultadoPrecioBomba; ?>">
                                                            <input type="hidden" id="NombresScoring" name="NombresScoring" value="<?php echo $NombresScoring;?>"/>
                                                            <input type="hidden" id="ApellidoPaternoScoring" name="ApellidoPaternoScoring" value="<?php echo $ApellidoPaternoScoring;?>"/>
                                                            <input type="hidden" id="ApellidoMaternoScoring" name="ApellidoMaternoScoring" value="<?php echo $ApellidoMaternoScoring;?>"/>
                                                            <input type="hidden" id="TipoDocumentoScoring" name="TipoDocumentoScoring" value="<?php echo $TipoDocumentoScoring;?>"/>
                                                            <input type="hidden" name="lbldocumentoscoring" id="lbldocumentoscoring" value="<?php echo $DocumentoScoring;?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6 scoring">
                                                    <div class="form-group">
                                                        <div class="col-sm-6 col-xs-6">
                                                            <button type="button" class="btn btn-danger btn-block btn-sm" id="btnModalconsultascoring" data-toggle="modal" data-target="#modal-consultascoring"><i class="fa fa-cog"></i> SCORING</button>
                                                        </div>
                                                        <div class="col-sm-6 col-xs-6">
                                                            <button type="button" class="btn btn-default btn-block btn-sm" id="logconsultadoc" data-toggle="modal" data-target="#modal-logdni"><i class="fa fa-pencil-square-o"></i> CONSULTAS DOC.</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div>
                                                <h5 class="subtitulo">INFORMACION REFERIDO</h5>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="referidoHabilitado">¿CLIENTE BRINDÓ REFERIDO?:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" name="referidoHabilitado" id="referidoHabilitado">
                                                                <option value="" disabled selected>Seleccione</option>
                                                                <option value="SI" <?php if ($referidoHabilitado == "SI") {echo "selected";}?>>SI</option>
                                                                <option value="NO"<?php if ($referidoHabilitado == "NO") {echo "selected";}?>>NO</option>
                                                            </select>
                                                            <input type="hidden" name="hidreferidoHabilitado" id="hidreferidoHabilitado" value="<?php echo $referidoHabilitado; ?>"/>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="cantidadreferidoHabilitado" style="text-align:left;">CANTIDAD REFERIDO: </label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <input type="text" class="form-control" id="cantidadreferidoHabilitado" name="cantidadreferidoHabilitado" value="<?php echo $cantidadreferido;?>"  readonly>
                                                                <div class="input-group-addon">
                                                                    <i class="fa fa-repeat actualizarcantidadref" style="cursor: pointer;"></i> <span class="actualizarcantidadref" style="cursor: pointer;"> Actualizar # Referidos</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group datosreferidoHabilitado <?php if($referidoHabilitado=="SI"){echo '';} else{echo 'ocultar';}?>" style="margin-bottom: 0px;">
                                                <div class="col-sm-12 col-md-12">
                                                    <div class="form-group">
                                                        <label class="col-sm-2 col-xs-4 control-label " style="text-align:left;" for="urlreferidoHabilitado">URL:</label>
                                                        <div class="col-sm-10 col-xs-8">
                                                            <div class="input-group">
                                                                <input type="text" class="form-control" id="urlreferidoHabilitado" name="urlreferidoHabilitado" value="<?php echo 'https://clientesverisure.com/apps/referidos/create/'.$idprospectorp.'/'.$matricula.'/'.$tipoventa.'/'.explode( '/', $cliente)[0].'/'.$correo;?>" readonly>
                                                                <div class="input-group-addon">
                                                                    <i class="fa fa-copy copiarurl" style="cursor: pointer;"></i>
                                                                </div>
                                                                <div class="input-group-addon">
                                                                    <i class="fa fa-external-link irurl" style="cursor: pointer;"></i>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div>
                                                <h5 class="subtitulo">DATOS DE LA OFERTA</h5>
                                                <input type="hidden" id="datosGeneral" value='<?php echo $DetalleGeneral; ?>'>
                                                <input type="hidden" id="datosExtras" value='<?php echo $DetalleExtras; ?>'>
                                                <input type="hidden" id="datosRegalos" value='<?php echo $DetalleRegalos; ?>'>
                                                
                                                <input type="hidden" id="idVenta" value='<?php echo $idventa; ?>'>
                                                <input type="hidden" id="estadoVenta" value='<?php echo $estadoventa; ?>'>
                                                <input type="hidden" id="categoriaVenta" value='<?php echo $categoriaventa; ?>'>
                                                <input type="hidden" id="tipoVenta" value='<?php echo $tipoventa; ?>'>
                                                <input type="hidden" id="matriculaUsuario" value='<?php echo $matriculausuario; ?>'>
                                                <input type="hidden" id="idProspectoRp" value='<?php echo $idprospectorp; ?>'>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblobservacion">GGCC:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="checkbox" name="GGCC" id="GGCC" <?php if($GGCC=="SI"){echo 'checked';} else{echo '';}?> data-size="small"/>
                                                            <input type="hidden" name="hidGGCC" id="hidGGCC" value="<?php echo $GGCC; ?>"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- DIV ESTADO DE VENTAS Y RECURSO -->
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblestadoventa">ESTADO VENTA: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select name="lblestadoventa" id="lblestadoventa" class="form-control input-sm">
                                                                <option>Seleccione</option>
                                                                <?php 
                                                                    if ($estadoventa == "ProspectoRP" || $estadoventa == "VAsignada" || $estadoventa == "PendienteData" || $estadoventa == "PendienteAgenda" || $estadoventa == "AgendadaDEL" || $estadoventa == "InstaladaDEL"  || $estadoventa == "NoVendida" || $estadoventa == "Cancelada" || $estadoventa == "NoInstalada"){
                                                                    ?>
                                                                <option value="ProspectoRP"<?php if ($estadoventa == "ProspectoRP") {echo "selected";}?> hidden="">ProspectoRP</option>
                                                                <option value="VAsignada"<?php if ($estadoventa == "VAsignada") {echo "selected";}?> hidden="">VAsignada</option>
                                                                <option value="PendienteData"<?php if ($estadoventa == "PendienteData") {echo "selected";}?> hidden="">PendienteData</option>
                                                                <option value="PendienteAgenda"<?php if ($estadoventa == "PendienteAgenda") {echo "selected";}?>hidden="">PendienteAgenda</option>
                                                                <option value="AgendadaDEL"<?php if ($estadoventa == "AgendadaDEL") {echo "selected";}?>>AgendadaDEL</option>
                                                                <option value="InstaladaDEL"<?php if ($estadoventa == "InstaladaDEL") {echo "selected";}?>>InstaladaDEL</option>
                                                                <option value="AgendadaTEC"<?php if ($estadoventa == "AgendadaTEC") {echo "selected";}?> hidden="">AgendadaTEC</option>
                                                                <option value="NoVendida"<?php if ($estadoventa == "NoVendida") {echo "selected";}?> hidden="">NoVendida</option>
                                                                <option value="Cancelada"<?php if ($estadoventa == "Cancelada") {echo "selected";}?> hidden="" disabled="disabled">Cancelada</option>
                                                                <option value="NoInstalada" <?php if ($estadoventa == "NoInstalada") {echo "selected";} ?> hidden="">NoInstalada</option>
                                                                <?php
                                                                    }if ($estadoventa == "AgendadaTEC"){
                                                                    ?>
                                                                <option value="AgendadaTEC"<?php if ($estadoventa == "AgendadaTEC") {echo "selected";}?> hidden="">AgendadaTEC</option>
                                                                <option value="PendienteAgenda"<?php if ($estadoventa == "PendienteAgenda") {echo "selected";}?> hidden="">PendienteAgenda</option>
                                                                <option value="AgendadaDEL"<?php if ($estadoventa == "AgendadaDEL") {echo "selected";}?> hidden="">AgendadaDEL</option>
                                                                <option value="InstaladaDEL"<?php if ($estadoventa == "InstaladaDEL") {echo "selected";}?> hidden="">InstaladaDEL</option>
                                                                <?php
                                                                    }
                                                                    if ($estadoventa == "Instalada"){
                                                                    ?>
                                                                <option value="Instalada"<?php if ($estadoventa == "Instalada") {echo "selected";}?>>Instalada</option>
                                                                <?php
                                                                    }
                                                                     if ($estadoventa == "IncidenciaAuditoria") {
                                                                    ?>
                                                                <option value="IncidenciaAuditoria" <?php if ($estadoventa == "IncidenciaAuditoria") {
                                                                    echo "selected";
                                                                    } ?>>IncidenciaAuditoria</option>
                                                                <?php
                                                                    }                                                                                 
                                                                    if ($estadoventa == "Facturada" || $estadoventa == "PorFacturar"){
                                                                    ?>
                                                                <option value="Facturada"<?php if ($estadoventa == "Facturada") {echo "selected";}?> hidden="" disabled="disabled">Facturada</option>
                                                                <option value="PorFacturar"<?php if ($estadoventa == "PorFacturar") {echo "selected";}?> hidden="">PorFacturar</option>
                                                                <?php 
                                                                    }if ($estadoventa == "Incidencia" || $estadoventa == "IncidenciaGestCorreo" || $estadoventa == "IncidenciaGestValija"){
                                                                    ?>
                                                                <option value="Incidencia"<?php if ($estadoventa == "Incidencia") {echo "selected";}?> hidden="" disabled="disabled">Incidencia</option>
                                                                <option value="IncidenciaGestCorreo"<?php if ($estadoventa == "IncidenciaGestCorreo") {echo "selected";}?>>IncidenciaGestCorreo</option>
                                                                <option value="IncidenciaGestValija"<?php if ($estadoventa == "IncidenciaGestValija") {echo "selected";}?>>IncidenciaGestValija</option>
                                                                <?php
                                                                    }if ($estadoventa == "Ilocalizable"){
                                                                    ?>
                                                                <option value="PendienteData"<?php if ($estadoventa == "PendienteData") {echo "selected";}?> hidden="">PendienteData</option>
                                                                <option value="PendienteAgenda"<?php if ($estadoventa == "PendienteAgenda") {echo "selected";}?> hidden="">PendienteAgenda</option>
                                                                <option value="AgendadaDEL"<?php if ($estadoventa == "AgendadaDEL") {echo "selected";}?>>AgendadaDEL</option>
                                                                <option value="InstaladaDEL"<?php if ($estadoventa == "InstaladaDEL") {echo "selected";}?>>InstaladaDEL</option>
                                                                <option value="Ilocalizable"<?php if ($estadoventa == "Ilocalizable") {echo "selected";}?> hidden="">Ilocalizable</option>
                                                                <?php 
                                                                    }if ($estadoventa == "Inviable"){
                                                                    ?>
                                                                <option value="PendienteData"<?php if ($estadoventa == "PendienteData") {echo "selected";}?> hidden="">PendienteData</option>
                                                                <option value="PendienteAgenda"<?php if ($estadoventa == "PendienteAgenda") {echo "selected";}?>>PendienteAgenda</option>
                                                                <option value="AgendadaDEL"<?php if ($estadoventa == "AgendadaDEL") {echo "selected";}?> hidden="">AgendadaDEL</option>
                                                                <option value="InstaladaDEL"<?php if ($estadoventa == "InstaladaDEL") {echo "selected";}?>>InstaladaDEL</option>
                                                                <option value="Inviable"<?php if ($estadoventa == "Inviable") {echo "selected";}?> >Inviable</option>
                                                                <?php 
                                                                    }
                                                                    if ($estadoventa == "NoDoc"|| $estadoventa == "DocEnvi"){
                                                                    ?>
                                                                <option value="NoDoc"<?php if ($estadoventa == "NoDoc") {echo "selected";}?> hidden="" disabled="disabled">NoDoc</option>
                                                                <option value="DocEnvi"<?php if ($estadoventa == "DocEnvi") {echo "selected";}?>>DocEnvi</option>
                                                                <?php
                                                                    }
                                                                    ?>
                                                                <option value="NoVendida"<?php if ($estadoventa == "NoVendida") {echo "selected";}?> hidden="">NoVendida</option>
                                                            </select>
                                                            <input id="lblestventa" name="lblestventa" value="<?php echo $estadoventa; ?>" hidden="" />
                                                            <input id="lblestvisita" name="lblestvisita" value="<?php echo $estadovisita; ?>" hidden=""  />
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltipoventa">RECURSO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select name="lbltipoventa" id="lbltipoventa" class="form-control input-sm" disabled>
                                                                <option>Seleccione</option>
                                                                <option value="RE"<?php if ($tipoventa == "RE") {echo "selected";}?>>RE</option>
                                                                <option value="RP"<?php if ($tipoventa == "RP") {echo "selected";}?>>RP</option>
                                                                <option value="RPPA"<?php if ($tipoventa == "RPPA") {echo "selected";}?>>RPPA</option>
                                                                <option value="RPPR"<?php if ($tipoventa == "RPPR") {echo "selected";}?>>RPPR</option>
                                                                <option value="RPTMK"<?php if ($tipoventa == "RPTMK") {echo "selected";}?>>RPTMK</option>
                                                                <option value="RPMKT"<?php if ($tipoventa == "RPMKT") {echo "selected";}?>>RPMKT</option>
                                                            </select>
                                                            <input id="lbltiventa" name="lbltiventa" value="<?php echo $tipoventa;?>"  hidden="" />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblmesesautorizados">MESES AUTORIZADOS:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="number" maxlength="3" class="form-control input-sm" id="lblmesesautorizados" name="lblmesesautorizados"  value="<?php if($mesesautorizados==''){echo '0.00';}else{ echo $mesesautorizados;}?>" onkeypress="return filterFloat(event, this);" readonly>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">N° PROSPECTO:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="text" class="form-control input-sm" name="lblnprospecto" id="lblnprospecto" data-inputmask='"mask": "999999"' value="<?php echo $nprospecto;?>" data-mask>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- TIPO DE KIT -->
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblncontrato">N° CONTRATO:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="text" class="form-control input-sm" name="lblncontrato" id="lblncontrato" data-inputmask='"mask": "9999999"' value="<?php echo $ncontrato;?>" data-mask>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltipokit">TIPO KIT:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" id="lbltipokit" name="lbltipokit">
                                                                <option value="" disabled selected>Seleccione</option>
                                                                <option value="Basico" <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':''; ?>>BASICO</option>
                                                                <option value="ZeroVision">ZEROVISION</option>
                                                                <option value="Reconexion" <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':''; ?>>RECONEXION</option>
                                                                <option value="Camara" <?php echo ($dc == "154" || $dc == "157" || $dc == "158" || $matriculausuario=='MGR200')?'hidden disabled':'hidden disabled'; ?> >CAMARA</option>
                                                                <option value="High Security" <?php echo ($dc == "154" || $dc == "157" || $dc == "158" || $matriculausuario=='MGR200')?'hidden disabled':'hidden disabled'; ?>>HIGH SECURITY</option>
                                                                <option value="Basico PRO" <?php if ($TipoKIT == 'Basico PRO') {
                        															echo 'selected';
                        															} ?> <?php echo ($dc == "150" || $dc == "154" || $dc == "158" || $dc == "151" || $dc == "152" || $dc == "153" || $dc == "155" || $dc == "156" || $dc == "157" || $dc == "159" || $dc == "251" || $dc == "252" || $dc == "513")?'':'hidden disabled'; ?>>BASICO PRO</option>
                                                                <option value="ZeroVision PRO" <?php if ($TipoKIT == 'ZeroVision PRO') {
                        															echo 'selected';
                        															} ?> <?php echo ($dc == "150" || $dc == "154" || $dc == "158" || $dc == "151" || $dc == "152" || $dc == "153" || $dc == "155" || $dc == "156" || $dc == "157" || $dc == "159" || $dc == "251" || $dc == "252" || $dc == "513" || $dc == "701" || $dc == "702" || $dc == "601" || $dc == "602")?'':'hidden disabled'; ?>>ZEROVISION PRO</option>
                                                                <option value="ZeroVision LA CURACAO" <?php if ($TipoKIT == 'ZeroVision LA CURACAO') {
                        															echo 'selected';
                        															} ?> <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':'hidden disabled'; ?>>ZEROVISION LA CURACAO</option>                        										
                        										<option value="ZeroVision PRO LA CURACAO" <?php if ($TipoKIT == 'ZeroVision PRO LA CURACAO') {
                        															echo 'selected';
                        															} ?> <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':'hidden disabled'; ?>>ZEROVISION PRO LA CURACAO</option>
                                                                <option value="Basico LA CURACAO" <?php if ($TipoKIT == 'Basico LA CURACAO') {
                        															echo 'selected';
                        															} ?> <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':'hidden disabled'; ?>>BASICO LA CURACAO</option>                        										
                        										<option value="Basico PRO LA CURACAO" <?php if ($TipoKIT == 'Basico PRO LA CURACAO') {
                        															echo 'selected';
                        															} ?> <?php echo ($dc == "701" || $dc == "702")?'hidden disabled':'hidden disabled'; ?>>BASICO PRO LA CURACAO</option>                        															
                                                            </select>
                                                            <input type="hidden" id="valtipokit" value="<?php echo $TipoKIT; ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- PILOTO DE ARLO-->
                                            <div class="form-group camaraarlo <?php if ($TipoCamaraKit == '' || $TipoCamaraKit == null) {
                                                echo 'ocultar';
                                                } ?>" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltipocamarakit">TIPO CÁMARA KIT:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" id="lbltipocamarakit" name="lbltipocamarakit">
                                                                <option value="" disabled selected>Seleccione</option>
                                                                <option value="Camara Interna" >CAMARA INTERNA</option>
                                                                <option value="Camara Externa" >CAMARA EXTERNA</option>
                                                            </select>
                                                            <input type="hidden" id="valtipocamarakit" value="<?php echo $TipoCamaraKit; ?>">                                                        
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- CARRITO DE COMPRA-->
                                            <div class="row">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblPAI">PAI:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" name="lblPAI" id="lblPAI">
                                                                <option>Seleccione</option>
                                                                <!-- <option value="BBVA-DIN"<?php //if ($PAI == "BBVA-DIN") {echo "selected";}?>>BBVA-DIN</option> -->
        														 <option value="PAI 30x36"<?php if ($PAI == "PAI 30x36") {echo "selected";}?> hidden>PAI 30x36</option>
        														 <option value="PAI 30x48"<?php if ($PAI == "PAI 30x48") {echo "selected";}?> >PAI 30x48</option>
        													                                                              
                                                                <option value="NO"<?php if ($PAI == "NO") {echo "selected";}?>>NO</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="">CATEGORIA PRECIO:</label>    
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" id="lblcategoriaprecio" name="lblcategoriaprecio">
                                                                <option value="" disabled selected>Seleccione</option>
                                                            </select>
                                                            <input type="hidden" id="hidCategoriaPrecio" value="<?php echo $CategoriaPrecio; ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblpreciokit">PRECIO KIT:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="">S/.</i>
                                                                </div>
                                                                <input type="number" class="form-control input-sm" name="lblpreciokit" id="lblpreciokit" value="<?php echo $preciokit;?>" onkeypress="return filterFloat(event, this);">
                                                                <input type="hidden" id="precioKit__MIN">
                                                                <input type="hidden" id="precioKit__MAX">
                                                                <input type="hidden" id="hidPrecioKit" value="<?php echo $preciokit;?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblclosingpack">CLOSING PACK:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" name="lblclosingpack" id="lblclosingpack">
                                                                <option value="" disabled selected>Seleccione</option>
                                                                <option value="Ninguno">Ninguno</option>
                                                            </select>
                                                            <input type="hidden" id="valclosingpack" value="<?php echo $ClosingPack; ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group mostrarEtiqueta <?php echo $mostrarEtiqueta; ?>">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblpreciokit">DESCUENTO CUOTA:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" id="lblDescuentoCuota" name="lblDescuentoCuota">
                                                                <option value="" disabled selected>Seleccione</option>
                                                                <option value="ninguno" <?php if($dsctCuota == 'ninguno' || $dsctCuota == ''){echo 'selected'; } ?>>Ninguno</option>
                                                                <option value="1mes"  <?php if($dsctCuota == '1mes'){echo 'selected'; } ?>>50% DESCUENTO 1 MES</option>
                                                                <option value="2meses"  <?php if($dsctCuota == '2meses'){echo 'selected'; } ?>>50% DESCUENTO 2 MESES</option>
                                                                <option value="3meses"  <?php if($dsctCuota == '3meses'){echo 'selected'; } ?> hidden>50% DESCUENTO 3 MESES</option>
                                                            </select>
                                                            <input type="hidden" value="<?php echo $dsctCuota; ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblRenove">RENOVE</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" id="lblRenove" name="lblRenove">
                                                                <option value="" disabled selected>Seleccione</option>
                                                                <option value="SI" <?php if($lblRenove == 'SI'){echo 'selected'; } ?>>SI</option>
                                                                <option value="NO" <?php if($lblRenove == 'NO'){echo 'selected'; } ?>>NO</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>                                                
                                            </div>
                                            <div class="row" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblRcompetencia">COMPETENCIA</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" id="lblRcompetencia" name="lblRcompetencia">
                                                                <option value="" disabled selected>Seleccione</option>
                                                                <option value="Prosegur" <?php if($lblRcompetencia == 'Prosegur'){echo 'selected'; } ?>>Prosegur</option>
                                                                <option value="Boxer Alarmas" <?php if($lblRcompetencia == 'Boxer Alarmas'){echo 'selected'; } ?>>Boxer Alarmas</option>
                                                                <option value="Mapfre" <?php if($lblRcompetencia == 'Mapfre'){echo 'selected'; } ?>>Mapfre</option>
                                                                <option value="Liderman" <?php if($lblRcompetencia == 'Liderman'){echo 'selected'; } ?>>Liderman</option>
                                                                <option value="Qido" <?php if($lblRcompetencia == 'Qido'){echo 'selected'; } ?>>Qido</option>
                                                                <option value="Otros" <?php if($lblRcompetencia == 'Otros'){echo 'selected'; } ?>>Otros</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblRvencimiento">FECHA VENCIMIENTO</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                           <input type="text" class="form-control pull-right input-sm readonly_blanco" id="lblRvencimiento" value="<?php echo $lblRvencimiento; ?>"  name="lblRvencimiento" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask readonly="readonly">
                                                        </div>
                                                    </div>
                                                </div>                                                
                                            </div>                                             
                                            <div class="row">
                                                <div class="col-sm-6 col-md-6">
                                                    <button type="button" class="btn btn-danger" style="margin-bottom: 15px; width: 100%" id="generarExtras">EXTRAS</button>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <button type="button" class="btn btn-danger" style="margin-bottom: 15px; width: 100%" id="generarRegalos">REGALOS</button>
                                                </div>
                                            </div>
                                            <!-- END CARRITO -->
                                            <!-- PRECIO KIT (OK) Y TOTAL EXTRA DEPRECATED -->
                                            <!-- RESUMEN INST Y REGALO AUTORIZADO DEPRECATED -->
                                            <!-- CLOSING PACK Y PRECIO ESPECIAL DEPRECATED -->
                                            <!-- CANTIDAD EXTRAS Y FORMA DE PAGO-->
                                            <!-- 590 -->
                                            <!-- PAI Y HOJA DE CERTIFICACION -->
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblCantExtras">CANTIDAD EXTRAS:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="number" class="form-control input-sm" id="lblCantExtras" name="lblCantExtras" min="0" value="<?php if($CantidadExtras == '' || $CantidadExtras == null){echo '0'; } else {echo $CantidadExtras;} ?>" disabled>       
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltotalextra">TOTAL EXTRA:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="">S/.</i>
                                                                </div>
                                                                <input type="number" class="form-control input-sm" name="lbltotalextra" id="lbltotalextra" value="<?php if($totalextra == '' || $totalextra == null){echo '0'; } else {echo $totalextra;} ?>" onkeypress="return filterFloat(event, this);" disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblCantRegalos">CANTIDAD REGALOS:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="number" class="form-control input-sm col-md-8" id="lblCantRegalos" name="lblCantRegalos" min="0" value="<?php if($CantidadRegalo == '' || $CantidadRegalo == null){ echo '0';} else { echo $CantidadRegalo; } ?>" disabled>       
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltotalcuota">TOTAL CUOTA:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="">S/.</i>
                                                                </div>
                                                                <input type="number" class="form-control input-sm" name="lbltotalcuota" id="lbltotalcuota" value="<?php if($TotalCuotaMonitoreo == '' || $TotalCuotaMonitoreo == null){ echo '0';} else { echo $TotalCuotaMonitoreo; } ?>" onkeypress="return filterFloat(event, this);" disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblresumenventa">RESUMEN INST.:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <textarea class="form-control input-sm" name="lblresumenventa" id="lblresumenventa" rows="2" style="resize:none"  placeholder="Ingresar..." disabled><?php echo $resumenventa;?></textarea> 
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div>
                                                <div class="col-sm-6 col-md-6 ocultar">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblextraautorizado">REGALO AUTORIZADO:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" name="lblextraautorizado" id="lblextraautorizado">
                                                                <option>Seleccione</option>
                                                                <option value="Ninguno"<?php if ($regaloutorizado == "Ninguno") {echo "selected";}?>>Ninguno</option>
                                                                <option value="Mando a distancia"<?php if ($regaloutorizado == "Mando a distancia") {echo "selected";}?>>Mando a distancia</option>
                                                                <option value="Magnetico"<?php if ($regaloutorizado == "Magnetico") {echo "selected";}?>>Magnetico</option>
                                                                <option value="Pulsador"<?php if ($regaloutorizado == "Pulsador") {echo "selected";}?>>Pulsador</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">590:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input type="text" class="form-control pull-right input-sm"  id="mesano" data-role="date" value="<?php if(isset($n590)){ echo $n590;}else{echo $fechames;}?>" name="lbl590" readonly="readonly" >
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="HCertificacion">HOJA CERTIFICACIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="checkbox" name="HCertificacion" id="HCertificacion" <?php if($HojaCertificacion=="SI"){echo 'checked';}else{echo '';}?> data-size="small"/>
                                                            <input type="hidden" name="hidden_HCertificacion" id="hidden_HCertificacion" value="<?php echo $HojaCertificacion; ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /.box-body -->
                                </div>
                                <!-- INFORMACION DE LA AGENDA -->
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                        <h5>INFORMACION DE AGENDA</h5>
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                        <div class="form-horizontal">
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">INSTALADOX: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" name="lblinstaladox" id="lblinstaladox">
                                                                <option>Seleccione</option>
                                                                <option value="TEC"<?php if ($instaladox == "TEC") {echo "selected";}?>>TEC</option>
                                                                <option value="DEL"<?php if ($instaladox == "DEL") {echo "selected";}?>>DEL</option>
                                                            </select>
                                                            <input id="lblidagenda" name="lblidagenda" value="<?php echo $idagenda;?>" hidden=""> 
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">TÉCNICO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select name="lbltecnico" id="lbltecnico" class="form-control cbxtecnico input-sm" style="width: 100%;">
                                                            <?php echo $html_tecnico;?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">F.INSTALACIÓN: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group" id="fi">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input type="text" class="form-control pull-right input-sm readonly_blanco" id="fechainst" value="<?php echo $fechainstalacionver;?>"  name="lblfinstalacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask readonly="readonly">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">H.INSTALACIÓN: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="bootstrap-timepicker timepicker">
                                                                <div class="input-group">
                                                                    <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhinstalacion" id="horainst" value="<?php echo $horainstalacionver;?>" >
                                                                    <div class="input-group-addon input-sm">
                                                                        <i class="fa fa-clock-o"></i>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">COMENTARIO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <textarea class="form-control input-sm" name="lblcomentarioagenda" id="lblcomentarioagenda" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo utf8_encode($comentarioagenda);?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="logcambios">LOG CAMBIOS: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <a class="btn btn-danger btn-sm"  href="#" data-toggle="modal" id="logcambios" data-target="#modal-default"><i class="fa fa-pencil-square-o"></i> Log Cambios</a>
                                                            <input type="hidden" name="lblIteraccionAttec" value="<?php echo $IteraccionAttec; ?>" id="lblIteraccionAttec" />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;display:none;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblrepercucion">REPERCUCIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <textarea class="form-control input-sm" name="lblrepercucion" id="lblrepercucion" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $repercucion;?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6" id="tinviable">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinviable">MOTIVO INVIABLE:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <textarea class="form-control input-sm" name="lblinviable" id="lblinviable" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo utf8_encode($motivoinviable);?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6" id="tcancelado">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcancelado">MOTIVO CANCELADO:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <textarea class="form-control input-sm" name="lblcancelado" id="lblcancelado" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $motivocancelado;?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /.box-body -->
                                </div>
                                <!-- INFORMACION DE AUDITORIA -->
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                        <h5>INFORMACION DE ATTEC</h5>
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                        <div class="form-horizontal" style="margin: 15px;">
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechaautidoria">FECHA AUDITORÍA:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input type="text" class="form-control pull-right input-sm" id="lblfechaautidoria" value="<?php echo $FechaAuditoria; ?>" name="lblfechaautidoria" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblestadoattec">ESTADO ATTEC:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" name="lblestadoattec" id="lblestadoattec" disabled>
                                                                <option value="">Seleccione</option>
                                                                <option value="Observada" <?php if ($EstadoAttec == "Observada") {
                                                                    echo "selected";
                                                                    } ?>>Observada</option>
                                                                <option value="AuditadaOK" <?php if ($EstadoAttec == "AuditadaOK") {
                                                                    echo "selected";
                                                                    } ?> <?php if ($EstadoAttec == "Observada" || $EstadoAttec == "InstaladaSinAuditar") {
                                                                    echo "hidden";
                                                                    } ?> >AuditadaOK</option>
                                                                <option value="AuditadaResuelta" <?php if ($EstadoAttec == "AuditadaResuelta") {
                                                                    echo "selected";
                                                                    } ?> <?php if ($EstadoAttec == "" || $EstadoAttec == "AuditadaOK" || $EstadoAttec == "InstaladaSinAuditar") {
                                                                    echo "hidden";
                                                                    } ?> >AuditadaResuelta</option>
                                                                <option value="InstaladaSinAuditar" <?php if ($EstadoAttec == "InstaladaSinAuditar") {
                                                                    echo "selected";
                                                                    } ?><?php if ($EstadoAttec == "Observada") {
                                                                    echo "hidden";
                                                                    } ?>>InstaladaSinAuditar</option>
                                                                <option value="NoInstalada" <?php if ($EstadoAttec == "NoInstalada") {
                                                                    echo "selected";
                                                                    } ?>>NoInstalada</option>
                                                                <option value="Desmontaje" <?php if ($EstadoAttec == "Desmontaje") {
                                                                    echo "selected";
                                                                    } ?>>Desmontaje</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div>
                                                <h5 class="subtitulo" style="font-size: 12px; color:red">INCIDENCIAS (*):</h5>
                                            </div>
                                            <input type="hidden" id="datosFalloSupervision" value='<?php echo $FalloSupervision_Dispotivos; ?>'>
                                            <input type="hidden" id="datosTamper" value='<?php echo $Tamper_Dispotivos; ?>'>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="datossbn">DATOS SBN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="form-group" style="margin-bottom: 0px;">
                                                                <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                    <input type="checkbox" name="datossbn" id="datossbn" data-size="small" data-style="ios" <?php if ($DatosSbn == "SI") {
                                                                        echo 'checked';
                                                                        } else {
                                                                        echo '';
                                                                        } ?> disabled/>
                                                                    <input type="hidden" name="hidden_datossbn" id="hidden_datossbn" value="<?php if ($DatosSbn == "SI") {
                                                                        echo 'SI';
                                                                        } else {
                                                                        echo 'NO';
                                                                        } ?>">
                                                                </div>
                                                                <div class="col-lg-6 col-md-8 col-sm-8 col-xs-8 datossbn <?php if($DatosSbn == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                                    <select class="form-control input-sm" name="lbldatossbncorreccion" id="lbldatossbncorreccion" disabled>
                                                                        <option value="" disabled selected>NO COINCIDE</option>
                                                                        <option value="Direccion" <?php if ($DatosSbn_NoCoincide == "Direccion") {
                                                                            echo "selected";
                                                                            } ?>>Direccion</option>
                                                                        <option value="Distrito" <?php if ($DatosSbn_NoCoincide == "Distrito") {
                                                                            echo "selected";
                                                                            } ?>>Distrito</option>
                                                                        <option value="Segmento" <?php if ($DatosSbn_NoCoincide == "Segmento") {
                                                                            echo "selected";
                                                                            } ?>>Segmento</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6 <?php if($DatosSbn == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_datossbn">FECHA CORRECIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_datossbn" value="<?php echo $F_CorreccionDatosSbn; ?>" name="lblfechacorrecion_datossbn" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="imagen">IMAGEN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="form-group" style="margin-bottom: 0px;">
                                                                <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                    <input type="checkbox" name="imagen" id="imagen" data-size="small" data-style="ios" <?php if ($Imagen == "SI") {
                                                                        echo 'checked';
                                                                        } else {
                                                                        echo '';
                                                                        } ?> disabled/>
                                                                    <input type="hidden" name="hidden_imagen" id="hidden_imagen" value="<?php if ($Imagen == "SI") {
                                                                        echo 'SI';
                                                                        } else {
                                                                        echo 'NO';
                                                                        } ?>">
                                                                </div>
                                                                <div class="col-lg-6 col-md-8 col-sm-8 col-xs-8 imagen ocultar">
                                                                    <select class="form-control input-sm" name="lblimagen_motivo" id="lblimagen_motivo" disabled>
                                                                        <option value="" disabled selected>MOTIVO</option>
                                                                        <option value="Zona Abierta" <?php if ($Imagen_Motivo == "Zona Abierta") {
                                                                            echo "selected";
                                                                            } ?>>Zona Abierta</option>
                                                                        <option value="Enfoque Calle" <?php if ($Imagen_Motivo == "Enfoque Calle") {
                                                                            echo "selected";
                                                                            } ?>>Enfoque Calle</option>
                                                                        <option value="Sensor no fijado" <?php if ($Imagen_Motivo == "Sensor no fijado") {
                                                                            echo "selected";
                                                                            } ?>>Sensor no fijado</option>
                                                                        <option value="Sensor Obstruido" <?php if ($Imagen_Motivo == "Sensor Obstruido") {
                                                                            echo "selected";
                                                                            } ?>>Sensor Obstruido</option>
                                                                        <option value="Zona Inviable" <?php if ($Imagen_Motivo == "Zona Inviable") {
                                                                            echo "selected";
                                                                            } ?>>Zona Inviable</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6 <?php if($Imagen == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_imagen">FECHA CORRECIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_imagen" value="<?php echo $F_Imagen; ?>" name="lblfechacorrecion_imagen" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="segincorrecto">SEGMENTO INCORRECTO:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="form-group" style="margin-bottom: 0px;">
                                                                <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                    <input type="checkbox" name="segincorrecto" id="segincorrecto" data-size="small" data-style="ios" <?php if ($SegIncorrecto == "SI") {
                                                                        echo 'checked';
                                                                        } else {
                                                                        echo '';
                                                                        } ?> disabled/>
                                                                    <input type="hidden" name="hidden_segincorrecto" id="hidden_segincorrecto" value="<?php if ($SegIncorrecto == "SI") {
                                                                        echo 'SI';
                                                                        } else {
                                                                        echo 'NO';
                                                                        } ?>">
                                                                </div>
                                                                <div class="col-lg-6 col-md-8 col-sm-8 col-xs-8 segcorrecion <?php if($SegIncorrecto == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                                    <select class="form-control input-sm" name="lblsegmentocorreccion" id="lblsegmentocorreccion" disabled>
                                                                        <option value="" disabled selected>DEBE DECIR</option>
                                                                        <option value="RES" <?php if ($Seg_DebeDecir == "RES") {
                                                                            echo "selected";
                                                                            } ?>>RES</option>
                                                                        <option value="NEG" <?php if ($Seg_DebeDecir == "NEG") {
                                                                            echo "selected";
                                                                            } ?>>NEG</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6 <?php if($SegIncorrecto == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_segincorrecto">FECHA CORRECIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_segincorrecto" value="<?php echo $F_CorreccionSegIncorrecto; ?>" name="lblfechacorrecion_segincorrecto" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="tamper">TAMPER (MANIPULACIÓN):</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="checkbox" name="tamper" id="tamper" data-size="small" data-style="ios" <?php if ($Tamper == "SI") {
                                                                echo 'checked';
                                                                } else {
                                                                echo '';
                                                                } ?> disabled/>
                                                            <input type="hidden" name="hidden_tamper" id="hidden_tamper" value="<?php if ($Tamper == "SI") {
                                                                echo 'SI';
                                                                } else {
                                                                echo 'NO';
                                                                } ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6 <?php if($Tamper == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_datossbn">FECHA CORRECIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_tamper" value="<?php echo $F_CorreccionTamper; ?>" name="lblfechacorrecion_tamper" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group tamper <?php if ($Tamper == "SI") {echo '';} else { echo 'ocultar';} ?>" style="margin-bottom: 0px;">
                                                <div class="col-sm-2 col-md-2">
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="box-body">
                                                        <div class="row">
                                                            <div id="listaTamper" class="col-md-12">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="ingresoprogramacion">INGRESO A PROGRAMACIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="checkbox" name="ingresoprogramacion" id="ingresoprogramacion" data-size="small" data-style="ios" <?php if ($IngresoProgramacion == "SI") {
                                                                echo 'checked';
                                                                } else {
                                                                echo '';
                                                                } ?> disabled/>
                                                            <input type="hidden" name="hidden_ingresoprogramacion" id="hidden_ingresoprogramacion" value="<?php if ($IngresoProgramacion == "SI") {
                                                                echo 'SI';
                                                                } else {
                                                                echo 'NO';
                                                                } ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6 <?php if($IngresoProgramacion == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_ingresoprogramacion">FECHA CORRECIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_ingresoprogramacion" value="<?php echo $F_CorreccionIngresoProgramacion; ?>" name="lblfechacorrecion_ingresoprogramacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="hidden_falloscomunicacion">FALLOS DE COMUNICACIÓN (COBERTURA):</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="checkbox" name="falloscomunicacion" id="falloscomunicacion" data-size="small" data-style="ios" <?php if ($FallosCobertura == "SI") {
                                                                echo 'checked';
                                                                } else {
                                                                echo '';
                                                                } ?> disabled/>
                                                            <input type="hidden" name="hidden_falloscomunicacion" id="hidden_falloscomunicacion" value="<?php if ($FallosCobertura == "SI") {
                                                                echo 'SI';
                                                                } else {
                                                                echo 'NO';
                                                                } ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6 <?php if($FallosCobertura == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_falloscomunicacion">FECHA CORRECIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_falloscomunicacion" value="<?php echo $F_CorreccionFallosCobertura; ?>" name="lblfechacorrecion_falloscomunicacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="segincorrecto">ZERO VISION:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="form-group" style="margin-bottom: 0px;">
                                                                <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                    <input type="checkbox" name="zerovision" id="zerovision" data-size="small" data-style="ios" <?php if ($ZeroVision == "SI") {
                                                                        echo 'checked';
                                                                        } else {
                                                                        echo '';
                                                                        } ?> disabled />
                                                                    <input type="hidden" name="hidden_zerovision" id="hidden_zerovision" value="<?php if ($ZeroVision == "SI") {
                                                                        echo 'SI';
                                                                        } else {
                                                                        echo 'NO';
                                                                        } ?>">
                                                                </div>
                                                                <div class="col-lg-6 col-md-8 col-sm-8 col-xs-8 zerovisioncorrecion <?php if($ZeroVision == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                                    <select class="form-control input-sm" name="lblzerovisioncorreccion" id="lblzerovisioncorreccion" disabled>
                                                                        <option value="" disabled selected>MOTIVO</option>
                                                                        <option value="Panel Apagado" <?php if ($Zerovision_motivo == "Panel Apagado") {
                                                                            echo "selected";
                                                                            } ?>>Panel Apagado</option>
                                                                        <option value="Mising Test" <?php if ($Zerovision_motivo == "Mising Test") {
                                                                            echo "selected";
                                                                            } ?>>Mising Test</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6 <?php if($ZeroVision == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_datossbn">FECHA CORRECIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_zerovision" value="<?php echo $F_CorreccionZeroVision; ?>" name="lblfechacorrecion_zerovision" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">FALLO DE SUPERVISION:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="checkbox" name="fallosupervision" id="fallosupervision" data-size="small" data-style="ios" <?php if ($FalloSupervision == "SI") {
                                                                echo 'checked';
                                                                } else {
                                                                echo '';
                                                                } ?> disabled/>
                                                            <input type="hidden" name="hidden_fallosupervision" id="hidden_fallosupervision" value="<?php if ($FalloSupervision == "SI") {
                                                                echo 'SI';
                                                                } else {
                                                                echo 'NO';
                                                                } ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6 <?php if($FalloSupervision == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_fallosupervision">FECHA CORRECIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_fallosupervision" value="<?php echo $F_CorreccionFalloSupervision; ?>" name="lblfechacorrecion_fallosupervision" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled/>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group fallosupervision <?php if ($FalloSupervision == "SI") { echo '';} else {echo 'ocultar';} ?>" style="margin-bottom: 0px;">
                                                <div class="col-sm-2 col-md-2">
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="box-body">
                                                        <div class="row">
                                                            <div id="listaFalloSupervision" class="col-md-12">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">MISSING TEST:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="checkbox" name="missingtest" id="missingtest" data-size="small" data-style="ios" <?php if ($MissingTest == "SI") {
                                                                echo 'checked';
                                                                } else {
                                                                echo '';
                                                                } ?> disabled/>
                                                            <input type="hidden" name="hidden_missingtest" id="hidden_missingtest" value="<?php if ($MissingTest == "SI") {
                                                                echo 'SI';
                                                                } else {
                                                                echo 'NO';
                                                                } ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6 <?php if($MissingTest == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_missingtest">FECHA CORRECIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_missingtest" value="<?php echo $F_CorreccionMissingTest; ?>" name="lblfechacorrecion_missingtest" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-12 col-md-12">
                                                    <div class="form-group">
                                                        <label class="col-md-2 col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblplantillacomentario"><span style="color:#2c3b41"> <i class="fa fa-fw fa-info"></i>COMENTARIO:</span></label>
                                                        <div class="col-md-10 col-sm-8 col-xs-8">
                                                            <textarea class="form-control input-sm" name="lblplantillacomentario" id="lblplantillacomentario" rows="4" style="resize:none" placeholder="Ingresar..." disabled><?php echo utf8_encode($ComentarioAttec); ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /.box-body -->
                                </div>
                                <!-- INFORMACION DE CERTIFICACION DE VENTA -->
                            <div class="box box-custom">
                                <input type="hidden" id="idcertventa" value="<?php if (isset($idcertventa)) {
                                                                                    echo $idcertventa;
                                                                                } else {
                                                                                } ?>">
                                <input type="hidden" id="lblpermiso" value="<?php echo $nombacceso; ?>">
                                <input type="hidden" id="FechaPendiente" value="<?php echo $FechaPendiente; ?>">
                                <input type="hidden" id="FechaPrimeraGestion" value="<?php echo $FechaPrimeraGestion; ?>">
                                <input type="hidden" id="FechaFinalizadoconIncidencia" value="<?php echo $FechaFinalizadoconIncidencia; ?>">
                                <input type="hidden" id="FechaResuelto" value="<?php echo $FechaResuelto; ?>">
                                

                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                    <h5>INFORMACION DE CERTIFICACIÓN VENTA</h5>

                                    <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>

                                    </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                    <div class="form-horizontal">

                                    <div class="box box-custom">
                                    
                                        <div class="box-header with-border">
                                            <label class="col-sm-4 col-xs-4 subtitulo" style="text-align:left;font-size: 12px;" for="">RESUMEN VENTAS:</label>
                                        </div>
                                        <!-- /.box-header -->
                                    <div class="box-body">
                                     <div class="form-horizontal" style="padding: 20px;">                                        
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblasignado">MATRICULA ASIGNADA:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control selectgestor input-sm" name="lblasignado" id="lblasignado" style="width: 100%;" disabled="disabled">
													        <?php echo $htmlGestor;?>></php>
													        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechaapertura_cert">FECHA DE ASIGNACIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group" id="fi">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechaapertura_cert" value="<?php echo $FechaApertura; ?>" name="lblfechaapertura_cert" disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>                                              
                                        </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
        
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltipocierre_cert">ESTADO DE CERTIFICACIÓN:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <input type="text" class="form-control pull-right input-sm" id="lbltipocierre_cert" value="<?php echo $TipoCierre; ?>" name="lbltipocierre_cert" disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblsolucionincidencia_cert"><span class="motivocierretc">ESTADO DE INCIDENCIA</span></label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <input type="text" class="form-control pull-right input-sm" id="lblsolucionincidencia_cert" value="<?php echo $SolucionIncidencia; ?>" name="lblsolucionincidencia_cert" disabled>
                                                            </div>
                                                        </div>
                                                    </div>                                            
                                                </div> 

                                        
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 subtitulo" style="text-align:left;color:red;font-size: 12px;" for="btnModalProductosC">MOTIVO INCIDENCIAS (*):</label>
                                                    <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                    						    	    <input type="hidden" id="datosIncidencia" value='<?php echo $jsonIncidencias; ?>'>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-md-12 table-responsive p-0">
                    							<table class="table table-hover text-nowrap" id="tbdatos">
                    								<thead>
                    									<tr>
                    										<th>#</th>
                    										<th>Motivo</th>
                    										<th>SubMotivo</th>
                    										<th>Fecha Incidencia</th>
                    										<th>¿Resuelta?</th>
                    										<th>Fecha Solucion</th>
                    										<th>Opciones</th>
                    									</tr>
                    								</thead>
                    								<tbody>
                    								</tbody>
                    							</table>
                    						</div>
                                        </div>


                                    </div>
                                    </div>
                                    </div>
                                    
                                    <div class="box box-custom">
                                    
                                        <div class="box-header with-border">
                                            <label class="col-sm-4 col-xs-4 subtitulo" style="text-align:left;font-size: 12px;" for="btnModalGestionC">RESUMEN GESTIÓN:</label>
                                            <div class="box-tools pull-right">
                                                        <a class="btn btn-default btn-sm" href="#" data-toggle="modal" id="logcambios_cert" data-target="#modal-default-cert" style="border-radius: 40px;"><i class="fa fa-pencil-square-o"></i> Historial</a>
                                            </div>
                                        </div>
                                        <!-- /.box-header -->
                                        <div class="box-body">
                                            <div class="form-horizontal" style="padding: 20px;">
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblnumerollamadas">NRO LLAMADAS:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <input type="text" class="form-control pull-right input-sm" id="lblnumerollamadas" name="lblnumerollamadas" value="<?php echo $numerollamadas; ?>" disabled>
                                                            </div>
                                                        </div>
                                                    </div>                                          
                                                </div>

                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblestadollamada">ESTADO DE LLAMADA:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <input type="text" class="form-control pull-right input-sm" id="lblestadollamada" name="lblestadollamada" value="<?php echo $EstadoLlamada; ?>" disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechaultimallamada">FECHA ULTIMA LLAMADA:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <div class="input-group" id="fi">
                                                                    <div class="input-group-addon input-sm">
                                                                        <i class="fa fa-calendar"></i>
                                                                    </div>
                                                                    <input type="text" class="form-control pull-right input-sm" id="lblfechaultimallamada" value="<?php echo $FechaUltimaGestion; ?>" name="lblfechaultimallamada" disabled>
                                                                    <input type="hidden" id="lblfechacierre_cert" value="<?php echo $FechaCierre; ?>" name="lblfechacierre_cert">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblestadollamada">FECHA HORA PROGRAMACIÓN:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <input type="text" class="form-control pull-right input-sm" id="lblfechahoraprogramacion" name="lblfechahoraprogramacion" value="<?php echo $FechaHoraProgramacion; ?>" disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                </div>                                                
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-8">
                                                        <div class="form-group">
                                                            <label class="col-md-3 col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcomentario_cert"><span style="color:#2c3b41">COMENTARIO:</span></label>
                                                            <div class="col-md-9 col-sm-8 col-xs-8">
                                                                <textarea class="form-control input-sm" name="lblcomentario_cert" id="lblcomentario_cert" rows="3" style="resize:none" placeholder="Ingresar..." disabled><?php echo $ComentarioGestion; ?></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                
                                                
                                            </div>
                                        </div>
                                        <!-- /.box-body -->
                                    </div>

                                       
                                        <div class="box box-custom">
                                        
                                            <div class="box-header with-border">
                                                <label class="col-sm-4 col-xs-4 subtitulo" style="text-align:left;font-size: 12px;" for="btnModalGestionC">RESUMEN COMERCIAL:</label>
                                                <div class="box-tools pull-right">
                                                    <button type="button" class="btn btn-nuevo btn-sm" id="btnModalRespuestaC" style="border-radius: 40px;">
            										    <i class="fa fa-plus"></i> Agregar Respuesta
            								    	    </button>                                                    
                                                    <a class="btn btn-default btn-sm" href="#" data-toggle="modal" id="logcambios_comentario_comercial" data-target="#modal-comentario_comercial" style="border-radius: 40px;"><i class="fa fa-pencil-square-o"></i> Log Comentario</a>
                                                </div>
                                            </div>
                                            <!-- /.box-header -->
                                            <div class="box-body">
                                                <div class="form-horizontal" style="padding: 20px;">
                                                  
                                                    <div class="form-group" style="margin-bottom: 0px;">
                                                        <div class="col-sm-6 col-md-8">
                                                            <div class="form-group">
            
                                                                <label class="col-md-3 col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcomentario_comercial"><span style="color:#2c3b41">RESPUESTA COMERCIAL:</span></label>
                                                                <div class="col-md-9 col-sm-8 col-xs-8">
                                                                    <textarea class="form-control input-sm" name="lblcomentario_comercial" id="lblcomentario_comercial" rows="3" style="resize:none" placeholder="Ingresar..." disabled><?php echo $ComentarioComercial; ?></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
     
                                                    </div>                                        
            
                                                    <div class="form-group" style="margin-bottom: 0px;">
    
                                                        <div class="col-sm-6 col-md-6">
                                                            <div class="form-group">
                                                                <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltipocierre_cert">HORARIO SUGERIDO:</label>
                                                                <div class="col-sm-8 col-xs-8">
                                                                    <select class="form-control input-sm" name="lblhorariosugerido2" id="lblhorariosugerido2" disabled>
                                                                        <option>Seleccione</option>
                                                                        <option value="9:00 am - 12 pm" <?php if ($nuevohorarioSugerido=='9:00 am - 12 pm') {echo "selected";} ?>>9:00 am - 12 pm</option>
                                                                        <option value="12:00 pm - 3:00 pm" <?php if ($nuevohorarioSugerido=='12:00 pm - 3:00 pm') {echo "selected";} ?>>12:00 pm - 3:00 pm</option>
                                                                        <option value="3:00 pm - 6:00 pm" <?php if ($nuevohorarioSugerido=='3:00 pm - 6:00 pm') {echo "selected";} ?>>3:00 pm - 6:00 pm</option>
                                                                    </select>  
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div> 
                                                    
                                                    
                                                </div>
                                            </div>
                                            <!-- /.box-body -->
                                        </div>                                    
 
                                                                               

                                        
                                    </div>

                                </div>
                                <!-- /.box-body -->
                            </div>

                                <!-- INFORMACION DE LA FACTURACION -->
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                        <h5>INFORMACION DE FACTURACIÓN</h5>
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                        <div class="form-horizontal">
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <?php if($estadoventa=='Instalada' || $estadoventa=='InstaladaDEL' || $estadoventa=='IncidenciaAuditoria' || $estadoventa=='IncidenciaGestCorreo' || $estadoventa=='IncidenciaGestValija' || $estadoventa=='Facturada' || $estadoventa=='PorFacturar' || $estadoventa=='DocEnvi'  || $estadoventa=='Incidencia' || $estadoventa=='NoDoc'){?>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">PAGO:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <a class="btn btn-danger btn-social btn-sm"  data-toggle="modal" id="btnrealizarpago" data-target="#modal-mediodepago"> <i class="fa fa-credit-card"></i> Realizar Pago </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">AFILIACIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <a class="btn btn-nuevo btn-social btn-sm"  data-toggle="modal" id="btnenviarcorreoafiliar" data-target="#modal-enviarcorreoafiliar"> <i class="fa fa-envelope-o"></i> Enviar Afiliacion </a>
                                                            <label class="label label-danger" style="font-size:12px">ESTADO DE AFILIACION</label>
                                                            <label class="label label-default" style="font-size:12px"><?php if($estadoafiliacion=="NOREGISTRADO"){ echo "RECHAZADO:".$ACTION_DESCRIPTION;}else if($estadoafiliacion=='REGISTRADO'){echo 'AFILIADO';}else if($estadoafiliacionmdp=='ENPROCESO'){echo 'ENPROCESO';}else if($estadoafiliacionmdp=='AFILIADO'){echo 'AFILIADO';}else if($estadoafiliacionmdp=='RECHAZADO'){echo "RECHAZADO:".$motivomdp;}else{echo 'PENDIENTE';}?></label>
                                                            <?php if(isset($card) && !empty($card)){?>
                                                            <label class="label label-default" style="font-size:12px"><?php echo $tipocuenta.' '.$card;?></label>
                                                            <?php }
                                                                
                                                                ?>                                                            
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php 
                                                    
                                                    }
                                                    ?>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-12 col-md-12">
                                                    <div class="form-group">
                                                        <label class="col-sm-2 col-xs-4 control-label" style="text-align:left;" for="lblmotivoincidencia">MOTIVO INCIDENCIA: </label>
                                                        <div class="col-sm-10 col-xs-8">
                                                            <textarea class="form-control input-sm" name="lblmotivoincidencia" id="lblmotivoincidencia" rows="2" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php echo $factmotivoincidencia;?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">FECHA RECEPCION DOC.:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input type="text" class="form-control pull-right input-sm" id="lblfecharecpciondoc"  name="lblfecharecpciondoc" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfecharecepciondoc;?>" disabled="disabled" >
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">FECHA DE FACTURACIÓN: <span style="font-size: 12px; color:red ">(*)</span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-calendar"></i>
                                                                </div>
                                                                <input type="text" class="form-control pull-right input-sm" id="lblfechafacturacion"  name="lblfechafacturacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfechafacturacion;?>" disabled="disabled" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /.box-body -->
                                </div>
                            </form>
                        </div>
                        <div class="col-md-2"></div>
                    </div>
                    <!-- MODAL GESTIONES DE AGENDAMIENTO -->
                    <div class="modal fade" id="modal-default">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4>GESTIONES DE AGENDAMIENTO</h4>
                                </div>
                                <div class="modal-body" id="vistaboy">
                                    <div id="myGrid"  style="height: 100%" class="ag-theme-fresh"></div>
                                    <div  id="ningunresultado"></div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                                </div>
                            </div>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                    <div class="modal fade" id="modal-mediodepago">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h3 id="myModalLabel">MEDIO DE PAGOS</h3>
                                </div>
                                <div class="modal-body">
                                    <div id="c-slider">
                                        <div id="slider">
                                            <section id="myWizard0">
                                                <div class="row">
                                                    <!-- left column -->
                                                    <div class="col-xs-12">
                                                        <!-- general form elements -->
                                                        <div class="box box-danger">
                                                            <div class="box-header">
                                                                <h1 class="box-title">SELECCIONE TIPO DE TARJETA</h1>
                                                            </div>
                                                            <!-- /.box-header -->
                                                            <!-- form start -->
                                                            <div class="box-body" id="bodyprincipal" >
                                                                <div class="row fila-tarjeta">
                                                                    <div class="col-md-2"></div>
                                                                    <div class="col-md-3">
                                                                        <img src="img/credit/Visa2.png" alt="VISA" class="btnvisa">
                                                                    </div>
                                                                    <div class="col-md-2"></div>
                                                                    <div class="col-md-3">
                                                                        <img src="img/credit/MasterCard.png" alt="MASTERCARD" class="btnmastercard">
                                                                    </div>
                                                                    <div class="col-md-2"></div>
                                                                </div>
                                                                <div class="row fila-tarjeta">
                                                                    <div class="col-md-2"></div>
                                                                    <div class="col-md-3">
                                                                        <img src="img/credit/dinerslogo.png" alt="DINNERS" class="btndinners">
                                                                    </div>
                                                                    <div class="col-md-2"></div>
                                                                    <div class="col-md-3">
                                                                        <img src="img/credit/american.png" alt="AMERICAN EXPRESS" class="btnamex">
                                                                    </div>
                                                                    <div class="col-md-2"></div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- /.box-body -->
                                                    </div>
                                                    <!-- /.box -->
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-nuevo" data-dismiss="modal">Cerrar</button>
                                                </div>
                                            </section>
                                            <section id="myWizard">
                                                <div class="row">
                                                    <!-- left column -->
                                                    <div class="col-xs-12">
                                                        <!-- general form elements -->
                                                        <div class="box box-danger">
                                                            <div class="box-header">
                                                                <h1 class="box-title" id="titulo"></h1>
                                                                <h1 class="box-title" id="titulo2"></h1>
                                                            </div>
                                                            <!-- /.box-header -->
                                                            <!-- form start -->
                                                            <div class="box-body" id="bodyprincipal">
                                                                <div class="row">
                                                                    <div class="col-md-1 col-sm-1 col-xs-1">  </div>
                                                                    <div class="col-md-10 col-sm-10 col-xs-10">
                                                                        <a class="btn btn-default btn-social btn-block btn-lg step3"> <i class="fa fa-credit-card"></i>PAGAR AHORA </a>
                                                                        <div class="espacio"> </div>
                                                                        <!-- /.info-box -->
                                                                        <!-- /.info-box -->
                                                                    </div>
                                                                    <div class="col-md-1 col-sm-1 col-xs-1">  </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col-xs-1">  </div>
                                                                    <div class="col-xs-10">
                                                                        <a class="btn btn-default btn-social btn-block btn-lg  step2"> <i class="fa fa-envelope-o"></i>ENVIAR CORREO </a>
                                                                        <div class="espacio"> </div>
                                                                        <!-- /.info-box -->
                                                                    </div>
                                                                    <div class="col-xs-1">  </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- /.box-body -->
                                                    </div>
                                                    <!-- /.box -->
                                                </div>
                                                <div class="modal-footer">
                                                    <a class="btn btn-default  regresarvtaonline" href="#"><i class="fa fa-reply"> Regresar</i></a> 
                                                    <button type="button" class="btn btn-nuevo pull-right" data-dismiss="modal">Cerrar</button>
                                                </div>
                                            </section>
                                            <section id="myWizard2">
                                                <div class="row">
                                                    <!-- left column -->
                                                    <div class="col-xs-12">
                                                        <!-- general form elements -->
                                                        <div class="box box-danger">
                                                            <div class="box-header">
                                                            </div>
                                                            <!-- /.box-header -->
                                                            <!-- form start -->
                                                            <div class="box-body" id="bodyventaoline">
                                                                <div id="divLoading2" style="display: none;">
                                                                    <div class="spinner">
                                                                        <div class="bounce1"></div>
                                                                        <div class="bounce2"></div>
                                                                        <div class="bounce3"></div>
                                                                    </div>
                                                                </div>
                                                                <input id="lblmediopago" name="lblmediopago" value="" hidden="">
                                                                <div  id="ningunresultado3"></div>
                                                            </div>
                                                            <!-- /.box-body -->
                                                        </div>
                                                        <!-- /.box -->
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <a class="btn btn-link mensajematricula pull-left"  href="#"></a>
                                                    <button type="button" class="btn btn-nuevo" id="Cerrarmodal" data-dismiss="modal">Cerrar</button>
                                                </div>
                                            </section>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                    <!-- MODAL CHECK IN -->
                    <div class="modal fade" id="modal-checkin">
                        <div class="modal-dialog modal-log">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4>Enviar Check-IN ...</h4>
                                </div>
                                <div class="modal-body">
                                    <div class="" id="Informacion">
                                        <input type="hidden" id="objGeofinder" name="objGeofinder" value='<?php echo $objGeofinder ?>'>
                                        <input type="hidden" id="checkin" name="checkin" value="<?php echo $Checkin; ?>">
                                        <input type="hidden" id="infocheckin" name="infocheckin" value='<?php echo $InfoCheckIn; ?>'>
                                        <input type="hidden" id="FechaVisita" name="FechaVisita" value='<?php if(empty($FVisitaObras)){echo $FechaVisita;} else { echo $FVisitaObras;} ?>'>
                                        <input type="hidden" id="latitud" name="latitud">
                                        <input type="hidden" id="longitud" name="longitud">
                                        <input type="hidden" id="latitudReubicacion" name="latitudReubicacion">
                                        <input type="hidden" id="longitudReubicacion" name="longitudReubicacion">
                                    </div>
                                    <div id="mapContenedor">
                                        <div id="map"></div>
                                        <div class="form-group" style="margin-top: 15px">
                                            <label style="font-weight: bold;">Motivos Checkin Fuera del circulo:</label>
                                            <select class="form-control input-sm" id="cboMotivosCheckIn">
                                                <option value="Ninguna">Ninguna</option>
                                                <option value="DirecciónMalGeoreferenciada">La dirección del cliente (PIN VERDE) no es correcta</option>
                                                <!-- <option value="ErrorGPS">Mi ubicación en el mapa (PIN AZUL) aparece en otro lugar</option> -->
                                                <option value="Otros">Otros, detallar en observaciones</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>Observaciones</label>
                                            <textarea class="form-control" rows="3" id="txtObservacionesCheckIN"></textarea>
                                        </div>
                                        <div class="checkbox chbxcorreouno ocultar">
                                            <label style="font-weight: bold">
                                            <input id="VisitaNoVisitable" type="checkbox" class="minimal-red">&nbsp&nbspVisita No Visitable
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <!--<button type="button" class="btn btn-nuevo" id="btnContinuar">Continuar sin Check-IN</button> -->
                                    <button type="button" class="btn btn-success" id="btnGuardarCheckIn">Enviar Ubicación</button>
                                    <!--<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- MODAL CHECKOUT -->
                    <div class="modal fade" id="modal-checkout" tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-log" role="document">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4>Enviar Check-OUT ...</h4>
                                </div>
                                <div class="modal-body">
                                    <div class="row">
                                        <input type="hidden" id="checkout" name="checkout" value="<?php echo $CheckOut; ?>">
                                        <input type="hidden" id="infocheckout" name="infocheckout" value='<?php echo $InfoCheckOut; ?>'>
                                        <input type="hidden" name="lbltotalhistorialcheckout" id="lbltotalhistorialcheckout" class="form-control input-sm" style="width: 100%;" value="<?php echo $totalHistorial;?>">
                                        <input type="hidden" id="fechalimiteenviocheckout" name="fechalimiteenviocheckout" value='<?php echo strtotime($fechaEnvio."+ 2days"); ?>'>
                                        <div class="col-sm-12 col-md-12 ocultar">
                                            <div class="form-group">
                                                <label>Nro. de Prospecto</label>
                                                <input name="lblnroprospecto" id="lblnroprospecto" class="form-control input-sm" style="width: 100%;" value="<?php echo $nprospecto;?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12 ocultar">
                                            <div class="form-group">
                                                <label>Fecha de Asignación de Visita</label>
                                                <input type="date" name="lblfechaasignacionvisita" id="lblfechaasignacionvisita" class="form-control input-sm" style="width: 100%;" value="<?php echo date("Y-m-d",strtotime($FechaVisita)); ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12 ocultar">
                                            <div class="form-group">
                                                <label>Fecha de Atención de Visita</label><?php echo $fechaEnvio; ?>
                                                <input type="date" name="lblfechaatencionvisita" id="lblfechaatencionvisita" class="form-control input-sm" style="width: 100%;" value="<?php if($fechaEnvio == '1969-12-31') { echo date("Y-m-d"); } else { echo date("Y-m-d",strtotime($fechaEnvio)); } ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label>¿Quién realizó la llamada de posicionamiento?</label>
                                                <!--<input name="lblllamadaposicionamiento" id="lblllamadaposicionamiento" class="form-control input-sm" style="width: 100%;" value="<?php echo $infoCheckOutD->LlamadaPosicionamiento; ?>">-->
                                                <select class="form-control input-sm" id="lblllamadaposicionamiento" name="lblllamadaposicionamiento">
                                                    <option value="Delegado/Gerente" <?php if($infoCheckOutD->LlamadaPosicionamiento == 'Delegado/Gerente') { echo "selected"; } ?>>Delegado/Gerente</option>
                                                    <option value="Jefe/Coach" <?php if($infoCheckOutD->LlamadaPosicionamiento == 'Jefe/Coach') { echo "selected"; } ?>>Jefe/Coach</option>
                                                    <option value="Yo mismo" <?php if($infoCheckOutD->LlamadaPosicionamiento == 'Yo mismo') { echo "selected"; } ?>>Yo mismo</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label style="font-weight: bold;">¿Se vendió?</label>
                                                <select class="form-control input-sm" id="cboSeVendio" name="cboSeVendio">
                                                    <option value="Si" <?php if($infoCheckOutD->Sevendio == 'Si') { echo "selected"; } ?>>Si</option>
                                                    <option value="No" <?php if($infoCheckOutD->Sevendio == 'No') { echo "selected"; } ?>>No</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12 <?php if($infoCheckOutD->cboSeVendio == 'Si' || $infoCheckOutD->cboSeVendio == '') { echo "ocultar"; } ?>">
                                            <div class="form-group">
                                                <label style="font-weight: bold;">Si no se vendió, ¿cuál fue el motivo principal?</label>
                                                <select class="form-control input-sm" id="cboMotivoPrincipal" name="cboMotivoPrincipal">
                                                    <option value="Precio muy alto para su economia" <?php if($infoCheckOutD->MotivoPrincipal == 'Precio muy alto para su economia' || $infoCheckOutD->MotivoPrincipal == 'Precio muy alto para sus posibilidades economicas') { echo "selected"; } ?>>Precio muy alto para su economia</option>
                                                    <option value="Cliente no quiso recibirnos" <?php if($infoCheckOutD->MotivoPrincipal == 'Cliente no quiso recibirnos') { echo "selected"; } ?>>Cliente no quiso recibirnos</option>
                                                    <option value="Solo esta interesado en camaras" <?php if($infoCheckOutD->MotivoPrincipal == 'Solo esta interesado en camaras') { echo "selected"; } ?>>Solo esta interesado en camaras</option>
                                                    <option value="Cliente no quiere pagar cuota" <?php if($infoCheckOutD->MotivoPrincipal == 'Cliente no quiere pagar cuota' || $infoCheckOutD->MotivoPrincipal == 'Cliente no quiere pagar cuota de monitoreo') { echo "selected"; } ?>>Cliente no quiere pagar cuota</option>
                                                    <option value="Cuota muy alta para sus posibilidades economicas" <?php if($infoCheckOutD->MotivoPrincipal == 'Cuota muy alta para sus posibilidades economicas' || $infoCheckOutD->MotivoPrincipal == 'Cuota muy alta para su economia') { echo "selected"; } ?>>Cuota muy alta para su economia</option>                                                    
                                                    <option value="Vivienda/Local inviable para instalar" <?php if($infoCheckOutD->MotivoPrincipal == 'Vivienda/local no cumple con las condiciones mínias de instalacion' || $infoCheckOutD->MotivoPrincipal == 'Vivienda/Local inviable para instalar') { echo "selected"; } ?>>Vivienda/Local inviable para instalar</option>
                                                    <option value="Competencia" <?php if($infoCheckOutD->MotivoPrincipal == 'Contrato con la competencia' || $infoCheckOutD->MotivoPrincipal == 'Competencia') { echo "selected"; } ?>>Competencia</option>
                                                    <option value="No se encontraban los decisores" <?php if($infoCheckOutD->MotivoPrincipal == 'No se encontraban los decisores') { echo "selected"; } ?>>No se encontraban los decisores</option>
                                                    <!--<option value="Tiempo de permanencia de contrato" <?php if($infoCheckOutD->MotivoPrincipal == 'Tiempo de permanencia de contrato') { echo "selected"; } ?>>Tiempo de permanencia de contrato</option>
                                                    <option value="Cliente no quiso recibirnos" <?php if($infoCheckOutD->MotivoPrincipal == 'Cliente no quiso recibirnos') { echo "selected"; } ?>>Cliente no quiso recibirnos</option>-->
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12 <?php if($infoCheckOutD->MotivoPrincipal != 'Contrató con la competencia') { echo "ocultar"; } ?>">
                                            <div class="form-group">
                                                <label style="font-weight: bold;">Si cliente contrató con la competencia, ¿con cuál empresa?</label>
                                                <select class="form-control input-sm" id="cboEmpresa" name="cboEmpresa">
                                                    <option value="Prosegur" <?php if($infoCheckOutD->Empresa == 'Prosegur') { echo "selected"; } ?>>Prosegur</option>
                                                    <option value="Mapfre" <?php if($infoCheckOutD->Empresa == 'Mapfre') { echo "selected"; } ?>>Mapfre</option>
                                                    <option value="Boxer" <?php if($infoCheckOutD->Empresa == 'Boxer') { echo "selected"; } ?>>Boxer</option>
                                                    <option value="Liderman" <?php if($infoCheckOutD->Empresa == 'Liderman') { echo "selected"; } ?>>Liderman</option>
                                                    <option value="Otros" <?php if($infoCheckOutD->Empresa == 'Otros') { echo "selected"; } ?>>Otros</option>
                                                </select>
                                            </div>
                                        </div>
                                        <!--<div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label style="font-weight: bold;">¿Se encontraban los decisores?</label>
                                                <select class="form-control input-sm" id="cboDecisores" name="cboDecisores">
                                                    <option value="Si" <?php if($infoCheckOutD->Decisores == 'Si') { echo "selected"; } ?>>Si</option>
                                                    <option value="No" <?php if($infoCheckOutD->Decisores == 'No') { echo "selected"; } ?>>No</option>
                                                </select>
                                            </div>
                                        </div>-->
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label style="font-weight: bold;">¿Qué se le cotizó al cliente?</label>
                                                <select class="form-control input-sm" id="cboCotizoCliente" name="cboCotizoCliente">
                                                    <option value="Kit Basico" <?php if($infoCheckOutD->CotizoCliente == 'Kit Basico') { echo "selected"; } ?>>Kit Básico</option>
                                                    <option value="Kit Basico + camara" <?php if($infoCheckOutD->CotizoCliente == 'Kit Basico + camara') { echo "selected"; } ?>>Kit Básico + camara</option>
                                                    <option value="Kit Zerovision" <?php if($infoCheckOutD->CotizoCliente == 'Kit Zerovision') { echo "selected"; } ?>>Kit Zerovision</option>
                                                    <option value="Kit Zerovision + camara" <?php if($infoCheckOutD->CotizoCliente == 'Kit Zerovision + camara') { echo "selected"; } ?>>Kit Zerovision + camara</option>
                                                    <!--<option value="Kit High Security" <?php if($infoCheckOutD->CotizoCliente == 'Kit High Security') { echo "selected"; } ?>>Kit High Secutiry</option>-->
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label style="font-weight: bold;">¿Con quién se realizó la llamada pared?</label>
                                                <select class="form-control input-sm" id="cboLlamadaPared" name="cboLlamadaPared">
                                                    <option value="Coach/Jefe de Ventas" <?php if($infoCheckOutD->LlamadaPared == 'Coach/Jefe de Ventas') { echo "selected"; } ?>>Coach/Jefe de Ventas</option>
                                                    <option value="Delegado/Gerente" <?php if($infoCheckOutD->LlamadaPared == 'Delegado/Gerente') { echo "selected"; } ?>>Delegado/Gerente</option>
                                                    <option value="Con un compañero" <?php if($infoCheckOutD->LlamadaPared == 'Con un compañero') { echo "selected"; } ?>>Con un compañero</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label style="font-weight: bold;">Acompañamiento en la Visita. ¿Quién asisitó a la visita?</label>
                                                <select class="form-control input-sm" id="cboAcompanamientoVisita" name="cboAcompanamientoVisita">
                                                    <option value="Delegado/Gerente" <?php if($infoCheckOutD->AcompanamientoVisita == 'Delegado/Gerente') { echo "selected"; } ?>>Delegado/Geremte</option>
                                                    <option value="Coach/Jefe de Ventas" <?php if($infoCheckOutD->AcompanamientoVisita == 'Coach/Jefe de Ventas') { echo "selected"; } ?>>Coach/Jefe de Ventas</option>
                                                    <option value="Con un compañero" <?php if($infoCheckOutD->AcompanamientoVisita == 'Con un compañero') { echo "selected"; } ?>>Con un compañero</option>
                                                    <option value="Solo yo" <?php if($infoCheckOutD->AcompanamientoVisita == 'Solo Especialista' || $infoCheckOutD->AcompanamientoVisita == 'Solo yo') { echo "selected"; } ?>>Solo yo</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label>¿Cuál fue el último precio que se le brindó al cliente?</label>
                                                <!--<input name="lblUltimoPrecio" id="lblUltimoPrecio" class="form-control input-sm" style="width: 100%;" value="<?php echo $infoCheckOutD->UltimoPrecio; ?>">-->
                                                <select class="form-control input-sm" id="lblUltimoPrecio" name="lblUltimoPrecio">
                                                    <option value="Precio Gerente" <?php if($infoCheckOutD->UltimoPrecio == 'Precio Gerente') { echo "selected"; } ?>>Precio Gerente</option>
                                                    <option value="Precio Jefe/Coach" <?php if($infoCheckOutD->UltimoPrecio == 'Precio Jefe/Coach') { echo "selected"; } ?>>Precio Jefe/Coach</option>
                                                    <option value="Otros Precios" <?php if($infoCheckOutD->UltimoPrecio == 'Otros Precios') { echo "selected"; } ?>>Otros Precios</option>
                                                </select>                                                
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label style="font-weight: bold;">¿Fue zona de robo?</label>
                                                <select class="form-control input-sm" id="cboZonaRobo" name="cboZonaRobo">
                                                    <option value="Si" <?php if($infoCheckOutD->ZonaRobo == 'Si') { echo "selected"; } ?>>Si</option>
                                                    <option value="No" <?php if($infoCheckOutD->ZonaRobo == 'No') { echo "selected"; } ?>>No</option>
                                                </select>
                                            </div>
                                        </div>
                                        <!--<div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label>¿Cuántos referidos RP se consiguió en la visita?</label>
                                                <input name="lblReferidosRP" id="lblReferidosRP" class="form-control input-sm" style="width: 100%;" value="<?php echo $infoCheckOutD->ReferidosRP; ?>">
                                            </div>
                                        </div>-->
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group">
                                                <label>Observaciones</label>
                                                <textarea class="form-control input-sm" name="lblObservacionesCheckOut" id="lblObservacionesCheckOut" rows="3" style="resize:none" placeholder="Ingresar..."><?php echo $infoCheckOutD->ObservacionesCheckout; ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <!--<button type="button" class="btn btn-nuevo" id="btnContinuar">Continuar sin Check-IN</button> -->
                                    <button type="button" class="btn btn-success" id="btnGuardarCheckOut">Grabar Checkout</button>
                                    <!--<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>-->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade" id="modal-consultascoring">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4>CONSULTAR SCORING</h4>
                                </div>
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div id="frmEditarVentaScoring" method="post">
                                                <div class="box box-danger">
                                                    <div class="box-header with-border">
                                                        <h5>SCORING</h5>
                                                        <div class="box-tools pull-right">
                                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                    <div class="box-body">
                                                        <div class="form-horizontal" style="padding: 10px 20px 0">
                                                            <div class="form-group">
                                                                <label style="text-align: left;">TIPO DOCUMENTO:</label>
                                                                <input type="hidden" id="matriculausuario" value="<?php echo $matriculausuario;?>">
                                                                <input type="hidden" id="nombreusuario" value="<?php echo $nombreusuario;?>">
                                                                <select class="form-control input-sm" name="TipoDocumento" id="TipoDocumento">
                                                                    <option value="">Seleccione</option>
                                                                    <option value="1">DNI</option>
                                                                    <option value="3">Carnet Extranjeria</option>
                                                                    <option value="6">RUC</option>
                                                                </select>
                                                                <a href="#" title="Modal de Busqueda de Documento" id="btnEquifax">(No tengo el Número de Documento)</a>
                                                            </div>
                                                            <div class="form-group">
                                                                <label id="labeltelefono">DOCUMENTO: </label>
                                                                <input type="text" class="form-control input-sm" name="Documento" id="Documento" maxlength="12" onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                                                            </div>
                                                            <div class="form-group hidden">
                                                                <label>DEPARTAMENTO: </label>
                                                                <select class="form-control input-sm select2full" name="Departamental" id="Departamental" style="width: 100%">
                                                                    <option value="" selected>Seleccione</option>
                                                                </select>
                                                            </div>
                                                            <div class="form-group hidden">
                                                                <label>PROVINCIA: </label>
                                                                <select class="form-control input-sm select2full" name="Provincial" id="Provincial" style="width: 100%">
                                                                    <option value="">Seleccione</option>
                                                                </select>
                                                            </div>
                                                            <div class="form-group hidden">
                                                                <label>DISTRITO: </label>
                                                                <select class="form-control input-sm select2full" name="Distrital" id="Distrital" style="width: 100%">
                                                                    <option value="">Seleccione</option>
                                                                </select>
                                                            </div>
                                                            <div class="form-group">
                                                                <label>SEGMENTO: </label>
                                                                <select class="form-control input-sm" name="Segmento" id="Segmento" style="width: 100%" <?php echo ($tipoventa == "RE")?'':'disabled';?>>
                                                                    <option value="">Seleccione</option>
                                                                    <option value="RES">RES</option>
                                                                    <option value="NEG">NEG</option>
                                                                </select>
                                                            </div>
                                                            <div class="form-group" style="margin-top:40px;">
                                                                <button class="btn  btn-block btn-verisure" id="btnScoring">Consultar Scoring</button>
                                                                <button class="btn  btn-block btn-verisure" style="display:none" id="btnNuevaScoring">Nueva Consulta</button>
                                                                <button type="button" class="btn btn-block btn-verisurecerrar" data-dismiss="modal">Cerrar</button> 
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <main class="contenedor ocultar box box-danger" id="ResultadoEquifax">
                                                <div id="resultado">
                                                    <div class="callout bg-deuda">
                                                        <h4><i class="fa fa-bullhorn"></i> Resultado de la Consulta:</h4>
                                                        <h2 style="text-align: center;"><small class="label bg-visita"><span class="TextoAccion"></span></small><small class="label bg-televenta"><span class="TextoAccion"></span></small><small class="label bg-gestion"><span class="TextoAccion"></span></small></h2>
                                                        <br>
                                                        <!--<strong>N°Operación: </strong><span id="NOperacion">S32012280000162</span><br>-->
                                                        <strong>Fecha Consulta: </strong><span id="FechaConsulta">13/11/2019 12:24:34</span><br><br>
                                                        <div class="row">
                                                            <div class="col-xs-12">
                                                                <strong><i class="fa fa-user text-danger"></i> Nombre del Solicitante:</strong><br><span id="NombreCompleto">DUBOIS DORIBAL DUBOIS DORIBAL GLADYS ELVIRA</span><br>
                                                                <strong><i class="fa fa-folder-open text-danger"></i> <span id="TDocumento">DNI:</span></strong><br><span id="NumeroDocumento">00007039332</span><br>
                                                            </div>
                                                            <div class="col-xs-12" style="display:none">
                                                                <div class="contenido-score">
                                                                    <div class="score-info">
                                                                        <div>
                                                                            <strong>SCORE - RIESGO</strong>
                                                                            <br>
                                                                            <span id="Riesgo">Bajo</span>
                                                                        </div>
                                                                        <div>
                                                                            <strong>SCORE - VALOR</strong>
                                                                            <br>
                                                                            <div id="Valor">952</div>
                                                                        </div>
                                                                        <div class="ocultar">
                                                                            <strong>NODOS - DESCRIPCION</strong>
                                                                            <br>
                                                                            <div id="ValorNodo">XXX</div>
                                                                        </div>
                                                                        <div class="ocultar">
                                                                            <strong>NODOS - ACCION</strong>
                                                                            <br>
                                                                            <div id="ValorNodoAccion">XXX</div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </main>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade" id="modal-logdni">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h3>DOCUMENTOS</h3>
                                </div>
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-12 table-responsive no-padding">
                                            <table class="table table-bordered" id="tblVentas" style="display:none;">
                                                <thead>
                                                    <tr style="height:0.8vw">
                                                        <td class="text-center">OPCIONES</td>
                                                        <td class="text-center">FECHA CONSULTA</td>
                                                        <td class="text-center">TIPO DOC.</td>
                                                        <td class="text-center">DOCUMENTO</td>
                                                        <td class="text-center">NOMBRES, APELLIDO PATERNO, APELLIDO MATERNO</td>
                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- MODAL DETALLE EXTRAS -->
                    <div class="modal fade" id="modal__carritocompras">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h3>EXTRAS</h3>
                                </div>
                                <div class="modal-body">
                                    <div class="form-group">
                                        <label for="cboProducto" class="col-md-3 control-label">Extra:</label>
                                        <div class="col-md-9">
                                            <select class="form-control" id="cboProducto" name="cboProducto" style="width: 100%">
                                                <option value="" disabled selected>--Seleccione--</option>
                                                <?php
                                                    if($dc == "154" || $dc == "157" || $dc == "158" || $matriculausuario=='MGR200' || $dc == "120" || $dc == "150" || $dc == "41"){
                                                        $query="SELECT IdItem, CodItem, Item, Precio, CuotaMes
                                                                FROM yifi58ge_dbVENTAS.tblitem
                                                                where CategoriaItem = 'field' and Estado = 'Activo'";
                                                    }else{
                                                        $query="SELECT IdItem, CodItem, Item, Precio, CuotaMes
                                                                FROM yifi58ge_dbVENTAS.tblitem
                                                                where CategoriaItem = 'field' and Estado = 'Activo'";
                                                    }                                                            
                                                    $resultado=$con->query($query);
                                                            
                                                    while ($data = $resultado->fetch_assoc()){                                                          
                                                    ?>
                                                <option value="<?php echo $data['IdItem']; ?>"><?php echo $data['Item']." (S/. ".number_format((float)$data['Precio'], 0, '.', '').")"; ?></option>
                                                <?php } ?>
                                            </select>
                                            <input type="hidden" id="hidProducto" name="hidProducto">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="cboTipoPrecio" class="col-md-3 control-label">Tipo precio:</label>
                                        <div class="col-md-9">
                                            <select class="form-control" id="cboTipoPrecio" name="cboTipoPrecio" style="width: 100%">
                                                <option value="" disabled selected>--Seleccione--</option>
                                                <option value="catalogo">CATALOGO (SIN DESCUENTO))</option>
                                                <option value="medio">MEDIO (25% DESCUENTO ) </option>
                                                <option value="autorizado">AUTORIZADO (50% DESCUENTO)</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="cantidadProductos" class="col-md-3 control-label">Precio unitario:</label>
                                        <div class="col-md-9">
                                            <input type="number" class="form-control" id="precioUnitario" name="precioUnitario">
                                            <input type="hidden" id="precioMin">
                                            <input type="hidden" id="precioMax">
                                            <input type="hidden" id="cuotaMes">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="cantidadProductos" class="col-md-3 control-label">Cantidad:</label>
                                        <div class="col-md-9">
                                            <input type="number" class="form-control" id="cantidadProductos" name="cantidadProductos">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <button class="btn btn-danger pull-right" id="btnAgregar" name="btnAgregar"><i class="fa fa-plus"></i>&nbsp Agregar </button>    
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div id="listaExtras" class="col-md-12">
                                        </div>
                                    </div>
                                    <!-- RESUTADO FINAL -->
                                    <div class="row">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-8">
                                            <label for="txtResumen" class="col-sm-4 control-label">Resumen:</label>
                                            <div class="col-sm-8">
                                                <textarea rows="2" id="txtResumen" name="txtResumen" style="width: 100%" disabled></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-8">
                                            <label for="txtCantidadExtra" class="col-sm-4 control-label">Cantidad Extras:</label>
                                            <div class="col-sm-8">
                                                <input type="number" id="txtCantidadExtra" name="txtCantidadExtra" style="width: 100%" min="0" value="0" disabled>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <!--
                                        <div class="row">
                                            <div class="col-md-4"></div>
                                            <div class="col-md-8">
                                                <label for="txtCantidadRegalo" class="col-sm-4 control-label">Cantidad Regalo:</label>
                                                <div class="col-sm-8">
                                                    <input type="number" id="txtCantidadRegalo" name="txtCantidadRegalo" style="width: 100%" min="0" value="0" disabled>
                                                </div>
                                            </div>
                                        </div>
                                        <br>
                                        -->
                                    <div class="row">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-8">
                                            <label for="txtTotal" class="col-sm-4 control-label">Total:</label>
                                            <div class="col-sm-8">
                                                <input type="number" id="txtTotal" name="txtTotal" style="width: 100%" min="0" value="0.00" disabled>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-8">
                                            <label for="txtTotalCuota" class="col-sm-4 control-label">Total Cuota:</label>
                                            <div class="col-sm-8">
                                                <input type="number" id="txtTotalCuota" name="txtTotalCuota" style="width: 100%" min="0" value="0.00" disabled>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button class="btn btn-danger" id="generarOferta">Generar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- MODAL DETALLE REGALOS -->
                    <div class="modal fade" id="modal__regalos">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h3>REGALOS</h3>
                                </div>
                                <div class="modal-body">
                                    <div class="form-group">
                                        <label for="cboRegalo" class="col-md-3 control-label">Regalo:</label>
                                        <div class="col-md-9">
                                            <select class="form-control" id="cboRegalo" name="cboRegalo" style="width: 100%">
                                                <option value="" disabled selected>--Seleccione--</option>
                                                <?php
                                                    if($dc == "154" || $dc == "157" || $dc == "158" || $matriculausuario=='MGR200' || $dc == "120" || $dc == "150" || $dc == "41"){
                                                        $query="SELECT IdItem, CodItem, Item, Precio, CuotaMes
                                                                FROM yifi58ge_dbVENTAS.tblitem
                                                                where CategoriaItem = 'fieldRegalo' and Estado = 'Activo'";
                                                    }else{
                                                        $query="SELECT IdItem, CodItem, Item, Precio, CuotaMes
                                                                FROM yifi58ge_dbVENTAS.tblitem
                                                                where CategoriaItem = 'fieldRegalo' and Estado = 'Activo'";
                                                    }
                                                    $resultado=$con->query($query);
                                                            
                                                    while ($data = $resultado->fetch_assoc()){                                                          
                                                    ?>
                                                <option value="<?php echo $data['IdItem']; ?>"><?php echo $data ['Item']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="cantidadProductos" class="col-md-3 control-label">Cantidad:</label>
                                        <div class="col-md-9">
                                            <input type="number" class="form-control" id="cantidadProductos__Regalos" name="cantidadProductos__Regalos" min="1" >
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <button class="btn btn-danger pull-right" id="btnAgregar__Regalos" name="btnAgregar__Regalos"><i class="fa fa-plus"></i>&nbsp Agregar </button>    
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div id="listaRegalos" class="col-md-12">
                                        </div>
                                    </div>
                                    <!-- RESUTADO FINAL -->
                                    <div class="row">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-8">
                                            <label for="txtResumen" class="col-sm-4 control-label">Resumen:</label>
                                            <div class="col-sm-8">
                                                <textarea rows="2" id="txtResumen__Regalo" name="txtResumen__Regalo" style="width: 100%" disabled></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <!--
                                        <div class="row">
                                            <div class="col-md-4"></div>
                                            <div class="col-md-8">
                                                <label for="txtCantidadExtra" class="col-sm-4 control-label">Cantidad Extras:</label>
                                                <div class="col-sm-8">
                                                    <input type="number" id="txtCantidadExtra" name="txtCantidadExtra" style="width: 100%" min="0" value="0" disabled>
                                                </div>
                                            </div>
                                        </div>
                                        <br>
                                        
                                        <div class="row">
                                            <div class="col-md-4"></div>
                                            <div class="col-md-8">
                                                <label for="txtCantidadRegalo" class="col-sm-4 control-label">Cantidad Regalo:</label>
                                                <div class="col-sm-8">
                                                    <input type="number" id="txtCantidadRegalo" name="txtCantidadRegalo" style="width: 100%" min="0" value="0" disabled>
                                                </div>
                                            </div>
                                        </div>
                                        <br>
                                        -->
                                    <div class="row">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-8">
                                            <label for="txtCantidadRegalo" class="col-sm-4 control-label">Cantidad Regalo:</label>
                                            <div class="col-sm-8">
                                                <input type="number" id="txtCantidadRegalo" name="txtCantidadRegalo" style="width: 100%" min="0" value="0" disabled>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-8">
                                            <label for="txtTotal" class="col-sm-4 control-label">Total:</label>
                                            <div class="col-sm-8">
                                                <input type="number" id="txtTotal__Regalo" name="txtTotal__Regalo" style="width: 100%" min="0" value="0.00" disabled>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-8">
                                            <label for="txtTotalCuota" class="col-sm-4 control-label">Total Cuota:</label>
                                            <div class="col-sm-8">
                                                <input type="number" id="txtTotalCuota__Regalo" name="txtTotalCuota__Regalo" style="width: 100%" min="0" value="0.00" disabled>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button class="btn btn-danger" id="generarOferta__Regalo">Generar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- IFRAME OCULTO 
                        <div class="ocultar">
                            <iframe id="geofinderwidgetDir" name="geofinderwidgetDir" height="450"  allowTransparency="true" frameborder="0" scrolling="yes" style="width:100%;" src="GFWIDGET-PE/buscadorDirComercial.html" type= "text/javascript"></iframe>
                        </div>
                        -->
                    <!-- MODAL ENVIO DE AFILIACION -->
                    <div class="modal fade" id="modal-enviarcorreoafiliar" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                    <h4 class="modal-enviocorreo-title">ENVIAR A AFILIAR</h4>
                                </div>
                                <div class="modal-body">
                                    <form id="form_enviocorreo" methodo="POST">
                                        <div class="form-group">
                                            <label for="exampleInputEmail1">CORREO:</label>
                                            <input type="email" class="form-control" id="InputCorreo" placeholder="Escribir correo">
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" id="ModEnviarCerrar" data-dismiss="modal">Cerrar</button>
                                    <button type="button" class="btn btn-danger" id="ModEnviar">Enviar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade" id="modal-default-cert">
                    	<div class="modal-dialog modal-lg">
                    		<div class="modal-content">
                    			<div class="modal-header modal-header-danger">
                    				<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    				<h4>GESTIONES DE CERTIFICACION DE LA VENTA</h4>
                    			</div>
                    			<div class="modal-body" id="vistaboy_cert">
                    				<div id="myGrid_cert"  style="height: 100%" class="ag-theme-fresh"></div>
                    				<div  id="ningunresultado_cert"></div>
                    			</div>
                    			<div class="modal-footer">
                    				<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                    			</div>
                    		</div>
                    	</div>
                    	<!-- /.modal-content -->
                    </div>
                    <div class="modal fade" id="modal-comentario_comercial">
                    	<div class="modal-dialog modal-lg">
                    		<div class="modal-content">
                    			<div class="modal-header modal-header-danger">
                    				<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    				<h4>HISTORIAL RESPUESTA COMERCIAL</h4>
                    			</div>
                    			<div class="modal-body" id="vistaboy_comentariocertcert">
                    				<div id="myGrid_comentariocertcert"  style="height: 100%" class="ag-theme-fresh"></div>
                    				<div  id="ningunresultado_comentariocert"></div>
                    			</div>
                    			<div class="modal-footer">
                    				<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                    			</div>
                    		</div>
                    	</div>
                    	<!-- /.modal-content -->
                    </div>                    

                    <!-- MODAL LOG_COMENTARIO -->
                    <div class="modal fade" id="modal_respuestaC">
                    	<div class="modal-dialog">
                    		<div class="modal-content">
                    			<div class="modal-header">
                    				 <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    				<h4 class="modal-title">AÑADIR RESPUESTA COMERCIAL</h4>
                    			</div>
                    			<div class="modal-body">
                    				<div class="form-group row ">
                    					<label for="modalhorariosugerido" class="col-lg-3 col-form-label">HORARIO SUGERIDO:<span class="text-danger">*</span></label>
                    					<div class="col-12 col-lg-9">
                                                                    <select class="form-control input-sm" name="modalhorariosugerido" id="modalhorariosugerido">
                                                                        <option>Seleccione</option>
                                                                        <option value="9:00 am - 12 pm">9:00 am - 12 pm</option>
                                                                        <option value="12:00 pm - 3:00 pm">12:00 pm - 3:00 pm</option>
                                                                        <option value="3:00 pm - 6:00 pm">3:00 pm - 6:00 pm</option>
                                                                    </select>  
                                                   
                    					</div>
                    				</div>
                    				<div class="form-group row">
                    					<label for="modalcomentario_comercial" class="col-lg-3 col-form-label">COMENTARIO: <span class="text-danger">*</span></label>
                    					<div class="col-12 col-lg-9">
                    					      <textarea class="form-control input-sm" name="modalcomentario_comercial" id="modalcomentario_comercial" rows="4" style="resize:none" placeholder="Ingresar...">
                    					          
                    					      </textarea>
                    					</div>
                    				</div>
                    			</div>
                    			<div class="modal-footer justify-content-between">
                    				<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                    				<button type="button" class="btn btn-danger" id="btnAgregarRespuesta" name="btnAgregarRespuesta"><i class="fa fa-plus"></i>&nbsp Agregar</button>
                    			</div>
                    		</div>
                    		<!-- /.modal-content -->
                    	</div>
                    	<!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->                     
                    
                    
                    
            </div>
            </section>
            <!-- /.content -->
            <?php include 'modalpassword.php';?>
        </div>
        <!-- /.content-wrapper -->
        <div class="control-sidebar-bg"></div>
        </div>
        <!-- ./wrapper -->
        <!-- jQuery v1.11 -->
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
            $.widget.bridge('uibutton', $.ui.button);
        </script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
        <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- SweetAlert -->
        <script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <!-- Bootstrap toogle -->
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>
        <!-- Notificaciones -->
        <script src="js/notificaciones_v3.js?v=1" type="text/javascript"></script>
        <!-- LEAFLET -->
        <script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js" integrity="sha512-XQoYMqMTK8LvdxXYG3nZ448hOEQiglfqkJs1NOQV44cWnUrBc8PkAOcXy20w0vlaXaVUearIOBhiXZ5V3ynxwA==" crossorigin=""></script>
        <script src="lib/leaflet_AwesomeMarkers/dist/leaflet.awesome-markers.js"></script>
        <!-- MOMENT -->
        <script src="lib/moment/moment.min.js"></script>
        <!-- iCheck 1.0.1 -->
        <script src="admin//plugins/iCheck/icheck.min.js"></script>
        <!--GLOBALES -->
        <script>
            //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE REGALOS
            let arregloRegalos = [];
            //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE EXTRAS
            let arregloDatos = [];
            //ARREGLO GENERAL DE KIT, REGALOS Y EXTRAS
            let arregloGeneral = [];
            
            let arregloDatosCert=[];
            
            const listaExtras = document.querySelector('#listaExtras');
            const listaRegalos = document.querySelector('#listaRegalos');
            
            
        </script>
        <!-- GRID -->
        <script>
            var columnDefs = [
                {headerName: 'FechaHoraREG', field: 'FechaHoraREG', width: 140},
                {headerName: 'FechaInst', field: 'FechaInst', width: 130},
                {headerName: 'HoraInst', field: 'HoraInst', width: 105},
                {headerName: 'InstaladoX', field: 'InstaladoX', width: 100},
                {headerName: 'MatriculaTec', field: 'MatriculaTec', width: 110},
                {headerName: 'Repercusion', field: 'Repercusion', width: 130},
                {headerName: 'MotivoInviable', field: 'MotivoInviable', width: 150},
                {headerName: 'Comentario', field: 'Comentario', width: 200},
                {headerName: 'EstadoVenta', field: 'EstadoVenta', width: 120},
                {headerName: 'Gestor', field: 'GestorAgenda', width: 120}
            ];
            
            var gridOptions = {
                columnDefs: columnDefs,
                rowData: null,
                enableFilter: true,
                enableColResize: true,
                localeText: {
                    // for filter panel
                    page: 'página',
                    more: 'Más',
                    to: 'a',
                    of: 'de',
                    next: 'Siguiente',
                    last: 'Último',
                    first: 'Primero',
                    previous: 'Anterior',
                    loadingOoo: 'Cargando...',
                    // for set filter
                    selectAll: 'Seleccionar todo',
                    searchOoo: 'Buscando...',
                    blanks: 'Espacios en blanco',
                    // for number filter and text filter
                    filterOoo: 'Filtrar...',
                    applyFilter: 'Aplicar Filtro',
                    // for number filter
                    equals: 'Igual',
                    notEqual: 'No es igual',
                    lessThanOrEqual: 'Menor o igual',
                    greaterThanOrEqual: 'Mayor que o igual',
                    inRange: 'En el rango',
                    lessThan: 'Menos que',
                    greaterThan: 'Mas grande que',
                    // for text filter
                    contains: 'Contiene',
                    startsWith: 'Comienza con',
                    endsWith: 'Termina con',
                    notContains:'No contiene',
                    // the header of the default group column
                    group: 'Grupo',
                    // tool panel
                    columns: 'columnas',
                    rowGroupColumns: 'Grupo columnas',
                    rowGroupColumnsEmptyMessage: 'No hay resultado',
                    valueColumns: 'Columna de valor',
                    pivotMode: 'Modo pivote',
                    groups: 'grupos',
                    values: 'valor',
                    pivots: 'pivote',
                    valueColumnsEmptyMessage: 'No hay resultado',
                    pivotColumnsEmptyMessage: 'No hay resultado',
                    // other
                    noRowsToShow: '<div class="callout callout-danger">\n\
                                    <span class="pull-left">\n\
                                    <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
                                    </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
                                    <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
                                    <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
                                    <br></div>'
                    ,
                    // enterprise menu
                    pinColumn: 'Aclar columna',
                    valueAggregation: 'Agregar valor',
                    autosizeThiscolumn: 'Auto tamaño esta columna ',
                    autosizeAllColumns: 'Auto tamaño todas columnas',
                    groupBy: 'Agrupar',
                    ungroupBy: 'Agrupar uno',
                    resetColumns: 'Restaurar Columnas',
                    expandAll: 'expandir todo',
                    collapseAll: 'desplegar todo',
                    toolPanel: 'Panel de Heramientas',
                    export: 'Exportar',
                    csvExport: 'Exportar CSV',
                    excelExport: 'Exportar Excel',
                    // enterprise menu pinning
                    pinLeft: 'Anclar a derecha',
                    pinRight: 'Anclar a izquierda',
                    noPin: 'Desanclar',
                    // enterprise menu aggregation and status panel
                    sum: 'Sumar',
                    min: 'Minimo',
                    max: 'Maximo',
                    first: 'Primero',
                            last: 'Ultimo',
                            none: 'Nada',
                    count: 'Contador',
                    average: 'Promedio',
                    // standard menu
                    copy: 'Copiar',
                    copyWithHeaders: 'Copiar Cabecera',
                    ctrlC: 'Ctrl+C',
                    paste: 'Pegar',
                    ctrlV: 'Ctrl+V'
                },
                enableSorting: true
            };

            var columnDefsCert = [
                        {headerName: 'FechaHoraREG', field: 'FechaHoraRegistro', width: 140},
                        {headerName: 'MatriculaAsignada', field: 'MatriculaAsignada', width: 70},                        
                        {headerName: 'FechaAsignacion', field: 'FechaAsignacion', width: 130},
                        {headerName: 'MatriculaGestor', field: 'MatriculaGestor', width: 130},
                        {headerName: 'EstadoLlamada', field: 'EstadoLlamada', width: 130},
                        {headerName: 'Comentario', field: 'Comentario', width: 130},
                        {headerName: 'FechaHoraProgramacion', field: 'FechaHoraProgramacion', width: 130},
                        {headerName: 'numerollamadas', field: 'numerollamadas', width: 130}
            ];
        
            var gridOptionsCert = {
                columnDefs: columnDefsCert,
                rowData: null,
                enableFilter: true,
                enableColResize: true,
                localeText: {
                    // for filter panel
                    page: 'página',
                    more: 'Más',
                    to: 'a',
                    of: 'de',
                    next: 'Siguiente',
                    last: 'Último',
                    first: 'Primero',
                    previous: 'Anterior',
                    loadingOoo: 'Cargando...',
                    // for set filter
                    selectAll: 'Seleccionar todo',
                    searchOoo: 'Buscando...',
                    blanks: 'Espacios en blanco',
                    // for number filter and text filter
                    filterOoo: 'Filtrar...',
                    applyFilter: 'Aplicar Filtro',
                    // for number filter
                    equals: 'Igual',
                    notEqual: 'No es igual',
                    lessThanOrEqual: 'Menor o igual',
                    greaterThanOrEqual: 'Mayor que o igual',
                    inRange: 'En el rango',
                    lessThan: 'Menos que',
                    greaterThan: 'Mas grande que',
                    // for text filter
                    contains: 'Contiene',
                    startsWith: 'Comienza con',
                    endsWith: 'Termina con',
                    notContains:'No contiene',
                    // the header of the default group column
                    group: 'Grupo',
                    // tool panel
                    columns: 'columnas',
                    rowGroupColumns: 'Grupo columnas',
                    rowGroupColumnsEmptyMessage: 'No hay resultado',
                    valueColumns: 'Columna de valor',
                    pivotMode: 'Modo pivote',
                    groups: 'grupos',
                    values: 'valor',
                    pivots: 'pivote',
                    valueColumnsEmptyMessage: 'No hay resultado',
                    pivotColumnsEmptyMessage: 'No hay resultado',
                    // other
                    noRowsToShow: '<div class="callout callout-danger">\n\
        <span class="pull-left">\n\
        <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
        </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
        <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
        <br></div>',
                    // enterprise menu
                    pinColumn: 'Aclar columna',
                    valueAggregation: 'Agregar valor',
                    autosizeThiscolumn: 'Auto tamaño esta columna ',
                    autosizeAllColumns: 'Auto tamaño todas columnas',
                    groupBy: 'Agrupar',
                    ungroupBy: 'Agrupar uno',
                    resetColumns: 'Restaurar Columnas',
                    expandAll: 'expandir todo',
                    collapseAll: 'desplegar todo',
                    toolPanel: 'Panel de Heramientas',
                    export: 'Exportar',
                    csvExport: 'Exportar CSV',
                    excelExport: 'Exportar Excel',
                    // enterprise menu pinning
                    pinLeft: 'Anclar a derecha',
                    pinRight: 'Anclar a izquierda',
                    noPin: 'Desanclar',
                    // enterprise menu aggregation and status panel
                    sum: 'Sumar',
                    min: 'Minimo',
                    max: 'Maximo',
                    first: 'Primero',
                            last: 'Ultimo',
                            none: 'Nada',
                    count: 'Contador',
                    average: 'Promedio',
                    // standard menu
                    copy: 'Copiar',
                    copyWithHeaders: 'Copiar Cabecera',
                    ctrlC: 'Ctrl+C',
                    paste: 'Pegar',
                    ctrlV: 'Ctrl+V'
                },
                enableSorting: true
            };



            
            var columnDefsComentarioCert  = [
                        {headerName: 'FechaHoraREG', field: 'FechaHoraREG', width: 140},
                        {headerName: 'Matricula', field: 'Matricula', width: 70},                        
                        {headerName: 'HorarioSugerido', field: 'HorarioSugerido', width: 130},
                        {headerName: 'Comentario', field: 'Comentario', width: 235}
            ]; 
        
            var gridOptionsComentarioCert = {
                columnDefs: columnDefsComentarioCert,
                rowData: null,
                enableFilter: true,
                enableColResize: true,
                localeText: {
                    // for filter panel
                    page: 'página',
                    more: 'Más',
                    to: 'a',
                    of: 'de',
                    next: 'Siguiente',
                    last: 'Último',
                    first: 'Primero',
                    previous: 'Anterior',
                    loadingOoo: 'Cargando...',
                    // for set filter
                    selectAll: 'Seleccionar todo',
                    searchOoo: 'Buscando...',
                    blanks: 'Espacios en blanco',
                    // for number filter and text filter
                    filterOoo: 'Filtrar...',
                    applyFilter: 'Aplicar Filtro',
                    // for number filter
                    equals: 'Igual',
                    notEqual: 'No es igual',
                    lessThanOrEqual: 'Menor o igual',
                    greaterThanOrEqual: 'Mayor que o igual',
                    inRange: 'En el rango',
                    lessThan: 'Menos que',
                    greaterThan: 'Mas grande que',
                    // for text filter
                    contains: 'Contiene',
                    startsWith: 'Comienza con',
                    endsWith: 'Termina con',
                    notContains:'No contiene',
                    // the header of the default group column
                    group: 'Grupo',
                    // tool panel
                    columns: 'columnas',
                    rowGroupColumns: 'Grupo columnas',
                    rowGroupColumnsEmptyMessage: 'No hay resultado',
                    valueColumns: 'Columna de valor',
                    pivotMode: 'Modo pivote',
                    groups: 'grupos',
                    values: 'valor',
                    pivots: 'pivote',
                    valueColumnsEmptyMessage: 'No hay resultado',
                    pivotColumnsEmptyMessage: 'No hay resultado',
                    // other
                    noRowsToShow: '<div class="callout callout-danger">\n\
        <span class="pull-left">\n\
        <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
        </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
        <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
        <br></div>',
                    // enterprise menu
                    pinColumn: 'Aclar columna',
                    valueAggregation: 'Agregar valor',
                    autosizeThiscolumn: 'Auto tamaño esta columna ',
                    autosizeAllColumns: 'Auto tamaño todas columnas',
                    groupBy: 'Agrupar',
                    ungroupBy: 'Agrupar uno',
                    resetColumns: 'Restaurar Columnas',
                    expandAll: 'expandir todo',
                    collapseAll: 'desplegar todo',
                    toolPanel: 'Panel de Heramientas',
                    export: 'Exportar',
                    csvExport: 'Exportar CSV',
                    excelExport: 'Exportar Excel',
                    // enterprise menu pinning
                    pinLeft: 'Anclar a derecha',
                    pinRight: 'Anclar a izquierda',
                    noPin: 'Desanclar',
                    // enterprise menu aggregation and status panel
                    sum: 'Sumar',
                    min: 'Minimo',
                    max: 'Maximo',
                    first: 'Primero',
                            last: 'Ultimo',
                            none: 'Nada',
                    count: 'Contador',
                    average: 'Promedio',
                    // standard menu
                    copy: 'Copiar',
                    copyWithHeaders: 'Copiar Cabecera',
                    ctrlC: 'Ctrl+C',
                    paste: 'Pegar',
                    ctrlV: 'Ctrl+V'
                },
                enableSorting: true
            };            
            
            function onFilterChanged(value) {
                gridOptions.api.setQuickFilter(value);
            }
            
            function listar() {
                var idventa=$("#idVenta").val();
                $.ajax({
                    url: 'ajax/findDataHisAgenda.php?idventa='+idventa,
                    success: function (data) {
                        if (data == 1) {
                            var gridDiv = document.querySelector('#myGrid');
                            new agGrid.Grid(gridDiv, gridOptions);
            
                            agGrid.simpleHttpRequest({url: 'ajax/selectListarHistAgenda.php?idventa='+idventa}).then(function (data) {
            
                                gridOptions.api.setRowData(data);
                            });
                            $('#vistaboy').height(function (index, height) {
            
                                return $(window).height() * 35 / 100;
                            });
                        } else {
            
                            $("#ningunresultado").html(data);
            
                            var gridDiv = document.querySelector('#myGrid');
                            new agGrid.Grid(gridDiv, gridOptions);
            
                            agGrid.simpleHttpRequest({url: 'ajax/selectListarHistAgenda.php?idventa='+idventa}).then(function (data) {
            
                                gridOptions.api.setRowData(data);
                            });
            
            
            
                            $('#myGrid').hide("fast");
            
                        }
                    }
                });
            }
            
            var refresh = function () {
                var idventa=$("#idVenta").val();
                $.ajax({
                    url: 'ajax/findDataHisAgenda.php?idventa='+idventa,
                    success: function (data) {
                        if (data == 1) {
                            var gridDiv = document.querySelector('#myGrid');
                            agGrid.simpleHttpRequest({url: 'ajax/selectListarHistAgenda.php?idventa='+idventa}).then(function (data) {
                                gridOptions.api.setRowData(data);
                            });
                            $('#vistaboy').height(function (index, height) {
                
                                return $(window).height() * 35 / 100;
                            });
                            $("#ningunresultado").hide("fast");
                            $('#myGrid').show(200);
                        } else {
                
                            $("#ningunresultado").html(data);
                            $('#myGrid').hide("fast");
                
                        }
                    }
                });
            }

        function listarCert() {
            var gridDiv = document.querySelector('#myGrid_cert');
            new agGrid.Grid(gridDiv, gridOptionsCert);
        }
        function listarComentarioCert() {
            var gridDiv = document.querySelector('#myGrid_comentariocertcert');
            new agGrid.Grid(gridDiv, gridOptionsComentarioCert);
        }    

var refresh_cert = function () {
                var idventa=$("#idcertventa").val();

                    var datos = {
                        array:'array8',
                        idventa: idventa
                    };            
                
                $.ajax({
                    type: 'POST',
                    url: './Controller/ControllerVenta.php',
    	            data: {function: JSON.stringify(datos)}, 
                    dataType: "Json",
                    success: function (data) {
    
                        if(data.length>0){
                                var gridDiv = document.querySelector('#myGrid_cert');
                                gridOptionsCert.api.setRowData(data);
                                $('#vistaboy_cert').height(function (index, height) {
                                    return $(window).height() * 35 / 100;
                                });
                                $("#ningunresultado_cert").hide("fast");
                                $('#myGrid_cert').show(200);                
                        }else{
                                $("#ningunresultado_cert").html(`
                                    <div class="callout bg-gray">
                                        <span class="pull-left">
                                          <img src="admin/dist/img/noresults-img.png" style="width: 70%">
                                        </span>
                                          <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                                        <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                                        <br>
                                    </div>                        
                                `);
                                $('#myGrid_cert').hide("fast");                
                        }
                    }
                });
                
        
            }			
     var refresh_comenariocert = function () {
            var idventa=$("#idVenta").val();

                var datos = {
                    array:'array6',
                    idventa: idventa
                };            
            
            $.ajax({
                type: 'POST',
                url: './Controller/ControllerVenta.php',
	            data: {function: JSON.stringify(datos)}, 
                dataType: "Json",
                success: function (data) {

                    if(data.length>0){
                            var gridDiv = document.querySelector('#myGrid_comentariocertcert');
                            gridOptionsComentarioCert.api.setRowData(data);
                            $('#vistaboy_comentariocertcert').height(function (index, height) {
                                return $(window).height() * 35 / 100;
                            });
                            $("#ningunresultado_comentariocert").hide("fast");
                            $('#myGrid_comentariocertcert').show(200);                
                    }else{
                            $("#ningunresultado_comentariocert").html(`
                                <div class="callout bg-gray">
                                    <span class="pull-left">
                                      <img src="admin/dist/img/noresults-img.png" style="width: 70%">
                                    </span>
                                      <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                                    <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                                    <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                                    <br>
                                </div>                        
                            `);
                            $('#myGrid_comentariocertcert').hide("fast");                
                    }
                }
            });
            
    
        }   


	            
        </script>
        <!-- EVENT LISTENER -->
        <script>
            $("#lbldc").change(function () {
                $("#lbldc option:selected").each(function () {
                    var lbldc = $(this).val();
                    $.post("./ajax/selectJefeVenta.php", { lbldc: lbldc }, function(data){
                        $("#lbljefeventa").html(data);
                    });            
                });
            });
            
            $("#lblinstaladox").change(function () {
                   $("#lblinstaladox option:selected").each(function () {
                   var lblinstaladox= $(this).val();
                    $.post("./ajax/selectTecnico.php", { lblinstaladox: lblinstaladox }, function(data){
                        $("#lbltecnico").html(data);
                    });            
                });
            });
            
            $("#lblestadoventa").change(function () {
                var condiciones = $("#lblestadoventa").val();
                $("#lblestventa").val(condiciones);
                bloquear(condiciones);
            });
            
            $("#lbltipoventa").change(function () {
                var tps= $("#lbltipoventa").val();
                $("#lbltiventa").val(tps);
            });
            
            
            
            $("#lblcategoria").change(function () {
                var categoria = $("#lblcategoria").val();
                var recurso=$("#lbltiventa").val();
                 $("#lblcat").val(categoria);
                bloquearxCategoria(categoria);
                if(recurso=="RE" || recurso=="RPMKT"){
                    if(categoria=="Ficha"){
                        $("#lblestadoventa").val("PendienteAgenda");
                        $("#lblestvisita").val("Vendida");
                        $("#lblestventa").val("PendienteAgenda");
                    
                    }
                    if(categoria =="Online"){
                        $("#lblestadoventa").val("PendienteData");
                        $("#lblestvisita").val("Vendida");
                        $("#lblestventa").val("PendienteData");
                    
                    }
                    if(categoria =="VAsignada"){
                        $("#lblestadoventa").val("VAsignada");
                        $("#lblestvisita").val("Asignada");
                        $("#lblestventa").val("VAsignada");
                    }
                    if(categoria =="Delegacion"){
                        $("#lblestadoventa").val("AgendadaDEL");
                        $("#lblestvisita").val("Vendida");
                        $("#lblestventa").val("AgendadaDEL");
                        //$('#lblestadoventa')[0].disabled=true;
                        //$('#lblncontrato')[0].disabled=false;
                        $('#lblestadoventa')[0].disabled=false;
                        $('#lblncontrato')[0].disabled=false;
                    
                    }
                    if(categoria =="NoVendida"){
                        $("#lblestadoventa").val("NoVendida");
                        $("#lblestvisita").val("NoVendida");
                        $("#lblestventa").val("NoVendida");
                        $('#lblestadoventa')[0].disabled=true;
                    }
                }else{
                    if(categoria =="Ficha"){
                    $("#lblestadoventa").val("PendienteAgenda");
                    $("#lblestventa").val("PendienteAgenda");
                    $('#lblestadoventa')[0].disabled=true;
                    $("#lblestvisita").val("");
                    }
                    if(categoria =="Online"){
                    $("#lblestadoventa").val("PendienteData");
                    $("#lblestventa").val("PendienteData");
                    $("#lblestvisita").val("");
                    }
                    if(categoria =="Delegacion"){
                    $("#lblestadoventa").val("AgendadaDEL");
                    $("#lblestventa").val("AgendadaDEL");
                    $("#lblestvisita").val("");
                    //$('#lblestadoventa')[0].disabled=true;
                            $('#lblestadoventa')[0].disabled=false;
                            $('#lblncontrato')[0].disabled=false;
                    
                    }
                    if(categoria =="NoVendida"){
                    $("#lblestadoventa").val("NoVendida");
                    $("#lblestventa").val("NoVendida");
                    $("#lblestvisita").val("");
                    $('#lblestadoventa')[0].disabled=true;
                    }    
                    if(categoria =="ProspectoRP"){
                    $("#lblestadoventa").val("ProspectoRP");
                    $("#lblestvisita").val("");
                    $("#lblestventa").val("ProspectoRP");
                    }
                }
            });
            
            $('#lblmatricula').on('keyup', function () {
                var dato = $('#lblmatricula').val();
                var url = 'ajax/findMatricula.php';
                $.ajax({
                    type: 'POST',
                    url: url,
                    data: 'dato=' + dato,
                    success: function (datos) {
                        $('.mensajematricula').html(datos);
                    }
                });
                return false;
            });
            
            $("#lblmatricula").autocomplete({
                source: "./ajax/selectMatricula.php",
                minLength: 2,
                select: function (event, ui) {
                    event.preventDefault();
                    $('#lblidusuario').val(ui.item.idusuario);
                    $('#lblmatricula').val(ui.item.matricula);
                    $('#lblnombcomercial').val(ui.item.comercial);
            //                        $('#lbldc').val(ui.item.dc);
            //                        $('#lbljefeventa').val(ui.item.jefe);
                 
                }
            });
            
            $("#lblmatricula").on("keydown", function (event) {
                if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE)
                {
                    $('#lblidusuario').val("");
                    $('#lblmatricula').val("");
                    $('#lblnombcomercial').val("");
            //                        $('#lbldc').val("");
            //                        $('#lbljefeventa').val("");
            
                }
                if (event.keyCode == $.ui.keyCode.DELETE) {
                    $('#lblmatricula').val("");
                    $('#lblidusuario').val("");
                    $('#lblnombcomercial').val("");
            //                        $('#lbldc').val("");
            //                        $('#lbljefeventa').val("");
                }
            });
            
            $('#HCertificacion').change(function(){
              if($(this).prop('checked')){
                 $('#hidden_HCertificacion').val('SI');
              }else{
                $('#hidden_HCertificacion').val('NO');
               }
            });
            
            $('#logcambios').click(function () {
                refresh();
            });
            
            $('#logcambios_cert').click(function () {
                refresh_cert();
            });
            
            $('#logcambios_comentario_comercial').click(function () {
                refresh_comenariocert();
            });
            
            
            
            $('#GGCC').bootstrapToggle({
            on:'SI',
            off:'NO',
            onstyle:'success',
            offstyle:'danger'
            });
            
            $('#GGCC').change(function(){
            if($(this).prop('checked')){
                $('#hidGGCC').val('SI');
                
            }else{
                $('#hidGGCC').val('NO');
            }
            
            const scoring = $('#lblresultadoScoring').val();
            const tipokit = $('#lbltipokit').val();
            const PAI = $('#lblPAI').val();
            
            if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
                return;
            } else {
                categoriaPrecio(scoring, tipokit, PAI);
            }
            });            
            
            
            $('#lblcategoriaprecio').on('change', function(){ 
    			var tipoventa = '<?php echo $tipoventa; ?>'; 
    			if(tipoventa=="RE"){
    			    $(".mostrarEtiqueta").removeClass("hidden");
    			}else{ 
    			    if($('#lblcategoriaprecio').val()=="RENOVE" || $('#lblcategoriaprecio').val()=="EXCEPCION RENOVE" || $('#lblcategoriaprecio').val() == 'SUPER OFERTA RENOVE' || $('#lblcategoriaprecio').val()=="OFERTA RECARGADA RENOVE" || $('#lblcategoriaprecio').val()=="PRECIO ULTRA RENOVE"){
    			 
    			        $(".mostrarEtiqueta").removeClass("hidden");
    			        $("#lblDescuentoCuota option[value='4meses']").show();
    			    }else{
    			        
    			        $(".mostrarEtiqueta").addClass("hidden");
    			        $("#lblDescuentoCuota option[value='4meses']").hide();
    			    }
    			}
			})
            
        </script>
        <!-- INICIALIZADORES -->
        <script>
            $('input[type="checkbox"].minimal-red, input[type="radio"].minimal-red').iCheck({
                  checkboxClass: 'icheckbox_minimal-red',
                  radioClass   : 'iradio_minimal-red'
            })
                
            $('#HCertificacion').bootstrapToggle({
                    on:'SI',
                    off:'NO',
                    onstyle:'success',
                    offstyle:'danger'
                });
                                                                                
            $('.selectdistrito').select2({
                placeholder: 'Seleccione Distrito - Provincia',
                allowClear: true,
                language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {
            
                        return "Buscando..";
                    }
                },
                ajax: {
                    url: 'ajax/selectDistritoField.php',
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                }
            });
            
                $('.selectdistrito').on('select2:select', function (e) {
                    var data = e.params.data;
                    $('#lblIdDepartamental').val(data.IdDepartamental);
                    $('#lblIdProvincial').val(data.IdProvincial);
                    $('#lblCodUbigeoReniec').val(data.CodUbigeoReniec);
                    
                    cargardepartamento();
                    //console.log(data);
                });             
                        
            $('.cbxtecnico').select2({
                placeholder: 'Seleccione',
                allowClear: true,
                language: {
                    errorLoading: function () {
                        return "La carga falló";
                    },
                    noResults: function () {
                        return "No hay resultado";
                    },
                    searching: function () {
            
                        return "Buscando..";
                    }
                }
            });
                                                                              
            $('#datemask').inputmask('dd/mm/yyyy', {'placeholder': 'dd/mm/yyyy'});
            $('#lblfecharecpciondoc').datepicker({
            autoclose: true,
            language: 'es',
            firstDay: 1
            });
            $('#lblfechafacturacion').datepicker({
            autoclose: true,
            language: 'es',
            firstDay: 1
            });
            //Money Euro
            $('[data-mask]').inputmask();
            //Date picker
            var DP_FechaFin = new Date();
            var dias = 30; // Número de días a agregar
            DP_FechaFin.setDate(DP_FechaFin.getDate() + dias);
            
            $('#fechainst').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1,
                todayHighlight: true,
                format: 'dd/mm/yyyy',
                startDate: new Date(),
                endDate: DP_FechaFin,
                clearBtn:true,
                todayBtn: 'linked',
            });
            $('#lblRvencimiento').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1,
                todayHighlight: true,
                format: 'dd/mm/yyyy',
                clearBtn:true,
                todayBtn: 'linked',
            });            
            //Date picker
            $('#horainst').timepicker({
                defaultTime:false,
                showInputs: true,
                minuteStep: 1
            });
            
            $('#mesano').datepicker({
                autoclose: true,
                language: 'en',
                firstDay: 1, format: 'M-yyyy',
                viewMode: "years",
                minViewMode: "months",
                clearBtn:true,
                todayBtn: 'linked',
                todayHighlight:true
            });
                                                                            
            $('#slider').css('margin-left', '-' + 100 + '%');
        </script>
        <!-- DOCUMENT READY -->
        <script>
            $(document).ready(function () {
                    
                listar();
                listarCert();
                listarComentarioCert();
                var tipoVentaData = $("#tipoVenta").val();
                var categoriaVentaData = $("#categoriaVenta").val();
                var estadoVentaData = $("#estadoVenta").val();
                bloquear(estadoVentaData);
                bloquearxCategoria(categoriaVentaData);
                bloquearxRecurso(tipoVentaData);
                
                $('#lbltipokit').val($('#valtipokit').val());
                $('#lbltipocamarakit').val($('#valtipocamarakit').val());
                //FUNCION SCORING
                $('#lblresultadoScoring').val($('#valresultadoScoring').val());
                
                //NOTIFICACIONES
                const headerCCUsuario = $('#headerCCUsuario').val();
                notificacionVisitasField(headerCCUsuario);
                //SCORING
                cargardepartamento();
                
                //Ubicacion del cliente
                //let direccion = buscarDireccion();
            
                var alterClass = function () {
                    var ww = document.body.clientWidth;
                    if (ww < 767) {
                        $('body').removeClass('sidebar-collapse');
                    } else if (ww >= 768) {
                        $('body').addClass('sidebar-collapse');
                    }
                    ;
                };
            
                $(window).resize(function () {
                    alterClass();
                });
                //Fire it when the page first loads:
                alterClass();
                //OCULTAR EL BOTON DE CHECKIN SI SE ENVIO EL CHECK-IN
                const lbldc = $('#lbldc').val();
                const lbltiventa = $('#lbltiventa').val();
            
                if(lbltiventa == 'RE'){
                    console.log(lbldc);
                    if(lbldc == '500'){
                        $('#btnCheckIn').addClass('ocultar');
                        $('#btnCheckOut').addClass('ocultar');
                    } else {
                        const infocheckin = $('#infocheckin').val();
                        const infocheckout = $('#infocheckout').val();
                        const historial = parseInt($('#lbltotalhistorialcheckout2').val());
                        const fechalimiteenviocheckout = $('#fechalimiteenviocheckout').val();
                        const fechaactual = Math.floor(new Date().getTime() / 1000);
                        console.log(infocheckin);
                        
                        if(infocheckin === ''){
                            $('#btnCheckIn').removeClass('ocultar');
                            $('#btnCheckOut').addClass('ocultar');
                        } else {
                            $('#btnCheckIn').addClass('ocultar');
                            if(infocheckout != '' && fechaactual > fechalimiteenviocheckout){
                                //alert("hola");
                                $('#btnCheckOut').addClass('ocultar');
                            } else {
                                $('#btnCheckOut').removeClass('ocultar');
                            }
                        }
                        
                        if(historial == 0 || historial == 'NULL' || historial == ''){
                            $('#btnHistorialCheckOut').addClass('ocultar');
                        }
                    }
                } else {
                    $('#btnCheckIn').addClass('ocultar');
                    $('#btnCheckOut').addClass('ocultar');
                    $('#btnHistorialCheckOut').addClass('ocultar');
                }
                
                <?php include 'jspassword.php';?>
                
                 $('.select2full').select2({
                  selectOnClose: true
                });
                                                                                        
                                                                                       
                $(document).on('keydown', '.select2', function(e) {
                  if (e.originalEvent && e.which == 40) {
                    e.preventDefault();
                    $(this).siblings('select').select2('open');
                  } 
                });
                $(document).on("select2:close", '.select2-hidden-accessible', function () { $(this).focus(); });
                
                //************************************************************
                //--------------NUEVA FUNCIONALIDAD CARRITO DE COMPRA---------
                //************************************************************
                
                const scoring = $('#lblresultadoScoring').val();
                const tipokit = $('#lbltipokit').val();
                const PAI = $('#lblPAI').val();
                
                if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
                    return;
                } else {
                    categoriaPrecio(scoring, tipokit, PAI);
                    
                    closingPack();
                    
                    $('#lblclosingpack').val($('#valclosingpack').val());   
                }
                
                //GUARDAR DATOS EN LOS ARREGLOS GLOBALES
                
                //ARREGLO GENERAL
                if($('#datosGeneral').val() != ''){
                    arregloGeneral = JSON.parse($('#datosGeneral').val());
                }
                if($('#datosRegalos').val() != ''){
                    arregloRegalos = JSON.parse($('#datosRegalos').val());
                }
                if($('#datosExtras').val() != ''){
                    arregloDatos = JSON.parse($('#datosExtras').val());
                }

                    if($('#datosIncidencia').val() != ''){
        			      arregloDatosCert = JSON.parse($('#datosIncidencia').val());
        			      datosHTMLN();
        			}                
                
                                        
            });
            

const contenedorNuevosDatos = document.querySelector('#tbdatos tbody');
    
    

function datosHTMLN() {
    limpiarHTML(contenedorNuevosDatos);

    let resumen = '';
    let total = 0;
    let totalcantidad = 0;
    let totalCuota = 0;
    let fila = 1;

    let pesobruto = 0;

    let myJsonString = JSON.stringify(arregloDatosCert);


    arregloDatosCert.forEach(
        datos => {
          
            const {
                IdIncidencia,
                Motivo,
                SubMotivo,
                FechaIncidencia,
                FechaSolucion,
                Resuelto
            } = datos;

            const row = document.createElement('tr');
            row.innerHTML = `
                            <td data-label="#">${fila}</td>
                            <td data-label="Motivo">${Motivo}</td>
                            <td data-label="SubMotivo">${SubMotivo}</td>
                            <td data-label="FechaIncidencia">${FechaIncidencia}</td>
                            <td data-label="Resuelto">
                            <a href="#" class="btn ${Resuelto === 'SI' ? 'btn-success' : 'btn-danger'} btn-sm" style="margin-left: 5px;" data-id="${IdIncidencia}"> ${Resuelto}</a></td>
                            <td data-label="FechaSolucion">${FechaSolucion}</td>
                            <td data-label="Opciones"></td>
                        `
            contenedorNuevosDatos.appendChild(row);
            fila++;

        })

}


//Elimina los cursos del tbody
function limpiarHTML(cont) {
    //forma recomendada
    while (cont.firstChild) {
        cont.removeChild(cont.firstChild);
    }

    $('#txtResumen').val('');
    $('#txtCantidad').val('');
    $('#txtTotal').val('');
    $('#txtJson').val('');
}            
            
            <?php include 'jsfuncionpassword.php';?>
        </script>
        <!-- BOTON GUARDAR -->
        <script>
            $('#btnGuardarEditarVenta').click(function () {
                var estadoGuiaRemision = $('#estadoGuiaRemision').val();
                // if(estadoGuiaRemision === 'Delegacion'){
                //     Swal.fire({
                //             title: 'Advertencia!',
                //             text: 'La Guia de Remisión esta pendiente no puedes generar la venta',
                //             icon: 'warning',
                //             showCancelButton: false,
                //             confirmButtonText: 'OK',
                //             closeOnConfirm: false,
                //             allowOutsideClick: false
                //         }).then((result) => {
                //             // Si el usuario hace clic en OK, recargar la página
                //             if (result.isConfirmed) {
                //                 // window.location.reload();
                //             }
                //         });
                // }else{
                    var gestor=$("#matriculaUsuario").val();
                    var catgventa=$('#lblcat').val();
                    var ediventa=$("#idVenta").val();
                    //Algunas variables por default de alertify
                    alertify.defaults.theme.ok = "btn btn-nuevo";
                    alertify.defaults.theme.cancel = "btn btn-danger";
                            
                    var lastX,lastY;
                    alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function(){ 
                        if (validaForm()) {
                        // Primero validará el formulario.
                        //var datos = $('#frmEditarVenta').serialize();
                        //console.log(datos);
                        
                        var lblmatricula = $('#lblmatricula').val();
                        var lblidusuario = $('#lblidusuario').val();
                        var lblnombcomercial = $('#lblnombcomercial').val();
                        var lbldc = $('#lbldc').val();
                        var lbljefeventa = $('#lbljefeventa').val();
                        var lblestadoventa = $('#lblestadoventa').val();
                        var lblestventa = $('#lblestventa').val();
                        var lblestvisita = $('#lblestvisita').val(); 
                        var lbltipoventa = $('#lbltipoventa').val();
                        var lbltiventa = $('#lbltiventa').val();
                        var lblsegmento = $('#lblsegmento').val();
                        var lblmesesautorizados = $('#lblmesesautorizados').val();
                        var lblnprospecto = $('#lblnprospecto').val();
                        var lblncontrato = $('#lblncontrato').val();
                        var lblnombcliente = $('#lblnombcliente').val().trim();
                        var lblidcliente = $('#lblidcliente').val();
                        var lblcorreo = $('#lblcorreo').val();
                        var lbldireccion = $('#lbldireccion').val();
                        var lbldistrito = $('#lbldistrito').val();
                        var lblmovil = $('#lblmovil').val();
                        var lblfijo = $('#lblfijo').val();
                        var lblpreciokit = $('#lblpreciokit').val();
                        var lbltotalextra = $('#lbltotalextra').val();
                        var lblresumenventa = $('#lblresumenventa').val();
                        var lblextraautorizado = $('#lblextraautorizado').val();
                        var lblformadepago = $('#lblformadepago').val();
                        var lbl590 = $('#mesano').val();
                        var lblPAI = $('#lblPAI').val();
                        var lblinstaladox = $('#lblinstaladox').val();
                        var lblidagenda = $('#lblidagenda').val();
                        var lbltecnico = $('#lbltecnico').val();
                        var lblfinstalacion = $('#fechainst').val();
                        var lblhinstalacion = $('#horainst').val();
                        var lblrepercucion = $('#lblrepercucion').val();
                        var lblcomentarioagenda = $('#lblcomentarioagenda').val();
                        var lblinviable = $('#lblinviable').val();
                        var lblcancelado = $('#lblcancelado').val();
                        var lblmotivoincidencia = $('#lblmotivoincidencia').val();
                        var lblfecharecpciondoc = $('#lblfecharecpciondoc').val();
                        var lblfechafacturacion = $('#lblfechafacturacion').val();
                        var hidden_HCertificacion = $('#hidden_HCertificacion').val();
                        //NUEVOS CAMPOS GENERADOS EL 02112020 PARA PILOTO ZEROVISION
                        var lbltipokit=$('#lbltipokit').val();
                        var lblclosingpack=$('#lblclosingpack').val();
                        var lblprecioEspecial=$('#lblprecioEspecial').val();
                        var lblCantExtras=$('#lblCantExtras').val();
                        var lblresultadoScoring=$('#lblresultadoScoring').val();
                        var valcodigoOperacionScoring=$('#valcodigoOperacionScoring').val();
                        var hidGGCC=$('#hidGGCC').val();
                        var IdDocRP=$('#IdDocRP').val();
                        
                        //NUEVOS CAMPOS GENERADOS EL 03082021 PARA EXTRAS Y REGALOS
                        const lblCantRegalos = $('#lblCantRegalos').val();
                        const lbltotalcuota = $('#lbltotalcuota').val();
                        const detalleExtras = JSON.stringify(arregloDatos);
                        const detalleRegalos = JSON.stringify(arregloRegalos);
                        const detalleGeneral = JSON.stringify(arregloGeneral);
                        
                        //NUEVOS CAMPOS GENERADOS PARA LA OFERTA
                        const lblcategoriaprecio = $('#lblcategoriaprecio').val();
                        const lblDescuentoCuota = $('#lblDescuentoCuota').val();
                        //CAMPOS DE ARLOS
                        const lbltipocamarakit=$('#lbltipocamarakit').val();
                        
                        //GENERAR ATTEC REPORTE
                        const lblIteraccionAttec=$('#lblIteraccionAttec').val();
                        
                        var lblRenove = $('#lblRenove').val();
                        var lblRcompetencia = $('#lblRcompetencia').val();
                        var lblRvencimiento = $('#lblRvencimiento').val();
                        
            
                        var data = {
                            lblcategoria:catgventa, 
                            lblidventa:ediventa, 
                            gestor:gestor, 
                            lbltiventa:lbltiventa,
                            lblmatricula: lblmatricula, 
                            lblidusuario:lblidusuario, 
                            lblnombcomercial: lblnombcomercial, 
                            lbldc:lbldc, 
                            lbljefeventa:lbljefeventa, 
                            lblestadoventa:lblestadoventa, 
                            lblestventa:lblestventa, 
                            lblestvisita:lblestvisita, 
                            lbltipoventa:lbltipoventa, 
                            lblsegmento:lblsegmento, 
                            lblmesesautorizados:lblmesesautorizados, 
                            lblnprospecto:lblnprospecto, 
                            lblncontrato:lblncontrato, 
                            lblnombcliente:lblnombcliente, 
                            lblidcliente:lblidcliente, 
                            lblcorreo:lblcorreo, 
                            lbldireccion:lbldireccion, 
                            lbldistrito:lbldistrito,
                            lblmovil:lblmovil,
                            lblfijo:lblfijo,
                            lblpreciokit:lblpreciokit,
                            lbltotalextra:lbltotalextra, 
                            lblresumenventa:lblresumenventa, 
                            lblextraautorizado:lblextraautorizado, 
                            lblformadepago:lblformadepago, 
                            lbl590:lbl590, lblPAI:lblPAI, 
                            lblinstaladox:lblinstaladox, 
                            lblidagenda:lblidagenda, 
                            lbltecnico:lbltecnico, 
                            lblfinstalacion:lblfinstalacion, 
                            lblhinstalacion:lblhinstalacion, 
                            lblrepercucion:lblrepercucion, 
                            lblcomentarioagenda:lblcomentarioagenda, 
                            lblinviable:lblinviable, 
                            lblcancelado:lblcancelado, 
                            lblmotivoincidencia:lblmotivoincidencia, 
                            lblfecharecpciondoc:lblfecharecpciondoc, 
                            lblfechafacturacion:lblfechafacturacion,
                            hidden_HCertificacion: hidden_HCertificacion,
                            lbltipokit: lbltipokit,
                            lblclosingpack: lblclosingpack,
                            lblprecioEspecial: lblprecioEspecial,
                            lblCantExtras: lblCantExtras,
                            lblresultadoScoring: lblresultadoScoring,
                            valcodigoOperacionScoring:valcodigoOperacionScoring,
                            hidGGCC:hidGGCC,
                            IdDocRP:IdDocRP,
                            lblCantRegalos: lblCantRegalos,
                            lbltotalcuota: lbltotalcuota,
                            detalleExtras: detalleExtras,
                            detalleRegalos: detalleRegalos,
                            lblcategoriaprecio: lblcategoriaprecio,
                            detalleGeneral: detalleGeneral,
                            lblDescuentoCuota: lblDescuentoCuota,
                            lbltipocamarakit:lbltipocamarakit,
                            lblIteraccionAttec:lblIteraccionAttec,
                            lblRenove:lblRenove,
                            lblRcompetencia:lblRcompetencia,
                            lblRvencimiento:lblRvencimiento                            
                        }
            
                        console.log(data);
                        
                        $.ajax({
                            type: 'POST',
                            url: 'ajax/updateConsultaVenta_v3.php',
                            data: data,
                            success: function (r) {
                                if (r == 1) {
                                    alertify.success("Modificado con exito");
                                    //enviarEncuesta();
                                    
                                        Swal.fire({
                                            title: 'Modificado con exito',
                                            type: 'success',
                                            showCancelButton: false,
                                            confirmButtonColor: '#3085d6',
                                            confirmButtonText: 'OK'
                                        }).then((result) => {
                                            if (result.isConfirmed) {
                                                location.reload();
                                            }
                                        });
                                }
                                else if (r == 0){
                                    alertify.warning("No se realizaron modificaciones");
                                }
                                else if (r == 2){
                                    alertify.warning("NContrato duplicado");
                                }                                
                                else {
                                    alertify.error("Fallo el server");
                                }
                            }
                        });
                    } }
                , function(){ alertify.error('No se han guardado los cambios')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
                    lastX = window.scrollX;
                    lastY = window.scrollY;
                },
                'onfocus':function(){
                window.scrollTo(lastX, lastY);
                }  }).show(); 
                // }
                
            });
        </script>
        <!-- FUNCIONES -->
        <script>
            function bloquear(condiciones){
                                                                           
                $('#tinviable').hide();
                $('#lblinviable').hide();
                $('#lblinviable').disabled=true;
                $('#tinviableespacio').hide();
                
                $('#tcancelado').hide();
                $('#lblcancelado').hide();
                $('#lblcancelado').disabled=true;
                $('#tcanceladoespacio').hide();
                        
                                                                           
                if (condiciones == "Inviable") {
                    $('#tinviable').show();
                    $('#lblinviable').show();
                    $('#lblinviable').show();
                    $('#lblinviable').disabled=false;
                    $('#tinviableespacio').show();
                    
                }
                <?php
                if($matriculausuario=='C32805' || $matriculausuario=='CD4231' || $matriculausuario=='HA6658'|| $matriculausuario=='MF6331'|| $matriculausuario=='RF6290' || $matriculausuario=='C97801' || $matriculausuario=='DF3030' || $matriculausuario=='JG9306' || $matriculausuario=='CI8027'){
                  echo 'else if(condiciones=="Instalada" || condiciones=="Facturada" || condiciones=="Incidencia" || condiciones=="IncidenciaGestCorreo" || condiciones=="IncidenciaGestValija" || condiciones=="NoDoc" || condiciones=="DocEnvi" ){
                     $("#lblcategoria")[0].disabled=true;
                         }';
                     
                }else{
                    echo 'else if(condiciones=="AgendadaTEC" || condiciones=="Instalada" || condiciones=="Facturada" || condiciones=="Incidencia" || condiciones=="IncidenciaGestCorreo" || condiciones=="IncidenciaGestValija" || condiciones=="NoDoc" || condiciones=="DocEnvi" ){
                     $("#lblcategoria")[0].disabled=true;
                         }';
                }
                
                ?>
                
                    else if(condiciones=="AgendadaDEL"){
                        $('#lblestadoventa')[0].disabled=false;
                    }else if(condiciones=="InstaladaDEL"){
                        $('#lblncontrato')[0].disabled=false;
                    }
                
                else if(condiciones=="Cancelado"){
                    $('#tcancelado').show();
                    $('#lblcancelado').show();
                    $('#lblcancelado').disabled=false;
                    $('#tcanceladoespacio').show();
                
                } 
                else {
                    $('#tinviable').hide();
                    $('#lblinviable').hide();
                     $('#lblinviable').disabled=true;
                    $('#tinviableespacio').hide();
                    
                    $('#tcancelado').hide();
                    $('#lblcancelado').hide();
                     $('#lblcancelado').disabled=true;
                    $('#tcanceladoespacio').hide();
                    $('#lblncontrato')[0].disabled=true;
                   
                }
            
            }
            
            function bloquearxRecurso(tipoventa){
                var catec=$("#categoriaVenta").val();
            
                if(tipoventa=="RE" || tipoventa=="RP" || tipoventa=="RPPA" || tipoventa=="RPPR" || tipoventa=="RPTMK" || tipoventa=="RPMKT"){
                
                    $('#lblmatricula')[0].disabled=true;
                    
                    $('#lbldc')[0].disabled=true;
                    $('#lbljefeventa')[0].disabled=true;
                    if(catec=="Delegacion" || catec=="Online" || catec=="Ficha"){
                        if($('#lblestadoventa').val()=="AgendadaDEL"){
                            $('#lblestadoventa')[0].disabled=false;
                            
                        }else{
                            $('#lblestadoventa')[0].disabled=true;
                            
                        }
                    $('#lblncontrato')[0].disabled=true;
                    }else{
                    $('#lblestadoventa')[0].disabled=true;
                    $('#lblncontrato')[0].disabled=true;
                    }
                    $('#lblsegmento')[0].disabled=true;
                    $('#lbltipoventa')[0].disabled=true;
                    $('#lblnprospecto')[0].disabled=true;
                    $('#lblnombcliente')[0].disabled=true;
                    $('#lblcorreo')[0].disabled=true;
                    $('#lbldireccion')[0].disabled=true;
                    $('#lbldistrito')[0].disabled=true;
                    $('#lblmovil')[0].disabled=true;
                    $('#lblfijo')[0].disabled=true;
                
                }else{
                
                    $('#lblmatricula')[0].disabled=false;
                    $('#lbldc')[0].disabled=false;
                    $('#lbljefeventa')[0].disabled=false;
                    $('#lblestadoventa')[0].disabled=true;
                    $('#lbltipoventa')[0].disabled=false;
                    $('#lblsegmento')[0].disabled=false;
                    $('#lblnprospecto')[0].disabled=false;
                    $('#lblncontrato')[0].disabled=true;
                    $('#lblnombcliente')[0].disabled=false;
                    $('#lblcorreo')[0].disabled=false;
                    $('#lbldireccion')[0].disabled=false;
                    $('#lbldistrito')[0].disabled=false;
                    $('#lblmovil')[0].disabled=false;
                    $('#lblfijo')[0].disabled=false;
                
                }
            }
            
            function bloquearxCategoria(categoria){
                                                                                
                if(categoria=="Delegacion"){
                $('#lblestadoventa')[0].disabled=false;
                $('#lblncontrato')[0].disabled=false;
                $('#lblinstaladox')[0].disabled=false;
                $('#lbltecnico')[0].disabled=false;
                $('#fechainst')[0].disabled=false;
                $('#horainst')[0].disabled=false;
                $('#lblrepercucion')[0].disabled=false;
                $('#lblcomentarioagenda')[0].disabled=false;
                $('#lblinviable')[0].disabled=false;
                }else{
                $('#lblinstaladox')[0].disabled=true;
                $('#lbltecnico')[0].disabled=true;
                $('#fechainst')[0].disabled=true;
                $('#horainst')[0].disabled=true;
                $('#lblrepercucion')[0].disabled=true;
                $('#lblcomentarioagenda')[0].disabled=true;
                $('#lblinviable')[0].disabled=true;
                }
                
            }
            
            function validaCorreo() {
            // Campos de texto
                if ($("#lblcorreoenvio").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#lblcorreoenvio").val())) {
                    alertify.warning("Por favor ingresar correo válido");
                    $("#lblcorreoenvio").val($("#frmEditarVenta #lblcorreo").val());
                    return false;
                }
                return true;
            }                                                                  
                                                                     
            function validaForm() {
                // Campos de texto
                if ($("#frmEditarVenta #lblmatricula").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula correspondiente");
                    $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lblnombcomercial").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula valida");
                    $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                 if ($("#frmEditarVenta #lbldc").val() == "" || $("#frmEditarVenta #lbldc").val() == "Seleccione" ) {
                    alertify.warning("Por favor ingresar CC correcto");
                    $("#frmEditarVenta #lbldc").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
            
                if ($("#frmEditarVenta #lbljefeventa").val() == "" || $("#frmEditarVenta #lbljefeventa").val() == "No se encontraron resultado") {
                    alertify.warning("Por favor revisar Jefe de Estructura Comercial");
                    $("#frmEditarVenta #lbljefeventa").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lblestadoventa").val() == "Seleccione" || $("#frmEditarVenta #lblestadoventa").val() == "") {
                    alertify.warning("Por favor ingresar Estado de Venta correcto");
                    $("#frmEditarVenta #lblestadoventa").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblestadoventa").val() == "InstaladaDEL") {
                    if ($("#frmEditarVenta #lblncontrato").val() == "") {
                        alertify.warning("Por favor ingresar N° Contrato correcto");
                        $("#frmEditarVenta #lblncontrato").focus();
                        return false;
                    }  
                }                
                if ($("#frmEditarVenta #lbltipoventa").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Recurso correcto");
                    $("#frmEditarVenta #lbltipoventa").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblsegmento").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Segmento correcto");
                    $("#frmEditarVenta #lblsegmento").focus();
                    return false;
                }
                // if ($("#frmEditarVenta #lblmesesautorizados").val() == "") {
                //     alertify.warning("Por favor ingresar MesAutorizado.Si no tuviese coloque: 0");
                //     $("#frmEditarVenta #lblmesesautorizados").focus();
                //     return false;
                // }
            
                if ($("#frmEditarVenta #lblnombcliente").val() == "") {
                    alertify.warning("Por favor ingresar Nombre del Cliente");
                    $("#frmEditarVenta #lblnombcliente").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblcorreo").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#frmEditarVenta #lblcorreo").val())) {
                    alertify.warning("Por favor ingresar correo válido");
                    $("#frmEditarVenta #lblcorreo").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lbldireccion").val() == "") {
                    alertify.warning("Por favor ingresar la Direccion del Cliente");
                    $("#frmEditarVenta #lbldireccion").focus();
                    return false;
                }
            
                if ($("#frmEditarVenta #lbldistrito").val() =="") {
                    alertify.warning("Por favor ingresar Distrito correcto");
                 
                    $("#frmEditarVenta #lbldistrito").select2('open');
                    return false;
                }
                
                 
                if ($("#frmEditarVenta #lblmovil").val() == "") {
                    alertify.warning("Por favor ingresar Telefono, de caso contrario digite: 0");
                    $("#frmEditarVenta #lblmovil").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblpreciokit").val() == "") {
                    alertify.warning("Por favor ingresar Precio del KIT");
                    $("#frmEditarVenta #lblpreciokit").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lbltotalextra").val() == "") {
                    alertify.warning("Por favor ingresar Total de Extra, de caso contrario digite: 0");
                    $("#frmEditarVenta #lbltotalextra").focus();
                    return false;
                }
            
                if ($("#frmEditarVenta #lblresumenventa").val() == "") {
                    alertify.warning("Por favor ingresar Resumen de Venta");
                    $("#frmEditarVenta #lblresumenventa").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblformadepago").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Forma de Pago");
                    $("#frmEditarVenta #lblformadepago").focus();
                    return false;
                }
                if ($("#frmEditarVenta #mesano").val() == "") {
                    alertify.warning("Por favor ingresar 590");
                    $("#frmEditarVenta #mesano").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblPAI").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar PAI");
                    $("#frmEditarVenta #lblPAI").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lbltipokit").val() == "" || $("#frmEditarVenta #lbltipokit").val() == null){
                    alertify.warning("Por favor ingresar Tipo KIT");
                    $("#frmEditarVenta #lbltipokit").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblclosingpack").val() == "" || $("#frmEditarVenta #lblclosingpack").val() == null){
                    alertify.warning("Por favor ingresar Closing Pack");
                    $("#frmEditarVenta #lblclosingpack").focus();
                    return false;
                }
                
                    if ($("#frmEditarVenta #lblresultadoScoring").val() == "" || $("#frmEditarVenta #lblresultadoScoring").val() == null) {
                        alertify.warning("Por favor ingresar RESULTADO SCORING");
                        $("#frmEditarVenta #lblresultadoScoring").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #valcodigoOperacionScoring").val() == "" || $("#frmEditarVenta #valcodigoOperacionScoring").val() == null) {
                        alertify.warning("Por favor seleccionar RESULTADO SCORING, puede ver en CONSULTAS DOC.");
                        $("#frmEditarVenta #lblresultadoScoring").focus();
                        return false;
                    }                
                 
                // if ($("#frmEditarVenta #referidoHabilitado").val() == "" || $("#frmEditarVenta #referidoHabilitado").val() == "Seleccione"){
                //     alertify.warning("Por favor seleccionar SI ó NO cuenta con referido");
                //     $("#frmEditarVenta #referidoHabilitado").focus();
                //     return false;
                // }
             
                // if ($("#frmEditarVenta #cantidadreferidoHabilitado").val() == 0) {
                    
                //         Swal.fire(
                //           '¡Advertencia!',
                //           'Para continuar, debes ingresar al menos 1 referido. En caso ya hayas ingresado el referido, por favor presiona el botón Actualizar Número de Referidos',
                //           'warning'
                //             );
                //         $("#frmEditarVenta #cantidadreferidoHabilitado").focus();
                //         return false;
                // }                
                
                if ($("#lblcat").val() == "Delegacion") {
                    if ($("#frmEditarVenta #lblinstaladox").val() == "" || $("#frmEditarVenta #lblinstaladox").val() == "Seleccione" || $("#frmEditarVenta #lblinstaladox").val() == "TEC" ) {
                        alertify.warning("Por favor seleccionar Instaladox: DEL");
                        $("#frmEditarVenta #lblinstaladox").focus();
                        return false;
                    }
            
            
                    if ($("#frmEditarVenta #lbltecnico").val() =="") {
                        alertify.warning("Por favor seleccionar el instalador");
                     
                        $("#frmEditarVenta #lbltecnico").select2('open');
                        return false;
                    }
            
                    if ($("#frmEditarVenta #fechainst").val() == "") {
                        alertify.warning("Por favor ingresar Fecha de Instalacion");
                        $("#frmEditarVenta #fechainst").focus();
                        return false;
                    }
            
            
                    if ($("#frmEditarVenta #horainst").val() == "") {
                        alertify.warning("Por favor ingresar Hora de Instalacion");
                        $("#frmEditarVenta #horainst").focus();
                        return false;
                    }
                    
                    if($('#lblcategoriaprecio').val() == '' || $('#lblcategoriaprecio').val() == null){
                        alertify.warning("Por favor ingresar categoria precio");
                        $('#lblcategoriaprecio').focus();
                        return false;
                    }
                }
                
                if($('#lblRenove').val() == '' || $('#lblRenove').val() == null){
                        Swal.fire(
                          '¡Importante!',
                          'Por favorseleccionar Renove',
                          'warning'
                            );                        
                    $('#lblRenove').focus();
                    return false;
                }
                if($('#lblRenove').val() == 'SI'){
                    if($('#lblRcompetencia').val() == '' || $('#lblRcompetencia').val() == null){
                        Swal.fire(
                          '¡Importante!',
                          'Por favorseleccionar Competencia',
                          'warning'
                            );                        
                        $('#lblRcompetencia').focus();
                    return false;                    
                        
                    }

                }                  
                
            
                return true; 
            }
            
            function calcDataTableHeight() {
                return $(window).height() * 65 / 100;
            };
            
            function filterFloat(evt, input) {
                // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
                var key = window.Event ? evt.which : evt.keyCode;
                var chark = String.fromCharCode(key);
                var tempValue = input.value + chark;
                if (key >= 48 && key <= 57) {
                    if (filter(tempValue) === false) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    if (key == 8 || key == 13 || key == 0) {
                        return true;
                    } else if (key == 46) {
                        if (filter(tempValue) === false) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
            }
            
            function filter(__val__) {
                var preg = /^([0-9]+\.?[0-9]{0,2})$/;
                if (preg.test(__val__) === true) {
                    return true;
                } else {
                    return false;
                }
            
            }
        </script>
        <!-- SCORING -->
        <script>
            var divLoading = $('#divLoading');
            
            $('#btnScoring').on('click', function(){
            
            $('#btnScoring').prop('disabled', true);
            
            divLoading.show();
            var idventa=$("#idVenta").val();
            var matriculausuario=$('#matriculausuario').val(); 
            var nombreusuario=$('#nombreusuario').val();
            var TipoDocumento = $('#TipoDocumento').val();
            var Documento = $('#Documento').val();
            var Departamental=$("#Departamental option:selected").text();
            var Provincial=$("#Provincial option:selected").text();
            var Distrital=$("#Distrital option:selected").text();
            var Ubigeo=$("#Distrital").val();
            var Segmento=$("#Segmento option:selected").val();
            var Area='COMERCIAL';
            var tipoventa=$("#lbltipoventa").val();
            var valPrecioBomba=$('#valPrecioBomba').val();
            var recurso=$('#lbltipoventa').val();
            
            
            var datos = {
            matriculausuario:matriculausuario,
            nombreusuario:nombreusuario,
            TipoDocumento: TipoDocumento,
            Documento: Documento,
            Departamental:Departamental,
            Provincial:Provincial,
            Distrital:Distrital,
            Ubigeo:Ubigeo,
            idventa:idventa,
            Area:Area,
            Segmento:Segmento,
            recurso:recurso
            }
            console.log(datos);
            if(validaFormScoring()){
                    $.ajax({
                type: "Post",
                data: datos,
                url: "ajax/funciones/soap2_venta_v2.php",
                dataType: "Json",
                success: function (data){
                  console.log(data);
            
                  if (data.tipo == 'exito'){
                    $('#FechaConsulta').html(data.fecha);
                    var resultado = data.datos;
                    var resultadooperacion=data.NodoAccion;
                    
                    //$('.TextoAccion').html(resultadooperacion);
                    if(resultadooperacion=="Generar Visita"){
                        $('.bg-visita').show();
                        $('.bg-televenta').hide();
                        $('.bg-gestion').hide();
                    }else if(resultadooperacion=="Pasar a base de datos-48 horas" || resultadooperacion=="Pasar a Televenta"){
                        $('.bg-visita').hide();
                        $('.bg-televenta').show();
                        $('.bg-gestion').hide();
                    }else{
                        $('.bg-visita').hide();
                        $('.bg-televenta').hide();
                        $('.bg-gestion').show();
                    }
                    $('#Riesgo').html(resultado.respuestaSVC11Type.Scores.Score.Riesgo + ' Riesgo');
                    if (resultado.respuestaSVC11Type.Integrante.TipoDocumento == 1){
                    $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno +' '+resultado.respuestaSVC11Type.Integrante.ApellidoMaterno +' '+resultado.respuestaSVC11Type.Integrante.Nombres);
                    $('#TDocumento').html("DNI:");
                    }
                    else if (resultado.respuestaSVC11Type.Integrante.TipoDocumento == 6){
                    
                    if(resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0,2)==10 || resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0,2)==15 || resultado.respuestaSVC11Type.Integrante.NumeroDocumento.substr(0,2)==17){
                        $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno +' '+resultado.respuestaSVC11Type.Integrante.ApellidoMaterno +' '+resultado.respuestaSVC11Type.Integrante.Nombres);
                    }else{
                        $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.RazonSocial);
                    }
                      $('#TDocumento').html("RUC:");
                    }else{
                    $('#NombreCompleto').html(resultado.respuestaSVC11Type.Integrante.ApellidoPaterno +' '+resultado.respuestaSVC11Type.Integrante.ApellidoMaterno +' '+resultado.respuestaSVC11Type.Integrante.Nombres);
                    $('#TDocumento').html("CE:");
                    }
            
                    $('#NumeroDocumento').html(resultado.respuestaSVC11Type.Integrante.NumeroDocumento);
            
            
                    $('#Valor').html(resultado.respuestaSVC11Type.Scores.Score.Valor);
                    $('#ValorNodo').html(data.NodoScoring);
                    $('#ValorNodoAccion').html(data.NodoAccion);
                    
                    //resultadooperacion=data.NodoAccion;
                    if(tipoventa=="RE" && valPrecioBomba=="NO"){
                        
                        if(resultadooperacion=="Oferta Extraordinaria" || resultadooperacion=="Oferta Especial" || resultadooperacion=="Oferta"){
                            $('.TextoAccion').html('Oferta RE');
                        }else{
                            $('.TextoAccion').html(resultadooperacion);  
                        }
                        
                    }else{
                        $('.TextoAccion').html(resultadooperacion);   
                    }
                    if(resultadooperacion=="Oferta Limitada"){
                        $('#lblresultadoScoring').val("Limitada");
                        $('#valresultadoScoring').val("Limitada");
                    }else if(resultadooperacion=="Oferta Especial"){
                        $('#lblresultadoScoring').val("Especial");
                        $('#valresultadoScoring').val("Especial");
                    }else if(resultadooperacion=="Oferta Extraordinaria"){
                        $('#lblresultadoScoring').val("Extraordinaria");
                        $('#valresultadoScoring').val("Extraordinaria");
                    }else if(resultadooperacion=="Oferta Unica"){
                       $('#lblresultadoScoring').val("Unica");
                       $('#valresultadoScoring').val("Unica");
                    }else if(resultadooperacion=="Oferta"){
                       $('#lblresultadoScoring').val("Oferta");
                       $('#valresultadoScoring').val("Oferta");                         
                    }else{
                        $('#lblresultadoScoring').val("");
                        $('#valresultadoScoring').val("");
                    }
                    $('#valcodigoOperacionScoring').val(resultado.respuestaSVC11Type.Header.NumeroOperacion);
                    $('#lblresultadoScoring').trigger('change');
            
                    divLoading.hide();
            
                    $('#ResultadoEquifax').show();
                    $('#TipoDocumento').prop('disabled', true); 
                    $('#Documento').prop('disabled', true); 
                    $("#Departamental").prop('disabled', true); 
                    $("#Provincial").prop('disabled', true); 
                    $("#Distrital").prop('disabled', true);
                    $('#btnScoring').hide();
                    $('#btnScoring').prop('disabled', false);
                    $('#btnNuevaScoring').show();
                  } else {
                    divLoading.hide();
                    alert(data.mensaje);
                    $('#btnScoring').show();
                    $('#btnScoring').prop('disabled', false);
                    $('#btnNuevaScoring').hide();
                  }
            
            
            
                }
            })
            
            }
            else{
                 divLoading.hide();
                  $('#btnScoring').prop('disabled', false);
            }
            
            });
            
            $('#btnNuevaScoring').on('click',function(){
                    $('#ResultadoEquifax').hide();
                    $('#TipoDocumento').prop('disabled', false); 
                    $('#Documento').prop('disabled', false);
                    
                    $("#Departamental").prop('disabled', true);
                    $("#Provincial").prop('disabled', true);
                    $("#Distrital").prop('disabled', false);
                    
                    $('#btnNuevaScoring').hide();
                    $('#btnScoring').show();
                    $('#btnScoring').prop('disabled', false);
                    
                    $('#TipoDocumento').val("1"); 
                    $('#Documento').val("");
                    // $("#Departamental").val("");
                    // $("#Provincial").find('option').remove();
                    // $("#Provincial").append('<option value="">Seleccione</option>');
                    // $("#Distrital").find('option').remove();
                    // $("#Distrital").append('<option value="">Seleccione</option>');
                    // cargardepartamento();
                    
            });
            
            $('#modal-logdni').on('shown.bs.modal', function(){
            $('#logconsultadoc').prop('disabled', true);
            divLoading.show();
            const contenedor = document.querySelector('#tblVentas tbody');
            while (contenedor.firstChild) {
                contenedor.removeChild(contenedor.firstChild);
                }
            
            var idventa=$("#idVenta").val();
            const lblsegmento=$('#lblsegmento option:selected').val();
            const lblIdProvincial=$('#lblIdProvincial').val();
            const lblCodUbigeoReniec=$('#lblCodUbigeoReniec').val();
            var datos = {
                idventa:idventa,
                lblsegmento:lblsegmento,
                lblIdProvincial:lblIdProvincial,
                lblCodUbigeoReniec:lblCodUbigeoReniec
            }
            console.log(datos);
             $.ajax({
                type: "Post",
                data: datos,
                url: "ajax/findDataConsultaScoringVenta.php",
                dataType: "Json",
                success: function (data){
                  console.log(data);
                  divLoading.hide();
                  $('#tblVentas').show();
                            if(data.length>0){
            
                                for (let [llave, valor] of Object.entries(data)){
                                    var TipoDoc;
                                    if(valor.TipoDocumento==1){TipoDoc="DNI"}else if(valor.TipoDocumento==6){TipoDoc="RUC"}else{TipoDoc="CE"}
                                    const row = document.createElement('tr');
                                        row.innerHTML = `   <td class="tblBody text-center"><button type="button" class="btn btn-nuevo btnSeleccionar" id="${valor.Accion+"-"+valor.NumeroOperacion+"-"+valor.Dentromes}">Seleccionar</button></td>
                                                            <td class="tblBody text-center">${valor.FechaHoraReg}</td> 
                                                            <td class="tblBody text-center">${TipoDoc}</td> 
                                                            <td class="tblBody text-center">${valor.NumeroDocumento}</td>
                                                            <td class="tblBody text-center">${valor.Nombres +" "+ valor.ApellidoPaterno+" "+valor.ApellidoMaterno}</td>
                                                            
                                                        `                        
                                    //Agrega el HTML del carrito en el tbody 
                                    contenedor.appendChild(row);
                                }
                                    //Desbloqueo del Boton
            $('#logconsultadoc').prop('disabled', false);                       
            $('.btnSeleccionar').on('click',function(){
            var cadena = $(this).attr("id");
            var separador = "-", // hay un "-"
                arregloDeSubCadenas = cadena.split(separador);
            var Accion=arregloDeSubCadenas[0];
            var NumeroOperacion=arregloDeSubCadenas[1];
            var Dentromes=arregloDeSubCadenas[2];
            if(Dentromes=="NO"){
                    Swal.fire(
                      '¡Scoring Desactualizado!',
                      'Por favor volver a scorear',
                      'warning'
                    );
            }else{
            
                    if(Accion=="Oferta Limitada"){
                        $('#lblresultadoScoring').val("Limitada");
                        $('#valresultadoScoring').val("Limitada");
                    }else if(Accion=="Oferta Especial"){
                        $('#lblresultadoScoring').val("Especial");
                        $('#valresultadoScoring').val("Especial");
                    }else if(Accion=="Oferta Extraordinaria"){
                        $('#lblresultadoScoring').val("Extraordinaria");
                        $('#valresultadoScoring').val("Extraordinaria");
                    }else if(Accion=="Oferta Unica"){
                       $('#lblresultadoScoring').val("Unica");
                       $('#valresultadoScoring').val("Unica");
                    }else if(Accion=="Oferta"){
                       $('#lblresultadoScoring').val("Oferta");
                       $('#valresultadoScoring').val("Oferta");                       
                    }else{
                        $('#lblresultadoScoring').val("");
                        $('#valresultadoScoring').val("");
                    }                    
                    $('#lblresultadoScoring').trigger('change');
                    $('#valcodigoOperacionScoring').val(NumeroOperacion);
             
              $('#modal-logdni').modal('hide');
            }
            });
                            }else{
                                const row = document.createElement('tr');
                                        row.innerHTML = `<td colspan="5" class="tblBody text-center"> No se encontró resultado</td>` 
                                    //Agrega el HTML del carrito en el tbody 
                                    contenedor.appendChild(row);
                                     $('#logconsultadoc').prop('disabled', false); 
                            }
                }
             });
            }) 
            
            $("#Departamental").change(function () {
                $("#Departamental option:selected").each(function () {
                    var Provincial = $(this).val();
                    var datos={
                        Provincial:Provincial
                    };
                    var provincia= $("#Provincial");
                    var distrito= $("#Distrital");
                     $.ajax({
                    data:datos,
                    url:   './ajax/selectProvincial.php',
                    type:  'POST',
                    dataType: 'json',
                    beforeSend: function () 
                    {
                        //provincia.prop('disabled', true);
                        //distrito.prop('disabled', true);
                    },
                    success:  function (r) 
                    {
                        provincia.prop('disabled', false);
                        distrito.prop('disabled', false);
                        
                        // Limpiamos el select de Provincia
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');
                        // Limpiamos el select de Distrito
                        distrito.find('option').remove();
                        distrito.append('<option value="">Seleccione</option>');
                        
                        $(r).each(function(i, v){ // indice, valor
                            provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                        })
                        
                        provincia.prop('disabled', false);
                        distrito.prop('disabled', false);
                    },
                    error: function()
                    {
                        //alert('Ocurrio un error en el servidor ..');
                        provincia.prop('disabled', false);
                        distrito.prop('disabled', false);
                    }
                });
            
                });
            });
            
            $("#Provincial").change(function () {
                $("#Provincial option:selected").each(function () {
                    var Provincial = $(this).val();
                    var datos={
                        Provincial:Provincial
                    };
                    var provincia= $("#Distrital");
                     $.ajax({
                    data:datos,
                    url:   './ajax/selectDistrital.php',
                    type:  'POST',
                    dataType: 'json',
                    beforeSend: function () 
                    {
                       //provincia.prop('disabled', true);
                    },
                    success:  function (r) 
                    {
                        provincia.prop('disabled', false);
                        
                        // Limpiamos el select
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');
                        
                        $(r).each(function(i, v){ // indice, valor
                            provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                        })
                        
                        provincia.prop('disabled', false);
                    },
                    error: function()
                    {
                        //alert('Ocurrio un error en el servidor ..');
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');
                        provincia.prop('disabled', false);
                    }
                });
            
                });
            });
            
            //Validaciones
            //nombres apellido_p apellido_m
            $("#nombres").bind('keypress', function(event) {
              var regex = new RegExp("^[a-zA-Z ]+$");
              var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
              if (!regex.test(key)) {
                event.preventDefault();
                return false;
              }
            });
            
            $("#apellido_p").bind('keypress', function(event) {
              var regex = new RegExp("^[a-zA-Z ]+$");
              var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
              if (!regex.test(key)) {
                event.preventDefault();
                return false;
              }
            });  
            $("#apellido_m").bind('keypress', function(event) {
              var regex = new RegExp("^[a-zA-Z ]+$");
              var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
              if (!regex.test(key)) {
                event.preventDefault();
                return false;
              }              
              
            });            
            
              $("#btnModalconsultascoring").click(function(event) {
                  const modalsegmento=$("#Segmento");
            
                    const lbltipoventa = $('#lbltipoventa').val();
                    
                        $("#Departamental").prop('disabled', true);
                        $("#Provincial").prop('disabled', true);
                                      
                  
               $("#lblsegmento option:selected").each(function () {
                    var segmento = $(this).val();
                      modalsegmento.val(segmento);
                      modalsegmento.trigger('change');
                    });
            });        
                      
            function validaFormScoring(){
                              if ($("#frmEditarVentaScoring #TipoDocumento").val() == "") {
                           alertify.warning("Por favor ingresar Tipo de Documento");
                           $("#frmEditarVentaScoring #lbldireccion").focus();
                           return false;
                        }
                                              if ($("#frmEditarVentaScoring #Documento").val() == "") {
                           alertify.warning("Por favor ingresar Número de Documento");
                           $("#frmEditarVentaScoring #Documento").focus();
                           return false;
                        }
                        //NUEVA FUNCION SI SELECCIONA DNI/RUC
                    if ($("#frmEditarVentaScoring #TipoDocumento").val() == "6") {
                            if ($("#frmEditarVentaScoring #Documento").val().length!=11) {
                                
                               alertify.warning("Por favor ingresar los 11 digitos del RUC");
                               $("#frmEditarVentaScoring #Documento").focus();
                               return false;
                            }
                            
                            if ($("#frmEditarVentaScoring #Documento").val().substr(0,2)==10 || $("#frmEditarVentaScoring #Documento").val().substr(0,2)==20 || $("#frmEditarVentaScoring #Documento").val().substr(0,2)==15 || $("#frmEditarVentaScoring #Documento").val().substr(0,2)==17) {
                              
                            }else{
                                 alertify.warning("Por favor ingresar correctamente el RUC debe comenzar 10 o 20");
                               $("#frmEditarVentaScoring #Documento").focus();
                               return false;
                            }
                            
                            
                        }
                    if ($("#frmEditarVentaScoring #TipoDocumento").val() == "1") {
                            if ($("#frmEditarVentaScoring #Documento").val().length!=8) {
                               alertify.warning("Por favor ingresar los 8 digitos del DNI");
                               $("#frmEditarVentaScoring #Documento").focus();
                               return false;
                            }
                        }                        
                    if ($("#frmEditarVentaScoring #TipoDocumento").val() == "3") {
                            if ($("#frmEditarVentaScoring #Documento").val().length==0) {
                               alertify.warning("Por favor ingresar CE");
                               $("#frmEditarVentaScoring #Documento").focus();
                               return false;
                            }
                        }
                                      if ($("#frmEditarVentaScoring #Departamental").val() == "") {
                      alertify.warning("Por favor ingresar Departamento correspondiente");
                      $("#frmEditarVentaScoring #Departamental").focus();
                      return false;
                  }
                                    if ($("#frmEditarVentaScoring #Provincial").val() == "") {
                      alertify.warning("Por favor ingresar Pronvincia correspondiente");
                      $("#frmEditarVentaScoring #Provincial").focus();
                      return false;
                  }
                                    if ($("#frmEditarVentaScoring #Distrital").val() == "") {
                      alertify.warning("Por favor ingresar Distrito correspondiente");
                      $("#frmEditarVentaScoring #Distrital").focus();
                      return false;
                  }
                                    if ($("#frmEditarVentaScoring #Segmento").val() == "") {
                      alertify.warning("Por favor seleccionar Segmento correspondiente");
                      $("#frmEditarVentaScoring #Segmento").focus();
                      return false;
                  }                       
                      
                  return true;
            } 
            function cargardepartamento(){
                    $('#TipoDocumento').val("1"); 
                    var lblIdProvincial = $("#lblIdProvincial").val();
                    var lblIdDepartamental = $("#lblIdDepartamental").val();
                    var lblCodUbigeoReniec=$('#lblCodUbigeoReniec').val();

                    var provincia= $("#Departamental");
                     $.ajax({
                    url:   './ajax/selectDepartamental.php',
                    type:  'POST',
                    dataType: 'json',
                    beforeSend: function () 
                    {
                        provincia.prop('disabled', true);
                        
                    },
                    success:  function (r) 
                    {
                        provincia.prop('disabled', false);
                        
                        // Limpiamos el select de Provincia
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');
            
                        $(r).each(function(i, v){ // indice, valor
                            provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                        })
                    if(lblIdDepartamental==""){
                        $("#Departamental option[value='15']").attr("selected", true);
                    }else{
                        $("#Departamental option[value='"+lblIdDepartamental+"']").attr("selected", true);
                    }
                    //$("#Departamental option[value='15']").attr("selected", true);
                        $("#Departamental option:selected").each(function () {
                    var Provincial = $(this).val();
                    var datos={
                        Provincial:Provincial
                    };
                    var provincia= $("#Provincial");
                    var distrito= $("#Distrital");
                     $.ajax({
                    data:datos,
                    url:   './ajax/selectProvincial.php',
                    type:  'POST',
                    dataType: 'json',
                    beforeSend: function () 
                    {
                        //provincia.prop('disabled', true);
                        //distrito.prop('disabled', true);
                    },
                    success:  function (r) 
                    {
                        provincia.prop('disabled', false);
                        distrito.prop('disabled', false);
                        
                        // Limpiamos el select de Provincia
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');
                        // Limpiamos el select de Distrito
                        distrito.find('option').remove();
                        distrito.append('<option value="">Seleccione</option>');
                        
                        $(r).each(function(i, v){ // indice, valor
                            provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                        })
                       if(lblIdProvincial==""){
                           $("#Provincial option[value='128']").attr("selected", true);
                       }else{
                           $("#Provincial option[value='"+lblIdProvincial+"']").attr("selected", true);
                       }
                       //$("#Provincial option[value='128']").attr("selected", true);
                        $("#Provincial option:selected").each(function () {
                    var Provincial = $(this).val();
                    var datos={
                        Provincial:Provincial
                    };
                    var provincia= $("#Distrital");
                     $.ajax({
                    data:datos,
                    url:   './ajax/selectDistrital.php',
                    type:  'POST',
                    dataType: 'json',
                    beforeSend: function () 
                    {
                       //provincia.prop('disabled', true);
                    },
                    success:  function (r) 
                    {
                        provincia.prop('disabled', false);
                        
                        // Limpiamos el select
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');
                        

                        
                        
                        $(r).each(function(i, v){ // indice, valor
                            provincia.append('<option value="' + v.id + '">' + v.text + '</option>');
                        })

                        if(!lblCodUbigeoReniec==""){
                            $("#Distrital option[value='"+lblCodUbigeoReniec+"']").attr("selected", true);
                        }                      
                        
                        provincia.trigger('change');
                        
                        provincia.prop('disabled', false);
                    },
                    error: function()
                    {
                        //alert('Ocurrio un error en el servidor ..');
                        provincia.find('option').remove();
                        provincia.append('<option value="">Seleccione</option>');
                        provincia.prop('disabled', false);
                    }
                });
            
                });
                        provincia.prop('disabled', false);
                        distrito.prop('disabled', false);
                    },
                    error: function()
                    {
                        //alert('Ocurrio un error en el servidor ..');
                        provincia.prop('disabled', false);
                        distrito.prop('disabled', false);
                    }
                });
            
                });
                        //provincia.trigger('change');
                         
                        
                        provincia.prop('disabled', false);
                        
                    },
                    error: function()
                    {
                        //alert('Ocurrio un error en el servidor ..');
                        provincia.prop('disabled', false);
                        distrito.prop('disabled', false);
                    }
                });
            
            }
            
                        
        </script>
        <!-- PASARELA DE PAGO -->
        <script>
            $('.step3').click(function (event) {
                
                var idventa=$("#idVenta").val();
                var tipopago='WEB';
                var mediopago = $("#lblmediopago").val();
                var correo=$("#lblcorreo").val();
                var gestororigen=$("#matriculaUsuario").val();
                var divLoading = $('#divLoading');
                
                 //Algunas variables por default de alertify
                    alertify.defaults.theme.ok = "btn btn-nuevo";
                    alertify.defaults.theme.cancel = "btn btn-danger";
                    
                    if ($(this).is("[disabled]")) {
                            event.preventDefault();
                    } else {
                    
                    var lastX,lastY;
                        alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', 'Por su seguridad, no guardaremos ningún registro después de esta operación', function(){ 
                        divLoading.show();    
                    
                                    $('#slider').animate({
                                        marginLeft: '-' + 100 + '%'}, 300, function () {
                                        $('#slider').css('margin-left', '-' + 200 + '%');
                                    });
                
            
                 
                       $.ajax({
                            type: 'POST',
                            url: 'ajax/insertTransaccion.php',
                            data: "idventa=" + idventa + "&tipopago="+tipopago+"&mediopago="+mediopago+"&gestororigen="+gestororigen+"&correo="+correo,
                            dataType: "JSON",
                            success: function (r) {
                                if (r.resultado==1) {
                                     $("#ningunresultado3").html(r.mostrar);
                                     window.open(r.URL,'_blank');
                                     divLoading.hide();
                                } else if(r.resultado==2 || r.resultado==3){
                                     $("#ningunresultado3").html(r.mostrar);
                                     divLoading.hide();
                                } else if(r.resultado==4){
                                     $("#ningunresultado3").html(r.mostrar);
                                     divLoading.hide();
                                } else if(r.resultado==6){
                                     $("#ningunresultado3").html(r.mostrar);
                                     divLoading.hide();
                                }
                                
                                else {
                                    alertify.error("Fallo el server");
                                   
                                }
                                
                            }
                        });
            
            
                        
                     }
                , function(){ alertify.error('Cancel')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
            
            lastX = window.scrollX;
            lastY = window.scrollY;
            },
            'onfocus':function(){
            window.scrollTo(lastX, lastY);
            }  }).show(); 
                
                
            } // END ELSE
                
                });
            
            $('.step2').click(function () {
                var idventa=$("#idVenta").val();
                var tipopago='CORREO';
                var mediopago = $("#lblmediopago").val();
                var gestororigen=$("#matriculaUsuario").val();
                var divLoading = $('#divLoading');
                var correomostrar=$("#frmEditarVenta #lblcorreo").val();
                
            
                //Algunas variables por default de alertify
                alertify.defaults.theme.ok = "btn btn-nuevo";
                alertify.defaults.theme.cancel = "btn btn-danger";
                
                var lastX,lastY;
                    alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', 'Por su seguridad, no guardaremos ningún registro después de esta operación. Desea enviar correo  a: <br><input name="lblcorreoenvio" class="form-control input-sm" id="lblcorreoenvio" value="'+ correomostrar+'" style="width: 100%;"/>', function(){ 
                        if (validaCorreo()) {
                            divLoading.show();
                            var lblcorreoenvio=$("#lblcorreoenvio").val();         
                            $('#slider').animate({
                                marginLeft: '-' + 100 + '%'}, 300, function () {
                                $('#slider').css('margin-left', '-' + 200 + '%');
                            });
                      
                            $.ajax({
                                type: 'POST',
                                url: 'ajax/insertTransaccion.php',
                                data: "idventa=" + idventa + "&tipopago="+tipopago+"&mediopago="+mediopago+"&gestororigen="+gestororigen+"&correo="+lblcorreoenvio,
                                dataType: "JSON",
                                success: function (r) {
                                    if (r.resultado==1) {
                                         $("#ningunresultado3").html(r.mostrar);
                                         window.open(r.URL,'_blank');
                                         divLoading.hide();
                                    } else if(r.resultado==2 || r.resultado==3){
                                         $("#ningunresultado3").html(r.mostrar);
                                         divLoading.hide();
                                    }else if(r.resultado==4){
                                         $("#ningunresultado3").html(r.mostrar);
                                         divLoading.hide();
                                    }else if(r.resultado==6){
                                         $("#ningunresultado3").html(r.mostrar);
                                         divLoading.hide();
                                    }else {
                                        alertify.error("Fallo el server");
                                       
                                    }
                                    
                                }
                            });
            
                        } //END IF  VALIDACORREO
                }
                , function(){ alertify.error('Cancel')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
                    lastX = window.scrollX;
                    lastY = window.scrollY;
                    },
                    'onfocus':function(){
                    window.scrollTo(lastX, lastY);
                    }  }).show(); 
            });
            
            $('.regresarvtaonline').click(function () {
                $('#slider').animate({
                    marginLeft: 0}, 300);
            });
            
            $('.btnvisa').click(function () {
                $('#lblmediopago').val("VISA");
                
                $('#titulo').text("VISA ");
                $('#titulo2').text("| MODO DE PAGO");
                
                                $('#slider').animate({
                    marginLeft: '-' + 100 + '%'}, 300, function () {
                    $('#slider').css('margin-left', '-' + 100 + '%');
                });
                
            });
            
            $('.btnmastercard').click(function () {
                $('#lblmediopago').val("MASTERCARD");
                 $('#titulo').text("MASTERCARD ");
                 $('#titulo2').text("| MODO DE PAGO");
            
                                $('#slider').animate({
                    marginLeft: '-' + 100 + '%'}, 300, function () {
                    $('#slider').css('margin-left', '-' + 100 + '%');
                });
                
            });
            
            $('.btndinners').click(function () {
                $('#lblmediopago').val("DINNERS");
                
                $('#titulo').text("DINNERS ");
                $('#titulo2').text("| MODO DE PAGO");
                                $('#slider').animate({
                    marginLeft: '-' + 100 + '%'}, 300, function () {
                    $('#slider').css('margin-left', '-' + 100 + '%');
                });
            });
            
            $('.btnamex').click(function () {
                $('#lblmediopago').val("AMEX");
                
                $('#titulo').text("AMERICAN EXPRESS ");
                $('#titulo2').text("| MODO DE PAGO");
                                $('#slider').animate({
                    marginLeft: '-' + 100 + '%'}, 300, function () {
                    $('#slider').css('margin-left', '-' + 100 + '%');
                });
            });
            
            $('#btnrealizarpago').click(function(e){
                
                var gestororigen=$("#matriculaUsuario").val();
                
                $.ajax({
                   url: "ajax/selectListarMdpTransaccionxUser.php",
                   method: "POST",
                   data: {gestororigen:gestororigen},
                   success:function(data){
                       console.log(data);
                       data = JSON.parse(data);
                       if (data >= 5) {
                           Swal.fire({
                              type: 'warning',
                              title: '¡Advertencia!',
                              text: 'No puede realizar más de 5 transacciones por día',
                            })
                            $('.step3').attr("disabled", "disabled");
                       } 
                   }
                });
                
                $('#slider').css('margin-left', 0);
            
            });
        </script>
        <!-- EVENTOS CHECK IN -->
        <script>
            const map = L.map('map');
            
            let newMarker;
            
            let target = {
              latitude : 0,
              longitude: 0,
              marker: ''
            };
            
            //WHATCH POSITION VARIABLE
            let idWP;
            
            $('#modal-checkin').on('shown.bs.modal', function(){
                //CARGA UBICACION DEL CLIENTE Y DEL COMERCIAL EN EL MAPA
                cargarUbicacionesMap();
            })
            
            $('#modal-checkin').on('hidden.bs.modal', function(){
                navigator.geolocation.clearWatch(idWP);
            })
            
            $('#btnGuardarCheckIn').on('click', async function(){
                
                //CONSTATNTE QUE TRAE EL OBJETO CHECKIN
                const infocheckin = $('#infocheckin').val();
                //CALCULA LA DIFERENCIA EN DIA DE LA FECHA DE HOY Y LA FECHA DE LA VISITA (FECHA HOY - FECHA VISITA)
                const dias = diasDiferenciaVisitaCheckIn();
                //OBTENEMOS LOS VALORES DE UBICACION DEL COMERCIAL (LAT1, LON1)
                let lat1 = $('#latitud').val();
                let lon1 = $('#longitud').val();
                //DEFINIMOS LA DISTANCIA
                let distancia;
                //VALIDAMOS SI EXISTE OBJGEOFINDER PARA BUSCAR LA UBICACION DEL CLIENTE (LAT2, LON2)
                console.log($('#objGeofinder').val());
                var IdDepartamental=$('#lblIdDepartamental').val();
                
                if($('#objGeofinder').val() != ''){
                    let objGeofinder = JSON.parse($('#objGeofinder').val());
                    let lat2 = objGeofinder.y;
                    let lon2 = objGeofinder.x;
                    //DISTANCIA ENTRE LOS DOS PUNTOS
                    distancia = calcularDistancia(lat1, lat2, lon1, lon2);
                    
                } else {
                    //SETEAMOS LA DISTANCIA EN UNDEFINDER PORQUE NO EXISTE OBJGEOFINDER
                    distancia = undefined;
                    console.log(distancia);
                }
                //TIPO DE CHECK IN
                let tipo = tipoCheckIn(distancia, dias,IdDepartamental);
                
                //MOTIVOS CHECKIN
                const cboMotivosCheckIn = $('#cboMotivosCheckIn').val();
                //OBSERVACIONES DEL CHECKIN
                const ObservacionesCheckIN = $('#txtObservacionesCheckIN').val();
                console.log(tipo);
                
                
                //DATOS ADICIONALES
                //Obtener idVenta
                const parametrosURL = new URLSearchParams(window.location.search);
                //DATOS A ENVIAR
                const idventa = parseInt( parametrosURL.get('idventa') );
                const matricula = $('#headerMatriculaUsuario').val();
                const lblnombcomercial = $('#lblnombcomercial').val();
                const lblnprospecto = $('#lblnprospecto').val();
                const lbldc = $('#lbldc').val();
                const nombUsuario = $('#headerNombreUsuario').val();
                
                datos = {
                    idventa: idventa,
                    lat: lat1,
                    lon: lon1,
                    distancia: distancia,
                    tipo: tipo,
                    ObservacionesCheckIN: ObservacionesCheckIN,
                    matricula: matricula,
                    lblnprospecto: lblnprospecto,
                    nombUsuario: nombUsuario,
                    lbldc: lbldc,
                    infocheckin: infocheckin,
                    cboMotivosCheckIn: cboMotivosCheckIn
                }
                
                console.log(datos);
                
                if(tipo === 'Manual'){
                    let textObsSwal;
                    
                    if(cboMotivosCheckIn==='Otros'){
                        textObsSwal = 'Estas enviando un check-in con motivo "OTROS",  debes llenar el campo observaciones con los motivos por los que realizaste el CHECK-IN fuera del área roja de la ubicación del cliente'
                    }
                    
                    if(validaVacio(ObservacionesCheckIN)){
                        textObsSwal = 'Estas enviando un check-in fuera del rango,  debes llenar el campo observaciones con los motivos por los que realizaste el CHECK-IN fuera del área roja de la ubicación del cliente'
                    } else {
                        textObsSwal = '';
                    }
                    
                    
                    Swal.fire({
                        title: '¿Estás seguro de enviar la ubicación fuera del rango (200m)?',
                        html: textObsSwal,
                        icon: 'question',
                        showDenyButton: false,
                        showCancelButton: true,
                        confirmButtonText: `Si, continuar`,
                        confirmButtonColor: '#e4002b',
                        cancelButtonText: 'No, regresar',
                        cancelButtonColor: '#444444',
                    }).then((result) => {
                        if (result.isConfirmed) {
                            let timerInterval
                            Swal.fire({
                              title: 'CHECK-IN',
                              html: 'Calculando distancia ....',
                              timer: 2000,
                              timerProgressBar: true,
                              didOpen: () => {
                                Swal.showLoading()
                                timerInterval = setInterval(() => {
                                }, 100)
                              },
                              willClose: () => {
                                clearInterval(timerInterval)
                              }
                            }).then((result) => {
                                if (result.dismiss === Swal.DismissReason.timer) {
                                    if(validaVacio(ObservacionesCheckIN) && cboMotivosCheckIn==='Ninguna'){
                                        Swal.fire(
                                            'Faltan motivos u observaciones',
                                            'Debes indicar motivos u observaciones',
                                            'warning'
                                        )
                                        return;
                                    } else {
                                        actualizarCheckIN(datos);
                                    }
                                }
                            })
                        } else {
                            return;
                        }
                    }) // END SWAL CONFIRMAR MANUAL
                } else {
                    let timerInterval
                        Swal.fire({
                          title: 'CHECK-IN',
                          html: 'Calculando distancia ....',
                          timer: 2000,
                          timerProgressBar: true,
                          didOpen: () => {
                            Swal.showLoading()
                            timerInterval = setInterval(() => {
                            }, 100)
                          },
                          willClose: () => {
                            clearInterval(timerInterval)
                          }
                        }).then((result) => {
                            if (result.dismiss === Swal.DismissReason.timer) {
                                actualizarCheckIN(datos);
                            }
                        })
                }
            })
            
            /* GRABAR CHECKOUT */
            $('#cboSeVendio').change(function () {
                const seVendio= $(this).val();
                if(seVendio == "No"){
                    $('#cboMotivoPrincipal').parent().parent().removeClass("ocultar");
                } else {
                    $('#cboMotivoPrincipal').parent().parent().addClass("ocultar");
                    $('#cboMotivoPrincipal').val("");
                }
            })
            
            $('#cboMotivoPrincipal').change(function () {
                const motivoPrincipal = $(this).val();
                if(motivoPrincipal == "Competencia"){
                    $('#cboEmpresa').parent().parent().removeClass("ocultar");
                } else {
                    $('#cboEmpresa').parent().parent().addClass("ocultar");
                    $('#cboEmpresa').val("");
                }
            })
            
            $('#btnGuardarCheckOut').on('click', async function(){
                let textObsSwal;
                //Obtener idVenta
                const parametrosURL = new URLSearchParams(window.location.search);
                const idventa = parseInt( parametrosURL.get('idventa') );
                
                const lbltotalhistorialcheckout = $('#lbltotalhistorialcheckout').val();
                const lblnroprospecto = $('#lblnroprospecto').val();
                const lblfechaasignacionvisita = $('#lblfechaasignacionvisita').val();
                const lblfechaatencionvisita = $('#lblfechaatencionvisita').val();
                const lblllamadaposicionamiento = $('#lblllamadaposicionamiento').val();
                const cboSeVendio = $('#cboSeVendio').val();
                var cboMotivoPrincipal = $('#cboMotivoPrincipal').val();
                var cboEmpresa = $('#cboEmpresa').val();
                /*const cboDecisores = $('#cboDecisores').val();*/
                const cboCotizoCliente = $('#cboCotizoCliente').val();
                const cboLlamadaPared = $('#cboLlamadaPared').val();
                const cboAcompanamientoVisita = $('#cboAcompanamientoVisita').val();
                const lblUltimoPrecio = $('#lblUltimoPrecio').val();
                const cboZonaRobo = $('#cboZonaRobo').val();
                /*const lblReferidosRP = $('#lblReferidosRP').val();*/
                const lblObservacionesCheckOut = $('#lblObservacionesCheckOut').val();
                const matricula = $('#headerMatriculaUsuario').val();
                const lblnombcomercial = $('#lblnombcomercial').val();
                
                if(cboSeVendio == 'Si'){
                    cboMotivoPrincipal = '';
                }
                
                if(cboMotivoPrincipal != 'Competencia'){
                    cboEmpresa = '';
                }
                
                datos = {
                    idventa : idventa,
                    lblnroprospecto: lblnroprospecto,
                    lblfechaasignacionvisita: lblfechaasignacionvisita,
                    lblfechaatencionvisita: lblfechaatencionvisita,
                    lblllamadaposicionamiento : lblllamadaposicionamiento,
                    cboSeVendio: cboSeVendio,
                    cboMotivoPrincipal: cboMotivoPrincipal,
                    cboEmpresa: cboEmpresa,
                    /*cboDecisores: cboDecisores,*/
                    cboCotizoCliente: cboCotizoCliente,
                    cboLlamadaPared: cboLlamadaPared,
                    cboAcompanamientoVisita: cboAcompanamientoVisita,
                    lblUltimoPrecio: lblUltimoPrecio,
                    cboZonaRobo: cboZonaRobo,
                    /*lblReferidosRP: lblReferidosRP,*/
                    lblObservacionesCheckOut: lblObservacionesCheckOut,
                    lbltotalhistorialcheckout: lbltotalhistorialcheckout
                }
                
                /* DATOS PARA EL HISTORIAL DE CHECKOUT */
                
                datosH = {
                    idventa : idventa,
                    datos : datos,
                    matricula: matricula,
                    comercial : lblnombcomercial
                }
                
                console.log(datosH);
                
                textObsSwal = '';
                
                Swal.fire({
                    title: '¿Seguro de enviar el checkout?',
                    html: textObsSwal,
                    icon: 'question',
                    showDenyButton: false,
                    showCancelButton: true,
                    confirmButtonText: `Si, continuar`,
                    confirmButtonColor: '#e4002b',
                    cancelButtonText: 'No, salir',
                    cancelButtonColor: '#444444',
                }).then((result) => {
                    if (result.isConfirmed) {
                        if(validaVacio(lblnroprospecto) || validaVacio(lblfechaasignacionvisita) || validaVacio(lblfechaatencionvisita) || validaVacio(lblllamadaposicionamiento)
                            || validaVacio(cboSeVendio) || validaVacio(cboCotizoCliente) || validaVacio(cboLlamadaPared) 
                            || validaVacio(cboAcompanamientoVisita) || validaVacio(lblUltimoPrecio) || validaVacio(cboZonaRobo)){
                            
                            if(cboSeVendio == 'No' && cboMotivoPrincipal == ''){
                                Swal.fire(
                                    'Faltan datos',
                                    'Por favor complete el motivo principal',
                                    'warning'
                                )
                                return;
                            }
                            
                            if(cboMotivoPrincipal == 'Competencia' && validaVacio(cboEmpresa) == ''){
                                
                                Swal.fire(
                                    'Faltan datos',
                                    'Por favor complete los campos vacíos',
                                    'warning'
                                )
                                return;
                            }
                            
                            Swal.fire(
                                'Faltan datos',
                                'Por favor complete todos los campos',
                                'warning'
                            )
                            return;
                            
                        } else {
                            actualizarCheckOUT(datos, datosH);
                        }
                    } else {
                        return;
                    }
                }) // END SWAL CONFIRMAR MANUAL                
            })
            
        </script>
        <!-- FUNCIONES CHECK IN -->
        <script>
            const optionsPosition = {
              enableHighAccuracy: true,
              timeout: 5000,
              maximumAge: 0
            };
            
            function cargarUbicacionesMap(){
                try {
                    //OBTENER LA INFORMACION DEL OBJETO GEOFINDER
                    let objGeofinder = $('#objGeofinder').val();
                        
                    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                        attribution: ''
                    }).addTo(map);
                    
                    //SI EL OBJETO GEOFINDER EXISTE GENERAMOS LA UBICACION EN EL MAPA DE LA DIRECCION DEL CLIENTE GEOREFERENCIADA
                    ubicacionCliente(objGeofinder);
                    
                    //Ubicacion del comercial
                    navigator.geolocation.getCurrentPosition(successPosition, errorPosition, optionsPosition);
                    
                    //Reubicacion del comercial
                    idWP = navigator.geolocation.watchPosition(successReposition, errorPosition, optionsPosition);
                    
                } catch (error) {
                    console.log(error);
                }
            }
            
            function ubicacionCliente(objGeofinder){
                if(objGeofinder !== ''){
                    objGeofinder= JSON.parse(objGeofinder);
                    //Datos de la direccion georeferenciada
                    var lat2 = objGeofinder.y;
                    var lon2 = objGeofinder.x;
                    //Constante de distancia para validación del checkIn
                    const distCheckin = 100;
                    //Definir ubicacion en el mapa
                    L.marker([lat2,lon2], {icon: L.AwesomeMarkers.icon({icon: 'home', prefix: 'fa', markerColor: 'green'}) }).addTo(map).bindPopup('Ubicación de cliente.<br>')
                            .openPopup();
                            
                    //Circulo de color rojo
                    var circle = L.circle([lat2, lon2], {
                                color: 'red',
                                fillColor: '#f03',
                                fillOpacity: 0.5,
                                radius: 200
                            })
                            
                    circle.addTo(map);
                } else {
                    
                }
            }
            
            function successPosition(pos){
                var crd = pos.coords;
                
                let geoComercial = marcadorComercial(crd.latitude, crd.longitude);
                
                target.latitude = crd.latitude;
                target.longitude = crd.longitude;
                target.marker = geoComercial;
            }
            
            function successReposition(pos) {
                var crd = pos.coords;
                
                if (target.latitude !== crd.latitude && target.longitude !== crd.longitude) {
                    map.removeLayer(target.marker);
                
                    let geoComercial = marcadorComercial(crd.latitude, crd.longitude);
                    
                    target.latitude = crd.latitude;
                    target.longitude = crd.longitude;
                    target.marker = geoComercial;
                } 
                
            };
            
            function errorPosition(objPositionError){
                switch (objPositionError.code){
                    case objPositionError.PERMISSION_DENIED:
                        mensaje = "Tu servicio de ubicación se encuentra bloqueado. Por favor, restablecer los permisos de Ubicación.";
                        break;
                    case objPositionError.POSITION_UNAVAILABLE:
                        mensaje = "No se ha podido acceder a la información de su posición. Enciende tu GPS(Servicio de ubicación móvil).";
                    break;
                        case objPositionError.TIMEOUT:
                        mensaje = "El servicio ha tardado demasiado tiempo en responder. Por favor, restablecer los permisos de Ubicación y actualiza VERISMART.";
                        break;
                    default:
                        mensaje = "Error desconocido.";
                }
              
                Swal.fire({
                      icon: 'error',
                      title: mensaje,
                      confirmButtonColor: '#e4002b',
                      footer: ''
                }) 
              
                $('#btnGuardarCheckIn').prop('disabled', true);
              
                window.close();
                $("#modal-checkin").hide();
                $('body').removeClass('modal-open');//eliminamos la clase del body para poder hacer scroll
                $('.modal-backdrop').remove();//eliminamos el backdrop del modal
            }
            
            function marcadorComercial(lat, lon){
                
                map.setView([lat, lon], 16);
               
                let geoComercial = new L.marker([lat, lon], {icon: L.AwesomeMarkers.icon({icon: 'user', prefix: 'fa', markerColor: 'blue'})})
                geoComercial.addTo(map)
                geoComercial.bindPopup('Mi Ubicación.<br> Enviar para check-IN.')
                geoComercial.openPopup();
                
                $('#latitud').val(lat);
                $('#longitud').val(lon);
                
                return geoComercial;
            }
            
            function calcularDistancia(lat1, lat2, lon1, lon2){
                lat1 = parseFloat(lat1);
                lat2 = parseFloat(lat2);
                lon1 = parseFloat(lon1);
                lon2 = parseFloat(lon2);
                
                var latlng1 = L.latLng(lat1, lon1);
                var latlng2 = L.latLng(lat2, lon2);
                //DISTANCIA EN METROS
                distancia = latlng1.distanceTo(latlng2);
                
                return distancia;
                
            }
            
            async function actualizarCheckIN(datos){
                try {
                    const respuesta =  await fetch('ajax/updateCheckIn_v3.php', {method: 'POST', body: JSON.stringify(datos)});
                    const resultado =  await respuesta.json();
                    
                    console.log(resultado);
                    
                    if(resultado.respuesta === 'exito'){
                        
                        Swal.fire({
                            icon: resultado.tipomensaje,
                            text: resultado.mensaje,
                            confirmButtonColor: '#e4002b'
                        })
                        
                    } else {
                        Swal.fire({
                              icon: 'error',
                              title: mensaje,
                              confirmButtonColor: '#e4002b',
                              footer: 'Comunicate con Desarrollo'
                        }) 
                    }
                    
                    $('#btnCheckIn').addClass('ocultar');
                    
                    //window.close();
                    $("#modal-checkin").modal('hide');
                    $("#modal-checkout").modal('show');
                    $('#btnCheckOut').removeClass('ocultar');
                    
                    //$('body').removeClass('modal-open');//eliminamos la clase del body para poder hacer scroll
                    //$('.modal-backdrop').remove();//eliminamos el backdrop del modal
                    //$('#btnCheckIn').addClass('ocultar');
                    
                } catch (error) {
                    console.log(error);
                }
            }
            
            async function actualizarCheckOUT(datos, datosH){
                
                try {
                    const respuesta =  await fetch('ajax/updateCheckOut.php', {method: 'POST', body: JSON.stringify(datos)});
                    const respuesta2 =  await fetch('ajax/updateCheckOut2.php', {method: 'POST', body: JSON.stringify(datosH)});
                    const resultado =  await respuesta.json();
                    const resultado2 =  await respuesta2.json();
                    
                    console.log(resultado2);
                    
                    if(resultado.respuesta === 'exito'){
                        
                        Swal.fire({
                            icon: resultado.tipomensaje,
                            text: resultado.mensaje,
                            confirmButtonColor: '#e4002b'
                        })
                        
                    } else {
                        Swal.fire({
                              icon: 'error',
                              title: mensaje,
                              confirmButtonColor: '#e4002b',
                              footer: 'Comunicate con Desarrollo'
                        }) 
                    }
                    
                    //$('#btnCheckOut').addClass('ocultar');
                    $('#btnHistorialCheckOut').removeClass('ocultar');
                    
                    //window.close();
                    //("#modal-checkin").modal('hide');
                    $("#modal-checkout").modal('hide');
                    
                    //$('body').removeClass('modal-open');//eliminamos la clase del body para poder hacer scroll
                    //$('.modal-backdrop').remove();//eliminamos el backdrop del modal
                    //$('#btnCheckIn').addClass('ocultar');
                    
                } catch (error) {
                    console.log(error);
                }
            }
            
            //OBTENER LA DIFERENCIA EN DIAS DE LA FECHA VISITA Y HOY
            function diasDiferenciaVisitaCheckIn(){
                //FECHA VISITA
                let fechaVisita = $('#FechaVisita').val();
                //HOY
                let hoy = moment().format('YYYY-MM-DD'); 
                //CAMBIAR AL FORMATO DE LA LIBRERIA MOMENTO (INICIO Y FINAL)
                let start = moment(hoy, "YYYY-MM-DD");
                let end = moment(fechaVisita, "YYYY-MM-DD");
                //DIFERENCIA EN DIAS --- DIAS < 0 -> FUERA DE FECHA Y DIAS >= 0 ANTES DE LA FECHA VISITA O EL MISMO DIA
                let dias = moment.duration(end.diff(start)).asDays();
                
                return dias;
            }
            //OBTENEMOS EL TIPO DE CHECKIN DE ACUERDO A LAS VARIABLES
            function tipoCheckIn(distancia, dias,IdDepartamental){
                var refdistancia=0;
                if(IdDepartamental==15){
                    refdistancia=200;
                }else{
                    refdistancia=300;
                }
                if(distancia <= refdistancia && dias >= 0 ){
                    tipo = 'Automatico';  
                } else if (distancia > refdistancia && dias >= 0){
                    tipo = 'Manual';
                } else if (dias < 0) {                        
                    tipo = 'FueraFecha';
                }else {
                    tipo = 'NoGeoreferenciado'
                }
                
                return tipo;
            }
            
            function validaVacio(valor) {
                valor = valor.replace("&nbsp;", "");
                valor = valor == undefined ? "" : valor;
                if (!valor || 0 === valor.trim().length) {
                    return true;
                    }
                else {
                    return false;
                    }
            }
        </script>
        <!-- FUNCIONES REFERIDO-->
        <script>
            $('#referidoHabilitado').change(function(){
                $("#referidoHabilitado option:selected").each(function () {
                var referidoHabilitado = $(this).val();
                    refhabilitada(referidoHabilitado);
                });
            });
            
            $('.copiarurl').on('click', function(){
             var content = document.getElementById('urlreferidoHabilitado');
                content.select();
                document.execCommand('copy');
                alertify.success("Copiado!");
            });
            
            $('.irurl').on('click', function(){
             var content = document.getElementById('urlreferidoHabilitado');
                window.open(content.value, '_blank').focus();
            });
            
            $('.actualizarcantidadref').on('click', function(){
            var idprospectorp=$("#idProspectoRp").val();
            var tipoventa=$("#tipoVenta").val();
            data = {idprospectorp:idprospectorp,tipoventa:tipoventa};
            fetch("./ajax/findCantidadReferidos.php",{method:'POST',body: JSON.stringify(data)})
                .then(function(res) {return res.json();})
                .then(function(data) {     
                    if(data.resultado=='Actualizado'){
                    Swal.fire(
                      'Actualizado!',
                      data.mensaje,
                      'success'
                        );
                    $('#cantidadreferidoHabilitado').val(data.cantidad);                        
                    }else{
                    Swal.fire(
                      'Error!',
                      data.mensaje,
                      'error'
                        );                        
                    }
                    $('#cantidadreferidoHabilitado').val(data.cantidad);
                })
                .catch(function(error) {
                    Swal.fire(
                      'Error!',
                      'Actualizar la página',
                      'error'
                        );  
                    
                });            
             
            });            
            function refhabilitada(value) {
            var idprospectorp=$("#idProspectoRp").val();
            var tipoventa=$("#tipoVenta").val();
            var refhabilitada = value;
            if(refhabilitada=="SI"){
                $('.datosreferidoHabilitado').removeClass('ocultar');
                        //.classList().remove('ocultar');
            }else{
                $('.datosreferidoHabilitado').addClass('ocultar');
            } 
            
            Swal.fire({
                icon: 'question',
                title: '¿Quieres guardar el cambio?',
                showDenyButton: true,
                showCancelButton: false,
                confirmButtonText: `Modificar`,
                denyButtonText: `Cancelar`,
                allowOutsideClick: false
            }).then((result) => {
                /* Read more about isConfirmed, isDenied below */
                if (result.isConfirmed) {
                    if(refhabilitada=="SI"){
                        $('#hidreferidoHabilitado').val("SI");
                                //.classList().remove('ocultar');
                    }else if(refhabilitada=="NO"){
                        $('#hidreferidoHabilitado').val("NO");
                        //.classList().add('ocultar');
                    }else{
                        $('#hidreferidoHabilitado').val("");
                            } 
                    
                    $.ajax({
                        type: 'post',
                        url: 'ajax/changeReferidoHabilitado.php',
                        data: {
                            refhabilitada: refhabilitada,
                            idprospectorp: idprospectorp,
                            tipoventa:tipoventa
                        },
                        success: function(data) {
                            console.log(data);
                            if (data == 1) {
                                Swal.fire('Modificado!', '', 'success');
            
                            } else if (data == 0) {
                                swal.fire(
                                    'Alerta',
                                    'Sin cambios',
                                    'warning');
                            } else {
                                swal.fire(
                                    'Error',
                                    'Error en la actualizacion',
                                    'error');
                            }
                        }
                    });
            
                } else if (result.isDenied) {
                    var refhabilitadaN=$('#hidreferidoHabilitado').val();
                    if (refhabilitadaN == 'SI') {
                        //$('#cotenviada').prop('checked',false);
                        //$('#referidoHabilitado option:selected').val($('#hidreferidoHabilitado').val());
                        $('.datosreferidoHabilitado').removeClass('ocultar');
                    } else if (refhabilitadaN == 'NO')  {
                        //$('#hidreferidoHabilitado').val('SI');
                        //$('#cotenviada').prop('checked',true);
                        //$('#referidoHabilitado option:selected').val('NO');
                        $('.datosreferidoHabilitado').addClass('ocultar');
                    }else{
                        $('#hidreferidoHabilitado').val('');
                        //$('#cotenviada').prop('checked',true);
                        //$('#referidoHabilitado option:selected').val('');
                        $('.datosreferidoHabilitado').addClass('ocultar');
                    }
                    $('#referidoHabilitado').val(refhabilitadaN);
                    Swal.fire('Los cambios no se guardan', '', 'info');
                }
            })
            
            
            }              
            
        </script>
        <!-- CARRITO DE COMPRAS -->
        <script>
            //Evento que identifica cuando un extra es modificado
            $('#cboProducto').on('change', function(){
                const Producto = $('#cboProducto option:selected').val();
                const tipokit = $('#lbltipokit').val();
                //CODIGO USADO PARA REMOVER EL PRECIO DE REFERENCIA ENTRE PARENTESIS PARA OBTENER EL NOMBRE DEL PRODUCTO
                const txtProducto = $('#cboProducto option:selected').text().split(' (', 1)[0];
                $('#hidProducto').val(txtProducto);
                
                $('#cboTipoPrecio').val('').trigger('change');
                
                $("#cboTipoPrecio option[value='PrimeraUnidad']").remove();
                $("#cboTipoPrecio option[value='SegundaUnidadKitZV']").remove();
                
                //NUEVO CATEGORIA ITEM 20220601 CAMARA ARLO Y N1
                $("#cboTipoPrecio option[value='Camaraton']").remove();
                
                //NUEVO CATEGORIA ITEM 20220817 OPDI Y PACKSENSE
                $("#cboTipoPrecio option[value='PrecioEspecial']").remove();                
                
                if(Producto == 70){
                    $('#cboTipoPrecio').append($("<option>", {
                        value: 'PrimeraUnidad',
                        text: 'PRIMERA UNIDAD'
                    }));
                }
                
                if(tipokit == 'ZeroVision'){
                    if(Producto == 84){
                        $('#cboTipoPrecio').append($("<option>", {
                            value: 'SegundaUnidadKitZV',
                            text: 'SEGUNDA UNIDAD KIT ZEROVISION'
                        }));
                    }
                }

            //NUEVO CATEGORIA ITEM 20220601 CAMARA ARLO Y N1
                if(Producto ==111){
                    $('#cboTipoPrecio').append($("<option>", {
                        value: 'Camaraton',
                        text: 'CAMARATÓN'
                    }));
                }
                if(Producto == 110){
                    $('#cboTipoPrecio').append($("<option>", {
                        value: 'Camaraton',
                        text: 'CAMARATÓN'
                    }));
                }
                if(Producto ==82){
                    $('#cboTipoPrecio').append($("<option>", {
                        value: 'Camaraton',
                        text: 'CAMARATÓN'
                    }));
                }
                //OPDI
                if(Producto ==80){
                    $('#cboTipoPrecio').append($("<option>", {
                        value: 'PrecioEspecial',
                        text: 'PRECIO ESPECIAL'
                    }));
                }
                //PACK SENSE
                if(Producto ==131){
                    $('#cboTipoPrecio').append($("<option>", {
                        value: 'PrecioEspecial',
                        text: 'PRECIO ESPECIAL'
                    }));
                }                
                
                
                
                
            })
            
        $('#cboTipoPrecio').on('change', function(){
                //RESETEAR VARIABLES DE CANTIDAD
                $('#cantidadProductos').val('');
                $('#cantidadProductos').prop('disabled', false);
                //RESETEAR VARIABLES DE PRECIO
                $('#precioUnitario').val('');
                $('#precioUnitario').prop('disabled', false);
                
                const Producto = $('#cboProducto option:selected').val();
                const TipoPrecio = $('#cboTipoPrecio option:selected').val();
                
                data = {Producto : Producto};
                
                fetch('ajax/selectListarExtrasField.php', {method: 'POST', body: JSON.stringify(data)})
                    .then(function(res) {
                        return res.json();
                    })
                    .then(function(datos) {
                        
                        const {IdItem, Item, Precio, CuotaMes} = datos;
                        
                        let precioTotal, descuento, precioMax;
                        
                        //SI EL PRODUCTO ES UN MANDO
                        if(Producto == '70'){
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            } else if(TipoPrecio == 'PrimeraUnidad'){
                                precioTotal = 49;
                                
                                $('#cantidadProductos').val(1);
                                $('#precioUnitario').prop('disabled', true);
                                $('#cantidadProductos').prop('disabled', true);
                            }
                        } else if(Producto == '75'){
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        }else if(Producto == '84'){
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            } else if(TipoPrecio == 'SegundaUnidadKitZV'){
                                precioTotal = 400;
                                $('#cantidadProductos').val(1);
                                $('#precioUnitario').prop('disabled', true);
                                $('#cantidadProductos').prop('disabled', true);
                            }
                        } // si el producto es llave
                        else if (Producto == '68') {
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                precioTotal =  15.50;
                                precioMax = Precio*0.75;
                            }
                        } else if(Producto == '85'){
                            if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal =  299;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        } else if(Producto == '86'){
                            if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal =  449;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        } else if(Producto == '87'){
                            if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal =  799;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        }
                        else if(Producto == '88'){
                            if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal =  549;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        }
                        else if(Producto == '89'){
                            if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal =  1399;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        }
                        else if(Producto == '90'){
                            if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal =  1399;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        }
                        else if(Producto == '91'){
                            if(TipoPrecio == 'catalogo'){ //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal =  1499;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        }
                        //CAMARATON
                        else if(Producto == '110' || Producto =='111' || Producto =='82'){
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            } else if(TipoPrecio == 'Camaraton'){
                                precioTotal = 250;
                                $('#cantidadProductos').val(1);
                                $('#precioUnitario').prop('disabled', true);
                            }                            
                        }      
                        else if(Producto == '80'){
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            } else if(TipoPrecio == 'PrecioEspecial'){
                                precioTotal = 299;
                                $('#cantidadProductos').val(1);
                                $('#precioUnitario').prop('disabled', true);
                            }                                
                        }
                        else if(Producto =='131'){
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                Swal.fire(
                                  'Alerta!',
                                  'Precio no autorizado',
                                  'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            } else if(TipoPrecio == 'PrecioEspecial'){
                                precioTotal = 399;
                                $('#cantidadProductos').val(1);
                                $('#precioUnitario').prop('disabled', true);
                            }                                
                        }                          
                        else {
                            if(TipoPrecio == 'catalogo'){
                                descuento = 1.00;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'medio') {
                                descuento = 0.75;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*1
                            } else if(TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal =  Precio*descuento;
                                precioMax = Precio*0.75;
                            }
                        } 

                        $('#precioUnitario').val(precioTotal)
                        $('#cuotaMes').val(CuotaMes);
                        
                        $('#precioMin').val(precioTotal);
                        $('#precioMax').val(precioMax);
                        

                    })
                
            })
            
            $('#precioUnitario').on('blur', function(){
                //alert($('#precioUnitario').val());
                
                const precio = parseFloat($(this).val());
                const TipoPrecio = $('#cboTipoPrecio').val();
                
                let max, min;
                
                if(TipoPrecio == 'catalogo'){
                    
                    min = parseFloat($('#precioMin').val());
                    max = parseFloat($('#precioMax').val());
                    
                    if(precio < min || precio > max){
                        Swal.fire('Alerta!', `El precio no puede ser menor a ${min} o mayor a ${max}.`, 'warning');
                        $(this).val('');
                    }
                    
                } else if(TipoPrecio == 'medio') {
                    min = parseFloat($('#precioMin').val());
                    max = parseFloat($('#precioMax').val());
                    
                    if(precio < min || precio >= max){
                        Swal.fire('Alerta!', `El precio no puede ser menor a ${min} o mayor igual a ${max}.`, 'warning');
                        $(this).val('');
                    }
                    
                } else if(TipoPrecio == 'autorizado') {
                    min = parseFloat($('#precioMin').val());
                    max = parseFloat($('#precioMax').val());
                    
                    if(precio < min || precio >= max){
                        Swal.fire('Alerta!', `El precio no puede ser menor a ${min} o mayor igual a ${max}.`, 'warning');
                        $(this).val('');
                    }
                    
                }
                
                
            })
            
            function getRandomInt(min, max) {
              return Math.floor(Math.random() * (max - min)) + min;
            }
            
            $('#btnAgregar').on('click', function(e){
                const IdItem = $('#cboProducto').val();
                const Producto = $('#cboProducto option:selected').val();
                const Item = $('#hidProducto').val();
                const TipoPrecio = $('#cboTipoPrecio option:selected').val();
                const cantidadProductos = $('#cantidadProductos').val();
                const precioUnitario = $('#precioUnitario').val();
                const cuotaMes = $('#cuotaMes').val();
                
                const datos = {Producto, TipoPrecio, cantidadProductos, precioUnitario};
                
                let numAleatorio = getRandomInt(10000, 99999);
                const dataID = `${Item}-${numAleatorio}`;
                
                if(validarProductoUnico(datos)){
                
                    if(!validarProducto(datos)){
                        Swal.fire(
                          '¡Formulario incompleto!',
                          'Por favor, completar todos los datos',
                          'warning'
                        );
                        return;
                    }
                    
                    let totalProductos, totalCuota;
                    
                    totalProductos = precioUnitario*cantidadProductos;
                    totalCuota = cuotaMes*cantidadProductos;
                    
                    data = {
                            CodItem: IdItem,
                            Item: Item,
                            TipoPrecio: TipoPrecio,
                            cantidadProductos: cantidadProductos,
                            Precio: precioUnitario,
                            CuotaMes: cuotaMes,
                            totalProductos: totalProductos,
                            totalCuota: totalCuota,
                            dataID: dataID
                        };
                        
                    arregloDatos = [...arregloDatos, data];
                    
                    const datosExtra = {
                            tipo: 'extra',
                            descripcion: Item,
                            dataID: dataID
                        }
                        
                    arregloGeneral = [...arregloGeneral, datosExtra];
                        
                    generarHtml();
                    
                    $('#cboProducto').val('');
                    $('#cboTipoPrecio').val('');
                    $('#cantidadProductos').val('');
                    $('#precioUnitario').val('');
                } else {
                    Swal.fire(
                      '¡Extra repetido!',
                      'Imposible vender dos extras',
                      'warning'
                    );
                }
                
            })
            
            function validarProductoUnico(datos){
                const {Producto, TipoPrecio} = datos;
                
                if (arregloDatos.length > 0){
                    const resultado = arregloDatos.find(elemento => elemento.CodItem === Producto);
                    
                    if(resultado == undefined){
                        return true;
                    } else {
                    
                        if(TipoPrecio == resultado.TipoPrecio){
                            return false;
                        } else {
                            return true;
                        }
            
                    }
                    
                } else {
                
                    return true;
                }
            }
            
            function validarProducto(datos){
            
                const {Producto, TipoPrecio, cantidadProductos, precioUnitario} = datos;
              
                if(Producto == '' || Producto == null){
                    return false;
                }
                if(TipoPrecio == '' || TipoPrecio == null){
                    return false;
                }
                if(cantidadProductos == '' || cantidadProductos == 0){
                    return false;
                }
                if(precioUnitario == '' || precioUnitario == 0 ){
                    return false;
                }
                
                return true;
            }
            
            function generarHtml(){
                
                limpiarHTML(listaExtras);
                
                let cantidadExtras= 0;
                let resumen = '';
                let subtotal = 0;
                let subtotalCuota = 0;
                
                
                if(arregloDatos.length > 0){
                    arregloDatos.forEach(datos => {
                        console.log(datos);
                        
                        const {CodItem, CuotaMes, Item, Precio, TipoPrecio, cantidadProductos,  totalProductos, totalCuota, dataID} = datos;
                        
                        let CuotaMes_Round = parseFloat(CuotaMes);
                        let Precio_Round = parseFloat(Precio);
                        
                        listaExtras.innerHTML += `
                                <div class="row" style="margin-top: 20px;">
                                    <div class="col-md-12">
                                        <div class="info-box bg-gray">
                                            <p class="info-box-icon" style="width: 50%; font-size: 15px; height: 100px; line-height: 100px; font-weight: bold;">${Item} <button class="btn borrar-extra" data-id="${dataID}" style="color: red; background-color: transparent;">X</button> </p>
                                            <div class="info-box-content" style="text-align: right;">
                                                <span class="info-box-text">S/. ${Precio_Round} - S/. ${CuotaMes_Round}</span>
                                                <span class="info-box-text">${cantidadProductos}</span>
                                                <span class="info-box-number">Total: ${totalProductos}</span>
                                                <span class="info-box-number">Total cuota: ${totalCuota}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            `;
                        
                        let cantidad;
                        
                        cantidad = parseInt(cantidadProductos);
                        cantidadExtras += cantidad;
                        
                        subtotal += totalProductos;
                        subtotalCuota += totalCuota;
                        
                        
                        
                    })
                }
                
                //ALGORITMO PARA GENERAR EL RESUMEN DE INSTALACION PARA EXTRAS
                arregloGeneral.forEach((elemento, index) => {
                    //Si existe más de un elemento en el arreglo
                    if(arregloGeneral.length > 1){
                        if((arregloGeneral.length -1) == index){
                            resumen += `${elemento.descripcion} (${elemento.tipo})`;
                        } else {
                            resumen += `${elemento.descripcion} (${elemento.tipo}) + `;
                        }
                    } else {
                        resumen += `${elemento.descripcion}`;
                    }
                    
                })
                
                $('#txtResumen').val(resumen);
                        
                $('#txtCantidadExtra').val(cantidadExtras);
                
                $('#txtTotal').val(subtotal);
                $('#txtTotalCuota').val(subtotalCuota);
                
            }
            
            function generarHtmlRegalos(){
                
                limpiarHTML(listaRegalos);
                
                //const resumenventa = $('#lblresumenventa').val();
                
                let resumen = '';
                
                let cantidadRegalos=0;
                
                let subtotal = 0;
                let subtotalCuota = 0;
                
                if(arregloRegalos.length > 0){
                    arregloRegalos.forEach(datos => {
                    
                        const {CodItem, CuotaMes, Item, Precio, cantidad,  totalProductos, totalCuota, dataID} = datos;
                        
                        listaRegalos.innerHTML += `
                                                <div class="row" style="margin-top: 20px;">
                                                    <div class="col-md-12">
                                                        <div class="info-box bg-gray">
                                                            <p class="info-box-icon" style="width: 50%; font-size: 15px; height: 100px; line-height: 100px; font-weight: bold;">${Item} <button class="btn borrar-regalo" data-id="${dataID}" style="color: red; background-color: transparent;">X</button> </p>
                                                            <div class="info-box-content" style="text-align: right;">
                                                                <span class="info-box-text"> Cuota - S/. ${CuotaMes}</span>
                                                                <span class="info-box-text">${cantidad}</span>
                                                                <span class="info-box-number">Total cuota: ${totalCuota}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>`;
                                                    
                        
            
                        let auxCantProductos = parseInt(cantidad)
                        
                        cantidadRegalos += auxCantProductos;
                        subtotalCuota += totalCuota;
            
                    })
                }
                
                console.log(arregloGeneral);
                //ALGORITMO PARA GENERAR EL RESUMEN DE INSTALACION PARA EXTRAS
                arregloGeneral.forEach((elemento, index) => {
                    //Si existe más de un elemento en el arreglo, por defecto el index 0 siempre es el KIT
                    if(arregloGeneral.length > 1){
                        if((arregloGeneral.length -1) == index){
                            resumen += `${elemento.descripcion} (${elemento.tipo})`;
                        } else {
                            resumen += `${elemento.descripcion} (${elemento.tipo}) + `;
                        }
                    } else {
                        //SE AGREGA EL TIPO DE KIT
                        resumen += `${elemento.descripcion}`;
                    }
                    
                })
                
                $('#txtResumen__Regalo').val(resumen);
                $('#txtCantidadRegalo').val(cantidadRegalos);
                $('#txtTotalCuota__Regalo').val(subtotalCuota);
                
            }
            
            function limpiarHTML(cont) {
                //forma recomendada
                while (cont.firstChild) {
                    cont.removeChild(cont.firstChild);
                }
                
                $('#txtResumen').val('');
                $('#txtCantidad').val('');
                $('#txtTotal').val('');
            }
            
            function validarProductoARLO(datos){
                var valArloI=0;
                var valArloE=0;
                const {Producto} = datos;
                if(Producto=="113"){
                    if (arregloDatos.length > 0){
                        const resultadoCamaraInternaArlo = arregloDatos.find(elemento => elemento.CodItem == 110);
                        const resultadoCamaraExternaArlo = arregloDatos.find(elemento => elemento.CodItem == 111);
                        console.log(resultadoCamaraInternaArlo);
                        if(resultadoCamaraInternaArlo == undefined){
                            valArloI=0;
                        } else {
                            console.log(resultadoCamaraInternaArlo.TipoPrecio);
                            if(resultadoCamaraInternaArlo.TipoPrecio=='catalogo'){
                                valArloI=1;
                            } else {
                                valArloI=0;
                            }
            
                        }
                        if(resultadoCamaraExternaArlo == undefined){
                            valArloE=0;
                        } else {
                            if(resultadoCamaraExternaArlo.TipoPrecio=='catalogo'){
                                valArloE=1;
                            } else {
                                valArloE=0;
                            }
            
                        }
                    var sumaAR=(valArloI+valArloE);
                    console.log(sumaAR);
                      if(sumaAR==0){
                          return true;
                      }else{
                          return false;
                      }
                        
                    }else{
                        return true;
                    }
                  
                }else{
                    return false;
                }
            }              

			function validarProductoSMARTHUB(){
			    var valArloI=0;
			    var lbltipokit=$('#lbltipokit').val();
			    console.log(arregloDatos);
			        if (arregloDatos.length > 0){
			            
			            const resultadoArloSmartHUB = arregloDatos.find(elemento => elemento.CodItem == 112);
			            
			            const resultadoCamaraArloInterior = arregloDatos.find(elemento => elemento.CodItem == 138);
			            const resultadoCamaraArloExterior = arregloDatos.find(elemento => elemento.CodItem == 140);
			            
			            const resultadoPackCamaraArloInterior= arregloDatos.find(elemento => elemento.CodItem == 142);
			            const resultadoPackCamaraArloExterior = arregloDatos.find(elemento => elemento.CodItem == 143);
			            
			            console.log(resultadoCamaraArloInterior);
			            
			            if(lbltipokit=='Basico PRO' || lbltipokit=='ZeroVision PRO'){
			                valArloI+=1;
			            }
			            
			            if(resultadoCamaraArloInterior !== undefined){
			                valArloI+=resultadoCamaraArloInterior.cantidadProductos;
			                
			            }
			            
			            if(resultadoCamaraArloExterior !== undefined){
			                valArloI+=resultadoCamaraArloExterior.cantidadProductos;
			                
			            }
			            
			            if(resultadoPackCamaraArloInterior !== undefined){
			                valArloI+=2;
			            }
			            if(resultadoPackCamaraArloExterior !== undefined){
			                valArloI+=2;
			            }
			            
    			        if(valArloI>=2){
    			            if(resultadoArloSmartHUB !== undefined){
    			                return false;
    			            }			            
    			          return true;
    			        }else{
    			          return false;
    			        }
			        
			        }else{
			            return false;
			        }			    

			}
			            
            //EXTRAS
            $('#generarOferta').on('click', function(e){
                
                const txtResumen = $('#txtResumen').val();
                const txtCantidadExtra = $('#txtCantidadExtra').val();
                const txtTotal = $('#txtTotal').val();
                const txtTotalCuota = $('#txtTotalCuota').val();
                
                const datos = {
                    arregloDatos,
                    txtResumen,
                    txtCantidadRegalo,
                    txtTotal,
                    txtTotalCuota
                }
                
                //SET DATOS EN EL FORMULARIO
                $('#lbltotalextra').val(txtTotal);
                $('#lbltotalcuota').val(txtTotalCuota);
                $('#lblCantExtras').val(txtCantidadExtra);
                $('#lblresumenventa').val(txtResumen);
                
			    if(validarProductoSMARTHUB()){
    			    Swal.fire({
    			        icon: 'warning',
    			        title:'¡Recuerda!',
    			        text: 'Una instalación con 2 cámaras o más requiere la instalación de ARLO SMART HUB.Agrégalo dentro de la lista de extras',
    			        confirmButtonColor: '#e4002b'
    			    }).then((result) => {
    			        
    			    })
			        
			        return;
			    }
                
                Swal.fire({
                    icon: 'success',
                    text: 'Datos generados correctamente',
                    confirmButtonColor: '#e4002b'
                }).then((result) => {
                     $('#modal__carritocompras').modal('hide');
                })
                
            })
            
            $('#generarOferta__Regalo').on('click', function(e){
                
                const txtResumen__Regalo = $('#txtResumen__Regalo').val();
                const txtCantidadRegalo = $('#txtCantidadRegalo').val();
                const txtTotalCuota__Regalo = parseFloat($('#txtTotalCuota__Regalo').val());
                let lbltotalcuota = parseFloat($('#lbltotalcuota').val());
                
                lbltotalcuota += txtTotalCuota__Regalo;
                
                $('#lblresumenventa').val(txtResumen__Regalo);
                $('#lblCantRegalos').val(txtCantidadRegalo);
                $('#lbltotalcuota').val(lbltotalcuota);
                
                Swal.fire({
                    icon: 'success',
                    text: 'Datos generados correctamente',
                    confirmButtonColor: '#e4002b'
                }).then((result) => {
                     $('#modal__regalos').modal('hide');
                })
            })
            
            $('#listaExtras').click(function(e){
                if (e.target.classList.contains('borrar-extra')) {
                    const dataID = e.target.getAttribute('data-id');
                    
                    //Elimina del arreglo de articulosCarrito por el data-id
                    arregloDatos = arregloDatos.filter(datos => datos.dataID != dataID);
                    arregloGeneral = arregloGeneral.filter(datos => datos.dataID != dataID);
                    
                    generarHtml();
                
                    
                   swal.fire('Extra eliminado', 'Se elimino el extra correctamente', 'success');
                }
            })
            
            $('#listaRegalos').click(function(e){
                if (e.target.classList.contains('borrar-regalo')) {
                    const dataID = e.target.getAttribute('data-id');
                    //Elimina del arreglo de articulosCarrito por el data-id
                    arregloRegalos = arregloRegalos.filter(datos => datos.dataID != dataID);
                    arregloGeneral = arregloGeneral.filter(datos => datos.dataID != dataID);
                    
                    generarHtmlRegalos();
            
                    swal.fire('Regalo eliminado', 'Se elimino el regalo correctamente', 'success');
                }
                             
            })
            
            
            
        </script>
        <!-- EVENTOS CARRITOS DE COMPRAS -->
        <script>
            $('#generarExtras').on('click', function(e){
                
                e.preventDefault();
                
                if ($('#lbltipokit').val() != '' && $('#lbltipokit').val() != null){
                    generarHtml();
                    $('#modal__carritocompras').modal('show');
                } else {
                    Swal.fire(
                      'SELECCIONAR KIT',
                      'Por favor seleccionar kit',
                      'warning'
                    );
                }
                
                
            })
            
            $('#generarRegalos').on('click', function(e){
                e.preventDefault();
                
                if ($('#lbltipokit').val() != '' && $('#lbltipokit').val() != null){
                    generarHtmlRegalos();
                    $('#modal__regalos').modal('show');
                    
                } else {
                    Swal.fire(
                      'SELECCIONAR KIT',
                      'Por favor seleccionar kit',
                      'warning'
                    );
                }
                
            })
            
            $('#lblresultadoScoring').on('change', function(){
                const scoring = $('#lblresultadoScoring').val();
                const tipokit = $('#lbltipokit').val();
                const PAI = $('#lblPAI').val();
                var tipoventa=$('#lbltipoventa').val();
                if(tipoventa == 'RPPA' || tipoventa == 'RPPR' || tipoventa == 'RPMKT' || tipoventa == 'RPTMK' || tipoventa == 'RP'){
                    /*
                    if(scoring=="Unica"){
                        $('#lblPAI option[value="PAI 30x36"]').hide();
                        $('#lblPAI option[value="PAI 30x36"]').prop('disabled',true);
                    }else{
                        $('#lblPAI option[value="PAI 30x36"]').show();
                        $('#lblPAI option[value="PAI 30x36"]').prop('disabled',false);
                    }
                    */
                }
            
                if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
                    return;
                } else {
                    categoriaPrecio(scoring, tipokit, PAI);
                }
            })
            
            $('#lbltipokit').on('change', async function(){
                //const resultadoScoring = $('#valresultadoScoring').val();
                const scoring = $('#lblresultadoScoring').val();
                const tipokit = $('#lbltipokit').val();
                const PAI = $('#lblPAI').val();
                const tipoventa=$('#lbltipoventa').val();
                
                const origenvisita=$('#OrigenVisita').val();
                
            
            
                if(tipoventa == 'RPPA' || tipoventa == 'RPPR' || tipoventa == 'RPMKT' || tipoventa == 'RPTMK' || tipoventa == 'RP'){
                    if(scoring=="Unica"  && tipokit!=='Reconexion'){
                        $('#lblPAI option[value="PAI 30x36"]').hide();
                        $('#lblPAI option[value="PAI 30x36"]').prop('disabled',true);
                    }else{
                        $('#lblPAI option[value="PAI 30x36"]').show();
                        $('#lblPAI option[value="PAI 30x36"]').prop('disabled',false);
                    }
                }
                
                if(tipokit=='Basico' && (origenvisita=='FB_CAMERA_PROMO_TEST_BBVA_cotizaciones' || origenvisita=='FB_CAMERA_PROMO_TEST_BBVA_m_cotizaciones')){
                     $("#lblDescuentoCuota option[value='2mesesBBVA']").show();
                }else{
                    $("#lblDescuentoCuota option[value='2mesesBBVA']").hide();
                    $("#lblDescuentoCuota").val("");
                }
                
                if(tipokit=='Basico' && (origenvisita=='FB_CAMERA_PROMO_TEST_OH_cotizaciones' || origenvisita=='FB_CAMERA_PROMO_TEST_OH_m_cotizaciones')){
                     $("#lblDescuentoCuota option[value='2mesesOH']").show();
                }else{
                    $("#lblDescuentoCuota option[value='2mesesOH']").hide();
                    $("#lblDescuentoCuota").val("");
                }
                
                if(tipokit=='ZeroVision' && (origenvisita=='FB_CAMERA_PROMO_TEST_INTERBANK_cotizaciones' || origenvisita=='FB_CAMERA_PROMO_TEST_INTERBANK_m_cotizaciones')){
                     $("#lblDescuentoCuota option[value='2mesesInterbank']").show();
                }else{
                    $("#lblDescuentoCuota option[value='2mesesInterbank']").hide();
                    $("#lblDescuentoCuota").val("");
                }
                
                if(tipokit=='ZeroVision' && (origenvisita=='FB_CAMERA_PROMO_TEST_BCP_cotizaciones' || origenvisita=='FB_CAMERA_PROMO_TEST_BCP_m_cotizaciones')){
                     $("#lblDescuentoCuota option[value='2mesesBCP']").show();
                }else{
                    $("#lblDescuentoCuota option[value='2mesesBCP']").hide();
                    $("#lblDescuentoCuota").val("");
                }
                
                console.log('await');
                const validadorZerovision = await validarZeroVisionSegundoDispostivo();
                console.log(validadorZerovision);
                
                if(validadorZerovision){
                    return;
                }
                
                console.log('Cambio de kit en el arreglo General');
                //ALGORITMO QUE GUARDA EL ULTIMO TIPO DE KIT MODIFICADO
                data = {
                    tipo: 'kit',
                    descripcion: tipokit
                };
                
                console.log(arregloGeneral);
                if(arregloGeneral.length > 0){
                    arregloGeneral.some((elemento,index) => {
                        if(elemento.tipo == 'kit'){
                            arregloGeneral.splice(index, 0);
                            
                            arregloGeneral[index] = data;
                        }
                    })
                } else {
                    arregloGeneral = [...arregloGeneral, data];
                }
                //FIN ALGORITMO
                
                generarResumenInstalacion();
                
                //AGREGAR FUNCION DE OCULTAR ARLO
                if(tipokit=='Camara' || tipokit=='High Security'){
                    $('.camaraarlo').removeClass('ocultar');
                    //PARA REGALO DE SMARTHUB NO ACTIVO
                    $('#cboRegalo option[value="113"]').hide();
                    $('#cboRegalo option[value="113"]').prop('disabled',true);                    
                }else{
                    $('.camaraarlo').addClass('ocultar');
                    //PARA REGALO DE SMARTHUB ACTIVO
                    $('#cboRegalo option[value="113"]').show();
                    $('#cboRegalo option[value="113"]').prop('disabled',false);                    
                }                
                
                if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
                    return;
                } else {
                    categoriaPrecio(scoring, tipokit, PAI);
                }
            })
            
            async function validarZeroVisionSegundoDispostivo(){
                //AWAIT QUE ESPERA HASRTA QUE EL FOR TERMINE PARA CONTINUAR LA EJECUCION
                for await  (const datos of arregloDatos){
                    console.log(datos);
                    //const contents = await fs.readFile(file, 'utf8');
                    if(datos.Item == 'ZEROVISION'){
                        if(datos.TipoPrecio == 'SegundaUnidadKitZV'){
                            swal.fire('Error', 'No puede modificar el tipo de kit porque existe un extra que requiere el tipo de kit ZEROVISION', 'error');
                            $('#lbltipokit').val('ZeroVision');
                            //generarResumenInstalacion();
                            return true;
                        }
                    }
                    
                }
                
                return false;
            }
            
            $('#lblPAI').on('change', function(){
                //const resultadoScoring = $('#valresultadoScoring').val();
                const scoring = $('#lblresultadoScoring').val();
                const tipokit = $('#lbltipokit').val();
                const PAI = $('#lblPAI').val();
                
                if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
                    return;
                } else {
                    categoriaPrecio(scoring, tipokit, PAI);
                }
            })
            
            $('#lblcategoriaprecio').on('change', function(){
                const categoriaPrecio = $('#lblcategoriaprecio').val();
                
                if(categoriaPrecio== '' || categoriaPrecio == null){
                    return;
                } else {
                    $('#hidCategoriaPrecio').val(categoriaPrecio);
                    asignarPrecioKit(categoriaPrecio);
                }
            })
            
            $('#lbldistrito').on('change', function(){
                //Limpiar todos los datos
               $('#lblresultadoScoring').val("");
               $('#valcodigoOperacionScoring').val("");
               $('#valresultadoScoring').val("");
               $('#IdDocRP').val("");
               $('#NombresScoring').val("");
               $('#ApellidoPaternoScoring').val("");
               $('#ApellidoMaternoScoring').val("");
               $('#TipoDocumentoScoring').val("");
               $('#lbldocumentoscoring').val("");
               
               $('#lbltipokit').val("");
               $('#lblPAI').val("");
               $('#lbltipocamarakit').val("");
               $('#lblcategoriaprecio').val("");
               $('#hidCategoriaPrecio').val("");
               $('#lblpreciokit').val("");
               $('#precioKit__MIN').val("");
               $('#precioKit__MAX').val("");
               $('#hidPrecioKit').val("");
               $('#lblCantExtras').val("");
               $('#lbltotalextra').val("");
               $('#lblclosingpack').val("");
               $('#valclosingpack').val("");
               $('#lblresumenventa').val("");
               $('#lblCantRegalos').val("");
               $('#lblDescuentoCuota').val("");
               $('#lbltotalcuota').val("");
               $('#lblextraautorizado').val("");
               closingpack = document.getElementById("lblclosingpack");
               categoriaprecio = document.getElementById("lblcategoriaprecio");
               limpiarDatos(closingpack);
               limpiarDatos(categoriaprecio);
               
               //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE REGALOS
               arregloRegalos = [];
               //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE EXTRAS
               arregloDatos = [];
               //ARREGLO GENERAL DE KIT, REGALOS Y EXTRAS
               arregloGeneral = [];     
               
               var idGeografico = $(this).val();
			   
			   var datos = {
			        idGeografico: idGeografico
			    }
			   
			 //  console.log(idGeografico);
			    var url = 'ajax/findSims.php';
			    $.ajax({
			        type: 'POST',
			        url: url,
			        data: datos,
			        success: function(datos) {
			            console.log(datos);
			         //   $('.mensajematricula').html(datos);
			         $("#lblsims").val(datos);
			        }
			    });
               
            }) 
            
            $('#lblsegmento').on('change', function(){
                //Limpiar todos los datos
               $('#lblresultadoScoring').val("");
               $('#valcodigoOperacionScoring').val("");
               $('#valresultadoScoring').val("");
               $('#IdDocRP').val("");
               $('#NombresScoring').val("");
               $('#ApellidoPaternoScoring').val("");
               $('#ApellidoMaternoScoring').val("");
               $('#TipoDocumentoScoring').val("");
               $('#lbldocumentoscoring').val("");
               
               $('#lbltipokit').val("");
               $('#lblPAI').val("");
               $('#lbltipocamarakit').val("");
               $('#lblcategoriaprecio').val("");
               $('#hidCategoriaPrecio').val("");
               $('#lblpreciokit').val("");
               $('#precioKit__MIN').val("");
               $('#precioKit__MAX').val("");
               $('#hidPrecioKit').val("");
               $('#lblCantExtras').val("");
               $('#lbltotalextra').val("");
               $('#lblclosingpack').val("");
               $('#valclosingpack').val("");
               $('#lblresumenventa').val("");
               $('#lblCantRegalos').val("");
               $('#lblDescuentoCuota').val("");
               $('#lbltotalcuota').val("");
               $('#lblextraautorizado').val("");
               closingpack = document.getElementById("lblclosingpack");
               categoriaprecio = document.getElementById("lblcategoriaprecio");
               limpiarDatos(closingpack);
               limpiarDatos(categoriaprecio);
               
               //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE REGALOS
               arregloRegalos = [];
               //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE EXTRAS
               arregloDatos = [];
               //ARREGLO GENERAL DE KIT, REGALOS Y EXTRAS
               arregloGeneral = [];               
            
            })                
            
            $('#btnAgregar__Regalos').on('click', function(){
                const regalo = $('#cboRegalo').val();
                const cantidad = parseInt($('#cantidadProductos__Regalos').val());
                const datos = {Producto : regalo};
                
                if($('#cantidadProductos__Regalos').val() == '' || $('#cantidadProductos__Regalos').val() == null || $('#cantidadProductos__Regalos').val() <= 0) {
                   swal.fire('Error', 'Indicar la cantidad de regalos', 'error');
                   return;
                }else{
                if(validarProductoARLO(datos)){
                    swal.fire('Error', 'Verificar que hayas añadido Extra Camara Interna o Externa ARLO a precio catálogo', 'error');
                    return;
                }   
                
                fetch('ajax/selectListarExtrasField.php', {method: 'POST', body: JSON.stringify(datos)})
                    .then(function(res) {
                        return res.json();
                    })
                    .then(function(datos) {
                        
                        console.log(datos);
                        
                        const {CodItem, Item, CuotaMes, Precio} = datos;
                        
                        let totalRegalo = Precio*cantidad;
                        let totalCuota = CuotaMes*cantidad;
                        
                        let numAleatorio = getRandomInt(10000, 99999);
                        const dataID = `${Item}-${numAleatorio}`;
                        
                       var data = {
                                CodItem: CodItem,
                                Item: Item,
                                cantidad: cantidad,
                                Precio: Precio,
                                CuotaMes: CuotaMes,
                                totalProductos: totalRegalo,
                                totalCuota: totalCuota,
                                dataID: dataID
                            };
                            
                            
                        arregloRegalos = [...arregloRegalos, data];
                        
                        const datosExtra = {
                            tipo: 'regalo',
                            descripcion: Item,
                            dataID: dataID
                        }
                        
                        arregloGeneral = [...arregloGeneral, datosExtra];
                        
                        generarHtmlRegalos();
                    })
                }
                
            })
            
            $('#lblpreciokit').on('blur', function(){
                const precio = parseFloat($('#lblpreciokit').val());
                const max = parseFloat($('#precioKit__MAX').val());
                const min = parseFloat($('#precioKit__MIN').val());
                
                if(precio > max || precio < min){
                    Swal.fire('Alerta!', 'El precio del kit no se encuentra en el rango, por favor, VERIFICAR', 'warning')
                    $('#lblpreciokit').val('');
                }
                
            })
            
            $('#lblclosingpack').on('change', function(){
                const lblclosingpack = $('#lblclosingpack').val();
                console.log('Inicia closing pack');
                console.log(lblclosingpack);
                //ALGORITMO QUE ELIMINA EL CLOSING PACK ESCOGIDO ANTES
                arregloGeneral.forEach((elemento, index) => {
                    console.log(elemento);
                    if(elemento.tipo == 'CP'){
                        arregloGeneral.splice(index, 1);
                    }
                })
                //FIN ALGORITMO
                
                if(lblclosingpack == '' || lblclosingpack == null || lblclosingpack == 'Ninguno'){
                    
                } else {
                    data = {
                        tipo: 'CP',
                        descripcion: lblclosingpack
                    };
                    
                    arregloGeneral = [...arregloGeneral, data];
                }
                
                console.log(arregloGeneral);
                
                generarResumenInstalacion();
            })
            
            $('#lbltipoventa').on('change', function(){
            
                //const resultadoScoring = $('#valresultadoScoring').val();
                const scoring = $('#lblresultadoScoring').val();
                const tipokit = $('#lbltipokit').val();
                const PAI = $('#lblPAI').val();
                var tipoventa=$('#lbltipoventa').val();
            
                if(tipoventa == 'RPPA' || tipoventa == 'RPPR' || tipoventa == 'RPMKT' || tipoventa == 'RPTMK' || tipoventa == 'RP'){
                    /*
                    if(scoring=="Unica"){
                        $('#lblPAI option[value="PAI 30x36"]').hide();
                        $('#lblPAI option[value="PAI 30x36"]').prop('disabled',true);
                    }else{
                        $('#lblPAI option[value="PAI 30x36"]').show();
                        $('#lblPAI option[value="PAI 30x36"]').prop('disabled',false);
                    }
                    */
                }                
                
                if(scoring == '' || scoring == null || tipokit == '' ||  tipokit == null ||  PAI == '' ||  PAI == null){
                    return;
                } else {
                    categoriaPrecio(scoring, tipokit, PAI);
                }
            })
            $('#lblDescuentoCuota').on('change', function(){
                //const resultadoScoring = $('#valresultadoScoring').val();
                const DescuentoCuota = $('#lblDescuentoCuota').val();
                if(DescuentoCuota == '2meses'){
                    $('#lblmesesautorizados').val('2.00');
                }else if(DescuentoCuota == '3meses'){
                    $('#lblmesesautorizados').val('3.00');
                }else if(DescuentoCuota == '1mes'){
                    $('#lblmesesautorizados').val('1.00');
                    
                }else{
                    $('#lblmesesautorizados').val('0.00');
                }
            })
            
        </script>
        <!-- NUEVAS FUNCIONES -->
        <script>
            const dc = $('#lbldc').val();
            
            const option = document.createElement("option");
            
            let arregloCategorias;
            
            //GENERA LAS OPCIONES DEL SELECT DE TIPO DE KIT DE ACUERDO A LA DELEGACION Y SEGMENTO
            // DEPRECATED
            function tipoKit(){
                const segmento = $('#lblsegmento').val();
                const tipokit = document.getElementById("lbltipokit");
                
                limpiarDatos(tipokit)
                
                if(segmento == 'RES'){
                    //ARBOL DE DESICIONES PARA ZEROVISION
                    
                    if(dc == '150' || dc == '151' || dc == '120' || dc=='154' || dc=='156' || dc=='157'){
                        let arragloKit = ['Basico', 'ZeroVision'];
                        cargarDatosKit(tipokit, arragloKit);
                    }else if(dc=='155' || dc== '153' || dc == '152' || dc=='158' || dc=='159'){
                        let arragloKit = ['Basico', 'ZeroVision'];
                        cargarDatosKit(tipokit, arragloKit);
                    } else {
                        let arragloKit = ['Basico', 'Premium','ZeroVision'];
                        cargarDatosKit(tipokit, arragloKit);
                    }
                    
                    //ARBOL DE DESICIONES SIN ZEROVISION
                    /*
                    let arragloKit = ['Basico', 'Premium'];
                    cargarDatosKit(tipokit, arragloKit);
                    */
                }
                else if (segmento == 'NEG'){
                    //ARBOL DE DESICIONES PARA ZEROVISION
                    
                    if(dc == '150' || dc == '151' || dc == '120' || dc=='154' || dc=='156' || dc=='157'){
                        let arragloKit = ['Basico', 'ZeroVision'];
                        cargarDatosKit(tipokit, arragloKit);
                    }
                    else if (dc=='155' || dc== '153' || dc == '152' || dc=='158' || dc=='159'){
                        let arragloKit = ['Basico', 'ZeroVision'];
                        cargarDatosKit(tipokit, arragloKit);
                    } else {
                        let arragloKit = ['Basico', 'Premium', 'ZeroVision'];
                        cargarDatosKit(tipokit, arragloKit);
                    }
                    //ARBOL DE DESICIONES SIN ZEROVISION
                    /*
                    let arragloKit = ['Basico', 'Premium'];
                    cargarDatosKit(tipokit, arragloKit);
                    */
                }
            }
            
            function cargarDatosKit(tipokit, arragloKit){
                for (value in arragloKit) {
                    let option = document.createElement("option");
                    option.value = arragloKit[value];
                    option.text = arragloKit[value];
                    tipokit.add(option);
                }
            }
            
function closingPack(){
			const lblcategoriaprecio = $('#hidCategoriaPrecio').val();
			const hidclosingpackAutorizados=$('#hidclosingpackAutorizados').val();
			console.log(lblcategoriaprecio);
			const lbltipokit = $('#lbltipokit').val();
			closingpack = document.getElementById("lblclosingpack");
			console.log(lbltipokit);
			
			const dc=$('#lbldc').val();
			const segmento = $('#lblsegmento').val();
			
			limpiarDatos(closingpack);
			
			if(dc==155 || dc == 153 || dc==200){

    			if(lbltipokit == 'Camara' || lbltipokit == 'High Security' || lbltipokit == 'ZeroVision PRO' || lbltipokit == 'Basico PRO'){
    			
    			    if(segmento=='RES'){

        			    if(lblcategoriaprecio == 'MEGA SUPERVENTA' || lblcategoriaprecio == 'SUPERVENTA' || lblcategoriaprecio == 'PRECIO ALTO' || lblcategoriaprecio == 'PRECIO MEDIO'){
        			        let arregloValueClosingPack = ['Ninguno', '1Magnetico'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    } 
        			    else if(hidclosingpackAutorizados=="SI"){
        			        let arregloValueClosingPack = ['Ninguno', '1Magnetico'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
        			    }                    
        			    else {
        			        let arregloValueClosingPack = ['Ninguno'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    }
    			        
    			    }else{
    			        
        			    if(lblcategoriaprecio == 'MEGA SUPERVENTA' || lblcategoriaprecio == 'SUPERVENTA' || lblcategoriaprecio == 'PRECIO ALTO' || lblcategoriaprecio == 'PRECIO MEDIO'){
        			        let arregloValueClosingPack = ['Ninguno', '1Pulsador'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    } 
        			    else if(hidclosingpackAutorizados=="SI"){
        			        let arregloValueClosingPack = ['Ninguno', '1Pulsador'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
        			    }                    
        			    else {
        			        let arregloValueClosingPack = ['Ninguno'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    }
    			        
    			        
    			    }
    			

    			}
    			else if(hidclosingpackAutorizados=="SI"){
    			    let arregloValueClosingPack = ['Ninguno', '1FOTO'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			}
    			else {
    			    let arregloValueClosingPack = ['Ninguno'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			}				
			
			}else if(dc==154 || dc==158 || dc == 151 || dc == 152  || dc == 150 || dc == 156 || dc == 157 || dc == 159 || dc == 251 || dc == 252 || dc == 513 || dc == 701 || dc == 702 || dc == 601 || dc == 602){

    			if(lbltipokit == 'Camara' || lbltipokit == 'High Security' || lbltipokit == 'ZeroVision PRO' || lbltipokit == 'Basico PRO' || lbltipokit == 'ZeroVision PRO LA CURACAO' || lbltipokit == 'Basico PRO LA CURACAO'){
    			
    			    if(segmento=='RES'){

        			    if(lblcategoriaprecio == 'MEGA SUPERVENTA' || lblcategoriaprecio == 'SUPERVENTA' || lblcategoriaprecio == 'PRECIO ALTO' || lblcategoriaprecio == 'PRECIO MEDIO'){
        			        let arregloValueClosingPack = ['Ninguno', '1Magnetico'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    } 
        			    else if(hidclosingpackAutorizados=="SI"){
        			        let arregloValueClosingPack = ['Ninguno', '1Magnetico'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
        			    }                    
        			    else {
        			        let arregloValueClosingPack = ['Ninguno'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    }
    			        
    			    }else{
    			        
        			    if(lblcategoriaprecio == 'MEGA SUPERVENTA' || lblcategoriaprecio == 'SUPERVENTA' || lblcategoriaprecio == 'PRECIO ALTO' || lblcategoriaprecio == 'PRECIO MEDIO'){
        			        let arregloValueClosingPack = ['Ninguno', '1Pulsador'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    } 
        			    else if(hidclosingpackAutorizados=="SI"){
        			        let arregloValueClosingPack = ['Ninguno', '1Pulsador'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
        			    }                    
        			    else {
        			        let arregloValueClosingPack = ['Ninguno'];
        			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
        			    }
    			        
    			        
    			    }
    			
    			}
    			else if(hidclosingpackAutorizados=="SI"){
    			    let arregloValueClosingPack = ['Ninguno', '2Magnetico', '1Magnetico', '1FOTO'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			}
    			else {
    			    let arregloValueClosingPack = ['Ninguno'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			}			    
			    
			}else{

    			if(lbltipokit == 'ZeroVision' || lbltipokit == 'Camara' || lbltipokit == 'High Security'){
    			
    			    if(lblcategoriaprecio == 'MEGA SUPERVENTA' || lblcategoriaprecio == 'SUPERVENTA' || lblcategoriaprecio == 'PRECIO ALTO' || lblcategoriaprecio == 'PRECIO MEDIO' ){
    			        let arregloValueClosingPack = ['Ninguno', '3Magnetico', '2Magnetico', '1Magnetico', '1MG+1FOTO', '1FOTO'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			    } 
    			    else if(hidclosingpackAutorizados=="SI"){
    			        let arregloValueClosingPack = ['Ninguno', '3Magnetico', '2Magnetico', '1Magnetico', '1MG+1FOTO', '1FOTO'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			    }                    
    			    else {
    			        let arregloValueClosingPack = ['Ninguno'];
    			        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			    }
    			}
    			else if(hidclosingpackAutorizados=="SI"){
    			    let arregloValueClosingPack = ['Ninguno', '3Magnetico', '2Magnetico', '1Magnetico', '1MG+1FOTO', '1FOTO','1MagneticoUpgrade'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);                    
    			}
    			else {
    			    let arregloValueClosingPack = ['Ninguno'];
    			    cargarDatosClosingPack(closingpack, arregloValueClosingPack);
    			}
			    
			}
			

			}
            //END DEPRECATED
            
            //NUEVAS 
            
            function cargarDatosClosingPack(closingpack, arregloClosingPack){
                for (value in arregloClosingPack) {
                    var option = document.createElement("option");
                    option.value = arregloClosingPack[value];
                    option.text = arregloClosingPack[value];
                    closingpack.add(option);
                }
            }
            
               function categoriaPrecio(scoring, tipokit, PAI){
                const dc=$('#lbldc').val();
                var uri;
    			if(dc == "150" || dc == "154" || dc == "158" || dc == "151" || dc == "152" || dc == "153" || dc == "155" || dc == "156" || dc == "157" || dc == "159" || dc == "251" || dc == "252" || dc == 513 || dc == 40 || dc == 120 || dc == 121 || dc == "701" || dc == "702" || dc == "601" || dc == "602"){
    			    //Carrito Kits Pro - Nuevos funciones
    			    uri="ajax/selectListarCategoriaPrecio_v2.php"; 
    			}else if(dc == "901" || dc == "711" || dc == "713"){
			        uri = "ajax/selectListarCategoriaPrecio_v3.php";
			    }else{
    			    //Actual Carrito
    			    uri="ajax/selectListarCategoriaPrecio.php";
    			}               
                const categoriaPrecio = document.getElementById("lblcategoriaprecio");
                const hidCategoriaPrecio=$('#hidCategoriaPrecio').val();
                limpiarDatos(categoriaPrecio);
                $('#lblpreciokit').val('');
                limpiarDatos(lblclosingpack);
                 
                const tipoventa = $('#lbltipoventa').val();
                console.log(tipoventa);
                
                if(scoring == 'Unica'){
                    scoring = 0;
                }else if(scoring == 'Limitada'){
                    scoring = 1;
                }else if(scoring == 'Oferta'){
                    scoring = 2;
                }else if(scoring == 'Especial'){
                    scoring = 3;
                }else if(scoring == 'Extraordinaria'){
                    scoring = 4;                     
                }else {
                    scoring = "NA";
                }
                
                const datos = {
                     tipoventa,
                     tipokit,
                     PAI,
                     scoring,
                     hidCategoriaPrecio
                }
                
                console.log(datos);
                
                $.ajax({
                     type: 'POST',
                     data: datos,
                     url: uri,
                     dataType: 'JSON',
                     success: function(data){
                         
                         console.log(data);
                         
                         if(data.respuesta == 'exito'){

                             cargarDatosCategoria(data.datos);
                             
                             arregloCategorias = data.datos;
                         }
                     }
                })
            }
            
            function cargarDatosCategoria(datos){
                console.log(datos);
                
                const categoriaPrecio = document.getElementById("lblcategoriaprecio");
            
                datos.forEach(elemento => {
                    const {Categoria, PrecioMinimo, PrecioMaximo} = elemento;
                    const option = document.createElement("option");
                    
                    option.value = Categoria;
                    option.text = `${Categoria} (S/. ${PrecioMinimo})`;
                    categoriaPrecio.add(option);
                })
                
                //AÑADIR OPCION DE GRANDES CUENTAS
                if($('#hidGGCC').val() == 'SI'){
                    //alert('Grandes Cuentas');
                    const option = document.createElement("option");
                    
                    option.value = 'GGCC';
                    option.text = 'GRANDES CUENTAS';
                    categoriaPrecio.add(option);
                } 
                
                //SET EL VALOR DE LA CATEGORIA GUARDADO PREVIAMENTE
                if($('#hidCategoriaPrecio').val() != ''){
                    $('#lblcategoriaprecio').val($('#hidCategoriaPrecio').val());
                }
                if($('#hidPrecioKit').val() != ''){
                    $('#lblpreciokit').val($('#hidPrecioKit').val());
                }
    			closingPack();
    			$('#lblclosingpack').val($('#valclosingpack').val());                
            }
            
            function asignarPrecioKit(categoriaPrecio){
                
                const lbltipoventa = $('#lbltipoventa').val();
                
                closingPack();
                
                
                if(categoriaPrecio == 'GGCC'){
                    $('#lblpreciokit').val('');
                    $('#precioKit__MIN').val(0);
                    $('#precioKit__MAX').val(99999);
                } else {
                
                    const datosCategoriaSeleccionada = arregloCategorias.filter(function(element){
                      return element.Categoria == categoriaPrecio;
                    });
                    
                    $('#lblpreciokit').val(datosCategoriaSeleccionada[0].PrecioMinimo);
                    $('#precioKit__MIN').val(datosCategoriaSeleccionada[0].PrecioMinimo);
                    $('#precioKit__MAX').val(datosCategoriaSeleccionada[0].PrecioMaximo);
                    
                    if(datosCategoriaSeleccionada[0].ClosingPack == 'SI'){
                        closingPack();
                    }
                }
            }
            
            function limpiarDatos(select){
                while(select.children.length > 1){
                    select.lastChild.remove();
                    
                    select.value = '';
                    
                }
            }
            
            function generarResumenInstalacion(){
                console.log(arregloGeneral);
                /*
                const lblresumenventa = $('#lblresumenventa').val();
                let nuevoResumen;
            
                if(lblresumenventa.indexOf('ZeroVision') !== -1){
                    nuevoResumen = lblresumenventa.replace('ZeroVision', 'Basico');
                } else {
                    nuevoResumen = lblresumenventa.replace('Basico', 'ZeroVision');
                }
                $('#lblresumenventa').val(nuevoResumen);
                */
                
                let resumen = '';
                
                //ALGORITMO PARA GENERAR EL RESUMEN DE INSTALACION PARA EXTRAS
                arregloGeneral.forEach((elemento, index) => {
                    //Si existe más de un elemento en el arreglo, por defecto el index 0 siempre es el KIT
                    if(arregloGeneral.length > 1){
                        if((arregloGeneral.length -1) == index){
                            resumen += `${elemento.descripcion} (${elemento.tipo})`;
                        } else {
                            resumen += `${elemento.descripcion} (${elemento.tipo}) + `;
                        }
                    } else {
                        //SE AGREGA EL TIPO DE KIT
                        resumen += `${elemento.descripcion}`;
                    }
                    
                })
                
                $('#lblresumenventa').val(resumen);
            
            }
            
        </script>
        <!--AFILIACION -->
        <script>
            $('#btnenviarcorreoafiliar').click(function(e){
                const correo=$('#lblcorreo').val();
                $('#InputCorreo').val(correo);    
            });
            
            $('#ModEnviar').click(function(e){
                var arrayNombre;
                const correo=$('#InputCorreo').val();
                var contrato=$('#lblncontrato').val();
                var nombcliente=getCleanedString($('#lblnombcliente').val().trim());
                arrayNombre=nombcliente.split(' ');
                var NombresScoring=getCleanedString($('#NombresScoring').val());
                var ApellidoPaternoScoring=getCleanedString($('#ApellidoPaternoScoring').val());
                var ApellidoMaternoScoring=getCleanedString($('#ApellidoMaternoScoring').val());
                var TipoDocumentoScoring=$('#TipoDocumentoScoring').val();
                var DocumentoScoring=$('#lbldocumentoscoring').val();
                if(TipoDocumentoScoring==6 || TipoDocumentoScoring==""){
                    TipoDocumentoScoring="0";
                    DocumentoScoring="00000000";
                    if(arrayNombre.length==1){
                        NombresScoring=arrayNombre[0];
                        ApellidoPaternoScoring=" ";
                        ApellidoMaternoScoring=" ";                    
                    }else if(arrayNombre.length==2){
                        NombresScoring=arrayNombre[0];
                        ApellidoPaternoScoring=arrayNombre[1];
                        ApellidoMaternoScoring=" ";   
                    }else{
                        NombresScoring=arrayNombre[0];
                        ApellidoPaternoScoring=arrayNombre[1];
                        ApellidoMaternoScoring=arrayNombre[2];
                    }                    
                }else if(TipoDocumentoScoring==3){
                    TipoDocumentoScoring=1;
                    DocumentoScoring=DocumentoScoring.substring(3);
                }else{
                    TipoDocumentoScoring=0;
                    DocumentoScoring=DocumentoScoring.substring(3);
                }
                console.log(DocumentoScoring);
            
                var url;
                var nombrecompleto;
                if (correo == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(correo)) {
                    Swal.fire({
                    type: 'warning',
                    title: '¡Advertencia!',
                    text: 'Verificar el correo a enviar la afiliacion',
                    })
                }else if(correo.split('@')[1].toLowerCase()=="verisure.pe"){
                    Swal.fire({
                    type: 'warning',
                    title: '¡Advertencia!',
                    text: 'Ingresar diferente al dominio de correo: @verisure.pe',
                    })
                 
                }else{
            
                    nombrecompleto=NombresScoring+" "+ApellidoPaternoScoring+" "+ApellidoMaternoScoring;
                    url="https://clientesverisure.com/apps/afiliacion/"+contrato+"/"+NombresScoring+"/"+ApellidoPaternoScoring+" "+ApellidoMaternoScoring+"/"+DocumentoScoring+"/"+TipoDocumentoScoring+"/"+correo;
                    var datos = {
                         correo:correo,
                         contrato:contrato,
                         nombrecompleto:encodeURIComponent(nombrecompleto),
                         url:encodeURIComponent(url)
                     }
                    $.ajax({
                        type: 'POST',
                        url: 'ajax/correoenvioAfiliacion.php',
                        data: datos,
                        dataType: "Json",
                        success: function(r) {
            
                            console.log(r);
            
                            if (r.respuesta == "exito") {
                                    swal.fire({
                                        title: 'Enviado!',
                                        text: 'El mensaje ha sido enviado exitosamente',
                                        type: 'success'
                                    });
            
                            } else {
                                    swal.fire({
                                        title: 'Error!',
                                        text: 'Ha ocurrido un erro en el envio,intentalo más tarde',
                                        type: 'error'
                                    });
                            }
                            $('#modal-enviarcorreoafiliar').modal('hide');                            
                        }
                    });
                }             
            
            });
            
            function getCleanedString(cadena){
            // Definimos los caracteres que queremos eliminar
            var specialChars = "!@#$^&%*()+=-[]\/{}|:<>?,.";
            
            // Los eliminamos todos
            for (var i = 0; i < specialChars.length; i++) {
               cadena= cadena.replace(new RegExp("\\" + specialChars[i], 'gi'), '');
            }   
            
            // Lo queremos devolver limpio en minusculas
            cadena = cadena.toLowerCase();
            
            // Quitamos acentos y "ñ". Fijate en que va sin comillas el primer parametro
            cadena = cadena.replace(/á/gi,"a");
            cadena = cadena.replace(/é/gi,"e");
            cadena = cadena.replace(/í/gi,"i");
            cadena = cadena.replace(/ó/gi,"o");
            cadena = cadena.replace(/ú/gi,"u");
            cadena = cadena.replace(/ñ/gi,"n");
            
            cadena = cadena.toUpperCase();
            
            return cadena;
            }            
            
        </script>
        <!--AUDITORIA-->
        <script>
            $('#datossbn').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });
            
                $('#datossbn').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_datossbn').val('SI');
                        $('#lblfechacorrecion_datossbn').prop("disabled", false);
                        $('.datossbn').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_datossbn').val('NO');
                        $('#lblfechacorrecion_datossbn').prop("disabled", true);
                        $('.datossbn').addClass('ocultar');
                        
                    }
                        
                });
            
            
                $('#segincorrecto').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_segincorrecto').val('SI');
                        $('.segcorrecion').removeClass('ocultar');
                        $('#lblfechacorrecion_segincorrecto').prop("disabled", false);
                    } else {
                        $('#hidden_segincorrecto').val('NO');
                        $('.segcorrecion').addClass('ocultar');
                        $('#lblfechacorrecion_segincorrecto').prop("disabled", true);
                    }
                    
                });
            
                $('#segincorrecto').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });
            
                $('#imagen').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_imagen').val('SI');
                        $('.imagen').removeClass('ocultar');
                        $('#lblfechacorrecion_imagen').prop("disabled", false);
                    } else {
                        $('#hidden_imagen').val('NO');
                        $('.imagen').addClass('ocultar');
                        $('#lblfechacorrecion_imagen').prop("disabled", true);
                    }
                    
                });
            
                $('#imagen').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });
            
                $('#ingresoprogramacion').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_ingresoprogramacion').val('SI');
                        $('#lblfechacorrecion_ingresoprogramacion').prop("disabled", false);
                    } else {
                        $('#hidden_ingresoprogramacion').val('NO');
                        $('#lblfechacorrecion_ingresoprogramacion').prop("disabled", true);
                    }
                    
                });
            
                $('#ingresoprogramacion').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });
            
                $('#falloscomunicacion').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_falloscomunicacion').val('SI');
                        $('#lblfechacorrecion_falloscomunicacion').prop("disabled", false);
                    } else {
                        $('#hidden_falloscomunicacion').val('NO');
                        $('#lblfechacorrecion_falloscomunicacion').prop("disabled", true);
                    }
                    
                });
            
                $('#falloscomunicacion').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });
            
                $('#missingtest').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_missingtest').val('SI');
                        $('#lblfechacorrecion_missingtest').prop("disabled", false);
                    } else {
                        $('#hidden_missingtest').val('NO');
                        $('#lblfechacorrecion_missingtest').prop("disabled", true);
                    }
                    
                });
            
                $('#missingtest').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });
            
                $('#zerovision').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_zerovision').val('SI');
                        $('#lblfechacorrecion_zerovision').prop("disabled", false);
                        $('.zerovisioncorrecion').removeClass('ocultar');
                    } else {
                        $('#hidden_zerovision').val('NO');
                        $('#lblfechacorrecion_zerovision').prop("disabled", true);
                        $('.zerovisioncorrecion').addClass('ocultar');
                    }
                    
                });
            
                $('#zerovision').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });
            
                $('#fallosupervision').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_fallosupervision').val('SI');
                        $('.fallosupervision').removeClass('ocultar');
                        $('#lblfechacorrecion_fallosupervision').prop("disabled", false);
                    } else {
                        $('#hidden_fallosupervision').val('NO');
                        $('.fallosupervision').addClass('ocultar');
                        $('#lblfechacorrecion_fallosupervision').prop("disabled", true);
                    }
                    
                });
            
                $('#fallosupervision').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });
            
                $('#tamper').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_tamper').val('SI');
                        $('.tamper').removeClass('ocultar');
                        $('#lblfechacorrecion_tamper').prop("disabled", false);
                    } else {
                        $('#hidden_tamper').val('NO');
                        $('.tamper').addClass('ocultar');
                         $('#lblfechacorrecion_tamper').prop("disabled", true);
                    }
                    
                });
            
                $('#tamper').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });
                
            function generarHtmlFalloSupervision() {
            
                limpiarHTMLAuditoria(listaFalloSupervision);
            
                let cantidadExtras = 0;
                let resumen = '';
                let subtotal = 0;
                let subtotalCuota = 0;
            
            
                if (arregloDatosFalloSupervision.length > 0) {
                    arregloDatosFalloSupervision.forEach(datos => {
                        console.log(datos);
            
                        const {
                            CodItem,
                            Item,
                            cantidadProductos,
                            dataID
                        } = datos;
            
                        listaFalloSupervision.innerHTML += `
                                <div class="row" style="margin-top: 5px;">
                                    <div class="col-md-12">
                                        <div class="info-box bg-gray" style="min-height: 0px;margin-bottom:0px">
                                            <p class="info-box-icon" style="width: 50%; font-size: 15px; height: auto; line-height: 0px; font-weight: bold;">${Item} <button type="button" class="btn" style="color: transparent; background-color: transparent;">X</button> </p>
                                            <div class="info-box-content" style="text-align: right;">
                                                <span class="info-box-number">Cantidad: ${cantidadProductos}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            `;
            
                        let cantidad;
            
                        cantidad = parseInt(cantidadProductos);
            
                    })
                }
            
            }
            function generarHtmlTamper() {
            
                limpiarHTMLAuditoria(listaTamper);
            
                let cantidadExtras = 0;
                let resumen = '';
                let subtotal = 0;
                let subtotalCuota = 0;
            
            
                if (arregloDatosTamper.length > 0) {
                    arregloDatosTamper.forEach(datos => {
                        console.log(datos);
            
                        const {
                            CodItem,
                            CuotaMes,
                            Item,
                            Precio,
                            TipoPrecio,
                            cantidadProductos,
                            totalProductos,
                            totalCuota,
                            dataID
                        } = datos;
            
                        let CuotaMes_Round = parseFloat(CuotaMes);
                        let Precio_Round = parseFloat(Precio);
            
                        listaTamper.innerHTML += `
                                <div class="row" style="margin-top: 5px;">
                                    <div class="col-md-12">
                                        <div class="info-box bg-gray" style="min-height: 0px;margin-bottom:0px">
                                            <p class="info-box-icon" style="width: 50%; font-size: 15px; height: auto; line-height: 0px; font-weight: bold;">${Item} <button type="button" class="btn" style="color: transparent; background-color: transparent;">X</button> </p>
                                            <div class="info-box-content" style="text-align: right;">
                                                <span class="info-box-number">Cantidad: ${cantidadProductos}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            `;
            
                        let cantidad;
            
                        cantidad = parseInt(cantidadProductos);
            
                    })
                }
            
            
            }            
            
            function limpiarHTMLAuditoria(cont) {
                //forma recomendada
                while (cont.firstChild) {
                    cont.removeChild(cont.firstChild);
                }
            
            }
            
            function enviarEncuesta(){
                const lblestadoventa = $('#lblestadoventa').val();
                
                if(lblestadoventa === 'InstaladaDEL'){
                    
                    let lblcorreo = $('#lblcorreo').val();
                    let lblnombcliente = $('#lblnombcliente').val();
                    let lblmovil = $('#lblmovil').val();
                    let lblncontrato = $('#lblncontrato').val();
                    let fechainst = moment($('#fechainst').val(), 'DD/MM/YYYY').format('DD-MM-YYYY');
                    let lblmatricula = $('#lblmatricula').val();
                    let lbldc = `PE${$('#lbldc').val()}`;
                    
                    let lbldistrito = $('#lbldistrito option:selected').text();
                    let arraylbldistrito = lbldistrito.split(" - ");
                    let distrito = arraylbldistrito[0];
                    
                    let lblsegmento = $('#lblsegmento').val();
                    let lbltipoventa = $('#lbltipoventa').val();
                    
                    moment.locale('es');
                    let mesinst = moment($('#fechainst').val(), 'DD/MM/YYYY').format('MMMM');
                    
                    data = {
                      "campaign_id": 309740,
                      "survey_id":336720,
                      "respondent_expiration_days": 10,
                      "respondent_email": lblcorreo,
                      "respondent_name": lblnombcliente,
                      "respondent_phone": lblmovil,
                      "numero_de_instalacion": lblncontrato,
                      "fecha_instalacion": fechainst,
                      "matricula_vendedor": lblmatricula,
                      "delegacion": lbldc,
                      "distrito": distrito,
                      "segmento": lblsegmento,
                      "recurso": lbltipoventa,
                      "mes_de_instalacion": mesinst,
                      "apellido": " "
                    }
                    
                    fetch('https://qservus.redcalidad.com/api/addrespondent/', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Authorization': 'Token 69091bedd687e3b2da71f0d804df3853242a493c'
                        },
                        body: JSON.stringify(data),
                    })
                    .then(response => response.json())
                    .then(data => {
                      console.log('Success:', data);
                    })
                    .catch((error) => {
                      console.error('Error:', error);
                    });

                }
            }            
                
        </script>      
        <script>
            $('#inci_tecnica').bootstrapToggle({
			on:'SI',
			off:'NO',
			onstyle:'success',
			offstyle:'danger'
			});
        </script>
      <script>
                $('#lblfechacorrecion_kitnoinstalado').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#kitnoinstalado').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#kitnoinstalado').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_kitnoinstalado').val('SI');
                        $('#lblfechacorrecion_kitnoinstalado').prop("disabled", false);
                        $('.kitnoinstalado').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_kitnoinstalado').val('NO');
                        $('#lblfechacorrecion_kitnoinstalado').prop("disabled", true);
                        $('.kitnoinstalado').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_errorcomprobantepago').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#errorcomprobantepago').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#errorcomprobantepago').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_errorcomprobantepago').val('SI');
                        $('#lblfechacorrecion_errorcomprobantepago').prop("disabled", false);
                        $('.errorcomprobantepago').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_errorcomprobantepago').val('NO');
                        $('#lblfechacorrecion_errorcomprobantepago').prop("disabled", true);
                        $('.errorcomprobantepago').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_errorsegmento').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#errorsegmento').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#errorsegmento').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_errorsegmento').val('SI');
                        $('#lblfechacorrecion_errorsegmento').prop("disabled", false);
                        $('.errorsegmento').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_errorsegmento').val('NO');
                        $('#lblfechacorrecion_errorsegmento').prop("disabled", true);
                        $('.errorsegmento').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_fueranomalcomercial').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#fueranomalcomercial').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#fueranomalcomercial').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_fueranomalcomercial').val('SI');
                        $('#lblfechacorrecion_fueranomalcomercial').prop("disabled", false);
                        $('.fueranomalcomercial').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_fueranomalcomercial').val('NO');
                        $('#lblfechacorrecion_fueranomalcomercial').prop("disabled", true);
                        $('.fueranomalcomercial').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_fueranormativatecnica').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#fueranormativatecnica').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#fueranormativatecnica').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_fueranormativatecnica').val('SI');
                        $('#lblfechacorrecion_fueranormativatecnica').prop("disabled", false);
                        $('.fueranormativatecnica').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_fueranormativatecnica').val('NO');
                        $('#lblfechacorrecion_fueranormativatecnica').prop("disabled", true);
                        $('.fueranormativatecnica').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_incidenciadatos').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#incidenciadatos').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#incidenciadatos').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_incidenciadatos').val('SI');
                        $('#lblfechacorrecion_incidenciadatos').prop("disabled", false);
                        $('.incidenciadatos').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_incidenciadatos').val('NO');
                        $('#lblfechacorrecion_incidenciadatos').prop("disabled", true);
                        $('.incidenciadatos').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_inconformidadfuncionamiento').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#inconformidadfuncionamiento').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#inconformidadfuncionamiento').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_inconformidadfuncionamiento').val('SI');
                        $('#lblfechacorrecion_inconformidadfuncionamiento').prop("disabled", false);
                        $('.inconformidadfuncionamiento').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_inconformidadfuncionamiento').val('NO');
                        $('#lblfechacorrecion_inconformidadfuncionamiento').prop("disabled", true);
                        $('.inconformidadfuncionamiento').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_inconformidadpagoinicial').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#inconformidadpagoinicial').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#inconformidadpagoinicial').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_inconformidadpagoinicial').val('SI');
                        $('#lblfechacorrecion_inconformidadpagoinicial').prop("disabled", false);
                        $('.inconformidadpagoinicial').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_inconformidadpagoinicial').val('NO');
                        $('#lblfechacorrecion_inconformidadpagoinicial').prop("disabled", true);
                        $('.inconformidadpagoinicial').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_inconformidadpagomensual').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#inconformidadpagomensual').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#inconformidadpagomensual').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_inconformidadpagomensual').val('SI');
                        $('#lblfechacorrecion_inconformidadpagomensual').prop("disabled", false);
                        $('.inconformidadpagomensual').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_inconformidadpagomensual').val('NO');
                        $('#lblfechacorrecion_inconformidadpagomensual').prop("disabled", true);
                        $('.inconformidadpagomensual').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_inconformidadtiempopermanencia').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#inconformidadtiempopermanencia').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#inconformidadtiempopermanencia').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_inconformidadtiempopermanencia').val('SI');
                        $('#lblfechacorrecion_inconformidadtiempopermanencia').prop("disabled", false);
                        $('.inconformidadtiempopermanencia').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_inconformidadtiempopermanencia').val('NO');
                        $('#lblfechacorrecion_inconformidadtiempopermanencia').prop("disabled", true);
                        $('.inconformidadtiempopermanencia').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_inconformidadubicaciondispositivos').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#inconformidadubicaciondispositivos').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#inconformidadubicaciondispositivos').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_inconformidadubicaciondispositivos').val('SI');
                        $('#lblfechacorrecion_inconformidadubicaciondispositivos').prop("disabled", false);
                        $('.inconformidadubicaciondispositivos').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_inconformidadubicaciondispositivos').val('NO');
                        $('#lblfechacorrecion_inconformidadubicaciondispositivos').prop("disabled", true);
                        $('.inconformidadubicaciondispositivos').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_noconcefuncionamiento').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#noconcefuncionamiento').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#noconcefuncionamiento').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_noconcefuncionamiento').val('SI');
                        $('#lblfechacorrecion_noconcefuncionamiento').prop("disabled", false);
                        $('.noconcefuncionamiento').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_noconcefuncionamiento').val('NO');
                        $('#lblfechacorrecion_noconcefuncionamiento').prop("disabled", true);
                        $('.noconcefuncionamiento').addClass('ocultar');
                        
                    }
                });

                $('#lblfechacorrecion_notienecontrato').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#notienecontrato').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#notienecontrato').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_notienecontrato').val('SI');
                        $('#lblfechacorrecion_notienecontrato').prop("disabled", false);
                        $('.notienecontrato').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_notienecontrato').val('NO');
                        $('#lblfechacorrecion_notienecontrato').prop("disabled", true);
                        $('.notienecontrato').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_promesaspendientes').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#promesaspendientes').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#promesaspendientes').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_promesaspendientes').val('SI');
                        $('#lblfechacorrecion_promesaspendientes').prop("disabled", false);
                        $('.promesaspendientes').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_promesaspendientes').val('NO');
                        $('#lblfechacorrecion_promesaspendientes').prop("disabled", true);
                        $('.promesaspendientes').addClass('ocultar');
                        
                    }
                });                
                $('#lblfechacorrecion_reclamocomercial').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#reclamocomercial').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#reclamocomercial').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_reclamocomercial').val('SI');
                        $('#lblfechacorrecion_reclamocomercial').prop("disabled", false);
                        $('.reclamocomercial').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_reclamocomercial').val('NO');
                        $('#lblfechacorrecion_reclamocomercial').prop("disabled", true);
                        $('.reclamocomercial').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_solicitabaja').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#solicitabaja').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#solicitabaja').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_solicitabaja').val('SI');
                        $('#lblfechacorrecion_solicitabaja').prop("disabled", false);
                        $('.solicitabaja').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_solicitabaja').val('NO');
                        $('#lblfechacorrecion_solicitabaja').prop("disabled", true);
                        $('.solicitabaja').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_tarjetaafiliadanopertenecetitular').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#tarjetaafiliadanopertenecetitular').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#tarjetaafiliadanopertenecetitular').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_tarjetaafiliadanopertenecetitular').val('SI');
                        $('#lblfechacorrecion_tarjetaafiliadanopertenecetitular').prop("disabled", false);
                        $('.tarjetaafiliadanopertenecetitular').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_tarjetaafiliadanopertenecetitular').val('NO');
                        $('#lblfechacorrecion_tarjetaafiliadanopertenecetitular').prop("disabled", true);
                        $('.tarjetaafiliadanopertenecetitular').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_recepmanual').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#recepmanual').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#recepmanual').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_recepmanual').val('SI');
                        $('#lblfechacorrecion_recepmanual').prop("disabled", false);
                        $('.recepmanual').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_recepmanual').val('NO');
                        $('#lblfechacorrecion_recepmanual').prop("disabled", true);
                        $('.recepmanual').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_descargaapp').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#descargaapp').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#descargaapp').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_descargaapp').val('SI');
                        $('#lblfechacorrecion_descargaapp').prop("disabled", false);
                        $('.descargaapp').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_descargaapp').val('NO');
                        $('#lblfechacorrecion_descargaapp').prop("disabled", true);
                        $('.descargaapp').addClass('ocultar');
                        
                    }
                });
                $('#lblfechacorrecion_capacitado').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });

                $('#capacitado').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#capacitado').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_capacitado').val('SI');
                        $('#lblfechacorrecion_capacitado').prop("disabled", false);
                        $('.capacitado').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_capacitado').val('NO');
                        $('#lblfechacorrecion_capacitado').prop("disabled", true);
                        $('.capacitado').addClass('ocultar');
                        
                    }
                });


                $('#btnModalRespuestaC').on('click', function () {
                    $('#modal_respuestaC').modal('show');
                   
                    $('#modalhorariosugerido').val('');
                    $('#modalcomentario_comercial').val('');
                
                });
                
                $('#btnAgregarRespuesta').on('click', function () {
                    
                    var modalhorariosugerido=$('#modalhorariosugerido').val();
                    var modalcomentario_comercial=$('#modalcomentario_comercial').val();
                    
                    var idcertventa = $('#idcertventa').val();
                    

                var matricula = $('#headerMatriculaUsuario').val();

                var ediventa = $("#idVenta").val();
                
                var lbltipocierre_cert = $("#lbltipocierre_cert").val();
                
                
                
                
                var datos = {
                    array:'array5',
                    lblcomentario_comercial: modalcomentario_comercial,
                    lblhorariosugerido2: modalhorariosugerido,
                    ediventa: ediventa,
                    idcertventa: idcertventa,
                    matricula:matricula,
                    lbltipocierre_cert:lbltipocierre_cert
                };

            Swal.fire({
                title: '¿Deseas guardar respuesta comercial?',
                html: '',
                showCancelButton: true,
                confirmButtonText: `Guardar`,
                icon: 'info',
            }).then((result) => {
                //GESTION
                if (result.isConfirmed) {
                    
                            $('#lblhorariosugerido2').val(modalhorariosugerido);
                            $('#lblcomentario_comercial').val(modalcomentario_comercial);

                            $.ajax({
                                type: 'POST',
                                url: './Controller/ControllerVenta.php',
	                            data: {function: JSON.stringify(datos)},                                
                                dataType: "Json",
                                success: function(data) {
                                    console.log(data);
                                    if (data.respuesta == 'exito') {
                                        Swal.fire({
                                          title:'Modificado con exito!',
                                          text:'Gestion!',
                                          icon:'success',
                                          showCancelButton:false,
                                          confirmButtonColor:'',
                                          confirmButtonText:'OK',
                                          closeOnConfirm: false,
                                          allowOutsideClick: false                          
                                        }).then((result)=>{
                                            if(result.isConfirmed){
                                               //window.location.reload();
                                               
                                            }
                                        });

                                    } else if (data.respuesta == 'sincambios') {
                                        alertify.warning("No se ha realizado ninguna modificación");

                                    } else {
                                        alertify.error("Fallo el server");

                                    }
                                }
                            });
                
                    $('#modal_respuestaC').modal('hide');    
                    
                }
            })


                
                });                
                
                
$(document).ready(function() {
    $('#lblncontrato').on('input', function() {
        var valorContrato = $(this).val(); // Obtener el valor ingresado en lblncontrato
        var valorCategoria = $('#lblcategoria').val(); // Obtener el valor de lblcategoria

        // Obtener la longitud del valor sin tener en cuenta los caracteres de la máscara
        var longitudReal = valorContrato.replace(/_/g, '').length;

        // Verificar si la longitud del valor ingresado es igual a 7 y la categoría es 'Delegacion'
        if (longitudReal === 7 && valorCategoria === 'Delegacion') {
            // console.log("Se han ingresado 7 dígitos en lblncontrato:", valorContrato);
            // console.log(valorCategoria);
                        // Enviar los datos al servidor a través de una solicitud AJAX
            var datos = {
                         ncontrato:valorContrato,
                         categoria:valorCategoria
                        }                
            $.ajax({
                type: 'POST',
                url: 'ajax/consultaContratoGuia.php',
                data: datos,
                dataType: "Json",
                success: function (data) {
                    console.log(data);
                    if (data.respuesta == 'exito') {
                        // Si la respuesta del servidor es un éxito, mostrar un mensaje de éxito
                        alertify.success("El Número Contrato esta vinculado con la Guia de Remisión");

                    } else if (data.respuesta == 'Denegado') {
                        Swal.fire({
                            title: 'Advertencia!',
                            text: 'El número ingresado no esta vinculado con la Guia de Remisión',
                            icon: 'warning',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                            closeOnConfirm: false,
                            allowOutsideClick: false
                        }).then((result) => {
                            // Si el usuario hace clic en OK, recargar la página
                            if (result.isConfirmed) {
                                // window.location.reload();
                                $('#lblncontrato').val('');
                            }
                        });
                        // Si no hay cambios, mostrar un mensaje de advertencia
                        

                    } else {
                        // Si hay un error en el servidor, mostrar un mensaje de error
                        alertify.error("Fallo del servidor");

                    }
                }
            });
        }
    });
});



                
                
    </script>

        
    </body>
</html>