<?php
session_start();
if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
        }


if ($_SESSION['pztecconsulta']==0) {
     header("location: ./denegado.php");
		exit;
        }
        
date_default_timezone_set('America/Lima');
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

include 'config/db.php';
include 'config/conexion.php';
require_once 'helper/helper_validacion.php';
/*
include 'config/dbsec.php';
include 'config/conexionsec.php';
*/
$fechames=date("M-Y");

if (isset($_GET['idamp'])) {

    $idamp = sanitizaCampo($_GET['idamp'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $idamp = htmlspecialchars($idamp);
    
    $titulo="AMPLIACIÓN - N°".$idamp;
    $titulo = htmlspecialchars($titulo);
    
    $sqlAmp=$con->prepare("SELECT
    c.IdCliente,
    c.NCliente,
    c.NombApellido Cliente,
    c.Correo,
    c.Segmento,
    c.Direccion,
    g.IdGeografico,
    g.Distrito,
    g.Provincia,
    c.Telefonouno,
    c.Telefonodos,
    amp.EstadoAmp,
    co.IdCotizacion,
    co.CEInstaladaX,
    DATE_FORMAT(agen.FechaVisitaTEC, '%d/%m/%Y') FechaVisitaTEC,
    TIME_FORMAT(agen.HoraVisitaTEC,'%r') HoraVisitaTEC,
    amp.AsignadoTEC,
    amp.ComentarioAmp,
    amp.CategoriaAmp,
    dc.IdCotDet,
    i.Item,
    i.Iditem,
    dc.Unidades,
    dc.PrecioCotDetalle,
    dc.DetReq,
   	dc2.IdCotDet IdCotDetCostoInst,
    i2.Item ItemCostoInst,
    i2.Iditem IditemCostoInst,
    dc2.DetReq DetReqCostoInst,
    dc2.Unidades UnidadesCostoInst,
    (CASE 
    	WHEN i2.IdItem IS NULL
     	THEN 'RegistrarInst'
     	ELSE 'ModificarInst'
     	END
    ) as CondicionInstalador,
    co.TotalUnidad,
    co.TotalPrecio,
    amp.FechaRegistroInforme
    FROM tblampliacion amp
    INNER JOIN tblcotizacion co on co.IdCotizacion=amp.IdCotizacion
    INNER JOIN tblagenda agen on agen.IdAmp=amp.IdAmp
    INNER JOIN tblcotizaciondetalle dc on dc.IdCotizacion=co.IdCotizacion and dc.Iditem=30
    LEFT JOIN tblcotizaciondetalle dc2 on dc2.IdCotizacion=co.IdCotizacion and dc2.Iditem=31
    INNER JOIN tblitem i on i.IdItem=dc.Iditem
    LEFT JOIN tblitem i2 on i2.IdItem=dc2.Iditem
    INNER JOIN tblcliente c on c.IdCliente=amp.IdCliente
    INNER JOIN tblgeografico g on g.IdGeografico=c.IdGeografico
    WHERE amp.IdAmp=?");
    $sqlAmp->bind_param('i',$idamp);
    $sqlAmp->execute();
    $sqlAmp->store_result();
    $sqlAmp->bind_result(
        $IdClienteRow,
        $NClienteRow,
        $ClienteRow,
        $CorreoRow,
        $SegmentoRow,
        $DireccionRow,
        $IdGeograficoRow,
        $DistritoRow,
        $ProvinciaRow,
        $TelefonounoRow,
        $TelefonodosRow,
        $EstadoAmpRow,
        $IdCotizacionRow,
        $CEInstaladaXRow,
        $FechaVisitaTECRow,
        $HoraVisitaTECRow,
        $AsignadoTECRow,
        $ComentarioAmpRow,
        $CategoriaAmpRow,
        $IdCotDetRow,
        $ItemRow,
        $IditemRow,
        $UnidadesRow,
        $PrecioCotDetalleRow,
        $DetReqRow,
        $IdCotDetCostoInstRow,
        $ItemCostoInstRow,
        $IditemCostoInstRow,
        $DetReqCostoInstRow,
        $UnidadesCostoInstRow,
        $CondicionInstaladorRow,
        $TotalUnidadRow,
        $TotalPrecioRow,
        $FechaRegistroInformeRow
        );
    
     while($sqlAmp->fetch()){
        $IdCliente=$IdClienteRow;
        $NCliente=$NClienteRow;
        $Cliente=$ClienteRow;
        $Correo=$CorreoRow;
        $Segmento=$SegmentoRow;
        $Direccion=$DireccionRow;
        $IdGeografico=$IdGeograficoRow;
        $Distrito=$DistritoRow;
        $Provincia=$ProvinciaRow;
        $htmldistrito='<option value="'.$IdGeografico.'">'.utf8_encode($Distrito).' - '.$Provincia.'</option>';
        $Telefonouno=$TelefonounoRow;
        $Telefonodos=$TelefonodosRow;
        $EstadoAmp=$EstadoAmpRow;
        $IdCotizacion=$IdCotizacionRow;
        $CEInstaladaX=$CEInstaladaXRow;
        $FechaVisitaTEC=$FechaVisitaTECRow;
        $HoraVisitaTEC=$HoraVisitaTECRow;
        $AsignadoTEC=$AsignadoTECRow;
        $IdCotDet=$IdCotDetRow;
        $ComentarioAmp=$ComentarioAmpRow;
        $CategoriaAmp=$CategoriaAmpRow;
        $Item=$ItemRow;
        $Unidades=$UnidadesRow;
        $PrecioCotDetalle = $PrecioCotDetalleRow;
        $DetReq=$DetReqRow;
        $DetReqCostoInst=$DetReqCostoInstRow;
        $IdCotDetCostoInst=$IdCotDetCostoInstRow;
        $IditemCostoInst=$IditemCostoInstRow;
        $CondicionInstalador=$CondicionInstaladorRow;
        $TotalUnidad=$TotalUnidadRow;
        $TotalPrecio=$TotalPrecioRow;
        $FechaRegistroInforme=$FechaRegistroInformeRow; ;
    }
    
    //REQUERIMIENTOS DE CAMARA
    $Puertosdiponibles=NULL;
    $nombPuertosdiponibles="Puertos diponibles";
    $Puntodecorriente=NULL;
    $nombPuntodecorriente="Punto de corriente";
    $Velocidaddesubidamayora1mb=NULL;
    $nombVelocidaddesubidamayora1mb="Velocidad de subida mayor a 1mb";
    $Compatibilidaddecamara=NULL;
    $nombCompatibilidaddecamara="Compatibilidad de camara";

    if(empty($DetReq)){
        $Puertosdiponibles="NO";
        $Puntodecorriente="NO";
        $Velocidaddesubidamayora1mb="NO";
        $Compatibilidaddecamara="NO";
    }else{
        $Requerimientos = json_decode($DetReq, true);
        foreach ($Requerimientos as $key=>$val){
            if($key==$nombPuertosdiponibles){
                $Puertosdiponibles=$val; 
            }
            else if($key==$nombPuntodecorriente){
                $Puntodecorriente=$val; 
            }
            else if($key==$nombVelocidaddesubidamayora1mb){
                $Velocidaddesubidamayora1mb=$val; 
            }
            else if($key==$nombCompatibilidaddecamara){
                $Compatibilidaddecamara=$val; 
            }
        }
    }
            
    //COSTO DE INSTALACION

    $manoobra="Mano de obra por instalacion y cableado con canaletas";
    $preciomanoobra=155.9322;
    $cantidadmanoobra=1;
    $checkmanoobra="NO";
    
    $suministrocable="Suministro de cable UTP Cat6 con 2 conectores  RJ45";
    $preciosumintrocable=127.1186;
    $cantidadsumintrocable=1;
    $checksuministrocable="NO";
    
    $patchcord2mtrs="Patch Cord de 2mtrs";
    $preciopatchcord2mtrs=25.4237;
    $cantidadpatchcord2mtrs=1;
    $checkpatchcord2mtrs="NO";
    
    $instc4mtrs="Instalacion de Camara arriba de los 4mtrs";
    $precioinstc4mtrs=67.7966;
    $cantidadinstc4mtrs=1;
    $checkinstc4mtrs="NO";
    
    $suministrosportemetalico="Suministro e instalacion de soporte metalico para camara exterior";
    $preciosuministrosportemetalico=161.0169;
    $cantidadsuministrosportemetalico=1;
    $checksuministrosportemetalico="NO";
    
    $tomaelectrica="Habilitacion de toma electrica empotrada";
    $preciotomaelectrica=42.3729;
    $cantidadtomaelectrica=1;
    $checktomaelectrica="NO";
    
    $usoadmios="Uso de andamios y/o escaleras por trabajos en altura";
    $preciousoadmios=127.1186;
    $cantidadusoadmios=1;
    $checkusoadmios="NO";
    
    $psjtrujillo="Trujillo";
    $preciotrujillo=59.3220;
    $cantidadtrujillo=1;
    $checkpsjtrujillo="NO";
    
    $psjica="Ica";
    $precioica=33.8983;
    $cantidadica=1;
    $checkpsjica="NO";
    
    $psjarequipa="Arequipa";
    $precioarequipa=127.1186;
    $cantidadarequipa=1;
    $checkpsjarequipa="NO";

       if(empty($DetReqCostoInst)){
            $checkmanoobra="NO";
            $checksuministrocable="NO";
            $checkpatchcord2mtrs="NO";    
            $checkinstc4mtrs="NO";
            $checksuministrosportemetalico="NO";
            $checktomaelectrica="NO";
            $checkusoadmios="NO";
            $checkpsjtrujillo="NO";
            $checkpsjica="NO";
            $checkpsjarequipa="NO";
       }else{
        $CostDET = json_decode($DetReqCostoInst, true);
            foreach ($CostDET as $key=>$val){
                 if($key==$manoobra){
                    $checkmanoobra=$val; 
                 }
                 else if($key==$suministrocable){
                    $checksuministrocable=$val; 
                 }
                 else if($key==$patchcord2mtrs){
                    $checkpatchcord2mtrs=$val; 
                 }
                else if($key==$instc4mtrs){
                    $checkinstc4mtrs=$val; 
                 }
                else if($key==$suministrosportemetalico){
                    $checksuministrosportemetalico=$val; 
                 }
                else if($key==$tomaelectrica){
                    $checktomaelectrica=$val; 
                 }
                else if($key==$usoadmios){
                    $checkusoadmios=$val; 
                 }
                else if($key==$psjtrujillo){
                    $checkpsjtrujillo=$val; 
                 }
                else if($key==$psjica){
                    $checkpsjica=$val; 
                 }
                else if($key==$psjarequipa){
                    $checkpsjarequipa=$val; 
                 }
             }
       }

}


?>


<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
       <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
 

        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">

      
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
        <!-- Bootstrap toogle-->
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
         
         <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css"/>
          <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/plugins/dropzone/dropzone.css" rel="stylesheet" type="text/css"/>
        <script src="admin/bower_components/moment/modernizr-custom.js" type="text/javascript"></script>
 
        <style>

            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;              
            }
            
            #frmEditarVenta .clsreadonly{
                background-color: #fff;
                cursor: pointer;
            }
            
            label{
                font-weight: 400;
                text-align:left;
                font-size: 12px;
            }
            
            .subtitulo{
                text-decoration: underline;
                font-weight: bold;
            }
            
            .blanco-sinborde{
              background: white!important;
              border: none;
            }
            
            .preloader{
                background-color:#FFF;
                width: 100%;
                height: 100%;
                position: absolute;
                z-index: 1;
            }

            .dataTables_wrapper .myfilter .dataTables_filter{float:left}
            .dataTables_wrapper .mylength .dataTables_length{float:right}
            div.dataTables_scrollBody thead th {
                vertical-align: top;
            }
            
            td {
                max-width: 250px;
                overflow: hidden;
                white-space: nowrap;
                text-overflow: ellipsis;
            }
            
            .espacio{
                height:10px;
            }
            
           .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }

            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }

            #frmEditarVenta .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }
            #slider section{
                width: 100%;
            }

            .select2-container--default .select2-selection--single {
                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo { 
                color: #FFFFFF; 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                color: #FFFFFF; 
                background-color: #616161;  
                border-color: #444444; 
            }

            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo {
                background-image: none; 
            } 

            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
                background-color: #444444; 
                border-color: #444444; 
            } 
            

            input[type=number]::-webkit-outer-spin-button,
            
            input[type=number]::-webkit-inner-spin-button {
            
                -webkit-appearance: none;
            
                margin: 0;
            
            }

            input[type=number] {
            
                -moz-appearance:textfield;
            
            }
    
        </style>
        
        <style>
        
            .main-header,.main-sidebar,.left-side{
                position:fixed;
                
            }
               
            .main-header {
                top: 0;
                right: 0;
                left: 0
            }
        
            .content-wrapper,
            .right-side {
                padding-top: 50px
            }
        
            @media (max-width:767px) {
                 .content-wrapper,
                 .right-side {
                    padding-top: 100px
                }
            }
        
        
            .layout-boxed .wrapper {
                max-width: 100%
            }
        
            .wrapper {
                overflow: hidden
            }
        
            .control-sidebar {
                position: fixed;
                height: 100%;
                overflow-y: auto;
                padding-bottom: 50px
            }       
            
        </style>
     
        <style>
            
            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                   -moz-border-radius: 5px;
                        border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                   -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        
                    z-index: 1051 !important;    
                        
            }
        
            hr {
                height: 4px;
                width: 100%;
                background-color: #ecf0f5;
            }
        
            hr {
                /* margin-top: 20px; */
                margin-bottom: 20px;
                border: 0;
                /* border-top: 1px solid #eee; */
            }
        
        
            hr {
                display: block;
                unicode-bidi: isolate;
                -webkit-margin-before: 0.5em;
                -webkit-margin-after: 0.5em;
                -webkit-margin-start: auto;
                -webkit-margin-end: auto;
                overflow: hidden;
                border-style: inset;
               
            }
        
            .box.box-custom {
                border-top-color: #ffffff;
            }
        
            .box {
                position: relative;
                border-radius: 3px;
                background: #ffffff;
                border-top: 3px solid #d2d6de;
                margin-bottom: 5px;
                width: 100%;
                box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            }
            .quitarpadding{
                padding-right: 0px;padding-left: 0px;
            }

        </style>
        
        <style>
            .ocultar {
              display: none;
            }
    
            .btn-blanco {
              background-color: white;
            }
    
            .btn-blanco{
              border: none;
            }
    
            .btn-blanco i{
              color: #E4002B;
            }
    
            .blanco-sinborde{
              background: white!important;
              border: none;
            }
            
            .info-tec label{
                text-align:left; 
                padding: 8px 15px;    
            }
            
            .info-tec button{
                padding: 4px 10px; 
                font-size: 16px;    
            }
            
            .info-tec p{
                padding: 4px 10px; 
                font-size: 16px; 
                font-weight: 600;
                display: inline-block;
            }
            
            
            .texto-derecha{
                text-align: right;
            }
            
            .red{
                color: #E4002B;
            }
            .green{
                color: green;
            }
            .orange{
                color: orange;
            }
    
        </style>
        
        <style>

.image-container {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 100%;
    height: 100%;
    overflow: hidden;
}

.image-container img {
    min-width: 100%;
    object-fit: cover;
    border-radius: 3px;
    -webkit-border-radius: 3px;
    -moz-border-radius: 3px;
    -ms-border-radius: 3px;
    -o-border-radius: 3px;
}

.button-container {
    width: 100%;
    text-align: center;
}

.button-container button {
    padding: 7px 18px;
    border: none;
    border-radius: 3px;
    background: #1976d2;
    color: #fff;
    transition: 0.3s all ease;
    -webkit-transition: 0.3s all ease;
    -moz-transition: 0.3s all ease;
    -ms-transition: 0.3s all ease;
    -o-transition: 0.3s all ease;
}

.button-container button:hover {
    background: #2780da;
}

/* ->Estilos generales */

/* Imágenes */

.images-cards figure {
    position: relative;
}

.images-cards img {
    height: 240px;
}

.images-cards figure figcaption {
    position: absolute;
    top: 0;
    left: 0;
    display: flex;
    width: 100%;
    height: 100%;
    align-items: center;
    justify-content: center;
    background: rgba(0, 0, 0, 0.4);
    color: #fff;
    font-size: 44px;
    cursor: pointer;
    opacity: 0;
    transition: 0.3s all ease;
    -webkit-transition: 0.3s all ease;
    -moz-transition: 0.3s all ease;
    -ms-transition: 0.3s all ease;
    -o-transition: 0.3s all ease;
}

.images-cards figure figcaption:hover {
    opacity: 1;
}

/* ->Imágenes */

/* Selector de imágenes */

#Images .add-new-photo {
    display: flex;
    border: 4px dashed #d2d6de;
    height: 100%;
    min-height: 240px;
    justify-content: center;
    align-items: center;
    font-size: 50px;
    color: #d2d6de;
    border-radius: 4px;
    cursor: pointer;
    transition: 0.3s all ease;
    -webkit-transition: 0.3s all ease;
    -moz-transition: 0.3s all ease;
    -ms-transition: 0.3s all ease;
    -o-transition: 0.3s all ease;
}

#Images .add-new-photo.first:hover {
    background: rgba(255, 255, 255, 0.17);
}

#add-photo-container input {
    display: none;
}

/* ->Selector de imágenes */
</style>        
        
    </head>

    <body class="sidebar-collapse skin-red sidebar-mini">

        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php
            $consultaventa="active";
            
            include 'admin/main-sidebar.php';
            ?>


            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-md-2"></div>
                        <div class="col-md-8">
                        <div class="box box-danger">
                            <div class="box-header">
                                <div class="espacio"></div>
                                <div class="col-xs-12 quitarpadding">
                                    <h3 class="box-title">EDITAR</h3>
                                </div>
                                <div class="col-xs-12 quitarpadding">
                                    <h3 class="box-title cattitle"><?php echo $titulo;?></h3>
                                </div>
                                
                                <div class="box-tools pull-right">
                                    
                                    <a class="btn btn-default btn-sm" id="ModEnviar" name="ModEnviar" <?php if($EstadoAmp=='VAsignadaTEC'){ echo 'style="display: none;"';} ?> ><i class="fa fa-envelope"></i> Descargar</a>
                                        <a class="btn btn-nuevo btn-sm" id="btnguardar" name="btnguardar"><i class="fa fa-save"></i></a>
                                        <a href="amptec.php" class="btn btn-danger btn-sm" ><i class="fa fa-reply"></i> </a>
                                        <a download="message.eml" id="downloadlink" class="btn btn-nuevo" style="display: none">Descargar</a>
                                    </div>
                            </div>
                            <div class="espacio"></div>
                        </div>

                        <form id="frmEditarVenta" method="POST">
    
                            <div class="box box-custom">
                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                   <h5>INFORMACIÓN DEL CLIENTE</h5>
                                  <div class="box-tools pull-right">
                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                    </button>
                                    
                                  </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                    <div class="form-horizontal">
                                        <input type="hidden" id="idAmpl" value="<?php if(isset($_GET['idamp'])){echo $idamp;}else{}?>">
                                        <input type="hidden" id="IdCotizacion" value="<?php echo $IdCotizacion; ?>">
                                        <input type="hidden" id="lblmatriculausuario" value="<?php echo $matriculausuario; ?>">
                                        <input type="hidden" id="FechaRegistroInforme" value="<?php echo $FechaRegistroInforme; ?>">
                                        
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblncliente">NCLIENTE: <span style="color:red">*</span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input name="lblncliente" class="form-control input-sm" id="lblncliente" value="<?php echo $NCliente; ?>" style="width: 100%;" readonly/></td>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcliente">CLIENTE: <span style="color:red">*</span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input name="lblnombcliente" class="form-control input-sm" id="lblnombcliente" value="<?php echo $Cliente;?>" style="width: 100%;" readonly/></td>
                                                             <input id="lblidcliente" name="lblidcliente" value="<?php echo $IdCliente;?>" hidden="">
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblcorreo">CORREO: <span style="font-size: 12px; color:red ">*</span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="email"  class="form-control input-sm" id="lblcorreo" value="<?php echo $Correo;?>" name="lblcorreo" readonly>
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblsegmento" style="text-align:left;">SEGMENTO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                                            <select class="form-control input-sm" name="lblsegmento" id="lblsegmento" disabled>
                                                                                <option>Seleccione</option>
                                                                                <option value="RES"<?php if ($Segmento == "RES") {echo "selected";}?>>RES</option>
                                                                                <option value="NEG"<?php if ($Segmento == "NEG") {echo "selected";}?>>NEG</option>
                                                                            </select>                                  
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lbldireccion">DIRECCIÓN:<span style="color:red">*</span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <textarea class="form-control input-sm" name="lbldireccion" id="lbldireccion" rows="1" style="resize:none" placeholder="Ingresar..." disabled><?php echo $Direccion;?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lbldistrito" style="text-align:left;">DISTRITO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                                        <select class="form-control selectdistrito input-sm" name="lbldistrito" id="lbldistrito" style="width: 100%;" disabled>
                                                                        <?php echo $htmldistrito;?>
                                                                        </select>                                
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblmovil" style="text-align:left;">TELEFONO UNO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="tel" class="form-control input-sm" name="lblmovil" id="lblmovil" value="<?php echo $Telefonouno;?>" readonly>  
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblfijo" style="text-align:left;">TELEFONO DOS: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="tel" class="form-control input-sm" name="lblfijo" id="lblfijo" value="<?php echo $Telefonodos;?>" readonly>                                 
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                        </div>
                                </div>
                                <!-- /.box-body -->
                            </div>
                        
                            <div class="box box-custom">
                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                   <h5>INFORMACIÓN DE LA AMPLIACIÓN CAMARA EXTERNA</h5>
                                  <div class="box-tools pull-right">
                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                    </button>
                                  </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                        <div class="form-horizontal">
                                            <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="cboEstadoAmpliacion">ESTADO AMP: <span style="font-size: 12px; color:red ">*</span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="cboEstadoAmpliacion" id="cboEstadoAmpliacion">
                                                            <option value="VAsignadaTEC" <?php if ($EstadoAmp == 'VAsignadaTEC'){echo 'selected';} ?>>VAsignadaTEC</option>
                                                            <option value="PendienteCotizacion" <?php if ($EstadoAmp == 'PendienteCotizacion'){echo 'selected';} ?>>PendienteCotizacion</option>
                                                        </select>
                                                        </div>
                                                    </div>
                                               </div>
                                               <!--
                                                <div class="col-sm-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblcaminstaladax">CE.INSTALADOX : <span style="font-size: 12px; color:red ">*</span></label>
                                                            <div class="col-sm-8 col-xs-8">
                                                            <input type="text" class="form-control input-sm" name="lblcaminstaladax" id="lblcaminstaladax" value="<?php echo $CEInstaladaX;?>" readonly="readonly">
                                                            </div>
                                                        </div>
                                                </div>
                                                -->
                                           </div>
                                            <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="">F. VISITA TÉCNICA:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                                    <div class="input-group-addon input-sm">
                                                                        <i class="fa fa-calendar"></i>
                                                                    </div>
                                                                    <input type="text" class="form-control pull-right input-sm" id="lblfvisita"  name="lblfvisita" value="<?php echo $FechaVisitaTEC;?>"  data-inputmask="'alias': 'dd/mm/yyyy'" data-mask disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                            </div>
                                            <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblhvisita">H. VISITA TÉCNICA:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="bootstrap-timepicker timepicker">
                                                                <div class="input-group">
                                                                    <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhvisita" id="lblhvisita" value="<?php echo $HoraVisitaTEC;?>"  disabled>
                                                                    <div class="input-group-addon input-sm">
                                                                        <i class="fa fa-clock-o"></i>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                            </div>
                                            </div>
                                        </div>        
                               
                                </div>
                                <!-- /.box-body -->
                            </div>

                            <div class="box box-custom">
                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                    <h5>REQUERIMIENTOS DE LA CÁMARA EXTERNA</h5>
                                    <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                    </div>
                                    <input type="hidden" id="iddetcotizacioncamara" value="<?php echo $IdCotDet; ?>">
                                    <input type="hidden" id="iddetcotizacioninstalacion" value="<?php echo $IdCotDetCostoInst;?>">
                                    <input type="hidden" id="TotalUnidad" value="<?php echo $TotalUnidad;?>">
                                    <input type="hidden" id="TotalPrecio" value="<?php echo $TotalPrecio;?>">
                                    <input type="hidden" name="lblcantidadc" id="lblcantidadc" value="<?php echo $Unidades;?>" min="0">
                                    <input type="hidden" name="DetReqCostoInst" id="DetReqCostoInst" value='<?php echo $DetReqCostoInst; ?>' >
                                    <input type="hidden" name="PrecioCotDetalle" id="PrecioCotDetalle" value="<?php echo $PrecioCotDetalle; ?>">
                                </div>
                                <div class="box-body info-tec">
                                    <div>
                                        <h5 class="subtitulo">REQUERIMIENTOS GENERALES:</h5>
                                    </div>
                                    <div class="form-horizontal">
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-md-6 col-sm-12">
                                                <div class="form-group">
                                                    <label class="col-sm-6 col-xs-6 control-label " style="text-align:left; padding: 8px 15px;">PUERTOS DISPONIBLES:</label>
                                                    <div class="col-sm-6 col-xs-6 texto-derecha">
                                                        <button type="button" name="PuertosLess" id="PuertosLess" class="btn btn-blanco btn-xs ocultar"><i class="fa fa-minus"></i></button>
                                                        <p id="lblPuertos"></p>
                                                        <button type="button" name="PuertosPlus" id="PuertosPlus" class="btn btn-blanco btn-xs "><i class="fa fa-plus"></i></button>
                                                        <input type="hidden" id="Puertos" value="0">    
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-sm-12">
                                                <div class="form-group">
                                                    <label class="col-sm-6 col-xs-6 control-label " style="text-align:left;">PUNTOS DE CORRIENTE (POEE): <small class="label"><i class="fa fa-info" id="ReqPCorriente"></i></small></label>
                                                    <div class="col-sm-6 col-xs-6 texto-derecha" >
                                                        <button type="button" name="PuntosCorrienteLess" id="PuntosCorrienteLess" class="btn btn-blanco btn-xs ocultar"><i class="fa fa-minus"></i></button>
                                                        <p id="lblPuntosCorriente"></p>
                                                        <button type="button" name="PuntosCorrientePlus" id="PuntosCorrientePlus" class="btn btn-blanco btn-xs "><i class="fa fa-plus"></i></button>
                                                        <input type="hidden" id="PuntosCorriente" value="0">    
                                                    </div>
                                                </div>
                                            </div>    
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-md-6 col-sm-12">
                                                <div class="form-group">
                                                    <label class="col-sm-6 col-xs-8 control-label " style="text-align:left;">VELOCIDAD DE SUBIDA (Mb) <small class="label"><i class="fa fa-info" id="ReqVSubida"></i></small></label>
                                                    <div class="col-sm-6 col-xs-4 texto-derecha">
                                                        <!--
                                                        <button type="button" name="VelocidadSubidaLess" id="VelocidadSubidaLess" class="btn btn-blanco btn-xs ocultar"><i class="fa fa-minus"></i></button>
                                                        <p id="lblVelocidadSubida"></p>
                                                        <button type="button" name="VelocidadSubidaPlus" id="VelocidadSubidaPlus" class="btn btn-blanco btn-xs"><i class="fa fa-plus"></i></button>
                                                        -->
                                                        <input type="number" class="form-control input-sm" name="VelocidadSubida" id="VelocidadSubida" style="width: 50px; text-align: right; float: right">   
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-sm-12">
                                                <div class="form-group">
                                                    <label class="col-sm-6 col-xs-6 control-label " style="text-align:left;" for="Provincia">PROVINCIA:</label>
                                                    <div class="col-sm-6 col-xs-6">
                                                        <select class="form-control input-sm" id="Provincia" name="Provincia">
                                                            <option disabled selected value="">Seleccione</option>
                                                            <option value="Lima">Lima</option>
                                                            <option value="Trujillo">Trujillo</option>
                                                            <option value="Ica">Ica</option>
                                                            <option value="Arequipa">Arequipa</option>
                                                            <option value="Piura">Piura</option>
                                                        </select>
                                                        <!-- PROVINCIA CLIENTE -->
                                                        <input type="hidden" id="HidProvinciaCliente" name="HidProvinciaCliente" value="<?php echo $Provincia; ?>">
                                                    </div>
                                                </div>
                                            </div>    
                                        </div>
                                    </div>
                                    <div>
                                        <h5 class="subtitulo">REQUERIMIENTOS ADICIONALES:</h5>
                                    </div>
                                    <div class="form-horizontal">
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-md-6 col-sm-12">
                                                <div class="form-group texto-derecha">
                                                    <label class="col-sm-6 col-xs-6 control-label " style="text-align:left;" for="Herramientas">HERRAMIENTAS:</label>
                                                    <div class="col-sm-6 col-xs-6">
                                                        <select class="form-control input-sm" id="Herramientas" name="Herramientas">
                                                            <option disabled selected value="">Seleccione</option>
                                                            <option value="Andamios">Andamios</option>
                                                            <option value="EscaleraTelescopica">Escalera Telescópica</option>
                                                            <option value="EscaleraTijera">Escalera Tijera</option>
                                                        </select>
                                                    </div>
                                                    
                                                </div>    
                                            </div>
                                            <div class="col-md-6 col-sm-12">
                                                <div class="form-group texto-derecha">
                                                    <label class="col-sm-6 col-xs-6 control-label " style="text-align:left;" for="Materiales">MATERIALES:</label>
                                                    <div class="col-sm-6 col-xs-6">
                                                        <select class="form-control input-sm" id="Materiales" name="Materiales">
                                                            <option disabled selected value="">Seleccione</option>
                                                            <option value="Caneletas">Caneletas</option>
                                                            <option value="Tuberia PVC">Tuberia PVC</option>
                                                        </select>
                                                    </div>
                                                    
                                                </div>    
                                            </div>
                                            <div class="col-md-6 col-sm-12">
                                                <div class="form-group texto-derecha">
                                                    <label class="col-sm-6 col-xs-6 control-label " style="text-align:left;" for="">INSTALACIÓN POR:</label>
                                                    <div class="col-sm-6 col-xs-6">
                                                            <select class="form-control input-sm" id="InstaladoX" name="InstaladoX">
                                                            <option disabled selected value="">Seleccione</option>
                                                            <option value="Verisure">Verisure</option>
                                                            <option value="Contrata">Contrata</option>
                                                            <option value="Cliente">Cliente</option>
                                                        </select>   
                                                    </div>
                                                </div>    
                                            </div>                                            
                                            <div class="col-md-6 col-sm-12">
                                                <div class="form-group texto-derecha">
                                                    <label class="col-sm-6 col-xs-6 control-label " style="text-align:left;" for="Compatibilidad">COMPATIBILIDAD:</label>
                                                    <div class="col-sm-6 col-xs-6">
                                                        <input type="checkbox" class="minimal-red" id="Compatibilidad" name="Compatibilidad">    
                                                    </div>
                                                </div>    
                                            </div>
                                        </div>
                                    </div>
                                    <div>
                                        <h5 class="subtitulo">REQUERIMIENTOS ESPECIFICOS POR CÁMARA:</h5>
                                    </div>
                                    <div class="form-horizontal">
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-md-6 col-sm-12" id="divCamEspecifica">
                                            </div>    
                                        </div>    
                                    </div>
                                    <div>
                                        <h5 class="subtitulo">COMENTARIOS:</h5>
                                    </div>
                                    <div class="form-horizontal">
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-12">
                                                <textarea class="form-control" rows="6" id="ComentarioCamara" name="ComentarioCamara"></textarea>
                                            </div>     
                                        </div>
                                    </div>
                                     
                                </div>
                                <div class="box-footer" style="font-size: 8px">
                                    <p><i class="fa fa-check green"></i>  CUMPLE TODOS REQUISITOS</p>
                                    <p><i class="fa fa-info orange"></i>  CUMPLE ALGUNOS REQUISITOS</p>
                                    <p><i class="fa fa-times red"></i>  NO CUMPLE LOS REQUISITOS</p>
                                </div>
                                    <div>
                                        <h5 class="subtitulo">IMAGENES:</h5>
                                    </div>                                
       <div class="form-group agregarMultimedia"> 
              <!--=====================================
              SUBIR MULTIMEDIA DE PRODUCTO FÍSICO
              ======================================-->
              
              <div class="multimediaFisica needsclick dz-clickable">

                <div class="dz-message needsclick">
                  
                  Arrastrar o dar click para subir imagenes.

                </div>

              </div>

            </div>
            <div class="row">
                <div id="imagenes">
                    
                </div>

                            </div>                                      
                        </form>
                    </div>
                    
                    <div class="col-md-2"></div>

         
                </section>
                <!-- /.content -->

            </div>
                </section>
            <!-- /.content-wrapper -->
                <div class="control-sidebar-bg"></div>
            </div>
        </div>
            <!-- ./wrapper -->
        
        <!-- MODALES -->
        <div class="modal fade" id="modal-RegistroCE">
          <div class="modal-dialog">
              <div class="modal-content">
                  <div class="modal-header modal-header-danger">
                      <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                      <h4 id="myModalLabel"></h4>
                      <input type="hidden" id="ModIdCotDet">
                  </div>
                  <div class="modal-body">
                        <div class="box box-danger">
                            <div class="box-header">
                              <h3 class="box-title">REQUERIMIENTOS</h3>
                            </div>
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-6 col-sm-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control blanco-sinborde" value="Tamaño del cable (m)" disabled style="border-bottom: 0.5px solid #d2d6de;">
                                                <span class="input-group-addon blanco-sinborde" style="border-bottom: 0.5px solid #d2d6de; padding: 0px;">
                                                    <input type="number" class="minimal-red form-control input-sm" name="TamañoCable" id="TamañoCable" style="width: 40px">
                                                </span>
                                            </div>      
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-sm-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <label class="form-control blanco-sinborde"  style="border-bottom: 0.5px solid #d2d6de;" for="PatchCord">Patch Cord (2m)</label>
                                                <span class="input-group-addon blanco-sinborde" style="border-bottom: 0.5px solid #d2d6de;">
                                                    <input type="checkbox" class="minimal-red" name="PatchCord" id="PatchCord" >
                                                </span>
                                            </div>      
                                        </div>
                                    </div>
                                
                                </div>
                            </div>
                        </div>
                        <div class="box box-danger">
                            <div class="box-header">
                                <h3 class="box-title">ADICIONALES</h3>    
                            </div>
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-12 col-sm-12">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control blanco-sinborde ocultar" value="Instalacion de Camara arriba de los 4 metros" disabled style="border-bottom: 0.5px solid #d2d6de;">
                                                <span class="input-group-addon blanco-sinborde" style="border-bottom: 0.5px solid #d2d6de;">
                                                    <input type="checkbox" class="minimal-red" name="CheckAltura" id="CheckAltura" >
                                                </span>
                                            </div>      
                                        </div>
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control blanco-sinborde" value="Suministro e instalacion de soporte metalico" disabled style="border-bottom: 0.5px solid #d2d6de;">
                                                <span class="input-group-addon blanco-sinborde" style="border-bottom: 0.5px solid #d2d6de;">
                                                    <input type="checkbox" class="minimal-red" name="SoporteMetalico" id="SoporteMetalico">
                                                </span>
                                            </div>      
                                        </div>
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control blanco-sinborde" value="Forma de Brazo Metalico" disabled style="border-bottom: 0.5px solid #d2d6de;">
                                                <span class="input-group-addon blanco-sinborde" style="border-bottom: 0.5px solid #d2d6de; padding: 0px;">
                                                <select class="form-control input-sm" id="Formabrazometalico" name="Formabrazometalico" style="width: 110px;">
                                                            <option disabled selected value="">Seleccione</option>
                                                            <option value="No requiere">No requiere</option>
                                                            <option value="En L">En L</option>
                                                            <option value="En C">En C</option>
                                                            <option value="Lineal">Lineal</option>
                                                        </select>
                                                </span>        
                                            </div>      
                                        </div>
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control blanco-sinborde" value="Medida Brazo Metalico (m)" disabled style="border-bottom: 0.5px solid #d2d6de;">
                                                <span class="input-group-addon blanco-sinborde" style="border-bottom: 0.5px solid #d2d6de; padding: 0px;">
                                                    <input type="number" class="minimal-red form-control input-sm" name="Medidabrazometalico" id="Medidabrazometalico" style="width: 40px">
                                                </span>
                                            </div>      
                                        </div>
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control blanco-sinborde" value="Ubicacion Brazo Metalico" disabled style="border-bottom: 0.5px solid #d2d6de;">
                                                <span class="input-group-addon blanco-sinborde" style="border-bottom: 0.5px solid #d2d6de; padding: 0px;">
                                                    <input type="text" class="minimal-red form-control input-sm" name="Ubicacionbrazometalico" id="Ubicacionbrazometalico" style="width: 100px">
                                                </span>
                                            </div>      
                                        </div>                                        
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control blanco-sinborde" value="Habilitacion de toma electrica empotrada" disabled style="border-bottom: 0.5px solid #d2d6de;">
                                                <span class="input-group-addon blanco-sinborde" style="border-bottom: 0.5px solid #d2d6de;">
                                                    <input type="checkbox" class="minimal-red" name="TomaElectrica" id="TomaElectrica">
                                                </span>
                                            </div>      
                                        </div>
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control blanco-sinborde" value="Altura de la ubicación de la cámara (m)" disabled style="border-bottom: 0.5px solid #d2d6de;">
                                                <span class="input-group-addon blanco-sinborde" style="border-bottom: 0.5px solid #d2d6de; padding: 0px;">
                                                    <input type="number" class="minimal-red form-control input-sm" name="AlturaCamara" id="AlturaCamara" style="width: 40px">
                                                </span>
                                            </div>     
                                        </div>
                                    </div>    
                                </div>    
                            </div>
                        </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                    <button type="button" class="btn btn-danger" id="btnGenerarEspCamExt" >Guardar</button>
                  </div>
              </div>
              <!-- /.modal-content -->
          </div>
          <!-- /.modal-dialog -->
        </div>

    <div class="modal" id="modal-Mensaje">
      <div class="modal-main">
        <div class="row">
          <div class="c-3-lg c-3-md c-1-sm close-modal"></div>
          <div class="c-6-lg c-6-md c-10-sm c-12-xs close-modal">
            <div class="modal-card" id="loading">
              <div class="preloader"></div>
              <span class="tag">Cargando...</span>
            </div>
            <div class="modal-card" id="Message">
              <span class="tag"></span>
            </div>
          </div>
          <div class="c-3-lg c-3-md c-1-sm close-modal"></div>
        </div>
      </div>
    </div>
                
        <!-- jQuery v1.11 -->
  
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
        $.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
       <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
         <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
        <!-- Moment-->
        <script src="admin/bower_components/moment/moment.js" type="text/javascript"></script>
        <script src="admin/bower_components/bootstrap-datepicker-mobile/bootstrap-datepicker-mobile.js" type="text/javascript"></script>
        <!-- Bootstrap toogle -->
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>
        <!-- iCheck 1.0.1 -->
        <script src="admin//plugins/iCheck/icheck.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>        
        <script src="admin/plugins/dropzone/dropzone.js"></script>
        <!-- DOCUMENT READY -->
        <script>
            $(document).ready(function () {
                                                                                
                //Red color scheme for iCheck
                $('input[type="checkbox"].minimal-red, input[type="radio"].minimal-red').iCheck({
                  checkboxClass: 'icheckbox_minimal-red',
                  radioClass   : 'iradio_minimal-red'
                });
                    
                var alterClass = function () {
                    var ww = document.body.clientWidth;
                    if (ww < 767) {
                        $('body').removeClass('sidebar-collapse');
                    } else if (ww >= 768) {
                        $('body').addClass('sidebar-collapse');
                    }
                    ;
                };

                $(window).resize(function () {
                    alterClass();
                });
                //Fire it when the page first loads:
                alterClass();
                            
                $('.selectdistrito').select2({
                    placeholder: 'Seleccione Distrito - Provincia',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {

                            return "Buscando..";
                        }
                    },
                    ajax: {
                        url: 'ajax/selectDistrito.php',
                        dataType: 'json',
                        delay: 250,
                        processResults: function (data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    }
                });
                
                var HidProvinciaCliente = $('#HidProvinciaCliente').val();
                $('#Provincia').val(HidProvinciaCliente);
                
                        
                $('#datemask').inputmask('dd/mm/yyyy', {'placeholder': 'dd/mm/yyyy'});
                //Money Euro
                $('[data-mask]').inputmask();
                
                GenerarInfoTecEspecCamara();
                
                if($('#cboEstadoAmpliacion').val() == 'PendienteCotizacion'){
                    //$('#btnguardar').addClass('ocultar');
                    
                    $('#cboEstadoAmpliacion').prop('disabled', true);
                }
                
                validarRegGen();
                
                
      
            });
                                                                            
            var calcDataTableHeight = function () {
                return $(window).height() * 65 / 100;
            };

            function filterFloat(evt, input) {
                // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
                var key = window.Event ? evt.which : evt.keyCode;
                var chark = String.fromCharCode(key);
                var tempValue = input.value + chark;
                if (key >= 48 && key <= 57) {
                    if (filter(tempValue) === false) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    if (key == 8 || key == 13 || key == 0) {
                        return true;
                    } else if (key == 46) {
                        if (filter(tempValue) === false) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
            }

            function filter(__val__) {
                var preg = /^([0-9]+\.?[0-9]{0,2})$/;
                if (preg.test(__val__) === true) {
                    return true;
                } else {
                    return false;
                }

            }

        </script>
        
        <script>
            $('#PuertosPlus').on('click', function(){
                var Puertos = parseInt($('#Puertos').val());
                Puertos++;
                $('#Puertos').val(Puertos);
                $('#lblPuertos').html(Puertos);
                $('#PuertosLess').removeClass('ocultar');
                
                validarRegGen();
            });
            $('#PuertosLess').on('click', function(){
                var Puertos = parseInt($('#Puertos').val());
                Puertos--;
                if(Puertos>0){
                    $('#Puertos').val(Puertos);
                    $('#lblPuertos').html(Puertos);
                    $('#PuertosLess').removeClass('ocultar');
                } else {
                    $('#Puertos').val(Puertos);
                    $('#lblPuertos').html('');
                    $('#PuertosLess').addClass('ocultar');
                }
                
                validarRegGen();
            })
            $('#PuntosCorrientePlus').on('click', function(){
                var PuntosCorriente = parseInt($('#PuntosCorriente').val());
                PuntosCorriente++;
                $('#PuntosCorriente').val(PuntosCorriente);
                $('#lblPuntosCorriente').html(PuntosCorriente);
                $('#PuntosCorrienteLess').removeClass('ocultar');
                
                validarRegGen();
            });
            $('#PuntosCorrienteLess').on('click', function(){
                var PuntosCorriente = parseInt($('#PuntosCorriente').val());
                PuntosCorriente--;
                if(PuntosCorriente>0){
                    $('#PuntosCorriente').val(PuntosCorriente);
                    $('#lblPuntosCorriente').html(PuntosCorriente);
                    $('#PuntosCorrienteLess').removeClass('ocultar');
                } else {
                    $('#PuntosCorriente').val(PuntosCorriente);
                    $('#lblPuntosCorriente').html('');
                    $('#PuntosCorrienteLess').addClass('ocultar');
                }
                
                validarRegGen();
            })
            
            $('#VelocidadSubida').on('blur', function(){
                validarRegGen();
            })

            $('#btnGenerarAMP').on('click', function(){
              ValidarCamara()
            })

            function ValidarCamara(){
              if($('#CamaraExterna').val() == ''){
                alertify('Seleccionar Cámara Externa');
                $('#CamaraExterna').focus();
                return true;
              }
              if($('#InstaladoXVerisure').is(':checked')){
                alert('Verisure');
                return true;
              }

              return false;
            }
        </script>
        
        <script>
            function datosEspecificosCamaraExterna(idCotizacion){
                
                var TamañoCable =  $('#TamañoCable').val();
                var PatchCord = $('#PatchCord').val();
                if ($("#PatchCord").is(':checked')){
                    var PatchCord = "SI";
                } else {
                    var PatchCord = "NO";
                }
                if ($("#CheckAltura").is(':checked')){
                    var CheckAltura = "SI";
                } else {
                    var CheckAltura = "NO";
                }
                if ($("#SoporteMetalico").is(':checked')){
                    var SoporteMetalico = "SI";
                } else {
                    var SoporteMetalico = "NO";
                }
                var Formabrazometalico = $('#Formabrazometalico').val();
                var Medidabrazometalico= $('#Medidabrazometalico').val();
                var Ubicacionbrazometalico= $('#Ubicacionbrazometalico').val();
                
                if ($("#TomaElectrica").is(':checked')){
                    var TomaElectrica = "SI";
                } else {
                    var TomaElectrica = "NO";
                }
                var AlturaCamara = $('#AlturaCamara').val();
                
                
                datos = {
                    idCotDet: idCotizacion,
                    TamañoCable: TamañoCable,
                    PatchCord: PatchCord,
                    CheckAltura: CheckAltura,
                    SoporteMetalico: SoporteMetalico,
                    Formabrazometalico:Formabrazometalico,
                    Medidabrazometalico:Medidabrazometalico,
                    Ubicacionbrazometalico:Ubicacionbrazometalico,
                    TomaElectrica: TomaElectrica,
                    AlturaCamara: AlturaCamara
                }
                
                
                //console.log(datos);
                
                return datos;
                
            }
            
            $('#btnGenerarEspCamExt').on('click', function(){
                
                var ModIdCotDet = $('#ModIdCotDet').val();
                
                if (ValidarInfoTecCamara()){
                    var datos = JSON.stringify(datosEspecificosCamaraExterna(ModIdCotDet));
                    $('#Hid'+ModIdCotDet).val(datos);
                    //BADGE COLOR Y CAMBIO DE ICONO
                    $('#badge'+ModIdCotDet).removeClass("fa-info");
                    $('#badge'+ModIdCotDet).addClass('fa-check');
                    $('#badge'+ModIdCotDet).parent().css("color", "green");
                    
                    $('#modal-RegistroCE').modal('hide');    
                }
                
            })

                //SUBIR IMAGENES

var arrayFiles = [];

$(".multimediaFisica").dropzone({
	url: "/",
	addRemoveLinks: true,
	acceptedFiles: ".jpeg, .jpg, .png",
	maxFilesize: 6, //2mb
	maxFiles: 10, 	//maximo 10 archivos
	init: function(){

		this.on("addedfile", function(file){

			arrayFiles.push(file);
			console.log("arrayFiles", arrayFiles);
		})

		this.on("removedfile", function(file){

			var index = arrayFiles.indexOf(file);
			arrayFiles.splice(index, 1);
			console.log("arrayFiles", arrayFiles);

		})

	}

})
       
                  
            
            $('#btnguardar').on('click', function(){
                
                alertify.defaults.theme.ok = "btn btn-nuevo";
                alertify.defaults.theme.cancel = "btn btn-danger";
                var lastX,lastY;
                
                alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function(){
                
                    if (ValidarInfoTec()){
                        var procede=false;
                        var multimediaFisica = null;
                        if(arrayFiles != "" ){

		/*=============================================
	   	PREGUNTAMOS SI VIENEN IMÁGENES PARA MULTIMEDIA
	   	=============================================*/

	   		if(arrayFiles.length > 0 ){

	   			var listaMultimedia = [];
	   			var finalFor = 0;
	   			var arrayFotos  = new Array();

	   			for(var i = 0; i < arrayFiles.length; i++){

	   				var datosMultimedia = new FormData();
	   				datosMultimedia.append("file", arrayFiles[i]);
					datosMultimedia.append("IdCotizacion", $('#IdCotizacion').val());
					$.ajax({
						url:"ajax/insertImagenes.php",
						method: "POST",
						data: datosMultimedia,
						cache: false,
						contentType: false,
						processData: false,
						beforeSend: function() {
						    $('.guardarProducto').html("Enviando ...");
						 },
						success: function(respuesta){
							
							listaMultimedia.push({"foto" : respuesta})
							multimediaFisica = JSON.stringify(listaMultimedia);
							
							if((finalFor + 1) == arrayFiles.length){
							    console.log(multimediaFisica);
								//agregarMiProducto(multimediaFisica); 
								finalFor = 0;
								var idAmpl = $('#idAmpl').val();
                        var EstadoAmpliacion = $('#cboEstadoAmpliacion').val();
                        //COTIZACION
                        var IdCotizacion = $('#IdCotizacion').val();
                        var TotalUnidad = $('#TotalUnidad').val();
                        var TotalPrecio = parseFloat($('#TotalPrecio').val());
                        //INFO TEC
                        var iddetcotizacioninstalacion = $('#iddetcotizacioninstalacion').val();
                        var Puertos = $('#Puertos').val();
                        var PuntosCorriente = $('#PuntosCorriente').val();
                        var VelocidadSubida = $('#VelocidadSubida').val();
                        var Provincia = $('#Provincia').val();
                        var PrecioCotDetalle = $('#PrecioCotDetalle').val(); //PRECIO DE LA CAMARA
                        var ComentarioCamara = $('#ComentarioCamara').val();
                        var Herramientas = $('#Herramientas').val();
                        var Materiales = $('#Materiales').val();
                        var InstaladoX = $('#InstaladoX').val();

                        if ($("#Compatibilidad").is(':checked')){
                            var Compatibilidad = "SI";
                        } else {
                            var Compatibilidad = "NO";
                        }
                        //CREAR OBJETO DE REQ. POR CAMARA
                        var iddetcotizacioncamara = $('#iddetcotizacioncamara').val();
                        var lblcantidadc = $('#lblcantidadc').val();
                        var DetCotCam = {};
                        
                        for(var i=1; i<=lblcantidadc; i++){
                            var camDet = 'Hid'+iddetcotizacioncamara+'-'+i;
                            //var CamaraDatos = JSON.stringify();
                            detelleCamara = JSON.parse($('#'+camDet).val());
                            DetCotCam[i] = detelleCamara;
                        }
                    
                        CotizacionTecnica = TotalInstalacionCamara();
                        //MODIFICA DATOS DE LA COTIZACION
                        if (iddetcotizacioninstalacion == ''){
                            TotalUnidad++;
                            TotalPrecio += parseFloat(CotizacionTecnica.TotalInstalacion);    
                        } else {
                            TotalPrecio = parseFloat(PrecioCotDetalle) + parseFloat(CotizacionTecnica.TotalInstalacion);
                        }
                        var FechaRegistroInforme = $('#FechaRegistroInforme').val();
                        
          
                        var datos = {
                            idAmpl: idAmpl,
                            EstadoAmpliacion: EstadoAmpliacion,
                            FechaRegistroInforme:FechaRegistroInforme,
                            IdCotizacion: IdCotizacion,
                            TotalUnidad: TotalUnidad,
                            TotalPrecio: TotalPrecio,
                            iddetcotizacioninstalacion: iddetcotizacioninstalacion,
                            Puertos: Puertos,
                            PuntosCorriente: PuntosCorriente,
                            VelocidadSubida: VelocidadSubida,
                            Provincia: Provincia,
                            Herramientas: Herramientas,
                            Materiales:Materiales,
                            InstaladoX:InstaladoX,
                            Compatibilidad: Compatibilidad,
                            DetCotCam: DetCotCam,
                            CotizacionTecnica: CotizacionTecnica,
                            ComentarioCamara: ComentarioCamara,
                            Imagenes:multimediaFisica
                        }
                        
                        console.log(datos);
                        
                        $.ajax({
                            type: 'Post',
                            url: 'ajax/updateAmpTEC_v3.php',
                            data: datos,
                            dataType: 'JSON',
                            success: function (data) {
                                console.log(data);
                                
                                if (data.respuesta == 'Exito'){
                                    if (data.tipo == 'Insertar'){
                                        Swal.fire(
                                            'Registrado',
                                            'Información Técnica',
                                            'success'
                                        ).then((result) => {
                                                if (result.value) {
                                                  window.location.reload();
                                                }
                                        });    
                                    }
                                    else if (data.tipo == 'Actualizacion'){
                                        Swal.fire(
                                            'Actualizado',
                                            'Información Técnica',
                                            'success'
                                        ).then((result) => {
                                                if (result.value) {
                                                  window.location.reload();
                                                }
                                        }); 
                                    }

                                }
                                else if (data.respuesta == 'SinCambios'){
                                    Swal.fire(
                                      'Sin cambios',
                                      'No se realizaron cambios',
                                      'info'
                                    )
                                }
                                else {
                                    Swal.fire(
                                      'Error',
                                      'Comuniquese con soporte IT ',
                                      'error'
                                    )
                                }
                            }
                        });
                        

							}

							finalFor++;
							
							$('.guardarProducto').html("Guardar producto");
							
							
							
						}

					})

	   			}

	   		}

	                    } else{
	   		    	  Swal.fire({
                          icon: 'warning',
                          title: 'Debes ingresar Imagen(es) referencial de la ruta',
                          showConfirmButton: false,
                          timer: 2000
                        })
	   	        	}
                        


                }
                
                }, function(){ 
                    alertify.error('No se han guardado los cambios')
                    
                }).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},
                    'onfocus':function(){
                    window.scrollTo(lastX, lastY);
                }  }).show();
                
            })
            //CARGAR DATOS DE LA CAMARA
            function GenerarInfoTecEspecCamara(){
                
                var IdCotDet = $('#iddetcotizacioncamara').val();
                var CantCam = $('#lblcantidadc').val();
                
                for (var i = 1; i<=CantCam; i++){
                    //console.log('Hola');
                    
                    var htmldiv = '<a style="cursor: pointer; color: black!important;" id="'+IdCotDet+'-'+i+'"><div class="info-box" style="min-height: 60px">';
                    htmldiv += '<span class="info-box-icon bg-red" style="float: right; height: 56px; width: 55px; font-size: 35px; line-height: 60px;"><i class="fa fa-cog"></i></span>';
                    htmldiv += '<div class="info-box-content" style="margin-left: 0; border: 0.5px solid">';                                
                    htmldiv += '<span class="info-box-text">CÁMARA EXTERNA   <small class="label" style="color: orange"><i class="fa fa-info" id="badge'+IdCotDet+'-'+i+'"></i></small></span>';
                    htmldiv += '<span class="info-box-number">#'+IdCotDet+'-'+i+'</span>';
                    htmldiv += '<input type="hidden" value="" id="Hid'+IdCotDet+'-'+i+'"></div></div></a>'
                    
                    $('#divCamEspecifica').append(htmldiv);
                    $('#'+IdCotDet+'-'+i).addClass('ModCamaraExterna');
                                                
                }
                
                var DetReqCostoInst = $('#DetReqCostoInst').val();
                if (DetReqCostoInst != ''){
                    DetReqCostoInst = JSON.parse(DetReqCostoInst);
                    
                    //GENERAL
                    
                    $('#Puertos').val(DetReqCostoInst.Generales.Puertos);
                    if(DetReqCostoInst.Generales.Puertos > 0){
                        $('#lblPuertos').html(DetReqCostoInst.Generales.Puertos);
                        $('#PuertosLess').removeClass('ocultar');
                    }
                    $('#PuntosCorriente').val(DetReqCostoInst.Generales.PuntosCorriente);
                    if(DetReqCostoInst.Generales.PuntosCorriente > 0){
                        $('#lblPuntosCorriente').html(DetReqCostoInst.Generales.PuntosCorriente);
                        $('#PuntosCorrienteLess').removeClass('ocultar');
                    }
                    $('#VelocidadSubida').val(DetReqCostoInst.Generales.VelocidadSubida);
                    if(DetReqCostoInst.Generales.VelocidadSubida > 0){
                        $('#lblVelocidadSubida').html(DetReqCostoInst.Generales.VelocidadSubida);
                        $('#VelocidadSubidaLess').removeClass('ocultar');
                    }
                    
                    $('#Provincia').val(DetReqCostoInst.Generales.Provincia);
                    

                    $('#Herramientas').val(DetReqCostoInst.Generales.Herramientas);
                    $('#Materiales').val(DetReqCostoInst.Generales.Materiales);
                    $('#InstaladoX').val(DetReqCostoInst.Generales.InstaladoX);
                    
                    if (DetReqCostoInst.Generales.Compatibilidad == "SI"){
                        $('#Compatibilidad').iCheck("check");
                    }
                    
                    $('#ComentarioCamara').html(DetReqCostoInst.Generales.Comentarios);
                    
                    //IMAGENES

  if (typeof DetReqCostoInst.Generales.Imagenes !== 'undefined')
  {
                      if(JSON.parse(DetReqCostoInst.Generales.Imagenes).length>0){
                    for (var i = 0; i<JSON.parse(DetReqCostoInst.Generales.Imagenes).length; i++){
                        $('#imagenes').append('<div class="col-md-4"><div class="thumbnail"><a href="https://www.verismart.com.pe/verismart'+JSON.parse(DetReqCostoInst.Generales.Imagenes)[i].foto.replace('../', '/')+'"><img src="https://www.verismart.com.pe/verismart'+JSON.parse(DetReqCostoInst.Generales.Imagenes)[i].foto.replace('../', '/')+'" alt="Lights" style="width:100%"></a></div></div>');
                    }
                }
  }else{
      $('#imagenes').append('<div class="col-md-12"><div class="thumbnail"><p>No cuenta con imagenes almacendas</p></div></div>');
  }
  

  
                    

                    //CAMARA ESPECIFICA
                    
                    for (var i = 1; i<=CantCam; i++){
    
                        var camaraEspTec = JSON.stringify(DetReqCostoInst.DetCotCam[i]);
                        
                        $('#Hid'+DetReqCostoInst.DetCotCam[i].idCotDet).val(camaraEspTec);
                        
                        if($('#Hid'+DetReqCostoInst.DetCotCam[i].idCotDet).val() != ""){
                            $('#badge'+DetReqCostoInst.DetCotCam[i].idCotDet).removeClass("fa-info");
                            $('#badge'+DetReqCostoInst.DetCotCam[i].idCotDet).addClass('fa-check');
                            $('#badge'+DetReqCostoInst.DetCotCam[i].idCotDet).parent().css("color", "green");
                        }
                    }
                }//END IF
            }
            
            function TotalInstalacionCamara(){
                var TotalInstalacion = 0;
                var DetalleCamara = Array();
                var iddetcotizacioncamara = $('#iddetcotizacioncamara').val();
                var lblcantidadc = $('#lblcantidadc').val();
                if(lblcantidadc==1){
                //TotalInstalacion += (148.64*lblcantidadc); //MANO_DE_OBRA
                DetalleCamara.push(['Mano de obra', (148.64*lblcantidadc).toFixed(4)]);
                }else{
                //TotalInstalacion += (148.64*lblcantidadc*0.80); //MANO_DE_OBRA
                DetalleCamara.push(['Mano de obra', (148.64*lblcantidadc*0.80).toFixed(4)]);                    
                }

                //TotalInstalacion += (123.22*lblcantidadc); //SUMINISTRO DE CABLE
                DetalleCamara.push(['Suministro de cable', (123.22*lblcantidadc)]);

                if ($("#Herramientas").val()=='Andamios'){
                    TotalInstalacion += 127.1186;
                    DetalleCamara.push(['Herramientas','Andamios', 127.1186]);
                }else if($("#Herramientas").val()=='EscaleraTelescopica'){
                    TotalInstalacion += 0;
                    DetalleCamara.push(['Herramientas','EscaleraTelescopica', 0]);
                }else{
                    TotalInstalacion += 0;
                    DetalleCamara.push(['Herramientas','EscaleraTijera', 0]);
                }
                
                if ($("#Provincia").val() == 'Trujillo'){
                    TotalInstalacion += 70;
                    DetalleCamara.push(['Provincia', 'Trujillo',  70]);
                }
                else if ($("#Provincia").val() == 'Arequipa'){
                    TotalInstalacion += 150;
                    DetalleCamara.push(['Provincia', 'Arequipa',  150]);
                }
                else if ($("#Provincia").val() == 'Piura'){
                    TotalInstalacion += 150;
                    DetalleCamara.push(['Provincia', 'Piura',  40]);
                }
                else if ($("#Provincia").val() == 'Ica'){
                    TotalInstalacion += 40;
                    DetalleCamara.push(['Provincia', 'Ica',  40]);
                }
                
                
                
                for(var i=1; i<=lblcantidadc; i++){
                    var camDet = 'Hid'+iddetcotizacioncamara+'-'+i;
                    //var CamaraDatos = JSON.stringify();
                    InfoTecEspCamara = JSON.parse($('#'+camDet).val());
                    
                    if(InfoTecEspCamara.PatchCord == "SI"){
                        TotalInstalacion += 0;
                        DetalleCamara.push([iddetcotizacioncamara+'-'+i, 'PatchCord',  0]);
                    }
                    if(InfoTecEspCamara.CheckAltura == "SI"){
                        TotalInstalacion += 0;
                        DetalleCamara.push([iddetcotizacioncamara+'-'+i, 'CheckAltura',  0]);
                    }
                    if(InfoTecEspCamara.SoporteMetalico == "SI"){
                        TotalInstalacion += 94.75;
                        DetalleCamara.push([iddetcotizacioncamara+'-'+i, 'SoporteMetalico',  94.75]);
                    }
                    if(InfoTecEspCamara.TomaElectrica == "SI"){
                        TotalInstalacion += 0;
                        DetalleCamara.push([iddetcotizacioncamara+'-'+i, 'TomaElectrica',  0]);
                    }
                }
                
                //QUITAR IGV AL PRECIO
                //TotalInstalacion = (TotalInstalacion/1.18).toFixed(4);
                //NETEO DE COSTO 2021-11-12
                TotalInstalacion=0.00;
                TotalInstalacion = TotalInstalacion.toFixed(4);
                
                var Total = {
                    TotalInstalacion: TotalInstalacion,
                    DetalleCamara: DetalleCamara
                };
                
                return Total;
            }
            
            function ValidarInfoTec(){
                
                var iddetcotizacioncamara = $('#iddetcotizacioncamara').val();
                var lblcantidadc = $('#lblcantidadc').val();
                var estado = $('#cboEstadoAmpliacion').val();
                
                if (estado == "PendienteCotizacion"){
                    
                    if($('#Puertos').val() == "0"){
                        Swal.fire({
                          icon: 'warning',
                          title: 'Debes seleccionar la cantidad de Puertos Disponibles',
                          showConfirmButton: false,
                          timer: 1200
                        })
                        return false;
                    }
                    if($('#PuntosCorriente').val() == "0"){
                        Swal.fire({
                          icon: 'warning',
                          title: 'Debes seleccionar la cantidad de PuntosCorriente',
                          showConfirmButton: false,
                          timer: 1200
                        })
                        return false;
                    }
                    if($('#VelocidadSubida').val() == "0"){
                        Swal.fire({
                          icon: 'warning',
                          title: 'Debes seleccionar la Velocidad Subida (Mb)',
                          showConfirmButton: false,
                          timer: 1200
                        })
                        return false;
                    }
                    if($('#Provincia').val() == null){
                        Swal.fire({
                          icon: 'warning',
                          title: 'Debes seleccionar la Provincia',
                          showConfirmButton: false,
                          timer: 1200
                        })
                        return false;
                    }
                    if($('#Herramientas').val() == ''){
                        Swal.fire({
                          icon: 'warning',
                          title: 'Debes seleccionar Herramienta a utilizar',
                          showConfirmButton: false,
                          timer: 1200
                        })
                        return false;
                    }
                    if($('#Materiales').val() == ''){
                        Swal.fire({
                          icon: 'warning',
                          title: 'Debes seleccionar Materiales a utilizar',
                          showConfirmButton: false,
                          timer: 1200
                        })
                        return false;
                    }
                    if($('#InstaladoX').val() == ''){
                        Swal.fire({
                          icon: 'warning',
                          title: 'Debes seleccionar Instalación a realizar',
                          showConfirmButton: false,
                          timer: 1200
                        })
                        return false;
                    }                      
                    for(var i=1; i<=lblcantidadc; i++){
                        var camDet = 'Hid'+iddetcotizacioncamara+'-'+i;
                        //var CamaraDatos = JSON.stringify();
                        if ($('#'+camDet).val() == ''){
                            Swal.fire({
                                icon: 'warning',
                                title: 'Debes completar la información de la cámara '+iddetcotizacioncamara+'-'+i,
                                showConfirmButton: false,
                                timer: 1200
                            })
                        return false;    
                        }
                    }    
                }
                if (estado== "VAsignadaTEC"){
                      Swal.fire({
                          icon: 'warning',
                          title: 'Debes cambiar de estado a PendienteCotizacion',
                          showConfirmButton: false,
                          timer: 1200
                        })
                        return false;
                }
                

                
                return true;
            }
            
            function ValidarInfoTecCamara(){
                if ($('#TamañoCable').val() == ''){
                    Swal.fire({
                        icon: 'warning',
                        title: 'Indicar tamaño del cable',
                        showConfirmButton: false,
                        timer: 1200
                    })
                    return false;
                }
                if ($('#Formabrazometalico').val() == ''){
                    Swal.fire({
                        icon: 'warning',
                        title: 'Seleccionar forma brazo metalico',
                        showConfirmButton: false,
                        timer: 1200
                    })
                    return false;
                }
                if ($('#Medidabrazometalico').val() == ''){
                    Swal.fire({
                        icon: 'warning',
                        title: 'Indicar medida brazo metalico. Si no requiere, colocar 0',
                        showConfirmButton: false,
                        timer: 1200
                    })
                    return false;
                }
                if ($('#Ubicacionbrazometalico').val() == ''){
                    Swal.fire({
                        icon: 'warning',
                        title: 'Indicar ubicacion brazo metalico',
                        showConfirmButton: false,
                        timer: 1200
                    })
                    return false;
                }                
                if ($("#CheckAltura").is(':checked')){
                    if ($('#AlturaCamara').val() == ''){
                        Swal.fire({
                            icon: 'warning',
                            title: 'Indicar altura de la cámara',
                            showConfirmButton: false,
                            timer: 1200
                        })
                        return false;    
                    }
                }
                
                return true;
            }
            
        </script>
        
        <!-- FUNCIONES DEL MODAL -->
        <script>
            $('#modal-RegistroCE').on('hidden.bs.modal', function (e) {
                //LIMPIAR MODAL
                $('#TamañoCable').val('');
                //$('#PatchCord').val(0);
                $('#PatchCord').iCheck('uncheck');
                $('#lblPatchCord').html('');
                $('#PatchCordLess').addClass('ocultar');
                
                $('#CheckAltura').iCheck('uncheck');
                $('#SoporteMetalico').iCheck('uncheck');
                $('#TomaElectrica').iCheck('uncheck');

                $('#Formabrazometalico').val('');
                $('#Medidabrazometalico').val('');
                $('#Ubicacionbrazometalico').val('');
                $('#AlturaCamara').val('');
            })
            
            $('#divCamEspecifica').on('click', '.ModCamaraExterna', function(){
                $('#modal-RegistroCE').modal('show');
                var ModalLabel = $(this).attr('id');
                
                $('#ModIdCotDet').val(ModalLabel);
                $('#myModalLabel').html('CAMARA EXTERNA - #'+ModalLabel);
                
                if ($('#Hid'+ModalLabel).val() != "" ){
                    datos = JSON.parse($('#Hid'+ModalLabel).val());
                    $('#TamañoCable').val(datos.TamañoCable);
                    /*
                    $('#PatchCord').val(datos.PatchCord);
                    $('#lblPatchCord').html(datos.PatchCord);
                    $('#PatchCordLess').removeClass('ocultar');
                    */
                    if(datos.PatchCord == "SI"){
                        $('#PatchCord').iCheck('check');
                    }
                    if(datos.CheckAltura == "SI"){
                        $('#CheckAltura').iCheck('check');
                    }
                    if(datos.SoporteMetalico == "SI"){
                        $('#SoporteMetalico').iCheck('check');
                    }
                    if(datos.TomaElectrica == "SI"){
                        $('#TomaElectrica').iCheck('check');
                    }
                    $('#Formabrazometalico').val(datos.Formabrazometalico);
                    $('#Medidabrazometalico').val(datos.Medidabrazometalico);
                    $('#Ubicacionbrazometalico').val(datos.Ubicacionbrazometalico);
                    $('#AlturaCamara').val(datos.AlturaCamara);
                    //Imagenes
                    
                }
            })
            
             $('#ModEnviar').on('click', function(){
                var lblncliente= $('#lblncliente').val();
                    //textbox = document.getElementById('textbox');
                var idAmpl = $('#idAmpl').val();

                //Algunas variables por default de alertify
                alertify.defaults.theme.ok = "btn btn-nuevo";
                alertify.defaults.theme.cancel = "btn btn-danger";
                var lastX,lastY;
                alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea descargar el archivo de envio?', function(){
                        // Primero validará el formulario.
                        var datos = {idAmpl:idAmpl};
                        console.log(datos);
                        $.ajax({
                           type: 'POST',
                           url: 'ajax/correofichaamptec.php',
                           data: datos,
                           success: function (r) {
                               console.log(r);
                               
                               var link = document.getElementById('downloadlink');
                                link.href = makeTextFile(r);
                                //link.style.display = 'block';

                                download("correo_"+lblncliente+".eml", makeTextFile(r));

                           }
                        });
                }, function(){ alertify.error('Se ha cancelado el envio de correo')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
                    lastX = window.scrollX;
                    lastY = window.scrollY;
                },
                'onfocus':function(){
                    window.scrollTo(lastX, lastY);
                }  }).show();


              })
            
        </script>
        <!-- VALIDA REQUERIMIENTOS GENERALES -->
        <script>
            function validarRegGen(){
                var CantCamaras = $('#lblcantidadc').val();
                
                var ValidarPuertosDisponibles = $('#Puertos').val();

                //PUERTOS
                $('#ReqPuertos').removeClass();
                
                if (ValidarPuertosDisponibles >= CantCamaras){
                    $('#ReqPuertos').addClass("fa fa-check green");
                }
                else if(ValidarPuertosDisponibles == "0"){
                    $('#ReqPuertos').addClass("fa fa-times red");
                }
                else if(ValidarPuertosDisponibles < CantCamaras){
                    $('#ReqPuertos').addClass("fa fa-info orange");
                }
                //PUNTOS DE CORRIENTE
                var PuntosCorriente = $('#PuntosCorriente').val();
                $('#ReqPCorriente').removeClass();
                
                if (PuntosCorriente >= CantCamaras){
                    $('#ReqPCorriente').addClass("fa fa-check green");
                }
                else if(PuntosCorriente == "0"){
                    $('#ReqPCorriente').addClass("fa fa-times red");
                }
                else if(PuntosCorriente < CantCamaras){
                    $('#ReqPCorriente').addClass("fa fa-info orange");
                }
                //VELOCIDAD DE SUBIDA
                var VelocidadSubida = $('#VelocidadSubida').val();
                $('#ReqVSubida').removeClass();
                
                console.log(VelocidadSubida);
                
                if (VelocidadSubida >= CantCamaras){
                    $('#ReqVSubida').addClass("fa fa-check green");
                }
                else if(VelocidadSubida == "0" || VelocidadSubida == ""){
                    $('#ReqVSubida').addClass("fa fa-times red");
                }
                else if(VelocidadSubida < CantCamaras){
                    $('#ReqVSubida').addClass("fa fa-info orange");
                }
            }
        </script>
        <!-- DESCARGAR ARCHIVO PARA ENVIO CORREO -->
        <script>
            var textFile = null,
            makeTextFile = function (text) {
              var data = new Blob([text], {type: 'text/plain'});
              if (textFile !== null) {
                window.URL.revokeObjectURL(textFile);
              }
              textFile = window.URL.createObjectURL(data);
              return textFile;
            };

            var create = document.getElementById('create'),
            textbox = document.getElementById('textbox');
            /*
              create.addEventListener('click', function () {

              }, false);
              */

              function download(nombre, url) {
                  var link= document.createElement('a');
                  link.setAttribute('href', url);
                  link.setAttribute('download', nombre);
                  link.click();
              }
        </script>
        <script>
            //Genera una cadena aleatoria según la longitud dada
function getRandomString(length) {
    var text = "";
    var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    for (var i = 0; i < length; i++)
        text += possible.charAt(Math.floor(Math.random() * possible.length));

    return text;
}

//Genera las previsualizaciones
function createPreview(file, id) {
    var imgCodified = URL.createObjectURL(file);
    var img = $('<div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-xs-12" id="' + id + '"><div class="image-container"> <figure> <img src="' + imgCodified + '" alt="Foto del usuario"> <figcaption> <i class="fa fa-times"></i> </figcaption> </figure> </div></div>');
    $(img).insertBefore("#add-photo-container");
}

//Crea todas las imágenes y las pone en el documento
function createImages(all_ids) {
    for (const key in all_ids) {
        var image = all_ids[key];

        var img = $('<div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-xs-12" data-id="' + image.id + '"><div class="image-container"> <figure> <img src="images/' + image.name + '" alt="Foto del usuario"> <figcaption> <i class="icon-cross"></i> </figcaption> </figure> </div></div>');
        $("#my-images").append(img);
    }
}
//Modals imagenes
function showModal(card) {
  $("#" + card).show();
  $("#modal-Mensaje").addClass("show");
}

function closeModal() {
  $("#modal-Mensaje").removeClass("show");
  setTimeout(function () {
    $("#modal-Mensaje .modal .modal-card").hide();
  }, 300);
}

function loading(status, tag) {
  if (status) {
    $("#loading .tag").text(tag);
    showModal("loading");
  }
  else {
    closeModal();
  }
}

function showMessage(message) {
  $("#Message .tag").text(message);
  showModal("Message");
}

        </script>
    </body>
</html>