<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
    }

    if ($_SESSION['pzwbvisitas']==0) {
        header("location: ./denegado.php");
		exit;
    }
    date_default_timezone_set('America/Lima');
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date)
    {
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date)
    {
        return date('Y-m-d', strtotime($date));
    }
    
    include 'config/db.php';
    include 'config/conexion.php';

    $fechadiahoy=date("M-Y");
    $fechconvercion=date('Y-m-d', strtotime($fechadiahoy));

    $dias=date("d");
    $mes=date("m");
    $ano=date("Y");
    
    $sql="SELECT FechaInicio, FechaFin, DetalleBudget FROM tbltmldbVisitas WHERE MesVisita='".$fechadiahoy."'";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    if($row_cnt>0){
        while($datosVisita = $resultado->fetch_assoc()){
            $FechaInicio = format_date_dd_mm_Y($datosVisita['FechaInicio']);
            $FechaFin = format_date_dd_mm_Y($datosVisita['FechaFin']);
        }
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verisure | VeriSmart</title>

    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" />
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
            folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
    <!-- daterange picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-daterangepicker/daterangepicker.css">
    <!-- Date Picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
    <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
    <!-- Alertifyjs -->
    <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <!--Hoja de estilos de la pagina dashboard visita *No usuar stilos en la misma pagina-->
    <link rel="stylesheet" href="css/dashboardvisita.css">
    
    <link rel="stylesheet" href="admin/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
</head>
<body class="skin-red sidebar-mini sidebar-collapse">
    <div id="divLoading" style="display: none;">
        <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
        </div>
    </div>
    <div class="wrapper">
        <!-- Header -->
        <?php include 'admin/header.php'; ?>
        <!-- Left side column. contains the logo and sidebar -->
        <?php
            $inicio = "active";
            $dashboardvisitas= "active";
            include 'admin/main-sidebar.php';
        ?>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div style="font-size:180%;"> DASHBOARD&nbsp <span style="font-size:80%;color:#DAD8D4"> | &nbsp <span style="font-size:80%;color:#8D8A80">DELEGACIONES</span></span> </div>              
                <ol class="breadcrumb">
                    <li><a class="text-left"><font color="red">Día: <?php echo $dias."/".$mes."/".$ano;?></font></a></li>
                </ol>
            </section>
            <!-- Main content -->
            <section class="content">
                <div class="box box-danger" style="display: none">
                    <div class="box-header"> 
                        <i class="fa fa-bar-chart-o"></i> 
                        <h3 class="box-title">VISITAS - GEOFINDER POR DELEGACIÓN | 
                            <input type="text" style="font-size:100%;color:#444; background-color: #fff;border: 0;"  id="lblFechaRegistro" name="lblFechaRegistro">
                        </h3>
                    </div>
                    
                    <div class="box-body">
                        <table class="table table-hover" id="tblGeofinderGeneral">
                            <thead>
                                <tr style="height:2vw">
                                    <th class="tblSubHeader ">Delegacion</th>
                                    <th class="tblSubHeader text-center">Total Visitas</th>
                                    <th class="tblSubHeader  text-center">Encontradas</th>
                                    <th class="tblSubHeader  text-center">NoEncontradas</th>
                                    <th class="tblSubHeader  text-center">%Encontradas</th>
                                    <th class="tblSubHeader text-center">%NoEncontradas</th>
                                </tr>
                            </thead>
                            <tbody>       
                            </tbody>
                        </table>
                        
                        <p>(*) Visitas generadas desde 19/10/2020</p>
                    </div>
                    <!-- /.box-body-->     
                </div>
                
                <div class="box box-danger" style="display: none">
                    <div class="box-header">
                        <i class="fa fa-bar-chart-o"></i> 
                        <h3 class="box-title">Visitas Geofinder por Distrito</h3> 
                    </div>
                    <div class="box-body">
                        <table class="table table-hover" id="tblGeofinderDistrito">
                            <thead>
                                <tr>
                                    <th class="tblSubHeader">Distrito</th>
                                    <th class="tblSubHeader text-center">Total Visitas</th>
                                    <th class="tblSubHeader  text-center">Encontradas</th>
                                    <th class="tblSubHeader  text-center">NoEncontradas</th>
                                    <th class="tblSubHeader  text-center">%Encontradas</th>
                                    <th class="tblSubHeader text-center">%NoEncontradas</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
                
                <div class="box box-danger" style="display: none">
                    <div class="box-header">
                        <i class="fa fa-bar-chart-o"></i> 
                        <h3 class="box-title">Visitas Diarias - <input type="text" style="font-size:100%;color:#444; background-color: #fff;border: 0;"  id="" name=""></h3>
                    </div>
                    <div class="box-body">
                        <div class="col-md-12">
                            <div id="chart_div" class="chart" style="width: 100%;min-height: 350px;"></div>
                        </div>  
                    </div>
                </div>
                
                <div class="box box-danger">
                    <div class="box-header"> 
                        <i class="fa fa-bar-chart-o"></i> 
                        <h3 class="box-title"> -  | 
                            <input type="text" style="font-size:100%;color:#444; background-color: #fff;border: 0;"  id="lblMesVisita" name="lblMesVisita">
                        </h3>
                    </div>
                    <div class="box-body">
                        <table class="table table-hover" id="tblGeoreferenciacion">
                            <thead>
                                <tr>
                                    <th class="tblSubHeader">Provincia</th>
                                    <th class="tblSubHeader text-center">Total Visitas</th>
                                    <th class="tblSubHeader  text-center">Geo Total</th>
                                    <th class="tblSubHeader  text-center">Geo CC</th>
                                    <th class="tblSubHeader  text-center">%Geo total</th>
                                    <th class="tblSubHeader text-center">%Geo CC</th>
                                    <th class="tblSubHeader text-center">%Geo Exacta</th>
                                    <th class="tblSubHeader text-center">%Geo Aprox</th>
                                    <th class="tblSubHeader text-center">%Check-IN AUTOMÁTICO</th>
                                    <th class="tblSubHeader text-center">%Check-IN MANUAL</th>
                                    <th class="tblSubHeader text-center">%Check-IN FUERA FECHA</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                        <br>
                        <table class="table table-hover" id="tblGeoOperador">
                            <thead>
                                <tr>
                                    <th class="tblSubHeader">Operador</th>
                                    <th class="tblSubHeader text-center">Total Visitas</th>
                                    <th class="tblSubHeader text-center">Busq. en linea</th>
                                    <th class="tblSubHeader text-center">Busq. Fuera llamada</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
                
                <div class="box box-danger">
                    <div class="box-body">
                        
                    </div>
                </div>
                
            </section>
            <?php include 'modalpassword.php';?>
            
        </div>
    </div>
    <!-- jQuery 3 -->
    <script src="admin/bower_components/jquery/dist/jquery.min.js"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <!-- Bootstrap 3.3.7 -->
    <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- SELECT 2 -->
    <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
    <!-- date-range-picker -->
    <script src="admin/bower_components/moment/min/moment.min.js"></script>
    <script src="admin/bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
    <!-- datepicker -->
    <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>

    <!-- Bootstrap WYSIHTML5 -->
    <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
    <!-- Slimscroll -->
    <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <!-- FastClick -->
    <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
    <!-- AdminLTE App -->
    <script src="admin/dist/js/adminlte.min.js"></script>
    <!-- SWEET ALERT -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <!-- CHARTS -->
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    
    <script src="admin/bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="admin/bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
    
    <!-- SCRIPT DASHBOARD -->
    <script>
        const contenedorGeofinderGeneral = document.querySelector('#tblGeofinderGeneral tbody');
        const contenedorGeofinderDistrito = document.querySelector('#tblGeofinderDistrito tbody');
        const contenedorGeoreferenciacion = document.querySelector('#tblGeoreferenciacion tbody');
        const contenedorGeoOperador = document.querySelector('#tblGeoOperador tbody');
    </script>
    <!-- INICIALIZADORES -->
    <script>
        $('#lblFechaRegistro').datepicker({
            autoclose: true,
            language: 'es',
            firstDay: 1,
            todayHighlight: true,
            format: 'dd/mm/yyyy',
            startDate: '19/10/2020'
        }).datepicker("setDate", '19/10/2020');
        
        $('#lblMesVisita').datepicker({
            autoclose: true,
            language: 'en',
            firstDay: 1, format: 'M-yyyy',
            viewMode: "years",
            minViewMode: "months"
        }).datepicker("setDate", new Date());
        
        
    </script>
    <!-- EVENTOS -->
    <script>
        $('#lblFechaRegistro').on('change', ()=>{
            console.log($('#lblFechaRegistro').val());
            
            limpiarHTML(contenedorGeofinderGeneral);
            limpiarHTML(contenedorGeofinderDistrito);
            
            cargarDatos();
        })
        
        $('#lblMesVisita').on('change', ()=> {
            limpiarHTML(contenedorGeoreferenciacion);
            
            cargarDatosGeoreferenciacion();
        })
    </script>
    <!-- DOCUMENT READY -->
    <script>
        $(document).ready(function () {
            //cargarDatos();
            
            cargarDatosGeoreferenciacion();
            
            cargarDatosGeoOperador();
        });
    </script>
    <!-- NUEVAS FUNCIONES -->
        <script>
        function limpiarHTML(cont) {
            //forma recomendada
            while (cont.firstChild) {
                cont.removeChild(cont.firstChild);
            }
        }
        
        function cargarDatos(){
            var lblMesVisita=document.getElementById("lblMesVisita").value;  
            data = {lblMesVisita: lblMesVisita};
            
            console.log(data);
            fetch('./ajax/dataGeofinder.php', {method: 'POST', body: JSON.stringify(data)})
                .then(function(res) {
                    return res.json();
                })
                .then(function(datos) {
                    console.log(datos);
                    for (let [llave, valor] of Object.entries(datos)){
                        
                        if(llave != 'Distritos' && llave != 'Totales' && llave != 'VisitasDiario'){
                            
                            const row = document.createElement('tr');
                            row.style = "height:1vw!important";
                            
                            row.innerHTML = `
                                                <td class="text-left">
                                                    ${valor.Delegacion.Id} - ${valor.Delegacion.Titulo} 
                                                </td>
                                                <td class=" text-center">
                                                    ${valor.Visitas} 
                                                </td>
                                                <td class=" text-center">
                                                    ${valor.Encontradas} 
                                                </td>
                                                <td class=" text-center">
                                                    ${valor.NoEncontradas} 
                                                </td>
                                                <td class=" text-center">
                                                    ${valor.PorcEncontradas} %
                                                </td>
                                                <td class=" text-center">
                                                    ${valor.PorcNoEncontradas} %
                                                </td>
                                            `;
                            //Agrega el HTML de la tabla 
                            contenedorGeofinderGeneral.appendChild(row);
                            
                        }
                        
                        if(llave == 'Distritos'){
                            
                            for(let i=0; i<valor.length; i++){
                                const row = document.createElement('tr');
                                row.style = "height:1vw!important";
                                
                                row.innerHTML = `
                                                    <td class="text-left">
                                                        ${valor[i].DistritoProvincia}
                                                    </td>
                                                    <td class=" text-center">
                                                        ${valor[i].TotalVisitas} 
                                                    </td>
                                                    <td class=" text-center">
                                                        ${valor[i].VisitasEncontradas} 
                                                    </td>
                                                    <td class=" text-center">
                                                        ${valor[i].VisitasNoEncontradas} 
                                                    </td>
                                                    <td class=" text-center">
                                                        ${valor[i].PorcVisitasEncontradas} %
                                                    </td>
                                                    <td class=" text-center">
                                                        ${valor[i].PorcVisitasNoEncontradas} %
                                                    </td>
                                                    
                                                `;
                                //Agrega el HTML de la tabla 
                                contenedorGeofinderDistrito.appendChild(row);
                            }
                        }
                        
                        if (llave == 'Totales'){
                            const row = document.createElement('tr');
                            row.style = "height:1vw!important";
                            row.innerHTML = `
                                                <td></td>
                                                <td class="tblBody text-center tblFooter tblBodyNumber">
                                                    ${valor.TotalVisitas} 
                                                </td>
                                                <td class="tblBody text-center tblFooter tblBodyNumber">
                                                    ${valor.totalVisitasEncontradas} 
                                                </td>
                                                <td class="tblBody text-center tblFooter tblBodyNumber">
                                                    ${valor.totalVisitasNoEncontradas} 
                                                </td>
                                                <td class="tblBody text-center tblFooter tblBodyNumber">
                                                    ${valor.porcentajeTotalEncontradas} %
                                                </td>
                                                <td class="tblBody text-center tblFooter tblBodyNumber">
                                                    ${valor.porcentajeTotalNoEncontradas} %
                                                </td>
                                            `;
                                            
                            //Agrega el HTML de la tabla 
                            contenedorGeofinderGeneral.appendChild(row);
                        }
                            
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
        }
        
        function cargarDatosGeoreferenciacion(){
            let lblMesVisita=document.getElementById("lblMesVisita").value;  
            let data = {lblMesVisita: lblMesVisita};
            
            fetch('./ajax/dataDashboardGeo.php', {method: 'POST', body: JSON.stringify(data)})
                .then(function(res) {
                    return res.json();
                })
                .then(function(datos) {
                    
                    console.log(datos);
                    
                    for (let [llave, valor] of Object.entries(datos)){
                        
                        console.log(valor.Totales.TotalVisitasGeoCC);
                        
                        const row = document.createElement('tr');
                        //row.style = "height:1vw!important";

                            row.style = "height:1vw!important;cursor: pointer;";
                            row.setAttribute("data-toggle", "collapse");
                            row.setAttribute("data-target", "."+valor.Id); //DEFINIR LA FILA QUE SE MOSTRARA
                            row.setAttribute("class", "Visitas"); //DEFINIR LA CLASE QUE SE ENCUENTRA
                        
                        row.innerHTML = `
                                            <td class="text-left">
                                                ${valor.Id} 
                                            </td>
                                            <td class=" text-center">
                                                ${valor.Totales.TotalVisitas} 
                                            </td>
                                            <td class=" text-center">
                                                ${valor.Totales.TotalVisitasGeo} 
                                            </td>
                                            <td class=" text-center">
                                                ${valor.Totales.TotalVisitasGeoCC} 
                                            </td>
                                            <td class=" text-center">
                                                ${valor.Totales.PorcVistasGeo} 
                                            </td>
                                            <td class=" text-center">
                                                ${valor.Totales.PorcVistasGeoCC} 
                                            </td>
                                            <td class=" text-center">
                                                ${valor.Totales.PorcVistasGeoExacta} 
                                            </td>
                                            <td class=" text-center">
                                                ${valor.Totales.PorcVistasGeoAproximada} 
                                            </td>
                                            <td class=" text-center">
                                                ${valor.Totales.PorcCheckINAutomatico} 
                                            </td>
                                            <td class=" text-center">
                                                ${valor.Totales.PorcCheckINManual} 
                                            </td>
                                            <td class=" text-center">
                                                ${valor.Totales.PorcCheckINFueraFecha} 
                                            </td>
                                        `;
                        //Agrega el HTML de la tabla 
                        contenedorGeoreferenciacion.appendChild(row);
                        
                        let Distritos = valor.Distritos;
                        
                        Distritos.forEach(element => {
                            
                            const rowDist = document.createElement('tr');
                            rowDist.style = "height:1vw!important; background-color: #e2e2e2";
                            rowDist.setAttribute("class", ""+valor.Id+" collapse sizetr"); //DEFINIR LA CLASE QUE SE ENCUENTRA
                        
                            rowDist.innerHTML = `
                                                <td class="text-left">
                                                    ${element.Distrito} 
                                                </td>
                                                <td class=" text-center">
                                                    ${element.TotalVisitas} 
                                                </td>
                                                <td class=" text-center">
                                                    ${element.TotalVisitasGeo} 
                                                </td>
                                                <td class=" text-center">
                                                    ${element.TotalVisitasGeoCC} 
                                                </td>
                                                <td class=" text-center">
                                                    ${element.PorcVisitasGeo} 
                                                </td>
                                                <td class=" text-center">
                                                    ${element.PorcVisitasGeoCC} 
                                                </td>
                                                <td class=" text-center">
                                                    ${element.PorcVisitasGeoExacta} 
                                                </td>
                                                <td class=" text-center">
                                                    ${element.PorcVisitasGeoAprox} 
                                                </td>
                                                <td class=" text-center">
                                                    ${element.PorcCheckInAutomatico}  
                                                </td>
                                                <td class=" text-center">
                                                    ${element.PorcCheckInManual} 
                                                </td>
                                                <td class=" text-center">
                                                    ${element.PorcCheckInFueraFecha}  
                                                </td>
                                            `;
                                            
                            contenedorGeoreferenciacion.appendChild(rowDist);
                        });
                            
                    }
                })
        }
        
        function cargarDatosGeoOperador(){
            let lblMesVisita=document.getElementById("lblMesVisita").value;  
            let data = {lblMesVisita: lblMesVisita};
            
            fetch('./ajax/dataDashboardGeoOperador.php', {method: 'POST', body: JSON.stringify(data)})
                .then(function(res) {
                    return res.json();
                })
                .then(function(datos) {
                    console.log(datos);
                    
                    for (let [llave, valor] of Object.entries(datos)){
                        const row = document.createElement('tr');
                        
                        row.innerHTML = `
                                            <td class="text-left">
                                                ${valor.NombreCompleto} 
                                            </td>
                                            <td class="text-left">
                                                ${valor.Visitas} 
                                            </td>
                                            <td class="text-left">
                                                ${valor.EnLinea} 
                                            </td>
                                            <td class="text-left">
                                                ${valor.FueraLlamada} 
                                            </td>
                                        `;
                        //Agrega el HTML de la tabla 
                        contenedorGeoOperador.appendChild(row);
                        
                    }
                })
        }
    </script>
    
</body>
</html>