<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
    }

    date_default_timezone_set('America/Lima');
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date)
    {
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date)
    {
        return date('Y-m-d', strtotime($date));
    }
    
    include 'config/db.php';
    include 'config/conexion.php';

    $fechadiahoy=date("M-Y");
    /*
    $fechames="May-2018";
    $fechconvercion=date('Y-m-d', strtotime($fechadiahoy));

    $dias=date("d");
    $mes=date("m");
    $ano=date("Y");
    */
    
?>

<!DOCTYPE html>
<html lang="en">
<head><meta charset="gb18030">
    
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verisure | VeriSmart</title>

    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" />
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
            folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">  
    <!-- Date Picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
    <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
    <!-- Alertifyjs -->
    <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <!--Hoja de estilos de la pagina dashboard visita *No usuar stilos en la misma pagina-->
    <link rel="stylesheet" href="css/dashboardvisita.css">
    
    <link rel="stylesheet" href="admin/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
    
</head>
<body class="skin-red sidebar-mini sidebar-collapse">
    <div id="divLoading" style="display: none;">
        <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
        </div>
    </div>
    <div class="wrapper">
        <!-- Header -->
        <?php include 'admin/header.php'; ?>
        <!-- Left side column. contains the logo and sidebar -->
        <?php
            $inicio = "active";
            include 'admin/main-sidebar.php';
        ?>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div style="font-size:180%;"> DASHBOARD&nbsp <span style="font-size:80%;color:#DAD8D4"> | &nbsp <span style="font-size:80%;color:#8D8A80">TELEVENTA</span></span> </div>              
            </section>
            <!-- Main content -->
            <section class="content">
                <div class="box box-danger">
                    <div class="box-header"> 
                        <i class="fa fa-bar-chart-o"></i> 
                        <h3 class="box-title">TELEVENTA - ASI VAMOS TV| <input type="text" style="font-size:100%;color:#444; background-color: #fff;border: 0;"  id="lblmesvisit" name="lblmesvisita"></h3>
                        
                        <button style="color:white;float:right;" id="btnNuevo" class="btn btn-sm btn-warning nueva_data" title="Nuevo"><i class="fa fa-plus"></i></button>
                    </div>
                    
                    <div class="box-body" id="contenido">
                        <table class="table table-hover" id="televenta" >
                            <thead>
                                <tr>
                                    <th class="tblSubHeader ">GESTORES</th>
                                    <th class="tblSubHeader text-center">FACTURADAS</th>
                                    <th class="tblSubHeader text-center">INSTALADAS</th>
                                    <th class="tblSubHeader text-center">AGENDADAS</th>
                                    <th class="tblSubHeader text-center">PEN. AGENDA</th>
                                    <th class="tblSubHeader text-center">INCIDENCIAS</th>
                                    <th class="tblSubHeader text-center">VENTAS BRUTAS</th>
                                    <th class="tblSubHeader text-center">OBJETIVO VENTAS</th>
                                    <th class="tblSubHeader text-center">XMOR/XVEN</th>
                                    <th class="tblSubHeader text-center">VENTAS NETAS</th>
                                    <th class="tblSubHeader text-center">% de CUMPL.</th>
                                </tr>
                            </thead>
                            <tbody>
                                
                            </tbody>
                        </table>
                        <br>
                        <table class="table table-hover" id="televentaPrecios" >
                            <thead>
                                <tr>
                                    <th class="tblSubHeader">GESTORES</th>
                                    <th class="tblSubHeader text-center">PProm.Venta</th>
                                    <th class="tblSubHeader text-center">Disp. Extras</th>
                                    <th class="tblSubHeader text-center">PVenta + Extras</th>
                                    <th class="tblSubHeader text-center">Disp. Regalo</th>
                                    <th class="tblSubHeader text-center">3 Meses Regalo x Q</th>
                                    <th class="tblSubHeader text-center">%Vta. Regalo</th>
                                </tr>
                            </thead>
                            <tbody>
                                
                            </tbody>
                        </table>
                        <br>
                        <!--
                        <div class="row" id="graficasTV">
                            <div class="col-md-4">
                                <div class="box box-danger">
                                    <div class="box-body">
                                        <div id="Segmento" style="height: 320px;"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="box box-default">
                                    <div class="box-body">
                                        <div id="" style="height: 320px;"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="box box-danger">
                                    <div class="box-body">
                                        <div id="TipoKit" style="height: 320px;"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        -->
                        <div class="row" id="graficasTV">
                            <div class="col-md-4">
                                <div class="nav-tabs-custom" style="cursor: move;">
                                        <!-- Tabs within a box -->
                                        <ul class="nav nav-tabs pull-right ui-sortable-handle">
                                            <li class="">
                                              <a href="#Segmento-telecierre" data-toggle="tab" aria-expanded="false">Telecierre</a>
                                            </li>
                                            <li class="active">
                                                <a href="#Segmento-televenta" data-toggle="tab" aria-expanded="true">Televenta</a>
                                            </li>
                                            <li class="pull-left header"><i class="fa fa-inbox"></i> Segmento</li>
                                        </ul>
                                        <div class="tab-content no-padding">
                                            <div class="chart tab-pane active" id="Segmento-televenta" style="position: relative; height: 300px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0);">
                                                <div id="SegmentoTV" style="height: 320px;"></div>
                                            </div>
                                            <div class="chart tab-pane" id="Segmento-telecierre" style="position: relative; height: 300px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0);">
                                                <div id="SegmentoTC" style="height: 320px;"></div>
                                            </div>
                                        </div>
                                </div>    
                            </div>
                            <div class="col-md-4">
                                <div class="nav-tabs-custom" style="cursor: move;">
                                        <!-- Tabs within a box -->
                                        <ul class="nav nav-tabs pull-right ui-sortable-handle">
                                            <li class="">
                                              <a href="#Scoring-telecierre" data-toggle="tab" aria-expanded="false">Telecierre</a>
                                            </li>
                                            <li class="active">
                                                <a href="#Scoring-televenta" data-toggle="tab" aria-expanded="true">Televenta</a>
                                            </li>
                                            <li class="pull-left header"><i class="fa fa-inbox"></i> Scoring</li>
                                        </ul>
                                        <div class="tab-content no-padding">
                                            <div class="chart tab-pane active" id="Scoring-televenta" style="position: relative; height: 450px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0);">
                                                <div id="scoringTV" style="height: 400px;"></div>
                                            </div>
                                            <div class="chart tab-pane" id="Scoring-telecierre" style="position: relative; height: 450px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0);">
                                                <div id="ScoringTC" style="height: 400px;"></div>
                                            </div>                    
                                        </div>
                                </div>    
                            </div>
                            <div class="col-md-4">
                                <div class="nav-tabs-custom" style="cursor: move;">
                                        <!-- Tabs within a box -->
                                        <ul class="nav nav-tabs pull-right ui-sortable-handle">
                                            <li class="">
                                              <a href="#TipoKit-telecierre" data-toggle="tab" aria-expanded="false">Telecierre</a>
                                            </li>
                                            <li class="active">
                                                <a href="#TipoKit-televenta" data-toggle="tab" aria-expanded="true">Televenta</a>
                                            </li>
                                            <li class="pull-left header"><i class="fa fa-inbox"></i> Tipo Kit</li>
                                        </ul>
                                        <div class="tab-content no-padding"> 
                                            <div class="chart tab-pane active" id="TipoKit-televenta" style="position: relative; height: 450px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0);">
                                                <div id="TipoKitTV" style="height: 400px;"></div>
                                            </div>
                                            <div class="chart tab-pane" id="TipoKit-telecierre" style="position: relative; height: 450px; -webkit-tap-highlight-color: rgba(0, 0, 0, 0);">
                                                <div id="TipoKitTC" style="height: 400px;"></div>
                                            </div>
                                        </div>
                                </div>    
                            </div>
                            
                        </div>
                        
                        <div class="box ocultar" id="boxSinResultados">
                            <div class="box-header"></div>
                            <div class="box-body">
                                <h1>Por favor, generar los datos del mes comercial actual para visualizar el dashboard.</h1>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /. box -->
            </section>
            <?php include 'modalpassword.php';?>
        </div>
        
        <div class="modal fade" id="add_data_Modal">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header modal-header-danger">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        <h4>GENERAR DATOS DEL DASHBOARD</h4>
                    </div>
                    <div class="modal-body">
                        <div class="box box-solid" style="box-shadow: none;">
                            <form>
                                <div class="box-body">
                                    <div class="row">
                                        <div class="col-md-2"></div>
                                        <div class="col-md-8">
                                            <div class="form-group">
                                              <label for="lbln590" class="col-sm-2 control-label">N590</label>
                            
                                              <div class="col-sm-10">
                                                    <input type="text" class="form-control" id="lbln590" name="lbln590" disabled>
                                              </div>
                                            </div>
                                        </div>
                                        <div class="col-md-2"></div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-2"></div>
                                        <div class="col-md-8">
                                            <div class="form-group">
                                              <label for="gestor" class="col-sm-2 control-label">Gestor</label>
                            
                                              <div class="col-sm-10">
                                                    <select class="form-control select2" id="gestor" name="gestor" style="width: 100%">
                                                        <option value="" disabled selected>--Seleccione--</option>
                                                        <?php 
                                                        $sql = "SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Gestor FROM yifi58ge_dbUSUARIO.tblusuario u
                                                                INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea
                                                                WHERE (a.IdArea='40' OR a.IdArea='17') AND (u.IdPerfil=36 OR u.IdPerfil=12 OR IdPerfil=35) and u.Estado='Activo'";
                                                        $resultado = $con->query($sql);
                                                        while($gestor = $resultado->fetch_assoc()){
                                                        ?>
                                                        <option value="<?php echo $gestor['Matricula']; ?>"><?php echo $gestor['Gestor'] ?></option>
                                                        <?php } ?>
                                                    </select>
                                              </div>
                                            </div>
                                        </div>
                                        <div class="col-md-2"></div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                              <label for="objetivo" class="col-sm-4 control-label">Objetivo</label>
                            
                                              <div class="col-sm-8">
                                                    <input type="number" class="form-control" id="objetivo" name="objetivo" value="0" style="width: 100%" min=0>
                                              </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                              <label for="xmor" class="col-sm-4 control-label" style="text-align: left">Xmor/Xven</label>
                            
                                              <div class="col-sm-8">
                                                    <input type="number" class="form-control" id="xmor" name="xmor" value="0" style="width: 100%" min=0>
                                              </div>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <button class="btn btn-danger pull-right" id="btnAgregar" name="btnAgregar"><i class="fa fa-plus"></i>&nbsp Agregar </button>
                                        </div>
                                    </div>
                                        
                                    <br>
                                    <div class="row">
                                        <div class="col-md-2"></div>
                                        <div class="col-md-8">
                                            <table class="table table-hover" id="tbdatos">
                                                <thead>
                                                    <tr>
                                                        <th>Gestor</th>
                                                        <th>Objetivo</th>
                                                        <th>Xven/Xmor</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                </tbody>
                                            </table>
                                        </div>
                                        
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" id="Cerrarmodal" data-dismiss="modal">Cerrar</button>
                        <input type="submit" name="insert" id="insert" value="Registrar" class="btn btn-danger" disabled>
                    </div>   
                </div>
                
            </div>
        </div>
    </div>
    <!-- jQuery 3 -->
    <script src="admin/bower_components/jquery/dist/jquery.min.js"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <!-- Bootstrap 3.3.7 -->
    <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- datepicker -->
    <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
    <!-- Bootstrap WYSIHTML5 -->
    <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
    <!-- Slimscroll -->
    <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <!-- FastClick -->
    <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
    <!-- AdminLTE App -->
    <script src="admin/dist/js/adminlte.min.js"></script>
    <!-- Chart loarder -->
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    
    <script src="admin/bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="admin/bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
    
    <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
    
    <script src="admin/bower_components/highcharts/highstock.js"></script>
    <script src="admin/bower_components/highcharts/maps.js"></script>
    <script src="admin/bower_components/highcharts/pe-all.js"></script>
    
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <!-- DOCUMENT READY -->
    <script>
        $(document).ready(function () {
            
            $('#lblmesvisit').datepicker({
                autoclose: true,
                language: 'en',
                firstDay: 1, format: 'M-yyyy',
                viewMode: "years",
                minViewMode: "months"
            }).datepicker("setDate", new Date());
        
            $('#lbln590').datepicker({
                autoclose: true,
                language: 'en',
                firstDay: 1, format: 'M-yyyy',
                viewMode: "years",
                minViewMode: "months"
            
            }).datepicker("setDate", new Date());
            
            $('.select2').select2()
            
            cargarDatosBaseMesComercial();
            
        });
    </script>
    <!-- FUNCIONES -->
    <script>
        const contenedor = document.querySelector('#televenta tbody');
        const cotenedorPrecios = document.querySelector('#televentaPrecios tbody');
        
        const botonModal = document.querySelector('#btnNuevo');
        const botonAgregarDatos = document.querySelector('#btnAgregar');
        const contenedorNuevosDatos = document.querySelector('#tbdatos tbody');
        const mes = document.querySelector("#lblmesvisit");
        
        const contenido = document.querySelector('#contenido');
        
        let arregloDatos = [];

        function cargarDatos() {
            let mesvisita = mes.value;
            data = {mesvisita: mesvisita};
            
            fetch('./ajax/dataDashboardTeleventa.php', {method: 'POST', body: JSON.stringify(data)})
                .then(function(res) {
                    return res.json();
                })
                .then(function(datos) {
                    console.log(datos);
                    if(datos.Resultado == 'SinGenerar'){
                        
                        $('#televenta').addClass('ocultar');
                        $('#televentaPrecios').addClass('ocultar');
                        $('#graficasTV').addClass('ocultar');
                        
                        $('#boxSinResultados').removeClass('ocultar');
                        
                    } else {
                        $('#televenta').removeClass('ocultar');
                        $('#televentaPrecios').removeClass('ocultar');
                        $('#graficasTV').removeClass('ocultar');
                        
                        $('#boxSinResultados').addClass('ocultar');
                
                        for (let [llave, valor] of Object.entries(datos)){
                            //console.log(llave);
                            
                            if(llave == 'Segmento'){
                                segmentoTV(datos['Segmento']);
                                segmentoTC(datos['Segmento']);
                            } 
                            else if(llave == 'Scoring'){
                                scoringTV(datos['Scoring']);
                                scoringTC(datos['Scoring']);
                            }
                            else if(llave == 'TipoKit'){
                                tipoKitTV(datos['TipoKit']);
                                tipoKitTC(datos['TipoKit']);
                            }
                            else {
                                if(llave == '511'){
                                    
                                    for(let [llave511, valor511] of Object.entries(valor)){
                                        
                                            const row511 = document.createElement('tr');
                                            row511.style = "height:1vw!important";
                                            
                                            if(llave511 != 'Totales511'){
                                            
                                                row511.innerHTML = `
                                                    <td class="text-left ${valor511.Estado}">
                                                        ${valor511['Gestor']}
                                                    </td>
                                                    <td class=" text-center">
                                                        ${valor511.Facturadas}
                                                    </td>
                                                    <td class=" text-center">
                                                        ${valor511.Instaladas}
                                                    </td>
                                                    <td class=" text-center">
                                                        ${valor511.Agendadas}
                                                    </td>
                                                    <td class=" text-center">
                                                        ${valor511.PenAgenda}
                                                    </td>
                                                    <td class=" text-center">
                                                        ${valor511.Incidencia}
                                                    </td>
                                                    <td class=" text-center" style="background-color: #332e2f; color: white">
                                                            ${valor511.VentasBrutas}
                                                    </td>
                                                    <td class=" text-center">
                                                            ${valor511.Objetivo}
                                                    </td>
                                                    <td class=" text-center">
                                                            ${valor511.XmorXven}
                                                    </td>
                                                    <td class=" text-center" style="background-color: #332e2f; color: white">
                                                            ${valor511.VentasNetas}
                                                    </td>
                                                    <td class=" text-center">
                                                            ${valor511.Cumplimiento} %
                                                    </td>
                                                `;
                                                
                                                contenedor.appendChild(row511); 
                                                
                                                let cumplimiento = parseFloat(valor511.Cumplimiento);
                                                row511.lastElementChild.style.color = 'white';
                                                switch(true){
                                                    case cumplimiento >= 40:
                                                        row511.lastElementChild.style.background = 'green';
                                                        break;
                                                    case cumplimiento >= 20 && cumplimiento < 40:
                                                        row511.lastElementChild.style.background = '#FFC300';
                                                        break;
                                                    default:
                                                        row511.lastElementChild.style.background = '#e4002b';
                                                        break;
                                                }
                                                
                                                const rowPrecio = document.createElement('tr');
                                                rowPrecio.style = "height:1vw!important";
                                                
                                                rowPrecio.innerHTML =   `
                                                            <td class=" text-left ${valor511.Estado}">
                                                                ${valor511.Gestor}
                                                            </td>
                                                            <td class=" text-center">
                                                                S/. ${valor511.PromedioVenta}
                                                            </td>
                                                            <td class=" text-center">
                                                                ${valor511.CantidadExtra}
                                                            </td>
                                                            <td class=" text-center">
                                                                S/. ${valor511.PromedioVentaExtras}
                                                            </td>
                                                            <td class=" text-center">
                                                                ${valor511.CantidadRegalo}
                                                            </td>
                                                            <td class=" text-center">
                                                                ${valor511.CantidadMesesDescuento}
                                                            </td>
                                                            <td class=" text-center">
                                                                ${valor511.VentaRegalo} %
                                                            </td>
                                                            `
                                                    
                                                cotenedorPrecios.appendChild(rowPrecio);
                                            }
                                            else {
                                                const row = document.createElement('tr');
                                                row.style = "height:1vw!important";
                                                row.innerHTML = `
                                                        <td class=" text-left tblBody ">
                                                            TELECIERRE (511)
                                                        </td>
                                                        <td class="text-center tblBody ">
                                                            ${valor511.totalfacturadas}
                                                        </td>
                                                        <td class=" text-center tblBody ">
                                                            ${valor511.totalinstaldas}
                                                        </td>
                                                        <td class=" text-center tblBody ">
                                                            ${valor511.totalagendadas}
                                                        </td>
                                                        <td class=" text-center tblBody ">
                                                            ${valor511.totalpendienteagenda}
                                                        </td>
                                                        <td class=" text-center tblBody ">
                                                            ${valor511.totalincidencia}
                                                        </td>
                                                        <td class=" text-center tblBody ">
                                                                ${valor511.totalventasbrutas}
                                                        </td>
                                                        <td class=" text-center tblBody ">
                                                                ${valor511.totalobjetivo}
                                                        </td>
                                                        <td class=" text-center tblBody ">
                                                                ${valor511.totalxmorxven}
                                                        </td>
                                                        <td class=" text-center tblBody ">
                                                                ${valor511.totalventasnetas}
                                                        </td>
                                                        <td class=" text-center">
                                                               
                                                        </td>
                                                    `;
                                                    contenedor.appendChild(row); 
                                                    
                                                    const rowPrecio = document.createElement('tr');
                                                    rowPrecio.style = "height:1vw!important";
                                                    
                                                    rowPrecio.innerHTML =   `
                                                            <td class=" text-left tblBody">
                                                                TELECIERRE (511)
                                                            </td>
                                                            <td class=" text-center tblBody">
                                                                S/.${valor511.totalPromVentas}
                                                            </td>
                                                            <td class=" text-center tblBody">
                                                                ${valor511.totalDispExtras}
                                                            </td>
                                                            <td class=" text-center tblBody">
                                                                S/.${valor511.totalPromVentasExtras}
                                                            </td>
                                                            <td class=" text-center tblBody">
                                                                ${valor511.totalRegalos}
                                                            </td>
                                                            <td class=" text-center tblBody">
                                                                ${valor511.TotalDescuento}
                                                            </td>
                                                            <td class=" text-center tblBody">
                                                            </td>
                                                            `
                                    
                                                    cotenedorPrecios.appendChild(rowPrecio);
                                            }
                                        }
                                        
                                }
                                if(llave == '512'){
                                    
                                    for(let [llave512, valor512] of Object.entries(valor)){
                                            const row512 = document.createElement('tr');
                                            row512.style = "height:1vw!important";
                                            
                                        if(llave512 != 'Totales512'){
                                            row512.innerHTML = `
                                                <td class=" text-left ${valor512.Estado}">
                                                    ${valor512['Gestor']}
                                                </td>
                                                <td class=" text-center">
                                                    ${valor512.Facturadas}
                                                </td>
                                                <td class=" text-center">
                                                    ${valor512.Instaladas}
                                                </td>
                                                <td class=" text-center">
                                                    ${valor512.Agendadas}
                                                </td>
                                                <td class=" text-center">
                                                    ${valor512.PenAgenda}
                                                </td>
                                                <td class=" text-center">
                                                    ${valor512.Incidencia}
                                                </td>
                                                <td class=" text-center" style="background-color: #332e2f; color: white">
                                                        ${valor512.VentasBrutas}
                                                </td>
                                                <td class=" text-center">
                                                        ${valor512.Objetivo}
                                                </td>
                                                <td class=" text-center">
                                                        ${valor512.XmorXven}
                                                </td>
                                                <td class=" text-center" style="background-color: #332e2f; color: white">
                                                        ${valor512.VentasNetas}
                                                </td>
                                                <td class=" text-center">
                                                        ${valor512.Cumplimiento} %
                                                </td>
                                            `;
                                            
                                            contenedor.appendChild(row512); 
                                            
                                            let cumplimiento = parseFloat(valor512.Cumplimiento);
                                            row512.lastElementChild.style.color = 'white';
                                            switch(true){
                                                case cumplimiento >= 40:
                                                    row512.lastElementChild.style.background = 'green';
                                                    break;
                                                case cumplimiento >= 20 && cumplimiento < 40:
                                                    row512.lastElementChild.style.background = '#FFC300';
                                                    break;
                                                default:
                                                    row512.lastElementChild.style.background = '#e4002b';
                                                    break;
                                            }
                                            
                                                const rowPrecio = document.createElement('tr');
                                                rowPrecio.style = "height:1vw!important";
                                                
                                                rowPrecio.innerHTML =   `
                                                            <td class=" text-left ${valor512.Estado}">
                                                                ${valor512.Gestor}
                                                            </td>
                                                            <td class=" text-center">
                                                                S/. ${valor512.PromedioVenta}
                                                            </td>
                                                            <td class=" text-center">
                                                                ${valor512.CantidadExtra}
                                                            </td>
                                                            <td class=" text-center">
                                                                S/. ${valor512.PromedioVentaExtras}
                                                            </td>
                                                            <td class=" text-center">
                                                                ${valor512.CantidadRegalo}
                                                            </td>
                                                            <td class=" text-center">
                                                                ${valor512.CantidadMesesDescuento}
                                                            </td>
                                                            <td class=" text-center">
                                                                ${valor512.VentaRegalo} %
                                                            </td>
                                                            `
                                                    
                                                cotenedorPrecios.appendChild(rowPrecio);                                        
                                        }
                                        else {
                                            const row = document.createElement('tr');
                                            row.style = "height:1vw!important";
                                            row.innerHTML = `
                                                    <td class=" text-left tblBody">
                                                        TELEVENTA (512)
                                                    </td>
                                                    <td class="text-center tblBody">
                                                        ${valor512.totalfacturadas}
                                                    </td>
                                                    <td class=" text-center tblBody">
                                                        ${valor512.totalinstaldas}
                                                    </td>
                                                    <td class=" text-center tblBody">
                                                        ${valor512.totalagendadas}
                                                    </td>
                                                    <td class=" text-center tblBody">
                                                        ${valor512.totalpendienteagenda}
                                                    </td>
                                                    <td class=" text-center tblBody">
                                                        ${valor512.totalincidencia}
                                                    </td>
                                                    <td class=" text-center tblBody">
                                                            ${valor512.totalventasbrutas}
                                                    </td>
                                                    <td class=" text-center tblBody">
                                                            ${valor512.totalobjetivo}
                                                    </td>
                                                    <td class=" text-center tblBody">
                                                            ${valor512.totalxmorxven}
                                                    </td>
                                                    <td class=" text-center tblBody">
                                                            ${valor512.totalventasnetas}
                                                    </td>
                                                    <td class=" text-center">
                                                           
                                                    </td>
                                                `;
                                                contenedor.appendChild(row);
                                                
                                                    const rowPrecio = document.createElement('tr');
                                                    rowPrecio.style = "height:1vw!important";
                                                    
                                                    rowPrecio.innerHTML =   `
                                                            <td class=" text-left tblBody">
                                                                TELEVENTA (512)
                                                            </td>
                                                            <td class=" text-center tblBody">
                                                                S/.${valor512.totalPromVentas}
                                                            </td>
                                                            <td class=" text-center tblBody">
                                                                ${valor512.totalDispExtras}
                                                            </td>
                                                            <td class=" text-center tblBody">
                                                                S/.${valor512.totalPromVentasExtras}
                                                            </td>
                                                            <td class=" text-center tblBody">
                                                                ${valor512.totalRegalos}
                                                            </td>
                                                            <td class=" text-center tblBody">
                                                                ${valor512.TotalDescuento}
                                                            </td>
                                                            <td class=" text-center tblBody">
                                                            </td>
                                                            `
                                    
                                                    cotenedorPrecios.appendChild(rowPrecio);                                            
                                        }
                                    }
                                        
                                }
                                if(llave == 'Totales'){
                                    const row = document.createElement('tr');
                                    row.style = "height:1vw!important";
                                    row.innerHTML = `
                                                        <td class=" text-left bg-footer ">
                                                            TOTALES (511 Y 512)
                                                        </td>
                                                        <td class=" text-center bg-footer ">
                                                            ${valor.totalfacturadas}
                                                        </td>
                                                        <td class=" text-center bg-footer ">
                                                            ${valor.totalinstaldas}
                                                        </td>
                                                        <td class=" text-center bg-footer ">
                                                            ${valor.totalagendadas}
                                                        </td>
                                                        <td class=" text-center bg-footer ">
                                                            ${valor.totalpendienteagenda}
                                                        </td>
                                                        <td class=" text-center bg-footer ">
                                                            ${valor.totalincidencia}
                                                        </td>
                                                        <td class=" text-center bg-footer ">
                                                                ${valor.totalventasbrutas}
                                                        </td>
                                                        <td class=" text-center bg-footer ">
                                                                ${valor.totalobjetivo}
                                                        </td>
                                                        <td class=" text-center bg-footer ">
                                                                ${valor.totalxmorxven}
                                                        </td>
                                                        <td class=" text-center bg-footer ">
                                                                ${valor.totalventasnetas}
                                                        </td>
                                                        <td class=" text-center">
                                                               
                                                        </td>
                                                    `;
                                    contenedor.appendChild(row);
                                    
                                    const rowPrecio = document.createElement('tr');
                                    rowPrecio.style = "height:1vw!important";
                                    rowPrecio.innerHTML =   `
                                                            <td class=" text-left bg-footer">
                                                                TOTALES (511 Y 512)
                                                            </td>
                                                            <td class=" text-center bg-footer">
                                                                S/.${valor.totalPromVentas}
                                                            </td>
                                                            <td class=" text-center bg-footer">
                                                                ${valor.totalDispExtras}
                                                            </td>
                                                            <td class=" text-center bg-footer">
                                                                S/.${valor.totalPromVentasExtras}
                                                            </td>
                                                            <td class=" text-center bg-footer">
                                                                ${valor.totalRegalos}
                                                            </td>
                                                            <td class=" text-center bg-footer">
                                                                ${valor.TotalDescuento}
                                                            </td>
                                                            <td class=" text-center bg-footer">
                                                            </td>
                                                            `
                                    
                                    cotenedorPrecios.appendChild(rowPrecio);
                                }
                                
                                const rowPrecio = document.createElement('tr');
                                rowPrecio.style = "height:1vw!important";
                                
                            }
                                        
                        
                        }
                    }
                    
                })
                .catch(function(error) {
                    console.log(error);
                })
        }
        
        function datosHTML(){
            limpiarHTML(contenedorNuevosDatos);
            
            arregloDatos.forEach(datos => {
                const {matricula, gestor, objetivo, xmorxven} =  datos;
                const row = document.createElement('tr');
                row.innerHTML = `
                                    <td>${gestor}</td>
                                    <td>${objetivo}</td>
                                    <td>${xmorxven}</td>
                                    <td><a href="#" class="borrar-gestor" data-id="${matricula}" text-id="${gestor}">X</a></td>
                                `   
                contenedorNuevosDatos.appendChild(row);
                
            })
            
        }
        //Elimina los cursos del tbody
        function limpiarHTML(cont) {
            //forma recomendada
            while (cont.firstChild) {
                cont.removeChild(cont.firstChild);
            }
        }
        
        function validarDatos(){
            const gestor = $('#gestor option:selected');
            const objetivo = $('#objetivo');
            const xmor = $('#xmor');
            if(gestor.val() == ''){
                alert('Seleccione Gestor');
                return false;
            }
            if(objetivo.val() == ''){
                alert('Indique el objetivo del mes');
                return false;
            }
            if(xmor.val() == ''){
                alert('Indique el Xmor/Xven');
                return false;
            }
            return true;
        }
        //DATOS DEL MES COMERCIAL
        function cargarDatosBaseMesComercial(){
            let n590 = mes.value;
            data = {n590: n590};
            
            fetch('./ajax/selectListarDashboardTV.php', {method: 'POST', body: JSON.stringify(data)})
                .then(function(res) {
                    return res.json();
                })
                .then(function(datos) {
                    //console.log(datos);
                })
                .catch(function(error) {
                    console.log(error);
                })
        }
        
    </script>
    <!-- ACCIONES -->
    <script>
        $("#lblmesvisit").on("change", function(e){
            
            $('#divLoading').show();
            limpiarHTML(contenedor);
            cargarDatos();
            setTimeout(() => {
                
                $('#divLoading').hide();
                
            } , 2000);
        });
        
        $('#btnNuevo').on("click", function(){
            $('#add_data_Modal').modal('show');
        })
        
        $('#btnAgregar').on("click", function(e){
            e.preventDefault();
            
            const gestor = $('#gestor option:selected');
            const objetivo = $('#objetivo');
            const xmor = $('#xmor');
            
            if(validarDatos()){
                
                const datos = {
                    matricula: gestor.val(),
                    gestor: gestor.text(),
                    objetivo: objetivo.val(),
                    xmorxven: xmor.val()
                }
            
                arregloDatos = [...arregloDatos, datos];
                
                datosHTML();
                
                gestor.remove();
                objetivo.val('');
                xmor.val(0);
                
                objetivo.focus();
            }
            
            if($('#gestor')[0].length == 1){
                
                $('#gestor').prop('disabled', true);
                objetivo.prop('disabled',true);
                xmor.prop('disabled',true);
                $('#btnAgregar').addClass('ocultar');
                $('#btnAgregar').prop('disabled', true);
                $('#insert').prop('disabled', false);
            }
            
        })
        
        $('#tbdatos').on("click", function(e){
            e.preventDefault();
            
            if (e.target.classList.contains('borrar-gestor')) {
                const matricula = e.target.getAttribute('data-id');
                const gestor = e.target.getAttribute('text-id');
        
                //Elimina del arreglo de articulosCarrito por el data-id
                arregloDatos = arregloDatos.filter(datos => datos.matricula !== matricula);
                
                datosHTML();
                
                $('#gestor').append(`<option value="${matricula}">${gestor}</option>`);
                
            }
        })
        
        $('#insert').on("click", function(e){
            e.preventDefault();
            
            
            let mesvisita = mes.value;
            
            let datos = {datos: arregloDatos, mesvisita: mesvisita};
            $.ajax({
                type: 'POST',
                url: 'ajax/insertDataDashboardTV.php',
                data: datos,
                dataType: "Json",
                success: function (data) {
                    if(data.respuesta == 'exito'){
                        arregloDatos = [];
                        
                        limpiarHTML(contenedorNuevosDatos);
                        $('#add_data_Modal').modal('hide');
                        
                        Swal.fire(
                          'Registrado',
                          'Se registró la información correctamente',
                          'success'
                        )
                        
                        
                    }
                }
            })

        })
    </script>
    <!-- GOOGLE CHARTS -->
    <script>
        function segmentoTV(data) {
                
            let neg, res;
            let totalProspectos = 0;
            
            data.forEach(objeto=>{
                const {CC, Segmento, Total} = objeto;
                
                if(CC === '512'){
                    if(Segmento === 'RES'){
                        res = parseInt(Total);

                        totalProspectos += res;
                    } else if(Segmento === 'NEG'){
                        neg = parseInt(Total);
                        totalProspectos += neg;
                    } 
                }
            })

            Highcharts.chart('SegmentoTV', {
                chart: {
                    plotBackgroundColor: null,
                    plotBorderWidth: null,
                    plotShadow: false,
                    type: 'pie'
                },
                title: {
                    text: 'SegmentoTV'
                },
                tooltip: {
                    pointFormat: '{point.y}'
                },
                plotOptions: {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        dataLabels: {
                            enabled: true,
                            formatter: function () {
                                var cant = this.y;
                                if (totalProspectos > 0) {
                                    var porcentaje = (cant/totalProspectos)*100;
                                    var porcentaje = porcentaje.toFixed(2);
                                    return '<b>'+porcentaje+'%</b>';
                                }
                            }
                        },
                        showInLegend: true
                    }
                },
                series: [{name:SegmentoTV, data: [{name: 'Negocio', y: neg, color: '#e4002b' },{name: 'Residencial', y: res}]}]
            });
        }
            
        function segmentoTC(data) {
            
            let neg, res;
            let totalProspectos = 0;
            
            data.forEach(objeto=>{
                const {CC, Segmento, Total} = objeto;
                
                if(CC === '511'){
                    if(Segmento === 'RES'){
                        res = parseInt(Total);
                        totalProspectos += res;
                    } else if(Segmento === 'NEG'){
                        neg = parseInt(Total);
                        totalProspectos += neg;
                    } 
                }
            })
            
            console.log(totalProspectos)
            
            Highcharts.chart('SegmentoTC', {
                chart: {
                    plotBackgroundColor: null,
                    plotBorderWidth: null,
                    plotShadow: false,
                    type: 'pie'
                },
                title: {
                    text: 'SegmentoTC'
                },
                tooltip: {
                    pointFormat: '{point.y}'
                },
                plotOptions: {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        dataLabels: {
                            enabled: true,
                            formatter: function () {
                                var cant = this.y;
                                if (totalProspectos > 0) {
                                    var porcentaje = (cant/totalProspectos)*100;
                                    var porcentaje = porcentaje.toFixed(2);
                                    return '<b>'+porcentaje+'%</b>';
                                }
                            }
                        },
                        showInLegend: true
                    }
                },
                series: [{name:SegmentoTC, data: [{name: 'Negocio', y: neg, color: '#e4002b' },{name: 'Residencial', y: res}]}]
            });
        }
        
        function scoringTV(data){
            
            console.log(data);
            
            let totalProspectos = 0;
            let TotalSuperOferta, TotalOfertaExtraordinaria, TotalOferta, TotalOfertaEspecial = 0;
            
            for(let i=0; i<data.length; i++){
                
                if(data[i]['CC'] == '512'){
                    
                    switch (data[i]['TCScoring']){
                        case 'Oferta':
                            TotalOferta = parseInt(data[i]['Total']);
                            totalProspectos +=TotalOferta;
                            break;
                        case 'SuperOferta':
                            TotalSuperOferta = parseInt(data[i]['Total']);
                            totalProspectos += TotalSuperOferta;
                            break;
                        case 'OfertaExtraordinaria':
                            TotalOfertaExtraordinaria = parseInt(data[i]['Total']);
                            totalProspectos += TotalOfertaExtraordinaria;
                            break;
                        case 'OfertaEspecial':
                            TotalOfertaEspecial = parseInt(data[i]['Total']);
                            totalProspectos += TotalOfertaEspecial;
                            break;
                    }
                        
                }
            }
            
            console.log(TotalSuperOferta);
            console.log(TotalOfertaExtraordinaria);
            console.log(TotalOferta);
            console.log(TotalOfertaEspecial);

            Highcharts.chart('scoringTV', {
                chart: {
                    plotBackgroundColor: null,
                    plotBorderWidth: null,
                    plotShadow: false,
                    type: 'pie'
                },
                title: {
                    text: 'scoringTV'
                },
                tooltip: {
                    pointFormat: '{point.y}'
                },
                plotOptions: {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        dataLabels: {
                            enabled: true,
                            formatter: function () {
                                var cant = this.y;
                                if (totalProspectos > 0) {
                                    var porcentaje = (cant/totalProspectos)*100;
                                    var porcentaje = porcentaje.toFixed(2);
                                    return '<b>'+porcentaje+'%</b>';
                                }
                            }
                        },
                        showInLegend: true
                    }
                },
                series: [{name:scoringTV, data: [{name: 'Super Oferta (B)', y: TotalSuperOferta },{name: 'Oferta Extraordinaria (A)', y: TotalOfertaExtraordinaria}, {name: 'Oferta (C)', y: TotalOferta }, {name: 'Oferta Especial (D)', y: TotalOfertaEspecial }]}]
            });

        }
        
        function scoringTC(data){
            
            //console.log(data);
            
            let totalProspectos = 0;
            let TotalSuperOferta, TotalOfertaExtraordinaria, TotalOferta, TotalOfertaEspecial;
            
            for(let i=0; i<data.length; i++){
                
                if(data[i]['CC'] == '511'){
                    
                    switch (data[i]['TCScoring']){
                        case 'SuperOferta':
                            TotalSuperOferta = parseInt(data[i]['Total']);
                            totalProspectos += TotalSuperOferta;
                            break;
                        case 'OfertaExtraordinaria':
                            TotalOfertaExtraordinaria = parseInt(data[i]['Total']);
                            totalProspectos += TotalOfertaExtraordinaria;
                            break;
                        case 'Oferta':
                            TotalOferta = parseInt(data[i]['Total']);
                            totalProspectos +=TotalOferta;
                            break;
                        case 'OfertaEspecial':
                            TotalOfertaEspecial = parseInt(data[i]['Total']);
                            totalProspectos += TotalOfertaEspecial;
                            break;
                    }
                    
                }
                
                
                
            }

            Highcharts.chart('ScoringTC', {
                chart: {
                    plotBackgroundColor: null,
                    plotBorderWidth: null,
                    plotShadow: false,
                    type: 'pie'
                },
                title: {
                    text: 'ScoringTC'
                },
                tooltip: {
                    pointFormat: '{point.y}'
                },
                plotOptions: {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        dataLabels: {
                            enabled: true,
                            formatter: function () {
                                var cant = this.y;
                                if (totalProspectos > 0) {
                                    var porcentaje = (cant/totalProspectos)*100;
                                    var porcentaje = porcentaje.toFixed(2);
                                    return '<b>'+porcentaje+'%</b>';
                                }
                            }
                        },
                        showInLegend: true
                    }
                },
                series: [{name:ScoringTC, data: [{name: 'Super Oferta (B)', y: TotalSuperOferta },{name: 'Oferta Extraordinaria (A)', y: TotalOfertaExtraordinaria}, {name: 'Oferta (C)', y: TotalOferta }, {name: 'Oferta Especial (D)', y: TotalOfertaEspecial }]}]
            });

        }
        
        function tipoKitTV(data){
            
            console.log(data);
            
            let sindatos, basico, premium, zerovision, totalProspectos = 0;
            
            data.forEach(objeto=>{
                const {CC, TipoKIT, Total} = objeto;
                
                if(CC === '512'){
                    
                    if (TipoKIT === "Basico") {
                        basico = parseInt(Total);
                        totalProspectos += basico;
                    }
                    if (TipoKIT === "Premium"){
                        premium = parseInt(Total);
                        totalProspectos += premium;
                    }
                    if (TipoKIT === "Zerovision"){
                        zerovision = parseInt(Total);
                        totalProspectos += zerovision;
                    }
                    if(TipoKIT == null){
                        sindatos = parseInt(Total);
                        totalProspectos += sindatos;
                    }
                }
            })

            Highcharts.chart('TipoKitTV', {
                chart: {
                    plotBackgroundColor: null,
                    plotBorderWidth: null,
                    plotShadow: false,
                    type: 'pie'
                },
                title: {
                    text: 'TipoKitTV'
                },
                tooltip: {
                    pointFormat: '{point.y}'
                },
                plotOptions: {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        dataLabels: {
                            enabled: true,
                            formatter: function () {
                                var cant = this.y;
                                if (totalProspectos > 0) {
                                    var porcentaje = (cant/totalProspectos)*100;
                                    var porcentaje = porcentaje.toFixed(2);
                                    return '<b>'+porcentaje+'%</b>';
                                }
                            }
                        },
                        showInLegend: true
                    }
                },
                series: [{name:TipoKitTV, data: [{name: 'Premium', y: premium}, {name: 'Basico', y: basico}, {name: 'ZeroVision', y: zerovision}, {name: 'sindatos', y: sindatos}, ]}]
            });

        }
        
        function tipoKitTC(data){
            
            console.log(data);
            
            let sindatos, basico, premium, zerovision, totalProspectos = 0;
            
            
            data.forEach(objeto=>{
                const {CC, TipoKIT, Total} = objeto;
                
                if(CC === '511'){
                    if(TipoKIT == null){
                        sindatos = parseInt(Total);
                        totalProspectos += sindatos;
                    }
                    if (TipoKIT === "Basico") {
                        basico = parseInt(Total);
                        totalProspectos += basico;
                    }
                    if (TipoKIT === "Premium"){
                        premium = parseInt(Total);
                        totalProspectos += premium;
                    }
                    if (TipoKIT === "ZeroVision"){
                        zerovision = parseInt(Total);
                        totalProspectos += zerovision;
                    }
                }
            })
            
            Highcharts.chart('TipoKitTC', {
                chart: {
                    plotBackgroundColor: null,
                    plotBorderWidth: null,
                    plotShadow: false,
                    type: 'pie'
                },
                title: {
                    text: 'TipoKitTC'
                },
                tooltip: {
                    pointFormat: '{point.y}'
                },
                plotOptions: {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        dataLabels: {
                            enabled: true,
                            formatter: function () {
                                var cant = this.y;
                                if (totalProspectos > 0) {
                                    var porcentaje = (cant/totalProspectos)*100;
                                    var porcentaje = porcentaje.toFixed(2);
                                    return '<b>'+porcentaje+'%</b>';
                                }
                            }
                        },
                        showInLegend: true
                    }
                },
                series: [{name:TipoKitTC, data: [{name: 'sindatos', y: sindatos},{name: 'Premium', y: premium}, {name: 'Basico', y: basico}, {name: 'ZeroVision', y: zerovision}]}]
            });

        }
        
            
    </script>
    
</body>
</html>