<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
    }

    date_default_timezone_set('America/Lima');
    
    include 'config/db.php';
    include 'config/conexion.php';

    $fechadiahoy=date("M-Y");
    $fechconvercion=date('Y-m-d', strtotime($fechadiahoy));

    $dias=date("d");
    $mes=date("m");
    $ano=date("Y");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verisure | VeriSmart</title>
    
    <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" />
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
            folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
    <!-- daterange picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-daterangepicker/daterangepicker.css">
    <!-- Date Picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
    <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
    <!-- Alertifyjs -->
    <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <!--Hoja de estilos de la pagina dashboard visita *No usuar stilos en la misma pagina-->
    <link rel="stylesheet" href="css/dashboardvisita.css">
    
    <link rel="stylesheet" href="admin/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
    
    <style>
        .tblSubHeader, .Row__titulo{
            text-transform: uppercase;
        }
        .ocultar{
            display: none;
        }
        
        .bajo{
            background-color: #e4002b;
            color: white;
        }
        
        .medio{
            background-color: orange;
            color: white;
        }
        
        .alto{
            background-color: green;
            color: white;
        }
        
        .tblfooter{
            background-color: gray;
            color: white;
        }
        
        .big{
            width: 20%;
        }
        
        .mid{
            width: 15%;
        }
        
        .small{
            width: 8%;
        }
    </style>
    
    <style>
        .table-sortable th {
          cursor: pointer;
        }
        
        .table-sortable .th-sort-asc::after {
          content: "\25b4";
        }
        
        .table-sortable .th-sort-desc::after {
          content: "\25be";
        }
        
        .table-sortable .th-sort-asc::after,
        .table-sortable .th-sort-desc::after {
          margin-left: 5px;
        }
        
        .table-sortable .th-sort-asc,
        .table-sortable .th-sort-desc {
          background: #A62828;
        }
        
        .sizetr{
            height:3vw!important;
        }
    </style>
</head>
<body class="skin-red sidebar-mini sidebar-collapse">
    <div id="divLoading" style="display: none;">
        <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
        </div>
    </div>
    <div class="wrapper">
        <!-- Header -->
        <?php include 'admin/header.php'; ?>
        <!-- Left side column. contains the logo and sidebar -->
        <?php
            $inicio = "active";
            $dashboardvisitas= "active";
            include 'admin/main-sidebar.php';
        ?>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div style="font-size:180%;"> DASHBOARD&nbsp <span style="font-size:80%;color:#DAD8D4"> | &nbsp <span style="font-size:80%;color:#8D8A80">UPSELLING</span></span> </div>              
                <ol class="breadcrumb">
                    <li><a class="text-left"><font color="red">Día: <?php echo $dias."/".$mes."/".$ano;?></font></a></li>
                </ol>
            </section>
            <!-- Main content -->
            <section class="content">
                <div class="box box-danger" >
                    <div class="box-header"> 
                        <i class="fa fa-bar-chart-o"></i> 
                        <h3 class="box-title">UPSELLING - GESTOR | 
                            <input type="text" style="font-size:100%;color:#444; background-color: #fff;border: 0; font-weight: bold;"  id="MesComercial" name="MesComercial">
                        </h3>
                        
                        <button style="color:white;float:right;" id="btnDatosUpselling" class="btn btn-sm btn-danger"><i class="fa fa-plus"></i></button>
                    </div>
                    
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-2" style="width: 20%; margin-bottom: 20px; text-align: left">
                                <img src="admin/dist/img/bandera.png" style="width:8vw;height:5vw;" alt="Bandera de Perú">
                            </div>
                            <div class="col-md-6">
                                <div>
                                    <h3>Días laborados</h3>
                                </div>
                                <div class="progress progress-xs progress-striped active">
                                    <div class="progress-bar progress-bar-danger" id="barra__diasLaborados"></div>
                                </div>
                                <div>
                                    <h3 style="text-align: right" id="text_diasLaborados"></h3>
                                </div>
                            </div>
                        </div>
                        
                        <table class="table table-hover table-sortable ocultar" id="tblCanal" >
                            <thead>
                                <tr style="height:2vw">
                                    <th class="tblSubHeader text-center big">Canal</th>
                                    <th class="tblSubHeader text-center small">Objetivo</th>
                                    <th class="tblSubHeader text-center small">Upfront</th>
                                    <th class="tblSubHeader text-center small">% Avance</th>
                                    <th class="tblSubHeader text-center small">% Proy</th>
                                    <th class="tblSubHeader text-center small">% Conversión</th>
                                    <th class="tblSubHeader text-center small">Agendados</th>
                                    <th class="tblSubHeader text-center small">Instalados</th>
                                    <th class="tblSubHeader text-center small">Facturados</th>
                                    <th class="tblSubHeader text-center small">N° Elementos</th>
                                    <th class="tblSubHeader text-center small">Precio Promedio</th>
                                </tr>
                            </thead>
                            <tbody>       
                            </tbody>
                        </table>
                        
                        <table class="table table-hover table-sortable-Gestor ocultar" id="tblGestor" style="margin-top: 20px">
                            <thead>
                                <tr style="height:2vw">
                                    <th class="tblSubHeader text-center big">Gestor</th>
                                    <th class="tblSubHeader text-center small">Objetivo</th>
                                    <th class="tblSubHeader text-center small">Upfront</th>
                                    <th class="tblSubHeader text-center small">% Avance</th>
                                    <th class="tblSubHeader text-center small">% Proy</th>
                                    <th class="tblSubHeader text-center small">% Conversión</th>
                                    <th class="tblSubHeader text-center small">Agendados</th>
                                    <th class="tblSubHeader text-center small">Instalados</th>
                                    <th class="tblSubHeader text-center small">Facturados</th>
                                    <th class="tblSubHeader text-center small">N° Elementos</th>
                                    <th class="tblSubHeader text-center small">Precio Promedio</th>
                                </tr>
                            </thead>
                            <tbody>       
                            </tbody>
                        </table>
                        
                        <table class="table table-hover table-sortable ocultar" id="tblDispositivos" style="margin-top: 20px">
                            <thead>
                                <tr style="height:2vw">
                                    <th class="tblSubHeader text-center big">DISPOSITIVOS</th>
                                    <th class="tblSubHeader text-center small">elementos</th>
                                    <th class="tblSubHeader text-center small">% elementos</th>
                                    <th class="tblSubHeader text-center small">% conversion</th>
                                    <th class="tblSubHeader text-center small">upfront</th>
                                    <th class="tblSubHeader text-center small">% upfront </th>
                                    <th class="tblSubHeader text-center small">% conversion</th>
                                    <th class="tblSubHeader text-center small">precio promedio</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                        
                    </div>
                    
                </div>
                
            </section>
            <?php include 'modalpassword.php';?>
            
            <div class="modal fade" id="add_data_Modal">
                <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header modal-header-danger">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">x</button>
                        <h4>GENERAR DATOS DEL DASHBOARD</h4>
                    </div>
                    <div class="modal-body">
                        <div class="box box-solid" style="box-shadow: none;">
                            <form>
                                <div class="box-body">
                                    <div class="row">
                                        <div class="col-md-2"></div>
                                        <div class="col-md-8">
                                            <div class="form-group">
                                              <label for="lbln590" class="col-sm-3 control-label">N590</label>
                            
                                              <div class="col-sm-9">
                                                    <input type="text" class="form-control" id="lbln590" name="lbln590">
                                              </div>
                                            </div>
                                        </div>
                                        <div class="col-md-2"></div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-2"></div>
                                        <div class="col-md-8">
                                            <div class="form-group">
                                              <label for="diasLaborables" class="col-sm-3 control-label">Dias Laborable:</label>
                            
                                              <div class="col-sm-9">
                                                    <input type="text" class="form-control" id="diasLaborables" name="diasLaborables">
                                              </div>
                                            </div>
                                        </div>
                                        <div class="col-md-2"></div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-2"></div>
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <label class="col-sm-3 control-label">Tipo: </label>
                                                <div class="col-sm-9">
                                                    <select class="form-control select2" id="tipoBase" name="tipoBase" style="width: 100%">
                                                        <option value="" disabled selected>Seleccione</option>
                                                        <option value="gestor">Gestor</option>
                                                        <option value="canal">Canal</option>
                                                        <option value="dispositivos">Dispositivos</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="divGestor ocultar">
                                        <div class="row">
                                            <div class="col-md-2"></div>
                                            <div class="col-md-8">
                                                <div class="form-group">
                                                    <label for="gestor" class="col-sm-3 control-label">Gestor</label>
                                                    <div class="col-sm-9">
                                                        <select class="form-control select2" id="gestor" name="gestor" style="width: 100%">
                                                            <option value="" disabled selected>--Seleccione--</option>
                                                            <?php 
                                                                $sql = "SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Gestor 
                                                                        FROM yifi58ge_dbUSUARIO.tblusuario u
                                                                        INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea
                                                                        WHERE (u.IdPerfil=42) and u.Estado='Activo'";
                                                                $resultado = $con->query($sql);
                                                                while($gestor = $resultado->fetch_assoc()){
                                                            ?>
                                                            <option value="<?php echo $gestor['Matricula']; ?>"><?php echo $gestor['Gestor'] ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2"></div>
                                        </div>
                                        <br>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                  <label for="objetivo" class="col-sm-4 control-label">Objetivo</label>
                                
                                                  <div class="col-sm-8">
                                                        <input type="number" class="form-control" id="objetivo" name="objetivo" value="0" style="width: 100%" min=0>
                                                  </div>
                                                </div>
                                            </div>
                                        </div>
                                        <br>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <button class="btn btn-danger pull-right" id="btnAgregar" name="btnAgregar"><i class="fa fa-plus"></i>&nbsp Agregar </button>
                                            </div>
                                        </div>
                                        <br>
                                        <div class="row">
                                            <div class="col-md-2"></div>
                                            <div class="col-md-8">
                                                <table class="table table-hover" id="tbdatos">
                                                    <thead>
                                                        <tr>
                                                            <th>Gestor</th>
                                                            <th>Objetivo</th>
                                                            <th></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    </tbody>
                                                </table>
                                            </div>
                                            
                                        </div>
                                    </div>
                                    <div class="divCanal ocultar">
                                        <div class="row">
                                            <div class="col-md-2"></div>
                                            <div class="col-md-8">
                                                <div class="form-group">
                                                  <label for="gestor" class="col-sm-3 control-label">Canal</label>
                                
                                                  <div class="col-sm-9">
                                                        <select class="form-control select2" id="canal" name="canal" style="width: 100%">
                                                            <option value="" disabled selected>--Seleccione--</option>
                                                            <option value="Inbound">Inbound</option>
                                                            <option value="Outbound">Outbound</option>
                                                            <option value="PostMantos">PostMantos</option>
                                                            <option value="Field">Field</option>
                                                        </select>
                                                  </div>
                                                </div>
                                            </div>
                                            <div class="col-md-2"></div>
                                        </div>
                                        <br>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                  <label for="objetivo" class="col-sm-4 control-label">Objetivo</label>
                                
                                                  <div class="col-sm-8">
                                                        <input type="number" class="form-control" id="objetivoCanal" name="objetivoCanal" value="0" style="width: 100%" min=0>
                                                  </div>
                                                </div>
                                            </div>
                                        </div>
                                        <br>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <button class="btn btn-danger pull-right" id="btnAgregarCanal" name="btnAgregarCanal"><i class="fa fa-plus"></i>&nbsp Agregar </button>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-2"></div>
                                            <div class="col-md-8">
                                                <table class="table table-hover" id="tbdatosCanal">
                                                    <thead>
                                                        <tr>
                                                            <th>Canal</th>
                                                            <th>Objetivo</th>
                                                            <th></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    </tbody>
                                                </table>
                                            </div>
                                            
                                        </div>
                                    </div>
                                    <div class="divDispositivos ocultar">
                                        
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" id="Cerrarmodal" data-dismiss="modal">Cerrar</button>
                        <button type="button" class="btn btn-danger" id="insert">Registrar</button>
                    </div>   
                </div>
                
            </div>
            </div>
            
        </div>
    </div>
    <!-- jQuery 3 -->
    <script src="admin/bower_components/jquery/dist/jquery.min.js"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <!-- Bootstrap 3.3.7 -->
    <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- SELECT 2 -->
    <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
    <!-- date-range-picker -->
    <script src="admin/bower_components/moment/min/moment.min.js"></script>
    <script src="admin/bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
    <!-- datepicker -->
    <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>

    <!-- Bootstrap WYSIHTML5 -->
    <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
    <!-- Slimscroll -->
    <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <!-- FastClick -->
    <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
    <!-- AdminLTE App -->
    <script src="admin/dist/js/adminlte.min.js"></script>
    <!-- SWEET ALERT -->
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- CHARTS -->
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    
    <script src="admin/bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="admin/bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
    
    <!-- SCRIPT DASHBOARD -->
    <script>
        const contenedorTablaGestores = document.querySelector('#tblGestor tbody');
        
        const contenedorTablaCanal = document.querySelector('#tblCanal tbody');
        
        const contenedorTablaDispositivos = document.querySelector('#tblDispositivos tbody')
        
        const contenedorNuevosDatos = document.querySelector('#tbdatos tbody');
        
        const contenedorNuevosDatosCanal = document.querySelector('#tbdatosCanal tbody');
        
        let arregloDatos = [];
        let arregloDatosCanal = [];
        
    </script>
    <!-- INICIALIZADORES -->
    <script>
        $('#MesComercial').datepicker({
            autoclose: true,
            language: 'en',
            firstDay: 1, format: 'M-yyyy',
            viewMode: "years",
            minViewMode: "months"
        }).datepicker("setDate", new Date());
        
        $('#lbln590').datepicker({
            autoclose: true,
            language: 'en',
            firstDay: 1, format: 'M-yyyy',
            viewMode: "years",
            minViewMode: "months"
        }).datepicker("setDate", new Date());
        
        $('.select2').select2()
        
    </script>
    <!-- EVENTOS -->
    <script>
        $('#btnDatosUpselling').on('click', function(){
            $('#add_data_Modal').modal('show');
        })
        
        $('#add_data_Modal').on('shown.bs.modal', function () {
            
            cargarDatosBase();
            //cargarDatosBaseCanal();
        })
        
        $('#add_data_Modal').on('hidden.bs.modal', function () {
            arregloDatos = [];
            arregloDatosCanal = [];
            limpiarHTML(contenedorNuevosDatos);
            limpiarHTML(contenedorNuevosDatosCanal);
        })
        
        $('#btnAgregar').on('click', function(e){
            e.preventDefault();
            
            const gestor = $('#gestor option:selected');
            const objetivo = $('#objetivo');
            
            const datos = {
                matricula: gestor.val(),
                gestor: gestor.text(),
                objetivo: objetivo.val()
            }
            
            if(validarDatosBase(datos)){
                
                arregloDatos = [...arregloDatos, datos];
        
                agregarDatosBase();
                
                gestor.remove();
                objetivo.val('');
            }
        })
        
        $('#btnAgregarCanal').on('click', function(e){
            e.preventDefault();
            
            const canal = $('#canal option:selected');
            const objetivoCanal = $('#objetivoCanal');
            
            
            const datos = {
                canal: canal.val(),
                objetivo: objetivoCanal.val()
            }
            
            arregloDatosCanal = [...arregloDatosCanal, datos];
            
            agregarDatosCanal();
                
            canal.remove();
            objetivoCanal.val('');
            
            
        })
        
        $('#insert').on("click", function(e){
            e.preventDefault();
            
            const accion = $('#insert').text();
            const lbln590 = $('#lbln590').val();
            const diasLaborables = $('#diasLaborables').val();
            let datos;
            
            if(accion === 'Registrar'){
                datos = {datos: arregloDatos, datosCanal: arregloDatosCanal, lbln590: lbln590, diasLaborables:diasLaborables, accion: 'insertar'};
            } else if (accion === 'Actualizar'){
                datos = {datos: arregloDatos, datosCanal: arregloDatosCanal, lbln590: lbln590, diasLaborables:diasLaborables, accion: 'actualizar'};
            } else {
                Swal.fire(
                  'Error',
                  'Función no reconocida',
                  'error'
                )
                
                return;
            }
            
            $.ajax({
                    type: 'POST',
                    url: 'ajax/CrudDashboardUpselling.php',
                    data: datos,
                    dataType: "Json",
                    success: function (data) {
                        if(data.respuesta == 'exito'){
                            arregloDatos = [];
                            
                            limpiarHTML(contenedorNuevosDatos);
                            $('#add_data_Modal').modal('hide');
                            
                            
                            
                            Swal.fire(
                              'Registrado',
                              'Se registró la información correctamente',
                              'success'
                            )
                            
                            cargarDatos();
                            
                        }
                    }
                })

        })
        
        $('#lbln590').on("change", function(){
            const lbln590 = $('#lbln590').val();
            arregloDatos = [];
            cargarDatosBase();
        })
        
        $('#MesComercial').on("change", function(){
            //DATOS TABLA GESTOR
            cargarDatos();
            //DATOS TABLA CANAL
            cargarDatosCanal();
            //DATOS TABLA DISPOSITIVOS
            cargarDatosDispositivos();
        })
        
        $('#tbdatos').on("click", function(e){
            if(e.target.classList.contains('borrar-gestor')){
                const gestor = e.target.parentElement.parentElement;
                const gestorMatricula = gestor.querySelector('a').getAttribute('data-id');
                const gestorNombre = gestor.querySelector('a').getAttribute('text-id');
                // Eliminar del arreglo del carrito

                arregloDatos = arregloDatos.filter(gestor => gestor.matricula !== gestorMatricula);
                
                agregarDatosBase();
                
                $('#gestor').append(`<option value="${gestorMatricula}">${gestorNombre}</option>`);
                
            }
        })
        
        $('#tbdatosCanal').on("click", function(e){
            if(e.target.classList.contains('borrar-canal')){
                const canal = e.target.parentElement.parentElement;
                
                const canalVal = canal.querySelector('a').getAttribute('data-id');

                arregloDatosCanal = arregloDatosCanal.filter(canal => canal.canal !== canalVal);
                
                agregarDatosCanal();
                
                $('#canal').append(`<option value="${canalVal}">${canalVal}</option>`);
            }
        })
        
        $('#tipoBase').on("change", function(){
            tipoBase = $('#tipoBase').val();
            if(tipoBase == 'gestor'){
                $('.divGestor').removeClass('ocultar');
                $('.divCanal').addClass('ocultar');
            }
            if(tipoBase == 'canal'){
                $('.divGestor').addClass('ocultar');
                $('.divCanal').removeClass('ocultar');
            }
        })
    </script>
    <!-- DOCUMENT READY -->
    <script>
        $(document).ready(() => {
            const lbln590 = $('#lbln590').val();
            
            let datos = {lbln590: lbln590, accion: 'consultar'};
            
            $.ajax({
                type: 'POST',
                url: 'ajax/CrudDashboardUpselling.php',
                data: datos,
                dataType: "Json",
                success: function (data) {
                    
                    console.log(data);
                    
                    if(data.resultado == 'exito'){
                        
                        $('#tblCanal').removeClass('ocultar');
                        $('#tblGestor').removeClass('ocultar');
                        $('#tblDispositivos').removeClass('ocultar');
                        
                        $('#insert').text('Actualizar');
                        
                        const gestores = data.datos;
                        
                        if(gestores){
                            gestores.forEach(elemento => {
                                arregloDatos = [...arregloDatos, elemento];
                                
                                //Remover al comercial del select
                                let matricula = elemento.matricula;
                                $("#gestor").find(`option[value='${matricula}']`).remove();
                                
                            })
                        }
                        
                        const canales = data.datosBaseCanal;
                        
                        if(canales){
                            canales.forEach(elemento => {
                                arregloDatosCanal = [...arregloDatosCanal, elemento];
                                
                                //Remover al comercial del select
                                let canal = elemento.canal;
                                $("#canal").find(`option[value='${canal}']`).remove();
                                
                            })
                        }
                        
                        $('#diasLaborables').val(data.diasLaborables);
                        
                        agregarDatosBase();
                        
                        //DATOS TABLA GESTOR
                        cargarDatos();
                        //DATOS TABLA CANAL
                        cargarDatosCanal();
                        //DATOS TABLA DISPOSITIVOS
                        cargarDatosDispositivos();
                    } else {
                        limpiarHTML(contenedorNuevosDatos);
                        
                        Swal.fire(
                          '¡Alerta!',
                          'Los datos base del dashboard no han sido generado.',
                          'warning'
                        )
                        

                    }
                }
            })
            
        });
        
    </script>
    <!-- NUEVAS FUNCIONES -->
    <script>
        function limpiarHTML(cont) {
            //forma recomendada
            while (cont.firstChild) {
                cont.removeChild(cont.firstChild);
            }
        }
        
        function validarDatosBase(datos){
            
            const {objetivo, gestor}= datos;
            
            if(objetivo <= 0){
                alert('El objetivo debe ser mayor a 0');
                return false;
            }
            if(gestor == ''){
                alert('Debe seleccionar al gestor');
                return false;
            }
            
            return true;
        }
        
        function agregarDatosBase(){
            
            limpiarHTML(contenedorNuevosDatos);
                
            arregloDatos.forEach(datos => {
                const {matricula, gestor, objetivo} =  datos;
                const row = document.createElement('tr');
                row.innerHTML = `
                                    <td>${gestor}</td>
                                    <td>${objetivo}</td>
                                    <td><a href="#" class="borrar-gestor" data-id="${matricula}" text-id="${gestor}">X</a></td>
                                `   
                contenedorNuevosDatos.appendChild(row);
                
            })
            
            arregloDatosCanal.forEach(datos => {
                const {canal, objetivo} =  datos;
                const row = document.createElement('tr');
                row.innerHTML = `
                                    <td>${canal}</td>
                                    <td>${objetivo}</td>
                                    <td><a href="#" class="borrar-canal" data-id="${canal}" text-id="${canal}">X</a></td>
                                `   
                contenedorNuevosDatosCanal.appendChild(row);
                
            })
        }
        
        function agregarDatosCanal(){
            limpiarHTML(contenedorNuevosDatosCanal);
            
            arregloDatosCanal.forEach(datos => {
                
                const {canal, objetivo} = datos;
                
                const row = document.createElement('tr');
                row.innerHTML = `
                                    <td>${canal}</td>
                                    <td>${objetivo}</td>
                                    <td><a href="#" class="borrar-canal" data-id="${canal}" text-id="${canal}">X</a></td>
                                `   
                contenedorNuevosDatosCanal.appendChild(row);
            })
        }
        
        function cargarDatos(){
            limpiarHTML(contenedorTablaGestores);
            
            const MesComercial = $('#MesComercial').val();
            
            const datos = {
                MesComercial
            };
            
            $.ajax({
                type: 'POST',
                url: 'ajax/dataDashboardUpsellingGestor.php',
                data: datos,
                dataType: "Json",
                success: function (data) {
                    
                    console.log(data);
                    
                    const diasLaborables = data.diasLaborables;
                    const diasLaborados = data.diasLaborados;
                    
                    const porcentaje = (diasLaborados/diasLaborables)*100;
                    
                    document.getElementById("barra__diasLaborados").style.width = `${porcentaje}%`;
                    
                    let texto = `${diasLaborados} días de ${diasLaborables}`;
                    
                    $('#text_diasLaborados').text(texto);
                    
                    if(data.Resultado == 'exito'){
                        
                        $('#tblGestor').removeClass('ocultar');
                        
                        const datosMes = data.Datos;
                        const datosActual = data.Actual;
                        const diasLaborables = data.diasLaborables;
                        const diasLaborados = data.diasLaborados;
                        
                        let totalObjetivo = 0;
                        let totalUpfront = 0.00; 
                        let totalAgendados = 0; 
                        let totalInstalados = 0; 
                        let totalFacturados = 0; 
                        let totalElementos = 0; 
                        let totalGestiones = 0;
                        
                        //ORDERNAR EL ARREGLO GENERAL DE MAYOR A MENOR POR UPFRONT FLOAT
                        datosMes.sort(function (a, b) {
                            
                            if (a.upfrontFLOAT < b.upfrontFLOAT) {
                                return 1;
                            }
                            if (a.upfrontFLOAT > b.upfrontFLOAT) {
                                return -1;
                            }
                            // a must be equal to b
                            return 0;
                            
                        });
                        
                        datosMes.forEach(elemento => {
                            agregarDatosTablaGestores(elemento);
                            
                            totalObjetivo += parseInt(elemento.objetivo);
                            totalUpfront += parseFloat(elemento.upfrontFLOAT);
                            
                            totalGestiones += elemento.gestiones;
                            totalAgendados += elemento.agendados;
                            totalInstalados += elemento.instalados;
                            totalFacturados += elemento.facturados;
                            totalElementos +=  elemento.nelementos;
                        })
                        
                        let totalAvance = (totalUpfront/totalObjetivo)*100;
                        totalAvance = totalAvance.toFixed(2);
                        
                        let totalProy = (((totalUpfront/diasLaborados)*diasLaborables)/totalObjetivo)*100;
                        totalProy = totalProy.toFixed(2);
                        
                        let totalConv = (totalInstalados/totalGestiones) *100;
                        totalConv = totalConv.toFixed(2);
                        
                        let totalPrecProm = (totalUpfront/totalElementos);
                        totalPrecProm = totalPrecProm.toFixed(2);
                        
                        const row = document.createElement('tr');
                        row.innerHTML = `
                            <td class="text-center tblfooter">
                                Total
                            </td>
                            <td class="text-center tblfooter">
                                S/. ${totalObjetivo}
                            </td>
                            <td class="text-center tblfooter">
                                S/. ${totalUpfront.toFixed(2)}
                            </td>
                            <td class="text-center tblfooter">
                                ${totalAvance} %
                            </td>
                            <td class="text-center tblfooter">
                                ${totalProy} %
                            </td>
                            <td class="text-center tblfooter">
                                ${totalConv} %
                            </td>
                            <td class="text-center tblfooter">
                                ${totalAgendados}
                            </td>
                            <td class="text-center tblfooter">
                                ${totalInstalados}
                            </td>
                            <td class="text-center tblfooter">
                                ${totalFacturados}
                            </td>
                            <td class="text-center tblfooter">
                                ${totalElementos}
                            </td>
                            <td class="text-center tblfooter">
                                S/. ${totalPrecProm}
                            </td>
                            `
                        contenedorTablaGestores.appendChild(row);
                    } 
                    
                }
            })
        }
        
        function cargarDatosCanal(){
            limpiarHTML(contenedorTablaCanal);
            
            const MesComercial = $('#MesComercial').val();
            
            const datos = {
                MesComercial
            };
            
            $.ajax({
                type: 'POST',
                url: 'ajax/dataDashboardUpsellingCanal.php',
                data: datos,
                dataType: "Json",
                success: function (data) {
                    console.log('Cuadro por Canal');
                    console.log(data);
                    
                    if(data.Resultado == 'exito'){
                        
                        $('#tblCanal').removeClass('ocultar');
                        
                        const datosMes = data.Datos;
                        const diasLaborables = data.diasLaborables;
                        const diasLaborados = data.diasLaborados;
                        
                        let totalObjetivo = 0;
                        let totalUpfront = 0.00; 
                        let totalAgendados = 0; 
                        let totalInstalados = 0; 
                        let totalFacturados = 0; 
                        let totalElementos = 0; 
                        let totalGestiones = 0;
                        
                        datosMes.forEach(elemento => {
                            agregarDatosTablaCanales(elemento);

                            totalObjetivo += parseInt(elemento.objetivo);
                            totalUpfront += parseFloat(elemento.upfrontFLOAT);
                            
                            totalGestiones += elemento.gestiones;
                            totalAgendados += elemento.agendados;
                            totalInstalados += elemento.instalados;
                            totalFacturados += elemento.facturados;
                            totalElementos +=  elemento.nelementos;
                            
                        })
                        
                        sortTable(document.getElementById("tblCanal"), 2);
                        
                        let totalAvance = (totalUpfront/totalObjetivo)*100;
                        totalAvance = totalAvance.toFixed(2);
                        
                        let totalProy = (((totalUpfront/diasLaborados)*diasLaborables)/totalObjetivo)*100;
                        totalProy = totalProy.toFixed(2);
                        
                        let totalConv = (totalInstalados/totalGestiones) *100;
                        totalConv = totalConv.toFixed(2);
                        
                        let totalPrecProm
                        if(totalElementos == 0){
                            totalPrecProm = 0;
                            totalPrecProm = totalPrecProm.toFixed(2);
                        } else {
                            totalPrecProm = (totalUpfront/totalElementos);
                            totalPrecProm = totalPrecProm.toFixed(2);
                        }
                        const row = document.createElement('tr');
                        row.innerHTML = `
                            <td class="text-center tblfooter">
                                Total
                            </td>
                            <td class="text-center tblfooter">
                                S/. ${totalObjetivo}
                            </td>
                            <td class="text-center tblfooter">
                                S/. ${totalUpfront.toFixed(2)}
                            </td>
                            <td class="text-center tblfooter">
                                ${totalAvance} %
                            </td>
                            <td class="text-center tblfooter">
                                ${totalProy} %
                            </td>
                            <td class="text-center tblfooter">
                                ${totalConv} %
                            </td>
                            <td class="text-center tblfooter">
                                ${totalAgendados}
                            </td>
                            <td class="text-center tblfooter">
                                ${totalInstalados}
                            </td>
                            <td class="text-center tblfooter">
                                ${totalFacturados}
                            </td>
                            <td class="text-center tblfooter">
                                ${totalElementos}
                            </td>
                            <td class="text-center tblfooter">
                                S/. ${totalPrecProm}
                            </td>
                            `
                        contenedorTablaCanal.appendChild(row);
                        
                        
                    }
                }
            })
        }
        
        function cargarDatosDispositivos(){
            limpiarHTML(contenedorTablaDispositivos);
            
            const MesComercial = $('#MesComercial').val();
            
            const datos = {
                MesComercial
            };
            
             $.ajax({
                type: 'POST',
                url: 'ajax/dataDashboardUpsellingDispositivos.php',
                data: datos,
                dataType: "Json",
                success: function (data) {
                    
                    console.log('Dispositivos');
                    console.log(data);
                    
                    if(data.Resultado == 'exito'){
                        $('#tblDispositivos').removeClass('ocultar');
                        
                        const datosMes = data.Datos;
                        
                        //TOTALES
                        let TotalElementosAmpliados = 0;
                        let TotalElementos = 0;
                        let TotalUpfront = 0.00;
                        let Total_UpfrontTotal = 0;
                        let PorcentajeUpfront = 0;
                        let Total_UpfrontAgendados =0;
                        let TotalPrecioPromedio = 0;
                        
                        datosMes.forEach(elemento => {
                            console.log('Detalle elemento');
                            console.log(elemento);
      
                            const {Elementos, ElementosAmpliados, Upfront, UpfrontTotal, UpfrontAgendados, PrecioPromedio} = elemento;
                            
                            let cantidadElementosAmpliados = parseInt(ElementosAmpliados); //CAMBIO A INT DE LA VARIABLE ElementosAmpliados
                            let cantidadElementos = parseInt(Elementos);
                            let Float_Upfront = parseFloat(Upfront);
                            let Float_UpfrontTotal = parseFloat(UpfrontTotal);
                            let Float_UpfrontAgendados = parseFloat(UpfrontAgendados);
                            let Float_PrecioPromedio = parseFloat(PrecioPromedio);

                            TotalElementosAmpliados += cantidadElementosAmpliados;
                            TotalElementos += cantidadElementos;
                           
                            //Total de elemento ampliados entre total de elementos ampliados
                            PorcentajeElementos = (TotalElementosAmpliados/TotalElementosAmpliados)*100;
                            
                            PorcentajeConversion = (TotalElementosAmpliados/TotalElementos)*100;
                            TotalUpfront += Float_Upfront;
                            
                            Total_UpfrontTotal += Float_UpfrontTotal;
                            PorcentajeUpfront = (TotalUpfront/TotalUpfront)*100;
                            
                            Total_UpfrontAgendados += Float_UpfrontAgendados;
                            PorcentajeConversionUpfront = (TotalUpfront/Total_UpfrontAgendados)*100;
                            
                            TotalPrecioPromedio +=  Float_PrecioPromedio;
                            PrecioPromedioGeneral = TotalPrecioPromedio/TotalElementosAmpliados;
                        })
                        
                        TotalUpfront = TotalUpfront.toFixed(2);
                        PorcentajeConversion = PorcentajeConversion.toFixed(2);
                        PorcentajeUpfront = PorcentajeUpfront.toFixed(2);
                        PorcentajeConversionUpfront = PorcentajeConversionUpfront.toFixed(2);
                        PrecioPromedioGeneral = PrecioPromedioGeneral.toFixed(2);
                        
                        const row = document.createElement('tr');
                        row.innerHTML = `
                                <td class="text-center tblfooter">
                                    Total
                                </td>
                                <td class="text-center tblfooter">
                                    ${TotalElementosAmpliados}
                                </td>
                                <td class="text-center tblfooter">
                                    ${PorcentajeElementos} %
                                </td>
                                <td class="text-center tblfooter">
                                    ${PorcentajeConversion} %
                                </td>
                                <td class="text-center tblfooter">
                                    S/. ${TotalUpfront}
                                </td>
                                <td class="text-center tblfooter">
                                    ${PorcentajeUpfront} %
                                </td>
                                <td class="text-center tblfooter">
                                    ${PorcentajeConversionUpfront} %
                                </td>
                                <td class="text-center tblfooter">
                                    S/. ${PrecioPromedioGeneral}
                                </td>
                            `;
                            
                        contenedorTablaDispositivos.appendChild(row);
                        
                        
                        datosMes.forEach(elemento => {
                            
                            agregarDatosTablaDispositivos(elemento);

                        })
                        
                        sortTable(document.getElementById("tblDispositivos"), 1);
                        
                    }
                }
             })
        }
        
        function cargarDatosBase(){
            
            const lbln590 = $('#lbln590').val();
            
            let datos = {lbln590: lbln590, accion: 'consultar'};
            
            $.ajax({
                type: 'POST',
                url: 'ajax/CrudDashboardUpselling.php',
                data: datos,
                dataType: "Json",
                success: function (data) {
                    
                    console.log(data);
                    
                    if(data.resultado == 'exito'){
                        
                        $('#insert').text('Actualizar');
                        
                        const gestores = data.datos;
                        if(gestores){
                            gestores.forEach(elemento => {
                                arregloDatos = [...arregloDatos, elemento];
                                
                                //Remover al comercial del select
                                let matricula = elemento.matricula;
                                $("#gestor").find(`option[value='${matricula}']`).remove();
                                
                            })
                        }
                        const canales = data.datosBaseCanal;
                        if(canales){
                            canales.forEach(elemento => {
                                arregloDatosCanal = [...arregloDatosCanal, elemento];
                                
                                //Remover al comercial del select
                                let canal = elemento.canal;
                                $("#canal").find(`option[value='${canal}']`).remove();
                                
                            })
                        }
                        $('#diasLaborables').val(data.diasLaborables);
                        
                        agregarDatosBase();
                    } else {
                        limpiarHTML(contenedorNuevosDatos);
                        console.log(data.resultado);
                        return data.resultado;
                    }
                }
            })
        }
        
        function agregarDatosTablaGestores(datos){
            
            const {matricula, gestor, objetivo, upfront, upfrontFLOAT, avance, proy, gestiones, agendados, instalados, facturados, nelementos, canales} = datos;
            
            //convierte el objeto canales en un array para poderlo recorrer
            const arrayCanales = Object.values(canales); 
            
            const row = document.createElement('tr');
            
            row.style = "height:1vw!important;cursor: pointer;";
            row.setAttribute("data-toggle", "collapse");
            row.setAttribute("data-target", "."+matricula); //DEFINIR LA FILA QUE SE MOSTRARA
            row.setAttribute("class", "tbgestores"); //DEFINIR LA CLASE QUE SE ENCUENTRA
            
            let conversion = 0;
            if(gestiones != 0){
                conversion = (instalados/gestiones)*100;
                conversion = conversion.toFixed(2);
            }
            
            let precpromedio = 0;
            if(nelementos != 0){
                precpromedio = (upfrontFLOAT/nelementos);
                precpromedio = precpromedio.toFixed(2);
            }
            
            row.innerHTML = `
                <td class="text-left ">
                    ${gestor} (${matricula})
                </td>
                <td class="text-center ">
                    S/. ${objetivo}
                </td>
                <td class="text-center ">
                    S/. ${upfront}
                </td>
                <td class="text-center ">
                    ${avance} %
                </td>
                <td class="text-center ">
                    ${proy} %
                </td>
                <td class="text-center ">
                    ${conversion} %
                </td>
                <td class="text-center ">
                    ${agendados} 
                </td>
                <td class="text-center ">
                    ${instalados} 
                </td>
                <td class="text-center ">
                    ${facturados} 
                </td>
                <td class="text-center ">
                    ${nelementos} 
                </td>
                <td class="text-center ">
                    S/. ${precpromedio} 
                </td>
            `;
            
            //AÑADIR COLORES AL AVANCE Y PROYECCION
            agregarFormato(row.children[3], avance);
            agregarFormato(row.children[4], proy);
            
            contenedorTablaGestores.appendChild(row);
            //FIN CONTENEDOR TABLA GESTORES
            
            //sortTable(document.getElementById("tblGestor"));
            
            arrayCanales.forEach(elemento => {
                
                const {canal, upfrontCanal, upfrontFLOATCanal, AgendadosCanal, GestionesCanal, InstaladosCanal, FacturadosCanal, NElementosCanal} = elemento;

                    const rowCanalGestor = document.createElement('tr');
                    rowCanalGestor.style = "height:1vw!important; background-color: #e2e2e2";
                    rowCanalGestor.setAttribute("class", ""+matricula+" collapse sizetr"); //DEFINIR LA CLASE QUE SE ENCUENTRA
                    
                    let conversionCanal = 0.00;
                    if(GestionesCanal != 0){
                        conversionCanal = (InstaladosCanal/GestionesCanal)*100;
                        conversionCanal = conversionCanal.toFixed(2);
                    }
                    let precpromedioCanal = 0.00;
                    if(NElementosCanal != 0){
                        precpromedioCanal = (upfrontFLOATCanal/NElementosCanal);
                        precpromedioCanal = precpromedioCanal.toFixed(2);
                    }
                    rowCanalGestor.innerHTML = `
                                                    <td class="text-left Row__titulo">
                                                        ${canal}
                                                    </td>
                                                    <td></td>
                                                    <td class="text-center">
                                                        S/. ${upfrontCanal}
                                                    </td>
                                                    <td></td>
                                                    <td></td>
                                                    <td class="text-center">
                                                        ${conversionCanal} %
                                                    </td>
                                                    <td class="text-center">
                                                        ${AgendadosCanal}
                                                    </td>
                                                    <td class="text-center">
                                                        ${InstaladosCanal}
                                                    </td>
                                                    <td class="text-center">
                                                        ${FacturadosCanal}
                                                    </td>
                                                    <td class="text-center">
                                                        ${NElementosCanal}
                                                    </td>
                                                    <td class="text-center">
                                                        S/. ${precpromedioCanal}
                                                    </td>
                                                `;
                                                
                    contenedorTablaGestores.appendChild(rowCanalGestor);
                    
                
            })
        }
        
        function agregarDatosTablaCanales(elemento){
            
            const {canal, objetivo, upfront, upfrontFLOAT, avance, proy, gestiones, agendados, instalados, facturados, nelementos} = elemento;
            const row = document.createElement('tr');
            
            let conversion = (instalados/gestiones)*100;
            conversion = conversion.toFixed(2);
            
            let precpromedio
            if(nelementos == 0){
                precpromedio = 0;
                precpromedio = precpromedio.toFixed(2);
            } else {
                precpromedio = (upfrontFLOAT/nelementos);
                precpromedio = precpromedio.toFixed(2);
            }
            
            row.innerHTML = `
                <td class="Row__titulo text-left ">
                    ${canal}
                </td>
                <td class="text-center ">
                    S/. ${objetivo}
                </td>
                <td class="text-center ocultar">
                    ${upfrontFLOAT}
                </td>
                <td class="text-center">
                    ${upfront}
                </td>
                <td class="text-center ">
                    ${avance} %
                </td>
                <td class="text-center ">
                    ${proy} %
                </td>
                <td class="text-center ">
                    ${conversion} %
                </td>
                <td class="text-center ">
                    ${agendados} 
                </td>
                <td class="text-center ">
                    ${instalados}
                </td>
                <td class="text-center ">
                    ${facturados} 
                </td>
                <td class="text-center ">
                    ${nelementos} 
                </td>
                <td class="text-center ">
                    S/. ${precpromedio} 
                </td>
            `;
            
            //AÑADIR COLORES AL AVANCE Y PROYECCION
            agregarFormato(row.children[4], avance);
            agregarFormato(row.children[5], proy);
            
            contenedorTablaCanal.appendChild(row);
            
            
        }
        
        function agregarDatosTablaDispositivos(elemento){
            const {CodItem, Item, ElementosAmpliados, Elementos, ElementosTotal, Upfront, UpfrontAgendados, UpfrontTotal, PrecioPromedio} = elemento;
            
            UpfrontRound = parseFloat(Upfront);
            UpfrontRound = UpfrontRound.toFixed(2);
            
            const row = document.createElement('tr');
            
            let porcentajeElementos = 0;
            if(ElementosTotal != 0){
                porcentajeElementos = (ElementosAmpliados/ElementosTotal)*100;
                porcentajeElementos = porcentajeElementos.toFixed(0);
            }
            
            let porcentajeConversionElementos = 0;
            if(Elementos!= 0){
                porcentajeConversionElementos = (ElementosAmpliados/Elementos)*100;
                porcentajeConversionElementos = porcentajeConversionElementos.toFixed(0);
            }
            
            let porcentajeConversionUpfront = 0;
            if(UpfrontAgendados!= 0){
                porcentajeConversionUpfront = (Upfront/UpfrontAgendados)*100;
                porcentajeConversionUpfront = porcentajeConversionUpfront.toFixed(0);
            }
            
            let porcentajeUpfront = 0;
            if(UpfrontTotal!= 0){
                porcentajeUpfront = (Upfront/UpfrontTotal)*100;
                porcentajeUpfront = porcentajeUpfront.toFixed(0);
            }
            
            PrecioPromedioRound = parseFloat(PrecioPromedio);
            PrecioPromedioRound = PrecioPromedioRound.toFixed(2);
            
            row.innerHTML = `
                    <td class="Row__titulo text-left ">
                        ${Item}
                    </td>
                    <td class="text-center ">
                        ${ElementosAmpliados}
                    </td>
                    <td class="text-center ">
                        ${porcentajeElementos} %
                    </td>
                    <td class="text-center ">
                        ${porcentajeConversionElementos} %
                    </td>
                    <td class="text-center ">
                        S/. ${UpfrontRound} 
                    </td>
                    <td class="text-center ">
                        ${porcentajeUpfront} %
                    </td>
                    <td class="text-center ">
                        ${porcentajeConversionUpfront} %
                    </td>
                    <td class="text-center ">
                        S/. ${PrecioPromedioRound} 
                    </td>
                `;
                
            contenedorTablaDispositivos.appendChild(row);

         }
        
        function agregarFormato(elemento, valor){
            if(valor >= 0 && valor <70){
                elemento.classList.add("bajo");
            } else if (valor >= 70 && valor < 100 ){
                elemento.classList.add("medio");
            } else if (valor >= 100){
                elemento.classList.add("alto");
            }
        }
        
    </script>
    
    <script>
        function sortTable(table, columna) {
            var rows, switching, i, x, y, shouldSwitch;
            switching = true;
            /*Make a loop that will continue until
            no switching has been done:*/
            while (switching) {
                //start by saying: no switching is done:
                switching = false;
                rows = table.rows;
                /*Loop through all table rows (except the
                first, which contains table headers):*/
                for (i = 1; i < (rows.length - 1); i++) {
                  //start by saying there should be no switching:
                  shouldSwitch = false;
                  /*Get the two elements you want to compare,
                  one from current row and one from the next:*/
                  x = rows[i].getElementsByTagName("TD")[columna];
                  y = rows[i + 1].getElementsByTagName("TD")[columna];
                  //check if the two rows should switch place:
                  if (Number(y.innerHTML) > Number(x.innerHTML)) {
                    //if so, mark as a switch and break the loop:
                    shouldSwitch = true;
                    break;
                  }
                }
                if (shouldSwitch) {
                  /*If a switch has been marked, make the switch
                  and mark that a switch has been done:*/
                  rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
                  switching = true;
                }
            }
        }
        
        function sortJSON(data, key, orden) {
            return data.sort(function (a, b) {
                var x = a[key],
                y = b[key];
        
                if (orden === 'asc') {
                    return ((x < y) ? -1 : ((x > y) ? 1 : 0));
                }
        
                if (orden === 'desc') {
                    return ((x > y) ? -1 : ((x < y) ? 1 : 0));
                }
            });
        } 
</script>

    
</body>
</html>