<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

$ingresokit=0;
$ingresoextras=0;
$ingresototal=0;

require '../config/db.php';
require '../config/conexion.php';
require_once '../helper/helper_validacion.php';

//AGREGAR FUNCIONES LOG
include 'log/insertLog.php'; //INSERTAR LOG
include 'log/insertLogFacturacionVenta.php'; //FUNCIONES FACT TABLA VENT
include 'log/insertLogFacturacion.php'; //FUNCIONES FACT TABLA FACT
include 'log/insertLogCliente.php'; //FUNCIONES FACT TABLA CLI

$imp= htmlspecialchars($_POST['lblimp']); 
$categoria= htmlspecialchars($_POST['lblcategoria']); 
$dc= htmlspecialchars($_POST['lbldc']); 
$tipoventa= htmlspecialchars($_POST['lbltipoventa']);  
$segmento= htmlspecialchars($_POST['lblsegmento']);  
$estadoventa= htmlspecialchars($_POST['lblestadoventa']);  
$direccion= sanitizaCampo($_POST['lbldireccion'], 'sanitizestring|scapestring|htmlspecialchars',$con);   
$distrito= htmlspecialchars($_POST['lbldistrito']);  
$nprospecto= htmlspecialchars($_POST['lblnprospecto']);   
$ncontrato= htmlspecialchars($_POST['lblncontrato']);   
$mesesautorizados= htmlspecialchars($_POST['lblmesesautorizados']);   
$preciokit= htmlspecialchars($_POST['lblpreciokit']);   
$totalextra= htmlspecialchars($_POST['lbltotalextra']);   
$extraautorizado= htmlspecialchars($_POST['lblextraautorizado']);   
$formadepago= htmlspecialchars($_POST['lblformadepago']);  
$n590= htmlspecialchars($_POST['lbl590']);   
$PAI= htmlspecialchars($_POST['lblPAI']);   


$fecharegistroagenda = date("Y-m-d H:i:s");  
$fecharegistrofacturacion = date("Y-m-d H:i:s");
$fecharegistroventa = date("Y-m-d H:i:s");
$fecharegistro=date("Y-m-d H:i:s");

$nombcliente= htmlspecialchars($_POST['lblnombcliente']);
$telefonouno= htmlspecialchars($_POST['lblmovil']);
$telefonodos= htmlspecialchars($_POST['lblfijo']);
$correo= htmlspecialchars($_POST['lblcorreo']);
$idusuario= htmlspecialchars($_POST['lblidusuario']);
$resumenventa= htmlspecialchars($_POST['lblresumenventa']);

$idcliente= htmlspecialchars($_POST['lblidcliente']);
$idventa= htmlspecialchars($_POST['lblidventa']);

//NUEVAS VARIABLES POST PARA GRABAR AL LOG DE ESTADOS
$matriculacomercial= htmlspecialchars($_POST['matriculacomercial']);
$cccomercial= htmlspecialchars($_POST['cccomercial']);
$matriculajefe= htmlspecialchars($_POST['matriculajefe']);
$tcgestor= htmlspecialchars($_POST['tcgestor']);

//Facturacion


$fecharecpciondoc= htmlspecialchars($_POST['lblfecharecpciondoc']);

if(isset($_POST['lblfechafacturacion'])){
    $fechafacturacion= htmlspecialchars($_POST['lblfechafacturacion']);
} else {
    $fechafacturacion='';
}
$fechaconvertrecpciondoc=  myUrlEncode($fecharecpciondoc);
$fechagrabarrecpciondoc=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertrecpciondoc));

$fechaconvertfacturacion=  myUrlEncode($fechafacturacion);
$fechagrabarfacturacion= format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfacturacion));

//FORMATO COMPARAR FECHAS
if($fechafacturacion != ''){
    $fechacomparafacturacion = $fechagrabarrecpciondoc;
} else {
    $fechacomparafacturacion = '';
}
//FECHA COMPARAR FECHAS
if($fecharecpciondoc != ''){
    $fechacompararecpciondoc = $fechagrabarrecpciondoc;
} else {
    $fechacomparafacturacion = '';
}

$motivoincidencia= htmlspecialchars($_POST['lblmotivoincidencia']);    //Facturacion  

$factdocoriginal= htmlspecialchars($_POST['lblfactdocoriginal']);  
$factsegmentacion= htmlspecialchars($_POST['lblfactsegmentacion']);  
$factpago= htmlspecialchars($_POST['lblfactpago']);   
$factautoriza= htmlspecialchars($_POST['lblfactautoriza']);   
$factdni= htmlspecialchars($_POST['lblfactdni']);   
$factelementosctops= htmlspecialchars($_POST['lblfactelementosctops']);   
$factdocpai= htmlspecialchars($_POST['lblfactdocpai']);   
$factfaltadoc= htmlspecialchars($_POST['lblfactfaltadoc']);   
$factrehacercto= htmlspecialchars($_POST['lblfactrehacercto']);   
$factafiliacion= htmlspecialchars($_POST['lblfactafiliacion']);   
$factprospecto_nroguia= htmlspecialchars($_POST['lblfactprospecto_nroguia']);   
$factfuerahora= htmlspecialchars($_POST['lblfactfuerahora']);   
$factscoring= htmlspecialchars($_POST['lblfactscoring']);   
$factvalidarpago= htmlspecialchars($_POST['lblfactvalidarpago']);    
$factvigenciapoder= htmlspecialchars($_POST['lblfactvigenciapoder']);    
$factfirma= htmlspecialchars($_POST['lblfactfirma']);    
//Nuevos datos Scoring
$lblautoscoring= htmlspecialchars($_POST['lblautoscoring']);   
$lblformapagocuota= htmlspecialchars($_POST['lblformapagocuota']);   
$lbldocumentoibs= htmlspecialchars($_POST['lbldocumentoibs']);    
$lbltipocomprobante= htmlspecialchars($_POST['lbltipocomprobante']);    
$lblinfogroup= htmlspecialchars($_POST['lblinfogroup']);   
$lblncarrera= htmlspecialchars($_POST['lblncarrera']);   
$lblcomentariofacturacion= htmlspecialchars($_POST['lblcomentariofacturacion']);    
$lbldireccionfical= htmlspecialchars($_POST['lbldireccionfical']);    
$lblcodwoinst= htmlspecialchars($_POST['lblcodwoinst']);   
$lblresultadodocumento= htmlspecialchars($_POST['lblresultadodocumento']);   

$lblfactcertificacion= htmlspecialchars($_POST['lblfactcertificacion']);   
$lblfactautorizacionprecio= htmlspecialchars($_POST['lblfactautorizacionprecio']);   
$lblfactautorizacionregalo= htmlspecialchars($_POST['lblfactautorizacionregalo']);    
$lblfactautorizacionoferta= htmlspecialchars($_POST['lblfactautorizacionoferta']);  

$FormatoContrato = htmlspecialchars($_POST['formatoContrato']);   
// $lblcontratodigital= htmlspecialchars($_POST['lblcontratodigital']);
// $lblpapel= htmlspecialchars($_POST['lblpapel']);
// $lblcontratodigitalconformulario= htmlspecialchars($_POST['lblcontratodigitalconformulario']);

// if ($lblcontratodigital == "on"){
//     $FormatoContrato = "DIGITAL";
// }else if ($lblpapel == "on"){
//     $FormatoContrato = "PAPEL";
// }else if($lblcontratodigitalconformulario == "on"){
//     $FormatoContrato = "DIGITALCONFORMULARIO";
// }


if($PAI=="PAI 30x36"){

$ingresokit=round((($preciokit+(1080*0.729))/1.18),2);
$ingresoextras=round(($totalextra/1.18),2);
$ingresototal=($ingresokit+$ingresoextras);

}else{

$ingresokit=round((($preciokit)/1.18),2);
$ingresoextras=round(($totalextra/1.18),2);
$ingresototal=($ingresokit+$ingresoextras);

}

//FUNCION QUE DEVUELVE ARRAY DE DATOS DEL CLIENTE
$resultadoCliente = consultaCliente($idcliente);
//FUNCION QUE DEVUELVE ARRAY DE DATOS DEL CLIENTE
$resultadoFactuVen = consultaFacturacionVenta($idventa);
if(isset($ncontrato) && !empty($ncontrato) && $ncontrato <> $resultadoFactuVen['NContrato']){
   if(validarNContrato($ncontrato) > 0){
        die('2');
    }
}

try{
    $sqlcliente= $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente c SET c.IdGeografico=?,c.NombApellido=? ,c.Segmento=? ,c.Telefonouno=? ,c.Telefonodos=? ,c.Correo=? ,c.Direccion=? ,c.NCliente=? ,c.DireccionFiscal=? WHERE c.IdCliente=?");
    $sqlcliente->bind_param('issssssssi',$distrito,$nombcliente,$segmento,$telefonouno,$telefonodos,$correo,$direccion,$ncontrato,$lbldireccionfical,$idcliente);
    $sqlcliente->execute();
    //VALIDA QUE SE ACTUALIZARON DATOS DEL CLIENTE
    $affectedrowcliente = $sqlcliente->affected_rows;
    // $sqlcliente->close();
} catch(\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
}

try{
    $sqlventa= $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa v SET v.CC = ?,v.TipoVenta = ?,v.Segmento = ?,v.NProspecto = ?,v.NContrato = ?,v.PrecioKit = ?,v.TotalExtra = ?,v.IngresoKIT = ?,v.IngresoExtras = ?,v.IngresoTotal = ?,v.EstadoVenta = ?,v.ExtraAutorizado = ?,v.MesesAutorizado = ?,v.N590 = ?,v.FormaPago = ?,v.PAI = ?,v.ResumenVenta = ?,v.IMP = ?,v.FormaPagoCuota = ?,v.AutorizacionScoring = ? WHERE v.IdVenta = ?");
    $sqlventa->bind_param('issssdddddssdsssssssi',$dc,$tipoventa,$segmento,$nprospecto,$ncontrato,$preciokit,$totalextra,$ingresokit,$ingresoextras,$ingresototal,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$imp,$lblformapagocuota,$lblautoscoring,$idventa);
    $sqlventa->execute();
    $affectedrowFactuVen = $sqlventa->affected_rows;
    $sqlventa->close();
} catch(\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
}
//VALIDACION DE FACTURADA AL PORFOLIO
if($estadoventa=="Facturada" || $estadoventa=="PorFacturar"){
    $insertporfolio=insertarPortafolio();
}


//FUNCION QUE DEVUELVE ARRAY DE DATOS DE FACTURACION EN TABLA FACTURACION
$resultadoFacturacion = consultaFacturacion($idventa);
if(empty($fecharecpciondoc) && empty($fechafacturacion) ){
    try{
        $sqlfacturacion= $con->prepare("UPDATE yifi58ge_dbVENTAS.tblfacturacion f SET f.MotivoIncidencia=?,f.DOCOriginal=?,f.Segmentacion=?,f.Pago=?,f.Autoriza=?,f.DNI=?,f.ElementosCTOPS=?,f.DOCPAI=?,f.FaltaDOC=?,f.RehacerCTO=?,f.Afiliacion=?,f.Prospecto_NroGuia=?,f.FueraHora=?,f.Scoring=?,f.DocumentoIBS=?,f.ResultadoValidacion=?,f.ValidarPago=?,f.VigenciaPoder=?,f.Firma=?,f.TipoComprobante=?,f.InfoGroup=?,f.NCarrera=?,f.Comentario=?,f.Cod_WO_Inst=?,f.Certificacion=?,f.Autorizacion_Precio=?,f.Autorizacion_Regalo=?,f.Autorizacion_Oferta=?,f.FormatoContrato=? WHERE f.IdVenta=?");
        $sqlfacturacion->bind_param('sssssssssssssssssssssisssssssi',$motivoincidencia,$factdocoriginal,$factsegmentacion,$factpago,$factautoriza,$factdni,$factelementosctops,$factdocpai,$factfaltadoc,$factrehacercto,$factafiliacion,$factprospecto_nroguia,$factfuerahora,$factscoring,$lbldocumentoibs,$lblresultadodocumento,$factvalidarpago,$factvigenciapoder,$factfirma,$lbltipocomprobante,$lblinfogroup,$lblncarrera,$lblcomentariofacturacion,$lblcodwoinst,$lblfactcertificacion,$lblfactautorizacionprecio,$lblfactautorizacionregalo,$lblfactautorizacionoferta,$FormatoContrato,$idventa);
        $sqlfacturacion->execute();
        $affectedrowFact = $sqlfacturacion->affected_rows;
        $sqlfacturacion->close();
    } catch(\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
    }
}

else if(empty($fechafacturacion)){
    try{
        $sqlfacturacion= $con->prepare("UPDATE yifi58ge_dbVENTAS.tblfacturacion f SET f.MotivoIncidencia=?,f.FechaRecepcionDOC=?,f.DOCOriginal=?,f.Segmentacion=?,f.Pago=?,f.Autoriza=?,f.DNI=?,f.ElementosCTOPS=?,f.DOCPAI=?,f.FaltaDOC=?,f.RehacerCTO=?,f.Afiliacion=?,f.Prospecto_NroGuia=?,f.FueraHora=?,f.Scoring=?,f.DocumentoIBS=?,f.ResultadoValidacion=?,f.ValidarPago=?,f.VigenciaPoder=?,f.Firma=?,f.TipoComprobante=?,f.InfoGroup=?,f.NCarrera=?,f.Comentario=?,f.Cod_WO_Inst=?,f.Certificacion=?,f.Autorizacion_Precio=?,f.Autorizacion_Regalo=?,f.Autorizacion_Oferta=?,f.FormatoContrato=? WHERE f.IdVenta=?");
        $sqlfacturacion->bind_param('ssssssssssssssssssssssisssssssi',$motivoincidencia,$fechagrabarrecpciondoc,$factdocoriginal,$factsegmentacion,$factpago,$factautoriza,$factdni,$factelementosctops,$factdocpai,$factfaltadoc,$factrehacercto,$factafiliacion,$factprospecto_nroguia,$factfuerahora,$factscoring,$lbldocumentoibs,$lblresultadodocumento,$factvalidarpago,$factvigenciapoder,$factfirma,$lbltipocomprobante,$lblinfogroup,$lblncarrera,$lblcomentariofacturacion,$lblcodwoinst,$lblfactcertificacion,$lblfactautorizacionprecio,$lblfactautorizacionregalo,$lblfactautorizacionoferta,$FormatoContrato,$idventa);
        $sqlfacturacion->execute();
        $affectedrowFact = $sqlfacturacion->affected_rows;
        $sqlfacturacion->close();
    } catch(\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
    }
}
else if(empty($fecharecpciondoc)){
    try{
        $sqlfacturacion= $con->prepare("UPDATE yifi58ge_dbVENTAS.tblfacturacion f SET f.MotivoIncidencia=?,f.FechaFacturacion=?,f.DOCOriginal=?,f.Segmentacion=?,f.Pago=?,f.Autoriza=?,f.DNI=?',f.ElementosCTOPS='?,f.DOCPAI=?,f.FaltaDOC=?,f.RehacerCTO=?,f.Afiliacion=?,f.Prospecto_NroGuia=?,f.FueraHora=?,f.Scoring=?,f.DocumentoIBS=?,f.ResultadoValidacion=?,f.ValidarPago=?,f.VigenciaPoder=?,f.Firma=?,f.TipoComprobante=?,f.InfoGroup=?,f.NCarrera=?,f.Comentario=?,f.Cod_WO_Inst=?,f.Certificacion=?,f.Autorizacion_Precio=?,f.Autorizacion_Regalo=?,f.Autorizacion_Oferta=?,f.FormatoContrato=? WHERE f.IdVenta=?");
        $sqlfacturacion->bind_param('ssssssssssssssssssssssisssssssi',$motivoincidencia,$fechagrabarfacturacion,$factdocoriginal,$factsegmentacion,$factpago,$factautoriza,$factdni,$factelementosctops,$factdocpai,$factfaltadoc,$factrehacercto,$factafiliacion,$factprospecto_nroguia,$factfuerahora,$factscoring,$lbldocumentoibs,$lblresultadodocumento,$factvalidarpago,$factvigenciapoder,$factfirma,$lbltipocomprobante,$lblinfogroup,$lblncarrera,$lblcomentariofacturacion,$lblcodwoinst,$lblfactcertificacion,$lblfactautorizacionprecio,$lblfactautorizacionregalo,$lblfactautorizacionoferta,$FormatoContrato,$idventa);
        $sqlfacturacion->execute();
        $affectedrowFact = $sqlfacturacion->affected_rows;
        $sqlfacturacion->close();
    } catch(\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
    }
}
else{
    try{
        $sqlfacturacion= $con->prepare("UPDATE yifi58ge_dbVENTAS.tblfacturacion f SET f.MotivoIncidencia=?,f.FechaRecepcionDOC=?,f.FechaFacturacion=?,f.DOCOriginal=?,f.Segmentacion=?,f.Pago=?,f.Autoriza=?,f.DNI=?,f.ElementosCTOPS=?,f.DOCPAI=?,f.FaltaDOC=?,f.RehacerCTO=?,f.Afiliacion=?,f.Prospecto_NroGuia=?,f.FueraHora=?,f.Scoring=?,f.DocumentoIBS=?,f.ResultadoValidacion=?,f.ValidarPago=?,f.VigenciaPoder=?,f.Firma=?,f.TipoComprobante=?,f.InfoGroup=?,f.NCarrera=?,f.Comentario=?,f.Cod_WO_Inst=?,f.Certificacion=?,f.Autorizacion_Precio=?,f.Autorizacion_Regalo=?,f.Autorizacion_Oferta=?,f.FormatoContrato=? WHERE f.IdVenta=? ");
        $sqlfacturacion->bind_param('sssssssssssssssssssssssisssssssi',$motivoincidencia,$fechagrabarrecpciondoc,$fechagrabarfacturacion,$factdocoriginal,$factsegmentacion,$factpago,$factautoriza,$factdni,$factelementosctops,$factdocpai,$factfaltadoc,$factrehacercto,$factafiliacion,$factprospecto_nroguia,$factfuerahora,$factscoring,$lbldocumentoibs,$lblresultadodocumento,$factvalidarpago,$factvigenciapoder,$factfirma,$lbltipocomprobante,$lblinfogroup,$lblncarrera,$lblcomentariofacturacion,$lblcodwoinst,$lblfactcertificacion,$lblfactautorizacionprecio,$lblfactautorizacionregalo,$lblfactautorizacionoferta,$FormatoContrato,$idventa);
        $sqlfacturacion->execute(); 
        $affectedrowFact = $sqlfacturacion->affected_rows;
        $sqlfacturacion->close();
    } catch(\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
    }
}

$Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
$Usuario = htmlspecialchars($_SESSION['usuariosesion']);
$Url = sanitizaCampo($_SERVER['REQUEST_URI'], 'sanitizeurl|scapestring|htmlspecialchars',$con);
if(!empty($Url)){
    $UrlLog = $Url.'=>IdVenta='.$idventa;
}
$Modificar = 'Modificar';
$Navegador = htmlspecialchars($_SERVER['HTTP_USER_AGENT']);

try{
    $result_exec= $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
    $result_exec->bind_param('ssssss',$Ip,$Usuario,$fecharegistro,$UrlLog,$Modificar,$Navegador);
    $result_exec->execute();
    $idLogSeg = $con->insert_id;
    $result_exec->close();
} catch(\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
}

$rep=0;

if ($affectedrowcliente > 0) {
    insertarLog($idLogSeg, $resultadoCliente);
    $rep=1;
}
if ($affectedrowFactuVen > 0) {
    insertLogFactuVenta($idLogSeg, $resultadoFactuVen);
    $rep=1;
}
if ($affectedrowFact > 0 ){
    insertLogFacutracion($idLogSeg, $resultadoFacturacion);
    $rep=1;
}

echo $rep;


unset($resultadoCliente);
unset($resultadoFactuVen);
unset($resultadoFacturacion);




function insertarPortafolio(){
    
    global $con;
    
    global $idcliente;
    global $EstadoMonitoring;
    global $EstadoBilling;
    global $UsuarioREG;
    global $fecharegistro;
    
    $EstadoMonitoring="OP";
    $EstadoBilling="CUOP";
    $UsuarioREG=$_SESSION['usuariosesion'];

    try {
        
        $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblporfolio(IdCliente, EstadoMonitoring, EstadoBilling, UsuarioREG, FechaHoraREG) VALUES(?, ?, ?, ?, ?) ");
        $stmt->bind_param('issss',  $idcliente, $EstadoMonitoring, $EstadoBilling, $UsuarioREG, $fecharegistro);
        $stmt->execute();
        
        $respuesta = $con->insert_id;

        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
}

function validarNContrato($val){
    global $con;
    try{
        $sql = $con->prepare("SELECT 1 FROM yifi58ge_dbVENTAS.tblcliente WHERE NCliente =?");
        $sql->bind_param('s',$val);
        $sql->execute();
        $sql->store_result();
        $sql->bind_result($num);        
        $row_cnt = $sql->num_rows;
        $sql->fetch();
        $sql->close();
        
    } catch (\Exception $e) {
        $row_cnt = 0;
    }
    
    return $row_cnt;
    
}


