<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}


require '../config/db.php';
require '../config/conexion.php';
//FUNCIONES LOG
//include 'log/insertLog.php'; //LOG TRANSAC
//include 'log/insertLogCliente.php'; //LOG CLIENTE
//include 'log/insertLogVenta.php'; //LOG VENTA
//include 'log/insertLogAgenda.php'; //LOG AGENDA

//FUNCIONES DE VENTA
//include 'funciones/Venta.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

$idventaActual=htmlspecialchars($_POST['idventaActual']);
$idventaCambio=htmlspecialchars($_POST['idventaCambio']);
$gestor=htmlspecialchars($_POST['gestor']);
$estvisita="Vendida";

$ingresokit=0;
$ingresoextras=0;
$ingresototal=0;
$fecharegistroventa = date("Y-m-d H:i:s");

    try{
        $stmt = $con->prepare( "SELECT 
    u.IdUsuario,
    v.Matricula,
    v.Comercial,
    v.CC,
    v.JefeVenta,
    CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
    v.EstadoVenta,
    v.CategoriaVenta,
    v.TipoVenta,
    v.Segmento,
    v.MesesAutorizado,
    v.NProspecto,
    v.NContrato,
    v.IdCliente,
    c.NombApellido Cliente,
    c.Correo,
    c.Telefonouno,
    c.Telefonodos,
    c.Direccion,
    g.IdGeografico,
    g.Distrito,
    g.Provincia,
    v.PrecioKit,
    v.TotalExtra,
    v.ResumenVenta,
    v.ExtraAutorizado,
    v.FormaPago,
    v.N590,
    v.PAI,
    v.EstadoVisita,
    v.CCOriginal,
    v.ContactadoCO,
    v.ComentarioCO,
    v.VTAConfirmadaCO,
    agen.IdAgenda,
    agen.InstaladoX,
    agen.MatriculaTec,
    CONCAT(t.Nombres,' ',t.Apellidos) Instalador,
    t.LN LNInstalador,
    agen.FechaInst, 
    agen.HoraInst,
    agen.Comentario,
    agen.MotivoInviable,
    agen.MotivoCancelada,
    agen.Repercusion,
    f.MotivoIncidencia,
    f.FechaRecepcionDOC,
    f.FechaFacturacion,
    f.DOCOriginal,
    f.Segmentacion,
    f.Pago,
    f.Autoriza,
    f.DNI,
    f.ElementosCTOPS,
    f.DOCPAI,
    f.FaltaDOC,
    f.RehacerCTO,
    f.Afiliacion,
    f.Prospecto_NroGuia,
    f.FueraHora,
    f.Scoring,
    f.DocumentoIBS,
    f.ResultadoValidacion,
    f.ValidarPago,
    f.VigenciaPoder,
    f.Firma,
    f.TipoComprobante,
    f.InfoGroup,
    f.NCarrera,
    f.Comentario as ComentarioFact,
    f.Cod_WO_Inst,
    v.TipoKIT,
    v.CantidadExtras,
    v.ClosingPack,
    v.ScoringRP,
    v.PrecioEspecial,
    v.HojaCertificacion,
    v.IdConsultaScoringRP,
    c.IdDocRP,
    v.GGCC,
    v.RegalosAutorizados,
    v.CantidadRegalo,
    sc.NumeroDocumento as DocumentoScoring,
    CASE WHEN sc.TipoDocumento=6 THEN sc.RazonSocial ELSE CONCAT(sc.Nombres,' ',sc.ApellidoPaterno,' ',sc.ApellidoMaterno) END as NombreScoring,
    sc.FechaHoraReg,
    sc.Servicio,
    sc.NumeroOperacion,
    sc.CodigoModelo,
    sc.TipoDocumento,
    sc.NumeroDocumento,
    sc.ApellidoPaterno,
    sc.ApellidoMaterno,
    sc.Nombres,
    sc.RazonSocial,
    sc.Explicacion,
    sc.Accion,
    sc.Score,
    sc.Riesgo,
    sc.Conclusion,
    sc.ultPeriodo,
    sc.TotalultPeriodo,
    sc.DeudaSoles,
    sc.DeudaDolares,
    sc.TotalDeudaSoles,
    sc.TotalDeudaDolares,
    sc.CodigoOficina,
    sc.GestorOrigen,
    sc.NombreGestorOrigen,
    sc.Integrante,
    sc.TipoPersona,
    sc.CantidadDocumentosMorosos,
    sc.ScoreRiesgo_PN,
    sc.PredictorIngresos_IP,
    sc.ScoreRiesgo_PJ,
    sc.MontoMorosoSoles,
    sc.MontoMorosoDolares,
    sc.PerfilScoring,
    sc.CodGenVen,
    sc.Departamental,
    sc.Provincial,
    sc.Distrital,
    sc.Ubigeo,
    sc.Area,
    sc.IdConsultaScoring,
    v.IMP,
    v.IdProspectoRP,
    v.CategoriaPrecio,
    v.dsctCuota,
    v.TipoCamaraKit,
    v.SegundaAlarma,
    v.TotalCuotaMonitoreo,
    vc.DetalleExtras,
    vc.DetalleRegalos,
    vc.DetalleGeneral,
    att.IdAttec,
    att.FechaAuditoria,
    att.EstadoAttec,
    att.DatosSbn,
    att.DatosSbn_NoCoincide,
    att.F_CorreccionDatosSbn,
    att.SegIncorrecto,
    att.F_CorreccionSegIncorrecto,
    att.Seg_DebeDecir,
    att.Imagen,
    att.F_Imagen,
    att.Imagen_Motivo,
    att.IngresoProgramacion,
    att.F_CorreccionIngresoProgramacion,
    att.FallosCobertura,
    att.F_CorreccionFallosCobertura,
    att.MissingTest,
    att.F_CorreccionMissingTest,
    att.ZeroVision,
    att.F_CorreccionZeroVision,
    att.FalloSupervision,
    att.F_CorreccionFalloSupervision,
    att.FalloSupervision_Dispotivos,
    att.Tamper,
    att.F_CorreccionTamper,
    att.Tamper_Dispotivos,
    att.Comentario as ComentarioAttec,
    att.Zerovision_motivo    
    FROM yifi58ge_dbVENTAS.tblventa v 
    INNER JOIN yifi58ge_dbUSUARIO.tblusuario u on v.IdUsuario=u.IdUsuario 
    INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
    INNER JOIN yifi58ge_dbUSUARIO.tblusuario m on m.Matricula=u.Manager
    INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
    INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
    INNER JOIN yifi58ge_dbVENTAS.tblagenda agen on agen.IdVenta=v.IdVenta
    INNER JOIN yifi58ge_dbVENTAS.tblfacturacion f on f.IdVenta=v.IdVenta
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario t on t.Matricula=agen.MatriculaTec
    LEFT JOIN yifi58ge_dbVENTAS.tbltmpscoring sc on sc.IdConsultaScoring=v.IdConsultaScoringRP
    LEFT JOIN yifi58ge_dbVENTAS.tblventacotizacion vc on vc.IdVenta=v.IdVenta
    LEFT JOIN yifi58ge_dbVENTAS.tblattec att on att.IdVenta=v.IdVenta
    WHERE v.IdVenta=?");
        $stmt->bind_param('i', $idventaActual);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($idusuario,
$matricula,
$nombcomercial,
$dc,
$jefeventa,
$NombJefeVenta,
$estadoventa,
$categoria,
$tipoventa,
$segmento,
$mesesautorizados,
$nprospecto,
$ncontrato,
$idcliente,
$cliente,
$correo,
$telefonouno,
$telefonodos,
$direccion,
$distrito,
$DistritoRow,
$provincia,
$preciokit,
$totalextra,
$resumenventa,
$extraautorizado,
$formadepago,
$n590,
$PAI,
$estadovisita,
$CCOriginal,
$hidden_contactadoco,
$comentarioco,
$hidden_ventaconfirmadaco,
$idagenda,
$instaladox,
$tecnico,
$nomreinstalador,
$lninstalador,
$fechagrabar,
$horagrabar,
$comentarioagenda,
$inviable,
$motivocancelado,
$repercucion,
$motivoincidencia,
$fechagrabarrecpciondoc,
$fechagrabarfacturacion,
$factdocoriginal,
$factsegmentacion,
$factpago,
$factautoriza,
$factdni,
$factelementosctops,
$factdocpai,
$factfaltadoc,
$factrehacercto,
$factafiliacion,
$factprospecto_nroguia,
$factfuerahora,
$factscoring,
$lbldocumentoibs,
$lblresultadodocumento,
$factvalidarpago,
$factvigenciapoder,
$factfirma,
$lbltipocomprobante,
$lblinfogroup,
$lblncarrera,
$lblcomentariofacturacion,
$lblcodwoinst,
$lbltipokit,
$lblCantExtras,
$lblclosingpack,
$lblresultadoScoring,
$lblprecioespecial,
$hidden_HCertificacion,
$IdConsultaScoringRP,
$IdDocRP,
$hidGGCC,
$RegalosAutorizados,
$CantidadRegalo,
$DocumentoScoring,
$NombreScoring,
$FechaHoraReg,
$Servicio,
$NumeroOperacion,
$CodigoModelo,
$TipoDocumento,
$NumeroDocumento,
$ApellidoPaterno,
$ApellidoMaterno,
$Nombres,
$RazonSocial,
$Explicacion,
$Accion,
$Score,
$Riesgo,
$Conclusion,
$ultPeriodo,
$TotalultPeriodo,
$DeudaSoles,
$DeudaDolares,
$TotalDeudaSoles,
$TotalDeudaDolares,
$CodigoOficina,
$GestorOrigen,
$NombreGestorOrigen,
$Integrante,
$TipoPersona,
$CantidadDocumentosMorosos,
$ScoreRiesgo_PN,
$PredictorIngresos_IP,
$ScoreRiesgo_PJ,
$MontoMorosoSoles,
$MontoMorosoDolares,
$PerfilScoring,
$CodGenVen,
$Departamental,
$Provincial,
$Distrital,
$Ubigeo,
$Area,
$IdConsultaScoring,
$IMP,
$IdProspectoRP,
$CategoriaPrecio,
$dsctCuota,
$TipoCamaraKit,
$SegundaAlarma,
$TotalCuotaMonitoreo,
$DetalleExtras,
$DetalleRegalos,
$DetalleGeneral,
$idattec,
$lblfechaautidoria,
$lblestadoattec,
$hidden_datossbn,
$lbldatossbncorreccion,
$lblfechacorrecion_datossbn,
$hidden_segincorrecto,
$lblfechacorrecion_segincorrecto,
$lblsegmentocorreccion,
$hidden_imagen,
$lblfechacorrecion_imagen,
$lblimagen_motivo,
$hidden_ingresoprogramacion,
$lblfechacorrecion_ingresoprogramacion,
$hidden_falloscomunicacion,
$lblfechacorrecion_falloscomunicacion,
$hidden_missingtest,
$lblfechacorrecion_missingtest,
$hidden_zerovision,
$lblfechacorrecion_zerovision,
$hidden_fallosupervision,
$lblfechacorrecion_fallosupervision,
$detalleFallosSupervision,
$hidden_tamper,
$lblfechacorrecion_tamper,
$detalleTamper,
$comentarioattec,
$lblzerovisioncorreccion);
        $stmt->fetch();
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }


   try{
        $stmtventaR = $con->prepare( "SELECT 
    u.IdUsuario,
    v.Matricula,
    v.Comercial,
    v.CC,
    v.JefeVenta,
    CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
    v.EstadoVenta,
    v.CategoriaVenta,
    v.TipoVenta,
    v.Segmento,
    v.MesesAutorizado,
    v.NProspecto,
    v.NContrato,
    v.IdCliente,
    c.NombApellido Cliente,
    c.Correo,
    c.Telefonouno,
    c.Telefonodos,
    c.Direccion,
    g.IdGeografico,
    g.Distrito,
    g.Provincia,
    v.PrecioKit,
    v.TotalExtra,
    v.ResumenVenta,
    v.ExtraAutorizado,
    v.FormaPago,
    v.N590,
    v.PAI,
    v.EstadoVisita,
    v.CCOriginal,
    v.ContactadoCO,
    v.ComentarioCO,
    v.VTAConfirmadaCO,
    agen.IdAgenda,
    agen.InstaladoX,
    agen.MatriculaTec,
    CONCAT(t.Nombres,' ',t.Apellidos) Instalador,
    t.LN LNInstalador,
    agen.FechaInst, 
    agen.HoraInst,
    agen.Comentario,
    agen.MotivoInviable,
    agen.MotivoCancelada,
    agen.Repercusion,
    f.MotivoIncidencia,
    DATE_FORMAT(f.FechaRecepcionDOC, '%d/%m/%Y') FechaRecepcionDOC,
    DATE_FORMAT(f.FechaFacturacion, '%d/%m/%Y') FechaFacturacion,
    f.DOCOriginal,
    f.Segmentacion,
    f.Pago,
    f.Autoriza,
    f.DNI,
    f.ElementosCTOPS,
    f.DOCPAI,
    f.FaltaDOC,
    f.RehacerCTO,
    f.Afiliacion,
    f.Prospecto_NroGuia,
    f.FueraHora,
    v.TipoKIT,
    v.CantidadExtras,
    v.ClosingPack,
    v.ScoringRP,
    v.PrecioEspecial,
    v.HojaCertificacion,
    c.IdDocRP,
    v.GGCC,
    v.RegalosAutorizados,
    v.CantidadRegalo,
    sc.NumeroDocumento as DocumentoScoring,
    CASE WHEN sc.TipoDocumento=6 THEN sc.RazonSocial ELSE CONCAT(sc.Nombres,' ',sc.ApellidoPaterno,' ',sc.ApellidoMaterno) END as NombreScoring,
    att.IdAttec,
    v.IdConsultaScoringRP
    FROM yifi58ge_dbVENTAS.tblventa v 
    INNER JOIN yifi58ge_dbUSUARIO.tblusuario u on v.IdUsuario=u.IdUsuario 
    INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
    INNER JOIN yifi58ge_dbUSUARIO.tblusuario m on m.Matricula=u.Manager
    INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
    INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
    INNER JOIN yifi58ge_dbVENTAS.tblagenda agen on agen.IdVenta=v.IdVenta
    INNER JOIN yifi58ge_dbVENTAS.tblfacturacion f on f.IdVenta=v.IdVenta
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario t on t.Matricula=agen.MatriculaTec
    LEFT JOIN yifi58ge_dbVENTAS.tbltmpscoring sc on sc.IdConsultaScoring=v.IdConsultaScoringRP
    LEFT JOIN yifi58ge_dbVENTAS.tblattec att on att.IdVenta=v.IdVenta
    WHERE v.IdVenta=?");
        $stmtventaR->bind_param('i', $idventaCambio);
        $stmtventaR->execute();
        $stmtventaR->store_result();
        $stmtventaR->bind_result($iduR,
            $matriculaR,
            $comercialR,
            $dcR,
            $matjefeR,
            $jefeventaR,
            $estadoventaR,
            $categoriaR,
            $tipoventaR,
            $segmentoR,
            $mesesautorizadosR,
            $nprospectoR,
            $ncontratoR,
            $idclienteR,
            $clienteR,
            $correoR,
            $movilR,
            $fijoR,
            $direccionR,
            $idgeograficoR,
            $distritoR,
            $provinciaR,
            $preciokitR,
            $totalextraR,
            $resumenventaR,
            $extraautorizadoR,
            $formadepagoR,
            $n590R,
            $PAIR,
            $estadovisitaR,
            $CCOriginalR,
            $hidden_contactadocoR,
            $comentariocoR,
            $hidden_ventaconfirmadacoR,
            $idagendaR,
            $instaladoxR,
            $matriculatecR,
            $nomreinstaladorR,
            $lninstaladorR,
            $fechainstalacionverR,
            $horainstalacionverR,
            $comentarioagendaR,
            $motivoinviableR,
            $motivocanceladoR,
            $repercucionR,
            $factmotivoincidenciaR,
            $factfecharecepciondocR,
            $factfechafacturacionR,
            $factdocoriginalR,
            $factsegmentacionR,
            $factpagoR,
            $factautorizaR,
            $factdniR,
            $factelementosctopsR,
            $factdocpaiR,
            $factfaltadocR,
            $factrehacerctoR,
            $factafiliacionR,
            $factprospecto_nroguiaR,
            $factfuerahoraR,
            $lbltipokitR,
            $lblCantExtrasR,
            $lblclosingpackR,
            $lblresultadoScoringR,
            $lblprecioespecialR,
            $hidden_HCertificacionR,
            $IdDocRPR,
            $hidGGCCR,
            $RegalosAutorizadosR,
            $CantidadRegaloR,
            $DocumentoScoringR,
            $NombreScoringR,
            $idattecR,
            $IdConsultaScoringRPR);
        $stmtventaR->fetch();
	    
        $stmtventaR->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

//DECLARACION DE VARIABLES CON PAI Y SIN PAI
if($PAI=="PAI 30x36"){
    $ingresokit=round((($preciokit+1080)/1.18),2);
    $ingresoextras=round(($totalextra/1.18),2);
    $ingresototal=($ingresokit+$ingresoextras);
}
else{
    $ingresokit=round((($preciokit)/1.18),2);
    $ingresoextras=round(($totalextra/1.18),2);
    $ingresototal=($ingresokit+$ingresoextras);
}

        //SCORING
        //DOCUMENTO
                if ($IdDocRPR == NULL){
                     $resultadoDocumento = insertarDocumento($TipoDocumento,$NumeroDocumento,$fecharegistroventa);
                     if ($resultadoDocumento > 0){
                     $IdDocRPR=$resultadoDocumento;
                     }else{
                     $IdDocRPR=NULL;  
                     }
                     
                }else{
                    $resultadoDocumento = actualizarDocumento($TipoDocumento,$NumeroDocumento,$IdDocRPR);
                    if ($resultadoDocumento > 0){
                    }else{
                    }
                }


            

        //$arrayVenta = consultaVenta_General($idventa);
        //$arrayAgenda = consultaAgenda($idventa);
        //ACTUALIZA DATOS DE LA TABLA VENTA SIN SEGMENTO Y NPROSPECTO

        //REFERIDOS
        $referidoHabilitado=NULL;
        $idreferido=obtenerIdReferido($IdProspectoRP);
        if($idreferido>0){
            $referidoHabilitado='SI';
            actualizarReferido($idreferido,$idventaCambio,$tipoventaR);
        }

        //TRASPASO ACTUAL AL NUEVO
        $resultadoventa = actualizarVenta($idventaCambio);
                //ACTUALIZAR IDVENTA EN SCORING
        
            try{
                $stmtSco = $con->prepare( "UPDATE yifi58ge_dbVENTAS.tbltmpscoring t SET t.IdVenta=? WHERE t.IdConsultaScoring=?");
                $stmtSco->bind_param('ii', $idventaCambio,$IdConsultaScoring);
                $stmtSco->execute();
        	    $sqlidscoring = $stmtSco->affected_rows;
                $stmtSco->close();
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }
                
        //ANULAR ESTADO Y CONTRATO
        //ACTUALIZA DATOS EN LA TABLA VENTA
            $auxEstadoVenta='NoVendida';
            $auxCategoriaVenta='NoVendida';
            $auxNContrato=NULL;
            $auxIdConsultaScoringRP=NULL;
            
            try{
                $stmtVen = $con->prepare( "UPDATE yifi58ge_dbVENTAS.tblventa v SET v.EstadoVenta=?,v.CategoriaVenta=?,v.NContrato=?,IdConsultaScoringRP=? WHERE v.IdVenta=?");
                $stmtVen->bind_param('sssii', $auxEstadoVenta,$auxCategoriaVenta,$auxNContrato,$auxIdConsultaScoringRP,$idventaActual);
                $stmtVen->execute();
        	    $sqlventa = $stmtVen->affected_rows;
                $stmtVen->close();
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }
            
            //ACTUALIZA NCLIENTE O NCONTRATO EN TBLCLIENTE
            
            try{
                $stmtClienteContrato = $con->prepare( "UPDATE yifi58ge_dbVENTAS.tblcliente c SET c.NCliente=? WHERE c.IdCliente=?");
                $stmtClienteContrato->bind_param('si',$auxNContrato,$idcliente);
                $stmtClienteContrato->execute();
        	    $sqlclientecontrato = $stmtClienteContrato->affected_rows;
                $stmtClienteContrato->close();
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }
        
        //ASIGNAR CONTRATO
        //ACTUALIZA DATOS EN LA TABLA VENTA
            try{
                $stmtVentaConContrato = $con->prepare( "UPDATE yifi58ge_dbVENTAS.tblventa v SET v.NContrato=? WHERE v.IdVenta=?");
                $stmtVentaConContrato->bind_param('si',$ncontrato,$idventaCambio);
                $stmtVentaConContrato->execute();
        	    $sqlventaR = $stmtVentaConContrato->affected_rows;
                $stmtVentaConContrato->close();
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }

        $sqlclientecontratoR=actualizarCliente($idclienteR,$IdDocRPR,$cliente,$ncontrato);//ACTUALIZA NCLIENTE O NCONTRATO EN TBLCLIENTE
        //ACTUALIZAR AGENDA
        $comentarioagenda="Traspaso de RP a RE";
        $resultadoagenda = actualizarAgenda($idventaCambio);
        
            try{
                $stmtAgendaHist = $con->prepare( "INSERT INTO yifi58ge_dbVENTAS.tblagendahist(IdAgenda, IdVenta, FechaInst, HoraInst, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES (?,?,?,?,?,?,?,?,?,?)");
                $stmtAgendaHist->bind_param('iissssssss',$idagendaR,$idventaCambio,$fechagrabar,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistroventa,$gestor,$estadoventa);
                $stmtAgendaHist->execute();
        	    $sqlagendahist = $stmtAgendaHist->affected_rows;
                $stmtAgendaHist->close();
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }        
        


        //FACTURACION
        
        $resultadofacturacion=actualizarFacturacion($idventaCambio);
        //VENTA COTIZACION
        $resultadoRegistroRegalos=registrarExtrasRegalos($idventaCambio,$DetalleExtras, $DetalleRegalos, $DetalleGeneral);
        
        //AUDITORIA
        //AUDITORIA REPORTE
        $FechaInstaladaDEL=NULL;
        $Vueltas=NULL;
        $FechaHoraREG=NULL;
        $FechaProgramacion=NULL;

            try{
                $stmtAttecreport = $con->prepare( "SELECT IdAttecRepor,FechaInstaladaDEL,Vueltas,FechaHoraREG,FechaProgramacion FROM tblattecreporte WHERE IdVenta=? ORDER BY 1 DESC LIMIT 1");
                $stmtAttecreport->bind_param('i',$idventaActual);
                $stmtAttecreport->execute();
                $stmtAttecreport->store_result();
                $stmtAttecreport->bind_result($IdAttecRepor,$FechaInstaladaDEL,$Vueltas,$FechaHoraREG,$FechaProgramacion);
                $numrows_attecreport=$stmtAttecreport->num_rows;       
                $stmtAttecreport->fetch();
                $stmtAttecreport->close();
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }  
        
        $IdAttecReporR=NULL;
            try{
                $stmtAttecreportR = $con->prepare( "SELECT IdAttecRepor FROM tblattecreporte WHERE IdVenta=? ORDER BY 1 DESC LIMIT 1");
                $stmtAttecreportR->bind_param('i',$idventaCambio);
                $stmtAttecreportR->execute();
                $stmtAttecreportR->store_result();
                $stmtAttecreportR->bind_result($IdAttecReporR);
                $numrows_attecreportR=$stmtAttecreportR->num_rows;       
                $stmtAttecreportR->fetch();
                $stmtAttecreportR->close();
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }  
        
        if($numrows_attecreportR>0){
            $resultadoRegistroAttecReporte=actualizarAttecReporte($IdAttecReporR,$FechaInstaladaDEL,$FechaHoraREG,$FechaProgramacion,$Vueltas);

            try{
                $stmtUpdIteraccionAttec = $con->prepare( "UPDATE yifi58ge_dbVENTAS.tblventa t SET t.IteraccionAttec=? WHERE t.IdVenta=?");
                $stmtUpdIteraccionAttec->bind_param('ii',$Vueltas,$idventaCambio);
                $stmtUpdIteraccionAttec->execute();
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }            
            
        }else{
            if ($numrows_attecreport> 0) {
                $resultadoRegistroAttecReporte=registrarAttecReporte($idventaCambio,$FechaInstaladaDEL,$FechaHoraREG,$FechaProgramacion,$Vueltas);
                try{
                    $stmtUpdIteraccionAttec = $con->prepare( "UPDATE yifi58ge_dbVENTAS.tblventa t SET t.IteraccionAttec=? WHERE t.IdVenta=?");
                    $stmtUpdIteraccionAttec->bind_param('ii',$Vueltas,$idventaCambio);
                    $stmtUpdIteraccionAttec->execute();
                } catch(PDOException $e) {
                    echo "Error: " . $e->getMessage();
                }                 
                
            }            
        }
        
        //AUDITORIA INSERT
        if ($idattecR == NULL){
            if ($idattec == NULL){
            }else{
                $resultadoDocumentoATTEC = insertarATTEC($idventaCambio);
            }
        }else{
            $resultadoDocumentoATTEC=actualizarATTEC($idattecR);
        }        
        

        if ($resultadoventa > 0 && $resultadoagenda > 0){
            $respuesta = array(
            'respuesta' => 'exito'
            );
        }else{
        $respuesta = array(
            'respuesta' => 'error'
            );
        }
        
        die(json_encode($respuesta));
        
function obtenerIdReferido($IdProspecto){
    global $con;
    
    $sql = "SELECT r.Id FROM yifi58ge_dbREFERIDO.tblreferido r WHERE r.IdProspectoRP = '".$IdProspecto."' LIMIT 1";
    $respuesta = $con->query($sql);
    
    if($respuesta){
        while($data = $respuesta->fetch_assoc()){
            $Id = $data['Id'];
        }
    } else {
        $Id = 0;
    }
    
    return $Id;
}

function actualizarReferido($Id,$idprospecto,$tipoventa){
    global $con;
    
    try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbREFERIDO.tblreferido SET IdProspectoRP=?, TipoVenta=? WHERE Id=?");
        $stmt->bind_param('isi',$idprospecto, $tipoventa, $Id);
        $stmt->execute();
        $respuesta = $stmt->affected_rows;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function actualizarVenta($idventa){
    
    global $con;

    global $idusuario;
    global $matricula;
    global $nombcomercial;
    global $dc;
    global $jefeventa;
    global $segmento;
    
    global $categoria;
    global $preciokit;
    global $totalextra;
    global $ingresototal;
    global $ingresokit;
    global $ingresoextras;
    global $estadoventa;
    global $extraautorizado;
    global $mesesautorizados;
    global $n590;
    global $formadepago;
    global $PAI;
    global $resumenventa;
    global $estvisita;
    global $hidden_contactadoco;
    global $hidden_ventaconfirmadaco;
    global $hidGGCC;
    global $comentarioco;
    //NUEVOS CAMPOS
    global $lbltipokit;
    global $lblCantExtras;
    global $lblclosingpack;
    global $lblresultadoScoring;
    global $lblprecioespecial;
    global $hidden_HCertificacion;
    global $IdConsultaScoring;
    global $IMP;
    global $referidoHabilitado;
    
    global $CategoriaPrecio;
    global $dsctCuota;
    global $TipoCamaraKit;
    global $SegundaAlarma;
    global $TotalCuotaMonitoreo;    
    
    $CategoriaPrecio=stringtonull($CategoriaPrecio);
    $dsctCuota=stringtonull($dsctCuota); 
    $TipoCamaraKit=stringtonull($TipoCamaraKit); 
    $SegundaAlarma=stringtonull($SegundaAlarma); 
    $TotalCuotaMonitoreo=stringtonull($TotalCuotaMonitoreo); 
    
    
    try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET IdUsuario=?, Matricula=?, Comercial=?, CC=?, JefeVenta=?,Segmento=?,CCOriginal=?, CategoriaVenta=?, PrecioKit=?, TotalExtra=?, IngresoKIT=?, IngresoTotal=?, EstadoVenta=?, ExtraAutorizado=?, MesesAutorizado=?, N590=?, FormaPago=?, PAI=?, ResumenVenta=?, EstadoVisita=?, PrecioKITOriginal=?, TotalExtraOriginal=?, ExtraAutorizadoOriginal=?, MesesAutorizadoOriginal=?, FormaPagoOriginal=?, PAIOriginal=?, ResumenVentaOriginal=?, ContactadoCO=?, VTAConfirmadaCO=?, ComentarioCO=?, TipoKIT=?, CantidadExtras=?, ClosingPack=?, ScoringRP=?, PrecioEspecial=?,HojaCertificacion=?,IdConsultaScoringRP=?,GGCC=?,IMP=?,referidoHabilitado=?,TotalCuotaMonitoreo=?,CategoriaPrecio=?,dsctCuota=?,TipoCamaraKit=?,SegundaAlarma=?  WHERE IdVenta=?");
        $stmt->bind_param('isssssssddddssssssssddsssssssssissssisssissssi',$idusuario, $matricula, $nombcomercial, $dc, $jefeventa, $segmento, $dc ,$categoria, $preciokit, $totalextra, $ingresokit, $ingresototal, $estadoventa, $extraautorizado, $mesesautorizados, $n590, $formadepago, $PAI, $resumenventa, $estvisita, $preciokit, $totalextra, $extraautorizado, $mesesautorizados, $formadepago, $PAI, $resumenventa, $hidden_contactadoco, $hidden_ventaconfirmadaco, $comentarioco, $lbltipokit, $lblCantExtras, $lblclosingpack, $lblresultadoScoring, $lblprecioespecial, $hidden_HCertificacion,$IdConsultaScoring,$hidGGCC,$IMP,$referidoHabilitado,$TotalCuotaMonitoreo,$CategoriaPrecio,$dsctCuota,$TipoCamaraKit,$SegundaAlarma,$idventa);
        $stmt->execute();
    
        $respuesta = $stmt->affected_rows;
            
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
}

function actualizarCliente($idcliente,$IdDocRP,$nombcliente,$ncontrato){
    
    global $con;
    
    global $distrito;
    global $telefonouno;
    global $telefonodos;
    global $correo;
    global $direccion;
    global $segmento;
    
    $telefonodos = stringtonull($telefonodos);
    
    try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente SET IdGeografico= ?, NombApellido= ?, Telefonouno= ?, Telefonodos= ?, Correo= ?, Direccion= ?,IdDocRP=?,Segmento=?,NCliente=? WHERE IdCliente = ?");
        $stmt->bind_param("isssssissi", $distrito, $nombcliente, $telefonouno, $telefonodos, $correo, $direccion, $IdDocRP,$segmento,$ncontrato,$idcliente);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function insertarDocumento($tipodoc,$documento,$fecharegistro){
    global $con;
    $tipodocnuevo="";
    if($tipodoc==1){
        $tipodocnuevo="DNI";
    }else if($tipodoc==6){
       $tipodocnuevo="RUC"; 
    }else{
       $tipodocnuevo="CE"; 
    }
        try {
    
          $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES(?, ?, ?)");
          $stmt->bind_param('sss', $tipodocnuevo,$documento,$fecharegistro);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
    
        return $respuesta;
    

}

function actualizarDocumento($tipodoc,$documento,$IdDocRP){
    global $con;
    $tipodocnuevo="";
    if($tipodoc==1){
        $tipodocnuevo="DNI";
    }else if($tipodoc==6){
       $tipodocnuevo="RUC"; 
    }else{
       $tipodocnuevo="CE"; 
    }
    
    try{
        $stmt = $con->prepare("UPDATE tbldocumento SET TipoDocumento=?, Documento=? WHERE IdDoc = ?");
        $stmt->bind_param('ssi', $tipodocnuevo,$documento, $IdDocRP);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();  
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
        return $respuesta;    
}

//Funcion nueva Cliente
function actualizarClienteDoc($idcliente,$IdDocRP,$nombcliente){
    global $con;

    try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente SET IdDocRP=?,NombApellido=? WHERE IdCliente = ?");
        $stmt->bind_param("isi", $IdDocRP,$nombcliente ,$idcliente);
        $stmt->execute();

        $respuesta = $stmt->affected_rows;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }

    return $respuesta;
}

function actualizarAgenda($idventa){
        
        global $con;
        
        
        global $fechagrabar;
        global $horagrabar;
        global $instaladox;
        global $tecnico;
        global $comentarioagenda;
        global $inviable;
        global $gestor;
        global $estadoventa;
        global $ncontrato;
        
        try{
            
            $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblagenda SET FechaInst=?, HoraInst=?, InstaladoX=?, MatriculaTec=?, Comentario=?, MotivoInviable=?, GestorAgenda=?, EstadoVenta=?,NContrato=? WHERE IdVenta=?");
            $stmt->bind_param('sssssssssi', $fechagrabar, $horagrabar, $instaladox, $tecnico, $comentarioagenda, $inviable, $gestor, $estadoventa,$ncontrato, $idventa);
            $stmt->execute();
            
            $respuesta = $stmt->affected_rows;
            
            $stmt->close();
            
        } catch (\Exception $e) {
            $respuesta = 'error';
        }
        
        return $respuesta;
        
    }

function actualizarFacturacion($idventa){
    global $con;
    
global $motivoincidencia;
global $fechagrabarrecpciondoc;
global $fechagrabarfacturacion;
global $factdocoriginal;
global $factsegmentacion;
global $factpago;
global $factautoriza;
global $factdni;
global $factelementosctops;
global $factdocpai;
global $factfaltadoc;
global $factrehacercto;
global $factafiliacion;
global $factprospecto_nroguia;
global $factfuerahora;
global $factscoring;
global $lbldocumentoibs;
global $lblresultadodocumento;
global $factvalidarpago;
global $factvigenciapoder;
global $factfirma;
global $lbltipocomprobante;
global $lblinfogroup;
global $lblncarrera;
global $lblcomentariofacturacion;
global $lblcodwoinst;
    

$motivoincidencia=stringtonull($motivoincidencia);
$fechagrabarrecpciondoc=stringtonull($fechagrabarrecpciondoc);
$fechagrabarfacturacion=stringtonull($fechagrabarfacturacion);
$factdocoriginal=stringtonull($factdocoriginal);
$factsegmentacion=stringtonull($factsegmentacion);
$factpago=stringtonull($factpago);
$factautoriza=stringtonull($factautoriza);
$factdni=stringtonull($factdni);
$factelementosctops=stringtonull($factelementosctops);
$factdocpai=stringtonull($factdocpai);
$factfaltadoc=stringtonull($factfaltadoc);
$factrehacercto=stringtonull($factrehacercto);
$factafiliacion=stringtonull($factafiliacion);
$factprospecto_nroguia=stringtonull($factprospecto_nroguia);
$factfuerahora=stringtonull($factfuerahora);
$factscoring=stringtonull($factscoring);
$lbldocumentoibs=stringtonull($lbldocumentoibs);
$lblresultadodocumento=stringtonull($lblresultadodocumento);
$factvalidarpago=stringtonull($factvalidarpago);
$factvigenciapoder=stringtonull($factvigenciapoder);
$factfirma=stringtonull($factfirma);
$lbltipocomprobante=stringtonull($lbltipocomprobante);
$lblinfogroup=stringtonull($lblinfogroup);
$lblncarrera=stringtonull($lblncarrera);
$lblcomentariofacturacion=stringtonull($lblcomentariofacturacion);
$lblcodwoinst=stringtonull($lblcodwoinst);



    try {
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblfacturacion f SET f.MotivoIncidencia=?,f.FechaRecepcionDOC=?,f.FechaFacturacion=?,f.DOCOriginal=?,f.Segmentacion=?,f.Pago=?,f.Autoriza=?,f.DNI=?,f.ElementosCTOPS=?,f.DOCPAI=?,f.FaltaDOC=?,f.RehacerCTO=?,f.Afiliacion=?,f.Prospecto_NroGuia=?,f.FueraHora=?,f.Scoring=?,f.DocumentoIBS=?,f.ResultadoValidacion=?,f.ValidarPago=?,f.VigenciaPoder=?,f.Firma=?,f.TipoComprobante=?,f.InfoGroup=?,f.NCarrera=?,f.Comentario=?,f.Cod_WO_Inst=? WHERE f.IdVenta=? ");
        $stmt->bind_param('ssssssssssssssssssssssssssi', $motivoincidencia,$fechagrabarrecpciondoc,$fechagrabarfacturacion,$factdocoriginal,$factsegmentacion,$factpago,$factautoriza,$factdni,$factelementosctops,$factdocpai,$factfaltadoc,$factrehacercto,$factafiliacion,$factprospecto_nroguia,$factfuerahora,$factscoring,$lbldocumentoibs,$lblresultadodocumento,$factvalidarpago,$factvigenciapoder,$factfirma,$lbltipocomprobante,$lblinfogroup,$lblncarrera,$lblcomentariofacturacion,$lblcodwoinst,$idventa);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;   
    
}


function stringtonull($val){
    
    if ($val == '' || empty($val) || !isset($val)){
        $resultado = NULL;
    }
    else {
        $resultado = $val;
    }
    
    return $resultado;
}

function registrarExtrasRegalos($idventa,$detalleExtras, $detalleRegalos, $detalleGeneral){
    global $con;
    $fecharegistro = date("Y-m-d H:i:s");
    
    if(($detalleExtras==''||$detalleExtras==null)&&($detalleExtras==''||$detalleExtras==null)&&($detalleExtras==''||$detalleExtras==null)){
        return 'error';
    }
    
    $sql = "SELECT DetalleExtras, DetalleRegalos FROM tblventacotizacion WHERE IdVenta =".$idventa;
    $resultado = $con->query($sql);
    
    $row_cnt = $resultado->num_rows;
    /*
    while($data = $resultado->fetch_assoc()){
        $DetalleExtras__BD = $data['DetalleExtras'];
        $DetalleRegalos__BD = $data['DetalleRegalos'];
    }
    */
    if($row_cnt > 0){

        try{
            $stmt = $con->prepare("UPDATE tblventacotizacion SET DetalleExtras=?, DetalleRegalos=?, DetalleGeneral=? WHERE IdVenta = ?");
            $stmt->bind_param("sssi", $detalleExtras, $detalleRegalos, $detalleGeneral, $idventa);
            $stmt->execute();
            $respuesta = $stmt->affected_rows;
            $stmt->close();
            
        }catch (\Exception $e) {
            $respuesta = 'error';
        }
        
    } else {
    
        try{
            $stmt = $con->prepare("INSERT INTO tblventacotizacion (IdVenta, FechaHoraREG, DetalleExtras, DetalleRegalos, DetalleGeneral) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("issss", $idventa, $fecharegistro, $detalleExtras, $detalleRegalos, $detalleGeneral);
            $stmt->execute();

            $respuesta = $con->insert_id;
            
            $stmt->close();
            
        }catch (\Exception $e) {
            $respuesta = 'error';
        }
    }
    
    return $respuesta;
}

function actualizarAttecReporte($idattecreporte,$FechaInstaladaDEL,$FechaHoraREG,$fechaprogramacion,$Vueltas){
    global $con;
    
    try {

      $stmt = $con->prepare("UPDATE tblattecreporte SET FechaInstaladaDEL=?, FechaProgramacion=?, Vueltas=?,FechaHoraREG=? where IdAttecRepor=?");
      $stmt->bind_param('ssssi', $FechaInstaladaDEL, $fechaprogramacion,$Vueltas, $FechaHoraREG,$idattecreporte);
      $stmt->execute();

      $respuesta = array(
            'respuesta' => 'exito',
          );

      $stmt->close();
    } catch (\Exception $e) {
        $respuesta = array(
          'respuesta' => 'error',
          'mensaje' => $e->getMessage()
        );
    }

    return $respuesta;
}

function registrarAttecReporte($idventa,$FechaInstaladaDEL,$FechaHoraREG,$FechaProgramacion,$Vueltas){
    global $con;
    try {

      $stmt = $con->prepare("INSERT INTO tblattecreporte(IdVenta, FechaInstaladaDEL, FechaProgramacion, Vueltas,FechaHoraREG) VALUES (?,?,?,?,?)");
      $stmt->bind_param('issss', $idventa, $FechaInstaladaDEL, $FechaProgramacion,$Vueltas, $FechaHoraREG);
      $stmt->execute();

      $respuesta = array(
            'respuesta' => 'exito',
          );

      $stmt->close();
    } catch (\Exception $e) {
        $respuesta = array(
          'respuesta' => 'error',
          'mensaje' => $e->getMessage()
        );
    }

    return $respuesta;
}

function actualizarATTEC($idattec){
    
    global $con;
    global $lblfechaautidoria;
    global $lblestadoattec;
    global $hidden_datossbn;
    global $lbldatossbncorreccion;
    global $lblfechacorrecion_datossbn;
    global $hidden_segincorrecto;
    global $lblsegmentocorreccion;
    global $lblfechacorrecion_segincorrecto;
    global $hidden_imagen;
    global $lblimagen_motivo;
    global $lblfechacorrecion_imagen;
    global $hidden_ingresoprogramacion;
    global $lblfechacorrecion_ingresoprogramacion;
    global $hidden_falloscomunicacion;
    global $lblfechacorrecion_falloscomunicacion;
    global $hidden_missingtest;
    global $lblfechacorrecion_missingtest;
    global $hidden_zerovision;
    global $lblfechacorrecion_zerovision;
    global $hidden_fallosupervision;
    global $lblfechacorrecion_fallosupervision;
    global $detalleFallosSupervision;
    global $hidden_tamper;
    global $lblfechacorrecion_tamper;
    global $detalleTamper;
    global $fecharegistroventa;
    global $comentarioattec;
    global $lblzerovisioncorreccion;

    try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblattec SET FechaAuditoria=?,EstadoAttec=?,DatosSbn=?,DatosSbn_NoCoincide=?,F_CorreccionDatosSbn=?,SegIncorrecto=?,F_CorreccionSegIncorrecto=?,Seg_DebeDecir=?,Imagen=?,F_Imagen=?,Imagen_Motivo=?,IngresoProgramacion=?,F_CorreccionIngresoProgramacion=?,FallosCobertura=?,F_CorreccionFallosCobertura=?,MissingTest=?,F_CorreccionMissingTest=?,ZeroVision=?,F_CorreccionZeroVision=?,FalloSupervision=?,F_CorreccionFalloSupervision=?,FalloSupervision_Dispotivos=?,Tamper=?,F_CorreccionTamper=?,Tamper_Dispotivos=?,Comentario=?,Zerovision_motivo=? WHERE IdAttec=?");
        $stmt->bind_param('sssssssssssssssssssssssssssi',  $lblfechaautidoria,$lblestadoattec,$hidden_datossbn,$lbldatossbncorreccion,$lblfechacorrecion_datossbn,$hidden_segincorrecto,$lblfechacorrecion_segincorrecto,$lblsegmentocorreccion,$hidden_imagen,$lblfechacorrecion_imagen,$lblimagen_motivo,$hidden_ingresoprogramacion,$lblfechacorrecion_ingresoprogramacion,$hidden_falloscomunicacion,$lblfechacorrecion_falloscomunicacion,$hidden_missingtest,$lblfechacorrecion_missingtest,$hidden_zerovision,$lblfechacorrecion_zerovision,$hidden_fallosupervision,$lblfechacorrecion_fallosupervision,$detalleFallosSupervision,$hidden_tamper,$lblfechacorrecion_tamper,$detalleTamper,$comentarioattec,$lblzerovisioncorreccion,$idattec);
        $stmt->execute();
    
        $respuesta = $stmt->affected_rows;
            
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
}


function insertarATTEC($idventa){
    
    global $con;
    
    global $lblfechaautidoria;
    global $lblestadoattec;
    global $hidden_datossbn;
    global $lblfechacorrecion_datossbn;
    global $hidden_segincorrecto;
    global $lblsegmentocorreccion;
    global $lblfechacorrecion_segincorrecto;
    global $hidden_imagen;
    global $lblimagen_motivo;
    global $lblfechacorrecion_imagen;
    global $hidden_ingresoprogramacion;
    global $lblfechacorrecion_ingresoprogramacion;
    global $hidden_falloscomunicacion;
    global $lblfechacorrecion_falloscomunicacion;
    global $hidden_missingtest;
    global $lblfechacorrecion_missingtest;
    global $hidden_zerovision;
    global $lblfechacorrecion_zerovision;
    global $hidden_fallosupervision;
    global $lblfechacorrecion_fallosupervision;
    global $detalleFallosSupervision;
    global $hidden_tamper;
    global $lblfechacorrecion_tamper;
    global $detalleTamper;
    global $fecharegistroventa;
    global $comentarioattec;
    global $lblzerovisioncorreccion;
    global $lbldatossbncorreccion;


    try {
        
        $stmt = $con->prepare("INSERT INTO tblattec(IdVenta, FechaAuditoria, EstadoAttec, DatosSbn, F_CorreccionDatosSbn, SegIncorrecto, F_CorreccionSegIncorrecto, Seg_DebeDecir, Imagen, F_Imagen, Imagen_Motivo, IngresoProgramacion, F_CorreccionIngresoProgramacion, FallosCobertura, F_CorreccionFallosCobertura, MissingTest, F_CorreccionMissingTest, ZeroVision, F_CorreccionZeroVision, FalloSupervision, F_CorreccionFalloSupervision, FalloSupervision_Dispotivos, Tamper, F_CorreccionTamper, Tamper_Dispotivos, FechaHoraREG,Comentario,Zerovision_motivo,DatosSbn_NoCoincide) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('issssssssssssssssssssssssssss',  $idventa,$lblfechaautidoria,$lblestadoattec,$hidden_datossbn,$lblfechacorrecion_datossbn,$hidden_segincorrecto,$lblfechacorrecion_segincorrecto,$lblsegmentocorreccion,$hidden_imagen,$lblfechacorrecion_imagen,$lblimagen_motivo,$hidden_ingresoprogramacion,$lblfechacorrecion_ingresoprogramacion,$hidden_falloscomunicacion,$lblfechacorrecion_falloscomunicacion,$hidden_missingtest,$lblfechacorrecion_missingtest,$hidden_zerovision,$lblfechacorrecion_zerovision,$hidden_fallosupervision,$lblfechacorrecion_fallosupervision,$detalleFallosSupervision,$hidden_tamper,$lblfechacorrecion_tamper,$detalleTamper,$fecharegistroventa,$comentarioattec,$lblzerovisioncorreccion,$lbldatossbncorreccion);
        $stmt->execute();
        
        $respuesta = $con->insert_id;

        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
    }
    
    return $respuesta;
}

