<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';

$NContrato = trim($_POST['NContrato']);
$idVentaActual = trim($_POST['idVentaActual']);

$json = [];

try {
    // Obtener IdClienteActual para $idVentaActual
    $stmtClienteActual = $con->prepare("SELECT IdCliente,NContrato FROM yifi58ge_dbVENTAS.tblventa WHERE IdVenta = ? LIMIT 1");
    $stmtClienteActual->bind_param('i', $idVentaActual);
    $stmtClienteActual->execute();
    $stmtClienteActual->store_result();

    $stmtClienteActual->bind_result($IdClienteActual,$numeroContrato);
    $stmtClienteActual->fetch();
    $stmtClienteActual->close();
    
    if($NContrato <> $numeroContrato){

        if (!empty($NContrato) && is_numeric($NContrato)) {
            // Validación 1: NContrato es válido
            $stmtVenta = $con->prepare("SELECT
              v.IdVenta,
              v.IdCliente,
              v.EstadoVenta,
              v.NProspecto,
              v.NContrato
              FROM yifi58ge_dbVENTAS.tblventa v
              INNER JOIN yifi58ge_dbVENTAS.tblagenda a ON a.IdVenta=v.IdVenta
              INNER JOIN yifi58ge_dbVENTAS.tblcliente c ON c.IdCliente=v.IdCliente
              WHERE v.NContrato = ?
              LIMIT 1");
    
            $stmtVenta->bind_param('i', $NContrato);
            $stmtVenta->execute();
            $stmtVenta->store_result();
    
            $numRows = $stmtVenta->num_rows;
    
            if ($numRows > 0) {
                $stmtVenta->bind_result($IdVenta, $IdCliente, $EstadoVenta, $NProspecto, $NContrato);
                while($stmtVenta->fetch()){
                    $json[] = array_map("utf8_encode",
                        ['IdVenta' => $IdVenta,
                        'IdCliente' => $IdCliente,
                        'EstadoVenta' => $EstadoVenta,
                        'NProspecto' => $NProspecto,
                        'NContrato' => $NContrato,
                        'IdClienteActual' => $IdClienteActual]);
                }
            } else {
                $json[] = array_map("utf8_encode",
                    ['NContrato' => $NContrato,
                    'IdClienteActual' => $IdClienteActual]);
            }
        } else {
            // Validación 2: NContrato no es válido
            echo json_encode(['error' => 'Número de contrato no válido.']);
        }
    
        // Envía la respuesta JSON
        echo json_encode($json);
    }else{
        echo json_encode(['error' => 'Número de contrato no válido.']);
    }
} catch (Exception $e) {
    echo json_encode(['error' => 'Error en la ejecución: ' . $e->getMessage()]);
} finally {
    $con->close();
}


