<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

$q=NULL;

if (isset($_GET['q'])) {
    $q=sanitizaCampo($_GET['q'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $q = htmlspecialchars($q);
}

$q = "%{$q}%";
$sql = $con->prepare("SELECT u.IdUsuario, u.Nombres, u.Apellidos, u.Matricula FROM yifi58ge_dbUSUARIO.tblusuario u
		WHERE u.Matricula LIKE ?"); 
$sql->bind_param('s',$q);
$sql->execute();
$sql->store_result();
$sql->bind_result(
    $IdUsuarioRow,
    $NombreRow,
    $ApellidoRow,
    $MatriculaRow
    );


$json = [];
while($sql->fetch()){
    $IdUsuario = $IdUsuarioRow;
    $Nombre = $NombreRow;
    $Apellido = $ApellidoRow;
    $Matricula = $MatriculaRow;
$json[] = array_map("utf8_encode",['id'=>$IdUsuario, 'text'=>$Matricula.'|'.$Nombre.' '.$Apellido]);

}


echo json_encode($json);

$sql->close();
