<?php

include('is_logged.php');

date_default_timezone_set('America/Lima');

function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

$arreglo=NULL;

$gestororigen = sanitizaCampo($_POST['gestororigen'],'sanitizestring|scapestring|htmlspecialchars',$con);

$sqlUrlActiva = $con->prepare("SELECT LAST_INSERT_ID(m.IdMdp) as last,m.URL,m.FechaVencimiento,m.EstadoURL,CURDATE() fechahoy,m.HoraVencimiento, time_format(ADDTIME(sysdate(),'02:00:00'),'%H:%i:%s') horahoy,m.CantidadTransaccion, COUNT(t.IdMdp) transarealizadas from yifi58ge_dbVENTAS.tblmdp m LEFT JOIN yifi58ge_dbVENTAS.tbltransaccion t on t.IdMdp=m.IdMdp WHERE m.EstadoURL='Activo' and m.Area='Venta' GROUP BY m.IdMdp order by m.IdMdp desc limit 1");
$sqlUrlActiva->execute();
$sqlUrlActiva->store_result();
$sqlUrlActiva->bind_result(
    $lastRow,
    $URLRow,
    $FechaVencimientoRow,
    $EstadoURLRow,
    $fechahoyRow,
    $HoraVencimientoRow,
    $horahoyRow,
    $CantidadTransaccionRow,
    $transarealizadasRow
    );
while($sqlUrlActiva->fetch()){
        $URL = $lastRow;
        $URL2 = $URLRow;
        $FechaVencimiento = $FechaVencimientoRow;
        $EstadoURL = $EstadoURLRow;
        $fechahoy = $fechahoyRow;
        $HoraVencimiento = $HoraVencimientoRow;
        $horahoy = $horahoyRow;
        $CantidadTransaccion = $CantidadTransaccionRow;
        $transaccionesrealizadas = $transarealizadasRow;
}
$sqlUrlActiva->close();

$sqlTotalTransUsuario = $con->prepare("SELECT COUNT(*) AS Total FROM yifi58ge_dbVENTAS.tbltransaccion where GestorOrigen = ? AND IdMdp = ? AND CAST(FechaHoraREG as date) = ? " );
$sqlTotalTransUsuario->bind_param('sis',$gestororigen,$URL,$fechahoy);
$sqlTotalTransUsuario->execute();
$sqlTotalTransUsuario->store_result();
$sqlTotalTransUsuario->bind_result(
        $TotalRow
    );
    
while($sqlTotalTransUsuario->fetch()){
    $TotalTransUsuario = $TotalRow;
}

if(!$TotalTransUsuario){
    die("Error");
}else{
   echo json_encode($TotalTransUsuario['Total']);
}

// mysqli_free_result($resultadoTotalTransUsuario);
// mysqli_close($con);
$sqlTotalTransUsuario->close()

?>