<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';

date_default_timezone_set('America/Lima');

$new_total_rows = 0;
$pagenum = $_GET['pagenum'];
$pagesize = $_GET['pagesize'];
$start = $pagenum * $pagesize;

$queryexec="SELECT SQL_CALC_FOUND_ROWS 
IdProspectoRP,
EstadoProspecto,
TipoVenta,
FechaHoraREG,
DC,
DCOrig,
IdUsuario,
Comercial,
Segmento,
NProspecto,
Cliente,
Telefonouno,
Telefonodos,
CategoriaVenta,
PrecioKit,
TotalExtra,
ExtraAutorizado,
MesVisitaRP,
FechaVisitaRP,
HoraVisitaRP
 FROM (SELECT  
p.IdProspectoRP,
p.EstadoProspecto,
p.TipoVenta,
p.FechaHoraREG,
p.CC DC,
p.CCOriginal DCOrig,
u.IdUsuario,
CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
p.Segmento,
p.NProspecto,
c.NombApellido Cliente,
c.Telefonouno,
c.Telefonodos,
p.CategoriaVenta,
p.PrecioKit,
p.TotalExtra,
p.ExtraAutorizado,
p.MesVisitaRP,
p.FechaVisitaRP,
p.HoraVisitaRP
FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
WHERE p.EstadoProspecto='ProspectoRP' and Year(p.FechaHoraREG)='2019' and (p.FechaHoraREG <= DATE_SUB(CURDATE(), INTERVAL 30 DAY)) 
ORDER BY p.FechaHoraREG DESC) as VENTA";

$query = $queryexec." LIMIT ?, ?";
$result = $con->prepare($query);
$result->bind_param('ii', $start, $pagesize);
$filterquery = "";
// filter data.
if (isset($_GET['filterscount']))
	{
	$filterscount = $_GET['filterscount'];
	if ($filterscount > 0)
		{
		$where = " WHERE (";
		$tmpdatafield = "";
		$tmpfilteroperator = "";
		$valuesPrep = "";
		$value = [];
		for ($i = 0; $i < $filterscount; $i++)
			{
			// get the filter's value.
			$filtervalue = $_GET["filtervalue" . $i];
			// get the filter's condition.
			$filtercondition = $_GET["filtercondition" . $i];
			// get the filter's column.
			$filterdatafield = $_GET["filterdatafield" . $i];
			// get the filter's operator.
			$filteroperator = $_GET["filteroperator" . $i];
			if ($tmpdatafield == "")
				{
				$tmpdatafield = $filterdatafield;
				}
			  else if ($tmpdatafield <> $filterdatafield)
				{
				$where.= ") AND (";
				}
			  else if ($tmpdatafield == $filterdatafield)
				{
				if ($tmpfilteroperator == 0)
					{
					$where.= " AND ";
					}
				  else $where.= " OR ";
				}
			// build the "WHERE" clause depending on the filter's condition, value and datafield.
			switch ($filtercondition)
				{
			case "CONTAINS":
				$condition = " LIKE ";
				$value[0][$i] = "%{$filtervalue}%";
				$values[] = & $value[0][$i];
				break;

			case "DOES_NOT_CONTAIN":
				$condition = " NOT LIKE ";
				$value[1][$i] = "%{$filtervalue}%";
				$values[] = & $value[1][$i];
				break;

			case "EQUAL":
				$condition = " = ";
				$value[2][$i] = $filtervalue;
				$values[] = & $value[2][$i];
				break;

			case "NOT_EQUAL":
				$condition = " <> ";
				$value[3][$i] = $filtervalue;
				$values[] = & $value[3][$i];
				break;

			case "GREATER_THAN":
				$condition = " > ";
				$value[4][$i] = $filtervalue;
				$values[] = & $value[4][$i];
				break;

			case "LESS_THAN":
				$condition = " < ";
				$value[5][$i] = $filtervalue;
				$values[] = & $value[5][$i];
				break;

			case "GREATER_THAN_OR_EQUAL":
				$condition = " >= ";
				$value[6][$i] = $filtervalue;
				$values[] = & $value[6][$i];
				break;

			case "LESS_THAN_OR_EQUAL":
				$condition = " <= ";
				$value[7][$i] = $filtervalue;
				$values[] = & $value[7][$i];
				break;

			case "STARTS_WITH":
				$condition = " LIKE ";
				$value[8][$i] = "{$filtervalue}%";
				$values[] = & $value[8][$i];
				break;

			case "ENDS_WITH":
				$condition = " LIKE ";
				$value[9][$i] = "%{$filtervalue}";
				$values[] = & $value[9][$i];
				break;

			case "NULL":
				$condition = " IS NULL ";
				$value[10][$i] = "%{$filtervalue}%";
				$values[] = & $value[10][$i];
				break;

			case "NOT_NULL":
				$condition = " IS NOT NULL ";
				$value[11][$i] = "%{$filtervalue}%";
				$values[] = & $value[11][$i];
				break;
				}
			$where.= " " . $filterdatafield . $condition . "? ";
			$valuesPrep = $valuesPrep . "s";
			if ($i == $filterscount - 1)
				{
				$where.= ")";
				}
			$tmpfilteroperator = $filteroperator;
			$tmpdatafield = $filterdatafield;
			}
		$filterquery.= $queryexec. " " . $where;
		// build the query.
		$valuesPrep = $valuesPrep . "ii";
		$values[] = & $start;
		$values[] = & $pagesize;
		$query = $queryexec." " . $where . " LIMIT ?, ?";
		$result = $con->prepare($query);
		call_user_func_array(array(
			$result,
			"bind_param"
		) , array_merge(array(
			$valuesPrep
		) , $values));
		}
	}
if (isset($_GET['sortdatafield']))
	{
	$sortfield = $_GET['sortdatafield'];
	$sortorder = $_GET['sortorder'];
	if ($sortorder != '')
		{
		if ($_GET['filterscount'] == 0)
			{
			if ($sortorder == "desc")
				{
				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT ?, ?";
				}
			  else if ($sortorder == "asc")
				{
				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT ?, ?";
				}
			$result = $con->prepare($query);
			$result->bind_param('ii', $start, $pagesize);
			}
		  else
			{
			if ($sortorder == "desc")
				{
				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT ?, ?";
				}
			  else if ($sortorder == "asc")
				{
				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT ?, ?";
				}
			// build the query.
			$query = $filterquery;
			$result = $con->prepare($query);
			call_user_func_array(array(
				$result,
				"bind_param"
			) , array_merge(array(
				$valuesPrep
			) , $values));
			}
		}
	}
$result->execute();
/* bind result variables */
$result->bind_result($IdProspectoRP,
$EstadoProspecto,
$TipoVenta,
$FechaHoraREG,
$DC,
$DCOrig,
$IdUsuario,
$Comercial,
$Segmento,
$NProspecto,
$Cliente,
$Telefonouno,
$Telefonodos,
$CategoriaVenta,
$PrecioKit,
$TotalExtra,
$ExtraAutorizado,
$MesVisitaRP,
$FechaVisitaRP,
$HoraVisitaRP);
/* fetch values */
$orders = [];
// get data and store in a json array
while ($result->fetch())
	{
	$orders[] = array(
'IdProspectoRP'=>$IdProspectoRP,
'EstadoProspecto'=>$EstadoProspecto,
'TipoVenta'=>$TipoVenta,
'FechaHoraREG'=>$FechaHoraREG,
'DC'=>$DC,
'DCOrig'=>$DCOrig,
'IdUsuario'=>$IdUsuario,
'Comercial'=>$Comercial,
'Segmento'=>$Segmento,
'NProspecto'=>$NProspecto,
'Cliente'=>$Cliente,
'Telefonouno'=>$Telefonouno,
'Telefonodos'=>$Telefonodos,
'CategoriaVenta'=>$CategoriaVenta,
'PrecioKit'=>$PrecioKit,
'TotalExtra'=>$TotalExtra,
'ExtraAutorizado'=>$ExtraAutorizado,
'MesVisitaRP'=>$MesVisitaRP,
'FechaVisitaRP'=>$FechaVisitaRP,
'HoraVisitaRP'=>$HoraVisitaRP
	);
	}
$result = $con->prepare("SELECT FOUND_ROWS()");
$result->execute();
$result->bind_result($total_rows);
$result->fetch();
if ($new_total_rows > 0) $total_rows = $new_total_rows;
$data[] = array(
	'TotalRows' => $total_rows,
	'Rows' => $orders
);
echo json_encode($data);
/* close statement */
$result->close();
/* close connection */
$con->close();
?>