<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

$matriculauser=sanitizaCampo($_GET['matriculauser'],'sanitizeint|scapestring|htmlspecialchars',$con);
$matriculauser = htmlspecialchars($matriculauser);

$permisouser=sanitizaCampo($_GET['permisouser'],'sanitizeint|scapestring|htmlspecialchars',$con);
$permisouser = htmlspecialchars($permisouser);

$arreglo=NULL;


if($permisouser=="GestorAMP"){
    $query=$con->prepare("SELECT
am.IdAmp,
am.NAviso,
'' as NMantenimiento,
DATE_FORMAT(am.FechaHoraREG, '%Y-%m-%d %r') FechaHoraREG,
am.UsuarioREG,
am.GestorUpselling,
am.Canal,
am.EstadoAmp,
am.Campana,
am.ComentarioAmp,
am.MesAmp,
c.NombApellido Cliente,
c.NCliente,
g.Distrito,
g.Provincia
FROM yifi58ge_dbVENTAS.tblampliacion am
INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=am.IdCliente
INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
WHERE am.GestorUpselling=? AND am.EstadoAmp = 'NoProcede' AND am.MotivoNoProcede = 'EDOC'
ORDER BY  am.FechaHoraREG DESC");
$query->bind_param('s',$matriculauser);
$query->execute();
$query->store_result();
$query->bind_result(
    $IdAmpRow,
    $NAvisoRow,
    $NMantenimientoRow,
    $FechaHoraREGRow,
    $UsuarioREGRow,
    $GestorUpsellingRow,
    $CanalRow,
    $EstadoAmpRow,
    $CampanaRow,
    $ComentarioAmpRow,
    $MesAmpRow,
    $ClienteRow,
    $NClienteRow,
    $DistritoRow,
    $ProvinciaRow
    );
}
else{
$query=$con->prepare("SELECT
am.IdAmp,
am.NAviso,
'' as NMantenimiento,
DATE_FORMAT(am.FechaHoraREG, '%Y-%m-%d %r') FechaHoraREG,
am.UsuarioREG,
am.GestorUpselling,
am.Canal,
am.EstadoAmp,
am.Campana,
am.ComentarioAmp,
am.MesAmp,
c.NombApellido Cliente,
c.NCliente,
g.Distrito,
g.Provincia
FROM yifi58ge_dbVENTAS.tblampliacion am
INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=am.IdCliente
INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
WHERE am.EstadoAmp = 'NoProcede' AND am.MotivoNoProcede = 'EDOC'
ORDER BY  am.FechaHoraREG DESC");

$query->execute();
$query->store_result();
$query->bind_result(
    $IdAmpRow,
    $NAvisoRow,
    $NMantenimientoRow,
    $FechaHoraREGRow,
    $UsuarioREGRow,
    $GestorUpsellingRow,
    $CanalRow,
    $EstadoAmpRow,
    $CampanaRow,
    $ComentarioAmpRow,
    $MesAmpRow,
    $ClienteRow,
    $NClienteRow,
    $DistritoRow,
    $ProvinciaRow
    );
}

if($query->num_rows <= 0){
    die("Error");
}else{
   
    $return_arr = array();
    while($query->fetch()){
         $row_array['IdAmp'] =$IdAmpRow;
         $row_array['NAviso'] =$NAvisoRow;
         $row_array['NMantenimiento'] =$NMantenimientoRow;
         $row_array['FechaHoraREG'] =$FechaHoraREGRow;
         $row_array['UsuarioREG'] =$UsuarioREGRow;
         $row_array['GestorUpselling'] =$GestorUpsellingRow;
         $row_array['Canal'] =$CanalRow;
         $row_array['EstadoAmp'] =$EstadoAmpRow;
         $row_array['Campana'] =$CampanaRow;
         $row_array['ComentarioAmp'] =$ComentarioAmpRow;
         $row_array['MesAmp'] =$MesAmpRow;
         $row_array['Cliente'] =$ClienteRow;
         $row_array['NCliente'] =$NClienteRow;
         $row_array['Distrito'] =$DistritoRow;
         $row_array['Provincia'] =$ProvinciaRow;
    
     array_push($return_arr,array_map("utf8_encode",$row_array)); //o este
    }
    echo json_encode($return_arr);
}

$query->close();


