<?php
include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

$q=NULL;

if (isset($_GET['q'])) {
    $q=sanitizaCampo($_GET['q'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $q = htmlspecialchars($q);
}

$q = "%{$q}%";
$sql = $con->prepare("SELECT IdArea,NombreArea 
FROM yifi58ge_dbUSUARIO.tblarea a
WHERE a.IdDpto
IN ( 6, 7, 8, 9, 10, 11, 12, 13, 14,15,17,18,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39) AND a.NombreArea LIKE ?"); 
$sql->bind_param('s',$q);
$sql->execute();
$sql->store_result();
$sql->bind_result(
    $IdAreaRow,
    $NombreAreaRow
    );


$json = [];

while($sql->fetch()){
    $IdArea = $IdAreaRow;
    $NombreArea = $NombreAreaRow;
$json[] = array_map("utf8_encode",['id'=>$IdArea, 'text'=>$NombreArea]);

}
echo json_encode($json);