<?php
    //INSERTA LOG EN LA TABLA TRANSACCIONAL
    function StmtInsertarLog($id_usuario, $idLogSeg, $tabla, $url, $actual, $nuevo, $fechaactual ){
        global $con;
    
        try{
            $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog_transac(Id_Usuario, IdLogSeg, Tabla, URL, RegActual, RegNuevo, FechaHoraReg) VALUES(?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param('iisssss', $id_usuario, $idLogSeg, $tabla, $url, $actual, $nuevo, $fechaactual);
            $stmt->execute();
            
            //$id_insertado = $stmt->insert_id;
            /*
            if($id_insertado > 0) {
                $respuesta = array(
                    'respuesta' => 'exito',
                    'id_insertado' => $id_insertado
                );
            } else {
                $respuesta = array(
                    'respuesta' => 'error'
                );
            }
            */
            unset($actual);
            unset($nuevo);
            $stmt->close();
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
        
        //return $respuesta;
    }
    
    function StmtInsertarLogTransac($Id_Usuario, $usuario, $IdLogSeg, $Url, $Identificador, $accion, $Tabla, $RegActual, $RegNuevo, $FechaHoraReg){
        global $con;
        
        try{
            $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog_transac(Id_Usuario, usuario, IdLogSeg, URL, Identificador, accion, Tabla, RegActual, RegNuevo, FechaHoraReg) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param('isisisssss', $Id_Usuario, $usuario, $IdLogSeg, $Url, $Identificador, $accion, $Tabla, $RegActual, $RegNuevo, $FechaHoraReg);
            $stmt->execute();
            $stmt->close();
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
        
    }
    
    function StmtInsertarLogStatus($IdLogTrans,$tabla,$identificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog){
        global $con;
        
        try {
            $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog_estado(IdLogTrans, Tabla, Identificador, NombreEstado, Estado, usuario, FechaHoraREG, Matricula, CC, JefeVenta) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param('isssssssis',$IdLogTrans,$tabla,$identificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
            $stmt->execute();
            $stmt->close();
        }catch (\Exception $e){
            echo $e->getMessage();
        }
        
        
    }
    
    function StmtInsertarLogSeguridad($accion){
        global $con;
        
        global $fecharegistro;
        global $idAmpl;
        
        $url = $_SERVER['REQUEST_URI'].'=>IdAmpl='.$idAmpl;
        
        try{
            $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->bind_param('ssssss', $_SERVER['REMOTE_ADDR'], $_SESSION['usuariosesion'], $fecharegistro, $url , $accion, $_SERVER['HTTP_USER_AGENT']);
            $stmt->execute();
            
            $respuesta = $stmt->insert_id;
            
            $stmt->close();
            
        } catch (\Exception $e) {
            $respuesta = $e->getMessage();
        }
        
        return $respuesta;
    }
    
    //LOG DE SEGURIDAD GENERAL PARA CUALQUIER MODULO GENERADO
    function StmtInsertarLogSeguridad_General($accion, $fecha, $id, $nombreid){
        global $con;
        
        $url = $_SERVER['REQUEST_URI'].'=>'.$nombreid.'='.$id;
        
        $usuario = $_SESSION['usuariosesion'];
        
        try{
            $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->bind_param('ssssss', $_SERVER['REMOTE_ADDR'], $usuario, $fecha, $url , $accion, $_SERVER['HTTP_USER_AGENT']);
            $stmt->execute();
            
            $respuesta = $stmt->insert_id;
            
            $stmt->close();
            
        } catch (\Exception $e) {
            $respuesta = $e->getMessage();
        }
        
        return $respuesta;
        
    }
    
    //Nuevo LogAmpliacion
    function StmtInsertarLogAmpliacion($IdAmp,$IdUsuario, $usuario,$accion, $Tabla, $RegActual, $RegNuevo, $FechaHoraReg){
        global $con;
        
        try{
            $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog_ampliacion(IdAmp,IdUsuario, Usuario,Accion, Tabla, RegActual, RegNuevo, FechaHoraReg) VALUES(?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param('iissssss', $IdAmp, $IdUsuario, $usuario, $accion, $Tabla, $RegActual, $RegNuevo, $FechaHoraReg);
            $stmt->execute();
            $stmt->close();
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
        
    }


?>