<?php

include('is_logged.php');

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require_once '../config/db.php';
require_once '../config/conexion.php';

//RECIBIR DATOS POST

$idusuario = $_SESSION['id_usuario'];
$fecharegistro= date("Y-m-d H:i:s");

$IdSoliciutd = generarSolicitud();

$arregloDetalle = $_POST['arregloDetalle'];

foreach ($arregloDetalle as $clave => $valor) {
    
    $solicitud = $valor['solicitud'];
    $detalle = json_encode($valor['detalle']);
    
    $IdDetalleSolicitud = registrarDetalle($IdSoliciutd, $solicitud, $detalle);
    
    $arrayResultadosDetalleSolicitud[] = $IdDetalleSolicitud;
    
}

if($IdSoliciutd > 0){

    $respuesta = ['exito', $IdSoliciutd, $arrayResultadosDetalleSolicitud];
} else {
    $respuesta = ['error'];
}

echo json_encode($respuesta);



//FUNCIONES

function generarSolicitud(){
    global $con;
    global $idusuario;
    global $fecharegistro;
    
    $ncliente = $_POST['ncliente'];
    $nombcliente = $_POST['nombcliente'];
    $correo = $_POST['correo'];
    $correo2 = $_POST['correo2'];
    $telefono = $_POST['telefono'];
    $estado = 'Ingresado';
        
    //INSERTAR DATOS EN LA BASE DE DATOS
    try{
        $stmt = $con->prepare("INSERT INTO tblsolicitudes (idUsuario,  FechaHoraReg, NCliente, Cliente, Correo, Correo2, Telefono, Estado) VALUES (?, ?, ? ,?, ?, ?, ?, ?)");
        $stmt->bind_param('isssssss', $idusuario, $fecharegistro, $ncliente, $nombcliente, $correo, $correo2, $telefono, $estado);
        $stmt->execute();
            
        $respuesta = $con->insert_id;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;

}

function registrarDetalle($IdSoliciutd, $solicitud, $detalle){
    global $con;
    
    try{
        $stmt = $con->prepare("INSERT INTO tblsolicitudesDetalle (IdSolicitud, Solicitud, Detalle) VALUES (?, ?, ?)");
        $stmt->bind_param('iss', $IdSoliciutd, $solicitud, $detalle);
        $stmt->execute();
            
        $respuesta = $con->insert_id;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
        
        
    }
    
    return $respuesta;
}