<?php

    include('is_logged.php');
    
    date_default_timezone_set('America/Lima');
    //Funciones para codificar al momento de grabar en Mysql
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date)
    {
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date)
    {
        return date('Y-m-d', strtotime($date));
    }
    
    require_once '../config/db.php';
    require_once '../config/conexion.php';
    require (__DIR__) . '/helper/helper_validacion.php';

    //LOGS TRANSACCCIONALES
    include 'log/insertLog.php'; //LOG TRANSAC
    include 'log/insertLogCliente.php'; //LOG CLIENTE
    include 'log/insertLogProsectoRP.php'; //LOG PROSPECTO

    $matriculausuario = sanitizaCampo($_POST['gestorcoordinadora'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    $categoria = sanitizaCampo($_POST['lblcategoria'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    $matricula = sanitizaCampo($_POST['lblmatricula'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    $nombcomercial = sanitizaCampo($_POST['lblnombcomercial'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    $dc = sanitizaCampo($_POST['lbldc'], 'sanitizeint|scapestring|htmlspecialchars', $con);
    $tipoventa = sanitizaCampo($_POST['lbltipoventa'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    $estadoventa = sanitizaCampo($_POST['lblestadoventa'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    $direccion = sanitizaCampo($_POST['lbldireccion'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    $comentarioprospecto = sanitizaCampo($_POST['lblcomentarioprospecto'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    $nombcliente = sanitizaCampo($_POST['lblnombcliente'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    $telefonouno = sanitizaCampo($_POST['lblmovil'], 'sanitizeint|scapestring|htmlspecialchars', $con);
    $telefonodos = sanitizaCampo($_POST['lblfijo'], 'sanitizeint|scapestring|htmlspecialchars', $con);
    $correo = sanitizaCampo($_POST['lblcorreo'], 'sanitizeemail|scapestring|htmlspecialchars', $con);
    $idusuario = sanitizaCampo($_POST['lblidusuario'], 'sanitizeintscapestring|htmlspecialchars', $con);
    $resumenventa = sanitizaCampo($_POST['lblresumenventa'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    
    $fecharegistroventa = date("Y-m-d H:i:s");
    
    if(isset($_POST['lbljefeventa'])){
        $jefeventa = sanitizaCampo($_POST['lbljefeventa'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    } else {
        $respuesta = array(
            'respuesta' => 'error'
        );
        die(json_encode($respuesta));
    }
    
    if($_POST['lblsegmento'] == '' || empty($_POST['lblsegmento'])){
        $segmento = NULL;
    } else {
        $segmento = sanitizaCampo($_POST['lblsegmento'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    }

    if(isset($_POST['lbldistrito'])){
        $distrito = sanitizaCampo($_POST['lbldistrito'], 'sanitizestring|scapestring|htmlspecialchars', $con);   
    } else {
        $respuesta = array(
            'respuesta' => 'error'
        );
        die(json_encode($respuesta));
    }

    if($_POST['lblmesesautorizados'] == ''){
        $mesesautorizados = NULL;
    } else {
        $mesesautorizados = sanitizaCampo($_POST['lblmesesautorizados'], 'sanitizeint|scapestring|htmlspecialchars', $con);   
    }

    if($_POST['lblpreciokit'] == ''){
        $preciokit = NULL;
    } else {
        $preciokit = sanitizaCampo($_POST['lblpreciokit'], 'sanitizefloat|scapestring|htmlspecialchars', $con);
    }

    if($_POST['lbltotalextra'] == ''){
        $totalextra = NULL;
    } else {
        $totalextra = sanitizaCampo($_POST['lbltotalextra'], 'sanitizefloat|scapestring|htmlspecialchars', $con);
    }

    if($_POST['lblextraautorizado'] == '' || empty($_POST['lblextraautorizado'])){
        $extraautorizado = NULL;
    } else {
        $extraautorizado = sanitizaCampo($_POST['lblextraautorizado'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    }

    if($_POST['lblformadepago'] == '' || empty($_POST['lblformadepago'])){
        $formadepago = NULL;
    } else {
        $formadepago = sanitizaCampo($_POST['lblformadepago'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    }


    if($_POST['lblPAI'] == '' || empty($_POST['lblPAI'])){
        $PAI = NULL;
    } else {
        $PAI = sanitizaCampo($_POST['lblPAI'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    }

    if($_POST['lblclienteref'] == '' || empty($_POST['lblclienteref'])){
        $clienteref = NULL;
    } else {
        $clienteref = sanitizaCampo($_POST['lblclienteref'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    }
    
    if($_POST['lbltipodoc'] == '' || empty($_POST['lbltipodoc'])){
        $tipodocref = NULL;
    }else{
        $tipodocref = sanitizaCampo($_POST['lbltipodoc'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    }

    if($_POST['lbldocumento'] == '' || empty($_POST['lbldocumento'])){
        $documentoref = NULL;
    } else {
        $documentoref = sanitizaCampo($_POST['lbldocumento'], 'sanitizeint|scapestring|htmlspecialchars', $con); 
    }
    
    /* Nuevos campos VISITA CONCERTADA 18.02
    VISITA CONCERTADA - VALOR(SI O NO) */

    if(isset($_POST['hidVisitaConcertada'])){
        if($_POST['hidVisitaConcertada'] == '' || empty($_POST['hidVisitaConcertada'])){
            $hidVisitaConcertada = NULL;   
        } else {
            $hidVisitaConcertada = sanitizaCampo($_POST['hidVisitaConcertada'], 'sanitizestring|scapestring|htmlspecialchars', $con);
        }
    }

    /* FECHA Y HORA VISITA CONCERTADA */
    if(isset($_POST['fechaVisitaConcertada'])){
        if($_POST['fechaVisitaConcertada'] == '' || empty($_POST['fechaVisitaConcertada'])){
            $fechaVisitaConcertada = NULL;
        } else{
            $fechaVisitaConcertadaOriginal= sanitizaCampo($_POST['fechaVisitaConcertada'], 'sanitizestring|scapestring|htmlspecialchars', $con);
            $fechaVisitaConcertadaFinal = myUrlEncode(sanitizaCampo($fechaVisitaConcertadaOriginal, 'sanitizestring|scapestring|htmlspecialchars', $con));
            $fechaVisitaConcertadaFinal = format_date_Y_mm_dd(str_replace('/', '-', $fechaVisitaConcertadaFinal));
        }
    }

    if(isset($_POST['horaVisitaConcertada'])){
        if($_POST['horaVisitaConcertada'] == '' || empty($_POST['horaVisitaConcertada'])){
            $horaVisitaConcertada = NULL;
        } else{
            $horaVisitaConcertada = sanitizaCampo($_POST['horaVisitaConcertada'], 'sanitizestring|scapestring|htmlspecialchars', $con);
        }
    }


    if($telefonodos == "" || empty($telefonodos)){
        $arrayCliente = consultaClienteI();
        
        /* CONSULTA PREPARADA N°27 */
        $queryInsertCliente = "INSERT INTO yifi58ge_dbVENTAS.tblcliente(IdGeografico, NombApellido, Telefonouno, Correo, Direccion,Segmento) VALUES(?, ?, ?, ?, ?, ?)";
        
        try{
            $stmt = $con->prepare($queryInsertCliente);
            $stmt->bind_param('ssisss', $distrito, $nombcliente, $telefonouno, $correo, $direccion, $segmento);
            $stmt->execute();
            $IdCliente = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
        
        if($IdCliente > 0){
            $arrayProspecto=consultaProspectoRPI(); 
            
            /* CONSULTA PREPARADA N°28 */
            $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblprospectorp(IdUsuario,IdCliente,FechaHoraREG, Matricula, Comercial,CC,JefeVenta,CategoriaVenta,TipoVenta,Segmento,PrecioKit,
            TotalExtra,EstadoProspecto,ExtraAutorizado,MesesAutorizado,FormaPago,PAI,ResumenProspecto,ComentarioProspectoRP, MatriculaOriginal, ComercialOriginal, CCOriginal, 
            JefeVentaOriginal,NContratoREF,TipoDocREF,DocREF, VisitaConcertada, FechaVisitaRP, HoraVisitaRP) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iissssssssddssdssssssssssssss', $idusuario,$idCli, $fecharegistroventa, $matricula, $nombcomercial, $dc, $jefeventa, $categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoventa,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$matricula, $nombcomercial, $dc, $jefeventa,$clienteref,$tipodocref,$documentoref,$hidVisitaConcertada,$fechaVisitaConcertadaFinal,$horaVisitaConcertada);
            $stmt->execute();
            $idprospectorp = $stmt->insert_id;
            
            if($idprospectorp > 0) {
                $respuesta = array(
                    'respuesta' => 'exito',
                    'id_registro' => $idprospectorp
                );
                
                /* CONSULTA PREPARADA N°29 */
                $queryInsertProspechist = "INSERT INTO yifi58ge_dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,Gestor) VALUES(?, ?, ?, ?, ?, ?)";
                $stmt = $con->prepare($queryInsertProspechist);
                $stmt->bind_param('isssss', $idprospectorp,$fecharegistroventa,$estadoventa,$tipoventa,$categoria,$matriculausuario);
                $stmt->execute();
                $stmt->close();
                
                /* CONSULTA PREPARADA N°30 */
                $accion = 'Registrar';
                $queryExec = "INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)";
                $stmtExec = $con->prepare($queryExec);
                $stmtExec->bind_param('ssssss', $_SERVER['REMOTE_ADDR'],$_SESSION['usuariosesion'],$fecharegistroventa,$_SERVER['REQUEST_URI'].'=>IdProspectoRP='.$idprospectorp,$accion,$_SERVER['HTTP_USER_AGENT']);
                $stmtExec->execute();
                $idLogSeg = $con->insert_id;
                $stmtExec->close();
                
                insertarLogI($idLogSeg, $arrayCliente);
                insertLogProspectoRPI($idLogSeg, $arrayProspecto);
            } else {
              $respuesta = array(
                'respuesta' => 'error'
              );
            }            
        }
        
        /* CONSULTA PREPARADA N°31 */
        $queryCliente = "INSERT INTO yifi58ge_dbVENTAS.tblcliente(IdGeografico, NombApellido, Telefonouno, Correo, Direccion,Segmento) VALUES (?,?,?,?,?,?)";
        
        try{
            $stmt = $con->prepare($queryCliente);
            $stmt->bind_param('isisss', $distrito,$nombcliente,$telefonouno,$correo,$direccion,$segmento);
            $stmt->execute();
            $idCli = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
        
        if($idCli > 0){
            /* CONSULTA PREPARADA N°31 */
            $arrayProspecto=consultaProspectoRPI();
            $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblprospectorp(IdUsuario,IdCliente,FechaHoraREG, Matricula, Comercial,CC,JefeVenta,CategoriaVenta,TipoVenta,Segmento,PrecioKit,TotalExtra,EstadoProspecto,ExtraAutorizado,MesesAutorizado,FormaPago,PAI,ResumenProspecto,ComentarioProspectoRP, MatriculaOriginal, ComercialOriginal, CCOriginal, JefeVentaOriginal,NContratoREF,TipoDocREF,DocREF, VisitaConcertada, FechaVisitaRP, HoraVisitaRP) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iissssssssddssdssssssssssssss', $idusuario,$idCli, $fecharegistroventa, $matricula, $nombcomercial, $dc, $jefeventa, $categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoventa,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$matricula, $nombcomercial, $dc, $jefeventa,$clienteref,$tipodocref,$documentoref,$hidVisitaConcertada,$fechaVisitaConcertadaFinal,$horaVisitaConcertada);
            $stmt->execute();
            $idprospectorp = $stmt->insert_id;
            
            if($idprospectorp > 0) {
                $respuesta = array(
                    'respuesta' => 'exito',
                    'id_registro' => $idprospectorp
                );
              
                $sqlprospechist = "INSERT INTO yifi58ge_dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,Gestor) VALUES(?, ?, ?, ?, ?, ?)";
                
                try{
                    $stmt = $con->prepare($sqlprospechist);
                    $stmt->bind_param('isssss', $idprospectorp,$fecharegistroventa,$estadoventa,$tipoventa,$categoria,$matriculausuario);
                    $stmt->execute();
                    $respuesta = $con->insert_id;
                    $stmt->close();
                } catch (\Exception $e) {
                    $respuesta = array(
                        'respuesta' => 'error'
                    );
                }              
              
                $accion = 'Registrar';
                $queryExec = "INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)";
                $stmtExec = $con->prepare($queryExec);
                $stmtExec->bind_param('ssssss', $_SERVER['REMOTE_ADDR'],$_SESSION['usuariosesion'],$fecharegistroventa,$_SERVER['REQUEST_URI'].'=>IdProspectoRP='.$idprospectorp,$accion,$_SERVER['HTTP_USER_AGENT']);
                $stmtExec->execute();
                $idLogSeg = $con->insert_id;
                $stmtExec->close();              
              
                insertarLogI($idLogSeg, $arrayCliente);
                insertLogProspectoRPI($idLogSeg, $arrayProspecto);
            } else {
              $respuesta = array(
                'respuesta' => 'error'
              );
            }            
        } else {
            $respuesta = array(
                'respuesta' => 'error'
            );            
        }
    } else {
        /* CONSULTA PREPARADA N°32 */
        $arrayCliente = consultaClienteI();
        $queryCliente2 = "INSERT INTO yifi58ge_dbVENTAS.tblcliente(IdGeografico, NombApellido, Telefonouno, Correo, Direccion,Segmento) VALUES (?,?,?,?,?,?)";
        
        try{
            $stmt = $con->prepare($queryCliente2);
            $stmt->bind_param('isisss', $distrito,$nombcliente,$telefonouno,$correo,$direccion,$segmento);
            $stmt->execute();
            $idCli = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }        
        
        if ($idCli > 0) {
            $arrayProspecto=consultaProspectoRPI(); 
            $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblprospectorp(IdUsuario,IdCliente,FechaHoraREG, Matricula, Comercial,CC,JefeVenta,CategoriaVenta,TipoVenta,Segmento,PrecioKit,TotalExtra,EstadoProspecto,ExtraAutorizado,MesesAutorizado,FormaPago,PAI,ResumenProspecto,ComentarioProspectoRP, MatriculaOriginal, ComercialOriginal, CCOriginal, JefeVentaOriginal,NContratoREF,TipoDocREF,DocREF,VisitaConcertada,FechaVisitaRP,HoraVisitaRP) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iissssssssddssdssssssssssssss', $idusuario,$idCli, $fecharegistroventa, $matricula, $nombcomercial, $dc, $jefeventa, $categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoventa,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$matricula, $nombcomercial, $dc, $jefeventa,$clienteref,$tipodocref,$documentoref,$hidVisitaConcertada,$fechaVisitaConcertada,$horaVisitaConcertada);
            $stmt->execute();
            $idprospectorp = $stmt->insert_id;
            if($idprospectorp > 0) {
              $respuesta = array(
                'respuesta' => 'exito',
                'id_registro' => $idprospectorp
              );
              
                $accion = 'Registrar';
                $queryExec = "INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)";
                $stmtExec = $con->prepare($queryExec);
                $stmtExec->bind_param('ssssss', $_SERVER['REMOTE_ADDR'],$_SESSION['usuariosesion'],$fecharegistroventa,$_SERVER['REQUEST_URI'].'=>IdProspectoRP='.$idprospectorp,$accion,$_SERVER['HTTP_USER_AGENT']);
                $stmtExec->execute();
                $idLogSeg = $con->insert_id;
                $stmtExec->close();              
              
              
              
              
              
            insertarLogI($idLogSeg, $arrayCliente);
            insertLogProspectoRPI($idLogSeg, $arrayProspecto);
            } else {
              $respuesta = array(
                'respuesta' => 'error'
              );
            }
        } else {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
    }

    die(json_encode($respuesta));
    $stmt->close();
    
    $buscarnumero = $telefonouno;
    $contador = 0;
    $conProspectoRP = 0;
    $conCommun = 0;
    
    /* CONSULTA PREPARA N°32 */
    
    $query="SELECT * FROM (SELECT v.IdVenta ID,v.FechaHoraREG,v.Matricula,v.Comercial,v.CC,v.NProspecto,v.TipoVenta,c.Telefonouno,c.Telefonodos,'Visita' OrigenVista FROM tblventa v 
    INNER JOIN tblcliente c on c.IdCliente=v.IdCliente
    WHERE (v.TipoVenta='RE' and v.CCOriginal!='511' and v.CCOriginal!='512')
    and (v.EstadoVenta='PendienteData' or v.EstadoVenta='PendienteAgenda' or v.EstadoVenta='AgendadaTEC' or v.EstadoVenta='AgendadaDEL' or v.EstadoVenta='NoVendida' or v.EstadoVenta='Cancelada' or v.EstadoVenta='Inviable' or v.EstadoVenta='Ilocalizable' or v.EstadoVenta='VAsignada') 
    and DATEDIFF(curdate(), v.FechaHoraREG) <=105 and
    (c.Telefonouno='?' or c.Telefonodos='?')
    UNION
    SELECT v.IdVenta ID,v.FechaHoraREG,v.Matricula,v.Comercial,v.CC,v.NProspecto,v.TipoVenta,c.Telefonouno,c.Telefonodos,'Televenta' FROM tblventa v 
    INNER JOIN tblcliente c on c.IdCliente=v.IdCliente
    WHERE v.TipoVenta='RE' and v.TCTipoVenta='TeleVenta'
    and (v.EstadoVenta='' or v.EstadoVenta is NULL or v.EstadoVenta='PendienteData' or v.EstadoVenta='PendienteAgenda' or v.EstadoVenta='AgendadaTEC' or v.EstadoVenta='AgendadaDEL' or v.EstadoVenta='NoVendida' or v.EstadoVenta='Cancelada' or v.EstadoVenta='Inviable' or v.EstadoVenta='Ilocalizable' or v.EstadoVenta='VAsignada') 
    and DATEDIFF(curdate(), v.FechaHoraREG) <=105 and
    (c.Telefonouno='?' or c.Telefonodos='?')
    UNION
    SELECT v.IdVenta,v.FechaHoraREG,v.Matricula,v.Comercial,v.CC,v.NProspecto,v.TipoVenta,c.Telefonouno,c.Telefonodos,'Venta' FROM tblventa v 
    INNER JOIN tblcliente c on c.IdCliente=v.IdCliente
    WHERE (v.TipoVenta='RP' OR v.TipoVenta='RPPR' OR v.TipoVenta='RPPA')   
    and (v.EstadoVenta='PendienteData' or v.EstadoVenta='PendienteAgenda' or v.EstadoVenta='AgendadaTEC' or v.EstadoVenta='AgendadaDEL' or v.EstadoVenta='NoVendida' or v.EstadoVenta='Cancelada' or v.EstadoVenta='Inviable' or v.EstadoVenta='Ilocalizable' or v.EstadoVenta='VAsignada') 
    and DATEDIFF(curdate(), v.FechaHoraREG) <=105 and
    (c.Telefonouno='?' or c.Telefonodos='?')
    UNION
    SELECT p.IdProspectoRP,p.FechaHoraREG,p.Matricula,p.Comercial,p.CC,p.NProspecto,p.TipoVenta,c1.Telefonouno,c1.Telefonodos,'ProspectoRP' FROM tblprospectorp p 
    INNER JOIN tblcliente c1 on c1.IdCliente=p.IdCliente
    WHERE (p.TipoVenta='RP') 
    and p.EstadoProspecto='ProspectoRP' 
    and DATEDIFF(curdate(), p.FechaHoraREG) <=105 and
    (c1.Telefonouno='?' or c1.Telefonodos='?')) t
    ORDER BY t.FechaHoraREG DESC";    
        
    $stmt = $con->prepare($query);
    $stmt->bind_param('ssssssss', $buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero);
    $stmt->execute();
    $stmt->store_result();
    
    $stmt->bind_result($ID,$FechaHoraREG,$Matricula,$Comercial,$CC,$NProspecto,$TipoVenta,$Telefonouno,$Telefonodos,$OrigenVisita);
    $numrows = $stmt->num_rows;
            
            if($OrigenVista=='ProspectoRP'){
                $conProspectoRP+=1;
            }else{
                $conCommun+=1;
            }

if($numrows<=1){
    
}else{
    if($conCommun==0){
        
    }else{
        
        $queryUsuario = "SELECT u.Matricula,CONCAT(u.Nombres,' ', u.Apellidos) Usuario,u.CC,u.Correo FROM yifi58ge_dbUSUARIO.tblusuario u WHERE u.Matricula=?";

    	try{       
            $stmt = $con->prepare($queryUsuario);
            $stmt->bind_param('s', $matriculausuario);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($USU,$USUCC,$USUCorreo);
            $stmt->fetch();
            $stmt->close();
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }        
    



    $correo_administrativo="lorena.pardo@verisure.pe";
    $correo_administrativo1="daniela.cahuina@verisure.pe";
    $correo_administrativo2="backoffice@verisure.pe";
    $correo_administrativo3="m.valenciaz@verisure.pe";
    
    //COPIA CORREO SUPERVISORES DE TELEVENTA
    
    $correo_administrativo4="carla.chumbile@verisure.pe";
    $correo_administrativo8="alejandro.delsante@verisure.pe";
    
    //COPIA CORREO GERENTE DC
    if($USUCC=="150"){
    $correo_administrativo5="boris.murga@verisure.pe";
    $correo_administrativo7="renzobranchi.branez@verisure.pe";
    }
    else if($USUCC=="151"){
    $correo_administrativo5="hector.vigo@verisure.pe";
    $correo_administrativo7="manuel.sgonzalez@securitasdirect.es";
    }
    else if($USUCC=="152"){
    $correo_administrativo5="cristhian.cuneo@verisure.pe";
    $correo_administrativo7="renzobranchi.branez@verisure.pe";
    }
    else if($USUCC=="153"){
    $correo_administrativo5="cesar.dealmeida@verisure.com.br";
    $correo_administrativo7="monicamaria.sanchez@verisure.pe";
    }
    else if($USUCC=="154"){
    $correo_administrativo5="david.adell@verisure.pe";
    $correo_administrativo7="manuel.sgonzalez@securitasdirect.es";
    }
    else if($USUCC=="155"){
    $correo_administrativo5="fernando.vera@verisure.cl";
    $correo_administrativo7="monicamaria.sanchez@verisure.pe";
    }
    else if($USUCC=="156"){
    $correo_administrativo5="juan.torregrosa@securitasdirect.es";
    $correo_administrativo7="manuel.sgonzalez@securitasdirect.es";
    }
    else if($USUCC=="157"){
    $correo_administrativo5="juan.ugaz@verisure.pe";
    $correo_administrativo7="renzobranchi.branez@verisure.pe";
    }
    else if($USUCC=="158"){
    $correo_administrativo5="r.barnuevo@verisure.pe";
    $correo_administrativo7="monicamaria.sanchez@verisure.pe";
    }
    else if($USUCC=="159"){
    $correo_administrativo5="jahir.goicochea@verisure.pe";
    $correo_administrativo7="renzobranchi.branez@verisure.pe";
    }    
    
    else if($USUCC=="120"){
    $correo_administrativo5="juliocesar.rojas@verisure.pe";
    $correo_administrativo7="manuel.sgonzalez@securitasdirect.es";
    }
    else if($USUCC=="100"){
    $correo_administrativo5="carlosomar.huazo@verisure.pe";
    $correo_administrativo7="manuel.sgonzalez@securitasdirect.es";
    }    
    else if($USUCC=="200"){
    $correo_administrativo5="michaeld.castillo@verisure.pe";
    $correo_administrativo7="monicamaria.sanchez@verisure.pe";
    }    
    else if($USUCC=="40"){
    $correo_administrativo5="oscar.meiggs@verisure.pe";
    $correo_administrativo7="renzobranchi.branez@verisure.pe";
    }
    else if($USUCC=="41"){
    $correo_administrativo5="carlosandree.moscoso@verisure.pe";
    $correo_administrativo7="renzobranchi.branez@verisure.pe";
    }

    else{
    $correo_administrativo5="";
    $correo_administrativo7="";   
    }   
    
    //CORREO PRUEBA
    $correo_prueba="joseenrique.nanquen@verisure.pe";
    
    //PARA PRUDCCION
    $para = '' . $correo_administrativo .", ".$correo_administrativo1.", ".$correo_administrativo2.", ".$correo_administrativo3.", ".$correo_administrativo4.", ".$correo_administrativo5.", ".$correo_administrativo7.", ".$correo_administrativo8.", ".$correo_prueba.", ".$USUCorreo.'' ;


    $titulo = "NOTIFICACION DE DUPLICIDAD";


$mensaje ='
<html>

<head>

<style>
 @font-face
	{font-family:Helvetica;
	panose-1:2 11 6 4 2 2 2 2 2 4;
	mso-font-charset:0;
	mso-generic-font-family:swiss;
	mso-font-pitch:variable;
	mso-font-signature:-536859905 -1073711037 9 0 511 0;}

      
 p.MsoNormal, li.MsoNormal, div.MsoNormal
	{mso-style-unhide:no;
	mso-style-qformat:yes;
        mso-style-parent:"";
	margin:0cm;
	margin-bottom:.0001pt;
	mso-pagination:widow-orphan;
	font-size:12.0pt;
	font-family:"Times New Roman","serif";
	mso-fareast-font-family:Calibri;
	mso-fareast-theme-font:minor-latin;}
h3
	{mso-style-priority:9;
	mso-style-unhide:no;
	mso-style-qformat:yes;
	mso-style-link:"Título 3 Car";
	mso-margin-top-alt:auto;
	margin-right:0cm;
	mso-margin-bottom-alt:auto;
	margin-left:0cm;
	mso-pagination:widow-orphan;
	mso-outline-level:3;
	font-size:13.5pt;
	font-family:"Times New Roman","serif";
	mso-fareast-font-family:Calibri;
	mso-fareast-theme-font:minor-latin;}
a:link, span.MsoHyperlink
	{mso-style-noshow:yes;
	mso-style-priority:99;
	color:blue;
	text-decoration:underline;
	text-underline:single;}
a:visited, span.MsoHyperlinkFollowed
	{mso-style-noshow:yes;
	mso-style-priority:99;
	color:purple;
	text-decoration:underline;
	text-underline:single;}
span.Ttulo3Car
	{mso-style-name:"Título 3 Car";
	mso-style-noshow:yes;
	mso-style-priority:9;
	mso-style-unhide:no;
	mso-style-locked:yes;
	mso-style-link:"Título 3";
	mso-ansi-font-size:12.0pt;
	mso-bidi-font-size:12.0pt;
	font-family:"Calibri Light","sans-serif";
	mso-ascii-font-family:"Calibri Light";
	mso-ascii-theme-font:major-latin;
	mso-fareast-font-family:"Helvetica";
	mso-fareast-theme-font:major-fareast;
	mso-hansi-font-family:"Calibri Light";
	mso-hansi-theme-font:major-latin;
	mso-bidi-font-family:"Times New Roman";
	mso-bidi-theme-font:major-bidi;
	color:#1F4D78;
	mso-themecolor:accent1;
	mso-themeshade:127;}
.MsoChpDefault
	{mso-style-type:export-only;
	mso-default-props:yes;
	font-size:10.0pt;
	mso-ansi-font-size:10.0pt;
	mso-bidi-font-size:10.0pt;}
@page WordSection1
	{size:612.0pt 792.0pt;
	margin:70.85pt 3.0cm 70.85pt 3.0cm;
	mso-header-margin:36.0pt;
	mso-footer-margin:36.0pt;
	mso-paper-source:0;}
div.WordSection1
	{page:WordSection1;}

</style>
</head>

<body bgcolor="#F2F2F2" lang=ES-PE link=blue vlink=purple style="tab-interval:35.4pt">
<div class=WordSection1>


<p class=MsoNormal><o:p>&nbsp;</o:p></p>

<div align=center>

<table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width="100%"
 style="width:100.0%;background:#F2F2F2;border-collapse:collapse;mso-yfti-tbllook:
 1184;mso-padding-alt:0cm 0cm 0cm 0cm">
 <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
  <td width="100%" valign=top style="width:100.0%;padding:15.0pt 15.0pt 15.0pt 15.0pt">
  <div align=center>
  <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=600
   style="width:650.0pt;border-collapse:collapse;mso-yfti-tbllook:1184;
   mso-padding-alt:0cm 0cm 0cm 0cm">
   <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes">
    <td valign=top style="padding:0cm 0cm 0cm 0cm">
    <div align=center>
    <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=600
     style="width:650.0pt;background:white;border-collapse:collapse;mso-yfti-tbllook:
     1184;mso-padding-alt:0cm 0cm 0cm 0cm">
     <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
      <td valign=top style="border-top:solid #D8D8D8 4.5pt;border-left:none;
      border-bottom:none;border-right:none;padding:6.75pt 0cm 0cm 0cm">
      <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
       width="100%" style="width:100.0%;border-collapse:collapse;mso-yfti-tbllook:
       1184;mso-padding-alt:0cm 0cm 0cm 0cm">
       <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
        <td valign=top style="padding:6.75pt 6.75pt 6.75pt 6.75pt">
        <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
         align=center width="100%" style="width:100.0%;border-collapse:collapse;
         mso-yfti-tbllook:1184;mso-table-lspace:2.25pt;mso-table-rspace:2.25pt;
         mso-table-anchor-vertical:paragraph;mso-table-anchor-horizontal:column;
         mso-table-left:left;mso-padding-alt:0cm 0cm 0cm 0cm">
         <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:
          yes">
          <td valign=top style="padding:0cm 6.75pt 0cm 6.75pt">
          <p class=MsoNormal><span><img
          width=118 height=73 id="_x0000_i1025"
          src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png"
          alt="Logo Verisure Peru"><o:p></o:p></span></p>
          </td>
         </tr>
        </table>
        </td>
       </tr>
      </table>
      </td>
     </tr>
    </table>
    </div>
    </td>
   </tr>
   <tr style="mso-yfti-irow:1;mso-yfti-lastrow:yes">
    <td valign=top style="padding:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
    -webkit-text-size-adjust: 100%">
    <div align=center>
    <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=600
     style="width:650.0pt;background:white;border-collapse:collapse;mso-yfti-tbllook:
     1184;mso-padding-alt:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
     -webkit-text-size-adjust: 100%;min-width: 100%" id=templateHeader>
     <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
      <td valign=top style="padding:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
      -webkit-text-size-adjust: 100%;min-width: 100%">
      <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
       width="100%" style="width:100.0%;border-collapse:collapse;mso-yfti-tbllook:
       1184;mso-padding-alt:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
       -webkit-text-size-adjust: 100%;min-width: 100%">
       <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
        <td valign=top style="padding:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
        -webkit-text-size-adjust: 100%">
        <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
         width="100%" style="width:100.0%;background:#F2F2F2;border-collapse:
         collapse;mso-yfti-tbllook:1184;mso-padding-alt:0cm 0cm 0cm 0cm;
         -ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%"
         id=bodyTable>
         <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:
          yes">
          <td valign=top style="padding:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
          -webkit-text-size-adjust: 100%">
          <div align=center>
          <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
           width=600 style="width:650.0pt;background:#DC0000;border-collapse:
           collapse;mso-yfti-tbllook:1184;mso-padding-alt:0cm 0cm 0cm 0cm;
           -ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%"
           id=emailContainer>
           <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:
            yes">
            <td valign=top style="padding:3.0pt 3.0pt 3.0pt 3.0pt;-ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%">
            <h3 align=center style="text-align:center"><span style="font-family:
            Helvetica,sans-serif;
            color:white">NOTIFICACI&Oacute;N VERISMART<o:p></o:p></span></h3>
            </td>
           </tr>
          </table>
          </div>
          </td>
         </tr>
        </table>
        </td>
       </tr>
      </table>
      <p class=MsoNormal><span style="
      display:none;mso-hide:all"><o:p>&nbsp;</o:p></span></p>
      <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
       width="100%" style="width:100.0%;border-collapse:collapse;mso-yfti-tbllook:
       1184;mso-padding-alt:0cm 0cm 0cm 0cm;min-width: 100%;-ms-text-size-adjust: 100%;
       -webkit-text-size-adjust: 100%">
       <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
        <td valign=top style="padding:6.75pt 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
        -webkit-text-size-adjust: 100%">
        <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
         align=left width="100%" style="width:100.0%;border-collapse:collapse;
         mso-yfti-tbllook:1184;margin-left:-2.25pt;margin-right:-2.25pt;
         mso-table-anchor-vertical:paragraph;mso-table-anchor-horizontal:column;
         mso-table-left:left;mso-padding-alt:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
         -webkit-text-size-adjust: 100%">
         <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:
          yes">
          <td width=600 valign=top style="width:650.0pt;padding:0cm 0cm 0cm 0cm;
          -ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
          <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
           align=left width="100%" style="width:100.0%;border-collapse:collapse;
           mso-yfti-tbllook:1184;mso-table-lspace:2.25pt;mso-table-rspace:2.25pt;
           mso-table-anchor-vertical:paragraph;mso-table-anchor-horizontal:
           column;mso-table-left:left;mso-padding-alt:0cm 0cm 0cm 0cm;
           -ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
           <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:
            yes">
            <td valign=top style="padding:0cm 13.5pt 6.75pt 13.5pt;max-width: 100%;
            min-width: 100%;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
            <p class=MsoNormal style="mso-margin-top-alt:auto;mso-margin-bottom-alt:
            auto;line-height:150%">
             <strong>
                <span style="font-size:11.0pt;
            line-height:150%;font-family:Helvetica,sans-serif;color:#606060">Estimado(s) Sr(es) </span>
            </strong>
         
                <br>
                
          
                 <span style="font-size:9.0pt;
            line-height:150%;font-family:Helvetica,sans-serif;color:#606060">Se detalla la informacion sobre los PROSPECTOS/VISITAS asociadas al n&#250;mero <strong>'.$buscarnumero.'</strong> ingresado por:</span>
           <br>
           <br>
           <table cellspacing="0" border="1" align="center" bordercolor="#ddd" style="width: 45%; text-align: left; font-size: 10pt;">
                                                     <tr>
                            <th style="width: 10%;font-size:9.0pt;line-height:150%;font-family:
            Helvetica,sans-serif;color:#606060; text-align: center;">MATRICULA</th>
                                <th style="width: 30%;font-size:9.0pt;line-height:150%;font-family:
            Helvetica,sans-serif;color:#606060; text-align: center;">COMERCIAL</th>
                               <th style="width: 5%;font-size:9.0pt;line-height:150%;font-family:
            Helvetica,sans-serif;color:#606060; text-align: center;">CC</th>
                            </tr>
                            <tr>
                            
              <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;
            color:#606060">'.$matriculausuario.'</td>
               <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;
            color:#606060">'.$USU.'</td>
              <td  style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;
            color:#606060">'.$USUCC.'</td>
            
            </tr>
                            
              </table>
           
          <br>
    
                    <strong><span style="font-size:9.0pt;line-height:150%;font-family:
            Helvetica,sans-serif;color:#606060">Total de registros ('.$numrows.'):</span></strong>
          <br>
         <br>
           
          <table cellspacing="0" border="1" align="center" bordercolor="#ddd" style="width: 95%; text-align: left; font-size: 10pt;">
                                                     <tr>
                           <th style="width: 5%;font-size:8.0pt;line-height:150%;font-family:
            Helvetica,sans-serif;color:#606060; text-align: center;">N&#176; ID</th>
                                <th style="width: 9.5%;font-size:8.0pt;line-height:150%;font-family:
            Helvetica,sans-serif;color:#606060; text-align: center;">N&#176; PROSPECTO</th>
                               <th style="width: 14%;font-size:8.0pt;line-height:150%;font-family:
            Helvetica,sans-serif;color:#606060; text-align: center;">FECHA REGISTRO</th>
                                <th style="width: 9.5%;font-size:8.0pt;line-height:150%;font-family:
            Helvetica,sans-serif;color:#606060; text-align: center;">MATRICULA</th>
                                <th style="width: 18.5%;font-size:8.0pt;line-height:150%;font-family:
            Helvetica,sans-serif;color:#606060; text-align: center;">COMERCIAL</th>
            
                                            <th style="width: 5%;font-size:8.0pt;line-height:150%;font-family:
            Helvetica,sans-serif;color:#606060; text-align: center;">CC</th>
                               <th style="width: 5%;font-size:8.0pt;line-height:150%;font-family:
            Helvetica,sans-serif;color:#606060; text-align: center;">TIPO VENTA</th>
                                <th style="width:9.5%;font-size:8.0pt;line-height:150%;font-family:
            Helvetica,sans-serif;color:#606060; text-align: center;">TELEFONO UNO</th>
                                <th style="width: 9.5%;font-size:8.0pt;line-height:150%;font-family:
            Helvetica,sans-serif;color:#606060; text-align: center;">TELEFONO DOS</th>
                                            <th style="width:9.5%;font-size:8.0pt;line-height:150%;font-family:
            Helvetica,sans-serif;color:#606060; text-align: center;">ORIGEN VISTA</th>
            <th style="width:5%;font-size:8.0pt;line-height:150%;font-family:
            Helvetica,sans-serif;color:#606060; text-align: center;"></th>
                            </tr>
                           ';
                           
        mysqli_data_seek($resultado,0);         
        while ($data = mysqli_fetch_assoc($resultado)) {
            
            $ID=$data['ID'];
            $FechaHoraREG=$data['FechaHoraREG'];
            $Matricula=$data['Matricula'];
            $Comercial=$data['Comercial'];
            $CC=$data['CC'];
            $NProspecto=$data['NProspecto'];
            $TipoVenta=$data['TipoVenta'];
            $Telefonouno=$data['Telefonouno'];
            $Telefonodos=$data['Telefonodos'];
           $OrigenVista=$data['OrigenVista'];
            $contador++;
            
            if($contador==1){
                $Nu='<span style="font-family:Helvetica,sans-serif;background-color: #d9534f;display: inline;
    padding: .2em .6em .3em;
    font-size: 95%;
    font-weight: 700;
    line-height: 1;
    color: #fff;
    text-align: center;
    white-space: nowrap;
    vertical-align: baseline;
    border-radius: .25em;">Nuevo</span>';
            }else{
                $Nu='-';
            }
            
        
       $mensaje.='
         <tr>
            <td style="text-align: center;font-size:8.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$ID.'</td>
            <td style="text-align: center;font-size:8.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$NProspecto.'</td>
            <td style="text-align: center;font-size:8.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$FechaHoraREG.'</td>
            <td style="text-align: center;font-size:8.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$Matricula.'</td>
            <td style="text-align: center;font-size:8.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$Comercial.'</td>
            <td style="text-align: center;font-size:8.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$CC.'</td>
            <td style="text-align: center;font-size:8.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$TipoVenta.'</td>
            <td style="text-align: center;font-size:8.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$Telefonouno.'</td>
            <td style="text-align: center;font-size:8.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$Telefonodos.'</td>
            <td style="text-align: center;font-size:8.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$OrigenVista.'</td>
            <td style="text-align: center;font-size:8.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$Nu.'</td>
         </tr>';
            
        }
        
        
        


$mensaje.='
 </table>
 
 <br> 
 <span
            style="font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;
            color:#606060">
Por seguridad, Verisure Per&#250; te informa:</span>
          <br>
          
          <div style="text-align: justify">
           <span
            style="font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;
            color:#606060">
Este correo electr&#243;nico contiene informaci&#243;n legal confidencial y privilegiada. Si Usted no es el destinatario a quien se desea enviar este mensaje, tendr&#225; prohibido darlo a conocer a persona alguna, as&#237; como a reproducirlo o copiarlo. Si recibe este mensaje por error, favor de notificarlo al remitente de inmediato y desecharlo de su sistema..
           </span>
              </div>
          <br>         
  
            <br>
            <strong>
            <span style="font-size:10.5pt;line-height:150%;font-family:Trebuchet MS,Helvetica,sans-serif;
            color:#ff0033">Verisure Per&uacute; SAC.</span></strong><br>
            <span style="font-size:8.5pt;line-height:150%;font-family:Trebuchet MS,Helvetica,sans-serif;
                  color:#606060">Av. Primavera 1050,Of.401 Santiago de Surco<br>
            15037,Lima, Per&uacute;</span></p>
            </td>
           </tr>
          </table>
          </td>
         </tr>
        </table>
        </td>
       </tr>
      </table>
      </td>
     </tr>
    </table>
    </div>
    </td>
   </tr>
  </table>
  </div>
  </td>
 </tr>
</table>

</div>

<p class=MsoNormal><span ><o:p>&nbsp;</o:p></span></p>

</div>

</body>

</html>';

//para el envío en formato HTML 
    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/html; charset=utf-8\r\n";

//dirección del remitente 
    $headers .= "From: VERISMART - Verisure Perú <notificacion.verismart@verismart.com.pe>\r\n";

//dirección de respuesta, si queremos que sea distinta que la del remitente 
    $headers .= "Reply-To: notificacion.verismart@verisure.pe\r\n";

//ruta del mensaje desde origen a destino 
    $headers .= "Return-path: notificacion.verismart@verismart.com.pe\r\n";

//direcciones que recibián copia 
    $headers .= "Cc: notificacion.verismart@verisure.pe\r\n";

//direcciones que recibirán copia oculta 
//$headers .= "Bcc: joecnan14@gmail.com\r\n"; 


mail($para, $titulo, $mensaje, $headers); 
    }
    

}
 
 
 
 
mysqli_close($con);

//mysqli_close($consec);



     