<?php

include('is_logged.php');

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require_once '../config/db.php';
require_once '../config/conexion.php';

$fecharegistroventa = date("Y-m-d H:i:s");
$ObjGeofinder = $_POST['ObjGeofinder'];
$matriculausuario=$_SESSION['matriculausuario'];


try{
    $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog_geofinder(matriculaUsuario, FechaHoraReg, objGeofinder) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $matriculausuario, $fecharegistroventa, $ObjGeofinder);
    $stmt->execute();
    
    $respuesta = $con->insert_id;
    
    $resultado = array(
            'respuesta' => 'exito',
            'id' => $respuesta
        );
        
    $stmt->close();
    
    
}catch (\Exception $e) {
    $resultado = array(
        'respuesta' => 'error',
        'mensaje' => $e->getMessage(),
    );
}

echo json_encode($resultado);
    