<?php


function editar_buscarProspecto($nprospecto,$nprospectohidden){
  global $con;
  
    if($nprospecto!=$nprospectohidden){
        if(empty($nprospecto)){
            return true;
        }else{

        try{
            $stmt = $con->prepare( "SELECT 1 FROM yifi58ge_dbVENTAS.tblventa v WHERE v.NProspecto= ? limit 1");
            $stmt->bind_param('s',$nprospecto);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($num);
            if($stmt->num_rows>0){
                return false;
            }else{
                return true;
            }
    	    
            $stmt->close();
    
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }        
            
        }

    }else{
       return true;
    }
    

}

function editar_buscarContrato($ncontrato,$ncontratohidden){
  global $con;
  
    if($ncontrato!=$ncontratohidden){
        if(empty($ncontrato)){
            return true;
        }else{

        try{
            $stmt = $con->prepare( "SELECT 1 FROM yifi58ge_dbVENTAS.tblventa v WHERE v.NContrato= ? limit 1");
            $stmt->bind_param('s',$ncontrato);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($num);
            if($stmt->num_rows>0){
                return false;
            }else{
                return true;
            }
    	    
            $stmt->close();
    
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }
            
        }

    }else{
       return true;
    }
    

}

function editarVenta_checkIn($idVenta, $tipo){
    
    global $con;
    
    if($tipo == 'Automatico'){
        $checkIn = 'SI';
        $mensaje = "CHECK IN VALIDADO";
        $tipomensaje = "success";
    } else if ($tipo == 'Manual' || $tipo == 'Inubicable'){
        $checkIn = 'NO';
        $mensaje = "UBICACIÓN ENVIADA, PENDIENTE VALIDAR POR EL BO";
        $tipomensaje = "warning";
    } else if ($tipo == 'FueraFecha'){
        $checkIn = 'NO';
        $mensaje = "UBICACIÓN ENVIADA FUERA DE FECHA, NO SE VALIDARÁ";
        $tipomensaje = "warning";
    }
    
    global $arrayDatos;
    global $VisitaNoVisitable;
    global $comentariosCheckIN;
    
    try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET Checkin=?, InfoCheckIn=? WHERE IdVenta =?");
        $stmt->bind_param("ssi",$checkIn, $arrayDatos, $idVenta);
        $stmt->execute();

        $rows = $stmt->affected_rows;
        
        if ($rows > 0) {
            $respuesta = array(
                'respuesta' => 'exito',
                'id_actualizado' => $idVenta,
                'tipo' => $tipo,
                'mensaje' => $mensaje,
                'tipomensaje' => $tipomensaje
            );
        } else {
            $respuesta = array(
                'respuesta' => ''
            );
        }
        
    }catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error',
            'mensaje' => $e->getMessage(),
        );
    }
    
    return $respuesta;
}

function editarVenta_CheckOut($idVenta, $totalHistorial){
    global $con;
    $tipomensaje = "success";
    $checkOut = 'SI';
    
    global $arrayDatos;
    
    try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET CheckOut=?, InfoCheckOut=?, totalHistorial=? WHERE IdVenta =?");
        $stmt->bind_param("sssi",$checkOut, $arrayDatos, $totalHistorial, $idVenta);
        $stmt->execute();

        $rows = $stmt->affected_rows;
        
        if ($rows > 0) {
            $respuesta = array(
                'respuesta' => 'exito',
                'id_actualizado' => $idVenta,
                'tipo' => "CHECKOUT",
                'mensaje' => "CHECKOUT GRABADO CON EXITO",
                'tipomensaje' => $tipomensaje,
                'arrayCheckIN' => $arrayDatos,
                'categoria' => "checkOUT"
            );
        } else {
            $respuesta = array(
                'respuesta' => 'SinCambios'
            );
        }
        
    }catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error',
            'mensaje' => $e->getMessage(),
        );
    }
    
    return $respuesta;
}

function editarVenta_CheckOut2($idVenta, $matricula, $comercial){
    global $con;
    $tipomensaje = "success";
    $checkOut = 'SI';
    
    global $arrayDatos;
    
    try{
        
        $fechaRegistro = date("Y-m-d H:i:s");
        $fechaModificacion = date("Y-m-d H:i:s");


        $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblhistorialcheckout(IdVenta, InfoCheckOut, Matricula, Comercial, FechaHoraREG, FechaHoraMod) VALUES (?,?,?,?,?,?)");
        $stmt->bind_param("isssss",$idVenta,$arrayDatos,$matricula,$comercial,$fechaRegistro,$fechaModificacion);
        $stmt->execute();
        $respuesta = $con->insert_id;
        $stmt->close();

        /*$stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET CheckOut=?, InfoCheckOut=?, totalHistorial=? WHERE IdVenta =?");
        $stmt->bind_param("sssi",$checkOut, $arrayDatos, $totalHistorial, $idVenta);
        $stmt->execute();

        $rows = $stmt->affected_rows;
        
        if ($rows > 0) {
            $respuesta = array(
                'respuesta' => 'exito',
                'id_actualizado' => $idVenta,
                'tipo' => "CHECKOUT",
                'mensaje' => "CHECKOUT GRABADO CON EXITO",
                'tipomensaje' => $tipomensaje,
                'arrayCheckIN' => $arrayDatos,
                'categoria' => "checkOUT"
            );
        } else {
            $respuesta = array(
                'respuesta' => 'SinCambios'
            );
        }*/
        
    }catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error',
            'mensaje' => $e->getMessage(),
        );
    }
    
    return $respuesta;
}

function editarVenta_CheckIn_v2($idVenta, $tipo){
    global $con;
    
    if($tipo == 'Automatico'){
        $checkIn = 'SI';
        $mensaje = "CHECK IN DENTRO DEL RANGO, SE NOTIFICARÁ AL GERENTE";
        $tipomensaje = "success";
    } else if ($tipo == 'Manual'){
        $checkIn = 'NO';
        $mensaje = "CHECK IN FUERA DEL RANGO, SE NOTIFICARÁ AL GERENTE";
        $tipomensaje = "success";
    } else if ($tipo == 'FueraFecha'){
        $checkIn = 'NO';
        $mensaje = "CHECK IN FUERA DE FECHA, SE NOTIFICARÁ AL GERENTE";
        $tipomensaje = "warning";
    } else if ($tipo == 'NoGeoreferenciado'){
        $checkIn = 'SI';
        $mensaje = "SE NOTIFICARÁ AL GERENTE";
        $tipomensaje = "success";
    }
    
    global $arrayDatos;
    
    try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET Checkin=?, InfoCheckIn=? WHERE IdVenta =?");
        $stmt->bind_param("ssi",$checkIn, $arrayDatos, $idVenta);
        $stmt->execute();

        $rows = $stmt->affected_rows;
        
        if ($rows > 0) {
            $respuesta = array(
                'respuesta' => 'exito',
                'id_actualizado' => $idVenta,
                'tipo' => $tipo,
                'mensaje' => $mensaje,
                'tipomensaje' => $tipomensaje,
                'arrayCheckIN' => $arrayDatos,
                'categoria' => "checkIN"
            );
        } else {
            $respuesta = array(
                'respuesta' => 'SinCambios'
            );
        }
        
    }catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error',
            'mensaje' => $e->getMessage(),
        );
    }
    
    return $respuesta;
}

function editarVenta_VnoV($idVenta, $VisitaNoVisitable, $arrayVnoV){
    global $con;
    global $fecharegistro;
    
    $CC = '511';
    
    try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET CC=?, VisitaNoVisitable=?, infoVNOV=?,FechaHoraTransferenciaTC=? WHERE IdVenta =?");
        $stmt->bind_param("isssi",$CC, $VisitaNoVisitable, $arrayVnoV, $fecharegistro,$idVenta);
        
         $stmt->execute();

        $rows = $stmt->affected_rows;
        
        if ($rows > 0) {
            
            $respuesta = array(
                'respuesta' => 'exito',
                'id_actualizado' => $idVenta,
                'arrayVnoV' => $arrayVnoV,
                'categoria' => "VnoV",
                'cc' => $CC
            );
        } else {
            $respuesta = array(
                'respuesta' => 'SinCambios'
            );
        }
        
    }catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error',
            'mensaje' => $e->getMessage(),
        );
    }
    
    return $respuesta;
}

?>