<?php

function actualizarTeleventa($idventa){
  global $con;

  global $categoria;
  global $estadoventa;
  global $n590;
  global $estadotelecierre;
  global $tipoventatc;
  global $movivonoventatc;
  global $cctc;
  global $gestortc;
  global $preciokittc;
  global $totalextratc;
  global $ingresokit;
  global $ingresoextras;
  global $ingresototal;
  global $extraautorizadotc;
  global $mesesautorizadostc;
  global $formadepagotc;
  global $PAItc;
  global $resumenventatc;
  global $comentariotc;
  global $estadovisita;
  global $tcscoring;
  global $tccompetencia;
  global $nprospecto;
  global $nprospectocc;
  global $mesteleventa;
  global $leadid;
  global $lblfrellamadaTC;
  global $lblhrellamadaTC;
  global $HidDesc3meses;
  

  try{
    $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET CategoriaVenta=?, EstadoVenta=?, N590=?, EstadoTelecierre=?, TCTipoVenta=?, TCMotivoNoVenta=?, CC=?, TCGestor=?, PrecioKit=?, TotalExtra=?, IngresoKIT=?, IngresoExtras=?, IngresoTotal=?, ExtraAutorizado=?, MesesAutorizado=?, FormaPago=?, PAI=?, ResumenVenta=?, TCComentario=?, EstadoVisita=?, TCScoring=?, TCCompetencia=?, NProspecto=?, NProspectoCC=?, MesTeleventa=?, LeadID=?, TCFechaRellamada=?, TCHoraRellamada=?,DescMeses=? WHERE IdVenta=?");
    $stmt->bind_param("ssssssssdddddsdssssssssssssssi",$categoria, $estadoventa, $n590, $estadotelecierre, $tipoventatc, $movivonoventatc, $cctc, $gestortc, $preciokittc, $totalextratc, $ingresokit, $ingresoextras, $ingresototal, $extraautorizadotc, $mesesautorizadostc, $formadepagotc, $PAItc, $resumenventatc, $comentariotc, $estadovisita, $tcscoring, $tccompetencia,
    $nprospecto, $nprospectocc, $mesteleventa, $leadid, $lblfrellamadaTC, $lblhrellamadaTC,$HidDesc3meses, $idventa);
    $stmt->execute();
    if ($stmt->affected_rows > 0) {
      $respuesta = array(
          'respuesta' => 'exito',
          'id_actualizado' => $idventa,
          'tipo' => 'televenta'
      );
    } else {
        $respuesta = array(
            'respuesta' => 'nada',
            'tipo' => 'televenta'
        );
    }
    $stmt->close();
  } catch (\Exception $e) {
      $respuesta = array(
        'respuesta' => 'error',
        'mensaje' => $e->getMessage(),
        'tipo' => 'televenta'
      );
  }

  return $respuesta;
}

function registrarHistoricoTeleventa($idventa){
    global $con;

    global $estadovisita;
    global $estadoventa;
    global $estadotelecierre;
    global $tipoventatc;
    global $movivonoventatc;
    global $cctc;
    global $gestortc;
    global $preciokittc;
    global $totalextratc;
    global $resumenventatc;
    global $extraautorizadotc;
    global $formadepagotc;
    global $mesesautorizadostc;
    global $PAItc;
    global $comentariotc;
    global $n590;
    global $gestor;
    global $fecharegistro;
    global $ccorigen;
    global $tcscoring;
    global $tccompetencia;

    try {

      $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tbltelecierrehist(IdVenta, EstadoVisita, EstadoVenta, EstadoTelecierre, TCTipoVenta, TCMotivoNoVenta, TCCC, TCGestor, TCPrecioKIT, TCTotalExtra, TCResumenVenta, TCExtraAutorizado, TCFormaPago, TCMesesAutorizado, TCPAI, TCComentario, TC590, GestorOrigen, FechaHoraREG,CCOriginal,TCScoring,TCCompetencia) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
      $stmt->bind_param('isssssisddsssdsssssiss', $idventa, $estadovisita, $estadoventa, $estadotelecierre, $tipoventatc, $movivonoventatc, $cctc, $gestortc, $preciokittc, $totalextratc, $resumenventatc, $extraautorizadotc, $formadepagotc, $mesesautorizadostc, $PAItc, $comentariotc, $n590, $gestor, $fecharegistro, $ccorigen, $tcscoring, $tccompetencia);
      $stmt->execute();

      $respuesta = array(
            'respuesta' => 'exito',
          );

      $stmt->close();
    } catch (\Exception $e) {
        $respuesta = array(
          'respuesta' => 'error',
          'mensaje' => $e->getMessage(),
          'tipo' => 'televenta'
        );
    }

    return $respuesta;
}

function totalGestiones($idventa){
  global $con;

  $sqlTotalGestiones = "SELECT count(*) totalGestiones
  FROM yifi58ge_dbACTIVIDADES.tbllog_estado
  WHERE Identificador = '".$idventa."' AND NombreEstado = 'EstadoTelecierre' AND ESTADO <> 'RegistroTeleventa' ";
  $resultadoTotalGestiones = $con->query($sqlTotalGestiones);

  while ($totalGestionesData = $resultadoTotalGestiones->fetch_assoc()) {
    $TotalGestiones = $totalGestionesData['totalGestiones'];
  }

  return $TotalGestiones;
}


//Nuevos funciones

function actualizarTeleventa_v2($idventa){
  global $con;

  global $categoria;
  global $estadoventa;
  global $n590;
  global $estadotelecierre;
  global $tipoventatc;
  global $movivonoventatc;
  global $cctc;
  global $gestortc;
  global $preciokittc;
  global $totalextratc;
  global $ingresokit;
  global $ingresoextras;
  global $ingresototal;
  global $extraautorizadotc;
  global $mesesautorizadostc;
  global $formadepagotc;
  global $PAItc;
  global $resumenventatc;
  global $comentariotc;
  global $estadovisita;
  global $tcscoring;
  global $tccompetencia;
  global $nprospecto;
  global $nprospectocc;
  global $mesteleventa;
  global $leadid;
  global $lblfrellamadaTC;
  global $lblhrellamadaTC;
  global $tipokittc;
  global $cantidadextratc;
  global $prioridad;
  global $formapagocuota;
  global $lblTotalCuotaMonitoreo;
  global $HidDesc3meses;
  global $segmento;
  
  global $fecharegistro; //Fecha de la modificacion
  
  $habilitadoTV = "NO";

  try{
    $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET CategoriaVenta=?, EstadoVenta=?, N590=?, EstadoTelecierre=?, TCTipoVenta=?, TCMotivoNoVenta=?, CC=?, TCGestor=?, PrecioKit=?, TotalExtra=?, IngresoKIT=?, IngresoExtras=?, IngresoTotal=?, ExtraAutorizado=?, MesesAutorizado=?, FormaPago=?, PAI=?, ResumenVenta=?, TCComentario=?, EstadoVisita=?, TCScoring=?, TCCompetencia=?, NProspecto=?, NProspectoCC=?, MesTeleventa=?, LeadID=?, TCFechaRellamada=?, TCHoraRellamada=?,TipoKIT=?,CantidadExtras=?,Prioridad=?,FormaPagoCuota=?, FechaGestionTC=?, HabilitadoTV=?, TotalCuotaMonitoreo=?, DescMeses=?,Segmento=? WHERE IdVenta=?");
    $stmt->bind_param("ssssssssdddddsdsssssssssssssssssssdssi",$categoria, $estadoventa, $n590, $estadotelecierre, $tipoventatc, $movivonoventatc, $cctc, $gestortc, $preciokittc, $totalextratc, $ingresokit, $ingresoextras, $ingresototal, $extraautorizadotc, $mesesautorizadostc, $formadepagotc, $PAItc, $resumenventatc, $comentariotc, $estadovisita, $tcscoring, $tccompetencia,
    $nprospecto, $nprospectocc, $mesteleventa, $leadid, $lblfrellamadaTC, $lblhrellamadaTC,$tipokittc,$cantidadextratc, $prioridad,$formapagocuota, $fecharegistro, $habilitadoTV, $lblTotalCuotaMonitoreo, $HidDesc3meses,$segmento, $idventa);
    $stmt->execute();
    if ($stmt->affected_rows > 0) {
      $respuesta = array(
          'respuesta' => 'exito',
          'id_actualizado' => $idventa,
          'tipo' => 'televenta',
          'FechaGestionTC' => $fecharegistro
      );
    } else {
        $respuesta = array(
            'respuesta' => 'nada',
            'tipo' => 'televenta'
        );
    }
    $stmt->close();
  } catch (\Exception $e) {
      $respuesta = array(
        'respuesta' => 'error',
        'mensaje' => $e->getMessage(),
        'tipo' => 'televenta'
      );
  }

  return $respuesta;
}

function actualizarTeleventa_v3($idventa){
  global $con;

  global $categoria;
  global $estadoventa;
  global $n590;
  global $estadotelecierre;
  global $tipoventatc;
  global $movivonoventatc;
  global $cctc;
  global $gestortc;
  global $preciokittc;
  global $totalextratc;
  global $ingresokit;
  global $ingresoextras;
  global $ingresototal;
  global $extraautorizadotc;
  global $mesesautorizadostc;
  global $formadepagotc;
  global $PAItc;
  global $resumenventatc;
  global $comentariotc;
  global $estadovisita;
  global $tcscoring;
  global $tccompetencia;
  global $nprospecto;
  global $nprospectocc;
  global $mesteleventa;
  global $leadid;
  global $lblfrellamadaTC;
  global $lblhrellamadaTC;
  global $tipokittc;
  global $cantidadextratc;
  global $prioridad;
  global $formapagocuota;
  global $lblTotalCuotaMonitoreo;
  global $HidDesc3meses;
  global $segmento;
  global $cantidadDias;
  global $TotalIntentos;
  
  global $fecharegistro; //Fecha de la modificacion
  
  $habilitadoTV = "NO";

  try{
    $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET CategoriaVenta=?, EstadoVenta=?, N590=?, EstadoTelecierre=?, TCTipoVenta=?, TCMotivoNoVenta=?, CC=?, TCGestor=?, PrecioKit=?, TotalExtra=?, IngresoKIT=?, IngresoExtras=?, IngresoTotal=?, ExtraAutorizado=?, MesesAutorizado=?, FormaPago=?, PAI=?, ResumenVenta=?, TCComentario=?, EstadoVisita=?, TCScoring=?, TCCompetencia=?, NProspecto=?, NProspectoCC=?, MesTeleventa=?, LeadID=?, TCFechaRellamada=?, TCHoraRellamada=?,TipoKIT=?,CantidadExtras=?,Prioridad=?,FormaPagoCuota=?, FechaGestionTC=?, HabilitadoTV=?, TotalCuotaMonitoreo=?, DescMeses=?,Segmento=?,TotalIntentos=?,CantidadDiasA=? WHERE IdVenta=?");
    $stmt->bind_param("ssssssssdddddsdsssssssssssssssssssdssiii",$categoria, $estadoventa, $n590, $estadotelecierre, $tipoventatc, $movivonoventatc, $cctc, $gestortc, $preciokittc, $totalextratc, $ingresokit, $ingresoextras, $ingresototal, $extraautorizadotc, $mesesautorizadostc, $formadepagotc, $PAItc, $resumenventatc, $comentariotc, $estadovisita, $tcscoring, $tccompetencia,
    $nprospecto, $nprospectocc, $mesteleventa, $leadid, $lblfrellamadaTC, $lblhrellamadaTC,$tipokittc,$cantidadextratc, $prioridad,$formapagocuota, $fecharegistro, $habilitadoTV, $lblTotalCuotaMonitoreo, $HidDesc3meses,$segmento,$TotalIntentos,$cantidadDias, $idventa);
    $stmt->execute();
    if ($stmt->affected_rows > 0) {
      $respuesta = array(
          'respuesta' => 'exito',
          'id_actualizado' => $idventa,
          'tipo' => 'televenta',
          'FechaGestionTC' => $fecharegistro
      );
    } else {
        $respuesta = array(
            'respuesta' => 'nada',
            'tipo' => 'televenta'
        );
    }
    $stmt->close();
  } catch (\Exception $e) {
      $respuesta = array(
        'respuesta' => 'error',
        'mensaje' => $e->getMessage(),
        'tipo' => 'televenta'
      );
  }

  return $respuesta;
}

//nuevoActualizarTeleventa
//Se agrego cantidad de regalos
function actualizarTeleventa_v4($idventa){
  global $con;
  
  global $categoria;
  global $estadoventa;
  global $n590;
  global $estadotelecierre;
  global $tipoventatc;
  global $movivonoventatc;
  global $cctc;
  global $gestortc;
  global $preciokittc;
  global $totalextratc;
  global $ingresokit;
  global $ingresoextras;
  global $ingresototal;
  global $extraautorizadotc;
  global $mesesautorizadostc;
  global $formadepagotc;
  global $PAItc;
  global $resumenventatc;
  global $comentariotc;
  global $estadovisita;
  global $tcscoring;
  global $tccompetencia;
  global $nprospecto;
  global $nprospectocc;
  global $mesteleventa;
  global $leadid;
  global $lblfrellamadaTC;
  global $lblhrellamadaTC;
  global $tipokittc;
  global $cantidadextratc;
  global $prioridad;
  global $formapagocuota;
  global $lblTotalCuotaMonitoreo;
  global $HidDesc3meses;
  global $segmento;
  global $cantidadDias;
  global $TotalIntentos;
  global $lblcantidadregalotc;
  global $lblorigen;
  global $lblnivel1;
  global $lblnivel2;
  
  global $fecharegistro; //Fecha de la modificacion
  
  $habilitadoTV = "NO";

  try{
    $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET CategoriaVenta=?, EstadoVenta=?, N590=?, EstadoTelecierre=?, TCTipoVenta=?, TCMotivoNoVenta=?, CC=?, TCGestor=?, PrecioKit=?, TotalExtra=?, IngresoKIT=?, IngresoExtras=?, IngresoTotal=?, ExtraAutorizado=?, MesesAutorizado=?, FormaPago=?, PAI=?, ResumenVenta=?, TCComentario=?, EstadoVisita=?, TCScoring=?, TCCompetencia=?, NProspecto=?, NProspectoCC=?, MesTeleventa=?, LeadID=?, TCFechaRellamada=?, TCHoraRellamada=?,TipoKIT=?,CantidadExtras=?,Prioridad=?,FormaPagoCuota=?, FechaGestionTC=?, HabilitadoTV=?, TotalCuotaMonitoreo=?, DescMeses=?, Segmento=?, TotalIntentos=?, CantidadDiasA=?, CantidadRegalo=?,OrigenVisita=?,Nivel_1=?,Nivel_2=? WHERE IdVenta=?");
    $stmt->bind_param("ssssssssdddddsdsssssssssssssssssssdssiiisssi",$categoria, $estadoventa, $n590, $estadotelecierre, $tipoventatc, $movivonoventatc, $cctc, $gestortc, $preciokittc, $totalextratc, $ingresokit, $ingresoextras, $ingresototal, $extraautorizadotc, $mesesautorizadostc, $formadepagotc, $PAItc, $resumenventatc, $comentariotc, $estadovisita, $tcscoring, $tccompetencia,
    $nprospecto, $nprospectocc, $mesteleventa, $leadid, $lblfrellamadaTC, $lblhrellamadaTC,$tipokittc,$cantidadextratc, $prioridad,$formapagocuota, $fecharegistro, $habilitadoTV, $lblTotalCuotaMonitoreo, $HidDesc3meses,$segmento,$TotalIntentos,$cantidadDias, $lblcantidadregalotc,$lblorigen,$lblnivel1,$lblnivel2, $idventa);
    $stmt->execute();
    if ($stmt->affected_rows > 0) {
      $respuesta = array(
          'respuesta' => 'exito',
          'id_actualizado' => $idventa,
          'tipo' => 'televenta',
          'FechaGestionTC' => $fecharegistro
      );
    } else {
        $respuesta = array(
            'respuesta' => 'nada',
            'tipo' => 'televenta'
        );
    }
    $stmt->close();
  } catch (\Exception $e) {
      $respuesta = array(
        'respuesta' => 'error',
        'mensaje' => $e->getMessage(),
        'tipo' => 'televenta'
      );
  }

  return $respuesta;
}

//nuevaActualizarTeleventa
//Se agrego arbol de tipificacion
function actualizarTeleventa_v5($idventa){
  global $con;
  
  global $categoria;
  global $estadoventa;
  global $n590;
  global $estadotelecierre;
  global $tipoventatc;
  global $movivonoventatc;
  global $cctc;
  global $gestortc;
  global $preciokittc;
  global $totalextratc;
  global $ingresokit;
  global $ingresoextras;
  global $ingresototal;
  global $extraautorizadotc;
  global $mesesautorizadostc;
  global $formadepagotc;
  global $PAItc;
  global $resumenventatc;
  global $comentariotc;
  global $estadovisita;
  global $tcscoring;
  global $tccompetencia;
  global $nprospecto;
  global $nprospectocc;
  global $mesteleventa;
  global $leadid;
  global $lblfrellamadaTC;
  global $lblhrellamadaTC;
  global $tipokittc;
  global $cantidadextratc;
  global $prioridad;
  global $formapagocuota;
  global $lblTotalCuotaMonitoreo;
  global $HidDesc3meses;
  global $segmento;
  global $cantidadDias;
  global $TotalIntentos;
  global $lblcantidadregalotc;
  global $lblorigen;
  global $lblnivel1;
  global $lblnivel2;
  global $lbltipoaccion;
  global $lblvueltas;
  global $lblfechaultimagestion;
  global $FechaTCFI;
  global $lblIteraccionAgenda;
  global $ultimaestado;
  global $IdConsultaScoring;
  global $lblprospectoabierto;
  
  global $comentariocancelacion;

  $habilitadoTV = "NO";
  
  if($lbltipoaccion=='gestion'){
      
    if($ultimaestado=="Cancelada" || $ultimaestado=="Inviable" || $ultimaestado=="Ilocalizable" || $ultimaestado==""){
        if($estadoventa=='PendienteAgenda' || $estadoventa=='PendienteData'){
            $lblIteraccionAgenda++;
            registrarAgendaReporte($idventa);         
        }         
        
    }

      
    if($estadoventa=='PendienteAgenda' || $estadoventa=='PendienteData'){
        if ($FechaTCFI == ''){
            $FechaTCFI=date("Y-m-d H:i:s");
        }else{
            $FechaTCFI=$FechaTCFI;
        }
    }
    
    if($estadoventa == 'ProspectoAbierto'){
        
    }
    
      try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET CategoriaVenta=?, EstadoVenta=?, N590=?, EstadoTelecierre=?, TCTipoVenta=?, TCMotivoNoVenta=?, CC=?, TCGestor=?, PrecioKit=?, TotalExtra=?, IngresoKIT=?, IngresoExtras=?, IngresoTotal=?, ExtraAutorizado=?, MesesAutorizado=?, FormaPago=?, PAI=?, ResumenVenta=?, TCComentario=?, EstadoVisita=?, TCScoring=?, TCCompetencia=?, NProspecto=?, NProspectoCC=?, MesTeleventa=?, LeadID=?, TCFechaRellamada=?, TCHoraRellamada=?,TipoKIT=?,CantidadExtras=?,Prioridad=?,FormaPagoCuota=?, FechaGestionTC=?, HabilitadoTV=?, TotalCuotaMonitoreo=?, DescMeses=?, Segmento=?, TotalIntentos=?, CantidadDiasA=?, CantidadRegalo=?,OrigenVisita=?,Nivel_1=?,Nivel_2=?,Vueltas=?,FechaUltimaGestion=?,FechaTCFI=?,IteraccionAgenda=?,IdConsultaScoringTCTV=?,ComentarioCancelacion=? WHERE IdVenta=?");
        $stmt->bind_param("ssssssssdddddsdsssssssssssssssssssdssiiisssissiisi",$categoria, $estadoventa, $n590, $estadotelecierre, $tipoventatc, $movivonoventatc, $cctc, $gestortc, $preciokittc, $totalextratc, $ingresokit, $ingresoextras, $ingresototal, $extraautorizadotc, $mesesautorizadostc, $formadepagotc, $PAItc, $resumenventatc, $comentariotc, $estadovisita, $tcscoring, $tccompetencia,
        $nprospecto, $nprospectocc, $mesteleventa, $leadid, $lblfrellamadaTC, $lblhrellamadaTC,$tipokittc,$cantidadextratc, $prioridad,$formapagocuota, $fecharegistro, $habilitadoTV, $lblTotalCuotaMonitoreo, $HidDesc3meses,$segmento,$TotalIntentos,$cantidadDias, $lblcantidadregalotc,$lblorigen,$lblnivel1,$lblnivel2,$lblvueltas,$lblfechaultimagestion,$FechaTCFI,$lblIteraccionAgenda,$IdConsultaScoring,$comentariocancelacion, $idventa);
        $stmt->execute();
        if ($stmt->affected_rows > 0) {
          $respuesta = array(
              'respuesta' => 'exito',
              'id_actualizado' => $idventa,
              'tipo' => 'televenta',
              'FechaGestionTC' => $fecharegistro
          );
        } else {
            $respuesta = array(
                'respuesta' => 'nada',
                'tipo' => 'televenta'
            );
        }
        $stmt->close();
      } catch (\Exception $e) {
          $respuesta = array(
            'respuesta' => 'error',
            'mensaje' => $e->getMessage(),
            'tipo' => 'televenta'
          );
      }

  }else if($lbltipoaccion=='informacion'){

      try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET CategoriaVenta=?, EstadoVenta=?, N590=?, TCTipoVenta=?, CC=?, TCGestor=?, PrecioKit=?, TotalExtra=?, IngresoKIT=?, IngresoExtras=?, IngresoTotal=?, ExtraAutorizado=?, MesesAutorizado=?, FormaPago=?, PAI=?, ResumenVenta=?, TCComentario=?, EstadoVisita=?, TCScoring=?, NProspecto=?, NProspectoCC=?, MesTeleventa=?, LeadID=?,TipoKIT=?,CantidadExtras=?,Prioridad=?,FormaPagoCuota=?, FechaGestionTC=?, HabilitadoTV=?, TotalCuotaMonitoreo=?, DescMeses=?, Segmento=?, TotalIntentos=?, CantidadDiasA=?, CantidadRegalo=?,OrigenVisita=?,IdConsultaScoringTCTV=?,ComentarioCancelacion=? WHERE IdVenta=?");
        $stmt->bind_param("ssssssdddddsdssssssssssssssssdssiiisisi",$categoria, $estadoventa, $n590, $tipoventatc, $cctc, $gestortc, $preciokittc, $totalextratc, $ingresokit, $ingresoextras, $ingresototal, $extraautorizadotc, $mesesautorizadostc, $formadepagotc, $PAItc, $resumenventatc, $comentariotc, $estadovisita, $tcscoring,
        $nprospecto, $nprospectocc, $mesteleventa, $leadid,$tipokittc,$cantidadextratc, $prioridad,$formapagocuota, $fecharegistro, $habilitadoTV, $lblTotalCuotaMonitoreo, $HidDesc3meses,$segmento,$TotalIntentos,$cantidadDias, $lblcantidadregalotc,$lblorigen,$IdConsultaScoring,$comentariocancelacion, $idventa);
        $stmt->execute();
        if ($stmt->affected_rows > 0) {
          $respuesta = array(
              'respuesta' => 'exito',
              'id_actualizado' => $idventa,
              'tipo' => 'televenta',
              'FechaGestionTC' => $fecharegistro
          );
        } else {
            $respuesta = array(
                'respuesta' => 'nada',
                'tipo' => 'televenta'
            );
        }
        $stmt->close();
      } catch (\Exception $e) {
          $respuesta = array(
            'respuesta' => 'error',
            'mensaje' => $e->getMessage(),
            'tipo' => 'televenta'
          );
      }

  }else{
        $respuesta = array(
        'respuesta' => 'error',
        'mensaje' => 'error',
        'tipo' => 'televenta'
      );
  }
   return $respuesta;
}

function registrarHistoricoTeleventa_v2($idventa){
    global $con;

    global $estadovisita;
    global $estadoventa;
    global $estadotelecierre;
    global $tipoventatc;
    global $movivonoventatc;
    global $cctc;
    global $gestortc;
    global $preciokittc;
    global $totalextratc;
    global $resumenventatc;
    global $extraautorizadotc;
    global $formadepagotc;
    global $mesesautorizadostc;
    global $PAItc;
    global $comentariotc;
    global $n590;
    global $gestor;
    global $fecharegistro;
    global $ccorigen;
    global $tcscoring;
    global $tccompetencia;
    global $prioridad;
    global $lblnivel1;
    global $lblnivel2;
    global $lbltipoaccion;
    
    try {

      $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tbltelecierrehist(IdVenta, EstadoVisita, EstadoVenta, EstadoTelecierre, TCTipoVenta, TCMotivoNoVenta, TCCC, TCGestor, TCPrecioKIT, TCTotalExtra, TCResumenVenta, TCExtraAutorizado, TCFormaPago, TCMesesAutorizado, TCPAI, TCComentario, TC590, GestorOrigen, FechaHoraREG,CCOriginal,TCScoring,TCCompetencia,Prioridad,Gestion,Nivel_1,Nivel_2) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?)");
      $stmt->bind_param('isssssisddsssdsssssissssss', $idventa, $estadovisita, $estadoventa, $estadotelecierre, $tipoventatc, $movivonoventatc, $cctc, $gestortc, $preciokittc, $totalextratc, $resumenventatc, $extraautorizadotc, $formadepagotc, $mesesautorizadostc, $PAItc, $comentariotc, $n590, $gestor, $fecharegistro, $ccorigen, $tcscoring, $tccompetencia, $prioridad,$lbltipoaccion,$lblnivel1,$lblnivel2);
      $stmt->execute();

      $respuesta = array(
            'respuesta' => 'exito',
          );

      $stmt->close();
    } catch (\Exception $e) {
        $respuesta = array(
          'respuesta' => 'error',
          'mensaje' => $e->getMessage(),
          'tipo' => 'televenta'
        );
    }

    return $respuesta;
}

//Se agrego arbol de tipificacion
function registrarHistoricoTeleventa_v3($idventa){
    global $con;

    global $estadovisita;
    global $estadoventa;
    global $estadotelecierre;
    global $tipoventatc;
    global $movivonoventatc;
    global $cctc;
    global $gestortc;
    global $preciokittc;
    global $totalextratc;
    global $resumenventatc;
    global $extraautorizadotc;
    global $formadepagotc;
    global $mesesautorizadostc;
    global $PAItc;
    global $comentariotc;
    global $n590;
    global $gestor;
    global $fecharegistro;
    global $ccorigen;
    global $tcscoring;
    global $tccompetencia;
    global $prioridad;
    global $lblnivel1;
    global $lblnivel2;
    global $lbltipoaccion;
    global $lblvueltas;
    global $lblfrellamadaTC;
    global $lblhrellamadaTC;
    
    global $comentariocancelacion;
    
    
    try {

      $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tbltelecierrehist(IdVenta, EstadoVisita, EstadoVenta, EstadoTelecierre, TCTipoVenta, TCMotivoNoVenta, TCCC, TCGestor, TCPrecioKIT, TCTotalExtra, TCResumenVenta, TCExtraAutorizado, TCFormaPago, TCMesesAutorizado, TCPAI, TCComentario, TC590, GestorOrigen, FechaHoraREG,CCOriginal,TCScoring,TCCompetencia,Prioridad,Gestion,Nivel_1,Nivel_2,Vueltas,TCFechaRellamada,TCHoraRellamada,ComentarioCancelacion) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?)");
      $stmt->bind_param('isssssisddsssdsssssissssssisss', $idventa, $estadovisita, $estadoventa, $estadotelecierre, $tipoventatc, $movivonoventatc, $cctc, $gestortc, $preciokittc, $totalextratc, $resumenventatc, $extraautorizadotc, $formadepagotc, $mesesautorizadostc, $PAItc, $comentariotc, $n590, $gestor, $fecharegistro, $ccorigen, $tcscoring, $tccompetencia, $prioridad,$lbltipoaccion,$lblnivel1,$lblnivel2,$lblvueltas,$lblfrellamadaTC,$lblhrellamadaTC,$comentariocancelacion);
      $stmt->execute();

      $respuesta = array(
            'respuesta' => 'exito',
          );

      $stmt->close();
    } catch (\Exception $e) {
        $respuesta = array(
          'respuesta' => 'error',
          'mensaje' => $e->getMessage(),
          'tipo' => 'televenta'
        );
    }

    return $respuesta;
}

function totalRegistros($idventa){
  global $con;

  $sqlTotalRegistros = "SELECT count(*) totalRegistros FROM tbltelecierrehist WHERE IdVenta = '".$idventa."'";
  $resultadoTotalRegistros= $con->query($sqlTotalRegistros);

  while ($totalRegistrosData = $resultadoTotalRegistros->fetch_assoc()) {
    $TotalRegistros = $totalRegistrosData['totalRegistros'];
  }

  return $TotalRegistros;
}

function establecerPrioridad($estadotelecierre, $estadoventa){
    
    global $idventa;
    global $movivonoventatc;
    $prioridad = null;
    
    switch($estadotelecierre){
        case 'PendienteRespuesta' :
            $prioridad = 'Alta';
            break;
        case 'NoContactado' :
            $totalIntentos = totalIntentos($estadotelecierre, $idventa);
            if ($totalIntentos <= 5 && ($movivonoventatc == 'Apagado' || $movivonoventatc == 'Timbranocontesta')){
                $prioridad = 'Alta';
            }
            elseif(($totalIntentos > 5 && $totalIntentos<=10) && ($movivonoventatc == 'Apagado' || $movivonoventatc == 'Timbranocontesta')){
                $prioridad = 'Media';
            }
            elseif($movivonoventatc == 'Telefononovalido'){
                $prioridad = NULL;
            }
            else{
                $prioridad = 'Baja';
            }
            break;
        case 'DevolverLlamada':
            $totalIntentos = totalIntentos($estadotelecierre, $idventa);
            if ($totalIntentos <= 5){
                $prioridad = 'Alta';
            }
            else if(($totalIntentos > 5 && $totalIntentos<=10)){
                $prioridad = 'Media';
            }
            else {
                $prioridad = 'Baja';
            }
            break;
        case 'NoVendida':
            if ($movivonoventatc == 'Competencia' || $movivonoventatc == 'Inviable'){
                $prioridad = null;
            } else {
                $prioridad = 'Baja';
            }
            break;
        default:
            $prioridad = null;
            break;
    }

    return $prioridad;
}

function establecerPrioridad2($estadotelecierre, $estadoventa){
    
    global $idventa;
    global $cantidadDias;
    global $fechareg;
    global $distrito;
    global $tcscoring;
    $prioridad = null;

    switch($estadotelecierre){
        case 'PendienteRespuesta' :
        case 'NoContactado' :
        case 'DevolverLlamada':    
            if ($cantidadDias==0  || $cantidadDias==1){
                if ($distrito==40  || $distrito==13 || $distrito==31 || $distrito==21 || $distrito==3 || $distrito==20 || $distrito==36){
                    if ($tcscoring=='OfertaExtraordinaria'){
                        $prioridad = 'Alta';
                    }else if($tcscoring=='SuperOferta'){
                        $prioridad = 'Alta';
                    }else if($tcscoring=='Oferta'){
                        $prioridad = 'Alta';
                    }else if($tcscoring=='OfertaEspecial'){
                        $prioridad = 'Alta';
                    }else{
                        $prioridad = NULL;
                    }
                    
                }else{
                    if ($tcscoring=='OfertaExtraordinaria'){
                        $prioridad = 'Alta';
                    }else if($tcscoring=='SuperOferta'){
                        $prioridad = 'Alta';
                    }else if($tcscoring=='Oferta'){
                        $prioridad = 'Media';
                    }else if($tcscoring=='OfertaEspecial'){
                        $prioridad = 'Baja';
                    }else{
                        $prioridad = NULL;
                    }
                    
                }
            }else if($cantidadDias==2){
                if ($distrito==40  || $distrito==13 || $distrito==31 || $distrito==21 || $distrito==3 || $distrito==20 || $distrito==36){
                    if ($tcscoring=='OfertaExtraordinaria'){
                        $prioridad = 'Alta';
                    }else if($tcscoring=='SuperOferta'){
                        $prioridad = 'Alta';
                    }else if($tcscoring=='Oferta'){
                        $prioridad = 'Alta';
                    }else if($tcscoring=='OfertaEspecial'){
                        $prioridad = 'Alta';
                    }else{
                        $prioridad = NULL;
                    }
                    
                }else{
                    if ($tcscoring=='OfertaExtraordinaria'){
                        $prioridad = 'Media';
                    }else if($tcscoring=='SuperOferta'){
                        $prioridad = 'Media';
                    }else if($tcscoring=='Oferta'){
                        $prioridad = 'Media';
                    }else if($tcscoring=='OfertaEspecial'){
                        $prioridad = 'Baja';
                    }else{
                        $prioridad = NULL;
                    }
                    
                }                
            }else if($cantidadDias==3  || $cantidadDias==5){
                if ($distrito==40  || $distrito==13 || $distrito==31 || $distrito==21 || $distrito==3 || $distrito==20 || $distrito==36){
                    if ($tcscoring=='OfertaExtraordinaria'){
                        $prioridad = 'Media';
                    }else if($tcscoring=='SuperOferta'){
                        $prioridad = 'Media';
                    }else if($tcscoring=='Oferta'){
                        $prioridad = 'Media';
                    }else if($tcscoring=='OfertaEspecial'){
                        $prioridad = 'Media';
                    }else{
                        $prioridad = NULL;
                    }
                    
                }else{
                    if ($tcscoring=='OfertaExtraordinaria'){
                        $prioridad = 'Baja';
                    }else if($tcscoring=='SuperOferta'){
                        $prioridad = 'Baja';
                    }else if($tcscoring=='Oferta'){
                        $prioridad = 'Baja';
                    }else if($tcscoring=='OfertaEspecial'){
                        $prioridad = 'Baja';
                    }else{
                        $prioridad = NULL;
                    }
                    
                }       
            }else if($cantidadDias==6  || $cantidadDias==30){
                if ($distrito==40  || $distrito==13 || $distrito==31 || $distrito==21 || $distrito==3 || $distrito==20 || $distrito==36){
                    if ($tcscoring=='OfertaExtraordinaria'){
                        $prioridad = 'TV2';
                    }else if($tcscoring=='SuperOferta'){
                        $prioridad = 'TV2';
                    }else if($tcscoring=='Oferta'){
                        $prioridad = 'TV2';
                    }else if($tcscoring=='OfertaEspecial'){
                        $prioridad = 'TV2';
                    }else{
                        $prioridad = NULL;
                    }
                    
                }else{
                    if ($tcscoring=='OfertaExtraordinaria'){
                        $prioridad = 'TV2';
                    }else if($tcscoring=='SuperOferta'){
                        $prioridad = 'TV2';
                    }else if($tcscoring=='Oferta'){
                        $prioridad = 'TV2';
                    }else if($tcscoring=='OfertaEspecial'){
                        $prioridad = 'TV2';
                    }else{
                        $prioridad = NULL;
                    }
                    
                }                   
            }else{
                if ($distrito==40  || $distrito==13 || $distrito==31 || $distrito==21 || $distrito==3 || $distrito==20 || $distrito==36){
                    if ($tcscoring=='OfertaExtraordinaria'){
                        $prioridad = 'TV3';
                    }else if($tcscoring=='SuperOferta'){
                        $prioridad = 'TV3';
                    }else if($tcscoring=='Oferta'){
                        $prioridad = 'TV3';
                    }else if($tcscoring=='OfertaEspecial'){
                        $prioridad = 'TV3';
                    }else{
                        $prioridad = NULL;
                    }
                    
                }else{
                    if ($tcscoring=='OfertaExtraordinaria'){
                        $prioridad = 'TV3';
                    }else if($tcscoring=='SuperOferta'){
                        $prioridad = 'TV3';
                    }else if($tcscoring=='Oferta'){
                        $prioridad = 'TV3';
                    }else if($tcscoring=='OfertaEspecial'){
                        $prioridad = 'TV3';
                    }else{
                        $prioridad = NULL;
                    }
                    
                }                    
            }
            break;
        default:
            $prioridad = NULL;
            break;
    }

    return $prioridad;
}

function totalIntentos($estadotelecierre, $idventa){
    global $con;
    
    $sql = "SELECT EstadoTelecierre, count(*) as 'Total'
            FROM tbltelecierrehist
            WHERE IdVenta = '".$idventa."' AND EstadoTelecierre = '".$estadotelecierre."'";
    $resultado = $con->query($sql);
    
    while($cantidad = $resultado->fetch_assoc()){
        
        $total = $cantidad['Total'];
    }
    
    $total++;
    
    return $total;
            
}

function fechaUltimaGestion($idventa){
    
    global $con;
    
    $sql = "SELECT FechaHoraREG 
            FROM tbltelecierrehist
            WHERE IdVenta = '".$idventa."'
            ORDER BY FechaHoraREG DESC LIMIT 1";
    $resultado = $con->query($sql);
    
    while ($fecha = $resultado->fetch_assoc()){
        $fechaUltimaGestion = $fecha['FechaHoraREG'];
    }
    
    return $fechaUltimaGestion;
}

function UltimoEstadoVenta($idventa){
    
    global $con;
    
    $sql = "SELECT EstadoVenta 
            FROM tblventa
            WHERE IdVenta = '".$idventa."'
            ";
    $resultado = $con->query($sql);
    
    while ($data = $resultado->fetch_assoc()){
        $ultimoestado = $data['EstadoVenta'];
    }
    
    return $ultimoestado;
}

//Se agrego arbol de tipificacion
function registrarAgendaReporte($idventa){
    global $con;

    global $fecharegistro;
    global $gestortc;
    global $cctc;
    global $lblIteraccionAgenda;
    global $distrito;
    
    try {

      $stmt = $con->prepare("INSERT INTO tblagendareporte(IdVenta, FechaVenta, Matricula, CC, Vueltas, IdGeografico) VALUES (?,?,?,?,?,?)");
      $stmt->bind_param('isssii', $idventa, $fecharegistro, $gestortc, $cctc, $lblIteraccionAgenda, $distrito);
      $stmt->execute();

      $respuesta = array(
            'respuesta' => 'exito',
          );

      $stmt->close();
    } catch (\Exception $e) {
        $respuesta = array(
          'respuesta' => 'error',
          'mensaje' => $e->getMessage(),
          'tipo' => 'televenta'
        );
    }

    return $respuesta;
}




?>
