<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';

date_default_timezone_set('America/Lima');

//LOG
$fecharegistro=date("Y-m-d H:i:s");
        $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
        $usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
        $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI']);
        $Acceso='Exportar';
        $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
        
        try {
                
          $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
          $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
          $stmt->execute();
          $stmt->close();
          
        } catch (\Exception $e) {
          echo $e->getMessage();
        }
//LIBRERIA DE EXPORTACION
require_once 'libreria/Spout/Autoloader/autoload.php';

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

$fileName = 'solicitudes.csv';

$writer = WriterEntityFactory::createCSVWriter();

$writer->openToBrowser($fileName);

$head = array(
    'ID Solicitud',
    'ID Acción',
    'Estado',
    'Matricula Gest.',
    'FechaHoraModificacion',
    'UsuarioModifica',
    'Fecha',
    'Hora',
    'N°Contrato',
    'Nombre',
    'Correo 1',
    'Correo 2',
    'Telefono',
    'Acción',
    'columna 1',
    'columna 2',
    'columna 3',
    'columna 4',
    'columna 5',
    'columna 6',
    'columna 7',
    'columna 8',
    'columna 9',
    'columna 10',
);
$rowFromValues = WriterEntityFactory::createRowFromArray($head);
$writer->addRow($rowFromValues);

$selectrows = htmlspecialchars($_GET['selectrows']);

$query= "SELECT 
            s.IdSolicitud,
            sd.IdDetalleSolicitud,
            sd.Estado,
            u.Matricula,
            sd.FechaHoraModificacion,
            uM.Matricula MatriculaModifica,
            DATE_FORMAT(s.FechaHoraReg, '%Y-%m-%d') Fecha, 
            DATE_FORMAT(s.FechaHoraReg,'%H:%i:%s')  Hora,
            s.NCliente,
            s.Cliente,
            s.Correo,
            s.Correo2,
            s.Telefono,
            sd.Solicitud,
            sd.Detalle
        FROM tblsolicitudes s
        INNER JOIN tblsolicitudesDetalle sd ON s.IdSolicitud = sd.IdSolicitud
        INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON s.idUsuario = u.idUsuario
        LEFT JOIN yifi58ge_dbUSUARIO.tblusuario uM ON sd.UsuarioModifica = uM.idUsuario
        WHERE sd.IdDetalleSolicitud IN (".$selectrows.")";

$result = $con->query($query);
$i=0;

while ($datos = $result->fetch_assoc()){
    //$arreglo[] = $datos;
    
    $arreglo[$i]['IdSolicitud'] = $datos['IdSolicitud'];
    $arreglo[$i]['IdDetalleSolicitud'] = $datos['IdDetalleSolicitud'];
    $arreglo[$i]['Estado'] = $datos['Estado'];
    $arreglo[$i]['Matricula'] = $datos['Matricula'];
    $arreglo[$i]['FechaHoraModificacion'] = $datos['FechaHoraModificacion'];
    $arreglo[$i]['UsuarioModifica'] = $datos['MatriculaModifica'];
    $arreglo[$i]['Fecha'] = $datos['Fecha'];
    $arreglo[$i]['Hora'] = $datos['Hora'];
    $arreglo[$i]['NCliente'] = $datos['NCliente'];
    $arreglo[$i]['Cliente'] = $datos['Cliente'];
    $arreglo[$i]['Correo'] = $datos['Correo'];
    $arreglo[$i]['Correo2'] = $datos['Correo2'];
    $arreglo[$i]['Telefono'] = $datos['Telefono'];
    $arreglo[$i]['Solicitud'] = $datos['Solicitud'];
    
    
    
    if($datos['Detalle'] != '' || $datos['Detalle'] != null){
        $Detalle = json_decode($datos['Detalle'], true);
        
        if($datos['Solicitud'] == "registroTarjeta"){
            $columna1 = "'".$Detalle['columna1'];
        } else {
            $columna1 = $Detalle['columna1'];
        }
        
        $columna2= $Detalle['columna2'];
        $columna3= $Detalle['columna3'];
        $columna4= $Detalle['columna4'];
        $columna5= $Detalle['columna5'];
        $columna6= $Detalle['columna6'];
        $columna7= $Detalle['columna7'];
        $columna8= $Detalle['columna8'];
        $columna9= $Detalle['columna9'];
        $columna10= $Detalle['columna10'];

        if(!empty($columna8)){
            $columna8 = $columna8; 
        }else{
            $columna8 = '';  
        }
        if(!empty($columna9)){
            $columna9 = $columna9; 
        }else{
            $columna9 = '';  
        }
        if(!empty($columna10)){
            $columna10 = $columna10; 
        }else{
            $columna10 = '';  
        }          
        
        $arreglo[$i]['columna1'] = $columna1;
        $arreglo[$i]['columna2'] = $columna2;
        $arreglo[$i]['columna3'] = $columna3;
        $arreglo[$i]['columna4'] = $columna4;
        $arreglo[$i]['columna5'] = $columna5;
        $arreglo[$i]['columna6'] = $columna6;
        $arreglo[$i]['columna7'] = $columna7;
        $arreglo[$i]['columna8'] = $columna8;
        $arreglo[$i]['columna9'] = $columna9;
        $arreglo[$i]['columna10'] = $columna10;
    } else {
        $arreglo[$i]['columna1'] = '';
        $arreglo[$i]['columna2'] = '';
        $arreglo[$i]['columna3'] = '';
        $arreglo[$i]['columna4'] = '';
        $arreglo[$i]['columna5'] = '';
        $arreglo[$i]['columna6'] = '';
        $arreglo[$i]['columna7'] = '';
        $arreglo[$i]['columna8'] = '';
        $arreglo[$i]['columna9'] = '';
        $arreglo[$i]['columna10'] = '';
    }
    
    $i++;
    
}

for($i=0; $i<count($arreglo); $i++){
    $rowData = WriterEntityFactory::createRowFromArray($arreglo[$i]);
    $writer->addRow($rowData);
}

$result->close();

$writer->close();

$con->close();

?>