<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
//LOG
require_once 'log/insertLog.php';
//LIBRERIA DE EXPORTACION
require_once 'libreria/Spout/Autoloader/autoload.php';

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

$fileName = 'Televenta.csv';

$writer = WriterEntityFactory::createCSVWriter();

$writer->openToBrowser($fileName);

$head = array(
'IdVenta',
'EstadoVenta',
'EstadoVisita',
'CC',
'CCOriginal',
'Matricula',
'Comercial',
'FechaVisita',
'FVencimientoVisita',
'N590',
'Checkin',
'Segmento',
'NProspecto',
'NContrato',
'Cliente',
'EstadoTelecierre',
'TCGestor',
'TCMotivoNoventa',
'TCComentario',
'TCTipoVenta',
'PrecioKit',
'TotalExtra',
'InstaladoX',
'FechaInst',
'HoraInst',
'Contactividad',
'TCVisitado',
'TCScoring',
'TCCompetencia',
'MesVisita',
'FechaHoraREG',
'NProspectoCC',
'TipoTV',
'Telefonouno',
'Telefonodos',
'Provincia',
'Distrito',
'MesTeleventa',
'LeadID',
'IMP',
'DescMeses'
);
$rowFromValues = WriterEntityFactory::createRowFromArray($head);
$writer->addRow($rowFromValues);

date_default_timezone_set('America/Lima');

$fecharegistro=date("Y-m-d H:i:s");

$result_exec = StmtInsertarLogSeguridad_General('Exportar', $fecharegistro, '', '');


$query="SELECT v.IdVenta,
IFNULL(v.EstadoVenta,'') EstadoVenta,
IFNULL(v.EstadoVisita,'') EstadoVisita,
IFNULL(v.CC,'') CC,
IFNULL(v.CCOriginal,'') CCOriginal,
IFNULL(v.Matricula,'') Matricula,
IFNULL(v.Comercial,'') Comercial,
IFNULL(v.FechaVisita,'') FechaVisita,
IFNULL(v.FVencimientoVisita,'') FVencimientoVisita,
IFNULL(STR_TO_DATE(CONCAT(v.n590,',01'),'%b-%Y,%d'),'') n590,
IFNULL(v.checkin,'') checkin,
IFNULL(v.Segmento,'') Segmento,
IFNULL(v.NProspecto,'') NProspecto,
IFNULL(v.NContrato,'') NContrato,
IFNULL(c.NombApellido,'') Cliente,
IFNULL(v.EstadoTelecierre,'') EstadoTelecierre,
IFNULL(v.TCGestor,'') TCGestor,
IFNULL(v.TCMotivoNoventa,'') TCMotivoNoventa,
IFNULL(v.TCComentario,'') TCComentario,
IFNULL(v.TCTipoVenta,'') TCTipoVenta,
IFNULL(v.PrecioKit,'') PrecioKit,
IFNULL(v.TotalExtra,'') TotalExtra,
IFNULL(a.InstaladoX,'') InstaladoX,
IFNULL(a.FechaInst,'') FechaInst,
IFNULL(a.HoraInst,'') HoraInst,
IFNULL(COUNT(t.IdVenta),0) Contactividad,
IFNULL(v.TCVisitado,'') TCVisitado,
IFNULL(v.TCScoring,'') TCScoring,
IFNULL(v.TCCompetencia,'') TCCompetencia,
IFNULL(STR_TO_DATE(CONCAT(v.MesVisita,',01'),'%b-%Y,%d'),'') MesVisita,
IFNULL(v.FechaHoraREG,'') FechaHoraREG,
IFNULL(v.NProspectoCC,'') NProspectoCC,
IFNULL(v.TipoTV,'') TipoTV,
IFNULL(REPLACE(c.Telefonouno, '_','') ,'') Telefonouno,
IFNULL(REPLACE(c.Telefonodos, '_','') ,'') Telefonodos,
IFNULL(g.Provincia,'') Provincia,
IFNULL(g.Distrito,'') Distrito,
IFNULL(STR_TO_DATE(CONCAT(v.MesTeleventa,',01'),'%b-%Y,%d'),'') MesTeleventa,
IFNULL(v.LeadID,'') LeadID,
IFNULL(v.IMP,'') IMP,
v.DescMeses
FROM yifi58ge_dbVENTAS.tblventa v 
INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=v.IdUsuario 
INNER JOIN yifi58ge_dbVENTAS.tblagenda a ON a.IdVenta=v.IdVenta 
INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
LEFT JOIN  yifi58ge_dbVENTAS.tbltelecierrehist t ON t.IdVenta=v.IdVenta
WHERE v.TipoVenta =  'RE'
and (v.CC='512' or v.CC='511')
GROUP BY v.IdVenta
";
/*ID(23466) desde 2019-04 hacia adelante*/
/*ID(29636) desde 2019-06 hacia adelante*/

$result = $con->query($query);



while ($Venta = $result->fetch_assoc()){
  $rowData = WriterEntityFactory::createRowFromArray($Venta);
  $writer->addRow($rowData);
}



$result->close();

$writer->close();

$con->close();

?>
