<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');

require '../config/db.php';
require '../config/conexion.php';
require_once '../helper/helper_validacion.php';

// Verificar si 'ncontrato' y 'categoria' están definidos en $_POST
if(isset($_POST['ncontrato']) && isset($_POST['categoria'])){
    $ncontrato= htmlspecialchars($_POST['ncontrato']);   
    $categoria= htmlspecialchars($_POST['categoria']);  

    // Si la categoría es 'Delegacion' y el número de contrato no está vacío
    if($categoria === 'Delegacion' && !empty($ncontrato)){
        // Realizar la validación del número de contrato
        $numContratos = validarNContrato($ncontrato);
    //   var_dump($numContratos);
        if($numContratos > 0){
            echo json_encode(["respuesta" => "exito"]); // Devolver éxito como JSON
            // validarNContratodos();
        } else {
            echo json_encode(["respuesta" => "Denegado"]); // Devolver Denegado como JSON
        }
    }
}

function validarNContrato($val){
    global $con;
    $contratoPresente = 0;
    try{
        // Query corregido y preparado con placeholders
        $sql = $con->prepare("SELECT 1 FROM yifi58ge_dbGUIAREMISION.guia WHERE contrato = ? AND contrato_presente = ?"); // hacer un inner join con la tbla tblventa de la base VENTAS
        $sql->bind_param('si',$val,$contratoPresente);
        $sql->execute();
        $sql->store_result();
        $row_cnt = $sql->num_rows;
        $sql->close();
        
    } catch (\Exception $e) {
        $row_cnt = 0;
    }
    
    return $row_cnt;
    
}

// function validarNContratodos(){
//     global $con;
//     try{
//         $tamano_lote = 1000;
        
//         $query="SELECT COUNT(*) FROM yifi58ge_dbVENTAS.tblventa";
//         $resultado= mysqli_query($con, $query);
//         $total_registros=mysqli_num_rows($resultado);
//         $inicio = 0;
//         $queryUsuario="UPDATE yifi58ge_dbGUIAREMISION.guia g
//                                   SET contrato_presente = (
//                                       CASE
//                                           WHEN EXISTS (
//                                               SELECT 1
//                                               FROM yifi58ge_dbVENTAS.tblventa tv
//                                               WHERE tv.NContrato = g.contrato
//                                           ) THEN 1
//                                           ELSE 0
//                                       END
//                                   )
//                                   LIMIT".$inicio.",".$tamano_lote."";

//         while ($inicio < $total_registros) {
            
//             $resultado= mysqli_query($con, $queryUsuario);
//             $inicio += $tamano_lote;
//         }

//     } catch (\Exception $e) {
//         // Manejo de errores
//     }
// }
?>
