<?php 

function consultaDatosCorreo($idventa){
    global $con;
    
    try{
        $stmt = $con->prepare( "SELECT 
    v.Matricula MatriculaComercial, 
    v.Comercial, 
    v.CC Delegacion,
    v.CCOriginal DelegacionOriginal, 
    u.Manager MatriculaJefeVenta, 
    u.Correo CorreoComercial, 
    CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta, 
    m.Correo CorreoJefeVenta, 
    CONCAT(del.Nombres,' ',del.Apellidos) NombDelegado, 
    del.Correo CorreoDelegado,  
    v.EstadoVenta, 
    v.TipoVenta, 
    v.Segmento, 
    v.NProspecto, 
    v.N590, 
    v.TCGestor,
    CONCAT(tc.Nombres,' ',tc.Apellidos) NombTCGestor,
    tc.Correo CorreoTCGestor,
    c.IdCliente, 
    c.NombApellido as NombCliente
    FROM tblventa v
    INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario u ON v.IdUsuario = u.IdUsuario
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario m ON u.Manager = m.Matricula
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario del ON m.Manager = del.Matricula
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario ori ON v.GestorOrigen = ori.Matricula
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario tc ON v.TCGestor = tc.Matricula
    WHERE v.IdVenta=?");
        $stmt->bind_param('i', $idventa);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($MatriculaComercial,
        $Comercial,
        $Delegacion,
        $DelegacionOriginal,
        $MatriculaJefeVenta,
        $CorreoComercial,
        $NombJefeVenta,
        $CorreoJefeVenta,
        $NombDelegado,
        $CorreoDelegado,
        $EstadoVenta,
        $TipoVenta,
        $Segmento,
        $NProspecto,
        $N590,
        $TCGestor,
        $NombTCGestor,
        $CorreoTCGestor,
        $IdCliente,
        $NombCliente);
        $data = [];        
        while ($stmt->fetch()){
        $data[] = array_map("utf8_encode",
        ['MatriculaComercial'=>$MatriculaComercial,
            'Comercial'=>$Comercial,
            'Delegacion'=>$Delegacion,
            'DelegacionOriginal'=>$DelegacionOriginal,
            'MatriculaJefeVenta'=>$MatriculaJefeVenta,
            'CorreoComercial'=>$CorreoComercial,
            'NombJefeVenta'=>$NombJefeVenta,
            'CorreoJefeVenta'=>$CorreoJefeVenta,
            'NombDelegado'=>$NombDelegado,
            'CorreoDelegado'=>$CorreoDelegado,
            'EstadoVenta'=>$EstadoVenta,
            'TipoVenta'=>$TipoVenta,
            'Segmento'=>$Segmento,
            'NProspecto'=>$NProspecto,
            'N590'=>$N590,
            'TCGestor'=>$TCGestor,
            'NombTCGestor'=>$NombTCGestor,
            'CorreoTCGestor'=>$CorreoTCGestor,
            'IdCliente'=>$IdCliente,
            'NombCliente'=>$NombCliente
            ]);            
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
    return $data;
}


function enviarNotifiacionCorreo_test($idventa,$comentarioagenda,$dc){
    global $con;
    $datosCorreos=consultaDatosCorreo($idventa);
    
    $MatriculaComer=$datosCorreos[0]['MatriculaComercial'];
    $CorreoComercial =$datosCorreos[0]['CorreoComercial'];
    $CorreoJefeVenta =$datosCorreos[0]['CorreoJefeVenta'];
    $CorreoDelegado=$datosCorreos[0]['CorreoDelegado'];
    $Cliente= $datosCorreos[0]['NombCliente'];
    $TCGestor =$datosCorreos[0]['TCGestor'];
    $CorreoTCGestor = $datosCorreos[0]['CorreoTCGestor'];

    $tituloCorreo = "NOTIFICACION AGENDA - ".$idventa;
    
    if($dc==602){

       
//HTML DE NOTIFICACION
$mensajeCorreo = '
            <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                <html xmlns="http://www.w3.org/1999/xhtml">
                    <head>
                        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                        <title>A Simple Responsive HTML Email</title>
                        <style type="text/css">
                            body {
                                margin: 0;
                                padding: 0;
                                min-width: 100%!important;
                            }
                            
                            img {
                                height: auto;
                            }
                            
                            .content {
                                width: 100%;
                                max-width: 600px;
                            }
                            
                            .header {
                                padding: 5px 20px 5px 20px;
                            }
                            
                            .innerpadding {
                                padding: 20px 30px 0px 30px;
                            }
                            
                            .borderbottom {
                                border-bottom: 1px solid #f2eeed;
                            }
                            
                            .subhead {
                                font-size: 15px;
                                color: #ffffff;
                                font-family: sans-serif;
                                letter-spacing: 10px;
                            }
                            
                            .h1 {
                                font-family: sans-serif;
                                color: #ffffff;
                                font-size: 23px;
                                line-height: 38px;
                                font-weight: bold;
                            }
                            
                            .h2 {
                                color: #000000;
                                font-family: sans-serif;
                                padding: 0 0 15px 0;
                                font-size: 24px;
                                line-height: 28px;
                                font-weight: bold;
                            }
                            
                            .h3 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 14px;
                                line-height: 22px;
                                font-weight: bold;
                            }
                            
                            .h4 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 16px;
                                line-height: 30px;
                                font-weight: bold;
                            }
                            
                            .bodycopy {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 14px;
                                line-height: 22px;
                            }
                            
                            .button {
                                text-align: center;
                                font-size: 18px;
                                font-family: sans-serif;
                                font-weight: bold;
                                padding: 0 30px 0 30px;
                            }
                            
                            .button a {
                                color: #ffffff;
                                text-decoration: none;
                            }
                            
                            .footer {
                                padding: 20px 30px 15px 30px;
                            }
                            
                            .footercopy {
                                font-family: sans-serif;
                                font-size: 14px;
                                color: #ffffff;
                            }
                            
                            .footercopy a {
                                color: #ffffff;
                                text-decoration: underline;
                            }
                            
                            .coldiv115 {
                                width: 115px;
                            }
                            
                            ;
                            .coldiv380 {
                                width: 380px;
                            }
                            
                            ;
                            @media only screen and (max-width: 550px),
                            screen and (max-device-width: 550px) {
                                body[yahoo] .hide {
                                    display: none!important;
                                }
                                body[yahoo] .buttonwrapper {
                                    background-color: transparent!important;
                                }
                                body[yahoo] .button {
                                    padding: 0px!important;
                                }
                                body[yahoo] .button a {
                                    background-color: #e05443;
                                    padding: 15px 15px 13px!important;
                                }
                                body[yahoo] .unsubscribe {
                                    display: block;
                                    margin-top: 20px;
                                    padding: 10px 50px;
                                    background: #2f3942;
                                    border-radius: 5px;
                                    text-decoration: none!important;
                                    font-weight: bold;
                                }
                            }
                        </style>
                    </head>

                    <body yahoo bgcolor="#f2f2f2">
                        <table width="100%" bgcolor="#f2f2f2" border="0" cellpadding="0" cellspacing="0">
                            <tr>
                                <td>
                                    <table bgcolor="#ffffff" class="content" align="center" cellpadding="0" cellspacing="0" border="0">
                                        <tr>
                                            <td bgcolor="#ffffff" class="header">
                                                <table width="70" align="center" border="0" cellpadding="0" cellspacing="0">
                                                    <tr>
                                                        <td height="70" style="padding: 0 20px 20px 0;">
                                                            <img class="fix" src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png" border="0" alt="" />
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                    
                                        <tr>
                                            <td bgcolor="#dc0000" class="header">
                                                <table class="col425" align="center" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 425px;">
                                                    <tr>
                                                        <td height="70">
                                                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                                <tr>
                                                                    <h1 class="h1" align="center" style="padding: 0 0 0 0;">VERISMART</h1>
                                                                    <h1 class="h1" align="center" style="padding: 0 0 0 0;">NOTIFICACION AGENDA</h1>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                    
                                        <tr>
                                            <td class="innerpadding">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td class="h2">
                                                            Estimado usuario,
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="bodycopy">
                                                            <p>Nos complace informarle que se ha enviado una notificación por Agenda</p>
                                                            <p>Cliente: '.$Cliente.'</p>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="innerpadding">
                                                <p>Se realizo: '.$comentarioagenda.'</p>
                                              
                                                <p>Por favor, para cualquier consulta, contacta con Agenda (agendacomercial@verisure.pe).</p>
                                                <p>Muchas gracias y un saludo.</p>
                                                <p>IT Perú</p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="footer" bgcolor="#44525f">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td align="center" class="footercopy">
                                                            2021 &reg; Verisure Perú SAC<br/> Av. Primavera 1050 – Oficina 501<br/> Santiago de Surco – Urbanización Chacarilla del Estanque<br/> Lima – Perú
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </body>
            
            </html>
        ';
        


        
        $opts = array(
            'http'=>array(
            'method'=>"GET",
            'header'=>"User-Agent: api script\r\n"
            )
        );
        
        $context = stream_context_create($opts);
        $curl = curl_init();
    
    
        
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => 'Agenda Comercial',
            'From' => 'agendacomercial@verisure.pe',
            'To' => 
            array (
              'Email' => 
              array (
                0 => 'fatima.chavezcuba@verisure.pe',
                1 => 'g.padilla@verisure.pe'
              )                
            ),
            'Cc' => 
            array (
              'Email' => 
              array (
                0 => 'jocelyn.delgado@verisure.pe',
              )
            ),
            'Bcc' => 
            array (
              'Email' => 
              array (
                0 => 'joseenrique.nanquen@verisure.pe',
              )
            ),
            'Message' => 
            array (
              'Subject' => $tituloCorreo,
              'Classification' => 'C',
              'Body' => 
              array (
                'Format' => 'html',
                "Value"=> $mensajeCorreo
              )
            ),
            'Options' => 
            array (
              'OpenTracking' => 'true',
              'ClickTracking' => 'true',
              'TextHtmlTracking' => 'true',
              'AutoTextBody' => 'false',
            )
          )
        );

        $dataSC_string = json_encode($dataSC);

        
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 60,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => $dataSC_string,
          CURLOPT_HTTPHEADER => array(
            "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
            "cache-control: no-cache",
            "content-type: application/json"
          ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
          return "cURL Error #:" . $err;
        } else {
          return $response;
        }

    }

}


function enviarNotifiacionCorreo_Telecierre($idventa,$comentarioagenda,$dc){
    global $con;
    $datosCorreos=consultaDatosCorreo($idventa);
    
    $MatriculaComer=$datosCorreos[0]['MatriculaComercial'];
    $Delegacion=$datosCorreos[0]['Delegacion'];
    $DelegacionOriginal=$datosCorreos[0]['DelegacionOriginal'];
    $CorreoComercial =$datosCorreos[0]['CorreoComercial'];
    $CorreoJefeVenta =$datosCorreos[0]['CorreoJefeVenta'];
    $CorreoDelegado=$datosCorreos[0]['CorreoDelegado'];
    $Cliente= $datosCorreos[0]['NombCliente'];
    $TCGestor =$datosCorreos[0]['TCGestor'];
    $NProspecto=$datosCorreos[0]['NProspecto'];
    $CorreoTCGestor = $datosCorreos[0]['CorreoTCGestor'];
    $EstadoVenta=$datosCorreos[0]['EstadoVenta'];
    
    /*
    $sql = "SELECT 
    v.Matricula MatriculaComercial, 
    v.Comercial, 
    v.CC Delegacion, 
    v.CCOriginal DelegacionOriginal, 
    u.Manager MatriculaJefeVenta, 
    u.Correo CorreoComercial, 
    CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta, 
    m.Correo CorreoJefeVenta, 
    CONCAT(del.Nombres,' ',del.Apellidos) NombDelegado, 
    del.Correo CorreoDelegado,  
    v.EstadoVenta, 
    v.TipoVenta, 
    v.Segmento, 
    v.NProspecto, 
    v.N590, 
    v.TCGestor,
    CONCAT(tc.Nombres,' ',tc.Apellidos) NombTCGestor,
    tc.Correo CorreoTCGestor,
    c.IdCliente, 
    c.NombApellido as NombCliente
    FROM tblventa v
    INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario u ON v.IdUsuario = u.IdUsuario
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario m ON u.Manager = m.Matricula
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario del ON m.Manager = del.Matricula
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario ori ON v.GestorOrigen = ori.Matricula
    LEFT JOIN yifi58ge_dbUSUARIO.tblusuario tc ON v.TCGestor = tc.Matricula
    
    WHERE v.IdVenta='.$idventa.'";
    
        $resultado = mysqli_query($con, $sql);
        
        while($data = $resultado->fetch_assoc()){
            $MatriculaComer=$data['MatriculaComercial'];
            $Delegacion=$data['Delegacion'];
            $DelegacionOriginal=$data['DelegacionOriginal'];
            $CorreoComercial = $data['CorreoComercial'];
            $CorreoJefeVenta = $data['CorreoJefeVenta'];
            $CorreoDelegado=$data['CorreoDelegado'];
            $Cliente=$data['NombCliente'];
            $TCGestor = $data['TCGestor'];
            $NProspecto=$data['NProspecto'];
            $CorreoTCGestor = $data['CorreoTCGestor'];
            $EstadoVenta=$data['EstadoVenta'];
        }
    
*/

    $tituloCorreo = "NOTIFICACION TELECIERRE - PROSPECTO ".$NProspecto;
    
            $mensajeCorreo = '
            <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                <html xmlns="http://www.w3.org/1999/xhtml">
                    <head>
                        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                        <title>A Simple Responsive HTML Email</title>
                        <style type="text/css">
                            body {
                                margin: 0;
                                padding: 0;
                                min-width: 100%!important;
                            }
                            
                            img {
                                height: auto;
                            }
                            
                            .content {
                                width: 100%;
                                max-width: 600px;
                            }
                            
                            .header {
                                padding: 5px 20px 5px 20px;
                            }
                            
                            .innerpadding {
                                padding: 20px 30px 0px 30px;
                            }
                            
                            .borderbottom {
                                border-bottom: 1px solid #f2eeed;
                            }
                            
                            .subhead {
                                font-size: 15px;
                                color: #ffffff;
                                font-family: sans-serif;
                                letter-spacing: 10px;
                            }
                            
                            .h1 {
                                font-family: sans-serif;
                                color: #ffffff;
                                font-size: 23px;
                                line-height: 38px;
                                font-weight: bold;
                            }
                            
                            .h2 {
                                color: #000000;
                                font-family: sans-serif;
                                padding: 0 0 15px 0;
                                font-size: 24px;
                                line-height: 28px;
                                font-weight: bold;
                            }
                            
                            .h3 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 14px;
                                line-height: 22px;
                                font-weight: bold;
                            }
                            
                            .h4 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 16px;
                                line-height: 30px;
                                font-weight: bold;
                            }
                            
                            .bodycopy {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 14px;
                                line-height: 22px;
                            }
                            
                            .button {
                                text-align: center;
                                font-size: 18px;
                                font-family: sans-serif;
                                font-weight: bold;
                                padding: 0 30px 0 30px;
                            }
                            
                            .button a {
                                color: #ffffff;
                                text-decoration: none;
                            }
                            
                            .footer {
                                padding: 20px 30px 15px 30px;
                            }
                            
                            .footercopy {
                                font-family: sans-serif;
                                font-size: 14px;
                                color: #ffffff;
                            }
                            
                            .footercopy a {
                                color: #ffffff;
                                text-decoration: underline;
                            }
                            
                            .coldiv115 {
                                width: 115px;
                            }
                            
                            ;
                            .coldiv380 {
                                width: 380px;
                            }
                            
                            ;
                            @media only screen and (max-width: 550px),
                            screen and (max-device-width: 550px) {
                                body[yahoo] .hide {
                                    display: none!important;
                                }
                                body[yahoo] .buttonwrapper {
                                    background-color: transparent!important;
                                }
                                body[yahoo] .button {
                                    padding: 0px!important;
                                }
                                body[yahoo] .button a {
                                    background-color: #e05443;
                                    padding: 15px 15px 13px!important;
                                }
                                body[yahoo] .unsubscribe {
                                    display: block;
                                    margin-top: 20px;
                                    padding: 10px 50px;
                                    background: #2f3942;
                                    border-radius: 5px;
                                    text-decoration: none!important;
                                    font-weight: bold;
                                }
                            }
                        </style>
                    </head>

                    <body yahoo bgcolor="#f2f2f2">
                        <table width="100%" bgcolor="#f2f2f2" border="0" cellpadding="0" cellspacing="0">
                            <tr>
                                <td>
                                    <table bgcolor="#ffffff" class="content" align="center" cellpadding="0" cellspacing="0" border="0">
                                        <tr>
                                            <td bgcolor="#ffffff" class="header">
                                                <table width="70" align="center" border="0" cellpadding="0" cellspacing="0">
                                                    <tr>
                                                        <td height="70" style="padding: 0 20px 20px 0;">
                                                            <img class="fix" src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png" border="0" alt="" />
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                    
                                        <tr>
                                            <td bgcolor="#dc0000" class="header">
                                                <table class="col425" align="center" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 425px;">
                                                    <tr>
                                                        <td height="70">
                                                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                                <tr>
                                                                    <h1 class="h1" align="center" style="padding: 0 0 0 0;">VERISMART</h1>
                                                                    <h1 class="h1" align="center" style="padding: 0 0 0 0;">NOTIFICACION AGENDA</h1>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                    
                                        <tr>
                                            <td class="innerpadding">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td class="h2">
                                                            Estimado usuario,
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="bodycopy">
                                                            <p>Nos complace informarle que se ha enviado una notificación por Agenda</p>
                                                            <p>Cliente: '.$Cliente.'</p>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="innerpadding">
                                                <p>Se realizo: '.$EstadoVenta.' a TELECIERRE - PROSPECTO '.$NProspecto.' </p>
                                                <p>Por favor, para cualquier consulta, contacta con Telecierre (telecierre@verisure.pe) o Raul Rubio (raul.rubio@verisure.pe) .</p>
                                                <p>Muchas gracias.</p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="footer" bgcolor="#44525f">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td align="center" class="footercopy">
                                                            2021 &reg; Verisure Perú SAC<br/> Av. Primavera 1050 – Oficina 501<br/> Santiago de Surco – Urbanización Chacarilla del Estanque<br/> Lima – Perú
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </body>
            
            </html>
        ';

        //Destinatario
        //$paraCorreo = $correoDelegado.", joseenrique.nanquen@verisure.pe, janpierre.vargas@verisure.pe";
        
        if( $DelegacionOriginal == 150 || $DelegacionOriginal == 152||$DelegacionOriginal == 157 || $DelegacionOriginal == 159 || $DelegacionOriginal == 251 || $DelegacionOriginal == 100){
            $correoTerritorial="renzobranchi.branez@verisure.pe";
        } else if ($DelegacionOriginal == 151 || $DelegacionOriginal == 156 || $DelegacionOriginal == 154 || $DelegacionOriginal == 120 || $DelegacionOriginal == 121 || $DelegacionOriginal == 140 || $DelegacionOriginal == 200){
            $correoTerritorial="manuel.sgonzalez@securitasdirect.es";
        } else if ($DelegacionOriginal == 153 || $DelegacionOriginal == 155 || $DelegacionOriginal == 250 || $DelegacionOriginal == 158 || $DelegacionOriginal == 40 || $DelegacionOriginal == 41 ){
            $correoTerritorial="monicamaria.sanchez@verisure.pe";
        }
        
        
        $paraCorreo = "joseenrique.nanquen@verisure.pe, raul.rubio@verisure.pe ,janpierre.vargas@verisure.pe,agendacomercial@verisure.pe,luisangel.serrano@verisure.pe,alejandro.delsante@verisure.pe,".$CorreoDelegado.",".$correoTerritorial."\r\n";
        
        //para el envío en formato HTML 
        $headersCorreo = "MIME-Version: 1.0\r\n";
        $headersCorreo .= "Content-type: text/html; charset=utf-8\r\n";
        
        //dirección del remitente 
            $headersCorreo .= "From: Sistema de Ventas Verismart - Verisure Perú <soporteit@verismart.com.pe>\r\n";
        
        //dirección de respuesta, si queremos que sea distinta que la del remitente 
            $headersCorreo .= "Reply-To: telecierre@verisure.pe\r\n";
        
        //ruta del mensaje desde origen a destino 
            $headersCorreo .= "Return-path: soporteit@verismart.com.pe\r\n";
        
        //direcciones que recibián copia 
            //$headersCorreo .= "cc: ".$correojefe.", ".$copia1."\r\n"; 
        
        //direcciones que recibirán copia oculta 
        //$headersCorreo .= "Bcc: ".$correo_prueba."\r\n"; 
        
        mail($paraCorreo, $tituloCorreo, $mensajeCorreo, $headersCorreo);
        
        
}