<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}


$ingresokit=0;
$ingresoextras=0;
$ingresototal=0;


require '../config/db.php';
require '../config/conexion.php';
include '../helper/helper_validacion.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

//AGREGAR FUNCIONES LOG
include 'log/insertLog.php';
include 'log/insertLogVisita.php';
include 'log/insertLogCliente.php';
//FUNCIONES DE VENTA
include 'funciones/Venta.php';

$matricula = sanitizaCampo($_POST['lblmatricula'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$matricula = htmlspecialchars($matricula);

$nombcomercial = sanitizaCampo($_POST['lblnombcomercial'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$nombcomercial = htmlspecialchars($nombcomercial);

$dc = sanitizaCampo($_POST['lbldc'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$dc = htmlspecialchars($dc);

$jefeventa = sanitizaCampo($_POST['lbljefeventa'], 'sanitizestring|scapestring|htmlspecialchars',$con); 
$jefeventa = htmlspecialchars($jefeventa);

$estadoventa = sanitizaCampo($_POST['lblestadoventa'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$estadoventa = htmlspecialchars($estadoventa);

$tipoventa = sanitizaCampo($_POST['lbltipoventa'], 'sanitizestring|scapestring|htmlspecialchars',$con); 
$tipoventa = htmlspecialchars($tipoventa);

$segmento = sanitizaCampo($_POST['lblsegmento'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$segmento = htmlspecialchars($segmento);

$categoria = sanitizaCampo($_POST['lblcategoria'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$categoria = htmlspecialchars($categoria);

$idcliente = sanitizaCampo($_POST['lblidcliente'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$idcliente = htmlspecialchars($idcliente);

$nombcliente = sanitizaCampo($_POST['lblnombcliente'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$nombcliente = htmlspecialchars($nombcliente);

$correo = sanitizaCampo($_POST['lblcorreo'], 'sanitizestring|scapestring|htmlspecialchars',$con); 
$correo = htmlspecialchars($correo);

$direccion = sanitizaCampo($_POST['lbldireccion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$direccion = htmlspecialchars($direccion);

$distrito = sanitizaCampo($_POST['lbldistrito'], 'sanitizestring|scapestring|htmlspecialchars',$con); 
$distrito = htmlspecialchars($distrito);

$telefonouno = sanitizaCampo($_POST['lblmovil'], 'sanitizestring|scapestring|htmlspecialchars',$con); 
$telefonouno = htmlspecialchars($telefonouno);

$telefonodos = sanitizaCampo($_POST['lblfijo'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$telefonodos = htmlspecialchars($telefonodos);

$idusuario = sanitizaCampo($_POST['lblidusuario'], 'sanitizeint|scapestring|htmlspecialchars',$con); 
$idusuario = htmlspecialchars($idusuario);

$matriculausuario = $_SESSION['matriculausuario'];

$fechmod=date("Y-m-d H:i:s");
$fecharegistro=date("Y-m-d H:i:s");
$fecharegistroventa=date("Y-m-d H:i:s");

$idventa = sanitizaCampo($_POST['lblidventa'], 'sanitizeint|scapestring|htmlspecialchars',$con); 
$idventa = htmlspecialchars($idventa);

$estvisita = sanitizaCampo($_POST['lblestvisita'], 'sanitizestring|scapestring|htmlspecialchars',$con); 
$estvisita = htmlspecialchars($estvisita);

//MODIFICACION EMU 17.05 
if(isset($_POST['ValFObras'])){
    $fobras = sanitizaCampo($_POST['ValFObras'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $fobras = htmlspecialchars($fobras);
} else {
    $fobras='NO';  
}

// $queryFechaVisitaObra = '';

//MODIFICACION EMU 21.05

if($_POST['lblFVisitaReal'] != ''){

    $fvisitaObras = sanitizaCampo($_POST['lblFVisitaReal'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $fvisitaObras = htmlspecialchars($fvisitaObras);

    $fechaconvertlblfvisitaObra = myUrlEncode($fvisitaObras);
    $fechagrabarfvisitaObra = format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertlblfvisitaObra));
    /*$queryFechaVisitaObra = "FVisitaObras = '".$fechagrabarfvisitaObra."'";*/

} else {
    // $queryFechaVisitaObra = "FVisitaObras = NULL";
    $fechagrabarfvisitaObra = NULL;
}


$comentariovisita = sanitizaCampo($_POST['lblcomentariovisita'], 'sanitizestring|scapestring|htmlspecialchars',$con);  
$comentariovisita = htmlspecialchars($comentariovisita);
    
$asignadopor = sanitizaCampo($_POST['lblasignado'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$asignadopor = htmlspecialchars($asignadopor);

$nprospecto = sanitizaCampo($_POST['lblnprospecto'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$nprospecto = htmlspecialchars($nprospecto);

$nprospectohidden = sanitizaCampo($_POST['lblnprospectohidden'], 'sanitizestring|scapestring|htmlspecialchars',$con); 
$nprospectohidden = htmlspecialchars($nprospectohidden);

$origen = sanitizaCampo($_POST['lblorigen'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$origen = htmlspecialchars($origen);

$fvencimiento = sanitizaCampo($_POST['lblfvencimiento'], 'sanitizestring|scapestring|htmlspecialchars',$con); 
$fvencimiento = htmlspecialchars($fvencimiento);

$fvisita = sanitizaCampo($_POST['lblfvisita'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$fvisita = htmlspecialchars($fvisita);

$hvisita = sanitizaCampo($_POST['lblhvisita'], 'sanitizestring|scapestring|htmlspecialchars',$con); 
$hvisita = htmlspecialchars($hvisita);

$checkin = sanitizaCampo($_POST['hidden_checki'], 'sanitizestring|scapestring|htmlspecialchars',$con); 
$checkin = htmlspecialchars($checkin);

$mesvisita = sanitizaCampo($_POST['lblmesvisita'], 'sanitizestring|scapestring|htmlspecialchars',$con); 
$mesvisita = htmlspecialchars($mesvisita);

$leadid = sanitizaCampo($_POST['lblleadid'], 'sanitizestring|scapestring|htmlspecialchars',$con); 
$leadid = htmlspecialchars($leadid);


$fechaconvertvencimiento=  myUrlEncode($fvencimiento);
$fechagrabarvencimiento=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertvencimiento));
$fechaconvertfvisita=  myUrlEncode($fvisita);
$fechagrabarfvisita=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfvisita));

$horaconvertvisita=  myUrlEncode($hvisita);
$horagrabarvisita=  date("H:i:s", strtotime(str_replace("+"," ",$horaconvertvisita)));

$lblcctc = sanitizaCampo($_POST['lblcctc'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblcctc = htmlspecialchars($lblcctc); 

//DOCUMENTO Visita
if (empty($_POST['lblIdDocVisita'])){
    $IdDocVisita = NULL;
} else {

    $IdDocVisita = sanitizaCampo($_POST['lblIdDocVisita'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $IdDocVisita = htmlspecialchars($IdDocVisita);
}

 $tipodoc = sanitizaCampo($_POST['lbltipodoc'], 'sanitizestring|scapestring|htmlspecialchars',$con);
 $tipodoc = htmlspecialchars($tipodoc);

 $documento = sanitizaCampo($_POST['lbldocumento'], 'sanitizestring|scapestring|htmlspecialchars',$con);
 $documento = htmlspecialchars($documento);

 $Referencia = sanitizaCampo($_POST['lblreferencia'], 'sanitizestring|scapestring|htmlspecialchars',$con);
 $Referencia = htmlspecialchars($Referencia);


// if (isset($_POST['lblinterior'])){
if ($_POST['lblinterior'] != ""){
    $interior = sanitizaCampo($_POST['lblinterior'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $interior = htmlspecialchars($interior);
} else {
    $interior = null;
}

// if (isset($_POST['objGeofinder'])){
if ($_POST['objGeofinder'] != ""){
    $objGeofinder = $_POST['objGeofinder'];
} else {
    $objGeofinder = null;
}

$lbldireccionAprox = sanitizaCampo($_POST['lbldireccionAprox'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lbldireccionAprox = htmlspecialchars($lbldireccionAprox);

// if (isset($_POST['lbltipoDireccion'])){
if ($_POST['lbltipoDireccion'] != ""){
    $lbltipoDireccion = $_POST['lbltipoDireccion'];
} else {
    $lbltipoDireccion = null;
}

$tiposegmento=sanitizaCampo($_POST['lbltiposegmento'],'sanitizestring|scapestring|htmlspecialchars',$con);
$tiposegmento = htmlspecialchars($tiposegmento);
$npiso=sanitizaCampo($_POST['lblnpiso'],'sanitizestring|scapestring|htmlspecialchars',$con);
$npiso = htmlspecialchars($npiso);
$tipovial=sanitizaCampo($_POST['tipovial'],'sanitizestring|scapestring|htmlspecialchars',$con);
$tipovial = htmlspecialchars($tipovial);

$motivoasignacion=sanitizaCampo($_POST['lblasignacion'],'sanitizestring|scapestring|htmlspecialchars',$con);
$motivoasignacion=htmlspecialchars($motivoasignacion);
$contactoasignacion=htmlspecialchars($_POST['lblcontactoasignacion']);
$cumpleranking=htmlspecialchars($_POST['lblcumpleranking']);

   $visePiso=htmlspecialchars($_POST['visePiso']);
        if($visePiso==""){
            $visePiso=null;
        }        
        $rubroNeg=htmlspecialchars($_POST['rubroNeg']);
        if($rubroNeg==""){
            $rubroNeg=null;
        }          
        $puertaCalle=htmlspecialchars($_POST['puertaCalle']);
        if($puertaCalle==""){
            $puertaCalle=null;
        }         
        $nobleParedes=htmlspecialchars($_POST['nobleParedes']);
        if($nobleParedes==""){
            $nobleParedes=null;
        }         
        $nobleTecho=htmlspecialchars($_POST['nobleTecho']);
        if($nobleTecho==""){
            $nobleTecho=null;
        }         
        $mcuadrados=htmlspecialchars($_POST['mcuadrados']);
        if($mcuadrados==""){
            $mcuadrados=null;
        }          
        $motivoInteres=htmlspecialchars($_POST['motivoInteres']);
        if($motivoInteres==""){
            $motivoInteres=null;
        }         
        $conSistema=htmlspecialchars($_POST['conSistema']);
        if($conSistema==""){
            $conSistema=null;
        }        
        $empresaSistema=htmlspecialchars($_POST['empresaSistema']);
        if($empresaSistema==""){
            $empresaSistema=null;
        }        
        $bancarizado=htmlspecialchars($_POST['bancarizado']);
        if($bancarizado==""){
            $bancarizado=null;
        }
        $segundaDireccion=htmlspecialchars($_POST['segundaDireccion']);
        if($segundaDireccion==""){
            $segundaDireccion=null;
        }        


/* ANULACIONES */
$lblestadovisita = htmlspecialchars($_POST['lblestadovisita']);
$seanula = htmlspecialchars($_POST['lblseanula']);
$seanulaH = htmlspecialchars($_POST['lblseanulaH']);
$detalle = htmlspecialchars($_POST['lbldetalle']);
$comentariosanulacion = htmlspecialchars($_POST['lblcomentarios']);

if($seanula == ''){
    $seanula = NULL;
}

if($detalle == ''){
    $detalle = NULL;
}

if($comentariosanulacion == ''){
    $comentariosanulacion = NULL;
}

/* ERROR GESTION */
$calificarGestion = htmlspecialchars($_POST['lblErrorGestion']);
if($calificarGestion == ''){
    $calificarGestion = NULL;
}
$comentariosErrorGestion = htmlspecialchars($_POST['lblcomentarioserrorgestion']);
if($comentariosErrorGestion == ''){
    $comentariosErrorGestion = NULL;
}

if(editar_buscarProspecto($nprospecto,$nprospectohidden)==false){
    echo 2;
}else{
    //CONSULTA PARA OBTENER DATOS A MODIFICAR
    
    $sqlValidaCambios = $con->prepare("SELECT 
    v.Matricula MatriculaComercial, 
    v.EstadoVisita, 
    v.EstadoVenta, 
    v.FechaVisita, 
    v.HoraVisita, 
    v.FObras,
    v.FVisitaObras,
    v.ComentarioVisita,
    v.MesVisita, 
    c.IdCliente, 
    c.NombApellido NombCliente,  
    c.Direccion DirCliente,
    c.Telefonouno,
    c.Telefonodos,
    v.Checkin
    FROM tblventa v
    INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON v.IdUsuario = u.IdUsuario
    INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
    WHERE v.IdVenta = ? ");
    $sqlValidaCambios->bind_param('i',$idventa);
    $sqlValidaCambios->execute();
    $sqlValidaCambios->store_result();
    $sqlValidaCambios->bind_result(
            $MatriculaComercialRow, 
            $EstadoVisitaRow, 
            $EstadoVentaRow, 
            $FechaVisitaRow, 
            $HoraVisitaRow, 
            $FObrasRow,
            $FVisitaObrasRow,
            $ComentarioVisitaRow,
            $MesVisitaRow, 
            $IdClienteRow, 
            $NNombClienteRow,  
            $DirClienteRow,
            $TelefonounoRow,
            $TelefonodosRow,
            $CheckinRow
        );
    

    while ($sqlValidaCambios->fetch()){
        $matriculaValidaCambios = $MatriculaComercialRow;
        $EstadoVisitaValidaCambios = $EstadoVisitaRow;
        $EstadoVentaValidaCambios = $EstadoVentaRow;
        $FechaVisitaValidaCambios = $FechaVisitaRow;
        $HoraVisitaValidaCambios = $HoraVisitaRow;
        $FObrasValidaCambios = $FObrasRow;
        $FVisitaObrasValidaCambios = $FVisitaObrasRow;
        $ComentarioVisitaValidaCambios = $ComentarioVisitaRow;
        $MesVisitaValidaCambios = $MesVisitaRow;
        $IdClienteValidaCambios = $IdClienteRow;
        $NombClienteValidaCambios = $NNombClienteRow;
        $DireccionValidaCambios = $DirClienteRow;
        $TelefonounoValidaCambios = $TelefonounoRow;
        $TelefonodosValidaCambios = $TelefonodosRow;
        $CheckinValidaCambios = $CheckinRow;
    }

    //FUNCION QUE DEVUELVE ARRAY DE DATOS DEL CLIENTE
    $resultadoCliente = consultaCliente($idcliente);
   
    //DOCUMENTO
    if ($IdDocVisita == NULL){
         $resultadoDocumento = insertarDocumento();
         if ($resultadoDocumento > 0){
            $IdDocVisita=$resultadoDocumento;
         }else{
            $IdDocVisita=NULL;  
         }
         
    }else{
        $resultadoDocumento = actualizarDocumento($IdDocVisita);

    }
    
    $sqlCliente = actualizarClienteDoc($idcliente); //ACTUALIZA DATOS DEL CLIENTE
   
    //VALIDAR RESULTADO DEL UPDATE
    if ($sqlCliente['respuesta']=='exito'){
        $affectedrowcliente = 1;    
    }else{
        $affectedrowcliente = 0;   
    }

    $resultadoVisita= consultaVisita($idventa);
    
    /* ANULACIONES */
    if($seanula == "SI" && $seanulaH == ""){
        try {
            $sqlAnulaciones = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblhistorialanulaciones(IdVenta, EstadoVisita, Detalle, Comentarios, MatriculaUsuario, FechaHoraREG) VALUES (?,?,?,?,?,?)");
        	$sqlAnulaciones->bind_param('isssss', $idventa, $lblestadovisita, $detalle, $comentariosanulacion, $matriculausuario, $fecharegistro);
        	$sqlAnulaciones->execute();
        	$idHistorialAnulaciones = $con->insert_id;
        	$sqlAnulaciones->close();
        }  catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }
    }    
    
    /* ERRORES DE GESTION 04.09.2023 */
    if($calificarGestion != '' && $comentariosErrorGestion != ''){
        try {
            $sqlErrorGestion = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblhistorialerroresgestion(IdVenta, ErrorGestion, MatriculaUsuario, Comentarios, FechaHoraREG) VALUES (?,?,?,?,?)");
        	$sqlErrorGestion->bind_param('issss', $idventa, $calificarGestion, $matriculausuario, $comentariosErrorGestion, $fecharegistro);
        	$sqlErrorGestion->execute();
        	$idHistorialErrorGestion = $con->insert_id;
        	$sqlErrorGestion->close();
        }  catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }
    }

    //$sqlventa=$con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa v SET v.IdUsuario=?,v.IdCliente=?,v.Matricula=?,v.Comercial=?,v.CC=?,v.JefeVenta=?,v.CategoriaVenta=?,v.TipoVenta=?,v.Segmento=?,v.NProspecto=?,EstadoVenta=?,EstadoVisita=?,FechaVisita=?,HoraVisita=?,FVencimientoVisita=?,GestorMKT=?,OrigenVisita=?,ComentarioVisita=?,v.CCOriginal=?,v.Checkin=?,v.MesVisita=?,v.LeadID=?, v.FObras=?, FVisitaObras=?,MotivoAsignacion=?, ContactoAsignacion=?, CumpleRanking=?,visePiso=?,rubroNeg=?,puertaCalle=?,nobleParedes=?,nobleTecho=?,metros=?,motivoInteres=?,conSistema=?,empresaSistema=?,bancarizado=?  WHERE v.IdVenta=? ");/*, ContactoAsignacion=?, CumpleRanking=?*/
    //$sqlventa->bind_param('iissssssssssssssssssssssssssssssdssssi',$idusuario,$idcliente,$matricula,$nombcomercial,$lblcctc,$jefeventa,$categoria,$tipoventa,$segmento,$nprospecto,$estadoventa,$estvisita,$fechagrabarfvisita,$horagrabarvisita,$fechagrabarvencimiento,$asignadopor,$origen,$comentariovisita,$dc,$checkin,$mesvisita,$leadid,$fobras,$fechagrabarfvisitaObra,$motivoasignacion,$contactoasignacion,$cumpleranking,$visePiso,$rubroNeg,$puertaCalle,$nobleParedes,$nobleTecho,$mcuadrados,$motivoInteres,$conSistema,$empresaSistema,$bancarizado,$idventa); /*is*/
    $sqlventa=$con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa v SET v.IdUsuario=?,v.IdCliente=?,v.Matricula=?,v.Comercial=?,v.CC=?,v.JefeVenta=?,v.CategoriaVenta=?,v.TipoVenta=?,v.Segmento=?,v.NProspecto=?,EstadoVenta=?,EstadoVisita=?,FechaVisita=?,HoraVisita=?,FVencimientoVisita=?,GestorMKT=?,OrigenVisita=?,ComentarioVisita=?,v.CCOriginal=?,v.Checkin=?,v.MesVisita=?,v.LeadID=?, v.FObras=?, FVisitaObras=?,MotivoAsignacion=?, ContactoAsignacion=?, CumpleRanking=?,visePiso=?,rubroNeg=?,puertaCalle=?,nobleParedes=?,nobleTecho=?,metros=?,motivoInteres=?,conSistema=?,empresaSistema=?,bancarizado=?, FechaSolicitudAnulacion=?, SeAnula=?, ComentariosAnulacion=?, DetalleAnulacion=?, errorGestion=?,v.CCTVTC=?,v.segundaDireccion=? WHERE v.IdVenta=? ");/*, ContactoAsignacion=?, CumpleRanking=?*/
    $sqlventa->bind_param('iissssssssssssssssssssssssssssssdsssssssssssi',$idusuario,$idcliente,$matricula,$nombcomercial,$lblcctc,$jefeventa,$categoria,$tipoventa,$segmento,$nprospecto,$estadoventa,$estvisita,$fechagrabarfvisita,$horagrabarvisita,$fechagrabarvencimiento,$asignadopor,$origen,$comentariovisita,$dc,$checkin,$mesvisita,$leadid,$fobras,$fechagrabarfvisitaObra,$motivoasignacion,$contactoasignacion,$cumpleranking,$visePiso,$rubroNeg,$puertaCalle,$nobleParedes,$nobleTecho,$mcuadrados,$motivoInteres,$conSistema,$empresaSistema,$bancarizado, $fecharegistro, $seanula, $comentariosanulacion, $detalle, $calificarGestion,$lblcctc,$segundaDireccion, $idventa); /*is*/
    $sqlventa->execute();
    
    
    //VALIDA QUE SE ACTUALIZARON DATOS DE LA VENTA
    $affectedrowVenta = $sqlventa->affected_rows; 

    $Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
    $Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $Url = sanitizaCampo($_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa, 'sanitizeurl|scapestring|htmlspecialchars',$con);
    if(!empty($Url)){
    	$UrlLog = $Url.'=>IdVenta='.$idventa;
    }
    $Modificar = 'Modificar';
    $Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                    
    try{
    	$result_exec= $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
    	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fechmod,$UrlLog,$Modificar,$Navegador);
    	$result_exec->execute();
    	$idLogSeg = $con->insert_id;
    	$result_exec->close();
    }  catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

    //INSERT AL LOG DE TRANSACCIONES
    if ($affectedrowcliente > 0){
        insertarLog($idLogSeg, $resultadoCliente);
    }
    if ($affectedrowVenta > 0){
        insertarLogVisita($idLogSeg, $resultadoVisita);
        echo 1;
    }
    
    //CORREO DE REASIGNACION Y MODIFICACION

    $sqltimename = $con->prepare("SET lc_time_names = 'es_ES'");
    $sqltimename->execute();
    
     
    $sqlCorreoConfirmacion = $con->prepare("SELECT 
    v.Matricula MatriculaComercial, 
    v.Comercial, 
    v.CC Delegacion, 
    u.Manager MatriculaJefeVenta, 
    u.Correo CorreoComercial,
    u.IdPerfil PerfilComercial,
    u.Categoria CategoriaComercial,
    CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta, 
    m.Correo CorreoJefeVenta, 
    CONCAT(del.Nombres,' ',del.Apellidos) NombDelegado, 
    del.Correo CorreoDelegado, 
    v.EstadoVisita, 
    v.EstadoVenta, 
    v.TipoVenta, 
    v.Segmento, 
    v.NProspecto, 
    v.N590, 
    v.FechaVisita,
    DATE_FORMAT(v.FechaVisita, '%d/%m/%Y') FechavisitaFormato,
    v.HoraVisita, 
    v.FObras,
    v.FVisitaObras,
    DATE_FORMAT(v.FVisitaObras, '%W %d/%m' ) FechaVisitaObrasDia,
    DATE_FORMAT(FechaVisita, '%W %d/%m') FechaVisitaDia, 
    v.FVencimientoVisita, 
    v.OrigenVisita, 
    v.ComentarioVisita, 
    v.MesVisita, 
    v.LeadID,
    v.GestorMKT,
    CONCAT(mkt.Nombres,' ',mkt.Apellidos) NombGestorMKT,
    mkt.Correo CorreoOperador,
    c.IdCliente, 
    c.NombApellido NombCliente, 
    c.Telefonouno T1Cliente, 
    c.Telefonodos T2Cliente, 
    c.Correo CorreoCliente, 
    c.Direccion DirCliente, 
    g.Distrito DistCliente, 
    g.Provincia ProvCliente,
    c.Referencia RefCliente,
    c.Interior IntCliente,
    v.Checkin,
    v.FechaHoraREG as FechaRegistroApertura
    FROM tblventa v
    INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON v.IdUsuario = u.IdUsuario
    INNER JOIN yifi58ge_dbUSUARIO.tblusuario m ON u.Manager = m.Matricula
    INNER JOIN yifi58ge_dbUSUARIO.tblusuario del ON m.Manager = del.Matricula
    INNER JOIN yifi58ge_dbUSUARIO.tblusuario mkt ON v.GestorMKT = mkt.Matricula
    INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
    INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
    WHERE v.IdVenta =? ");
    $sqlCorreoConfirmacion->bind_param('i',$idventa);
    $sqlCorreoConfirmacion->execute();
    $sqlCorreoConfirmacion->store_result();
    $sqlCorreoConfirmacion->bind_result(
            $MatriculaComercialRow, 
            $ComercialRow, 
            $DelegacionRow, 
            $MatriculaJefeVentaRow, 
            $CorreoComercialRow,
            $PerfilComercialRow,
            $CategoriaComercialRow,
            $NombJefeVentaRow, 
            $CorreoJefeVentaRow, 
            $NombDelegadoRow, 
            $CorreoDelegadoRow, 
            $EstadoVisitaRow, 
            $EstadoVentaRow, 
            $TipoVentaRow, 
            $SegmentoRow, 
            $NProspectoRow, 
            $N590Row, 
            $FechaVisitaRow,
            $FechavisitaFormatoRow,
            $HoraVisitaRow, 
            $FObrasRow,
            $FVisitaObrasRow,
            $FechaVisitaObrasDiaRow,
            $FechaVisitaDiaRow, 
            $FVencimientoVisitaRow, 
            $OrigenVisitaRow, 
            $ComentarioVisitaRow, 
            $MesVisitaRow, 
            $LeadIDRow,
            $GestorMKTRow,
            $NombGestorMKTRow,
            $CorreoOperadorRow,
            $IdClienteRow, 
            $NombClienteRow, 
            $T1ClienteRow, 
            $T2ClienteRow, 
            $CorreoClienteRow, 
            $DirClienteRow, 
            $DistClienteRow, 
            $ProvClienteRow,
            $RefClienteRow,
            $IntClienteRow,
            $CheckinRow,
            $FechaRegistroAperturaRow
        );

    while($sqlCorreoConfirmacion->fetch()){
        $NProspecto = $NProspectoRow;
        $MatriculaComercialCorreo = $MatriculaComercialRow;
        $ComercialCorreo = $ComercialRow;
        $DelegacionCorreo = $DelegacionRow;
        $MatriculaJefeVentaCorreo = $MatriculaJefeVentaRow;
        $CorreoComercialCorreo = $CorreoComercialRow;
        $NombJefeVentaCorreo = $NombJefeVentaRow;
        $CorreoJefeVentaCorreo = $CorreoJefeVentaRow;
        $NombDelegadoCorreo = $NombDelegadoRow;
        $CorreoDelegadoCorreo = $CorreoDelegadoRow;
        $EstadoVisitaCorreo = $EstadoVisitaRow;
        $EstadoVentaCorreo = $EstadoVentaRow;
        $TipoVentaCorreo = $TipoVentaRow;
        $SegmentoCorreo = $SegmentoRow;
        $NProspectoCorreo = $NProspectoRow;
        $N590Correo = $N590Row;
        $FechaVisitaCorreo = $FechaVisitaRow;
        $FechavisitaFormatoCorreo = $FechavisitaFormatoRow;
        $HoraVisitaCorreo = $HoraVisitaRow;
        $FechaObrasCorreo = $FObrasRow;
        $FVisitaObrasCorreo = $FVisitaObrasRow; //FECHAVISITAOBRA - FORMAR NORMAL
        $FechaVisitaObrasDiaCorreo = $FechaVisitaObrasDiaRow; //FECHAVISITAOBRADIA - FORMATO CON DIA
        $FechaVisitaDiaCorreo = $FechaVisitaDiaRow;
        $FVencimientoVisitaCorreo = $FVencimientoVisitaRow;
        $OrigenVisitaCorreo = $OrigenVisitaRow;
        $ComentarioVisitaCorreo = $ComentarioVisitaRow;
        $GestorMKTCorreo = $GestorMKTRow;
        $NombGestorMKTCorreo = $NombGestorMKTRow;
        $CorreoOperadorCorreo = $CorreoOperadorRow;
        $MesVisitaCorreo = $MesVisitaRow;
        $LeadIDCorreo = $LeadIDRow;
        $IdClienteCorreo = $IdClienteRow;
        $NombClienteCorreo = $NombClienteRow;
        $T1ClienteCorreo = $T1ClienteRow;
        $T2ClienteCorreo = $T2ClienteRow;
        $CorreoClienteCorreo = $CorreoClienteRow;
        $DirClienteCorreo = $DirClienteRow;
        $DistClienteCorreo = $DistClienteRow;
        $ProvClienteCorreo = $ProvClienteRow;
        $RefClienteCorreo = $RefClienteRow;
        $IntClienteCorreo = $IntClienteRow;
        $CheckinCorreo = $CheckinRow;
        $PerfilComercialCorreo = $PerfilComercialRow;
        $CategoriaComercialCorreo = $CategoriaComercialRow;
        $FechaRegistroApertura=$FechaRegistroAperturaRow;
    }

    $tipoEnvio = '';
    
    if ($DelegacionCorreo != 511 && $DelegacionCorreo != 512 && $DelegacionCorreo != 500){

        if ($matriculaValidaCambios != $MatriculaComercialCorreo) {
            $tipoEnvio = 'REASIGNACIÓN';
            //enviarCorreo($tipoEnvio);
            EnvioCorreo_Reasignacion($idventa, $NProspecto, $TipoVentaCorreo);
        } else if($NombClienteValidaCambios != $NombClienteCorreo || $FechaVisitaValidaCambios != $FechaVisitaCorreo  || $HoraVisitaValidaCambios != $HoraVisitaCorreo || $DireccionValidaCambios != $DirClienteCorreo || $ComentarioVisitaValidaCambios != $ComentarioVisitaCorreo || $TelefonounoValidaCambios != $T1ClienteCorreo || $TelefonodosValidaCambios != $T2ClienteCorreo || $FVisitaObrasValidaCambios != $FVisitaObrasCorreo ){ 
            $tipoEnvio = 'MODIFICACIÓN';
            //enviarCorreo($tipoEnvio);
            EnvioCorreo_Modificacion($idventa, $NProspecto, $TipoVentaCorreo);
        } else if ($EstadoVisitaValidaCambios != $EstadoVisitaCorreo) {
            
            if($EstadoVisitaCorreo == 'AnuladaTEC' || $EstadoVisitaCorreo== 'AnuladaOP' || $EstadoVisitaCorreo == 'AnuladaCLI' || $EstadoVisitaCorreo == 'AnuladaporCruce'){
                $tipoEnvio = 'ANULACIÓN';
                enviarCorreo($tipoEnvio);
            }
        }
        
        if($CheckinValidaCambios != $CheckinCorreo){
            if($CheckinCorreo == 'SI'){
                enviarCorreoValidacionCheckIN();
            }
        }
    }
    
    //INSERTAR HISTORIAL DE REASIGNACION SECURITY CHECK
   
    if ($idventa == ""){}else{
        if(isset($matricula) && $matricula <> $resultadoVisita['Matricula']){
            $categoriamatricula=consultarCategoriaMatricula($matricula);
            if(($categoriamatricula!="DEL" || $categoriamatricula!='JE' || $categoriamatricula!='COACH') && ($dc==100 || $dc==151 || $dc==152 || $dc==153 || $dc==154 || $dc==155 || $dc==156 || $dc==159)){
                $accion=consultarApertura($idventa);
                if($checkin=="NO" && $estadoventa=="VAsignada" && $FechaRegistroApertura>"2023-04-17 08:53:00"){
                    $ObjCorreoM=EnvioCorreoSecurityCheck($idventa,$correo,$accion);
                         if($accion=="Apertura"){
                             $AsignacionPlantilla="Apertura";
                         }else{
                             $AsignacionPlantilla="Reasignacion";
                         }
                    //$ObjCorreoM=NULL;                    
                }else{
                    $ObjCorreoM=NULL;
                    $AsignacionPlantilla=NULL;
                }
            }            
            else{
            $ObjCorreoM=NULL;    
            }
            insertarReasignacion($idventa);
        }

    }
    
    $sqlCorreoConfirmacion->close();
   
}

    function actualizarDocumento($IdDocVisita){
        global $con;
        global $tipodoc, $documento;
        
        if(empty($tipodoc) && empty($documento)){
            return 0;
        }else{

            try{
                $stmt = $con->prepare("UPDATE tbldocumento SET TipoDocumento=?, Documento=? WHERE IdDoc = ?");
                $stmt->bind_param('ssi', $tipodoc, $documento, $IdDocVisita);
                $stmt->execute();
                $respuesta = $stmt->affected_rows;

                $stmt->close();  
            } catch (\Exception $e) {
                $respuesta = 'error';
            }
            return $respuesta;
        }
    }
    
    //Funcion nueva Documento
    function insertarDocumento(){
        global $con;
        global $tipodoc, $documento, $fecharegistro;
        if(empty($tipodoc) && empty($documento)){
            return 0;
        }else{
            try {
        
              $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES(?, ?, ?)");
              $stmt->bind_param('sss', $tipodoc,$documento,$fecharegistro);
                $stmt->execute();
                $respuesta = $con->insert_id;
                $stmt->close();
            } catch (\Exception $e) {
                $respuesta = array(
                    'respuesta' => 'error'
                );
            }
        
            return $respuesta;
        }
    
    }
    
    //Funcion nueva Cliente
    function actualizarClienteDoc($idcliente){
        global $con;
    
        global $nombcliente, $correo, $direccion, $distrito, $telefonouno, $telefonodos, $segmento,$IdDocVisita, $Referencia, $interior, $objGeofinder, $lbldireccionAprox, $lbltipoDireccion;
        global $tiposegmento,$npiso,$tipovial;
    
        try{
            $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente SET IdGeografico = ?, NombApellido = ?, Correo = ?, Direccion = ?, Telefonouno = ?, Telefonodos=?, Segmento=?,IdDocVisita=?, Referencia=?, Interior=?, objGeofinder=?, DireccionAprox=?, TipoDireccion=?,TipoSegmento=?,NPiso=?,TipoVial=? WHERE IdCliente = ?");
            $stmt->bind_param("issssssissssssisi", $distrito, $nombcliente, $correo, $direccion, $telefonouno, $telefonodos, $segmento,$IdDocVisita, $Referencia, $interior, $objGeofinder, $lbldireccionAprox, $lbltipoDireccion,$tiposegmento,$npiso,$tipovial, $idcliente);
            $stmt->execute();
    
            $rows = $stmt->affected_rows;
    
            if ($rows > 0) {
                $respuesta = array(
                    'respuesta' => 'exito',
                    'id_actualizado' => $idcliente,
                    'tipo' => 'cliente'
                );
            } else {
                $respuesta = array(
                    'respuesta' => 'nada',
                    'tipo' => 'cliente'
                );
            }
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error',
                'mensaje' => $e->getMessage(),
                'tipo' => 'cliente'
            );
        }
    
        return $respuesta;
    }
    //Funcion enviar Correo
    function enviarCorreo($tipo){
        
        global $idventa;
        
        global $MatriculaComercialCorreo; 
        global $ComercialCorreo;
        global $DelegacionCorreo;
        global $MatriculaJefeVentaCorreo; 
        global $CorreoComercialCorreo;
        global $NombJefeVentaCorreo;
        global $CorreoJefeVentaCorreo;
        global $NombDelegadoCorreo;
        global $CorreoDelegadoCorreo;
        global $EstadoVisitaCorreo;
        global $EstadoVentaCorreo;
        global $TipoVentaCorreo;
        global $SegmentoCorreo;
        global $NProspectoCorreo;
        global $N590Correo;
        global $FechaVisitaCorreo;
        global $HoraVisitaCorreo;
        global $FechavisitaFormatoCorreo;
        global $FechaObrasCorreo; //MODIFICACION EMU 16.05 CONSULTA LA BD PARA TRAER EL CAMPO FOBRAS
        global $FechaVisitaObrasDiaCorreo;
        global $FVisitaObrasCorreo;
        global $FechaVisitaDiaCorreo;
        global $FVencimientoVisitaCorreo;
        global $OrigenVisitaCorreo;
        global $ComentarioVisitaCorreo;
        global $MesVisitaCorreo;
        global $LeadIDCorreo;
        global $IdClienteCorreo;
        global $NombClienteCorreo;
        global $T1ClienteCorreo;
        global $T2ClienteCorreo;
        global $CorreoClienteCorreo;
        global $DirClienteCorreo;
        global $DistClienteCorreo;
        global $ProvClienteCorreo;
        global $CorreoOperadorCorreo;
        global $GestorMKTCorreo;
        global $NombGestorMKTCorreo;
        global $RefClienteCorreo;
        global $IntClienteCorreo;
        
        global $PerfilComercialCorreo;
        global $CategoriaComercialCorreo; 
        
        if($FechaObrasCorreo=="SI"){
        $hfobras='<span style="color:red">SI</span>';
        $DescripFechaVisita = $FechaVisitaObrasDiaCorreo.' a las '.$HoraVisitaCorreo.' (Visita se considera con fecha en obras para el '.$FechavisitaFormatoCorreo.')';
        }else{
            $hfobras='NO';
            $DescripFechaVisita= $FechaVisitaDiaCorreo.' a las '.$HoraVisitaCorreo.'';
        }
        
        $correo_prueba="joseenrique.nanquen@verisure.pe";
        
        //ESTRUCTURA DEL CORREO ACTUALIZADO
        //DELEGADO
        if($PerfilComercialCorreo == 17){
            
            if($CategoriaComercialCorreo == 'N1' || $CategoriaComercialCorreo == 'N2' || $CategoriaComercialCorreo == 'N3' || $CategoriaComercialCorreo == 'JE' 
            || $CategoriaComercialCorreo == 'VET' || $CategoriaComercialCorreo == 'COACH' || $CategoriaComercialCorreo == 'MST' || $CategoriaComercialCorreo == 'ELI/MST'){
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=$CorreoJefeVentaCorreo; //JEFE
                $correoAdministrativo3=$CorreoDelegadoCorreo; //DELEGADO
            } else if ($CategoriaComercialCorreo == 'DEL'){
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=$CorreoJefeVentaCorreo; //JEFE
                $correoAdministrativo3=''; //DELEGADO
            } else if ($CategoriaComercialCorreo == 'GERENTE TERRITORIAL') {
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=''; //JEFE
                $correoAdministrativo3=''; //DELEGADO
            } else {
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=''; //JEFE
                $correoAdministrativo3=''; //DELEGADO
            }
        } else if ($PerfilComercialCorreo == 38){
            $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
        } else {
            $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
        }
        
        if($DelegacionCorreo == 150 || $DelegacionCorreo == 156 || $DelegacionCorreo == 157 || $DelegacionCorreo == 159 || $DelegacionCorreo == 252 || $DelegacionCorreo == 130 || $DelegacionCorreo == 151){
            $correoAdministrativo4="renzobranchi.branez@verisure.pe";
        } else if ($DelegacionCorreo == 152){
            $correoAdministrativo4="cristhian.cuneo@verisure.pe";
        } else if ($DelegacionCorreo == 120  || $DelegacionCorreo == 121  || $DelegacionCorreo == 140 | $DelegacionCorreo == 200){
            $correoAdministrativo4="juliocesar.rojas@verisure.pe";             
        } else if ($DelegacionCorreo == 40  || $DelegacionCorreo == 41  || $DelegacionCorreo == 80  || $DelegacionCorreo == 100  || $DelegacionCorreo == 230){
            $correoAdministrativo4="david.adell@verisure.pe";
        } else if ($DelegacionCorreo == 154 || $DelegacionCorreo == 155 || $DelegacionCorreo == 158 || $DelegacionCorreo == 152){
            $correoAdministrativo4="monicamaria.sanchez@verisure.pe";
        }
        
        
        //$correoAdministrativo4="backoffice@verisure.pe";
        $copia1 = "CHRISTIAN.GUTIERREZ@VERISURE.PE";
        $copia2 = "SHIRLEY.CUADRA@VERISURE.PE";
        $copia3 = "MADELEYNE.MUNAYCO@VERISURE.PE";
        $copia4 = "diego.delabarra@verisure.pe";
        $copia5 = "anthony.villarreal@verisure.pe";
        $copia6 = "joseenrique.nanquen@verisure.pe";
        $paraCorreoVisita = '' . $correoAdministrativo1 . ',' .$correoAdministrativo2. ',' .$correoAdministrativo3. ',' .$correoAdministrativo4.' ';
    
    /*
        $paraCorreoVisita = '' . $correo_prueba .'';
    
        if ($DelegacionCorreo=="150" || $DelegacionCorreo=="151" || $DelegacionCorreo=="152" || $DelegacionCorreo=="153" || $DelegacionCorreo=="120" || $DelegacionCorreo=="200" || $DelegacionCorreo=="41" || $DelegacionCorreo=="40" || $DelegacionCorreo=="155"){
            $paraCorreoVisita = '' . $correoAdministrativo1 . ',' .$correoAdministrativo2. ',' .$correoAdministrativo3. ',' .$correoAdministrativo4. ',' .$correoAdministrativo5. ',' .$correoadministrativo6. ','.$correoDelegado.'';   
        }
        else {
            $paraCorreoVisita = '' . $correoAdministrativo1 . ',' .$correoAdministrativo2. ',' .$correoAdministrativo3. ',' .$correoAdministrativo4. ',' .$correoAdministrativo5. ',' .$correoadministrativo6. '';    
        }
    */
        
    if ($TipoVentaCorreo === 'RE'){   
        $tituloCorreoVisita = "OPORTUNIDAD DE VENTA VISITA RE - ".$NProspectoCorreo." (".$tipo.") ";
        
        $mensajeCorreoVisita ='
    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml">
     
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      <title>A Simple Responsive HTML Email</title>
      <style type="text/css">
      body {margin: 0; padding: 0; min-width: 100%!important;}
      img {height: auto;}
      .content {width: 100%; max-width: 600px;}
      .header {padding: 5px 20px 5px 20px;}
      .innerpadding {padding: 20px 30px 15px 30px;}
      .borderbottom {border-bottom: 1px solid #f2eeed;}
      .subhead {font-size: 15px; color: #ffffff; font-family: sans-serif; letter-spacing: 10px;}
      .h1 {font-family: sans-serif;color: #ffffff;font-size:23px; line-height: 38px; font-weight: bold;}
      .h2 {color: #000000; font-family: sans-serif;padding: 0 0 15px 0; font-size: 24px; line-height: 28px; font-weight: bold;}
      .h3 {color: #000000; font-family: sans-serif;font-size: 14px; line-height: 22px; font-weight: bold;}
      .h4 {color: #000000;font-family: sans-serif;font-size: 16px; line-height: 30px; font-weight: bold;}
      .bodycopy {color: #000000; font-family: sans-serif;font-size: 14px; line-height: 22px;}
      .button {text-align: center; font-size: 18px; font-family: sans-serif; font-weight: bold; padding: 0 30px 0 30px;}
      .button a {color: #ffffff; text-decoration: none;}
      .footer {padding: 20px 30px 15px 30px;}
      .footercopy {font-family: sans-serif; font-size: 14px; color: #ffffff;}
      .footercopy a {color: #ffffff; text-decoration: underline;}
      .coldiv115{width: 115px;};
      .coldiv380{width: 380px;};
    
      @media only screen and (max-width: 550px), screen and (max-device-width: 550px) {
      body[yahoo] .hide {display: none!important;}
      body[yahoo] .buttonwrapper {background-color: transparent!important;}
      body[yahoo] .button {padding: 0px!important;}
      body[yahoo] .button a {background-color: #e05443; padding: 15px 15px 13px!important;}
      body[yahoo] .unsubscribe {display: block; margin-top: 20px; padding: 10px 50px; background: #2f3942; border-radius: 5px; text-decoration: none!important; font-weight: bold;}
      }
    
      /*@media only screen and (min-device-width: 601px) {
        .content {width: 600px !important;}
        .col425 {width: 425px!important;}
        .col380 {width: 380px!important;}
        }*/
    
      </style>
    </head>
    
    <body yahoo bgcolor="#f2f2f2">
    <table width="100%" bgcolor="#f2f2f2" border="0" cellpadding="0" cellspacing="0">
    <tr>
      <td>
        <!--[if (gte mso 9)|(IE)]>
          <table width="600" align="center" cellpadding="0" cellspacing="0" border="0">
            <tr>
              <td>
        <![endif]-->     
        <table bgcolor="#ffffff" class="content" align="center" cellpadding="0" cellspacing="0" border="0">
          <tr>
            <td bgcolor="#ffffff" class="header">
              <table width="70" align="center" border="0" cellpadding="0" cellspacing="0">  
                <tr>
                  <td height="70" style="padding: 0 20px 20px 0;">
                    <img class="fix"  src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png" border="0" alt="" />
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          
          
          <tr>
            <td bgcolor="#3a65ff" class="header">
              
              <!--[if (gte mso 9)|(IE)]>
                <table width="425" align="center" cellpadding="0" cellspacing="0" border="0">
                  <tr>
                    <td>
              <![endif]-->
              <table class="col425" align="center" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 425px;">  
                <tr>
                  <td height="70">
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td class="h1" align="center" style="padding: 0 0 0 0;">
                          OPORTUNIDAD DE VENTA RE- '.$NProspectoCorreo.'
                        </td>
                      </tr>
                    </table>
                  </td>
                </tr>
              </table>
              <!--[if (gte mso 9)|(IE)]>
                    </td>
                  </tr>
              </table>
              <![endif]-->
            </td>
          </tr>
          
          <tr>
            <td class="innerpadding borderbottom">
              <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td class="h2">
                    Estimado(s) Sr(es) '.strtoupper($ComercialCorreo).'
                  </td>
                </tr>
                <tr>
                    <td class="bodycopy">
                        <h4 style="font-weight: normal">Envío los datos de una RE para el <span style="font-weight: bold;">'.$DescripFechaVisita.'</span></h4>
                        <h4 style="font-weight: normal">Enviar la ubicación al WHATSAPP CEL. <span style="font-weight: bold;">942474698</span> indicando:</h4>
                        <ul>
                            <ol>
                                <li>Ubicación de la visita.</li>
                                <li>El número de prospecto dentro del día que se agendó la visita.</li>
                                <li>Informar el estado final de la visita (Vendida o No Vendido).</li>
                            </ol>
                        </ul>
                    </td>
                </tr>
              </table>
            </td>
          </tr>
          
           <tr>
            <td class="innerpadding borderbottom">
              <table  width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td class="h4" bgcolor="#dddddd" align="center" style="padding: 0 0px 0px 0;">
                    INFORMACIÓN DE LA VISITA
                  </td>
                </tr>
              </table>
                
              <table align="left" border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td class="h3" width="145" style="padding: 5px 0px 0px 0;">
                    CLIENTE:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. strtoupper($NombClienteCorreo).'
                  </td>
                </tr>
                <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    DIRECCIÓN:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. strtoupper($DirClienteCorreo).'
                  </td>
                </tr>
                <tr>
                    <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    INTERIOR:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. strtoupper($IntClienteCorreo).'
                  </td>
                </tr>
                <tr>
                    <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    REFERENCIA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. strtoupper($RefClienteCorreo).'
                  </td>
                </tr>
                
                 <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    DISTRITO:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '. strtoupper($DistClienteCorreo).'
                  </td>
                </tr>
                 <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    PROVINCIA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '. strtoupper($ProvClienteCorreo).'
                  </td>
                </tr>
                <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    TELEFONO UNO:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. $T1ClienteCorreo.'
                  </td>
                </tr>
                 <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    TELEFONO DOS:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '. $T2ClienteCorreo.'
                  </td>
                </tr>
                <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    CORREO:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '. strtoupper($CorreoClienteCorreo).'
                  </td>
                </tr>
                <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    FECHA VISITA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. $FechaVisitaCorreo.'
                  </td>
                </tr>
                <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    HORA VISITA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. $HoraVisitaCorreo.'
                  </td>
                </tr>
                <tr>
                    <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    FECHA OBRAS:
                    </td>
                    <td class="bodycopy" width="350" style="padding: 0 0px 0px 0; font-weight: bold;">
                    '.$hfobras.' 
                    </td>
                </tr>
                 <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    COMENTARIO VISITA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '. strtoupper($ComentarioVisitaCorreo).'
                  </td>
                </tr>
                
              </table>
             
            </td>
          </tr>
    
          <tr>
            <td class="innerpadding borderbottom">
              <table bgcolor="#dddddd" width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td class="h4" align="center"  style="padding: 0 0px 0px 0;">
                    INFORMACIÓN DEL PROSPECTO
                  </td>
                </tr>
              </table>
                
              <table align="left" border="0" cellpadding="0" cellspacing="0">  
                <tr>
                  <td class="h3" width="145" style="padding: 5px 0px 0px 0;">
                    MATRICULA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 5px 0px 0px 0;">
                    '. $MatriculaComercialCorreo.'
                  </td>
                </tr>
                 <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    COMERCIAL:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '.strtoupper($ComercialCorreo).'
                  </td>
                </tr>
                
                <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    DELEGACIÓN:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. $DelegacionCorreo.'
                  </td>
                </tr>
                 <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    JEFE VENTA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '. strtoupper($MatriculaJefeVentaCorreo).'
                  </td>
                </tr>
                <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    ESTADO VISITA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '.strtoupper($EstadoVisitaCorreo).'
                  </td>
                </tr>
                 <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    RECURSO:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     RE
                  </td>
                </tr>
                <tr>
                    <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    GESTOR RE:
                    </td>
                    <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '.$GestorMKTCorreo.' - '.$NombGestorMKTCorreo.'
                  </td>
                </tr>
    
              </table>
             
            </td>
          </tr>
          
          <tr>
            <td class="footer" bgcolor="#44525f">
              <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td align="center" class="footercopy">
                     2018 &reg; Verisure Perú SAC<br/>
                     Av. Primavera 1050 – Oficina 401<br/> 
                     Santiago de Surco – Urbanización Chacarilla del Estanque<br/>
                     Lima – Perú
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
        <!--[if (gte mso 9)|(IE)]>
              </td>
            </tr>
        </table>
        <![endif]-->
        </td>
      </tr>
    </table>
    
    
    </body>
    </html>
    ';
    }
    else if ($TipoVentaCorreo === 'RPMKT'){
        $tituloCorreoVisita = "OPORTUNIDAD DE VENTA VISITA RPMKT - ".$NProspectoCorreo." (".$tipo.") ";
        
            $mensajeCorreoVisita ='
            <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
            <html xmlns="http://www.w3.org/1999/xhtml">
             
            <head>
              <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
              <title>A Simple Responsive HTML Email</title>
              <style type="text/css">
              body {margin: 0; padding: 0; min-width: 100%!important;}
              img {height: auto;}
              .content {width: 100%; max-width: 600px;}
              .header {padding: 5px 20px 5px 20px;}
              .innerpadding {padding: 20px 30px 15px 30px;}
              .borderbottom {border-bottom: 1px solid #f2eeed;}
              .subhead {font-size: 15px; color: #ffffff; font-family: sans-serif; letter-spacing: 10px;}
              .h1 {font-family: sans-serif;color: #ffffff;font-size:23px; line-height: 38px; font-weight: bold;}
              .h2 {color: #000000; font-family: sans-serif;padding: 0 0 15px 0; font-size: 24px; line-height: 28px; font-weight: bold;}
              .h3 {color: #000000; font-family: sans-serif;font-size: 14px; line-height: 22px; font-weight: bold;}
              .h4 {color: #000000;font-family: sans-serif;font-size: 16px; line-height: 30px; font-weight: bold;}
              .bodycopy {color: #000000; font-family: sans-serif;font-size: 14px; line-height: 22px;}
              .button {text-align: center; font-size: 18px; font-family: sans-serif; font-weight: bold; padding: 0 30px 0 30px;}
              .button a {color: #ffffff; text-decoration: none;}
              .footer {padding: 20px 30px 15px 30px;}
              .footercopy {font-family: sans-serif; font-size: 14px; color: #ffffff;}
              .footercopy a {color: #ffffff; text-decoration: underline;}
              .coldiv115{width: 115px;};
              .coldiv380{width: 380px;};
            
              @media only screen and (max-width: 550px), screen and (max-device-width: 550px) {
              body[yahoo] .hide {display: none!important;}
              body[yahoo] .buttonwrapper {background-color: transparent!important;}
              body[yahoo] .button {padding: 0px!important;}
              body[yahoo] .button a {background-color: #e05443; padding: 15px 15px 13px!important;}
              body[yahoo] .unsubscribe {display: block; margin-top: 20px; padding: 10px 50px; background: #2f3942; border-radius: 5px; text-decoration: none!important; font-weight: bold;}
              }
            
              /*@media only screen and (min-device-width: 601px) {
                .content {width: 600px !important;}
                .col425 {width: 425px!important;}
                .col380 {width: 380px!important;}
                }*/
            
              </style>
            </head>
            
            <body yahoo bgcolor="#f2f2f2">
            <table width="100%" bgcolor="#f2f2f2" border="0" cellpadding="0" cellspacing="0">
            <tr>
              <td>
                <!--[if (gte mso 9)|(IE)]>
                  <table width="600" align="center" cellpadding="0" cellspacing="0" border="0">
                    <tr>
                      <td>
                <![endif]-->     
                <table bgcolor="#ffffff" class="content" align="center" cellpadding="0" cellspacing="0" border="0">
                  <tr>
                    <td bgcolor="#ffffff" class="header">
                      <table width="70" align="center" border="0" cellpadding="0" cellspacing="0">  
                        <tr>
                          <td height="70" style="padding: 0 20px 20px 0;">
                            <img class="fix"  src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png" border="0" alt="" />
                          </td>
                        </tr>
                      </table>
                    </td>
                  </tr>
                  
                  
                  <tr>
                    <td bgcolor="#dc0000" class="header">
                      
                      <!--[if (gte mso 9)|(IE)]>
                        <table width="425" align="center" cellpadding="0" cellspacing="0" border="0">
                          <tr>
                            <td>
                      <![endif]-->
                      <table class="col425" align="center" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 425px;">  
                        <tr>
                          <td height="70">
                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                <td class="h1" align="center" style="padding: 0 0 0 0;">
                                  OPORTUNIDAD DE VENTA RPMKT- '.$NProspectoCorreo.'
                                </td>
                              </tr>
                            </table>
                          </td>
                        </tr>
                      </table>
                      <!--[if (gte mso 9)|(IE)]>
                            </td>
                          </tr>
                      </table>
                      <![endif]-->
                    </td>
                  </tr>
                  
                  <tr>
                    <td class="innerpadding borderbottom">
                      <table width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                          <td class="h2">
                            Estimado(s) Sr(es) '.strtoupper($ComercialCorreo).'
                          </td>
                        </tr>
                        <tr>
                            <td class="bodycopy">
                                <h4 style="font-weight: normal">Envío los datos de una RPMKT para el <span style="font-weight: bold;">'.$FechaVisitaCorreo.' a las '.$HoraVisitaCorreo.'</span></h4>
                                <h4 style="font-weight: normal">Enviar la ubicación al WHATSAPP CEL. <span style="font-weight: bold;">942488070</span> indicando:</h4>
                                <ul>
                                    <ol>
                                        <li>El número de prospecto dentro del día que se agendó la visita.</li>
                                        <li>Informar el estado final de la visita (Vendida o No Vendido).</li>
                                    </ol>
                                </ul>
                            </td>
                        </tr>
                      </table>
                    </td>
                  </tr>
                  
                   <tr>
                    <td class="innerpadding borderbottom">
                      <table  width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                          <td class="h4" bgcolor="#dddddd" align="center" style="padding: 0 0px 0px 0;">
                            INFORMACIÓN DE LA VISITA
                          </td>
                        </tr>
                      </table>
                        
                      <table align="left" border="0" cellpadding="0" cellspacing="0">
                        <tr>
                          <td class="h3" width="145" style="padding: 5px 0px 0px 0;">
                            CLIENTE:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. strtoupper($NombClienteCorreo).'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            DIRECCIÓN:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. strtoupper($DirClienteCorreo).'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            DISTRITO:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($DistClienteCorreo).'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            PROVINCIA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($ProvClienteCorreo).'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            TELEFONO UNO:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. $T1ClienteCorreo.'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            TELEFONO DOS:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. $T2ClienteCorreo.'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            CORREO:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($CorreoClienteCorreo).'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            FECHA VISITA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. $FechaVisitaCorreo.'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            HORA VISITA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. $HoraVisitaCorreo.'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            COMENTARIO VISITA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($ComentarioVisitaCorreo).'
                          </td>
                        </tr>
                        
                      </table>
                     
                    </td>
                  </tr>
            
                  <tr>
                    <td class="innerpadding borderbottom">
                      <table bgcolor="#dddddd" width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                          <td class="h4" align="center"  style="padding: 0 0px 0px 0;">
                            INFORMACIÓN DEL PROSPECTO
                          </td>
                        </tr>
                      </table>
                        
                      <table align="left" border="0" cellpadding="0" cellspacing="0">  
                        <tr>
                          <td class="h3" width="145" style="padding: 5px 0px 0px 0;">
                            MATRICULA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 5px 0px 0px 0;">
                            '. $MatriculaComercialCorreo.'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            COMERCIAL:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($ComercialCorreo).'
                          </td>
                        </tr>
                        
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            DELEGACIÓN:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. $DelegacionCorreo.'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            JEFE VENTA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. $NombJefeVentaCorreo.'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            ESTADO VISITA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '.$EstadoVisitaCorreo.'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            RECURSO:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             RPMKT
                          </td>
                        </tr>
                      </table>
                     
                    </td>
                  </tr>
                  <tr>
                    <td class="footer" bgcolor="#44525f">
                      <table width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                          <td align="center" class="footercopy">
                             2019 &reg; Verisure Perú SAC<br/>
                             Av. Primavera 1050 – Oficina 401<br/> 
                             Santiago de Surco – Urbanización Chacarilla del Estanque<br/>
                             Lima – Perú
                          </td>
                        </tr>
                      </table>
                    </td>
                  </tr>
                </table>
                <!--[if (gte mso 9)|(IE)]>
                      </td>
                    </tr>
                </table>
                <![endif]-->
                </td>
              </tr>
            </table>
            
            
            </body>
            </html>
            ';
    }
    
        //para el envío en formato HTML 
        $headersCorreoVisita = "MIME-Version: 1.0\r\n";
        $headersCorreoVisita .= "Content-type: text/html; charset=utf-8\r\n";
        
        //dirección del remitente 
            $headersCorreoVisita .= "From: Sistema de Ventas Verismart - Verisure Perú <backoffice@verismart.com.pe>\r\n";
        
        //dirección de respuesta, si queremos que sea distinta que la del remitente 
            $headersCorreoVisita .= "Reply-To: backoffice@verisure.pe\r\n";
        
        //ruta del mensaje desde origen a destino 
            $headersCorreoVisita .= "Return-path: backoffice@verismart.com.pe\r\n";
        
        //direcciones que recibián copia 
            $headersCorreoVisita .= "Cc: ".$copia1.",".$copia2.",".$copia3.",".$copia4.",".$copia5.",".$copia6."\r\n";
        
        //direcciones que recibirán copia oculta 
            $headersCorreoVisita .= "Bcc: ".$correo_prueba."\r\n"; 
        
        mail($paraCorreoVisita, $tituloCorreoVisita, $mensajeCorreoVisita, $headersCorreoVisita);
            
    
    }
    //Funcion enviar correo al especialista cuando se valida el checkin, solo para las delegaciones del piloto
    function enviarCorreoValidacionCheckIN(){
    global $DelegacionCorreo;
    
    if($DelegacionCorreo == 154 || $DelegacionCorreo == 156 || $DelegacionCorreo == 150 || $DelegacionCorreo == 151 || $DelegacionCorreo == 152 || $DelegacionCorreo == 153 || $DelegacionCorreo == 155 || $DelegacionCorreo == 157 || $DelegacionCorreo == 158 || $DelegacionCorreo == 159 ){
        global $NProspecto;
        global $CorreoComercialCorreo;
        global $CorreoJefeVentaCorreo;
        global $CheckinCorreo;
        
        $tituloCorreo = "NOTIFICACION VERISMART - ".$NProspecto;
        
        $mensajeCorreo = '
            <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                <html xmlns="http://www.w3.org/1999/xhtml">
                    <head>
                        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                        <title>A Simple Responsive HTML Email</title>
                        <style type="text/css">
                            body {
                                margin: 0;
                                padding: 0;
                                min-width: 100%!important;
                            }
                            
                            img {
                                height: auto;
                            }
                            
                            .content {
                                width: 100%;
                                max-width: 600px;
                            }
                            
                            .header {
                                padding: 5px 20px 5px 20px;
                            }
                            
                            .innerpadding {
                                padding: 20px 30px 0px 30px;
                            }
                            
                            .borderbottom {
                                border-bottom: 1px solid #f2eeed;
                            }
                            
                            .subhead {
                                font-size: 15px;
                                color: #ffffff;
                                font-family: sans-serif;
                                letter-spacing: 10px;
                            }
                            
                            .h1 {
                                font-family: sans-serif;
                                color: #ffffff;
                                font-size: 23px;
                                line-height: 38px;
                                font-weight: bold;
                            }
                            
                            .h2 {
                                color: #000000;
                                font-family: sans-serif;
                                padding: 0 0 15px 0;
                                font-size: 24px;
                                line-height: 28px;
                                font-weight: bold;
                            }
                            
                            .h3 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 14px;
                                line-height: 22px;
                                font-weight: bold;
                            }
                            
                            .h4 {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 16px;
                                line-height: 30px;
                                font-weight: bold;
                            }
                            
                            .bodycopy {
                                color: #000000;
                                font-family: sans-serif;
                                font-size: 14px;
                                line-height: 22px;
                            }
                            
                            .button {
                                text-align: center;
                                font-size: 18px;
                                font-family: sans-serif;
                                font-weight: bold;
                                padding: 0 30px 0 30px;
                            }
                            
                            .button a {
                                color: #ffffff;
                                text-decoration: none;
                            }
                            
                            .footer {
                                padding: 20px 30px 15px 30px;
                            }
                            
                            .footercopy {
                                font-family: sans-serif;
                                font-size: 14px;
                                color: #ffffff;
                            }
                            
                            .footercopy a {
                                color: #ffffff;
                                text-decoration: underline;
                            }
                            
                            .coldiv115 {
                                width: 115px;
                            }
                            
                            ;
                            .coldiv380 {
                                width: 380px;
                            }
                            
                            ;
                            @media only screen and (max-width: 550px),
                            screen and (max-device-width: 550px) {
                                body[yahoo] .hide {
                                    display: none!important;
                                }
                                body[yahoo] .buttonwrapper {
                                    background-color: transparent!important;
                                }
                                body[yahoo] .button {
                                    padding: 0px!important;
                                }
                                body[yahoo] .button a {
                                    background-color: #e05443;
                                    padding: 15px 15px 13px!important;
                                }
                                body[yahoo] .unsubscribe {
                                    display: block;
                                    margin-top: 20px;
                                    padding: 10px 50px;
                                    background: #2f3942;
                                    border-radius: 5px;
                                    text-decoration: none!important;
                                    font-weight: bold;
                                }
                            }
                        </style>
                    </head>

                    <body yahoo bgcolor="#f2f2f2">
                        <table width="100%" bgcolor="#f2f2f2" border="0" cellpadding="0" cellspacing="0">
                            <tr>
                                <td>
                                    <table bgcolor="#ffffff" class="content" align="center" cellpadding="0" cellspacing="0" border="0">
                                        <tr>
                                            <td bgcolor="#ffffff" class="header">
                                                <table width="70" align="center" border="0" cellpadding="0" cellspacing="0">
                                                    <tr>
                                                        <td height="70" style="padding: 0 20px 20px 0;">
                                                            <img class="fix" src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png" border="0" alt="" />
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                    
                                        <tr>
                                            <td bgcolor="#dc0000" class="header">
                                                <table class="col425" align="center" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 425px;">
                                                    <tr>
                                                        <td height="70">
                                                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                                <tr>
                                                                    <h1 class="h1" align="center" style="padding: 0 0 0 0;">VERISMART</h1>
                                                                    <h1 class="h1" align="center" style="padding: 0 0 0 0;">'.$NProspecto.'</h1>
                                                                    <h1 class="h1" align="center" style="padding: 0 0 0 0;">NOTIFICACION CHECK-IN RE</h1>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                    
                                        <tr>
                                            <td class="innerpadding">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td class="h2">
                                                            Estimado usuario,
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="bodycopy">
                                                            <p>Nos complace informarle que se ha enviado una notificación por Check-IN RE</p>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="innerpadding">
                                                <p>El Check-IN del prospecto '.$NProspecto.' ha sido validado y actualizado  por BackOffice-Marketing<p>
                                                <p>Por favor, para cualquier consulta, contacta con BackOffice-Marketing (backoffice@verisure.pe).</p>
                                                <p>Muchas gracias y un saludo.</p>
                                                <p>IT Perú</p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="footer" bgcolor="#44525f">
                                                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                    <tr>
                                                        <td align="center" class="footercopy">
                                                            2021 &reg; Verisure Perú SAC<br/> Av. Primavera 1050 – Oficina 401<br/> Santiago de Surco – Urbanización Chacarilla del Estanque<br/> Lima – Perú
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </body>
            
            </html>
        ';
        
        //Destinatario
        $paraCorreo = $CorreoComercialCorreo.", ".$CorreoJefeVentaCorreo;
        
        $correo_prueba = "joseenrique.nanquen@verisure.pe";
        
        //para el envío en formato HTML 
        $headersCorreo = "MIME-Version: 1.0\r\n";
        $headersCorreo .= "Content-type: text/html; charset=utf-8\r\n";
        
        //dirección del remitente 
            $headersCorreo .= "From: Sistema de Ventas Verismart - Verisure Perú <soporteit@verismart.com.pe>\r\n";
        
        //dirección de respuesta, si queremos que sea distinta que la del remitente 
            $headersCorreo .= "Reply-To: soporteit@verisure.pe\r\n";
        
        //ruta del mensaje desde origen a destino 
            $headersCorreo .= "Return-path: soporteit@verismart.com.pe\r\n";
        
        //direcciones que recibián copia 
            //$headersCorreo .= "cc: ".$correojefe.", ".$copia1."\r\n"; 
        
        //direcciones que recibirán copia oculta 
        $headersCorreo .= "Bcc: ".$correo_prueba."\r\n"; 
        
        mail($paraCorreo, $tituloCorreo, $mensajeCorreo, $headersCorreo);
    }
}

    //Funcion de Security Check
    function consultarCategoriaMatricula($matricula){
        global $con;
        
        $sql = $con->prepare("SELECT Categoria FROM yifi58ge_dbUSUARIO.tblusuario WHERE Matricula= ? ");
        $sql->bind_param('s',$matricula);
        $sql->execute();
        $sql->store_result();
        $sql->bind_result(
            $CategoriaRow
            );
        
        while($sql->fetch()){
            $categoriamatricula = $CategoriaRow;
        }
        
        return $categoriamatricula;
        
    }
    
    function consultarApertura($idven){
        global $con;
        
        $sql = $con->prepare("SELECT Categoria,EstadoAsignacion FROM yifi58ge_dbVENTAS.tblreasignacion WHERE IdVenta= ? ORDER by IdReasignacion DESC LIMIT 1");
        $sql->bind_param('i',$idven);
        $sql->execute();
        $sql->store_result();
        $sql->bind_result(
            $CategoriaRow,
            $EstadoAsignacionRow
            );

        
        while($sql->fetch()){
            $categoriamatricula = $CategoriaRow;
            $estadoasignacion = $EstadoAsignacionRow;
        }
        
        if($categoriamatricula=="DEL" && $estadoasignacion=="Apertura"){
            $accion="Apertura";
        }else{
            $accion="Reasignacion";
        }
        
        return $accion;
        
    }
    
    function insertarReasignacion($idventa){
        global $con;
    
        global $matricula, $categoriamatricula,$fecharegistroventa, $dc,$ObjCorreoM,$AsignacionPlantilla;
        $estadoasignacion='Reasignacion'; 
            try {
        
              $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblreasignacion(IdVenta,Matricula, Categoria, FechaAsignacion,CC,EstadoAsignacion,ObjCorreoM,AsignacionPlantilla) VALUES(?,?, ?, ?,?,?,?,?)");
              $stmt->bind_param('isssisss', $idventa,$matricula,$categoriamatricula,$fecharegistroventa,$dc,$estadoasignacion,$ObjCorreoM,$AsignacionPlantilla);
                $stmt->execute();
                $respuesta = $con->insert_id;
                $stmt->close();
            } catch (\Exception $e) {
                $respuesta = array(
                    'respuesta' => 'error'
                );
            }
        
            return $respuesta;
    
    }

    function EnvioCorreoSecurityCheck($idventa,$correocliente,$accion){
         if($accion=="Apertura"){
             $plantilla="plantilla_securty_check_apertura";
             $texto="¡Hola! Ya tienes asignado al especialista de seguridad que te atenderá.";
         }else{
             $plantilla="plantilla_securty_check_reasignacion";
             $texto="¡Hola! Hemos reasignado a un especialista para tu visita";
         }
        $opts = array(
        'http'=>array(
        'method'=>"GET",
        'header'=>"User-Agent: api script\r\n"
        ));
        
        $context = stream_context_create($opts);
        
                $curl = curl_init();
        
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => 'Verisure Visitas',
            'From' => 'visitas@verisure.pe',
            'To' => 
            array (
              'Email' => 
              array (
                0 => $correocliente
              )
            ),
            'Cc' => 
            array (
              'Email' => 
              array (
                0 => '',
              )
            ),
            'Bcc' => 
            array (
              'Email' => 
              array (
                0 => 'joseenrique.nanquen@verisure.pe',
              )
            ),
            'Message' => 
            array (
              'Subject' => $texto,
              'Classification' => 'C',
              'Body' => 
              array (
                'Format' => 'html',
                'Value' => file_get_contents("https://www.verismart.com.pe/verismart/$plantilla.php?IdVenta=$idventa",false,$context),
              )
            ),
            'Options' => 
            array (
              'OpenTracking' => 'true',
              'ClickTracking' => 'true',
              'TextHtmlTracking' => 'true',
              'AutoTextBody' => 'false',
            )
          )
        );
        
        $dataSC_string = json_encode($dataSC);
        
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 60,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => $dataSC_string,
          CURLOPT_HTTPHEADER => array(
            "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
            "cache-control: no-cache",
            "content-type: application/json"
          ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
          return "cURL Error #:" . $err;
        } else {
          return $response;
        }
            
    
    }    
    
    function EnvioCorreo_Modificacion($idventa,$nprospecto,$tipoventa){
        
        //ESTRUCTURA DEL CORREO ACTUALIZADO
        //DELEGADO
        //VARIABLES GLOBALES
        global $PerfilComercialCorreo;
        global $CategoriaComercialCorreo;
        
        global $CorreoComercialCorreo;
        global $CorreoJefeVentaCorreo;
        global $CorreoDelegadoCorreo;
        global $DelegacionCorreo;
        //ESTRUCTURA
        if($PerfilComercialCorreo == 17){
            
            if($CategoriaComercialCorreo == 'N1' || $CategoriaComercialCorreo == 'N2' || $CategoriaComercialCorreo == 'N3' || $CategoriaComercialCorreo == 'JE' 
            || $CategoriaComercialCorreo == 'VET' || $CategoriaComercialCorreo == 'COACH' || $CategoriaComercialCorreo == 'MST' || $CategoriaComercialCorreo == 'ELI/MST'){
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=$CorreoJefeVentaCorreo;; //JEFE
                $correoAdministrativo3=$CorreoDelegadoCorreo; //DELEGADO
            } else if ($CategoriaComercialCorreo == 'DEL'){
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=$CorreoJefeVentaCorreo; //JEFE
                $correoAdministrativo3=''; //DELEGADO
            } else if ($CategoriaComercialCorreo == 'GERENTE TERRITORIAL') {
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=''; //JEFE
                $correoAdministrativo3=''; //DELEGADO
            } else {
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=''; //JEFE
                $correoAdministrativo3=''; //DELEGADO
            }
        } else if ($PerfilComercialCorreo == 38){
            $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
        } else {
            $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
        }
        
        if($DelegacionCorreo == 150 || $DelegacionCorreo == 156 || $DelegacionCorreo == 157 || $DelegacionCorreo == 159 || $DelegacionCorreo == 252 || $DelegacionCorreo == 130 || $DelegacionCorreo == 151){
            $correoAdministrativo4="renzobranchi.branez@verisure.pe";
        } else if ($DelegacionCorreo == 152){
            $correoAdministrativo4="cristhian.cuneo@verisure.pe";
        } else if ($DelegacionCorreo == 120  || $DelegacionCorreo == 121  || $DelegacionCorreo == 140 || $DelegacionCorreo == 200){
            $correoAdministrativo4="juliocesar.rojas@verisure.pe";             
        } else if ($DelegacionCorreo == 40  || $DelegacionCorreo == 41  || $DelegacionCorreo == 80 || $DelegacionCorreo == 100 || $DelegacionCorreo == 230){
            $correoAdministrativo4="david.adell@verisure.pe";
        } else if ($DelegacionCorreo == 154 || $DelegacionCorreo == 155 || $DelegacionCorreo == 158 || $DelegacionCorreo == 152){
            $correoAdministrativo4="monicamaria.sanchez@verisure.pe";
        }
        
        
        $copia1 = "CHRISTIAN.GUTIERREZ@VERISURE.PE";
        $copia2 = "SHIRLEY.CUADRA@VERISURE.PE";
        $copia3 = "MADELEYNE.MUNAYCO@VERISURE.PE";
        $copia4 = "diego.delabarra@verisure.pe";
        
        $titulo="";
        
        if($tipoventa === 'RE'){
            $titulo="OPORTUNIDAD DE VENTA VISITA RE - ".$nprospecto." (MODIFICACION) ";
        }else if($tipoventa === 'RPMKT'){
            $titulo = "OPORTUNIDAD DE VENTA VISITA RPMKT - ".$nprospecto." (MODIFICACION) ";
        }else{
            $titulo=""; 
        }
        
        $opts = array(
            'http'=>array(
            'method'=>"GET",
            'header'=>"User-Agent: api script\r\n"
        ));
        $context = stream_context_create($opts);
    
        $curl = curl_init();
        
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => 'Sistema de Ventas Verismart - Verisure Perú',
            'From' => 'backoffice@verisure.pe',
            'To' => 
                array (
                  'Email' => 
                  array (
                    0 => $correoAdministrativo1,
                    1 => $correoAdministrativo2,
                    2 => $correoAdministrativo3,
                    3 => $correoAdministrativo4
                  )
                ),
            'Cc' => 
                array (
                  'Email' => 
                  array (
                    0 => $copia1,
                    1 => $copia2,
                    2 => $copia3,
                    3 => $copia4,
                  )
                ),
            'Bcc' => 
                array (
                  'Email' => 
                  array (
                    0 => 'joseenrique.nanquen@verisure.pe',
                    1 => 'anthony.villarreal@verisure.pe'
                  )
                ),
            'Message' => 
                array (
                    'Subject' => $titulo,
                    'Classification' => 'C',
                    'Body' => 
                        array (
                            'Format' => 'html',
                            'Value' => file_get_contents("https://www.verismart.com.pe/verismart/plantilla_modificacion_visita.php?idventa=$idventa",false,$context),
                        )
                ),
            'Options' => 
                array (
                  'OpenTracking' => 'true',
                  'ClickTracking' => 'true',
                  'TextHtmlTracking' => 'true',
                  'AutoTextBody' => 'false',
                )
          )
        );
        
        $dataSC_string = json_encode($dataSC);
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT =>630,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $dataSC_string,
            CURLOPT_HTTPHEADER => array(
                "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
                "cache-control: no-cache",
                "content-type: application/json"
            ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
          return "cURL Error #:" . $err;
        } else {
          return $response;
        }    
    
    }
    
    function EnvioCorreo_Reasignacion($idventa,$nprospecto,$tipoventa){
        //ESTRUCTURA DEL CORREO ACTUALIZADO
        //DELEGADO
        //VARIABLES GLOBALES
        global $PerfilComercialCorreo;
        global $CategoriaComercialCorreo;
        
        global $CorreoComercialCorreo;
        global $CorreoJefeVentaCorreo;
        global $CorreoDelegadoCorreo;
        
        global $DelegacionCorreo;
        //ESTRUCTURA
        if($PerfilComercialCorreo == 17){
            
            if($CategoriaComercialCorreo == 'N1' || $CategoriaComercialCorreo == 'N2' || $CategoriaComercialCorreo == 'N3' || $CategoriaComercialCorreo == 'JE' 
            || $CategoriaComercialCorreo == 'VET' || $CategoriaComercialCorreo == 'COACH' || $CategoriaComercialCorreo == 'MST' || $CategoriaComercialCorreo == 'ELI/MST'){
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo3=$CorreoDelegadoCorreo; //DELEGADO
            } else if ($CategoriaComercialCorreo == 'DEL'){
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=$CorreoJefeVentaCorreo; //JEFE
                $correoAdministrativo3=''; //DELEGADO
            } else if ($CategoriaComercialCorreo == 'GERENTE TERRITORIAL') {
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=''; //JEFE
                $correoAdministrativo3=''; //DELEGADO
            } else {
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=''; //JEFE
                $correoAdministrativo3=''; //DELEGADO
            }
        } else if ($PerfilComercialCorreo == 38){
            $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
        } else {
            $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
        }
        
        if($DelegacionCorreo == 150 || $DelegacionCorreo == 156 || $DelegacionCorreo == 157 || $DelegacionCorreo == 159 || $DelegacionCorreo == 252 || $DelegacionCorreo == 130 || $DelegacionCorreo == 151){
            $correoAdministrativo4="renzobranchi.branez@verisure.pe";
        } else if ($DelegacionCorreo == 152){
            $correoAdministrativo4="cristhian.cuneo@verisure.pe";
        } else if ($DelegacionCorreo == 120  || $DelegacionCorreo == 121  || $DelegacionCorreo == 140 || $DelegacionCorreo == 200){
            $correoAdministrativo4="juliocesar.rojas@verisure.pe";             
        } else if ($DelegacionCorreo == 40  || $DelegacionCorreo == 41  || $DelegacionCorreo == 80 || $DelegacionCorreo == 100 || $DelegacionCorreo == 230){
            $correoAdministrativo4="david.adell@verisure.pe";
        } else if ($DelegacionCorreo == 154 || $DelegacionCorreo == 155 || $DelegacionCorreo == 158 || $DelegacionCorreo == 152){
            $correoAdministrativo4="monicamaria.sanchez@verisure.pe";
        }
        
        
        $copia1 = "CHRISTIAN.GUTIERREZ@VERISURE.PE";
        $copia2 = "SHIRLEY.CUADRA@VERISURE.PE";
        $copia3 = "MADELEYNE.MUNAYCO@VERISURE.PE";
        
        //CORREO
        $titulo="";
        
        if($tipoventa === 'RE'){
            $titulo="OPORTUNIDAD DE VENTA VISITA RE - ".$nprospecto." (REASIGNACION) ";
        }else if($tipoventa === 'RPMKT'){
            $titulo = "OPORTUNIDAD DE VENTA VISITA RPMKT - ".$nprospecto." (REASIGNACION) ";
        }else{
            $titulo=""; 
        }
        
        $opts = array(
            'http'=>array(
            'method'=>"GET",
            'header'=>"User-Agent: api script\r\n"
        ));
        $context = stream_context_create($opts);
    
        $curl = curl_init();
        
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => 'Sistema de Ventas Verismart - Verisure Perú',
            'From' => 'backoffice@verisure.pe',
            'To' => 
                array (
                  'Email' => 
                  array (
                    0 => $correoAdministrativo1,
                    1 => $correoAdministrativo2,
                    2 => $correoAdministrativo3,
                    3 => $correoAdministrativo4
                  )
                ),
            'Cc' => 
                array (
                  'Email' => 
                    array (
                        0 => $copia1,
                        1 => $copia2,
                        2 => $copia3
                    )
                ),
            'Bcc' => 
                array (
                    'Email' => 
                        array (
                            0 => 'joseenrique.nanquen@verisure.pe',
                            1 => 'anthony.villarreal@verisure.pe'
                        )
                ),
            'Message' => 
                array (
                    'Subject' => $titulo,
                    'Classification' => 'C',
                    'Body' => 
                        array (
                            'Format' => 'html',
                            'Value' => file_get_contents("https://www.verismart.com.pe/verismart/plantilla_reasignacion_visita.php?idventa=$idventa",false,$context),
                        )
                ),
            'Options' => 
                array (
                  'OpenTracking' => 'true',
                  'ClickTracking' => 'true',
                  'TextHtmlTracking' => 'true',
                  'AutoTextBody' => 'false',
                )
          )
        );
        
        $dataSC_string = json_encode($dataSC);
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $dataSC_string,
            CURLOPT_HTTPHEADER => array(
                "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
                "cache-control: no-cache",
                "content-type: application/json"
            ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
          return "cURL Error #:" . $err;
        } else {
          return $response;
        }    
    
    }
    
    function insertarLogCorreo($idventa){
        global $con;
    
        global $ObjCorreoAsignacion,$fecharegistroventa;
         
            try {
        
              $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog_correo(IdVenta,ObjTransaccion,FechaHoraREG) VALUES(?,?,?)");
              $stmt->bind_param('iss', $idventa,$ObjCorreoAsignacion,$fecharegistroventa);
                $stmt->execute();
                $respuesta = $con->insert_id;
                $stmt->close();
            } catch (\Exception $e) {
                $respuesta = array(
                    'respuesta' => 'error'
                );
            }
        
            return $respuesta;
    
    }
    
//END PHP 
?> 