<?php
header("Content-Type: text/html;charset=utf-8");
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require '../config/db.php';
require '../config/conexion.php';

include 'log/insertLog.php';
include 'log/insertLogCliente.php';

$fecharegistro = date("Y-m-d H:i:s");
$usuarioreg = $_SESSION['usuariosesion'];

//VALIDAR DATOS CLIENTE
$idcliente = stringtonull($_POST['lblidcliente']);
$ncliente = stringtonull($_POST['lblncliente']);
$nombcliente = stringtonull($_POST['lblnombcliente']);
$correo = stringtonull($_POST['lblcorreo']);
$correodos = stringtonull($_POST['lblcorreo2']);
$correo3 = stringtonull($_POST['lblcorreo3']);
$correo4 = stringtonull ($_POST['lblcorreo4']);
$direccion= stringtonull($_POST['lbldireccion']);
$distrito = stringtonull($_POST['lbldistrito']);
$telefonouno = stringtonull($_POST['lblmovil']);
$telefonodos = stringtonull($_POST['lblfijo']);
$telefonotres = stringtonull($_POST['lblTelefono3']);
$telefonocuatro = stringtonull($_POST['lblTelefono4']);
$segmento = stringtonull($_POST['lblsegmento']);

//DATOS DE RETENCION
$idretencion = stringtonull($_POST['idretencion']);

$movitoaviso = stringtonull($_POST['lblmovitoaviso']);
$gestor = stringtonull($_POST['lblasignado']);
$tipocanal = stringtonull($_POST['tipocanal']);

if($_POST['lblfechacierre'] != '' || !empty($_POST['lblfechacierre'])){
    $lblfechacierre = $_POST['lblfechacierre'];
    $lblfechacierreconvert = myUrlEncode($lblfechacierre);
    $lblfechacierregrabar = format_date_Y_mm_dd(str_replace('/', '-', $lblfechacierreconvert));
} else {
    $lblfechacierregrabar = NULL;
}


$lblmotivocierre = stringtonull($_POST['lblmotivocierre']);
$lblestadofingestion = stringtonull($_POST['lblestadofingestion']);
$lblduracionoferta = stringtonull($_POST['lblduracionoferta']);

$hiddenreincidente  = $_POST['hiddenreincidente'];
$lbltipocierre = $_POST['lbltipocierre'];
$lblmotivocierretc=$_POST['lblmotivocierretc'];
$lblcompetencia = stringtonull($_POST['lblcompetencia']);


    //REGISTRO NUEVO CLIENTE
    if ($idcliente == NULL){
            //$consultaCliente = consultaClienteI_Amp();
            $resultadoCliente = insertarCliente(); //RETORNA EL IDCLIENTE
            
            if ($resultadoCliente > 0){
               // $consultaRetencion = consultaRetencionI();
                $resultadoRetencion = insertarRetencion($resultadoCliente);
                
                if ($resultadoRetencion['respuesta'] == 'exito'){
                    $idretencion = $resultadoRetencion['id_registro'];
                    
                    $idLogSeg = StmtInsertarLogSeguridad('Registrar');
                    
                    if ($idLogSeg > 0){
                        //insertarLogI_Amp($idLogSeg, $consultaCliente);
                        //insertLogRetencionI($idLogSeg, $consultaRetencion);
                    }
                    
                    die(json_encode($resultadoRetencion));
                    
                } else {
                    die(json_encode($resultadoRetencion));     
                }
            } else {
                die(json_encode($resultadoCliente));       
            }
        
    } 
    //REGISTRO CON CLIENTE EXISTENTE
    else {
        //ACTUALIZAR CLIENTE
        $resultadoCliente = actualizarCliente($idcliente);
        //REGISTRAR Retencion
        if ($idretencion == NULL){
                    //$consultaRetencion = consultaRetencionI();
                    $resultadoRetencion = insertarRetencion($idcliente);
                    
                    if ($resultadoRetencion['respuesta'] == 'exito' || $resultadoCliente>0){
                        $idretencion = $resultadoRetencion['id_registro'];
                        
                        $idLogSeg = StmtInsertarLogSeguridad('Registrar');
                        
                        if ($idLogSeg > 0){
                            //insertLogRetencionI($idLogSeg, $consultaRetencion);
                        }
                        
                        die(json_encode($resultadoRetencion));
                    
                    } else {
                        die(json_encode($resultadoRetencion));     
                    }
        } else {
            //$consultaRetencion = consultaRetencion($idretencion);
                $resultadoRetencion = actualizarRetencion($idretencion);
                
                if ($resultadoRetencion > 0 || $resultadoCliente>0){
            
                        $idLogSeg = StmtInsertarLogSeguridad('Modificar');
                
                        if ($idLogSeg > 0){
                            if($resultadoRetencion > 0){
                                //insertLogRetencion($idLogSeg, $consultaRetencion);
                            }

                        }
                        die(json_encode(array('respuesta' => 'exito', 'id_registro' => '')));
                    
                }
                else if($resultadoRetencion==0 || $resultadoCliente==0){
                    
                    die(json_encode(array('respuesta' => 'SinCambios')));
                    
                }
                else {
                    die(json_encode(array('respuesta' => 'error')));
                }    
        }
    }




function actualizarRetencion($idretencion){
    
    global $con;
    
    global $movitoaviso;
    global $gestor;
    global $tipocanal;
    
    global $lblfechacierregrabar;
    global $lblmotivocierre;
    
    global $lblestadofingestion;
    global $lblduracionoferta;
    global $hiddenreincidente;
    global $lbltipocierre;
    global $lblmotivocierretc;
    global $lblcompetencia;

  
    try{
        $stmt = $con->prepare("UPDATE tblretencion SET MotivoAviso=?, Gestor = ?, FechaCierre=?, TipoCierre=?, MotivoCierre=?, EstadoFinGestion=?,TipoCanal=?,DuracionOferta=?,Reincidente=?,MotivoCierreTC=?,Competencia=? WHERE IdRetencion = ?");
        $stmt->bind_param('sssssssssssi', $movitoaviso, $gestor, $lblfechacierregrabar, $lbltipocierre, $lblmotivocierre, $lblestadofingestion, $tipocanal, $lblduracionoferta,$hiddenreincidente,$lblmotivocierretc,$lblcompetencia,$idretencion);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();    
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function insertarCliente(){
    
    global $con;
    
    global $distrito;
    global $nombcliente;
    global $telefonouno;
    global $telefonodos;
    global $telefonotres;
    global $telefonocuatro;
    global $correo;
    global $direccion;
    //Nuevos Registro
    global $ncliente;
    global $correodos;
    global $correo3;
    global $correo4;
    global $segmento;
    
    $telefonodos = stringtonull($telefonodos);
    $correodos=stringtonull($correodos);
    
    try {
        
        $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblcliente(IdGeografico, NombApellido, Telefonouno, Telefonodos, Correo, Direccion, NCliente,Correodos,Segmento, correotres, correocuatro, Telefonotres, Telefonocuatro) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ");
        $stmt->bind_param('issssssssssss',  $distrito, $nombcliente, $telefonouno, $telefonodos, $correo, $direccion,$ncliente,$correodos,$segmento, $correo3, $correo4, $telefonotres, $telefonocuatro);
        $stmt->execute();
        
        $respuesta = $con->insert_id;

        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
    }
    
    return $respuesta;
}

function insertarretencion($idCli){
    global $con;
    
    global $movitoaviso;
    global $gestor;
    global $tipocanal;
    
    global $lblfechacierregrabar;
    global $lblmotivocierre;
    
    global $lblestadofingestion;
    global $lblduracionoferta;
    global $hiddenreincidente;
    global $lbltipocierre;
    global $fecharegistro;
    global $lblmotivocierretc;
    global $lblcompetencia;
    
    try{
    
        $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblretencion(IdCliente,MotivoAviso, Gestor, FechaCierre, TipoCierre, MotivoCierre, EstadoFinGestion,TipoCanal,DuracionOferta,Reincidente,FechaHoraREG,MotivoCierreTC,Competencia) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?)");
        $stmt->bind_param('issssssssssss', $idCli,  $movitoaviso, $gestor, $lblfechacierregrabar, $lbltipocierre, $lblmotivocierre, $lblestadofingestion, $tipocanal, $lblduracionoferta,$hiddenreincidente,$fecharegistro,$lblmotivocierretc,$lblcompetencia);
        $stmt->execute();
        
        $IdRetencion = $con->insert_id;
        
        
        $respuesta = array(
            'respuesta' => 'exito',
            'id_registro' => $IdRetencion
        );
        
        
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
    }
    
    return $respuesta;
    
}


function actualizarCliente($idCli){
    global $con;
    
    global $correo3;
    global $correo4;
    global $telefonotres;
    global $telefonocuatro;
    
    try{
        $stmt = $con->prepare("UPDATE tblcliente SET Telefonotres=?, Telefonocuatro=?, correotres=?, correocuatro=? WHERE IdCliente=?");
        $stmt->bind_param('ssssi', $telefonotres, $telefonocuatro, $correo3, $correo4, $idCli);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();  
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
}



function stringtonull($val){
    
    if ($val == '' || empty($val)){
        $resultado = NULL;
    }
    else if(!isset($val)){
        $resultado = NULL;
    }
    else {
        $resultado = $val;
    }
    
    return $resultado;
}


