<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}

$ingresokit=0;
$ingresoextras=0;
$ingresototal=0;

require '../config/db.php';
require '../config/conexion.php';
require_once '../helper/helper_validacion.php';
//LOGS TRANSACCCIONALES
include 'log/insertLog.php'; //LOG TRANSAC
include 'log/insertLogCliente.php'; //LOG CLIENTE
include 'log/insertLogProsectoRP.php'; //LOG PROSPECTORP
include 'log/insertLogFacturacion.php'; //LOG FACTURACION
include 'log/insertLogAgenda.php'; //LOG AGENDA
include 'log/insertLogVenta.php'; //LOG VENTA

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

$categoria = sanitizaCampo($_POST['lblcategoria'],'sanitizestring|scapestring|htmlspecialchars',$con);
$categoria = htmlspecialchars($categoria);

$idprospectorp = sanitizaCampo($_POST['lblidprospectorp'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$idprospectorp = htmlspecialchars($idprospectorp);

$gestor = sanitizaCampo($_POST['gestor'],'sanitizestring|scapestring|htmlspecialchars',$con);
$gestor = htmlspecialchars($gestor);

$matricula = sanitizaCampo($_POST['lblmatricula'],'sanitizestring|scapestring|htmlspecialchars',$con);
$matricula = htmlspecialchars($matricula);

$idusuario = sanitizaCampo($_POST['lblidusuario'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$idusuario = htmlspecialchars($idusuario);

$nombcomercial = sanitizaCampo($_POST['lblnombcomercial'],'sanitizestring|scapestring|htmlspecialchars',$con);
$nombcomercial = htmlspecialchars($nombcomercial);

$dc = sanitizaCampo($_POST['lbldc'],'sanitizestring|scapestring|htmlspecialchars',$con);
$dc = htmlspecialchars($dc);

$jefeventa = sanitizaCampo($_POST['lbljefeventa'],'sanitizestring|scapestring|htmlspecialchars',$con);
$jefeventa = htmlspecialchars($jefeventa);

$estadoprospecto = sanitizaCampo($_POST['lblestadoprospecto'],'sanitizestring|scapestring|htmlspecialchars',$con);
$estadoprospecto = htmlspecialchars($estadoprospecto);

$estadoventa = sanitizaCampo($_POST['lblestventa'],'sanitizestring|scapestring|htmlspecialchars',$con);
$estadoventa = htmlspecialchars($estadoventa);

$tipoventa = sanitizaCampo($_POST['lbltiventa'],'sanitizestring|scapestring|htmlspecialchars',$con);
$tipoventa = htmlspecialchars($tipoventa);

$segmento = sanitizaCampo($_POST['lblsegmento'],'sanitizestring|scapestring|htmlspecialchars',$con);
$segmento = htmlspecialchars($segmento);

$mesesautorizados = sanitizaCampo($_POST['lblmesesautorizados'],'sanitizefloat|scapestring|htmlspecialchars',$con);
$mesesautorizados = htmlspecialchars($mesesautorizados);

$preciokit = sanitizaCampo($_POST['lblpreciokit'],'sanitizefloat|scapestring|htmlspecialchars',$con);
$preciokit = htmlspecialchars($preciokit);

$totalextra = sanitizaCampo($_POST['lbltotalextra'],'sanitizefloat|scapestring|htmlspecialchars',$con);
$totalextra = htmlspecialchars($totalextra);

$resumenventa = sanitizaCampo($_POST['lblresumenventa'],'sanitizestring|scapestring|htmlspecialchars',$con);
$resumenventa = htmlspecialchars($resumenventa);

$extraautorizado = sanitizaCampo($_POST['lblextraautorizado'],'sanitizestring|scapestring|htmlspecialchars',$con);
$extraautorizado = htmlspecialchars($extraautorizado);

$formadepago = sanitizaCampo($_POST['lblformadepago'],'sanitizestring|scapestring|htmlspecialchars',$con);
$formadepago = htmlspecialchars($extraautorizado);

//INFORMACION ADICIONAL DE LA VENTA AGREGADA POR PILOTO ZEROVISION

$lbltipokit = sanitizaCampo($_POST['lbltipokit'],'sanitizestring|scapestring|htmlspecialchars',$con);
$lbltipokit = htmlspecialchars($lbltipokit);

$lblclosingpack = sanitizaCampo($_POST['lblclosingpack'],'sanitizestring|scapestring|htmlspecialchars',$con);
$lblclosingpack = htmlspecialchars($lblclosingpack);

$lblprecioEspecial = sanitizaCampo($_POST['lblprecioEspecial'],'sanitizestring|scapestring|htmlspecialchars',$con);
$lblprecioEspecial = htmlspecialchars($lblprecioEspecial);

$lblCantExtras = sanitizaCampo($_POST['lblCantExtras'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$lblCantExtras = htmlspecialchars($lblCantExtras);

$lblresultadoScoring = sanitizaCampo($_POST['lblresultadoScoring'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblresultadoScoring = htmlspecialchars($lblresultadoScoring);
//INFORMACION ADICIONAL POR PILOTO CHECKIN;
//Nuevos campos VISITA CONCERTADA 18.02
//VISITA CONCERTADA - VALOR(SI O NO)
if(isset($_POST['hidVisitaConcertada'])){
    if($_POST['hidVisitaConcertada']=='' || empty($_POST['hidVisitaConcertada'])){
        $hidVisitaConcertada=NULL;   
    } else {
        $hidVisitaConcertada = sanitizaCampo($_POST['hidVisitaConcertada'],'sanitizestring|scapestring|htmlspecialchars',$con);
        $hidVisitaConcertada = htmlspecialchars($hidVisitaConcertada);
    }
} else {
    $hidVisitaConcertada=NULL;   
}

//FECHA Y HORA VISITA CONCERTADA
if(isset($_POST['fechaVisitaConcertada'])){
    if($_POST['fechaVisitaConcertada']=='' || empty($_POST['fechaVisitaConcertada'])){
        $fechaVisitaConcertadaFinal=NULL;
    } else{
        $fechaVisitaConcertadaOriginal = sanitizaCampo($_POST['fechaVisitaConcertada'],'sanitizestring|scapestring|htmlspecialchars',$con);
        $fechaVisitaConcertadaOriginal = htmlspecialchars($fechaVisitaConcertadaOriginal);
        $fechaVisitaConcertadaFinal= myUrlEncode($fechaVisitaConcertadaOriginal);
        $fechaVisitaConcertadaFinal= format_date_Y_mm_dd(str_replace('/', '-', $fechaVisitaConcertadaFinal));
    }
} else {
    $fechaVisitaConcertadaFinal=NULL;
}

if(isset($_POST['horaVisitaConcertada'])){
    if($_POST['horaVisitaConcertada']=='' || empty($_POST['horaVisitaConcertada'])){
        $horaVisitaConcertada=NULL;
    } else{
        $horaVisitaConcertada = sanitizaCampo($_POST['horaVisitaConcertada'],'sanitizestring|scapestring|htmlspecialchars',$con);
        $horaVisitaConcertada = htmlspecialchars($horaVisitaConcertada);
    }
} else {
    $horaVisitaConcertada=NULL;
}

//FIN INFORMACION ADICIONAL

//CODIGO SCORING
if(isset($_POST['valcodigoOperacionScoring'])){
    if($_POST['valcodigoOperacionScoring']=='' || empty($_POST['valcodigoOperacionScoring'])){
        $valcodigoOperacionScoring=NULL;   
    } else {
        $valcodigoOperacionScoring = sanitizaCampo($_POST['valcodigoOperacionScoring'],'sanitizestring|scapestring|htmlspecialchars',$con);
        $valcodigoOperacionScoring = htmlspecialchars($valcodigoOperacionScoring);
    }
} else {
    $valcodigoOperacionScoring=NULL;   
}

//FIN CODIGO SCORING
$hidGGCC = sanitizaCampo($_POST['hidGGCC'],'sanitizestring|scapestring|htmlspecialchars',$con);
$hidGGCC = htmlspecialchars($hidGGCC);

$hidden_HCertificacion = sanitizaCampo($_POST['hidden_HCertificacion'],'sanitizestring|scapestring|htmlspecialchars',$con);
$hidden_HCertificacion = htmlspecialchars($hidden_HCertificacion);

$lblformapagocuota = sanitizaCampo($_POST['lblformapagocuota'],'sanitizestring|scapestring|htmlspecialchars',$con);
$lblformapagocuota = htmlspecialchars($lblformapagocuota);

$PAI = sanitizaCampo($_POST['lblPAI'],'sanitizestring|scapestring|htmlspecialchars',$con);
$PAI = htmlspecialchars($PAI);

$comentarioprospecto = sanitizaCampo($_POST['lblcomentarioprospecto'],'sanitizestring|scapestring|htmlspecialchars',$con);
$comentarioprospecto = htmlspecialchars($comentarioprospecto);

//---Fechas_de_registros--
$GestionOrigen = 'VENTA';
$fecharegistro = date("Y-m-d H:i:s");
//ARRAY DATOS DEL PROSPECTO A MODIFICAR
$arrayProspectoRP = consultaProspectoRP($idprospectorp);

//

if($categoria=='ProspectoRP'){
    
    //---Cliente--
    $idcliente = sanitizaCampo($_POST['lblidcliente'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $idcliente = htmlspecialchars($idcliente);

    $nombcliente = sanitizaCampo($_POST['lblnombcliente'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $nombcliente = htmlspecialchars($nombcliente);

    $correo = sanitizaCampo($_POST['lblcorreo'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $correo = htmlspecialchars($correo);
    
    $direccion = sanitizaCampo($_POST['lbldireccion'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $direccion = htmlspecialchars($correo);
    
    $distrito = sanitizaCampo($_POST['lbldistrito'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $distrito = htmlspecialchars($distrito);
    
    $telefonouno = sanitizaCampo($_POST['lblmovil'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $telefonouno = htmlspecialchars($telefonouno);
    
    $telefonodos = sanitizaCampo($_POST['lblfijo'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $telefonodos = htmlspecialchars($telefonodos);
    //---Termina Cliente---
    
    //CREACION DEL ARRAY QUE TRAE DATOS DEL CLIENTE
    $arrayCliente = consultaCliente($idcliente);
    
    //ACTUALIZA DATOS DEL CLIENTE RP
    if($telefonodos=="" || empty($telefonodos)){
        $sqlcliente= $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente c SET c.IdGeografico=?,c.NombApellido=?,c.Telefonouno=?,c.Correo=?,c.Direccion=? WHERE c.IdCliente=?");
        $sqlcliente->bind_param('issssi',$distrito,$nombcliente,$telefonouno,$correo,$direccion,$idcliente);
        $sqlcliente->execute();
        //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
        $affectedrowCliente = $sqlcliente->affected_rows;
    }else{
        $sqlcliente= $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente c SET c.IdGeografico=?,c.NombApellido=?,c.Telefonouno=?,c.Telefonodos=?,c.Correo=?,c.Direccion=? WHERE c.IdCliente=?");
        $sqlcliente->bind_param('isssssi',$distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,$idcliente);
        $sqlcliente->execute();
        //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
        $affectedrowCliente = $sqlcliente->affected_rows;
    }
    
    //ACTUALIZA DATOS EN LA TABLA PROSPECTORP
    $sqlprospecto=$con->prepare("UPDATE yifi58ge_dbVENTAS.tblprospectorp p SET p.IdUsuario=?,p.IdCliente=?,p.Matricula=?,p.Comercial=?,p.CC=?,p.JefeVenta=?,p.CategoriaVenta=?,p.TipoVenta=?,p.Segmento=?,p.PrecioKit=?,p.TotalExtra=?,p.EstadoProspecto=?,p.ExtraAutorizado=?,p.MesesAutorizado=?,p.FormaPago=?,p.PAI=?,p.ResumenProspecto=?,p.ComentarioProspectoRP=?,p.TipoKIT=?,p.ClosingPack=?,p.PrecioEspecial=?,p.CantidadExtras=?,p.ScoringRP=?,p.VisitaConcertada=?,p.FechaVisitaRP=?,p.HoraVisitaRP=?,p.CodigoOperacionScoring=?,p.GGCC=?,p.HojaCertificacion=?,p.FormaPagoCuota=? WHERE p.IdProspectoRP=?");  
    $sqlprospecto->bind_param('iisssssssddssdsssssssissssssssi',$idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$hidVisitaConcertada,$fechaVisitaConcertadaFinal,$horaVisitaConcertada,$valcodigoOperacionScoring,$hidGGCC,$hidden_HCertificacion,$lblformapagocuota,$idprospectorp);
    $sqlprospecto->execute();
    $affectedrowProspectoRP = $sqlprospecto->affected_rows;
    //INSERTA LOG DE SEGURIDA POR TRANSACCION (MODIFICAR)

    if($affectedrowCliente > 0 || $affectedrowProspectoRP > 0 ){
        $Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
        $Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
        $Url = sanitizaCampo($_SERVER['REQUEST_URI'], 'sanitizeurl|scapestring|htmlspecialchars',$con);
        
        if(!empty($Url)){
        	$UrlLog = $Url.'=>IdProspectoRP='.$idprospectorp;
        }
        $Modificar = 'Modificar';
        $Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                        
        try{
        	$result_exec= $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
        	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fecharegistro,$UrlLog,$Modificar,$Navegador);
        	$result_exec->execute();
        	$idLogSeg = $con->insert_id;
        	$result_exec->close();
        } 
        
        if($affectedrowCliente > 0){
            insertarLog($idLogSeg, $arrayCliente);
        }
        if($affectedrowProspectoRP > 0){
            insertLogProspectoRP($idLogSeg, $arrayProspectoRP);
        }
        echo 5;
    }else{
     echo 20; 
    }
}
else if($categoria=='Ficha'){

    $n590 = sanitizaCampo($_POST['lbl590'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $n590 = htmlspecialchars($n590);
    //---Cliente--
   
    $idcliente = sanitizaCampo($_POST['lblidcliente'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $idcliente = htmlspecialchars($idcliente);
    
    $nombcliente = sanitizaCampo($_POST['lblnombcliente'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $nombcliente = htmlspecialchars($nombcliente);
    
    $correo = sanitizaCampo($_POST['lblcorreo'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $correo = htmlspecialchars($correo);
    
    $direccion = sanitizaCampo($_POST['lbldireccion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $direccion = htmlspecialchars($direccion);
    
    $distrito = sanitizaCampo($_POST['lbldistrito'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $distrito = htmlspecialchars($distrito);
    
    $telefonouno = sanitizaCampo($_POST['lblmovil'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $telefonouno = htmlspecialchars($telefonouno);
    
    $telefonodos = sanitizaCampo($_POST['lblfijo'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $telefonodos = htmlspecialchars($distrito);
    //---Termina Cliente---
    
    //CREACION DEL ARRAY QUE TRAE DATOS DEL CLIENTE
    $arrayCliente = consultaCliente($idcliente);
    
    //VERIFICA QUE EXISTA EN EL SCORING TEMPORAL
    $resultadoScoring= $con->prepare("SELECT t.FechaHoraReg,t.Servicio,t.NumeroOperacion,t.CodigoModelo,t.TipoDocumento,t.NumeroDocumento,t.ApellidoPaterno,t.ApellidoMaterno,t.Nombres,t.RazonSocial,t.Explicacion,t.Accion,t.Score,t.Riesgo,t.Conclusion,t.ultPeriodo,t.TotalultPeriodo,t.DeudaSoles,t.DeudaDolares,t.TotalDeudaSoles,t.TotalDeudaDolares,t.CodigoOficina,t.GestorOrigen,t.NombreGestorOrigen,t.Integrante,t.TipoPersona,t.CantidadDocumentosMorosos,t.ScoreRiesgo_PN,t.PredictorIngresos_IP,t.ScoreRiesgo_PJ,t.MontoMorosoSoles,t.MontoMorosoDolares,t.PerfilScoring,t.CodGenVen,t.Departamental,t.Provincial,t.Distrital,t.Ubigeo,t.Area FROM yifi58ge_dbVENTAS.tbltmpscoringRP t WHERE t.NumeroOperacion= ?");
    $resultadoScoring->bind_param('s',$valcodigoOperacionScoring);
    $resultadoScoring->execute();
    $resultadoScoring->store_result();
    $resultadoScoring->bind_result(
        $FechaHoraRegRow,
        $ServicioRow,
        $NumeroOperacionRow,
        $CodigoModeloRow,
        $TipoDocumentoRow,
        $NumeroDocumentoRow,
        $ApellidoPaternoRow,
        $ApellidoMaternoRow,
        $NombresRow,
        $RazonSocialRow,
        $ExplicacionRow,
        $AccionRow,
        $ScoreRow,
        $RiesgoRow,
        $ConclusionRow,
        $ultPeriodoRow,
        $TotalultPeriodoRow,
        $DeudaSolesRow,
        $DeudaDolaresRow,
        $TotalDeudaSolesRow,
        $TotalDeudaDolaresRow,
        $CodigoOficinaRow,
        $GestorOrigenRow,
        $NombreGestorOrigenRow,
        $IntegranteRow,
        $TipoPersonaRow,
        $CantidadDocumentosMorososRow,
        $ScoreRiesgo_PNRow,
        $PredictorIngresos_IPRow,
        $ScoreRiesgo_PJRow,
        $MontoMorosoSolesRow,
        $MontoMorosoDolaresRow,
        $PerfilScoringRow,
        $CodGenVenRow,
        $DepartamentalRow,
        $ProvincialRow,
        $DistritalRow,
        $UbigeoRow,
        $AreaRow
        );
    $numrowsScoring=$resultadoScoring->num_rows;
    
    //VERIFICA QUE EXISTA EL ID PROSPECTO EN LA TABLA VENTA
    $resultado= $con->prepare("SELECT 1 FROM yifi58ge_dbVENTAS.tblventa v WHERE v.IdProspectoRP= ?");
    $resultado->bind_param('i',$idprospectorp);
    $resultado->execute();
    $numrows=$resultado->affected_rows;
    
    
    if($numrowsScoring>0){
        if($numrows>0){
          echo 2;
        }else{
            while ($resultadoScoring->fetch()) {
            $FechaHoraReg = $FechaHoraRegRow;
            $Servicio = $ServicioRow;
            $NumeroOperacion = $NumeroOperacionRow;
            $CodigoModelo = $CodigoModeloRow;
            $TipoDocumento = $TipoDocumentoRow;
            $NumeroDocumento = $NumeroDocumentoRow;
            $ApellidoPaterno = $ApellidoPaternoRow;
            $ApellidoMaterno = $ApellidoMaternoRow;
            $Nombres = $NombresRow;
            $RazonSocial = $RazonSocialRow;
            $Explicacion = $ExplicacionRow;
            $Accion = $AccionRow;
            $Score = $ScoreRow;
            $Riesgo = $RiesgoRow;
            $Conclusion = $ConclusionRow;
            $ultPeriodo = $ultPeriodoRow;
            $TotalultPeriodo = $TotalultPeriodoRow;
            $DeudaSoles = $DeudaSolesRow;
            $DeudaDolares = $DeudaDolaresRow;
            $TotalDeudaSoles = $TotalDeudaSolesRow;
            $TotalDeudaDolares = $TotalDeudaDolaresRow;
            $CodigoOficina = $CodigoOficinaRow;
            $GestorOrigen = $GestorOrigenRow;
            $NombreGestorOrigen = $NombreGestorOrigenRow;
            $Integrante = $IntegranteRow;
            $TipoPersona = $TipoPersonaRow;
            $CantidadDocumentosMorosos = $CantidadDocumentosMorososRow;
            $ScoreRiesgo_PN = $ScoreRiesgo_PNRow;
            $PredictorIngresos_IP = $PredictorIngresos_IPRow;
            $ScoreRiesgo_PJ = $ScoreRiesgo_PJRow;
            $MontoMorosoSoles = $MontoMorosoSolesRow;
            $MontoMorosoDolares = $MontoMorosoDolaresRow;
            $PerfilScoring = $PerfilScoringRow;
            $CodGenVen = $CodGenVenRow;
            $Departamental = $DepartamentalRow;
            $Provincial = $ProvincialRow;
            $Distrital = $DistritalRow;
            $Ubigeo = $UbigeoRow;
            $Area = $AreaRow;
        }
            
            $IdConsultaScoring=insertarScoring($FechaHoraReg,$Servicio,$NumeroOperacion,$CodigoModelo,$TipoDocumento,$NumeroDocumento,$ApellidoPaterno,$ApellidoMaterno,$Nombres,$RazonSocial,$Explicacion,$Accion,$Score,$Riesgo,$Conclusion,$ultPeriodo,$TotalultPeriodo,$DeudaSoles,$DeudaDolares,$TotalDeudaSoles,$TotalDeudaDolares,$CodigoOficina,$GestorOrigen,$NombreGestorOrigen,$Integrante,$TipoPersona,$CantidadDocumentosMorosos,$ScoreRiesgo_PN,$PredictorIngresos_IP,$ScoreRiesgo_PJ,$MontoMorosoSoles,$MontoMorosoDolares,$PerfilScoring,$CodGenVen,$Departamental,$Provincial,$Distrital,$Ubigeo,$Area);
            $IdDocRP=insertarDocumento($TipoDocumento,$NumeroDocumento,$fecharegistro);
            
             
            //ACTUALIZA DATOS DEL CLIENTE RP
            if($telefonodos=="" || empty($telefonodos)){
                
                $sqlcliente= $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente c SET c.IdGeografico=?,c.NombApellido=?,c.Telefonouno=?,c.Correo=?,c.Direccion=?,c.IdDocRP=? WHERE c.IdCliente=?");
                $sqlcliente->bind_param('issssii',$distrito,$nombcliente,$telefonouno,$correo,$direccion,$IdDocRP,$idcliente);
                $sqlcliente->execute();
                //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
                $affectedrowCliente = $sqlcliente->affected_rows;
                
            }
            else{
                
                $sqlcliente= $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente c SET c.IdGeografico=?,c.NombApellido=?,c.Telefonouno=?,c.Telefonodos=?,c.Correo=?,c.Direccion=?,c.IdDocRP=? WHERE c.IdCliente=?");
                $sqlcliente->bind_param('issssssii',$distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,$IdDocRP,$idcliente);
                $sqlcliente->execute();
                //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
                $affectedrowCliente = $sqlcliente->affected_rows;
                
            }  
            
             //ACTUALIZA DATOS DEL PROSPECTORP EN LA TABLA PROSPECTORP
            $sqlprospecto=$con->prepare("UPDATE yifi58ge_dbVENTAS.tblprospectorp p SET p.IdUsuario=?,p.IdCliente=?,p.Matricula=?,p.Comercial=?,p.CC=?,p.JefeVenta=?,p.CategoriaVenta=?,p.TipoVenta=?,p.Segmento=?,p.PrecioKit=?,p.TotalExtra=?,p.EstadoProspecto=?,p.EstadoVenta=?,p.ExtraAutorizado=?,p.MesesAutorizado=?,p.N590=?,p.FormaPago=?,p.PAI=?,p.ResumenProspecto=?,p.ComentarioProspectoRP=?,p.TipoKIT=?,p.ClosingPack=?,p.PrecioEspecial=?,p.CantidadExtras=?,p.ScoringRP=?,p.CodigoOperacionScoring=?,p.GGCC=?,p.HojaCertificacion=?,p.IdConsultaScoring=?,p.FormaPagoCuota=?,p.VisitaConcertada=?,p.FechaVisitaRP=?,p.HoraVisitaRP=? WHERE p.IdProspectoRP=?"); 
            $sqlprospecto->bind_param('iisssssssddsssdssssssssissssissssi',$idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$valcodigoOperacionScoring,$hidGGCC,$hidden_HCertificacion,$IdConsultaScoring,$lblformapagocuota,$hidVisitaConcertada,$fechaVisitaConcertadaFinal,$horaVisitaConcertada, $idprospectorp); 
            $sqlprospecto->execute(); 
            $affectedrowProspectoRP = $sqlprospecto->affected_rows;
            
            
            $arrayVenta = consultaVentaIProspecto();
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA VENTAS
            
            $sqlventa=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblventa(IdUsuario,IdCliente,Matricula,Comercial,CC,JefeVenta,CategoriaVenta,TipoVenta,Segmento,PrecioKit,TotalExtra,IngresoKIT,IngresoExtras,IngresoTotal,EstadoVenta,ExtraAutorizado,MesesAutorizado,N590,FormaPago,PAI,ResumenVenta,FechaHoraREG,GestorOrigen,CCOriginal,PrecioKITOriginal,TotalExtraOriginal,ExtraAutorizadoOriginal,MesesAutorizadoOriginal,FormaPagoOriginal,PAIOriginal,ResumenVentaOriginal,IdProspectoRP, TipoKIT, CantidadExtras, TipoKITOriginal, ClosingPack, PrecioEspecial, CantidadExtrasOriginal, ScoringRP,GGCC,HojaCertificacion,Accion,PerfilScoring,IdConsultaScoring,FormaPagoCuota,IdConsultaScoringRP) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?)");
            $sqlventa->bind_param('iisssssssdddddssdsssssssddsdsssisisssisssssisi',$idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$ingresokit,$ingresoextras,$ingresototal,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$fecharegistro,$gestor,$dc,$preciokit,$totalextra,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$idprospectorp, $lbltipokit, $lblCantExtras, $lbltipokit, $lblclosingpack, $lblprecioEspecial, $lblCantExtras, $lblresultadoScoring,$hidGGCC,$hidden_HCertificacion,$Accion,$PerfilScoring,$IdConsultaScoring,$lblformapagocuota,$IdConsultaScoring);
            $sqlventa->execute();
            $idVen = $con->insert_id;
            
            $arrayAgenda=consultaAgendaI();
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA AGENDA
            $sqlagenda=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagenda(IdVenta,FechaHoraREG, GestionOrigen) VALUES (?,?,?) ");
            $sqlagenda->bind_param('iss',$idVen,$fecharegistro,$GestionOrigen);
            $sqlagenda->execute();
            
            
            $arrayFactu=consultaFacturacionI();
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA FACTURACION
            $sqlfacturacion=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblfacturacion(IdVenta, FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
            $sqlfacturacion->bind_param('iss',$idVen,$fecharegistro,$GestionOrigen);
            $sqlfacturacion->execute();
            //ACTUALIZAR IDVENTA EN SCORING
            $sqlidscoring= $con->prepare("UPDATE yifi58ge_dbVENTAS.tbltmpscoring t SET t.IdVenta=? WHERE t.IdConsultaScoring=?");
            $sqlidscoring->bind_param('ii',$idVen,$IdConsultaScoring);
            $sqlidscoring->execute();
            
            if($affectedrowCliente > 0 || $affectedrowProspectoRP > 0 ){
            //GENERA LOG DE PROSPECTO HISTORICO
            $sqlprospechist=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,Gestor) values(?,?,?,?,?,?)");
            $sqlprospechist->bind_param('isssss',$idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$gestor);
            $sqlprospechist->execute();
            
            //GENERA LOG DE SEGURIDAD
            $Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
            $Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
            $Url = sanitizaCampo($_SERVER['REQUEST_URI'], 'sanitizeurl|scapestring|htmlspecialchars',$con);
            if(!empty($Url)){
            	$UrlLog = $Url.'=>IdVenta='.$idventa;
            }
            $Modificar = 'Registrar';
            $Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                            
            try{
            	$result_exec= $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
            	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fecharegistro,$UrlLog,$Modificar,$Navegador);
            	$result_exec->execute();
            	$idLogSeg = $con->insert_id;
            	$result_exec->close();
            }
           
            //ENVIA RESULTADO    
            echo 6;
        
            if($affectedrowCliente > 0){
                insertarLog($idLogSeg, $arrayCliente);
            }
            if($affectedrowProspectoRP > 0){
                insertLogProspectoRP($idLogSeg, $arrayProspectoRP);
            }
            
            insertLogVentaIProspecto($idLogSeg, $arrayVenta);
    
            insertLogAgendaI($idLogSeg, $arrayAgenda);
            insertLogFacutracionI($idLogSeg, $arrayFactu);
            
            }
    
        }
    
    }else{
        echo 4;
    }
    
    //CIERRA CONSULTA
    $resultadoScoring->close();
    $resultado->close();
}
else if($categoria=='Delegacion'){
    $n590 = sanitizaCampo($_POST['lbl590'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $n590 = htmlspecialchars($n590);
    //---Cliente--
   
    $idcliente = sanitizaCampo($_POST['lblidcliente'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $idcliente = htmlspecialchars($idcliente);
    
    $nombcliente = sanitizaCampo($_POST['lblnombcliente'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $nombcliente = htmlspecialchars($nombcliente);
    
    $correo = sanitizaCampo($_POST['lblcorreo'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $correo = htmlspecialchars($correo);
    
    $direccion = sanitizaCampo($_POST['lbldireccion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $direccion = htmlspecialchars($direccion);
    
    $distrito = sanitizaCampo($_POST['lbldistrito'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $distrito = htmlspecialchars($distrito);
    
    $telefonouno = sanitizaCampo($_POST['lblmovil'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $telefonouno = htmlspecialchars($telefonouno);
    
    $telefonodos = sanitizaCampo($_POST['lblfijo'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $telefonodos = htmlspecialchars($distrito);
    //---Termina Cliente---    
    
    //---Agenda--
    
    $instaladox = sanitizaCampo($_POST['lblinstaladox'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $instaladox = htmlspecialchars($instaladox);
    
    $tecnico = sanitizaCampo($_POST['lbltecnico'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $tecnico = htmlspecialchars($tecnico);
    
    $finstalacion = sanitizaCampo($_POST['lblfinstalacion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $finstalacion = htmlspecialchars($finstalacion);
    
    $hinstalacion = sanitizaCampo($_POST['lblhinstalacion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $hinstalacion = htmlspecialchars($finstalacion);
    
    $fechaconvert=  myUrlEncode($finstalacion);
    $fechagrabar=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvert));
    $horaconvert=  myUrlEncode($hinstalacion);
    $horagrabar=  date("H:i", strtotime(str_replace("+"," ",$horaconvert)));
    $horagrabarcomparar=  date("H:i:s", strtotime(str_replace("+"," ",$horaconvert)));
   
    $comentarioagenda = sanitizaCampo($_POST['lblcomentarioagenda'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $comentarioagenda = htmlspecialchars($comentarioagenda);
    //---Termina Agenda---
    
    //NUEVO

    $ncontrato = sanitizaCampo($_POST['lblncontrato'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $ncontrato = htmlspecialchars($ncontrato);
    
    
    if($estadoventa=="InstaladaDEL" && isset($ncontrato)){
       if(validarNContrato($ncontrato) > 0){
            die('9');
        }
    }
    //

    //CREACION DEL ARRAY QUE TRAE DATOS DEL CLIENTE
    $arrayCliente = consultaCliente($idcliente);
    
    //VERIFICA QUE EXISTA EN EL SCORING TEMPORAL
    $resultadoScoring= $con->prepare("SELECT t.FechaHoraReg,t.Servicio,t.NumeroOperacion,t.CodigoModelo,t.TipoDocumento,t.NumeroDocumento,t.ApellidoPaterno,t.ApellidoMaterno,t.Nombres,t.RazonSocial,t.Explicacion,t.Accion,t.Score,t.Riesgo,t.Conclusion,t.ultPeriodo,t.TotalultPeriodo,t.DeudaSoles,t.DeudaDolares,t.TotalDeudaSoles,t.TotalDeudaDolares,t.CodigoOficina,t.GestorOrigen,t.NombreGestorOrigen,t.Integrante,t.TipoPersona,t.CantidadDocumentosMorosos,t.ScoreRiesgo_PN,t.PredictorIngresos_IP,t.ScoreRiesgo_PJ,t.MontoMorosoSoles,t.MontoMorosoDolares,t.PerfilScoring,t.CodGenVen,t.Departamental,t.Provincial,t.Distrital,t.Ubigeo,t.Area FROM yifi58ge_dbVENTAS.tbltmpscoringRP t WHERE t.NumeroOperacion= ?");
    $resultadoScoring->bind_result('s',$valcodigoOperacionScoring);
    $resultadoScoring->execute();
    $resultadoScoring->store_result();
    $resultadoScoring->bind_result(
        $FechaHoraRegRow,
        $ServicioRow,
        $NumeroOperacionRow,
        $CodigoModeloRow,
        $TipoDocumentoRow,
        $NumeroDocumentoRow,
        $ApellidoPaternoRow,
        $ApellidoMaternoRow,
        $NombresRow,
        $RazonSocialRow,
        $ExplicacionRow,
        $AccionRow,
        $ScoreRow,
        $RiesgoRow,
        $ConclusionRow,
        $ultPeriodoRow,
        $TotalultPeriodoRow,
        $DeudaSolesRow,
        $DeudaDolaresRow,
        $TotalDeudaSolesRow,
        $TotalDeudaDolaresRow,
        $CodigoOficinaRow,
        $GestorOrigenRow,
        $NombreGestorOrigenRow,
        $IntegranteRow,
        $TipoPersonaRow,
        $CantidadDocumentosMorososRow,
        $ScoreRiesgo_PNRow,
        $PredictorIngresos_IPRow,
        $ScoreRiesgo_PJRow,
        $MontoMorosoSolesRow,
        $MontoMorosoDolaresRow,
        $PerfilScoringRow,
        $CodGenVenRow,
        $DepartamentalRow,
        $ProvincialRow,
        $DistritalRow,
        $UbigeoRow,
        $AreaRow
        );
    $numrowsScoring=$resultadoScoring->num_rows;
    
    //VERIFICA QUE EXISTA EL ID PROSPECTO EN LA TABLA VENTA
    $resultado= $con->prepare("SELECT 1 FROM yifi58ge_dbVENTAS.tblventa v WHERE v.IdProspectoRP= ?");
    $resultado->bind_result('i',$idprospectorp);
    $resultado->execute();
    
    $numrows=$resultado->num_rows;

if($numrowsScoring>0){
    if($numrows>0){
      echo 2;
    }else{
        while ($resultadoScoring->fetch()) {
            $FechaHoraReg=$FechaHoraRegRow;
            $Servicio=$ServicioRow;
            $NumeroOperacion=$NumeroOperacionRow;
            $CodigoModelo=$CodigoModeloRow;
            $TipoDocumento=$TipoDocumentoRow;
            $NumeroDocumento=$NumeroDocumentoRow;
            $ApellidoPaterno=$ApellidoPaternoRow;
            $ApellidoMaterno=$ApellidoMaternoRow;
            $Nombres=$NombresRow;
            $RazonSocial=$RazonSocialRow;
            $Explicacion=$ExplicacionRow;
            $Accion=$AccionRow;
            $Score=$ScoreRow;
            $Riesgo=$RiesgoRow;
            $Conclusion=$ConclusionRow;
            $ultPeriodo=$ultPeriodoRow;
            $TotalultPeriodo=$TotalultPeriodoRow;
            $DeudaSoles=$DeudaSolesRow;
            $DeudaDolares=$DeudaDolaresRow;
            $TotalDeudaSoles=$TotalDeudaSolesRow;
            $TotalDeudaDolares=$TotalDeudaDolaresRow;
            $CodigoOficina=$CodigoOficinaRow;
            $GestorOrigen=$GestorOrigenRow;
            $NombreGestorOrigen=$NombreGestorOrigenRow;
            $Integrante=$IntegranteRow;
            $TipoPersona=$TipoPersonaRow;
            $CantidadDocumentosMorosos=$CantidadDocumentosMorososRow;
            $ScoreRiesgo_PN=$ScoreRiesgo_PNRow;
            $PredictorIngresos_IP=$PredictorIngresos_IPRow;
            $ScoreRiesgo_PJ=$ScoreRiesgo_PJRow;
            $MontoMorosoSoles=$MontoMorosoSolesRow;
            $MontoMorosoDolares=$MontoMorosoDolaresRow;
            $PerfilScoring=$PerfilScoringRow;
            $CodGenVen=$CodGenVenRow;
            $Departamental=$DepartamentalRow;
            $Provincial=$ProvincialRow;
            $Distrital=$DistritalRow;
            $Ubigeo=$UbigeoRow;
            $Area=$AreaRo;

        }
            
            $IdConsultaScoring=insertarScoring($FechaHoraReg,$Servicio,$NumeroOperacion,$CodigoModelo,$TipoDocumento,$NumeroDocumento,$ApellidoPaterno,$ApellidoMaterno,$Nombres,$RazonSocial,$Explicacion,$Accion,$Score,$Riesgo,$Conclusion,$ultPeriodo,$TotalultPeriodo,$DeudaSoles,$DeudaDolares,$TotalDeudaSoles,$TotalDeudaDolares,$CodigoOficina,$GestorOrigen,$NombreGestorOrigen,$Integrante,$TipoPersona,$CantidadDocumentosMorosos,$ScoreRiesgo_PN,$PredictorIngresos_IP,$ScoreRiesgo_PJ,$MontoMorosoSoles,$MontoMorosoDolares,$PerfilScoring,$CodGenVen,$Departamental,$Provincial,$Distrital,$Ubigeo,$Area);
            $IdDocRP=insertarDocumento($TipoDocumento,$NumeroDocumento,$fecharegistro);
           
        //ACTUALIZA DATOS DEL PROSPECTORP EN LA TABLA PROSPECTORP
        $sqlprospecto=$con->prepare("UPDATE yifi58ge_dbVENTAS.tblprospectorp p SET p.IdUsuario=?,p.IdCliente=?,p.Matricula=?,p.Comercial=?,p.CC=?,p.JefeVenta=?,p.CategoriaVenta=?,p.TipoVenta=?,p.Segmento=?,p.PrecioKit=?,p.TotalExtra=?,p.EstadoProspecto=?,p.EstadoVenta=?,p.ExtraAutorizado=?,p.MesesAutorizado=?,p.N590=?,p.FormaPago=?,p.PAI=?,p.ResumenProspecto=?,p.ComentarioProspectoRP=?,p.TipoKIT=?,p.ClosingPack=?,p.PrecioEspecial=?,p.CantidadExtras=?,p.ScoringRP=?,p.CodigoOperacionScoring=?,p.GGCC=?,p.HojaCertificacion=?,p.IdConsultaScoring=?,p.FormaPagoCuota=?,p.VisitaConcertada=?,p.FechaVisitaRP=?,p.HoraVisitaRP=? WHERE p.IdProspectoRP=?"); 
        $sqlprospecto->bind_param('iisssssssddsssdssssssssissssissssi',$idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$valcodigoOperacionScoring,$hidGGCC,$hidden_HCertificacion,$IdConsultaScoring,$lblformapagocuota,$hidVisitaConcertada,$fechaVisitaConcertadaFinal,$horaVisitaConcertada, $idprospectorp); 
        $sqlprospecto->execute(); 
        $affectedrowProspectoRP = $sqlprospecto->affected_rows;
        
        //ACTUALIZA DATOS DEL CLIENTE
        if($telefonodos=="" || empty($telefonodos)){
            
            $sqlcliente= $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente c SET c.IdGeografico=?,c.NombApellido=?,c.Telefonouno=?,c.Correo=?,c.Direccion=?,c.IdDocRP=?,c.NCliente=? WHERE c.IdCliente=?");
            $sqlcliente->bind_param('issssisi',$distrito,$nombcliente,$telefonouno,$correo,$direccion,$IdDocRP,$ncontrato,$idcliente);
            //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
            $affectedrowCliente = $sqlcliente->affected_rows;
            
        }
        else{

            $sqlcliente= $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente c SET c.IdGeografico=?,c.NombApellido=?,c.Telefonouno=?,c.Telefonodos=?,c.Correo=?,c.Direccion=?,c.IdDocRP=?,c.NCliente=? WHERE c.IdCliente=?");
            $sqlcliente->bind_param('isssssisi',$distrito,$nombcliente,$telefonouno,$correo,$direccion,$IdDocRP,$ncontrato,$idcliente);
            //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
            $affectedrowCliente = $sqlcliente->affected_rows;
            
        }


        
        //INSERTA DATOS DEL PROSPECTORP EN LA TABLA VENTAS
        $arrayVenta = consultaVentaIProspecto();
        
        $sqlventa=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblventa(IdUsuario,IdCliente,Matricula,Comercial,CC,JefeVenta,CategoriaVenta,TipoVenta,Segmento,PrecioKit,TotalExtra,IngresoKIT,IngresoExtras,IngresoTotal,EstadoVenta,ExtraAutorizado,MesesAutorizado,N590,FormaPago,PAI,ResumenVenta,FechaHoraREG,GestorOrigen,CCOriginal,PrecioKITOriginal,TotalExtraOriginal,ExtraAutorizadoOriginal,MesesAutorizadoOriginal,FormaPagoOriginal,PAIOriginal,ResumenVentaOriginal,IdProspectoRP, TipoKIT, CantidadExtras, TipoKITOriginal, ClosingPack, PrecioEspecial, CantidadExtrasOriginal, ScoringRP,GGCC,HojaCertificacion,Accion,PerfilScoring,IdConsultaScoring,FormaPagoCuota,IdConsultaScoringRP,NContrato) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $sqlventa->bind_param('iisssssssdddddssdsssssssddsdsssisisssisssssisis',$idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$ingresokit,$ingresoextras,$ingresototal,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$fecharegistro,$gestor,$dc,$preciokit,$totalextra,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$idprospectorp, $lbltipokit, $lblCantExtras, $lbltipokit, $lblclosingpack, $lblprecioEspecial, $lblCantExtras, $lblresultadoScoring,$hidGGCC,$hidden_HCertificacion,$Accion,$PerfilScoring,$IdConsultaScoring,$lblformapagocuota,$IdConsultaScoring,$ncontrato);
        $sqlventa->execute();
        $idVen = $con->insert_id;
        
        //INSERTA DATOS EN LA TABLA AGENDA (NUEVO REGISTRO)
        if(empty($finstalacion) && empty($hinstalacion) ){
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA AGENDA
            $arrayAgenda=consultaAgendaProspectoRP();
            $sqlagenda=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagenda(IdVenta, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta,GestionOrigen) VALUES (?,?,?,?,?,?,?,?)"); 
            $sqlagenda->bind_param('isssssss',$idVen,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa, $GestionOrigen);
            $sqlagenda->execute();
            $idagendahis=$con->insert_id;
            $sqlagendahist=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagendahist(IdAgenda, IdVenta, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES (?,?,?,?,?,?,?,?)");
            $sqlagendahist->bind_param('iissssss',$idagendahis,$idVen,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa);
            $sqlagendahist->execute();
            
        }else if(empty($finstalacion)){
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA AGENDA
            $arrayAgenda=consultaAgendaProspectoRP();
            $sqlagenda= $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagenda(IdVenta,FechaInst, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta,GestionOrigen) VALUES (?,?,?,?,?,?,?,?,?)");   
            $sqlagenda->bind_param('issssssss',$idVen,$fechagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa, $GestionOrigen);
            $sqlagenda->execute();
            $idagendahis=$con->insert_id;
            $sqlagendahist=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagendahist(IdAgenda, IdVenta,FechaInst, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES (?,?,?,?,?,?,?,?,?)");
            $sqlagendahist->bind_param('iisssssss',$idagendahis,$idVen,$fechagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa);  
            $sqlagendahist->execute();
            
        }else if(empty($hinstalacion)){
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA AGENDA
            $arrayAgenda=consultaAgendaProspectoRP();
            $sqlagenda= $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagenda(IdVenta,HoraInst, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta,GestionOrigen) VALUES (?,?,?,?,?,?,?,?,?)");   
            $sqlagenda->bind_param('issssssss',$idVen,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa, $GestionOrigen);
            $sqlagenda->execute();
            $idagendahis=$con->insert_id;
            $sqlagendahist=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagendahist(IdAgenda, IdVenta,HoraInst, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES (?,?,?,?,?,?,?,?,?)");
            $sqlagendahist->bind_param('iisssssss',$idagendahis,$idVen,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa);
            $sqlagendahist->execute();
            
        }else{
            //INSERTA DATOS DEL PROSPECTORP EN LA TABLA AGENDA
            $arrayAgenda=consultaAgendaProspectoRP();
            $sqlagenda= $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagenda(IdVenta,FechaInst,HoraInst, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta,GestionOrigen) VALUES (?,?,?,?,?,?,?,?,?,?)");   
            $sqlagenda->bind_param('isssssssss',$idVen,$fechagrabar,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa,$GestionOrigen);
            $sqlagenda->execute();
            $idagendahis=$con->insert_id;
            $sqlagendahist=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagendahist(IdAgenda, IdVenta,FechaInst,HoraInst, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES (?,?,?,?,?,?,?,?,?,?)");
            $sqlagendahist->bind_param('iissssssss',$idagendahis,$idVen,$fechagrabar,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistro,$gestor,$estadoventa);
            $sqlagendahist->execute();
        }
        
        //INSERTA DATOS DEL PROSECTORP EN LA TABLA FACTURACION
        $arrayFactu=consultaFacturacionI();
        $sqlfacturacion=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblfacturacion(IdVenta, FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
        $sqlfacturacion->bind_param('iss',$idVen,$fecharegistro,$GestionOrigen);
        $sqlfacturacion->execute();
        
        //ACTUALIZAR IDVENTA EN SCORING

        try{
            $sqlidscoring = $con->prepare("UPDATE yifi58ge_dbVENTAS.tbltmpscoring t SET t.IdVenta=? WHERE t.IdConsultaScoring=?");
            $sqlidscoring->bind_param('ii',$idVen,$IdConsultaScoring);
            $sqlidscoring->execute();
            $sqlidscoring->close();
        } catch (\Exception $e) {
            $error = 'error';
        }
        
        //GENERA LOG DE HISTORICO DE PROSPECTORP

        try{
            $sqlprospechist = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,Gestor) values(?,?,?,?,?,?)");
            $sqlprospechist->bind_param('isssss',$idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$gestor);
            $sqlprospechist->execute();
            $sqlprospechist->close();
        } catch (\Exception $e) {
            $error = 'error';
        }
        
        //GENERA LOG DE SEGURIDAD
            $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
            $usuariosesion=$_SESSION['usuariosesion'];
            $REQUEST_URI=$_SERVER['REQUEST_URI'].'=>IdProspectoRP='.$idprospectorp;
            $Acceso='Modificar';
            $HTTP_USER_AGENT=$_SERVER['HTTP_USER_AGENT'];
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              
              $idLogSeg = $con->insert_id;
              
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            }
        //ENVIA RESPUESTA
        echo 7;
    
    if($affectedrowProspectoRP > 0){
        insertLogProspectoRP($idLogSeg, $arrayProspectoRP);
    }    
    if($affectedrowCliente > 0){
        insertarLog($idLogSeg, $arrayCliente);
    }
    
        insertLogVentaIProspecto($idLogSeg, $arrayVenta);
        insertLogAgendaProspectoRP($idLogSeg, $arrayAgenda);
        insertLogFacutracionI($idLogSeg, $arrayFactu);
    }
    
}else{
    echo 4;
}



    //CIERRA CONSULTA
    $resultadoScoring->close();
    $resultado->close();
}
else if($categoria=='NoVendida'){
    
    //---Cliente--
    $idcliente=$_POST['lblidcliente'];
    $nombcliente=$_POST['lblnombcliente'];
    $correo=$_POST['lblcorreo'];
    $direccion=$_POST['lbldireccion'];
    $distrito=$_POST['lbldistrito'];
    $telefonouno=$_POST['lblmovil'];
    $telefonodos=$_POST['lblfijo'];
    //---Termina Cliente---
    
    //CREACION DEL ARRAY QUE TRAE DATOS DEL CLIENTE
    $arrayCliente = consultaCliente($idcliente);
    
    //ACTUALIZA DATOS DEL PROSPECTORP EN LA TABLA CLIENTE
    if($telefonodos=="" || empty($telefonodos)){
        
        //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
        $affectedrowCliente=registrarCliente($distrito,$nombcliente,$telefonouno,NULL,$correo,$direccion,NULL,$segmento,$idcliente,NULL);
        
    }else{
        
        //VALIDA QUE HUBO UNA ACTUALIZACION EN LA TABLA CLIENTES
        $affectedrowCliente=registrarCliente($distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,NULL,$segmento,$idcliente,NULL);
        
    }
    
    //ACTUALIZA DATOS DEL PROSPECTORP EN LA TABLA PROSPECTORP
    $affectedrowProspectoRP=updateProspectoRP($idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,NULL,$extraautorizado,$mesesautorizados,NULL,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$valcodigoOperacionScoring,$hidGGCC,$hidden_HCertificacion,NULL,$lblformapagocuota,NULL,NULL,NULL,$idprospectorp);    
    
    
    //GENERA LOG DE SEGURIDAD
    if($affectedrowCliente > 0 || $affectedrowProspectoRP > 0 ){
    //GENERA HISTORICO DEL PROSPECTORP
           try{
                $stmtProshist = $con->prepare( "INSERT INTO yifi58ge_dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,Gestor) values(?,?,?,?,?,?)");
                $stmtProshist->bind_param('isssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$gestor);
                $stmtProshist->execute();
                $stmtProshist->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }
    

            $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
            $usuariosesion=$_SESSION['usuariosesion'];
            $REQUEST_URI=$_SERVER['REQUEST_URI'].'=>IdVenta='.$idVen;
            $Acceso='Modificar';
            $HTTP_USER_AGENT=$_SERVER['HTTP_USER_AGENT'];
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              
              $idLogSeg = $con->insert_id;
              
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            }  
    
    if($affectedrowCliente > 0){
    insertarLog($idLogSeg, $arrayCliente);
    }
    if($affectedrowProspectoRP > 0){
        insertLogProspectoRP($idLogSeg, $arrayProspectoRP);
    }
    
     echo 5;
    }else{
     echo 20; 
    }
}

function insertarScoring($FechaHoraReg,$Servicio,$NumeroOperacion,$CodigoModelo,$TipoDocumento,$NumeroDocumento,$ApellidoPaterno,$ApellidoMaterno,$Nombres,$RazonSocial,$Explicacion,$Accion,$Score,$Riesgo,$Conclusion,$ultPeriodo,$TotalultPeriodo,$DeudaSoles,$DeudaDolares,$TotalDeudaSoles,$TotalDeudaDolares,$CodigoOficina,$GestorOrigen,$NombreGestorOrigen,$Integrante,$TipoPersona,$CantidadDocumentosMorosos,$ScoreRiesgo_PN,$PredictorIngresos_IP,$ScoreRiesgo_PJ,$MontoMorosoSoles,$MontoMorosoDolares,$PerfilScoring,$CodGenVen,$Departamental,$Provincial,$Distrital,$Ubigeo,$Area){
    global $con;
        try {
    
          $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tbltmpscoring(FechaHoraReg,Servicio,NumeroOperacion,CodigoModelo,TipoDocumento,NumeroDocumento,ApellidoPaterno,ApellidoMaterno,Nombres,RazonSocial,Explicacion,Accion,Score,Riesgo,Conclusion,ultPeriodo,TotalultPeriodo,DeudaSoles,DeudaDolares,TotalDeudaSoles,TotalDeudaDolares,CodigoOficina,GestorOrigen,NombreGestorOrigen,Integrante,TipoPersona,CantidadDocumentosMorosos,ScoreRiesgo_PN,PredictorIngresos_IP,ScoreRiesgo_PJ,MontoMorosoSoles,MontoMorosoDolares,PerfilScoring,CodGenVen,Departamental,Provincial,Distrital,Ubigeo,Area) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
          $stmt->bind_param('ssssisssssssisssdssddsssisiididdsssssss', $FechaHoraReg,$Servicio,$NumeroOperacion,$CodigoModelo,$TipoDocumento,$NumeroDocumento,$ApellidoPaterno,$ApellidoMaterno,$Nombres,$RazonSocial,$Explicacion,$Accion,$Score,$Riesgo,$Conclusion,$ultPeriodo,$TotalultPeriodo,$DeudaSoles,$DeudaDolares,$TotalDeudaSoles,$TotalDeudaDolares,$CodigoOficina,$GestorOrigen,$NombreGestorOrigen,$Integrante,$TipoPersona,$CantidadDocumentosMorosos,$ScoreRiesgo_PN,$PredictorIngresos_IP,$ScoreRiesgo_PJ,$MontoMorosoSoles,$MontoMorosoDolares,$PerfilScoring,$CodGenVen,$Departamental,$Provincial,$Distrital,$Ubigeo,$Area);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
        return $respuesta;
}

function insertarDocumento($tipodoc,$documento,$fecharegistro){
    global $con;
    $tipodocnuevo="";
    if($tipodoc==1){
        $tipodocnuevo="DNI";
    }else if($tipodoc==6){
       $tipodocnuevo="RUC"; 
    }else{
       $tipodocnuevo="CE"; 
    }
        try {
    
          $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES(?, ?, ?)");
          $stmt->bind_param('sss', $tipodocnuevo,$documento,$fecharegistro);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
    
        return $respuesta;
    

}

function validarNContrato($val){
    global $con;
    
    $sql = "SELECT * FROM tblcliente WHERE NCliente =".$val;
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    return $row_cnt;
    
}

function registrarCliente($distrito,$nombcliente,$telefonouno,$telefonodos=NULL,$correo,$direccion,$IdDocRP=NULL,$segmento,$idcliente,$ncontrato=NULL){
global $con;
  try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente c SET c.IdGeografico=?,c.NombApellido=?,c.Telefonouno=?,c.Telefonodos=?,c.Correo=?,c.Direccion=?,c.IdDocRP=?,c.Segmento=?,c.NCliente=? WHERE c.IdCliente=?");
        $stmt->bind_param('isssssissi', $distrito,$nombcliente,$telefonouno,$telefonodos,$correo,$direccion,$IdDocRP,$segmento,$ncontrato,$idcliente);
        
        $stmt->execute();

        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 0;
    }
    return $respuesta;

}

function updateProspectoRP($idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,$estadoventa=NULL,$extraautorizado,$mesesautorizados,$n590=NULL,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$valcodigoOperacionScoring,$hidGGCC,$hidden_HCertificacion,$IdConsultaScoring=NULL,$lblformapagocuota,$hidVisitaConcertada=NULL,$fechaVisitaConcertadaFinal=NULL,$horaVisitaConcertada=NULL,$idprospectorp){
global $con;
  try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblprospectorp p SET p.IdUsuario=?,p.IdCliente=?,p.Matricula=?,p.Comercial=?,p.CC=?,p.JefeVenta=?,p.CategoriaVenta=?,p.TipoVenta=?,p.Segmento=?,p.PrecioKit=?,p.TotalExtra=?,p.EstadoProspecto=?,p.EstadoVenta=?,p.ExtraAutorizado=?,p.MesesAutorizado=?,p.N590=?,p.FormaPago=?,p.PAI=?,p.ResumenProspecto=?,p.ComentarioProspectoRP=?,p.TipoKIT=?,p.ClosingPack=?,p.PrecioEspecial=?,p.CantidadExtras=?,p.ScoringRP=?,p.CodigoOperacionScoring=?,p.GGCC=?,p.HojaCertificacion=?,p.IdConsultaScoring=?,p.FormaPagoCuota=?,p.VisitaConcertada=?,p.FechaVisitaRP=?,p.HoraVisitaRP=? WHERE p.IdProspectoRP=?");
        $stmt->bind_param('iississssddsssdssssssssissssissssi', $idusuario,$idcliente,$matricula,$nombcomercial,$dc,$jefeventa,$categoria,$tipoventa,$segmento,$preciokit,$totalextra,$estadoprospecto,$estadoventa,$extraautorizado,$mesesautorizados,$n590,$formadepago,$PAI,$resumenventa,$comentarioprospecto,$lbltipokit,$lblclosingpack,$lblprecioEspecial,$lblCantExtras,$lblresultadoScoring,$valcodigoOperacionScoring,$hidGGCC,$hidden_HCertificacion,$IdConsultaScoring,$lblformapagocuota,$hidVisitaConcertada,$fechaVisitaConcertadaFinal,$horaVisitaConcertada,$idprospectorp);
        
        $stmt->execute();

        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 0;
    }
    return $respuesta;

}



