<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

$ingresokit=0;
$ingresoextras=0;
$ingresototal=0;

$fechavisitaasig=NULL;

require '../config/db.php';
require '../config/conexion.php';

//AGREGAR FUNCIONES LOG
include 'log/insertLog.php';
include 'log/insertLogCliente.php';
include 'log/insertLogCallRP.php';

$categoria=htmlspecialchars($_POST['lblcategoria']);

$idprospectorp=htmlspecialchars($_POST['lblidprospectorp']);
$gestorcall=htmlspecialchars($_POST['gestor']);
$estadoprospecto=htmlspecialchars($_POST['lblestadoprospecto']);
$tipoventa=htmlspecialchars($_POST['lbltiventa']);

//---Fechas_de_registros--
$comentariocallrp=htmlspecialchars($_POST['lblcomentariocallrp']);

$fecharegistro = date("Y-m-d H:i:s");
$segmento=htmlspecialchars($_POST['lblsegmento']);
if(isset($_POST['lblfechagestion'])){
    $fechagestion=htmlspecialchars($_POST['lblfechagestion']);
} else {
    $fechagestion='';
}
$fUltimaGestion = date("Y-m-d H:i:s");

//---Cliente--
$idcliente=htmlspecialchars($_POST['lblidcliente']);
$nombcliente=htmlspecialchars($_POST['lblnombcliente']);
$correo=htmlspecialchars($_POST['lblcorreo']);
$direccion=htmlspecialchars($_POST['lbldireccion']);
$distrito=htmlspecialchars($_POST['lbldistrito']);
if (isset($_POST['lblmovil'])){
    $telefonouno=$_POST['lblmovil'];
}
$telefonodos=htmlspecialchars($_POST['lblfijo']);

if(isset($_POST['hidden_checki'])){
    $checkin=htmlspecialchars($_POST['hidden_checki']);
} else {
    $checkin='NO';
}

//FUNCION QUE DEVUELVE ARRAY DE DATOS DEL CLIENTE
$resultadoCliente = consultaCliente($idcliente);

//---Termina Cliente---
//VALIDA QUE HUBO UNA ACTUALIZACION DE CLIENTES
if($telefonodos=="" || empty($telefonodos)){
    $affectedrowCliente=modificarCliente($distrito,$nombcliente,NULL,$correo,$direccion,$idcliente);
}else{
    $affectedrowCliente=modificarCliente($distrito,$nombcliente,$telefonodos,$correo,$direccion,$idcliente);
}


 try{
        $stmtBPros = $con->prepare("Select ph.IdProspectoRP,
ph.FechaHoraREG,
ph.EstadoProspecto,
ph.TipoVenta,
ph.CategoriaVenta,
ph.ComentarioCallRP,
ph.GestorContactRP,
ph.GestorBackOffice,
ph.IdUsuario,
ph.Matricula,
ph.Comercial,
ph.CC,
ph.JefeVenta,
ph.FechaVisitaRP,
ph.HoraVisitaRP,
ph.MesVisitaRP,
ph.ComentarioVisita,
ph.Segmento,
ph.MotivoNoAceptaVisita,
ph.Competencia,
ph.FechaRellamada,
ph.HoraRellamada
 from yifi58ge_dbVENTAS.tblprospectorphist ph WHERE ph.IdProspectoRPHist = (SELECT LAST_INSERT_ID(p.IdProspectoRPHist) FROM yifi58ge_dbVENTAS.tblprospectorphist p WHERE p.IdProspectoRP = ? order by p.IdProspectoRPHist desc limit 0,1)");
        $stmtBPros->bind_param('i', $idprospectorp);
        $stmtBPros->execute();
        $stmtBPros->store_result();
        $stmtBPros->bind_result($ValidarIdProspectoRP,
$ValidarFechaHoraREG,
$ValidarEstadoProspecto,
$ValidarTipoVenta,
$ValidarCategoriaVenta,
$ValidarComentarioCallRP,
$ValidarGestorContactRP,
$ValidarGestorBackOffice,
$ValidarIdUsuario,
$ValidarMatricula,
$ValidarComercial,
$ValidarCC,
$ValidarJefeVenta,
$ValidarFechaVisitaRP,
$ValidarHoraVisitaRP,
$ValidarMesVisitaRP,
$ValidarComentarioVisita,
$ValidarSegmento,
$ValidarMotivoNoAceptaVisita,
$ValidarCompetencia,
$ValidarFechaRellamada,
$ValidarHoraRellamada);
        $numrows=$stmtBPros->num_rows;
        $stmtBPros->fetch();
        $stmtBPros->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }


if($categoria=='VisitaAceptada'){
    $estadousuario=$_POST['estadousuario'];

    //$cat='VisitaAceptada'; 
    //$estadopro='VisitaAceptada';
    //$fechavisitaasig="p.FechaVisitaAsignada=NULL";
    //$fechavisitaasigVal = null;
    //$comvisita="p.ComentarioVisita=NULL";
    //$comvisitaVal = null;
    
    $fvisita=$_POST['lblfvisita'];
    $hvisita=$_POST['lblhvisita'];

    
    $mesvisita=$_POST['lblmesvisita'];
    
    $fechaconvertfvisita=  myUrlEncode($fvisita);
    $fechagrabarfvisita=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfvisita));
    
    $horaconvertvisita=  myUrlEncode($hvisita);
    $horagrabarvisita=  date("H:i", strtotime(str_replace("+"," ",$horaconvertvisita)));    
    $horagrabarvisitacomparar=  date("H:i:s", strtotime(str_replace("+"," ",$horaconvertvisita)));
    
    $faceptada = date("Y-m-d H:i:s");
    
    //ARRAY CON DATOS ACTUALES PROSPECTORP
    $resultadoProspectoRP = consultaProspectoRP($idprospectorp);

  try{
        $sqlprospecto = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblprospectorp p SET p.CategoriaVenta=?,p.TipoVenta=?,p.EstadoProspecto=?,p.MesVisitaRP=?,p.FechaVisitaRP=?,p.HoraVisitaRP=?,p.FechaGestion=?, p.FechaVisitaAceptada=?, p.FechaUltimaGestion=?, p.ComentarioCallRP=?,p.GestorContactRP=?,p.Segmento=? WHERE p.IdProspectoRP=?");
        $sqlprospecto->bind_param('ssssssssssssi', $categoria,$tipoventa,$estadoprospecto,$mesvisita,$fechagrabarfvisita,$horagrabarvisita,$fechagestion,$faceptada,$fUltimaGestion,$comentariocallrp,$gestorcall,$segmento,$idprospectorp);
        $sqlprospecto->execute();
        $affectedrowprospecto = $sqlprospecto->affected_rows;
        $sqlprospecto->close();
    } catch (\Exception $e) {
         echo $e->getMessage();
    }
    //VALIDA SI SE REALIZO EL UPDATE
    if ($affectedrowprospecto > 0){
        //---LOGPROSPECTORP--
        if($numrows==0){

          try{
              
              $TipoTabla='CallRP';
        
                $sqlprospechist = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,ComentarioCallRP,GestorContactRP,FechaVisitaRP, HoraVisitaRP, MesVisitaRP,Segmento, Gestor, TipoTabla) values(?,?,?,?,?,?,?,?,?,?,?,?,?)");
                $sqlprospechist->bind_param('issssssssssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$comentariocallrp,$gestorcall,$fechagrabarfvisita,$horagrabarvisita,$mesvisita,$segmento, $gestorcall, $TipoTabla);
                $sqlprospechist->execute();
                $sqlprospechist->close();
            } catch (\Exception $e) {
                 echo $e->getMessage();
            }            
            
           
        } else {
            if($ValidarEstadoProspecto==$estadoprospecto && $ValidarTipoVenta==$tipoventa && $ValidarCategoriaVenta==$categoria && $ValidarComentarioCallRP==$comentariocallrp && $ValidarGestorContactRP==$gestorcall && $ValidarFechaVisitaRP==$fechagrabarfvisita &&  $ValidarHoraVisitaRP==$horagrabarvisitacomparar && $ValidarMesVisitaRP==$mesvisita){
            } else {

              try{
                  
                  $TipoTabla='CallRP';
            
                    $sqlprospechist = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,ComentarioCallRP,GestorContactRP,FechaVisitaRP, HoraVisitaRP, MesVisitaRP,Segmento, Gestor, TipoTabla) values(?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $sqlprospechist->bind_param('issssssssssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$comentariocallrp,$gestorcall,$fechagrabarfvisita,$horagrabarvisita,$mesvisita,$segmento, $gestorcall, $TipoTabla);
                    $sqlprospechist->execute();
                    $sqlprospechist->close();
                } catch (\Exception $e) {
                     echo $e->getMessage();
                }                 
              
            }
        }

            $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
            $usuariosesion=$_SESSION['usuariosesion'];
            $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI']).'=>IdProspectoRP='.$idprospectorp;
            $Acceso='Modificar';
            $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              
              $idLogSeg = $con->insert_id;
              
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            } 

        if ($affectedrowCliente > 0){
            insertarLog($idLogSeg, $resultadoCliente);
        }
        insertarLogProspectoRP($idLogSeg, $resultadoProspectoRP);
        
        echo 2;
    }
}
else if($categoria=='NoAceptaVisita'){
    
    $movitonoaceptavisita=$_POST['lblmovitonoaceptavisita'];
    
    if(isset($_POST['lblcompetencia']) && $_POST['lblcompetencia'] != '0'){
        $competencia=$_POST['lblcompetencia'];
    }else{
        $competencia=NULL;
    }
    
    //ARRAY CON DATOS ACTUALES PROSPECTORP
    $resultadoProspectoRP = consultaProspectoRP($idprospectorp);
    
    //UPDATE TABLA PROSPECTO, SE ENVIA FECHA Y HORA VISITA NULO PORQUE EL PROSPECTO PUEDE VENIR DE UN ESTADO CON FECHA VISITA REGISTRADA

  try{
      
      $FechaVisitaRP=NULL;
      $HoraVisitaRP=NULL;
      
        $sqlprospecto = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblprospectorp p SET p.CategoriaVenta=?,p.TipoVenta=?,p.EstadoProspecto=?,p.MotivoNoAceptaVisita=?,p.ComentarioCallRP=?,p.GestorContactRP=?,p.Competencia=?,p.FechaVisitaRP=?,p.HoraVisitaRP=?,p.Segmento=?,p.FechaGestion=?, p.FechaUltimaGestion=? WHERE p.IdProspectoRP=?");
        $sqlprospecto->bind_param('ssssssssssssi', $categoria,$tipoventa,$estadoprospecto,$movitonoaceptavisita,$comentariocallrp,$gestorcall,$competencia,$FechaVisitaRP,$HoraVisitaRP,$segmento,$fechagestion,$fUltimaGestion,$idprospectorp);
        
        $sqlprospecto->execute();

        $affectedrowprospecto = $sqlprospecto->affected_rows;
        
        $sqlprospecto->close();
    } catch (\Exception $e) {
         echo $e->getMessage();
    }

    //VALIDA SI SE ACTUALIZO EL PROSPECTO
    if ($affectedrowprospecto > 0){
        //Insertar al Log Prospecto
        //---LOGPROSPECTORP--
        if($numrows==0){

          try{
              
              $TipoTabla='CallRP';
        
                $sqlprospechist = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,ComentarioCallRP,GestorContactRP,MotivoNoAceptaVisita,Competencia, Gestor, TipoTabla) values(?,?,?,?,?,?,?,?,?, ?, ?)");
                $sqlprospechist->bind_param('issssssssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$comentariocallrp,$gestorcall,$movitonoaceptavisita,$competencia, $gestorcall, $TipoTabla);
                $sqlprospechist->execute();
                $sqlprospechist->close();
            } catch (\Exception $e) {
                 echo $e->getMessage();
            }            
            
        }else{
            if($ValidarEstadoProspecto==$estadoprospecto && $ValidarTipoVenta==$tipoventa && $ValidarCategoriaVenta==$categoria && $ValidarComentarioCallRP==$comentariocallrp && $ValidarGestorContactRP==$gestorcall && $ValidarMotivoNoAceptaVisita==$movitonoaceptavisita && $ValidarCompetencia==$competencia){
            }else{
                
                try{
              
                  $TipoTabla='CallRP';
            
                    $sqlprospechist = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,ComentarioCallRP,GestorContactRP,MotivoNoAceptaVisita,Competencia, Gestor, TipoTabla) values(?,?,?,?,?,?,?,?,?, ?, ?)");
                    $sqlprospechist->bind_param('issssssssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$comentariocallrp,$gestorcall,$movitonoaceptavisita,$competencia, $gestorcall, $TipoTabla);
                    $sqlprospechist->execute();
                    $sqlprospechist->close();
                } catch (\Exception $e) {
                     echo $e->getMessage();
                } 
            
          
            }
        }
        //---Termina LOGPROSPECTORP---
            $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
            $usuariosesion=$_SESSION['usuariosesion'];
            $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI']).'=>IdProspectoRP='.$idprospectorp;
            $Acceso='Modificar';
            $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              
              $idLogSeg = $con->insert_id;
              
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            }
        if ($affectedrowCliente > 0){
            insertarLog($idLogSeg, $resultadoCliente);
        }
        insertarLogProspectoRP($idLogSeg, $resultadoProspectoRP);
        echo 3;
    }
}
else if($categoria=='DevolverLlamada'){
    $frellamada=$_POST['lblfrellamada'];
    $hrellamada=$_POST['lblhrellamada'];
    
    $fechaconvertfrellamada=  myUrlEncode($frellamada);
    $fechagrabarfrellamada=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfrellamada));
    
    $horaconvertrellamada=  myUrlEncode($hrellamada);
    $horagrabarrellamada=  date("H:i", strtotime(str_replace("+"," ",$horaconvertrellamada)));
    $horagrabarrellamadacomparar=  date("H:i:s", strtotime(str_replace("+"," ",$horaconvertrellamada)));

    //ARRAY CON DATOS ACTUALES PROSPECTORP
    $resultadoProspectoRP = consultaProspectoRP($idprospectorp);
    
    //SE REGISTRAN DATOS COMO NULL POR SI VIENEN DE OTROS ESTADOS

  try{
      
      $FechaVisitaRP=NULL;
      $HoraVisitaRP=NULL;

        $sqlprospecto = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblprospectorp p SET p.CategoriaVenta=?,p.TipoVenta=?,p.EstadoProspecto=?,p.FechaRellamada=?,p.HoraRellamada=?,p.ComentarioCallRP=?,p.GestorContactRP=?,p.FechaVisitaRP=?,p.HoraVisitaRP=?,p.Segmento=?,p.FechaGestion=?, p.FechaUltimaGestion=? WHERE p.IdProspectoRP=?");
        $sqlprospecto->bind_param('ssssssssssssi', $categoria,$tipoventa,$estadoprospecto,$fechagrabarfrellamada,$horagrabarrellamada,$comentariocallrp,$gestorcall,$FechaVisitaRP,$HoraVisitaRP,$segmento,$fechagestion,$fUltimaGestion,$idprospectorp);
        
        $sqlprospecto->execute();

        $affectedrowprospecto = $sqlprospecto->affected_rows;
        
        $sqlprospecto->close();
    } catch (\Exception $e) {
         echo $e->getMessage();
    }
    
    

    //VALIDA SI SE REALIZO EL UPDATE
    
    if ($affectedrowprospecto > 0){
        //---LOGPROSPECTORP--
        if($numrows==0){

          try{
              
              $TipoTabla='CallRP';
        
                $sqlprospechist = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,ComentarioCallRP,GestorContactRP,FechaRellamada,HoraRellamada, Gestor, TipoTabla) values(?,?,?,?,?,?,?,?,?,?,?)");
                $sqlprospechist->bind_param('issssssssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$comentariocallrp,$gestorcall,$fechagrabarfrellamada,$horagrabarrellamada, $gestorcall, $TipoTabla);
                $sqlprospechist->execute();
                $sqlprospechist->close();
            } catch (\Exception $e) {
                 echo $e->getMessage();
            }
            
        }else{
            if($ValidarEstadoProspecto==$estadoprospecto && $ValidarTipoVenta==$tipoventa && $ValidarCategoriaVenta==$categoria && $ValidarComentarioCallRP==$comentariocallrp && $ValidarGestorContactRP==$gestorcall && $ValidarFechaRellamada==$fechagrabarfrellamada && $ValidarHoraRellamada==$horagrabarrellamadacomparar){
                
            }else{

                  try{
                      
                      $TipoTabla='CallRP';
                
                        $sqlprospechist = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,ComentarioCallRP,GestorContactRP,FechaRellamada,HoraRellamada, Gestor, TipoTabla) values(?,?,?,?,?,?,?,?,?,?,?)");
                        $sqlprospechist->bind_param('issssssssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$comentariocallrp,$gestorcall,$fechagrabarfrellamada,$horagrabarrellamada, $gestorcall, $TipoTabla);
                        $sqlprospechist->execute();
                        $sqlprospechist->close();
                    } catch (\Exception $e) {
                         echo $e->getMessage();
                    }
          
            }
        }
        //---Termina LOGPROSPECTORP---
        
  $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
            $usuariosesion=$_SESSION['usuariosesion'];
            $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI']).'=>IdProspectoRP='.$idprospectorp;
            $Acceso='Modificar';
            $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              
              $idLogSeg = $con->insert_id;
              
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            } 
            
        if ($affectedrowCliente > 0){
            insertarLog($idLogSeg, $resultadoCliente);
        }
        insertarLogProspectoRP($idLogSeg, $resultadoProspectoRP);
        echo 4;
    }
}
else if($categoria=='NoContesta' || $categoria=='ClienteError' || $categoria=='TelefonoError' || $categoria=='ZSCC' || $categoria=='Provincia' || $categoria=='Inviable' || $categoria=='Rechazada' || $categoria=='ClienteVerisure' ){
    
    //ARRAY CON DATOS ACTUALES PROSPECTORP
    $resultadoProspectoRP = consultaProspectoRP($idprospectorp);
    //SE REGISTRAN DATOS COMO NULL POR SI VIENEN DE OTROS ESTADOS

    try{
      
      $FechaVisitaRP=NULL;
      $HoraVisitaRP=NULL;
      $MotivoNoAceptaVisita=NULL;
     
        $sqlprospecto = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblprospectorp p SET p.CategoriaVenta=?,p.TipoVenta=?,p.EstadoProspecto=?,p.ComentarioCallRP=?,p.GestorContactRP=?,p.MotivoNoAceptaVisita=?,p.FechaVisitaRP=?,p.HoraVisitaRP=?, p.FechaGestion=?, p.FechaUltimaGestion=? WHERE p.IdProspectoRP=?");
        $sqlprospecto->bind_param('ssssssssssi', $categoria,$tipoventa,$estadoprospecto,$comentariocallrp,$gestorcall,$MotivoNoAceptaVisita,$FechaVisitaRP,$HoraVisitaRP,$fechagestion,$fUltimaGestion,$idprospectorp);
        
        $sqlprospecto->execute();

        $affectedrowprospecto = $sqlprospecto->affected_rows;
        
        $sqlprospecto->close();
    } catch (\Exception $e) {
         echo $e->getMessage();
    }
    
    if ($affectedrowprospecto > 0){
        //Insertar al Log Prospecto
        //---LOGPROSPECTORP--
        if($numrows==0){

          try{
              
              $TipoTabla='CallRP';
                $sqlprospechist = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,ComentarioCallRP,GestorContactRP, Gestor, TipoTabla) values(?,?,?,?,?,?,?,?,?)");
                $sqlprospechist->bind_param('issssssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$comentariocallrp,$gestorcall, $gestorcall, $TipoTabla);
                $sqlprospechist->execute();
                $sqlprospechist->close();
            } catch (\Exception $e) {
                 echo $e->getMessage();
            }
            

        }else{
            if($ValidarEstadoProspecto==$estadoprospecto && $ValidarTipoVenta==$tipoventa && $ValidarCategoriaVenta==$categoria && $ValidarComentarioCallRP==$comentariocallrp && $ValidarGestorContactRP==$gestorcall){
                
            }else{

              try{
                  
                  $TipoTabla='CallRP';
                    $sqlprospechist = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,ComentarioCallRP,GestorContactRP, Gestor, TipoTabla) values(?,?,?,?,?,?,?,?,?)");
                    $sqlprospechist->bind_param('issssssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$comentariocallrp,$gestorcall, $gestorcall, $TipoTabla);
                    $sqlprospechist->execute();
                    $sqlprospechist->close();
                } catch (\Exception $e) {
                     echo $e->getMessage();
                }
          
            }
        }
        //---Termina LOGPROSPECTORP---
            $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
            $usuariosesion=$_SESSION['usuariosesion'];
            $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI']).'=>IdProspectoRP='.$idprospectorp;
            $Acceso='Modificar';
            $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              
              $idLogSeg = $con->insert_id;
              
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            } 
        //INSERTA LOG DE TRANSACCION SI LOS DATOS DEL CLIENTE SON MODIFICADOS
        if ($affectedrowCliente > 0){
            insertarLog($idLogSeg, $resultadoCliente);
        };
        //INSERTA LOG DE TRANSACCION SI LOS DATOS DEL PROSPECTO SON MODIFICADOS
        insertarLogProspectoRP($idLogSeg, $resultadoProspectoRP);
        echo 1;
    }

}
else if($categoria=='VRPAsignada' || $categoria=='AnuladaOP' || $categoria=='AnuladaCLI' || $categoria=='AnuladaTEC'){
    

    //INICIO DECLARACION DE VARIABLES
    $fvisita=$_POST['lblfvisita'];
    $hvisita=$_POST['lblhvisita'];
    $mesvisita=$_POST['lblmesvisita'];
    
    $idusuarioVA=$_POST['lblidusuarioVA'];
    $MatriculaVA=$_POST['lblmatriculaVA'];
    $nombcomercialVA=$_POST['lblnombcomercialVA'];
    $dcVA=$_POST['lbldcVA'];
    $jefeventaVA=$_POST['lbljefeventaVA'];
    $comentarioVisita=htmlspecialchars($_POST['lblcomentarioVisita']);
    $gestorCallRP=$_POST['lblgestorcontactrpOriginal'];
    $gestorbackoffice=$_POST['lblmatgestorbackofficerp'];
    $checkin=NULL;
    
    $fechaconvertfvisita=  myUrlEncode($fvisita);
    $fechagrabarfvisita=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfvisita));
    
    $horaconvertvisita=  myUrlEncode($hvisita);
    $horagrabarvisita=  date("H:i", strtotime(str_replace("+"," ",$horaconvertvisita)));
    $horagrabarvisitacomparar=  date("H:i:s", strtotime(str_replace("+"," ",$horaconvertvisita)));
    
if($estadoprospecto=='VRPAsignada'){
    $fechavisitaasig=date("Y-m-d H:i:s");
}else{
$fechavisitaasig=NULL;
}    
    
    //FIN DE DECLARACION DE VARIABLES
    
    //ARRAY CON DATOS ACTUALES PROSPECTORP
    $resultadoProspectoRP = consultaProspectoRP($idprospectorp);

        try{
          
            $sqlprospecto = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblprospectorp p SET CheckinRP=?,p.CategoriaVenta=?,p.TipoVenta=?,p.EstadoProspecto=?,p.MesVisitaRP=?,p.FechaVisitaRP=?,p.HoraVisitaRP=?,p.ComentarioCallRP=?,p.IdUsuario=?,p.Matricula=?,p.Comercial=?,p.CC=?,p.JefeVenta=?,p.ComentarioVisita=?, p.GestorBackOffice=?,p.FechaVisitaAsignada=? WHERE p.IdProspectoRP=?");
            $sqlprospecto->bind_param('ssssssssississssi', $checkin,$categoria,$tipoventa,$estadoprospecto,$mesvisita,$fechagrabarfvisita,$horagrabarvisita,$comentariocallrp,$idusuarioVA,$MatriculaVA,$nombcomercialVA,$dcVA,$jefeventaVA,$comentarioVisita,$gestorbackoffice,$fechavisitaasig,$idprospectorp);
            
            $sqlprospecto->execute();
    
            $affectedrowprospecto = $sqlprospecto->affected_rows;
            
            $sqlprospecto->close();
        } catch (\Exception $e) {
             echo $e->getMessage();
        }

    if ($affectedrowprospecto > 0){
    //---LOGPROSPECTORP--
        if($numrows==0){

          try{
              
              $TipoTabla='BackOffice';
                $sqlprospechist = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,ComentarioCallRP,GestorContactRP,GestorBackOffice,IdUsuario,Matricula,Comercial,CC,JefeVenta,FechaVisitaRP,HoraVisitaRP,MesVisitaRP,ComentarioVisita, Gestor, TipoTabla) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                $sqlprospechist->bind_param('isssssssississsssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$comentariocallrp,$gestorCallRP,$gestorbackoffice,$idusuarioVA,$MatriculaVA,$nombcomercialVA,$dcVA,$jefeventaVA,$fechagrabarfvisita,$horagrabarvisita,$mesvisita,$comentarioVisita, $gestorbackoffice,$TipoTabla);
                $sqlprospechist->execute();
                $sqlprospechist->close();
            } catch (\Exception $e) {
                 echo $e->getMessage();
            }              
            
             
        }else{
            if($ValidarEstadoProspecto==$estadoprospecto && $ValidarTipoVenta==$tipoventa && $ValidarCategoriaVenta==$categoria && $ValidarComentarioCallRP==$comentariocallrp && $ValidarGestorContactRP==$gestorcall && $ValidarFechaVisitaRP==$fechagrabarfvisita &&  $ValidarHoraVisitaRP==$horagrabarvisitacomparar && $ValidarMesVisitaRP==$mesvisita && $ValidarIdUsuario==$idusuarioVA && $ValidarMatricula==$MatriculaVA && $ValidarComercial==$nombcomercialVA && $ValidarCC==$dcVA && $ValidarJefeVenta==$jefeventaVA && $ValidarComentarioVisita==$comentarioVisita ){
            }else{
                try{
              
                  $TipoTabla='BackOffice';
                    $sqlprospechist = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblprospectorphist(IdProspectoRP,FechaHoraREG,EstadoProspecto,TipoVenta,CategoriaVenta,ComentarioCallRP,GestorContactRP,GestorBackOffice,IdUsuario,Matricula,Comercial,CC,JefeVenta,FechaVisitaRP,HoraVisitaRP,MesVisitaRP,ComentarioVisita, Gestor, TipoTabla) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    $sqlprospechist->bind_param('isssssssississsssss', $idprospectorp,$fecharegistro,$estadoprospecto,$tipoventa,$categoria,$comentariocallrp,$gestorCallRP,$gestorbackoffice,$idusuarioVA,$MatriculaVA,$nombcomercialVA,$dcVA,$jefeventaVA,$fechagrabarfvisita,$horagrabarvisita,$mesvisita,$comentarioVisita, $gestorbackoffice,$TipoTabla);
                    $sqlprospechist->execute();
                    $sqlprospechist->close();
                } catch (\Exception $e) {
                     echo $e->getMessage();
                } 
            }
        }
        //---Termina LOGPROSPECTORP---
        
            $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
            $usuariosesion=$_SESSION['usuariosesion'];
            $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI']).'=>IdProspectoRP='.$idprospectorp;
            $Acceso='Modificar';
            $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              
              $idLogSeg = $con->insert_id;
              
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            } 
        //INSERTA LOG DE TRANSACCION SI LOS DATOS DEL CLIENTE SON MODIFICADOS
        if ($affectedrowCliente > 0){
            insertarLog($idLogSeg, $resultadoCliente);
        }
        //INSERTA LOG DE TRANSACCION SI LOS DATOS DEL PROSPECTO SON MODIFICADOS
        insertarLogProspectoRP($idLogSeg, $resultadoProspectoRP);
        echo 5;
    }
}


//ENVIO CORREO

    try{

        $stmtInfE = $con->prepare( "SELECT
   u.IdUsuario,
    p.Matricula,
    p.Comercial,
    p.CC,
    p.JefeVenta,
    CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
    u.Correo Correcomercial,
    m.Correo Correojefe,
    del.Correo Correodel,
    p.EstadoProspecto,
    p.CategoriaVenta,
    p.TipoVenta,
    p.Segmento,
    c.NombApellido Cliente,
    c.Correo CorreoCliente,
    c.Telefonouno,
    c.Telefonodos,
    c.Direccion,
    g.IdGeografico,
    g.Distrito,
    g.Provincia,
    p.PrecioKit,
    p.TotalExtra,
    p.ResumenProspecto,
    p.ExtraAutorizado,
    p.FormaPago,
    p.PAI,
    p.N590,
    p.ComentarioProspectoRP,
    p.ComentarioCallRP,
    p.ComentarioVisita,
    p.GestorContactRP,
    ges.Correo CorreoGestor,
    CONCAT(ges.Nombres,' ',ges.Apellidos) NombGestor,
    DATE_FORMAT(p.FechaVisitaRP,'%W %d/%m') FVisita,
    DATE_FORMAT(p.FechaVisitaRP,'%d/%m/%Y') FechaVisitaRP,
	TIME_FORMAT(p.HoraVisitaRP,'%r') HoraVisitaRP,
	p.FechaVisitaRP FechaVisitaRPComparar,
    p.HoraVisitaRP HoraVisitaRPComparar,
    p.MesVisitaRP,
    p.MotivoNoAceptaVisita,
    DATE_FORMAT(p.FechaRellamada,'%d/%m/%Y') FechaRellamada,
	TIME_FORMAT(p.HoraRellamada,'%r') HoraRellamada,
	u.Estado,
	p.FechaVisitaAsignada
FROM yifi58ge_dbVENTAS.tblprospectorp p
INNER JOIN yifi58ge_dbUSUARIO.tblusuario u on p.IdUsuario=u.IdUsuario 
INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
INNER JOIN yifi58ge_dbUSUARIO.tblusuario m on m.Matricula=u.Manager
INNER JOIN yifi58ge_dbUSUARIO.tblusuario del on del.Matricula=m.Manager
INNER JOIN yifi58ge_dbUSUARIO.tblusuario ges on ges.Matricula=p.GestorContactRP
INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
WHERE p.IdProspectoRP=?");
        $stmtInfE->bind_param('i', $idprospectorp);
        $stmtInfE->execute();
        $stmtInfE->store_result();
        $stmtInfE->bind_result($idu,
            $matriculaCorreo,
            $comercialCorreo,
            $dcCorreo,
            $matjefeCorreo,
            $jefeventaCorreo,
            $correocomercial,
            $correoJefeVente,
            $correodelegadoenviar,
            $estadoprospectoCorreo,
            $categoriaventaCorreo,
            $tipoventaCorreo,
            $segmentoCorreo,
            $clienteCorreo,
            $correoCliente,
            $movilCorreo,
            $fijoCorreo,
            $direccionCorreo,
            $idgeograficoCorreo,
            $distritoCorreo,
            $provinciaCorreo,
            $preciokitCorreo,
            $totalextraCorreo,
            $resumenventaCorreo,
            $regaloutorizadoCorreo,
            $formadepagoCorreo,
            $PAICorreo,
            $n590Correo,
            $comentarioprospectoCorreo,
            $comentariocallrpCorreo,
            $comentariovisitaCorreo,
            $gestorContactRPCorreo,
            $correoenviargestorCallRP,
            $nombregestorcorreo,
            $fvisita,
            $fvisitaCorreo,
            $hvisitaCorreo,
            $FechaVisitaRPComparar,
            $HoraVisitaRPComparar,
            $mesvisitaCorreo,
            $movitonoaceptavisitaCorreo,
            $frellamadaCorreo,
            $hrellamadaCorreo,
            $EstadoComercialCorreo,
            $fechasignadaCorreo);
        $numrowscorreo=$stmtInfE->num_rows;
        
        $fvisita=utf8_encode($fvisita); //Cambio a utf8
        $correocomercialenviar=$correocomercial;
        $correojefeenviar=$correoJefeVente;
        $nombregestorCall=$nombregestorcorreo;

        $stmtInfE->fetch();
        $stmtInfE->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

    if($numrowscorreo==0){
        
    }else{
    
    
        if($estadoprospectoCorreo=='VRPAsignada'){
            
            //NUEVO ENVIO DE ACUERDO AL TIPO DE CORREO
            //Cuando el estado recibido es VRPAceptada se envia correo sin tipo
            if ($resultadoProspectoRP['EstadoProspecto'] == 'VisitaAceptada'){
                $tipo = '';
                enviarcorreo($tipo);
            }
            else if ($resultadoProspectoRP['MesVisitaRP'] != $mesvisitaCorreo || $resultadoProspectoRP['FechaVisitaRP'] != $FechaVisitaRPComparar || $resultadoProspectoRP['HoraVisitaRP'] != $HoraVisitaRPComparar || $resultadoProspectoRP['ComentarioVisita'] != $comentariovisitaCorreo) {
                $tipo = '(MODIFICACIÓN)';
                enviarcorreo($tipo);
            }
            else if ($resultadoProspectoRP['Matricula'] != $matriculaCorreo){
                $tipo = "(REASIGNACIÓN)";
                enviarcorreo($tipo);
            }
        }
        else if ($estadoprospectoCorreo == 'AnuladaOP' || $estadoprospectoCorreo == 'AnuladaCLI' || $estadoprospectoCorreo == 'AnuladaTEC'){
            $tipo = "(ANULACIÓN)";
            enviarcorreo($tipo);
        }
        
    }

function enviarcorreo($tipo){
    
    global $idu;
    global $matriculaCorreo;
    global $comercialCorreo;
    global $matjefeCorreo;
    global $jefeventaCorreo;
    global $correocomercial;
    global $correoJefeVente;
    global $dcCorreo;
    global $estadoprospectoCorreo;
    global $categoriaventaCorreo;
    global $tipoventaCorreo;
    global $segmentoCorreo;
    global $clienteCorreo;
    global $correoCliente;
    global $movilCorreo;
    global $fijoCorreo;
    global $direccionCorreo;
    global $preciokitCorreo;
    global $totalextraCorreo;
    global $resumenventaCorreo;
    global $regaloutorizadoCorreo;
    global $formadepagoCorreo;
    global $n590Correo;
    global $PAICorreo;
    global $idgeograficoCorreo;
    global $distritoCorreo;
    global $provinciaCorreo;
    global $comentarioprospectoCorreo;
    global $comentariocallrpCorreo;
    global $gestorContactRPCorreo;
    global $nombregestorcorreo;
    global $movitonoaceptavisitaCorreo;
    global $mesvisitaCorreo;
    global $fvisita;
    global $fvisitaCorreo;
    global $hvisitaCorreo;
    global $EstadoComercialCorreo;
    global $comentariovisitaCorreo;
    global $correocomercialenviar;
    global $correojefeenviar;
    global $correodelegadoenviar;
    global $nombregestorCall;
    global $correoenviargestorCallRP;
    global $fechasignadaCorreo;

    global $idprospectorp;
    
    $correo_prueba="joseenrique.nanquen@verisure.pe";
            

                $correo_administrativo1="joseenrique.nanquen@verisure.pe";
                $correo_administrativo2="backoffice@verisure.pe";
                
                $para = $correocomercialenviar.",".$correojefeenviar.",".$correodelegadoenviar;

                $copia1 = "CHRISTIAN.GUTIERREZ@VERISURE.PE";
                $copia2 = "SHIRLEY.CUADRA@VERISURE.PE";
                $copia3 = "MADELEYNE.MUNAYCO@VERISURE.PE";
                $copia4 = $correoenviargestorCallRP;
                $copia5 = "lissett.mendoza@verisure.pe";                
                

                $titulo = "OPORTUNIDAD DE VENTA VISITA RPTMK - ".$idprospectorp." ".$tipo."";
            
            
            $mensaje ='
            <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
            <html xmlns="http://www.w3.org/1999/xhtml">
             
            <head>
              <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
              <title>A Simple Responsive HTML Email</title>
              <style type="text/css">
              body {margin: 0; padding: 0; min-width: 100%!important;}
              img {height: auto;}
              .content {width: 100%; max-width: 600px;}
              .header {padding: 5px 20px 5px 20px;}
              .innerpadding {padding: 20px 30px 15px 30px;}
              .borderbottom {border-bottom: 1px solid #f2eeed;}
              .subhead {font-size: 15px; color: #ffffff; font-family: sans-serif; letter-spacing: 10px;}
              .h1 {font-family: sans-serif;color: #ffffff;font-size:23px; line-height: 38px; font-weight: bold;}
              .h2 {color: #000000; font-family: sans-serif;padding: 0 0 15px 0; font-size: 24px; line-height: 28px; font-weight: bold;}
              .h3 {color: #000000; font-family: sans-serif;font-size: 14px; line-height: 22px; font-weight: bold;}
              .h4 {color: #000000;font-family: sans-serif;font-size: 16px; line-height: 30px; font-weight: bold;}
              .bodycopy {color: #000000; font-family: sans-serif;font-size: 14px; line-height: 22px;}
              .button {text-align: center; font-size: 18px; font-family: sans-serif; font-weight: bold; padding: 0 30px 0 30px;}
              .button a {color: #ffffff; text-decoration: none;}
              .footer {padding: 20px 30px 15px 30px;}
              .footercopy {font-family: sans-serif; font-size: 14px; color: #ffffff;}
              .footercopy a {color: #ffffff; text-decoration: underline;}
              .coldiv115{width: 115px;};
              .coldiv380{width: 380px;};
            
              @media only screen and (max-width: 550px), screen and (max-device-width: 550px) {
              body[yahoo] .hide {display: none!important;}
              body[yahoo] .buttonwrapper {background-color: transparent!important;}
              body[yahoo] .button {padding: 0px!important;}
              body[yahoo] .button a {background-color: #e05443; padding: 15px 15px 13px!important;}
              body[yahoo] .unsubscribe {display: block; margin-top: 20px; padding: 10px 50px; background: #2f3942; border-radius: 5px; text-decoration: none!important; font-weight: bold;}
              }
            
              /*@media only screen and (min-device-width: 601px) {
                .content {width: 600px !important;}
                .col425 {width: 425px!important;}
                .col380 {width: 380px!important;}
                }*/
            
              </style>
            </head>
            
            <body yahoo bgcolor="#f2f2f2">
            <table width="100%" bgcolor="#f2f2f2" border="0" cellpadding="0" cellspacing="0">
            <tr>
              <td>
                <!--[if (gte mso 9)|(IE)]>
                  <table width="600" align="center" cellpadding="0" cellspacing="0" border="0">
                    <tr>
                      <td>
                <![endif]-->     
                <table bgcolor="#ffffff" class="content" align="center" cellpadding="0" cellspacing="0" border="0">
                  <tr>
                    <td bgcolor="#ffffff" class="header">
                      <table width="70" align="center" border="0" cellpadding="0" cellspacing="0">  
                        <tr>
                          <td height="70" style="padding: 0 20px 20px 0;">
                            <img class="fix"  src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png" border="0" alt="" />
                          </td>
                        </tr>
                      </table>
                    </td>
                  </tr>
                  
                  
                  <tr>
                    <td bgcolor="#dc0000" class="header">
                      
                      <!--[if (gte mso 9)|(IE)]>
                        <table width="425" align="center" cellpadding="0" cellspacing="0" border="0">
                          <tr>
                            <td>
                      <![endif]-->
                      <table class="col425" align="center" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 425px;">  
                        <tr>
                          <td height="70">
                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                <td class="h1" align="center" style="padding: 0 0 0 0;">
                                  OPORTUNIDAD DE VENTA RPTMK- '.$idprospectorp.'
                                </td>
                              </tr>
                            </table>
                          </td>
                        </tr>
                      </table>
                      <!--[if (gte mso 9)|(IE)]>
                            </td>
                          </tr>
                      </table>
                      <![endif]-->
                    </td>
                  </tr>
                  
                  <tr>
                    <td class="innerpadding borderbottom">
                      <table width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                          <td class="h2">
                            Estimado(s) Sr(es) '.strtoupper($comercialCorreo).'
                          </td>
                        </tr>
                        <tr>
                            <td class="bodycopy">
                                <h4 style="font-weight: normal">Envío los datos de una RPTMK para el <span style="font-weight: bold;">'.$fvisita.' a las '.$hvisitaCorreo.'</span></h4>
                                <h4 style="font-weight: normal">Enviar la ubicación al WHATSAPP CEL. <span style="font-weight: bold;">942488070</span> indicando:</h4>
                                <ul>
                                    <ol>
                                        <li>El número de prospecto dentro del día que se agendó la visita.</li>
                                        <li>Informar el estado final de la visita (Vendida o No Vendido).</li>
                                    </ol>
                                </ul>
                            </td>
                        </tr>
                      </table>
                    </td>
                  </tr>
                  
                   <tr>
                    <td class="innerpadding borderbottom">
                      <table  width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                          <td class="h4" bgcolor="#dddddd" align="center" style="padding: 0 0px 0px 0;">
                            INFORMACIÓN DE LA VISITA
                          </td>
                        </tr>
                      </table>
                        
                      <table align="left" border="0" cellpadding="0" cellspacing="0">
                        <tr>
                          <td class="h3" width="145" style="padding: 5px 0px 0px 0;">
                            CLIENTE:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. strtoupper($clienteCorreo).'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            DIRECCIÓN:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. strtoupper($direccionCorreo).'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            DISTRITO:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($distritoCorreo).'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            PROVINCIA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($provinciaCorreo).'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            TELEFONO UNO:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. $movilCorreo.'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            TELEFONO DOS:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. $fijoCorreo.'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            CORREO:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($correoCliente).'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            FECHA VISITA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. $fvisitaCorreo.'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            HORA VISITA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. $hvisitaCorreo.'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            COMENTARIO VISITA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($comentariovisitaCorreo).'
                          </td>
                        </tr>
                        
                      </table>
                     
                    </td>
                  </tr>
            
                  <tr>
                    <td class="innerpadding borderbottom">
                      <table bgcolor="#dddddd" width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                          <td class="h4" align="center"  style="padding: 0 0px 0px 0;">
                            INFORMACIÓN DEL PROSPECTO
                          </td>
                        </tr>
                      </table>
                        
                      <table align="left" border="0" cellpadding="0" cellspacing="0">  
                        <tr>
                          <td class="h3" width="145" style="padding: 5px 0px 0px 0;">
                            MATRICULA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 5px 0px 0px 0;">
                            '. $matriculaCorreo.'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            COMERCIAL:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($comercialCorreo).'
                          </td>
                        </tr>
                        
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            DELEGACIÓN:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. $dcCorreo.'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            JEFE VENTA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($matjefeCorreo).'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            ESTADO VISITA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. strtoupper($estadoprospectoCorreo).'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            RECURSO:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             RPTMK
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 5px 0px 0px 0;">
                            GESTOR RPTMK:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 5px 0px 0px 0;">
                            '.strtoupper($gestorContactRPCorreo).' - '.strtoupper($nombregestorCall).'
                          </td>
                        </tr>
            
                      </table>
                     
                    </td>
                  </tr>
                  <tr>
                    <td class="footer" bgcolor="#44525f">
                      <table width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                          <td align="center" class="footercopy">
                             2019 &reg; Verisure Perú SAC<br/>
                             Av. Primavera 1050 – Oficina 401<br/> 
                             Santiago de Surco – Urbanización Chacarilla del Estanque<br/>
                             Lima – Perú
                          </td>
                        </tr>
                      </table>
                    </td>
                  </tr>
                </table>
                <!--[if (gte mso 9)|(IE)]>
                      </td>
                    </tr>
                </table>
                <![endif]-->
                </td>
              </tr>
            </table>
            
            
            </body>
            </html>
            ';
            
            // //para el envío en formato HTML 
            //     $headers = "MIME-Version: 1.0\r\n";
            //     $headers .= "Content-type: text/html; charset=utf-8\r\n";
            
            // //dirección del remitente 
            //     $headers .= "From: Sistema de Ventas Verismart - Verisure Peru <backoffice@verismart.com.pe>\r\n";
            
            // //dirección de respuesta, si queremos que sea distinta que la del remitente 
            //     $headers .= "Reply-To: backoffice@verisure.pe\r\n";
            
            // //ruta del mensaje desde origen a destino 
            //     $headers .= "Return-path: backoffice@verismart.com.pe\r\n";
            
            // //direcciones que recibián copia 
            //     $headers .= "Cc: ".$copia1.",".$copia2.",".$copia3.",".$copia4.",".$copia5."\r\n";
            
            // //direcciones que recibirán copia oculta 
            // //$headers .= "Bcc: joecnan14@gmail.com\r\n"; 
            //         //direcciones que recibirán copia oculta 
            //         $headers .= "Bcc: ".$correo_prueba."\r\n";
            
            // mail($para, $titulo, $mensaje, $headers);
            
            
            
        /*******************************/
        // $para = array($correocomercialenviar,$correojefeenviar,$correodelegadoenviar);
        $copiaCorreo = array($copia1,$copia2,$copia3,$copia4,$copia5);

        $subject = 'Sistema de Ventas Verismart - Verisure Peru'; 

        $opts = array(
            'http'=>array(
            'method'=>"GET",
            'header'=>"User-Agent: api script\r\n"
            )
        );
        
        $context = stream_context_create($opts);
        
        $curl = curl_init();
        
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => $subject,
            'From' => 'backoffice@verisure.pe',
            'To' => 
            array (
              'Email' => 
              array (
                0 => $correocomercialenviar,
                1 => $correojefeenviar,
                2 => $correodelegadoenviar,
              )
            ),
            'Cc' => 
            array (
              'Email' => $copiaCorreo
            //   array (
            //     0 => $copiaCorreo,
            //   )
            ),
            'Bcc' => 
            array (
              'Email' => 
              array (
                0 => $correo_prueba,
                1 => 'placido.curilopez@verisure.pe'
              )
            ),
            'Message' => 
            array (
              'Subject' => $subject,
              'Classification' => 'C',
              'Body' => 
              array (
                'Format' => 'html',
                "Value"=> $mensaje
              )
            ),
            'Options' => 
            array (
              'OpenTracking' => 'true',
              'ClickTracking' => 'true',
              'TextHtmlTracking' => 'true',
              'AutoTextBody' => 'false',
            )
          )
        );
       
        $dataSC_string = json_encode($dataSC);
        
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 60,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => $dataSC_string,
          CURLOPT_HTTPHEADER => array(
            "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
            "cache-control: no-cache",
            "content-type: application/json"
          ),
        ));
        
        $response = curl_exec($curl); 
        $err = curl_error($curl);
        
        curl_close($curl);
}

function modificarCliente($distrito,$nombcliente,$telefonodos=NULL,$correo,$direccion,$idcliente){
global $con;
  try{
      
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente c SET c.IdGeografico=?,c.NombApellido=?,c.Telefonodos=?,c.Correo=?,c.Direccion=? WHERE c.IdCliente=?");
        $stmt->bind_param('issssi', $distrito,$nombcliente,$telefonodos,$correo,$direccion,$idcliente);
        
        $stmt->execute();

        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 0;
    }
    return $respuesta;

}




