<?php
    include('is_logged.php');
    date_default_timezone_set('America/Lima');
    
    require '../config/db.php';
    require '../config/conexion.php';
    include '../helper/helper_validacion.php';
    
    $ingresokit=0;
    $ingresoextras=0;
    $ingresototal=0;
    
    //AGREGAR FUNCIONES LOG
    include 'log/insertLog.php';
    include 'log/insertLogVisita.php';
    include 'log/insertLogCliente.php';
    //FUNCIONES DE VENTA
    include 'funciones/Venta.php';
    include 'Correo/correoNotificacionVisita.php';
    include 'Correo/correoNotificacionCheckIn.php';
    
    $MatriculaUsuario=sanitizaCampo($_POST['lblgestorbackoffice'],'sanitizestring|scapestring|htmlspecialchars',$con);
    
    $matricula=sanitizaCampo($_POST['lblmatricula'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $nombcomercial=sanitizaCampo($_POST['lblnombcomercial'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $dc=sanitizaCampo($_POST['lbldc'],'sanitizeint|scapestring|htmlspecialchars',$con);
    $jefeventa=sanitizaCampo($_POST['lbljefeventa'],'sanitizestring|scapestring|htmlspecialchars',$con);
    
    $estadoventa=sanitizaCampo($_POST['lblestadoventa'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $tipoventa=sanitizaCampo($_POST['lbltipoventa'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $segmento=sanitizaCampo($_POST['lblsegmento'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $categoria=sanitizaCampo($_POST['lblcategoria'],'sanitizestring|scapestring|htmlspecialchars',$con);
    
    $idcliente=sanitizaCampo($_POST['lblidcliente'],'sanitizeint|scapestring|htmlspecialchars',$con);
    $nombcliente=sanitizaCampo($_POST['lblnombcliente'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $correo=sanitizaCampo($_POST['lblcorreo'],'sanitizeemail|scapestring|htmlspecialchars',$con);
    $direccion=sanitizaCampo($_POST['lbldireccion'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $distrito=sanitizaCampo($_POST['lbldistrito'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $telefonouno=sanitizaCampo($_POST['lblmovil'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $telefonodos=sanitizaCampo($_POST['lblfijo'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $idusuario=sanitizaCampo($_POST['lblidusuario'],'sanitizeint|scapestring|htmlspecialchars',$con);
    
    $fechmod=date("Y-m-d H:i:s");
    $fecharegistro=date("Y-m-d H:i:s");
    $fecharegistroventa=date("Y-m-d H:i:s");
    
    $idventa=sanitizaCampo($_POST['lblidventa'],'sanitizeint|scapestring|htmlspecialchars',$con);
    $idventa=(int) htmlspecialchars($idventa);

    $estvisita=sanitizaCampo($_POST['lblestvisita'],'sanitizestring|scapestring|htmlspecialchars',$con);
    
    //MODIFICACION EMU 17.05 
    if(isset($_POST['ValFObras'])){
        $fobras=sanitizaCampo($_POST['ValFObras'],'sanitizestring|scapestring|htmlspecialchars',$con);
    } else {
        $fobras='NO';  
    }
    
    $queryFechaVisitaObra = '';
    
    //MODIFICACION EMU 21.05
    
    if($_POST['lblFVisitaReal'] != ''){
        $fvisitaObras=sanitizaCampo($_POST['lblFVisitaReal'],'sanitizestring|scapestring|htmlspecialchars',$con);
        $fechaconvertlblfvisitaObra = myUrlEncode($fvisitaObras);
        $fechagrabarfvisitaObra = format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertlblfvisitaObra));
        $queryFechaVisitaObra = "FVisitaObras = '".$fechagrabarfvisitaObra."'";
    } else {
        $queryFechaVisitaObra = "FVisitaObras = NULL";
        $fechagrabarfvisitaObra = NULL;
    }
    
    $comentariovisita=sanitizaCampo($_POST['lblcomentariovisita'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $asignadopor=sanitizaCampo($_POST['lblasignado'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $nombreOperadorCC=sanitizaCampo($_POST['nombreOperadorCC'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $nprospecto=sanitizaCampo($_POST['lblnprospecto'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $nprospectohidden=sanitizaCampo($_POST['lblnprospectohidden'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $origen=sanitizaCampo($_POST['lblorigen'],'sanitizestring|scapestring|htmlspecialchars',$con);
    
    $fvencimiento=sanitizaCampo($_POST['lblfvencimiento'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $fvisita=sanitizaCampo($_POST['lblfvisita'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $hvisita=sanitizaCampo($_POST['lblhvisita'],'sanitizestring|scapestring|htmlspecialchars',$con);
    
    $checkin=sanitizaCampo($_POST['hidden_checki'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $mesvisita=sanitizaCampo($_POST['lblmesvisita'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $leadid=sanitizaCampo($_POST['lblleadid'],'sanitizestring|scapestring|htmlspecialchars',$con);
    
    $fechaconvertvencimiento=  myUrlEncode($fvencimiento);
    $fechagrabarvencimiento=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertvencimiento));
    $fechaconvertfvisita=  myUrlEncode($fvisita);
    $fechagrabarfvisita=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfvisita));
    
    $horaconvertvisita=  myUrlEncode($hvisita);
    $horagrabarvisita=  date("H:i:s", strtotime(str_replace("+"," ",$horaconvertvisita)));
    
    $lblcctc=sanitizaCampo($_POST['lblcctc'],'sanitizestring|scapestring|htmlspecialchars',$con);
    
    //DOCUMENTO Visita
    if (empty($_POST['lblIdDocVisita'])){
        $IdDocVisita = NULL;
    } else {
        $IdDocVisita=sanitizaCampo($_POST['lblIdDocVisita'],'sanitizestring|scapestring|htmlspecialchars',$con);
    }
    
    $tipodoc=$_POST['lbltipodoc'];
    $documento=sanitizaCampo($_POST['lbldocumento'],'sanitizestring|scapestring|htmlspecialchars',$con);
    
    $Referencia=sanitizaCampo($_POST['lblreferencia'],'sanitizestring|scapestring|htmlspecialchars',$con);
    
    if (isset($_POST['lblinterior'])){
        $interior=sanitizaCampo($_POST['lblinterior'],'sanitizestring|scapestring|htmlspecialchars',$con);
    } else {
        $interior = null;
    }
    
    if (isset($_POST['objGeofinder'])){
        $objGeofinder=$_POST['objGeofinder'];
    } else {
        $objGeofinder = null;
    }
    
    $lblIdDireccion = sanitizaCampo($_POST['lblIdDireccion'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $lbldireccionAprox = sanitizaCampo($_POST['lbldireccionAprox'],'sanitizestring|scapestring|htmlspecialchars',$con);
    if (isset($_POST['lbltipoDireccion'])){
        $lbltipoDireccion = sanitizaCampo($_POST['lbltipoDireccion'],'sanitizestring|scapestring|htmlspecialchars',$con);
    } else {
        $lbltipoDireccion = null;
    }
    //ZONIFICACION
    $idZonificacion = sanitizaCampo($_POST['idZonificacion'],'sanitizeint|scapestring|htmlspecialchars',$con);
    $objZonificacionVerisure = $_POST['objZonificacionVerisure'];
    //INPUTS PARA DIFERENTE DELEGACION SELECCIONADA
    $txtMotivoDelegacion = sanitizaCampo($_POST['txtMotivoDelegacion'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $lbldcobjzonificacion = sanitizaCampo($_POST['lbldcobjzonificacion'],'scapestring|htmlspecialchars',$con);

    $CalidadGeo = sanitizaCampo($_POST['CalidadGeo'],'sanitizestring|scapestring|htmlspecialchars',$con);
    
    //DATOS DE SCORING
    $tipodoc=sanitizaCampo($_POST['lbltipodoc'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $documento=sanitizaCampo($_POST['lbldocumento'],'sanitizestring|scapestring|htmlspecialchars',$con);
    //CONSULTA SCORING
    if (isset($_POST['lblIdConsultaScoring'])){
        $IdConsultaScoring= sanitizaCampo($_POST['lblIdConsultaScoring'],'sanitizeint|scapestring|htmlspecialchars',$con);
        $PerfilScoring= sanitizaCampo($_POST['lblperfilscoring'],'sanitizestring|scapestring|htmlspecialchars',$con);
        $Accion=sanitizaCampo($_POST['lblaccion'],'sanitizestring|scapestring|htmlspecialchars',$con);
    } else {
        $IdConsultaScoring = NULL;
        $PerfilScoring =  NULL;
        $Accion = NULL;
    }
    
    $lblcalificarGestion = sanitizaCampo($_POST['lblcalificarGestion'],'sanitizestring|scapestring|htmlspecialchars',$con);
    
   $tiposegmento=sanitizaCampo($_POST['lbltiposegmento'],'sanitizestring|scapestring|htmlspecialchars',$con);
   $npiso=sanitizaCampo($_POST['lblnpiso'],'sanitizestring|scapestring|htmlspecialchars',$con);
   $tipovial=sanitizaCampo($_POST['tipovial'],'sanitizestring|scapestring|htmlspecialchars',$con);
   $motivoasignacion=sanitizaCampo($_POST['lblasignacion'],'sanitizestring|scapestring|htmlspecialchars',$con);
   
   $contactoasignacion=sanitizaCampo($_POST['lblcontactoasignacion'],'sanitizestring|scapestring|htmlspecialchars',$con);
   $cumpleranking=sanitizaCampo($_POST['lblcumpleranking'],'sanitizestring|scapestring|htmlspecialchars',$con);
   
     $visePiso=htmlspecialchars($_POST['visePiso']);
        if($visePiso==""){
            $visePiso=null;
        }        
        $rubroNeg=htmlspecialchars($_POST['rubroNeg']);
        if($rubroNeg==""){
            $rubroNeg=null;
        }          
        $puertaCalle=htmlspecialchars($_POST['puertaCalle']);
        if($puertaCalle==""){
            $puertaCalle=null;
        }         
        $nobleParedes=htmlspecialchars($_POST['nobleParedes']);
        if($nobleParedes==""){
            $nobleParedes=null;
        }         
        $nobleTecho=htmlspecialchars($_POST['nobleTecho']);
        if($nobleTecho==""){
            $nobleTecho=null;
        }         
        $mcuadrados=htmlspecialchars($_POST['mcuadrados']);
        if($mcuadrados==""){
            $mcuadrados=null;
        }          
        $motivoInteres=htmlspecialchars($_POST['motivoInteres']);
        if($motivoInteres==""){
            $motivoInteres=null;
        }         
        $conSistema=htmlspecialchars($_POST['conSistema']);
        if($conSistema==""){
            $conSistema=null;
        }        
        $empresaSistema=htmlspecialchars($_POST['empresaSistema']);
        if($empresaSistema==""){
            $empresaSistema=null;
        }        
        $bancarizado=htmlspecialchars($_POST['bancarizado']);
        if($bancarizado==""){
            $bancarizado=null;
        }      

        $segundaDireccion=htmlspecialchars($_POST['segundaDireccion']);
        if($segundaDireccion==""){
            $segundaDireccion=null;
        }    

    if(editar_buscarProspecto($nprospecto, $nprospectohidden)==false){
        $resultado = ['resultado' => 'ExisteNProspecto'];
    }else{
        //FUNCION QUE DEVUELVE ARRAY DE DATOS DEL CLIENTE
        $resultadoCliente = consultaCliente_AsignarVisita($idcliente);
        $resultadoVisita = consultaVisita_AsignarVisita($idventa);
        //DOCUMENTO
        if ($IdDocVisita == NULL){
             $resultadoDocumento = insertarDocumento();
             
             if ($resultadoDocumento > 0){
                $IdDocVisita=$resultadoDocumento;
             }else{
                $IdDocVisita=NULL;  
             }
             
        }else{
            $resultadoDocumento = actualizarDocumento($IdDocVisita);
        }
        
        //ACTUALIZA DATOS DEL CLIENTE
        $updCliente = actualizarClienteDoc($idcliente); 
        
        //ACTUALIZAR VENTA
        $updVenta = actualizarVenta();
        
        if($updVenta == 'Exito Update Venta'){
            
            //INSERT LOG DE SEGURIDAD
            $IdLogSegCliente = StmtInsertarLogSeguridad_General('Modificar', $fecharegistro, $idcliente, 'IdCliente');
            $IdLogSegVisita = StmtInsertarLogSeguridad_General('Modificar', $fecharegistro, $idventa, 'IdVenta');
            //INSERT LOG DE CLIENTES
            insertLogTransacCliente_AsignarVisita($IdLogSegCliente, $resultadoCliente);
            //INSERT LOG TRANSACCIONAL
            insertLogTransacVisita_AsignarVisita($IdLogSegVisita, $resultadoVisita);
            
            //CORREO DE ASIGNACION VISITA
            $sqltimename = "SET lc_time_names = 'es_ES'";
            $resultado_sqltimename = $con->query($sqltimename);
        
            $sqlCorreoConfirmacion = "SELECT 
                                    v.Matricula MatriculaComercial, 
                                    v.Comercial, 
                                    v.CC Delegacion, 
                                    u.Manager MatriculaJefeVenta, 
                                    u.Correo CorreoComercial, 
                                    u.IdPerfil PerfilComercial,
                                    u.Categoria CategoriaComercial,
                                    CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta, 
                                    m.Correo CorreoJefeVenta, 
                                    CONCAT(del.Nombres,' ',del.Apellidos) NombDelegado, 
                                    del.Correo CorreoDelegado, 
                                    v.EstadoVisita, 
                                    v.EstadoVenta, 
                                    v.TipoVenta, 
                                    v.Segmento, 
                                    v.NProspecto, 
                                    v.N590, 
                                    v.FechaVisita, 
                                    v.HoraVisita, 
                                    v.FObras,
                                    v.FVisitaObras,
                                    DATE_FORMAT(v.FVisitaObras, '%W %d/%m' ) FechaVisitaObrasDia,
                                    DATE_FORMAT(FechaVisita, '%W %d/%m') FechaVisitaDia, 
                                    v.FVencimientoVisita, 
                                    v.OrigenVisita, 
                                    v.ComentarioVisita, 
                                    v.MesVisita, 
                                    v.LeadID,
                                    v.GestorMKT,
                                    CONCAT(mkt.Nombres,' ',mkt.Apellidos) NombGestorMKT,
                                    mkt.Correo CorreoOperador,
                                    c.IdCliente, 
                                    c.NombApellido NombCliente, 
                                    c.Telefonouno T1Cliente, 
                                    c.Telefonodos T2Cliente, 
                                    c.Correo CorreoCliente, 
                                    c.Direccion DirCliente,
                                    c.Referencia RefCliente,
                                    g.Distrito DistCliente, 
                                    g.Provincia ProvCliente,
                                    c.Interior IntCliente
                                    FROM tblventa v
                                    INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON v.IdUsuario = u.IdUsuario
                                    INNER JOIN yifi58ge_dbUSUARIO.tblusuario m ON u.Manager = m.Matricula
                                    INNER JOIN yifi58ge_dbUSUARIO.tblusuario del ON m.Manager = del.Matricula
                                    INNER JOIN yifi58ge_dbUSUARIO.tblusuario mkt ON v.GestorMKT = mkt.Matricula
                                    INNER JOIN yifi58ge_dbUSUARIO.tblusuario ori ON v.GestorOrigen = ori.Matricula
                                    INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
                                    INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
                                    WHERE v.IdVenta = ?";
                                    
        try {
        
    $stmtCorreo = $con->prepare($sqlCorreoConfirmacion);
    $stmtCorreo->bind_param('i', $idventa);
    $stmtCorreo->execute();
    $stmtCorreo->store_result();
    $stmtCorreo->bind_result($MatriculaComercialCorreo,
$ComercialCorreo,
$DelegacionCorreo,
$MatriculaJefeVentaCorreo,
$CorreoComercialCorreo,
$PerfilComercialCorreo,
$CategoriaComercialCorreo,
$NombJefeVentaCorreo,
$CorreoJefeVentaCorreo,
$NombDelegadoCorreo,
$CorreoDelegadoCorreo,
$EstadoVisitaCorreo,
$EstadoVentaCorreo,
$TipoVentaCorreo,
$SegmentoCorreo,
$NProspectoCorreo,
$N590Correo,
$FechaVisitaCorreo,
$HoraVisitaCorreo,
$fobras,
$FVisitaObrasCorreo,
$FechaVisitaObrasDiaCorreo,
$FechaVisitaDiaCorreo,
$FVencimientoVisitaCorreo,
$OrigenVisitaCorreo,
$ComentarioVisitaCorreo,
$MesVisitaCorreo,
$LeadIDCorreo,
$GestorMKTCorreo,
$NombGestorMKTCorreo,
$CorreoOperadorCorreo,
$IdClienteCorreo,
$NombClienteCorreo,
$T1ClienteCorreo,
$T2ClienteCorreo,
$CorreoClienteCorreo,
$DirClienteCorreo,
$RefClienteCorreo,
$DistClienteCorreo,
$ProvClienteCorreo,
$IntClienteCorreo);
    $stmtCorreo->fetch();

            if($EstadoVisitaCorreo=='Asignada' || $EstadoVisitaCorreo=='Vendida' || $EstadoVisitaCorreo=='NoVendida'){
                $ObjCorreoAsignacion=EnvioCorreoAsignacion($idventa,$nprospecto,$tipoventa);
                insertarLogCorreo($idventa);
            }

            //SECURITY CHECK
            
            if(($CategoriaComercialCorreo!="DEL" || $CategoriaComercialCorreo!='JE' || $CategoriaComercialCorreo!='COACH') && ($DelegacionCorreo==100 || $DelegacionCorreo==151 || $DelegacionCorreo==152 || $DelegacionCorreo==153 || $DelegacionCorreo==154 || $DelegacionCorreo==155 || $DelegacionCorreo==156 || $DelegacionCorreo==159)){
                $AsignacionPlantilla="Apertura";
                $ObjCorreoM=EnvioCorreoSecurityCheck($idventa, $CorreoClienteCorreo);
                //$ObjCorreoM=NULL;
            }else{
                $ObjCorreoM=NULL;   
                $AsignacionPlantilla=NULL;
            }
            
            //LOG DE SECURITY CHECK
            insertarReasignacion($idventa);
            
            $resultado = [
                'resultado' => 'exito',
                'Cliente' => $updCliente,
                'Venta' => $updVenta
            ];



    
    
    
    $stmtCorreo->close();

 
    } catch (\Exception $e) {
      
    }
                                    
    

        
        
        } else {
            $resultado = [
                'resultado' => 'error',
                'Cliente' => $updCliente,
                'Venta' => $updVenta
            ];
        }

        if($CalidadGeo == 'NO' || $CalidadGeo == 'SINGEO'){
            correoNotificacionCalidadGeo($nprospecto, $asignadopor, $nombreOperadorCC, $CalidadGeo);
        }
        actualizarCalidadGeo($CalidadGeo);
        
        if($tipoventa == 'RE'){
            if($lbldcobjzonificacion != $dc && !($lbldcobjzonificacion == '' || $lbldcobjzonificacion == null)){
                enviarCorreoDifDelegacion();
            }
        }

        correoNotificacionCalidadVisita($nprospecto, $asignadopor, $nombreOperadorCC, $lblcalificarGestion);

    }
    
    
    echo json_encode($resultado);

    function actualizarVenta(){
        global $con;
        
        global $MatriculaUsuario;
        global $idusuario, $matricula, $nombcomercial, $lblcctc, $jefeventa, $categoria, $tipoventa, $segmento, $nprospecto, $estadoventa, $estvisita;
        global $fechagrabarfvisita, $horagrabarvisita, $fechagrabarvencimiento, $asignadopor, $origen, $comentariovisita, $dc, $mesvisita, $leadid, $fobras, $fechagrabarfvisitaObra;
        global $idventa;
        global $IdConsultaScoring, $PerfilScoring, $Accion, $txtMotivoDelegacion;
        global $lblcalificarGestion;
        global $fecharegistro;
        global $motivoasignacion;
        global $contactoasignacion,$cumpleranking;
        global $visePiso,$rubroNeg,$puertaCalle,$nobleParedes,$nobleTecho,$mcuadrados,$motivoInteres,$conSistema,$empresaSistema,$bancarizado,$segundaDireccion;
        
        
        if($estvisita == 'Asignada'){
            if($estadoventa != 'VAsignada'){
                $respuesta = 'Error en el update Venta';
                return $respuesta;
            }
        }
        
        try{
            $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa 
                                        SET  
                                            IdUsuario =?,
                                            Matricula =?,
                                            Comercial =?,
                                            CC =?,
                                            JefeVenta=?,
                                            CategoriaVenta=?,
                                            TipoVenta=?,
                                            Segmento=?,
                                            NProspecto=?,
                                            EstadoVenta=?,
                                            EstadoVisita=?,
                                            FechaVisita=?,
                                            HoraVisita=?,
                                            FVencimientoVisita=?,
                                            GestorMKT=?,
                                            OrigenVisita=?,
                                            ComentarioVisita=?,
                                            CCOriginal=?,
                                            MesVisita=?,
                                            LeadID=?,
                                            FObras=?,
                                            FVisitaObras=?,
                                            GestorOrigen=?,
                                            IdConsultaScoring=?,
                                            PerfilScoring=?,
                                            Accion=?, 
                                            MotivoDifDelegacion=?,
                                            CalificacionVisita=?,
                                            FechaHoraAsignacion=?,
                                            MotivoAsignacion=?,
                                            MatriculaOriginal=?,
                                            ContactoAsignacion=?,
                                            CumpleRanking=?,
                                            visePiso=?,
                                            rubroNeg=?,
                                            puertaCalle=?,
                                            nobleParedes=?,
                                            nobleTecho=?,
                                            metros=?,
                                            motivoInteres=?,
                                            conSistema=?,
                                            empresaSistema=?,
                                            bancarizado=?,
                                            segundaDireccion=?
                                        WHERE IdVenta = ?");
            $stmt->bind_param("issssssssssssssssssssssissssssssssssssdsssssi", $idusuario, $matricula, $nombcomercial, $dc, $jefeventa, $categoria, $tipoventa, $segmento, $nprospecto, $estadoventa, $estvisita, $fechagrabarfvisita, $horagrabarvisita, $fechagrabarvencimiento, $asignadopor, $origen, $comentariovisita, $dc, $mesvisita, $leadid, $fobras, $fechagrabarfvisitaObra, $MatriculaUsuario, $IdConsultaScoring, $PerfilScoring, $Accion, $txtMotivoDelegacion, $lblcalificarGestion, $fecharegistro,$motivoasignacion,$matricula,$contactoasignacion,$cumpleranking,$visePiso,$rubroNeg,$puertaCalle,$nobleParedes,$nobleTecho,$mcuadrados,$motivoInteres,$conSistema,$empresaSistema,$bancarizado,$segundaDireccion, $idventa);
            $stmt->execute();
    
            $rows = $stmt->affected_rows;
            
            if($rows > 0){
                $respuesta = 'Exito Update Venta';
            }
            
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = 'Error en el update Venta';
        }
        
        return $respuesta;

    }
    
    function insertarDocumento(){
        global $con;
        global $tipodoc, $documento, $fecharegistro;
        if(empty($tipodoc) && empty($documento)){
            return 0;
        }else{
            try {
        
              $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES(?, ?, ?)");
              $stmt->bind_param('sss', $tipodoc,$documento,$fecharegistro);
                $stmt->execute();
                $respuesta = $con->insert_id;
                $stmt->close();
            } catch (\Exception $e) {
                $respuesta = array(
                    'respuesta' => 'error'
                );
            }
        
            return $respuesta;
        }
    
    }
    
    function actualizarDocumento($IdDocVisita){
        global $con;
        global $tipodoc, $documento;
        if(empty($tipodoc) && empty($documento)){
            return 0;
        }else{
              try{
            $stmt = $con->prepare("UPDATE tbldocumento SET TipoDocumento=?, Documento=? WHERE IdDoc = ?");
            $stmt->bind_param('ssi', $tipodoc, $documento, $IdDocVisita);
            $stmt->execute();
            
            $respuesta = $stmt->affected_rows;
            
            $stmt->close();  
        } catch (\Exception $e) {
            $respuesta = 'error';
        }
        return $respuesta;  
        }
    }
    
    //Funcion nueva Cliente
    function actualizarClienteDoc($idcliente){
        global $con;
    
        global $nombcliente, $correo, $direccion, $distrito, $telefonouno, $telefonodos, $segmento,$IdDocVisita, $Referencia, $interior, $objGeofinder, $lbldireccionAprox, $lbltipoDireccion, $lblIdDireccion;
        global $idZonificacion, $objZonificacionVerisure;
        global $tiposegmento,$npiso,$tipovial;
        
        try{
            $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente 
                                        SET IdGeografico = ?, 
                                            NombApellido = ?, 
                                            Correo = ?, 
                                            Direccion = ?, 
                                            Telefonouno = ?, 
                                            Telefonodos=?, 
                                            Segmento=?, 
                                            IdDocVisita=?, 
                                            Referencia=?, 
                                            Interior=?, 
                                            objGeofinder=?, 
                                            DireccionAprox=?, 
                                            TipoDireccion=?,
                                            IdDireccion=?,
                                            IdZonificacion=?, 
                                            objZonificacion=?,
                                            TipoSegmento=?,
                                            NPiso=?,
                                            TipoVial=?
                                            WHERE IdCliente = ?");
            $stmt->bind_param("issssssisssssiissisi", $distrito, $nombcliente, $correo, $direccion, $telefonouno, $telefonodos, $segmento,$IdDocVisita, $Referencia, $interior, $objGeofinder, $lbldireccionAprox, $lbltipoDireccion, $lblIdDireccion, $idZonificacion, $objZonificacionVerisure,$tiposegmento,$npiso,$tipovial, $idcliente);
            $stmt->execute();
    
            $rows = $stmt->affected_rows;
    
            if ($rows > 0) {
                $respuesta = array(
                    'respuesta' => 'exito',
                    'id_actualizado' => $idcliente,
                    'tipo' => 'cliente'
                );
            } else {
                $respuesta = array(
                    'respuesta' => 'nada',
                    'tipo' => 'cliente'
                );
            }
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error',
                'mensaje' => $e->getMessage(),
                'tipo' => 'cliente'
            );
        }
    
        return $respuesta;
    }
    
    function actualizarCalidadGeo($CalidadGeo){
        global $con;
        global $lblIdDireccion;
        
        try {
            $stmt = $con->prepare("UPDATE tbltmpdirecciones SET CalidadGeo=? WHERE IdDireccion=?");
            $stmt->bind_param('si', $CalidadGeo, $lblIdDireccion);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
        
        //return $respuesta;
    }
    
    function EnvioCorreoAsignacion($idventa,$nprospecto,$tipoventa){
        
        //ESTRUCTURA DEL CORREO ACTUALIZADO
        //DELEGADO
        
        global $PerfilComercialCorreo;
        global $CategoriaComercialCorreo;
        
        global $CorreoComercialCorreo;
        global $CorreoJefeVentaCorreo;
        global $CorreoDelegadoCorreo;
        global $DelegacionCorreo;
        
        
        if($PerfilComercialCorreo == 17){
            
            if($CategoriaComercialCorreo == 'N1' || $CategoriaComercialCorreo == 'N2' || $CategoriaComercialCorreo == 'N3' || 
                $CategoriaComercialCorreo == 'N4' || $CategoriaComercialCorreo == 'N5' || $CategoriaComercialCorreo == 'N6' || 
                $CategoriaComercialCorreo == 'JE' || $CategoriaComercialCorreo == 'VET' || $CategoriaComercialCorreo == 'COACH' || 
                $CategoriaComercialCorreo == 'MST' || $CategoriaComercialCorreo == 'ELI/MST' ){
                    $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                    $correoAdministrativo2=$CorreoJefeVentaCorreo; //JEFE
                    $correoAdministrativo3=$CorreoDelegadoCorreo; //DELEGADO
            } else if ($CategoriaComercialCorreo == 'DEL'){
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=$CorreoJefeVentaCorreo; //JEFE
                $correoAdministrativo3=''; //DELEGADO
            } else if ($CategoriaComercialCorreo == 'GERENTE TERRITORIAL') {
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=''; //JEFE
                $correoAdministrativo3=''; //DELEGADO
            } else {
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=''; //JEFE
                $correoAdministrativo3=''; //DELEGADO
            }
        } else if ($PerfilComercialCorreo == 38){
            $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
            $correoAdministrativo2=''; //JEFE
            $correoAdministrativo3=''; //DELEGADO
        } else {
            $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
            $correoAdministrativo2=''; //JEFE
            $correoAdministrativo3=''; //DELEGADO            
        }
        
        //COPIA CORREO A LOS TERRITORIALES
    
        if($DelegacionCorreo == 150 || $DelegacionCorreo == 156 || $DelegacionCorreo == 157 || $DelegacionCorreo == 159 || $DelegacionCorreo == 252 || $DelegacionCorreo == 130 || $DelegacionCorreo == 151){
            $correoAdministrativo4="renzobranchi.branez@verisure.pe";
        } else if ($DelegacionCorreo == 152){
            $correoAdministrativo4="cristhian.cuneo@verisure.pe";
        } else if ($DelegacionCorreo == 120  || $DelegacionCorreo == 121  || $DelegacionCorreo == 140 || $DelegacionCorreo == 200){
            $correoAdministrativo4="juliocesar.rojas@verisure.pe";             
        } else if ($DelegacionCorreo == 40  || $DelegacionCorreo == 41  || $DelegacionCorreo == 80 || $DelegacionCorreo == 100 || $DelegacionCorreo == 230){
            $correoAdministrativo4="david.adell@verisure.pe";
        } else if ($DelegacionCorreo == 154 || $DelegacionCorreo == 155 || $DelegacionCorreo == 158 || $DelegacionCorreo == 152) {
            $correoAdministrativo4="monicamaria.sanchez@verisure.pe";
        }
        
        
        //$correoAdministrativo4="backoffice@verisure.pe";
        
        $copia1 = "CHRISTIAN.GUTIERREZ@VERISURE.PE";
        $copia2 = "SHIRLEY.CUADRA@VERISURE.PE";
        $copia3 = "MADELEYNE.MUNAYCO@VERISURE.PE";
        $copia4 = "diego.delabarra@verisure.pe";
        $copia5 = "lissett.mendoza@verisure.pe"; 
        
        $titulo="";
        if($tipoventa === 'RE'){
            $titulo="OPORTUNIDAD DE VENTA VISITA RE - ".$nprospecto." ";
        }else if($tipoventa === 'RPMKT'){
            $titulo = "OPORTUNIDAD DE VENTA VISITA RPMKT - ".$nprospecto." ";
        }else{
            $titulo=""; 
        }
        
        $opts = array(
        'http'=>array(
        'method'=>"GET",
        'header'=>"User-Agent: api script\r\n"
        ));
        $context = stream_context_create($opts);

        $curl = curl_init();
    
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => 'Sistema de Ventas Verismart - Verisure Perú',
            'From' => 'backoffice@verisure.pe',
            'To' => 
                    array (
                      'Email' => 
                      array (
                            0 => $correoAdministrativo1,
                            1 => $correoAdministrativo2,
                            2 => $correoAdministrativo3,
                            3 => $correoAdministrativo4
                      )
                    ),
            'Cc' => 
                    array (
                      'Email' => 
                      array (
                        0 => $copia1,
                        1 => $copia2,
                        2 => $copia3,
                        3 => $copia4,
                        4 => $copia5
                      )
                    ),
            'Bcc' => 
                    array (
                      'Email' => 
                      array (
                        0 => 'joseenrique.nanquen@verisure.pe',
                      )
                    ),
            'Message' => 
            array (
              'Subject' => $titulo,
              'Classification' => 'C',
              'Body' => 
              array (
                'Format' => 'html',
                'Value' => file_get_contents("https://www.verismart.com.pe/verismart/plantilla_asignacion_visita.php?idventa=$idventa",false,$context),
                
              )
            ),
            'Options' => 
            array (
              'OpenTracking' => 'true',
              'ClickTracking' => 'true',
              'TextHtmlTracking' => 'true',
              'AutoTextBody' => 'false',
            )
          )
        );
    
        $dataSC_string = json_encode($dataSC);
        
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => $dataSC_string,
          CURLOPT_HTTPHEADER => array(
            "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
            "cache-control: no-cache",
            "content-type: application/json"
          ),
        ));
    
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
          return "cURL Error #:" . $err;
        } else {
          return $response;
        }    
    
    }
    
    function insertarLogCorreo($idventa){
        global $con;
    
        global $ObjCorreoAsignacion,$fecharegistroventa;
         
            try {
        
              $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog_correo(IdVenta,ObjTransaccion,FechaHoraREG) VALUES(?,?,?)");
              $stmt->bind_param('iss', $idventa,$ObjCorreoAsignacion,$fecharegistroventa);
                $stmt->execute();
                $respuesta = $con->insert_id;
                $stmt->close();
            } catch (\Exception $e) {
                $respuesta = array(
                    'respuesta' => 'error'
                );
            }
        
            return $respuesta;
    
    }
    
    function EnvioCorreoSecurityCheck($idventa,$correocliente){
        $opts = array(
        'http'=>array(
        'method'=>"GET",
        'header'=>"User-Agent: api script\r\n"
        ));
        
        $context = stream_context_create($opts);
        
                
        $curl = curl_init();
        
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => 'Verisure Visitas',
            'From' => 'visitas@verisure.pe',
            'To' => 
            array (
              'Email' => 
              array (
                0 => $correocliente,
              )
            ),
            'Cc' => 
            array (
              'Email' => 
              array (
                0 => '',
              )
            ),
            'Bcc' => 
            array (
              'Email' => 
              array (
                0 => 'm.valenciaz@verisure.pe',
                1 => 'joseenrique.nanquen@verisure.pe',
              )
            ),
            'Message' => 
            array (
              'Subject' => '¡Hola! Ya tienes asignado al especialista de seguridad que te atenderá.',
              'Classification' => 'C',
              'Body' => 
              array (
                'Format' => 'html',
                'Value' => file_get_contents("https://www.verismart.com.pe/verismart/plantilla_securty_check_apertura.php?IdVenta=$idventa",false,$context),
              )
            ),
            'Options' => 
            array (
              'OpenTracking' => 'true',
              'ClickTracking' => 'true',
              'TextHtmlTracking' => 'true',
              'AutoTextBody' => 'false',
            )
          )
        );
        
        $dataSC_string = json_encode($dataSC);
        
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 60,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => $dataSC_string,
          CURLOPT_HTTPHEADER => array(
            "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
            "cache-control: no-cache",
            "content-type: application/json"
          ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
          return "cURL Error #:" . $err;
        } else {
          return $response;
        }
            
    
    }
    
    //PRIMERA ASIGNACION DE LA VISITA
    function insertarReasignacion($idventa){
        global $con;
    
        global $MatriculaComercialCorreo, $CategoriaComercialCorreo, $fecharegistroventa, $dc, $ObjCorreoM, $AsignacionPlantilla;
        $estadoasignacion='Apertura'; 
        
        try {
    
          $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblreasignacion(IdVenta,Matricula, Categoria, FechaAsignacion,CC,EstadoAsignacion,ObjCorreoM,AsignacionPlantilla) VALUES(?,?, ?, ?,?,?,?,?)");
          $stmt->bind_param('isssisss', $idventa,$MatriculaComercialCorreo,$CategoriaComercialCorreo,$fecharegistroventa,$dc,$estadoasignacion,$ObjCorreoM,$AsignacionPlantilla);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
    
        return $respuesta;
    
    }

    //Funciones para codificar al momento de grabar en Mysql
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }