<?php
include('is_logged.php');
require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

if (isset($_GET['ncliente']) && $_GET['ncliente'] <> '') {
    $ncliente = sanitizaCampo($_GET['ncliente'], 'sanitizeint|scapestring|htmlspecialchars', $con);
} else {
    $ncliente="NSP";
}

$arreglo = null;

if($ncliente=="NSP"){
    $arreglo[] = [ 'IdCliente'=>0,
        'NCliente'=>'',
        'NombApellido'=>'',
        'Direccion'=>'',
        'Telefonouno'=>'',
        'Telefonodos'=>'',
        'Distrito'=>'',
        'Provincia'=>'',
        'Correo'=>'',
        'Correodos'=>''];
    echo json_encode($arreglo);
    
} else {
    
    $sql="SELECT c.IdCliente,c.NCliente,c.NombApellido,c.Direccion,c.Telefonouno,c.Telefonodos,g.Distrito,g.Provincia,c.Correo,c.Correodos FROM yifi58ge_dbVENTAS.tblcliente c 
    INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico WHERE c.NCliente=?";
    
    	try{       
            $stmt = $con->prepare($query);
            $stmt->bind_param('i', $ncliente);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($IdCliente, $NCliente, $NombApellido, $Direccion, $Telefonouno, $Telefonodos, $Distrito, $Provincia, $Correo, $Correodos);
            
            if($stmt->num_rows > 0){
                while($stmt->fetch()){
                    $arreglo[]=array_map("utf8_encode",['IdCliente' => $IdCliente, 'NCliente' => $NCliente, 'NombApellido' => $NombApellido, 'Direccion' => $Direccion, 
                    'Telefonouno' => $Telefonouno, 'Telefonodos' => $Telefonodos, 'Distrito' => $Distrito, 'Provincia' => $Provincia, 'Correo' => $Correo, $Correodos => 'Correodos']);
                }
            }
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }    
    
echo json_encode($arreglo);
}