<?php

include('is_logged.php');
require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

$arraglo=NULL;

$idattec = sanitizaCampo($_GET['idattec'], 'sanitizestring|scapestring|htmlspecialchars', $con);
$query="SELECT
    att.FechaHoraREG,
    att.FechaInst,
    att.HoraInst,
    att.FechaAuditoria,
    att.Comentario as ComentarioAttec,    
    att.EstadoVenta,
    att.NContrato,
    att.GestorAgenda,
    att.EstadoAttec,
    att.DatosSbn,
    att.DatosSbn_NoCoincide,
    att.F_CorreccionDatosSbn,
    att.SegIncorrecto,
    att.F_CorreccionSegIncorrecto,
    att.Seg_DebeDecir,
    att.Imagen,
    att.F_Imagen,
    att.Imagen_Motivo,
    att.IngresoProgramacion,
    att.F_CorreccionIngresoProgramacion,
    att.FallosCobertura,
    att.F_CorreccionFallosCobertura,
    att.MissingTest,
    att.F_CorreccionMissingTest,
    att.ZeroVision,
    att.F_CorreccionZeroVision,
    att.FalloSupervision,
    att.F_CorreccionFalloSupervision,
    att.Tamper,
    att.F_CorreccionTamper,
    att.Zerovision_motivo
    from tblagendahist att
    WHERE att.IdAttec=? ORDER BY att.IdAgendaHist DESC";
    
    	try{       
            $stmt = $con->prepare($query);
            $stmt->bind_param('i', $idattec);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($FechaHoraREG, $FechaInst, $HoraInst, $FechaAuditoria, $ComentarioAttec, $EstadoVenta, $NContrato, $GestorAgenda, $EstadoAttec, $DatosSbn, $DatosSbn_NoCoincide, $F_CorreccionDatosSbn, $SegIncorrecto, $F_CorreccionSegIncorrecto, $Seg_DebeDecir, $Imagen,$F_Imagen, $Imagen_Motivo, $IngresoProgramacion, $F_CorreccionIngresoProgramacion, $FallosCobertura, $F_CorreccionFallosCobertura, $MissingTest, $F_CorreccionMissingTest, $ZeroVision, $F_CorreccionZeroVision, $FalloSupervision, $F_CorreccionFalloSupervision, $Tamper, $F_CorreccionTamper, $Zerovision_motivo);
            $resultado = $stmt->num_rows;
            if($stmt->num_rows > 0){
                while($stmt->fetch()){
                    $arraglo['datos'][] = array_map("utf8_encode",['FechaHoraREG' => $FechaHoraREG,
                        'FechaInst' => $FechaInst,
                        'HoraInst' => $HoraInst,
                        'FechaAuditoria' => $FechaAuditoria,
                        'ComentarioAttec' => $ComentarioAttec,
                        'EstadoVenta' => $EstadoVenta,
                        'NContrato' => $NContrato,
                        'GestorAgenda' => $GestorAgenda,
                        'EstadoAttec' => $EstadoAttec,
                        'DatosSbn' => $DatosSbn,
                        'DatosSbn_NoCoincide' => $DatosSbn_NoCoincide,
                        'F_CorreccionDatosSbn' => $F_CorreccionDatosSbn,
                        'SegIncorrecto' => $SegIncorrecto,
                        'F_CorreccionSegIncorrecto' => $F_CorreccionSegIncorrecto,
                        'Seg_DebeDecir' => $Seg_DebeDecir,
                        'Imagen' => $Imagen,
                        'Imagen_Motivo' => $Imagen_Motivo,
                        'IngresoProgramacion' => $IngresoProgramacion,
                        'F_CorreccionIngresoProgramacion' => $F_CorreccionIngresoProgramacion,
                        'FallosCobertura' => $FallosCobertura,
                        'F_CorreccionFallosCobertura' => $F_CorreccionFallosCobertura,
                        'MissingTest' => $MissingTest,
                        'F_CorreccionMissingTest' => $F_CorreccionMissingTest,
                        'ZeroVision' => $ZeroVision,
                        'F_CorreccionZeroVision' => $F_CorreccionZeroVision,
                        'FalloSupervision' => $FalloSupervision,
                        'F_CorreccionFalloSupervision' => $F_CorreccionFalloSupervision,
                        'Tamper' => $Tamper,
                        'F_CorreccionTamper' => $F_CorreccionTamper,
                        'Zerovision_motivo' => $Zerovision_motivo,
                        ]);
                }
            }
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        } 

if($resultado == 0){
    $arraglo['respuesta']='error';
    $arraglo['datos']='';
}else{
    if($resultado > 0){
        $arraglo['respuesta']='exito';
    }else{
        $arraglo['datos']='';
        $arraglo['respuesta']='sindatos';
    }
}

echo json_encode($arraglo);
