<?php
include('is_logged.php');
require_once '../config/db.php';
require_once '../config/conexion.php';


$query="SELECT v.IdVenta,
v.EstadoVenta,
v.TipoVenta,
v.CC DC,
u.IdUsuario,
u.Matricula,
CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
v.TCGestor,
v.Segmento,
v.NProspecto,
v.NContrato,
c.NombApellido Cliente,
v.CategoriaVenta,
v.PrecioKit,
v.TotalExtra,
v.ExtraAutorizado,
v.N590,
a.InstaladoX,
DATE_FORMAT(a.FechaInst, '%d/%m/%Y') FechaInst,
TIME_FORMAT(a.HoraInst,'%r') HoraInst,
DATE_FORMAT(f.FechaFacturacion, '%d/%m/%Y') FechaFacturacion,
DATE_FORMAT(f.FechaRecepcionDOC, '%d/%m/%Y') FechaRecepcionDOC,
f.MotivoIncidencia
FROM yifi58ge_dbVENTAS.tblventa v INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=v.IdUsuario 
INNER JOIN yifi58ge_dbVENTAS.tblagenda a ON a.IdVenta=v.IdVenta 
INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente 
INNER JOIN yifi58ge_dbVENTAS.tblfacturacion f on  f.IdVenta=v.IdVenta 
WHERE v.N590='Nov-2022' and (v.EstadoVenta='Instalada' OR v.EstadoVenta='Incidencia' OR v.EstadoVenta='NoDoc' OR v.EstadoVenta='Facturada' OR v.EstadoVenta='IncidenciaGestCorreo' OR v.EstadoVenta='IncidenciaGestValija' OR v.EstadoVenta='PorFacturar' OR v.EstadoVenta='DocEnvi')";

    try{
        $stmt = $con->prepare($query);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdVenta,
$EstadoVenta,
$TipoVenta,
$DC,
$IdUsuario,
$Matricula,
$Comercial,
$TCGestor,
$Segmento,
$NProspecto,
$NContrato,
$Cliente,
$CategoriaVenta,
$PrecioKit,
$TotalExtra,
$ExtraAutorizado,
$N590,
$InstaladoX,
$FechaInst,
$HoraInst,
$FechaFacturacion,
$FechaRecepcionDOC,
$MotivoIncidencia);
        $arreglo = [];        
        while ($stmt->fetch()){
        $arreglo[] = array_map("utf8_encode",[
        'IdVenta'=>$IdVenta,
        'EstadoVenta'=>$EstadoVenta,
        'TipoVenta'=>$TipoVenta,
        'DC'=>$DC,
        'IdUsuario'=>$IdUsuario,
        'Matricula'=>$Matricula,
        'Comercial'=>$Comercial,
        'TCGestor'=>$TCGestor,
        'Segmento'=>$Segmento,
        'NProspecto'=>$NProspecto,
        'NContrato'=>$NContrato,
        'Cliente'=>$Cliente,
        'CategoriaVenta'=>$CategoriaVenta,
        'PrecioKit'=>$PrecioKit,
        'TotalExtra'=>$TotalExtra,
        'ExtraAutorizado'=>$ExtraAutorizado,
        'N590'=>$N590,
        'InstaladoX'=>$InstaladoX,
        'FechaInst'=>$FechaInst,
        'HoraInst'=>$HoraInst,
        'FechaFacturacion'=>$FechaFacturacion,
        'FechaRecepcionDOC'=>$FechaRecepcionDOC,
        'MotivoIncidencia'=>$MotivoIncidencia
            ]);            
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        die("Error");
    }

echo json_encode($arreglo);

