<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include dirname(__DIR__).'/helper/helper_validacion.php';

$q=NULL;

if (isset($_GET['q'])) {
    $q=sanitizaCampo($_GET['q'],'sanitizestring|scapestring|htmlspecialchars',$con);
}


    try{
        $q = "%{$q}%";
        $stmt = $con->prepare( "SELECT g.IdGeografico,g.Distrito,g.Provincia,p.IdProvincial,p.IdDepartamental,g.CodUbigeoReniec FROM yifi58ge_dbVENTAS.tblgeografico g
        LEFT JOIN yifi58ge_dbVENTAS.tbldistrital dd on dd.CodUbigeoReniec=g.CodUbigeoReniec
        LEFT JOIN yifi58ge_dbVENTAS.tblprovincial p on p.IdProvincial=dd.IdProvincial
		WHERE g.Estado='Activo' and g.Field='SI' and g.Distrito LIKE ?");
        $stmt->bind_param('s', $q);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdGeografico,$Distrito,$Provincia,$IdProvincial,$IdDepartamental,$CodUbigeoReniec);
        $json = [];        
        while ($stmt->fetch()){
        $json[] = array_map("utf8_encode",['id'=>$IdGeografico, 'text'=>$Distrito." - ".$Provincia,'IdProvincial'=>$IdProvincial,'IdDepartamental'=>$IdDepartamental,'CodUbigeoReniec'=>$CodUbigeoReniec]);         
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

echo json_encode($json);


