<?php

    function consultaTeleventa($id){
        
       global $con;
        $arrayactual = null;

  try{
        $stmt = $con->prepare( "SELECT 
        v.CategoriaVenta,
        v.EstadoVenta,
        v.N590,
        v.EstadoTelecierre,
        v.TCTipoVenta,
        v.TCMotivoNoVenta,
        v.CC,
        v.TCGestor,
        v.PrecioKit,
        v.TotalExtra,
        v.IngresoKIT,
        v.IngresoExtras,
        v.IngresoTotal,
        v.ExtraAutorizado,
        v.MesesAutorizado,
        v.FormaPago,
        v.PAI,
        v.ResumenVenta,
        v.TCComentario,
        v.EstadoVisita,
        v.TCScoring,
        v.TCCompetencia,
        v.NProspecto,
        v.NProspectoCC,
        v.MesTeleventa,
        v.LeadID
        FROM tblventa v
        WHERE v.IdVenta= ?");
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($CategoriaVenta,
            $EstadoVenta,
            $N590,
            $EstadoTelecierre,
            $TCTipoVenta,
            $TCMotivoNoVenta,
            $CC,
            $TCGestor,
            $PrecioKit,
            $TotalExtra,
            $IngresoKIT,
            $IngresoExtras,
            $IngresoTotal,
            $ExtraAutorizado,
            $MesesAutorizado,
            $FormaPago,
            $PAI,
            $ResumenVenta,
            $TCComentario,
            $EstadoVisita,
            $TCScoring,
            $TCCompetencia,
            $NProspecto,
            $NProspectoCC,
            $MesTeleventa,
            $LeadID
            );
        while ($stmt->fetch()){
            $arrayactual = array(
            'CategoriaVenta'=>$CategoriaVenta,
            'EstadoVenta'=>$EstadoVenta,
            'N590'=>$N590,
            'EstadoTelecierre'=>$EstadoTelecierre,
            'TCTipoVenta'=>$TCTipoVenta,
            'TCMotivoNoVenta'=>$TCMotivoNoVenta,
            'CC'=>$CC,
            'TCGestor'=>$TCGestor,
            'PrecioKit'=>$PrecioKit,
            'TotalExtra'=>$TotalExtra,
            'IngresoKIT'=>$IngresoKIT,
            'IngresoExtras'=>$IngresoExtras,
            'IngresoTotal'=>$IngresoTotal,
            'ExtraAutorizado'=>$ExtraAutorizado,
            'MesesAutorizado'=>$MesesAutorizado,
            'FormaPago'=>$FormaPago,
            'PAI'=>$PAI,
            'ResumenVenta'=>$ResumenVenta,
            'TCComentario'=>$TCComentario,
            'EstadoVisita'=>$EstadoVisita,
            'TCScoring'=>$TCScoring,
            'TCCompetencia'=>$TCCompetencia,
            'NProspecto'=>$NProspecto,
            'NProspectoCC'=>$NProspectoCC,
            'MesTeleventa'=>$MesTeleventa,
            'LeadID'=>$LeadID
                );
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

        return $arrayactual;
        
        
    }
    
    function consultaTeleventaI(){
        
        $arrayactual = null;
        
        $arrayactual = array(
                    'IdUsuario' => '',
                    'IdCliente' => '',
                    'Matricula' => '',
                    'Comercial' => '',
                    'CC' => '',
                    'JefeVenta' => '',
                    'CategoriaVenta' => '',
                    'TipoVenta' => '',
                    'Segmento' => '',
                    'NProspectoCC' => '',
                    'PrecioKit' => '0.00',
                    'TotalExtra' => '0.00',
                    'IngresoKIT' => '0.00',
                    'IngresoExtras' => '0.00',
                    'IngresoTotal' => '0.00',
                    'EstadoVenta' => '',
                    'ExtraAutorizado' => '',
                    'MesesAutorizado' => '0.00',
                    'N590' => '',
                    'FormaPago' => '',
                    'PAI' => '',
                    'ResumenVenta' => '',
                    'FechaHoraREG' => '',
                    'GestorOrigen' => '',
                    'CCOriginal' => '',
                    'PrecioKITOriginal' => '0.00',
                    'TotalExtraOriginal' => '0.00',
                    'ExtraAutorizadoOriginal' => '',
                    'MesesAutorizadoOriginal' => '0.00',
                    'FormaPagoOriginal' => '',
                    'PAIOriginal' => '',
                    'ResumenVentaOriginal' => '',
                    'TCTipoVenta' => '',
                    'TCGestor' => '',
                    'EstadoTelecierre' => '',
                    'TipoTV' => '',
                    'GestorMKT' => '',
                    'MesTeleventa' => '',
                    'LeadID' => ''
                );
                
        return $arrayactual;
    }
    
    function insertLogTeleventa($idLogSeg, $actual){
        global $con;
        
        //TRAER VARIABLES POST
        global $idventa;
        global $categoria;
        global $estadoventa;
        global $n590;
        global $estadotelecierre;
        global $tipoventatc;
        global $movivonoventatc;
        global $cctc;
        global $gestortc;
        global $preciokittc;
        $preciokittc = number_format($preciokittc,2,'.','');
        global $totalextratc;
        $totalextratc = number_format($totalextratc,2,'.','');
        global $ingresokit;
        $ingresokit = number_format($ingresokit,2,'.','');
        global $ingresoextras;
        $ingresoextras = number_format($ingresoextras,2,'.','');
        global $ingresototal;
        $ingresototal = number_format($ingresototal,2,'.','');
        global $extraautorizadotc;
        global $mesesautorizadostc;
        $mesesautorizadostc = number_format($mesesautorizadostc,2,'.','');
        global $formadepagotc;
        global $PAItc;
        global $resumenventatc;
        global $comentariotc;
        global $estadovisita;
        global $tcscoring;
        global $tccompetencia;
        global $nprospecto;
        global $nprospectocc;
        global $mesteleventa;
        global $leadid;
        
        $idventa=htmlspecialchars($idventa);


        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
        $nuevo = array(
        'CategoriaVenta' => $categoria,
        'EstadoVenta' => $estadoventa,
        'N590' => $n590,
        'EstadoTelecierre' => $estadotelecierre,
        'TCTipoVenta' => $tipoventatc,
        'TCMotivoNoVenta' => $movivonoventatc,
        'CC' => $cctc,
        'TCGestor' => $gestortc,
        'PrecioKit' => $preciokittc,
        'TotalExtra' => $totalextratc,
        'IngresoKIT' => $ingresokit,
        'IngresoExtras' => $ingresoextras,
        'IngresoTotal' => $ingresototal,
        'ExtraAutorizado' => $extraautorizadotc,
        'MesesAutorizado' => $mesesautorizadostc,
        'FormaPago' => $formadepagotc,
        'PAI' => $PAItc,
        'ResumenVenta' => $resumenventatc,
        'TCComentario' => $comentariotc,
        'EstadoVisita' => $estadovisita,
        'TCScoring' => $tcscoring,
        'TCCompetencia' => $tccompetencia,
        'NProspecto' => $nprospecto,
        'NProspectoCC' => $nprospectocc,
        'MesTeleventa' => $mesteleventa,
        'LeadID' => $leadid
            );
            
        $RegActual = array_diff_assoc($actual, $nuevo);
        $RegNuevo = array_diff_assoc($nuevo, $actual);
        
        $RegActual = json_encode($RegActual);
        $RegNuevo = json_encode($RegNuevo);
        
        unset($actual);
        unset($nuevo);
        
        $tabla = "tblventa";
        $url = htmlspecialchars($_SERVER['REQUEST_URI'])."=>IdVenta='".$idventa."'";
        $usuariolog=$_SESSION['usuariosesion'];
        $identificador=$idventa;
        $accion="Modificar";
        
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $identificador, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
        $IdLogTrans = $con->insert_id;
        
        $RegNuevo=json_decode($RegNuevo, true);
        
        if(array_key_exists('EstadoTelecierre', $RegNuevo)){
            $nombestadoLog="EstadoTelecierre";
            $estadolog=$RegNuevo['EstadoTelecierre'];
            $matriculalog=$gestortc;
            $cclog=$cctc;
            $jefeventalog=NULL;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$identificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        if(array_key_exists('EstadoVenta', $RegNuevo)){
            $nombestadoLog="EstadoVenta";
            $estadolog=$RegNuevo['EstadoVenta'];
            $matriculalog=$gestortc;
            $cclog=$cctc;
            $jefeventalog=NULL;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$identificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        unset($RegActual);
        unset($RegNuevo);
    }
    
    function insertLogTeleventaI($idLogSeg, $actual){
        global $con;
        
        //TRAER VARIABLES POST
        global $idVen;
                
                
        global $idusuario;
        global $idCli;
        global $matricula;
        global $nombcomercial;
        global $dc;
        global $jefeventa;
        global $categoria;
        global $tipoventa;
        global $segmento;
        global $nprospecto;
        global $preciokit;
        $preciokit = number_format($preciokit,2,'.','');
        global $totalextra;
        $totalextra = number_format($totalextra,2,'.','');
        global $ingresokit;
        $ingresokit = number_format($ingresokit,2,'.','');
        global $ingresoextras;
        $ingresoextras = number_format($ingresoextras,2,'.','');
        global $ingresototal;
        $ingresototal = number_format($ingresototal,2,'.','');
        global $estadoventa;
        global $extraautorizado;
        global $mesesautorizados;
        $mesesautorizados = number_format($mesesautorizados,2,'.','');
        global $n590;
        global $formadepago;
        global $PAI;
        global $resumenventa;
        global $fecharegistroventa;
        global $matriculausuario;
        global $TCTipoVenta;
        global $estadotelecierre;
        global $tipotvz;
        global $asignado;
        global $mesteleventa;
        global $leadid;
        
        $idVen=htmlspecialchars($idVen);


        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
        $nuevo = array(
        'IdUsuario' => $idusuario,
'IdCliente' => $idCli,
'Matricula' => $matricula,
'Comercial' => $nombcomercial,
'CC' => $dc,
'JefeVenta' => $jefeventa,
'CategoriaVenta' => $categoria,
'TipoVenta' => $tipoventa,
'Segmento' => $segmento,
'NProspectoCC' => $nprospecto,
'PrecioKit' => $preciokit,
'TotalExtra' => $totalextra,
'IngresoKIT' => $ingresokit,
'IngresoExtras' => $ingresoextras,
'IngresoTotal' => $ingresototal,
'EstadoVenta' => $estadoventa,
'ExtraAutorizado' => $extraautorizado,
'MesesAutorizado' => $mesesautorizados,
'N590' => $n590,
'FormaPago' => $formadepago,
'PAI' => $PAI,
'ResumenVenta' => $resumenventa,
'FechaHoraREG' => $fecharegistroventa,
'GestorOrigen' => $matriculausuario,
'CCOriginal' => $dc,
'PrecioKITOriginal' => $preciokit,
'TotalExtraOriginal' => $totalextra,
'ExtraAutorizadoOriginal' => $extraautorizado,
'MesesAutorizadoOriginal' => $mesesautorizados,
'FormaPagoOriginal' => $formadepago,
'PAIOriginal' => $PAI,
'ResumenVentaOriginal' => $resumenventa,
'TCTipoVenta' => $TCTipoVenta,
'TCGestor' => $matricula,
'EstadoTelecierre' => $estadotelecierre,
'TipoTV' => $tipotvz,
'GestorMKT' => $asignado,
'MesTeleventa' => $mesteleventa,
'LeadID' => $leadid

            );
            
        $RegActual = [];
        $RegNuevo = array_diff_assoc($nuevo, $actual);
        
        $RegActual = json_encode($RegActual);
        $RegNuevo = json_encode($RegNuevo);
        
        unset($actual);
        unset($nuevo);
        
        $tabla = "tblventa";
        $url = htmlspecialchars($_SERVER['REQUEST_URI'])."=>IdVenta='".$idVen."'";
        $usuariolog=$_SESSION['usuariosesion'];
        $identificador=$idVen;
        $accion="Registrar";
        
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $identificador, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
        $IdLogTrans = $con->insert_id;
        
        $RegNuevo=json_decode($RegNuevo, true);
        
        if($IdLogTrans>0){
            $nombestadoLog="EstadoTelecierre";
            $estadolog="RegistroTeleventa";
            $matriculalog=$matricula;
            $cclog=$dc;
            $jefeventalog=$jefeventa;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$identificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        
        unset($RegActual);
        unset($RegNuevo);
    }
    
    
    //GESTORES SELECCIONADOS PARA TV

    function consultaGestorTV($SelectedIds){
        
        global $con;
        
        $sql = "SELECT IdVenta, TCGestor FROM tblventa WHERE IdVenta IN (".$SelectedIds.")";
        $resultado = $con->query($sql);
        
        $arrayactual = [];
        
        $i=0;
        
        while ($Gestores = $resultado->fetch_assoc()){
            $arrayactual += [
                    $i => ['IdVenta' => $Gestores['IdVenta'], 'TCGestor'=>$Gestores['TCGestor'] ] 
                ];
                
            $i++;
        }
        
        return $arrayactual;
}

    function consultaGestorTVLEAD($SelectedIds){
        
        global $con;
        
        $sql = "SELECT IdLead, TCGestor FROM tblventa WHERE IdLead IN (".$SelectedIds.")";
        $resultado = $con->query($sql);
        
        $arrayactual = [];
        
        $i=0;
        
        while ($Gestores = $resultado->fetch_assoc()){
            $arrayactual += [
                    $i => ['IdLead' => $Gestores['IdLead'], 'TCGestor'=>$Gestores['TCGestor'] ] 
                ];
                
            $i++;
        }
        
        return $arrayactual;
}


    function insertLogGestorTV($idLogSeg, $actual){
    global $con;
    
    $id_usuario = $_SESSION['id_usuario'];
    $fechaactual = date("Y-m-d H:i:s");
    
    global $cboGestorTV;
    global $selectrows;
    
    $nuevo = array(
            'TCGestor' => $cboGestorTV
        );
        
    $RegActual = json_encode($actual);
    $RegNuevo = json_encode($nuevo);
    $tabla = "tblventa";
    $url = "".$_SERVER['REQUEST_URI']."=>IdVenta={".$selectrows."}";
    
    $usuariolog=$_SESSION['usuariosesion'];
    $identificador=NULL;
    $accion="Modificar";
    
    StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $identificador, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
}

    function insertLogGestorTVLEAD($idLogSeg, $actual){
    global $con;
    
    $id_usuario = $_SESSION['id_usuario'];
    $fechaactual = date("Y-m-d H:i:s");
    
    global $cboGestorTV;
    global $selectrows;
    
    $nuevo = array(
            'TCGestor' => $cboGestorTV
        );
        
    $RegActual = json_encode($actual);
    $RegNuevo = json_encode($nuevo);
    $tabla = "tblventa";
    $url = "".$_SERVER['REQUEST_URI']."=>IdLead={".$selectrows."}";
    
    $usuariolog=$_SESSION['usuariosesion'];
    $identificador=NULL;
    $accion="Modificar";
    
    StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $identificador, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
}
    
    function consultaPrioridadTV($SelectedIds){
    
        global $con;
        
        $sql = "SELECT IdVenta, Prioridad FROM tblventa WHERE IdVenta IN (".$SelectedIds.")";
        $resultado = $con->query($sql);
        
        $arrayactual = [];
        
        $i=0;
        
        while ($Prioridades = $resultado->fetch_assoc()){
            $arrayactual += [
                    $i => ['IdVenta' => $Prioridades['IdVenta'], 'Prioridad'=>$Prioridades['Prioridad'] ] 
                ];
                
            $i++;
        }
        
        return $arrayactual;
    }
    
    function insertPrioridadTV($idLogSeg, $actual){
        global $con;
        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
        global $cboPrioridadTV;
        global $selectrows;
        
        $nuevo = array(
                'Prioridad' => $cboPrioridadTV
            );
            
        $RegActual = json_encode($actual);
        $RegNuevo = json_encode($nuevo);
        $tabla = "tblventa";
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta={".$selectrows."}";
        
        $usuariolog=$_SESSION['usuariosesion'];
        $identificador=NULL;
        $accion="Modificar";
        
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $identificador, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
    }
    
    function consultaHabilitarTV($SelectedIds){
    
        global $con;
        
        $sql = "SELECT IdVenta, HabilitadoTV FROM tblventa WHERE IdVenta IN (".$SelectedIds.")";
        $resultado = $con->query($sql);
        
        $arrayactual = [];
        
        $i=0;
        
        while ($Habilitado = $resultado->fetch_assoc()){
            $arrayactual += [
                    $i => ['IdVenta' => $Habilitado['IdVenta'], 'HabilitadoTV'=>$Habilitado['HabilitadoTV'] ] 
                ];
                
            $i++;
        }
        
        return $arrayactual;
    }
    
    function insertHabilitarTV($idLogSeg, $actual){
        global $con;
        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
        global $hidden_checki;
        global $selectrows;
        
        $nuevo =    array(
                        'HabilitadoTV' => $hidden_checki
                    );
            
        $RegActual = json_encode($actual);
        $RegNuevo = json_encode($nuevo);
        $tabla = "tblventa";
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta={".$selectrows."}";
        
        $usuariolog=$_SESSION['usuariosesion'];
        $identificador=NULL;
        $accion="Modificar";
        
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $identificador, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
    }
    
?>