<?php

include('is_logged.php');

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require_once '../config/db.php';
require_once '../config/conexion.php';


$fecha_mes=htmlspecialchars($_POST['lbln590']);
$id = htmlspecialchars($_POST['lblidjebu']);
$lblcondicion=htmlspecialchars($_POST['lblcondicion']);
$cantje=htmlspecialchars($_POST['lblcantje']);
$fecharegistro = date('Y-m-d H:i:s', time());
$origen=$_SESSION['matriculausuario'];


if($lblcondicion=="Actualizar"){

    try{
        $stmt = $con->prepare( "SELECT jd.IdTmpBudgetJE,jd.IdUsuario,jd.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Comercial,jd.CC,jd.Manager,jd.Categoria,jd.MesBudget,jd.Budget  FROM tbltmpbudgetjefatura jd INNER JOIN yifi58ge_dbUSUARIO.tblusuario u on u.Matricula=jd.Matricula WHERE jd.MesBudget=? and jd.FechaHoraREG=(SELECT MAX(jde.FechaHoraREG) FROM tbltmpbudgetjefatura jde ORDER by jde.FechaHoraREG DESC) order by FIELD(jd.CC,150,151,152,153,154,155,120,40,41,511,512)");
        $stmt->bind_param('s', $fecha_mes);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdTmpBudgetJE,
            $IdUsuario,
            $Matricula,
            $Comercial,
            $CC,
            $Manager,
            $Categoria,
            $mesbudget,
            $budget);
        if($stmt->num_rows>0){
            while($stmt->fetch()){
            $budgetnuevo=htmlspecialchars($_POST[$Matricula]);
            
                if($budget==$budgetnuevo && $mesbudget==$fecha_mes){
               //nada 
                }else{
                    try{
                        $stmtUp = $con->prepare( "UPDATE tbltmpbudgetjefatura jd SET jd.Budget=? WHERE jd.IdTmpBudgetJE=?");
                        $stmtUp->bind_param('si', $budgetnuevo,$IdTmpBudgetJE);
                        $stmtUp->execute();
                        $stmtUp->close();
                
                    } catch(PDOException $e) {
                        echo "Error: " . $e->getMessage();
                    }  
                    
                }  
            }
            echo 1;
        }else{
            echo 3;
        }        
        

        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
    

    $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
    $usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
    $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI']);
    $Acceso='Modificar';
    $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
    
    try {
            
      $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
      $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
      $stmt->execute();
      $stmt->close();
      
    } catch (\Exception $e) {
      echo $e->getMessage();
    }

}
else if($lblcondicion=="Registrar"){

    try{
        $stmt = $con->prepare( "SELECT u.IdUsuario,u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Comercial,u.CC,u.Manager,u.Categoria FROM yifi58ge_dbUSUARIO.tblusuario u WHERE (u.Categoria='JE' or u.Categoria='COACH') AND u.Estado='Activo' order by FIELD(u.CC,150,151,152,153,154,155,120,40,41,511,512)");
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdUsuario,
            $Matricula,
            $Comercial,
            $CC,
            $Manager,
            $Categoria);

        if($stmt->num_rows>0){
            while($stmt->fetch()){
            $budget=htmlspecialchars($_POST[$Matricula]);

                    try{
                        $stmtIn = $con->prepare( "INSERT INTO tbltmpbudgetjefatura(IdUsuario,Matricula,Categoria,CC,Manager,FechaHoraREG,Origen,MesBudget,Budget) VALUES (?,?,?,?,?,?,?,?,?)");
                        $stmtIn->bind_param('ississsss', $IdUsuario
                            ,$Matricula
                            ,$Categoria
                            ,$CC
                            ,$Manager
                            ,$fecharegistro
                            ,$origen
                            ,$fecha_mes
                            ,$budget);
                        $stmtIn->execute();
                        $stmtIn->close();
                
                    } catch(PDOException $e) {
                        echo "Error: " . $e->getMessage();
                    } 
            
            }
            echo 2;
        }else{
            echo 3;
        }
        
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

    $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
    $usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
    $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI']);
    $Acceso='Modificar';
    $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
    
    try {
            
      $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
      $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
      $stmt->execute();
      $stmt->close();
      
    } catch (\Exception $e) {
      echo $e->getMessage();
    }



}



