<?php

include('is_logged.php');

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require_once '../config/db.php';
require_once '../config/conexion.php';

require_once '../helper/helper_validacion.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

//LOGS TRANSACCCIONALES
include 'log/insertLog.php'; //LOG TRANSAC
include 'log/insertLogTransaccional.php'; //LOG TRANSACCION

$matriculausuario=htmlspecialchars($_POST['gestororigen']);
$idventa=htmlspecialchars($_POST['idventa']);
$tipopago=htmlspecialchars($_POST['tipopago']);
$mediopago=htmlspecialchars($_POST['mediopago']);
$fecharegistro = date("Y-m-d H:i:s");
$correo=htmlspecialchars($_POST['correo']);

$respuesta = array(); //creamos un array 


    try{

        $stmt = $con->prepare( "select LAST_INSERT_ID(m.IdMdp) as last,m.URL,m.FechaVencimiento,m.EstadoURL,CURDATE() fechahoy,m.HoraVencimiento, time_format(ADDTIME(sysdate(),'02:00:00'),'%H:%i:%s') horahoy,m.CantidadTransaccion, COUNT(t.IdMdp) transarealizadas  from yifi58ge_dbVENTAS.tblmdp m LEFT JOIN yifi58ge_dbVENTAS.tbltransaccion t on t.IdMdp=m.IdMdp WHERE m.EstadoURL='Activo' and m.Area='Venta' GROUP BY m.IdMdp order by m.IdMdp desc limit 1");
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($last,
$URL,
$FechaVencimiento,
$EstadoURL,
$fechahoy,
$HoraVencimiento,
$horahoy,
$CantidadTransaccion,
$transarealizadas);
        $nums=$stmt->num_rows;
        $stmt->fetch();
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

if($nums==0){
        $respuesta=array(
        "URL"=>'vacio',
        "resultado"=>2,
        "mostrar"=>'<div class="callout callout-danger">
                <span class="pull-left">
                    <img src="admin/dist/img/noresults-img.png" style="width: 70%"> </span>
                    <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
               <strong>Lo sentimos, pero por el momento no se encuentra ninguna URL activa.</strong><br>
                 <p>Comunicarse con mediosdepago@verisure.pe <br><i class="fa fa-phone"></i>&nbsp 514 7315 (Opción 2)</p>
                    </div>'
    );
    
}

else{


    if($fechahoy<=$FechaVencimiento){
        
        
        if(($fechahoy.' '.$horahoy)<=($FechaVencimiento.' '.$HoraVencimiento)){
            
            if($transaccionesrealizadas<$CantidadTransaccion){
            $arrayTransaccion=consultaTransaccionI();
            if($tipopago=="WEB"){

            try{
                $stmt = $con->prepare( "INSERT INTO yifi58ge_dbVENTAS.tbltransaccion(IdVenta,IdMdp,FechaHoraREG,GestorOrigen,TipoPago,TarjetaMarca,CorreoBilling) VALUES (?,?,?,?,?,?,?)");
                $stmt->bind_param('iisssss', $idventa,$last,$fecharegistro,$matriculausuario,$tipopago,$mediopago,$correo);
                $stmt->execute();
                $idTransaccion = $con->insert_id;
                
                 $respuesta=array(
                "URL"=>$URL,
                "resultado"=>1,
                "mostrar"=>'<div class="callout callout-success">
                            <h4><i class="fa fa-bullhorn"></i> ¡IMPORTANTE!</h4>
                       <strong>Se ha redirigido a la página de '.$mediopago.' .</strong><br>
                        <p>&nbsp;</p>
                           </div>'
            );
                
        
                $stmt->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }
                
                 }else{

            try{
                $stmt = $con->prepare( "INSERT INTO yifi58ge_dbVENTAS.tbltransaccion(IdVenta,IdMdp,FechaHoraREG,GestorOrigen,TipoPago,TarjetaMarca,CorreoBilling) VALUES (?,?,?,?,?,?,?)");
                $stmt->bind_param('iisssss', $idventa,$last,$fecharegistro,$matriculausuario,$tipopago,$mediopago,$correo);
                $stmt->execute();
                $idTransaccion = $con->insert_id;
                $stmt->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }

            try{
                $stmt = $con->prepare( "SELECT v.NProspecto,v.NContrato,v.PrecioKit,c.NombApellido,v.TotalExtra,SUM(v.PrecioKit+v.TotalExtra) MontoTotal,v.CC FROM  yifi58ge_dbVENTAS.tblventa v INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente  WHERE v.IdVenta=?");
                $stmt->bind_param('i', $idventa);
                $stmt->execute();
                $stmt->store_result();
                $stmt->bind_result($NProspecto,$NContrato,$PrecioKit,$Cliente,$TotalExtra,$MontoTotal,$CCBilling);
                $stmt->fetch();
                $stmt->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }

         //Envio de correo
         
           $correo_administrativo=$correo;
    
        $para = '' . $correo_administrativo .'';

    $titulo = "SOLICITUD DE PAGO POR VISANET";


$mensaje ='
<html>

<head>

<title>Verisure Perú</title>
<link href="https://fonts.googleapis.com/css?family=Fira+Sans:400,700" rel="stylesheet"> 
<style>

 @font-face
	{font-family:"Cambria Math";
	panose-1:2 4 5 3 5 4 6 3 2 4;
	mso-font-charset:0;
	mso-generic-font-family:roman;
	mso-font-pitch:variable;
	mso-font-signature:-536870145 1107305727 0 0 415 0;}
@font-face
	{font-family:Calibri;
	panose-1:2 15 5 2 2 2 4 3 2 4;
	mso-font-charset:0;
	mso-generic-font-family:swiss;
	mso-font-pitch:variable;
	mso-font-signature:-536870145 1073786111 1 0 415 0;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
	{mso-style-unhide:no;
	mso-style-qformat:yes;
	mso-style-parent:"";
	margin:0cm;
	margin-bottom:.0001pt;
	mso-pagination:widow-orphan;
	font-size:11pt;
	font-family:Arial,"serif";
	mso-fareast-font-family:Calibri;
	mso-fareast-theme-font:minor-latin;}
.MsoChpDefault
	{mso-style-type:export-only;
	mso-default-props:yes;
	font-size:10.0pt;
	mso-ansi-font-size:10.0pt;
	mso-bidi-font-size:10.0pt;}
@page WordSection1
	{size:612.0pt 792.0pt;
	margin:70.85pt 3.0cm 70.85pt 3.0cm;
	mso-header-margin:36.0pt;
	mso-footer-margin:36.0pt;
	mso-paper-source:0;}
div.WordSection1
	{page:WordSection1;}

</style>

</head>

<body bgcolor=white lang=ES-PE link=blue vlink=purple style="tab-interval:35.4pt">

<div class=WordSection1>

<p class=MsoNormal><o:p> </o:p></p>

<div align=center>

<table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=700
 style="width:525.0pt;mso-cellspacing:0cm;background:white;mso-yfti-tbllook:
 1184;mso-padding-alt:0cm 0cm 0cm 0cm">
 <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
  <td style="padding:0cm 0cm 0cm 0cm">
  <p class=MsoNormal><span style="mso-fareast-font-family:Arial"><img
  width=180 id="_x0000_i1025"
  src="https://www.verismart.com.pe/verismart/img/email/logo.png"><o:p></o:p></span></p>
  </td>
  <td style="padding:0cm 0cm 0cm 0cm">
  <p class=MsoNormal align=right style="text-align:right"><span
  style="color:#606060;font-size:8.5pt;font-family:Arial,Helvetica,sans-serif;mso-fareast-font-family:Arial">SOMOS
  <b>LA ALARMA MÁS RECOMENDADA</b> DEL MERCADO*<o:p></o:p></span></p>
  </td>
 </tr>
</table>

</div>

<p class=MsoNormal><span style="font-family:Arial;mso-fareast-font-family:
Arial;color:#606060"><o:p>&nbsp;</o:p></span></p>

<div align=center>

<table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=700
 style="width:530pt;mso-cellspacing:0cm;background:white;mso-yfti-tbllook:
 1184;mso-padding-alt:0cm 0cm 0cm 0cm">
 <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
  <td style="padding:0cm 0cm 0cm 0cm">
  <div class=MsoNormal align=center style="text-align:center"><span
  style="mso-fareast-font-family:Arial">
  <hr size=1 width="100%" noshade style="color:#606060" align=center>
  </span></div>
  </td>
 </tr>
</table>

</div>

<p class=MsoNormal><span style="font-family:Arial;mso-fareast-font-family:
Arial;color:#606060;display:none;mso-hide:all"><o:p>&nbsp;</o:p></span></p>

<div align=center>

<table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=700
 style="width:525.0pt;mso-cellspacing:0cm;background:white;mso-yfti-tbllook:
 1184;mso-padding-alt:15.0pt 15.0pt 15.0pt 15.0pt">
 <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
  <td style="padding:15.0pt 15.0pt 15.0pt 15.0pt">
  <p class=MsoNormal><b><span style="color:#606060;font-size:13.5pt;font-family:Arial,Arial,
            Helvetica,sans-serif;
  mso-fareast-font-family:Arial">Estimado(s) Sr(es) '.$Cliente.',</span></b><span
  style="font-size:13pt;font-family:Arial;mso-fareast-font-family:Arial">
  <o:p></o:p></span></p>
  </td>
 </tr>
</table>

</div>

<p class=MsoNormal><span style="font-family:Arial;mso-fareast-font-family:
Arial;color:#606060;display:none;mso-hide:all"><o:p>&nbsp;</o:p></span></p>

<div align=center>

<table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=700
 style="width:525.0pt;mso-cellspacing:0cm;background:white;mso-yfti-tbllook:
 1184;mso-padding-alt:15pt 15pt 15pt 15pt">
 <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
  <td style="padding:15pt 15pt 15pt 15pt">
  <p class=MsoNormal><span style="color:#606060;font-size:11pt;font-family:Arial,
            Helvetica,sans-serif;mso-fareast-font-family:
  Arial">Adjunto a la presente encontrarás el detalle del pago a
  realizar: <o:p></o:p></span></p><br><br>
  </td>
 </tr>
</table>

</div>

<p class=MsoNormal><span style="font-family:Arial;mso-fareast-font-family:
Arial;color:#606060;display:none;mso-hide:all"><o:p>&nbsp;</o:p></span></p>

<div align=center>

             <table cellspacing="0" border="1" align="center" bordercolor="#ddd" width=650 style="text-align: left; font-size: 12pt;">
                            <tr>
                                <th style="width: 30%;font-size:11pt;line-height:150%;font-family:Arial,
            Helvetica,sans-serif;text-align: center;background:#E20513;color:white">CÓDIGO DE
  CLIENTE</th>
                               <th style="width: 30%;font-size:11pt;line-height:150%;font-family:Arial,
            Helvetica,sans-serif;text-align: center;background:#E20513;color:white">N&#176; PROSPECTO</th>
                                <th style="width: 30%;font-size:11pt;line-height:150%;font-family:Arial,
            Helvetica,sans-serif;text-align: center;background:#E20513;color:white">MONTO</th>

                            </tr>
                            <tr>
                                        <td  style="width: 30%; text-align: center;font-size:12.0pt;line-height:150%;font-family:Arial,
            Helvetica,sans-serif;
            color:#606060">'.$NContrato.'</td>
                                        <td style="width: 30%; text-align: center;font-size:12.0pt;line-height:150%;font-family:Arial,
            Helvetica,sans-serif;
            color:#606060">'.$NProspecto.'</td>
                                        <td style="width: 30%; text-align: center;font-size:12.0pt;line-height:150%;font-family:Arial,
            Helvetica,sans-serif;
            color:#606060">S/ '.$MontoTotal.'</td>
                                      
                                    </tr>
             </table><br>

</div>
&nbsp;
<p class=MsoNormal><span style="font-family:Arial,
            Helvetica,sans-serif;mso-fareast-font-family:
Arial;color:#606060;display:none;mso-hide:all"><o:p>&nbsp;</o:p></span></p>

<div align=center>

<table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=700
 style="width:525.0pt;mso-cellspacing:0cm;background:white;mso-yfti-tbllook:
 1184;mso-padding-alt:15.0pt 15.0pt 15.0pt 15.0pt">
 <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
  <td style="padding:15.0pt 15.0pt 15.0pt 15.0pt">
  <p class=MsoNormal><span style="mso-fareast-font-family:Arial"><img
  width=700 id="_x0000_i1027"
  src="https://www.verismart.com.pe/verismart/img/email/linea1.png"><o:p></o:p></span></p>
  </td>
 </tr>
</table>

</div>

<p class=MsoNormal> <span style="font-family:Arial, Helvetica,sans-serif;mso-fareast-font-family: Arial;color:#606060;display:none;mso-hide:all"><o:p></o:p> </span></p>

<div align=center>

<table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=700
 style="width:500pt;mso-cellspacing:0cm;background:white;mso-yfti-tbllook:
 1184;mso-padding-alt:0cm 0cm 0cm 0cm">
 <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes">
  <td colspan=2 style="padding:0cm 0cm 0cm 0cm">
  <p class=MsoNormal align=center style="text-align:center"><span style="font-size:18pt;font-family:Arial,
            Helvetica,sans-serif;mso-fareast-font-family:Arial;color:#E30614;
  letter-spacing:-.4pt">Desde su computadora o celular <o:p></o:p></span></p><br><br>
  </td>
 </tr>
 <tr style="mso-yfti-irow:1">
  <td width=280 style="width:210.0pt;padding:0cm 0cm 0cm 0cm">
  <table class=MsoNormalTable border=0 cellpadding=0 align=right width=370
   style="width:277.5pt;mso-cellspacing:1.5pt;mso-yfti-tbllook:1184;mso-table-lspace:
   2.25pt;mso-table-rspace:2.25pt;mso-table-anchor-vertical:paragraph;
   mso-table-anchor-horizontal:column;mso-table-left:right;mso-table-top:middle;
   mso-padding-alt:3.75pt 3.75pt 3.75pt 3.75pt">
   <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
    <td style="padding:3.75pt 3.75pt 3.75pt 3.75pt">
    <p class=MsoNormal><span style="mso-fareast-font-family:Arial"><img
    width=300 id="_x0000_i1028"
    src="https://www.verismart.com.pe/verismart/img/email/plataformas_pago.png"><o:p></o:p></span></p>
    </td>
   </tr>
  </table>
  </td>
  <td style="padding:18.75pt 0cm 0cm 0cm">
  <div align=center>
  <table class=MsoNormalTable border=0 cellpadding=0 width=300
   style="width:225.0pt;mso-cellspacing:1.5pt;mso-yfti-tbllook:1184;mso-padding-alt:
   3.75pt 3.75pt 3.75pt 3.75pt">
   <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes">
    <td style="padding:2.75pt 3.75pt 3.75pt 3.75pt">
    <p class=MsoNormal><span style="mso-fareast-font-family:Arial"><img
    width=30 id="_x0000_i1030"
    src="https://www.verismart.com.pe/verismart/img/email/1.png"><o:p></o:p></span></p>
    </td>
    <td style="padding:2.75pt 3.75pt 3.75pt 3.75pt">
    <p class=MsoNormal><span style="color:#606060;font-family:Arial,
            Helvetica,sans-serif;mso-fareast-font-family:Arial">Acceda
    a la <b><span style="color:#E30614">web</span></b><o:p></o:p></span></p>
    </td>
   </tr>
   <tr style="mso-yfti-irow:1">
    <td style="padding:2.75pt 3.75pt 3.75pt 3.75pt">
    <p class=MsoNormal><span style="font-family:Arial,
            Helvetica,sans-serif;mso-fareast-font-family:Arial"><img
    width=30 id="_x0000_i1031"
    src="https://www.verismart.com.pe/verismart/img/email/2.png"><o:p></o:p></span></p>
    </td>
    <td style="padding:2.75pt 3.75pt 3.75pt 3.75pt">
    <p class=MsoNormal><span style="color:#606060;font-family:Arial,
            Helvetica,sans-serif;mso-fareast-font-family:Arial">Introduzca
    los <b><span style="color:#E30614">datos solicitados</span></b><span
    style="color:#E30614"> </span><o:p></o:p></span></p>
    </td>
   </tr>
   <tr style="mso-yfti-irow:2">
    <td style="padding:2.75pt 3.75pt 3.75pt 3.75pt">
    <p class=MsoNormal><span style="mso-fareast-font-family:Arial"><img
     width=30 id="_x0000_i1032"
    src="https://www.verismart.com.pe/verismart/img/email/3.png"><o:p></o:p></span></p>
    </td>
    <td style="padding:2.75pt 3.75pt 3.75pt 3.75pt">
    <p class=MsoNormal><span style="color:#606060;font-family:Arial,
            Helvetica,sans-serif;mso-fareast-font-family:Arial">Ingrese
    el <b><span style="color:#E30614">código de cliente</span></b><span
    style="color:#E30614"> </span><o:p></o:p></span></p>
    </td>
   </tr>
   <tr style="mso-yfti-irow:3">
    <td style="padding:2.75pt 3.75pt 3.75pt 3.75pt">
    <p class=MsoNormal><span style="mso-fareast-font-family:Arial"><img
     width=30 id="_x0000_i1033"
    src="https://www.verismart.com.pe/verismart/img/email/4.png"><o:p></o:p></span></p>
    </td>
    <td style="padding:2.75pt 3.75pt 3.75pt 3.75pt">
    <p class=MsoNormal><span style="color:#606060;font-family:Arial,
            Helvetica,sans-serif;mso-fareast-font-family:Arial">Coloque el
    monto a pagar<o:p></o:p></span></p>
    </td>
   </tr>
   <tr style="mso-yfti-irow:4">
    <td style="padding:2.75pt 3.75pt 3.75pt 3.75pt"></td>
    <td style="padding:2.75pt 3.75pt 3.75pt 3.75pt"></td>
   </tr>
  </table>
  </div>
  </td>
 </tr>
  <tr style="mso-yfti-irow:2;mso-yfti-lastrow:yes">
      <td colspan=2 style="padding:2.75pt 3.75pt 3.75pt 3.75pt">
          <br><br><br>
    <p class=MsoNormal align=center style="text-align:center"><span style="mso-fareast-font-family:Arial">
        <a
    href="'.$URL.'">
        <img
    width=290 id="_x0000_i1028"
    src="https://www.verismart.com.pe/verismart/img/email/btn_plataforma.png"></a><o:p></o:p></span></p>
    </td>
 </tr>

 <tr style="mso-yfti-irow:2;mso-yfti-lastrow:yes">
  <td colspan=2 style="padding:0cm 0cm 0cm 0cm">
  <p class=MsoNormal style="margin-bottom:12.0pt"><span style="color:#606060;font-size:8pt;font-family:Arial,
            Helvetica,sans-serif;
  mso-fareast-font-family:Arial;letter-spacing:0pt"><br><br>
  <br><br><br>
 <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=700
 style="width:525.0pt;mso-cellspacing:0.5cm;mso-yfti-tbllook:1184;mso-padding-alt:
 0cm 0cm 0cm 0cm">
 <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
  <td style="padding:0cm 0cm 0cm 0cm">
  <p class=MsoNormal align=left style="text-align:left;"><span
  style="font-size:9pt;color:#606060;font-family:Arial,
            Helvetica,sans-serif;mso-fareast-font-family:Arial"><b>Por seguridad, Verisure Perú te informa:</b><br><br>El sistema de
  VisaNet PAGO LINK cuenta con la certificación internacional PCI DSS, la cual asegura la protección, confidencialidad e integridad de los datos. Significa que cuando ingresan los datos de su tarjeta Visa en el formulario, lo está haciendo en un ambiente completamente seguro y encriptado. Ni la empresa ni Visanet nunca almacenan datos de las tarjetas.</span></p>
  </td>
 </tr>
</table>

</div>

<div align=center>

<table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=700
 style="width:525.0pt;mso-cellspacing:0cm;background:white;mso-yfti-tbllook:
 1184;mso-padding-alt:0cm 0cm 0cm 0cm">
 <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
  <td style="padding:0cm 0cm 0cm 0cm">
  <div class=MsoNormal align=center style="text-align:center"><span
  style="mso-fareast-font-family:Arial">
  <hr size=1 width="100%" noshade style="color:#606060" align=center>
  </span></div>
  </td>
 </tr>
</table>

</div>

<p class=MsoNormal><span style="font-family:Arial,
            Helvetica,sans-serif;mso-fareast-font-family:
Arial;color:#606060"><o:p>&nbsp;</o:p></span></p>

<div align=center>

<table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=700
 style="width:525.0pt;mso-cellspacing:0cm;mso-yfti-tbllook:1184;mso-padding-alt:
 0cm 0cm 0cm 0cm">
 <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
  <td style="padding:0cm 0cm 0cm 0cm">
  <p class=MsoNormal><span style="color:#606060;font-size:11pt;font-family:Arial,
            Helvetica,sans-serif;mso-fareast-font-family:
  Arial">CANAL CLIENTE | <b>SIEMPRE A SU SERVICIO</b> <o:p></o:p></span></p>
  </td>
 </tr>
</table>

</div>

<p class=MsoNormal style="margin-bottom:12.0pt"><span style="font-family:Arial,
            Helvetica,sans-serif;
mso-fareast-font-family:Arial;color:#606060"><br style="mso-special-character:
line-break">
<![if !supportLineBreakNewLine]><br style="mso-special-character:line-break">
<![endif]><o:p></o:p></span></p>

<div align=center>

<table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=700
 style="width:525.0pt;mso-cellspacing:0cm;mso-yfti-tbllook:1184;mso-padding-alt:
 0cm 0cm 0cm 0cm">
 <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
  <td width=250 style="width:187.5pt;padding:0cm 0cm 0cm 0cm">
  <p class=MsoNormal align=center style="text-align:center"><span
  style="font-size:12pt;font-family:Arial,
            Helvetica,sans-serif;color:#606060;mso-fareast-font-family:Arial"><img
  border=0 width=50 id="_x0000_i1035"
  src="https://www.verismart.com.pe/verismart/img/email/telefono_rojo.png"><br>
  Llámanos a <br>
  <b>0 800 2 12 12</b> <o:p></o:p></span></p>
  </td>
  <td width=250 style="width:187.5pt;padding:0cm 0cm 0cm 0cm">
  <p class=MsoNormal align=center style="text-align:center"><span
  style="font-family:Arial,
            Helvetica,sans-serif;font-size:12pt;mso-fareast-font-family:Arial"><a
  href="mailto:clientes@verisure.pe" style="color:#606060;text-decoration:
  none;text-underline:none"><span><img border=0 width=50 id="_x0000_i1036"
  src="https://www.verismart.com.pe/verismart/img/email/correo_rojo.png"><br>
  Escríbenos a <br>
  <b>clientes@verisure.pe</b> </span></a><o:p></o:p></span></p>
  </td>
 </tr>
</table>

</div>

<p class=MsoNormal style="margin-bottom:12.0pt"><span style="font-family:Arial;
mso-fareast-font-family:Arial;color:#606060"><br style="mso-special-character:
line-break">
<![if !supportLineBreakNewLine]><br style="mso-special-character:line-break">
<![endif]><o:p></o:p></span></p>

<div align=center>

<table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=700
 style="width:525.0pt;mso-cellspacing:0cm;mso-yfti-tbllook:1184;mso-padding-alt:
 0cm 0cm 0cm 0cm">
 <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
  <td style="padding:0cm 0cm 0cm 0cm">
  <p class=MsoNormal align=center style="text-align:left;"><span
  style="font-size:9pt;color:#606060;font-family:Arial,
            Helvetica,sans-serif;mso-fareast-font-family:Arial">(*)
  Estudio de mercado realizado por la empresa Directo Marketing en el mes de
  Septiembre del 2016 a 700 usuarios de sistema de alarma en 14 distritos de
  Lima Metropolitana (Margen de error +/- 3.7%). <o:p></o:p></span></p>
  </td>
 </tr>
</table>

</div>

<p class=MsoNormal><span style="font-family:Arial,
            Helvetica,sans-serif;mso-fareast-font-family:Arial"><o:p>&nbsp;</o:p></span></p>

</div>

</body>

</html>
';

//para el envío en formato HTML 
    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/html; charset=utf-8\r\n";

//dirección del remitente 
    $headers .= "From: Sistema de Pago - Verisure Perú <canaldepago@verismart.com.pe>\r\n";

//dirección de respuesta, si queremos que sea distinta que la del remitente 
    $headers .= "Reply-To: canaldepago@verisure.pe\r\n";

//ruta del mensaje desde origen a destino 
    $headers .= "Return-path: canaldepago@verismart.com.pe\r\n";

//direcciones que recibián copia 
    //$headers .= "Cc: joecnan14@gmail.com\r\n";

//direcciones que recibirán copia oculta 
if($CCBilling=="512" || $CCBilling=="511" ){
   $headers .= "Bcc: mediosdepago@verisure.pe,telecierre@verisure.pe\r\n";
}else{
   $headers .= "Bcc: mediosdepago@verisure.pe\r\n";  
}
   


mail($para, $titulo, $mensaje, $headers);
         
         //FIn de envo de correo
         
      $respuesta=array(
        "URL"=>'',
        "resultado"=>4,
        "mostrar"=>'<div class="callout callout-success">
                    <h4><i class="fa fa-bullhorn"></i> ¡IMPORTANTE!</h4>
               <strong>Se ha enviado la URL al correo '.$correo.' .</strong><br>
                <p>&nbsp;</p>
                   </div>'
    );
    
    
     }

$REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
$usuariosesion=$_SESSION['usuariosesion'];
$REQUEST_URI=$_SERVER['REQUEST_URI'].'=>IdTransaccion='.$idTransaccion;
$Acceso='Registrar';
$HTTP_USER_AGENT=$_SERVER['HTTP_USER_AGENT'];

try {
        
  $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
  $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
  $stmt->execute();
  $idLogSeg = $con->insert_id;
  insertLogTransaccionI($idLogSeg, $arrayTransaccion);
  
  $stmt->close();
  
} catch (\Exception $e) {
  echo $e->getMessage();
}

            }else{
                
                                $respuesta=array(
        "URL"=>'',
        "resultado"=>6,
                "mostrar"=>'<div class="callout callout-warning">
                    <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
               <strong>Lo sentimos, pero la URL alcanzo su máximo de transacciones</strong><br>
<p>Comunicarse con mediosdepago@verisure.pe <br><i class="fa fa-phone"></i>&nbsp 514 7315 (Opción 2)</p>
                    </div>'
    ); 
            }
            
        }else{
            
                $respuesta=array(
        "URL"=>'',
        "resultado"=>3,
                "mostrar"=>'<div class="callout callout-warning">
                    <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
               <strong>Lo sentimos, pero la URL se encuentra vencida.</strong><br>
<p>Comunicarse con mediosdepago@verisure.pe <br><i class="fa fa-phone"></i>&nbsp 514 7315 (Opción 2)</p>
                    </div>'
    ); 
            
        }
    
    }else{
    $respuesta=array(
        "URL"=>'',
        "resultado"=>3,
                "mostrar"=>'<div class="callout callout-warning">
                    <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
               <strong>Lo sentimos, pero la URL se encuentra vencida.</strong><br>
<p>Comunicarse con mediosdepago@verisure.pe <br><i class="fa fa-phone"></i>&nbsp 514 7315 (Opción 2)</p>
                    </div>'
    ); 
    
    }
    
}

    $json_string = json_encode($respuesta); 
    echo $json_string; 

